// * File:     VGE\uMain.pas
// * Created:  2005-12-06
// * Modified: 2009-11-17
// * Version:  1.0.46.15
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	uTypes, uDForm, uCalc,
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	uDImage, ExtCtrls, uDWinControl;

type
	TfMain = class(TDForm)
		Image: TDImage;
		procedure ImageFill(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure ImageMouseMove(Sender: TObject; Shift: TShiftState; X,
			Y: Integer);
		procedure FormKeyDown(Sender: TObject; var Key: Word;
			Shift: TShiftState);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure ImageMouseDown(Sender: TObject; Button: TMouseButton;
			Shift: TShiftState; X, Y: Integer);
	private
		{ Private declarations }
		MousePt: TXYPt;
		GN1,GN2: TXYPt;
		procedure RWOptions(const Save: BG);
		procedure Draw;
	public
		{ Public declarations }
	end;

var
	fMain: TfMain;

implementation

{$R *.dfm}
uses
	Types, Math,
	uFiles, uDIniFile, uDBitmap, uMath, uDrawStyle, uColor;

var
	Polygon: TXYPtDynArray;
	InnerPolygons: TXYPtDynArray2D;

	LabelPt: TXYPt;
	RectSize: TXYPt;

const
	DataFileName = 'Data.ini';

var
	Zoom: Double = 4;
	Offset: TPoint;
	ActualPt: PXYPt;
	SelectedPt: PXYPt;
	LastPt: TXYPt;

// TODO 1 -cSpecification -oSafrad: sign
function LToS(const PT: TXYPt): TXYPt;
begin
	Result.X := Zoom * PT.X - Offset.X;
	Result.Y := Zoom * PT.Y - Offset.Y;
end;

// TODO 1 -cSpecification -oSafrad: sign
function LToS2(const PT: TXYPt): TPoint;
begin
	Result.X := Round(Zoom * PT.X) - Offset.X;
	Result.Y := Round(Zoom * PT.Y) - Offset.Y;
end;

// TODO 1 -cSpecification -oSafrad: sign
function SToL(const Pt: TPoint): TXYPt;
begin
	Result.X := +(Pt.X + Offset.X) / Zoom;
	Result.Y := +(Pt.Y + Offset.Y) / Zoom;
end;

procedure RWPoint(const IniFile: TDIniFile; const Save: BG; const Section, Id: string; var P: TXYPt);
begin
	IniFile.RWNum(Section, Id + '.X', P.X, Save);
	IniFile.RWNum(Section, Id + '.Y', P.Y, Save);
end;

procedure RWPolygon(const IniFile: TDIniFile; const Save: BG; const Section: string; var Polygon: TXYPtDynArray);
var
	i: SG;
	Count: SG;
begin
	if Save then
		Count := Length(Polygon)
	else
		// Default values
		Count := 0;
	IniFile.RWNum(Section, 'Count', Count, Save);
	if Save = False then
		SetLength(Polygon, Count);
	for i := 0 to Count - 1 do
	begin
		if Save = False then
		begin
			// Default values
			Polygon[i].X := 0;
			Polygon[i].Y := 0;
		end;
		RWPoint(IniFile, Save, Section, 'P' + IntToStr(i), Polygon[i]);
	end;
end;

procedure RWPolygons(const Save: Boolean);
const
	Section = 'Options';
var
	IniFile: TDIniFile;
	PolygonCount: SG;
	i: SG;
begin
	IniFile := TDIniFile.Create(AppDataDir + DataFileName);
	try
		if Save = False then
		begin
			// Default values
			RectSize.X := 20;
			RectSize.Y := 10;
			PolygonCount := 0;
		end;
		RWPoint(IniFile, Save, Section, 'RectSize', RectSize);

		if Save then
			PolygonCount := 1 + Length(InnerPolygons);
		IniFile.RWNum(Section, 'PolygonCount', PolygonCount, Save);
		if PolygonCount = 0 then Exit;
		RWPolygon(IniFile, Save, 'Polygon' + IntToStr(0), Polygon);

		if Save = False then
			SetLength(InnerPolygons, PolygonCount - 1);
		for i := 0 to PolygonCount - 2 do
		begin
			RWPolygon(IniFile, Save, 'Polygon' + IntToStr(i + 1), InnerPolygons[i]);
		end;
	finally
		IniFile.Free;
	end;
end;

{ TfMain }

procedure TfMain.RWOptions(const Save: BG);
const
	Section = 'Options';
begin
	MainIni.RWFormPos(Self, Save);
	MainIni.RWNum(Section, 'Zoom', Zoom, Save);
	MainIni.RWPoint(Section, 'Offset', Offset, Save);
	RWPolygons(Save);
end;

procedure TfMain.FormCreate(Sender: TObject);
var
	i: SG;
	Pt: TPoint;
begin
	Background := baNone;
	if not FileExists(AppDataDir + DataFileName) then
		CopyFile(DataDir + DataFileName, AppDataDir + DataFileName, True);
	RWOptions(False);

	for i := 0 to Length(Polygon) - 1 do
	begin
		Pt := LToS2(Polygon[i]);
		if Pt.X < Offset.X then
		begin
			Offset.X := Pt.X;
		end;
		if Pt.X < Offset.Y then
		begin
			Offset.Y := Pt.Y;
		end;
	end;

	Draw;
end;

procedure DrawPolygon(const P: TXYPtDynArray; const Color: TColor; Bmp: TDBitmap);
const
	RectSize = 2;
	RectSize2 = 3;
var
	i: SG;
	SP, EP: TXYPt;
begin
	if Length(P) <= 0 then Exit;

	for i := 0 to Length(P) - 2 do
	begin
		SP := LToS(P[i]);
		EP := LToS(P[i + 1]);
		Bmp.Line(SP.X, SP.Y, EP.X, EP.Y, Color, ef16, 2);
	end;
	SP := LToS(P[0]);
	Bmp.Line(SP.X, SP.Y, EP.X, EP.Y, Color, ef16, 2);

	for i := 0 to Length(P) - 1 do
	begin
		SP := LToS(P[i]);
		Bmp.Rec(SP.X - RectSize, SP.Y - RectSize, SP.X + RectSize, SP.Y + RectSize, Color, ef12);
		if @P[i] = SelectedPt then
		begin
			Bmp.Rec(SP.X - RectSize2, SP.Y - RectSize2, SP.X + RectSize2, SP.Y + RectSize2, Color, ef12)
		end;
	end;
end;

function OffsetPoint(const Pt: TXYPt; const OffsetX, OffsetY: Double): TXYPt;
begin
	Result.X := Pt.X + OffsetX;
	Result.Y := Pt.Y + OffsetY;
end;

procedure TfMain.ImageFill(Sender: TObject);
const
	Step = 8;
var
	Bmp: TDBitmap;
	i: SG;
	SP1, SP2: TXYPt;
//	BestPt: TXYPt;
	x, y: SG;
	C: TRGBA;
	P: TPoint;
	Pt: TXYPt;
begin
	Bmp := Image.Bitmap;

	Bmp.Bar(clBlack, ef16);

{	for y := 0 to Bmp.Height div Step - 1 do
	for x := 0 to Bmp.Width div Step - 1 do
	begin
		P.X := x * Step;
		P.Y := y * Step;
		Pt := SToL(P);
		if LinePolygonDistance(Pt, Pt, Polygon) > 57 then
		begin
			C.L := clLime;
			Pix(Bmp.Data, Bmp.ByteX, x * Step, y * Step, @C, ef16);
		end;
	end;}

	for i := 0 to Length(InnerPolygons) - 1 do
	begin
		DrawPolygon(InnerPolygons[i], clSilver, Bmp);
	end;

	DrawPolygon(Polygon, clWhite, Bmp);

(*	BestPt := PolygonMiddle(Polygon);
	Bmp.Cross(LToSX(BestPt.X), LToSY(BestPt.Y), Zoom, clWhite, ef16); *)

	SP1 := LToS(OffsetPoint(LabelPt, -RectSize.X / 2, -RectSize.Y / 2));
	SP2 := LToS(OffsetPoint(LabelPt, +RectSize.X / 2, +RectSize.Y / 2));
	Bmp.Rec(SP1.X, SP1.Y, SP2.X, SP2.Y, clYellow, ef16);

{	SP1 := LToS(GN1);
	SP2 := LToS(GN2);
	Bmp.Line(SP1.X, SP1.Y, SP2.X, SP2.Y, clGreen, ef16, 2);}

	Bmp.Canvas.TextOut(0, 0, FloatToStr(GBestDistance));
end;

procedure TfMain.Draw;
begin
	GetRectangleInPolygon(RectSize, Polygon, InnerPolygons, LabelPt, 0.01);
	Image.Repaint;
end;

procedure FindPoint(const Pt: TXYPt; const Polygon: TXYPtDynArray; var BestPt: PXYPt; var MinDistance: Double);
var
	i: SG;
	Distance: Double;
begin
	for i := 0 to Length(Polygon) - 1 do
	begin
		Distance := GetSquaredDistance(Pt, Polygon[i]);
		if Distance < MinDistance then
		begin
			BestPt := @Polygon[i];
			MinDistance := Distance;
		end;
	end;
end;

procedure TfMain.ImageMouseMove(Sender: TObject; Shift: TShiftState; X,
	Y: Integer);
var
	MinDistance: Double;
	i: SG;
	LastSelectedPt: PXYPt;
	SP: TPoint;
begin
	SP.X := X;
	SP.Y := Y;
	MousePt := SToL(SP);
	{$ifopt d+}
	Caption := FloatToStr(LinePolygonDistance(MousePt, MousePt, Polygon)) + ' - ' +
		FloatToStr(PointVectorDistance(MousePt, Polygon[4], Polygon[0])) + ' ';
	GN1 := N1;
	GN2 := N2;
	{$endif}

	if Image.MouseL then
	begin
		if ActualPt <> nil then
		begin
			ActualPt^ := MousePt;
		end;
		Draw;
	end
	else
	begin
		MinDistance := Infinity;
		LastSelectedPt := SelectedPt;
		SelectedPt := nil;
		FindPoint(MousePt, Polygon, SelectedPt, MinDistance);
		for i := 0 to Length(InnerPolygons) - 1 do
		begin
			FindPoint(MousePt, InnerPolygons[i], SelectedPt, MinDistance);
		end;

		if SelectedPt <> LastSelectedPt then
		begin
			Draw;
		end;
	end;
end;

procedure TfMain.FormKeyDown(Sender: TObject; var Key: Word;
	Shift: TShiftState);
const
	Step = 32;
begin
	case Key of
	VK_ADD:
	begin
		Zoom := Zoom * 2;
		Draw;
	end;
	VK_SUBTRACT:
	begin
		if Zoom > 0.01 then
		begin
			Zoom := Zoom / 2;
			Draw;
		end;
	end;
	VK_LEFT:
	begin
		Dec(Offset.X, Step);
		Draw;
	end;
	VK_RIGHT:
	begin
		Inc(Offset.X, Step);
		Draw;
	end;
	VK_UP:
	begin
		Dec(Offset.Y, Step);
		Draw;
	end;
	VK_DOWN:
	begin
		Inc(Offset.Y, Step);
		Draw;
	end;
	VK_RETURN:
	begin
		if (ssAlt in Shift) then
			FullScreen := not FullScreen;
	end;
	VK_ESCAPE:
	begin
		if ActualPt <> nil then
		begin
			ActualPt^ := LastPt;
			ActualPt := nil;
			Draw;
		end;
	end;
	end;
end;

procedure TfMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	RWOptions(True);
end;

procedure TfMain.ImageMouseDown(Sender: TObject; Button: TMouseButton;
	Shift: TShiftState; X, Y: Integer);
var
	Pt: TXYPt;
	i: SG;
	MinDistance: Double;
	SP: TPoint;
begin
	SP.X := X;
	SP.Y := Y;
	Pt := SToL(SP);
	MinDistance := Infinity;
	ActualPt := nil;
	FindPoint(Pt, Polygon, ActualPt, MinDistance);
	for i := 0 to Length(InnerPolygons) - 1 do
	begin
		FindPoint(Pt, InnerPolygons[i], ActualPt, MinDistance);
	end;
	if ActualPt <> nil then
		LastPt := ActualPt^;
end;

end.
