// * File:     VGE\uCalc.pas
// * Created:  2009-02-22
// * Modified: 2009-11-17
// * Version:  1.0.46.15
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uCalc;

interface

type
	PXYPt = ^TXYPt;
	TXYPt = record
		X, Y: Double;
	end;
	TXYPtDynArray = array of TXYPt;
	TXYPtDynArray2D = array of TXYPtDynArray;

	TRectVertex = (rvLT, rvRT, rvRB, rvLB);

function GetSquaredDistance(const A, B: TXYPt): Double;
function PointVectorDistance(const P, F0, T0: TXYPt): Double;
function LinePolygonDistance(const F0, T0: TXYPt; const Polygon: TXYPtDynArray): Double;

procedure GetRectangleInPolygon(const Size: TXYPt; const Polygon:
		TXYPtDynArray; const InnerPolygons: TXYPtDynArray2D; out BestPt: TXYPt;
		Precision: Double);

var
	GBestDistance: Double;
	status: string;
	N1, N2: TXYPt;

implementation

uses
	Math;

function Oriented(const Pt: TXYPt; const Size: TXYPt; const Orientation: TRectVertex; const Precision: Double): TXYPt;
begin
	case Orientation of
	rvLT:
	begin
		Result.X := Pt.X + Size.X / 2 + Precision;
		Result.Y := Pt.Y + Size.Y / 2 + Precision;
	end;
	rvRT:
	begin
		Result.X := Pt.X - Size.X / 2 - Precision;
		Result.Y := Pt.Y + Size.Y / 2 + Precision;
	end;
	rvRB:
	begin
		Result.X := Pt.X - Size.X / 2 - Precision;
		Result.Y := Pt.Y - Size.Y / 2 - Precision;
	end;
	rvLB:
	begin
		Result.X := Pt.X + Size.X / 2 + Precision;
		Result.Y := Pt.Y - Size.Y / 2 - Precision;
	end;
	end;
end;

function OrientedEx(const Pt: TXYPt; const Size: TXYPt; const Orientation: TRectVertex): TXYPt;
begin
	case Orientation of
	rvLT:
	begin
		Result.X := Pt.X - Size.X / 2;
		Result.Y := Pt.Y - Size.Y / 2;
	end;
	rvRT:
	begin
		Result.X := Pt.X + Size.X / 2;
		Result.Y := Pt.Y - Size.Y / 2;
	end;
	rvRB:
	begin
		Result.X := Pt.X + Size.X / 2;
		Result.Y := Pt.Y + Size.Y / 2;
	end;
	rvLB:
	begin
		Result.X := Pt.X - Size.X / 2;
		Result.Y := Pt.Y + Size.Y / 2;
	end;
	end;
end;

function PtInPolygon(const Polygon: TXYPtDynArray; const X, Y: Double): Boolean;
var
	i, j: Integer;
begin
	Result := False;
	j := Length(Polygon) - 1;
	for i := 0 to Length(Polygon) - 1 do
	begin
		if ((Polygon[i].Y <= Y) and (Y < Polygon[j].Y)) or
				((Polygon[j].Y <= Y) and (Y < Polygon[i].Y)) then
		begin
			if (x < (Polygon[j].X - Polygon[i].X) *	(y - Polygon[i].Y) / (Polygon[j].Y - Polygon[i].Y) + Polygon[i].X) then
			begin
				Result := not Result;
			end;
		end;
		j := i;
	end;
end;

function Subtract(AVec1, AVec2 : TXYPt) : TXYPt;
begin
	Result.X := AVec1.X - AVec2.X;
	Result.Y := AVec1.Y - AVec2.Y;
end;

(**
	Determine if 2 line cross given their end-points.
*)
function LinesCross(LineAP1, LineAP2, LineBP1, LineBP2 : TXYPt): Boolean;
Var
	diffLA, diffLB : TXYPt;
	CompareA, CompareB: Double;
begin
	Result := False;

	diffLA := Subtract(LineAP2, LineAP1);
	diffLB := Subtract(LineBP2, LineBP1);

	CompareA := diffLA.X*LineAP1.Y - diffLA.Y*LineAP1.X;
	CompareB := diffLB.X*LineBP1.Y - diffLB.Y*LineBP1.X;

	if ( ((diffLA.X*LineBP1.Y - diffLA.Y*LineBP1.X) < CompareA) xor
			((diffLA.X*LineBP2.Y - diffLA.Y*LineBP2.X) < CompareA) ) and
			( ((diffLB.X*LineAP1.Y - diffLB.Y*LineAP1.X) < CompareB) xor
			((diffLB.X*LineAP2.Y - diffLB.Y*LineAP2.X) < CompareB) ) then
		Result := True;
end;

(**
	Find the intersection of 2 lines.
*)
function LineIntersect(LineAP1, LineAP2, LineBP1, LineBP2 : TXYPt): TXYPt;
var
	LDetLineA, LDetLineB, LDetDivInv : Double;
	LDiffLA, LDiffLB : TXYPt;
begin
	LDetLineA := LineAP1.X*LineAP2.Y - LineAP1.Y*LineAP2.X;
	LDetLineB := LineBP1.X*LineBP2.Y - LineBP1.Y*LineBP2.X;

	LDiffLA := Subtract(LineAP1, LineAP2);
	LDiffLB := Subtract(LineBP1, LineBP2);

	LDetDivInv := 1 / ((LDiffLA.X*LDiffLB.Y) - (LDiffLA.Y*LDiffLB.X));

	Result.X := ((LDetLineA*LDiffLB.X) - (LDiffLA.X*LDetLineB)) * LDetDivInv;
	Result.Y := ((LDetLineA*LDiffLB.Y) - (LDiffLA.Y*LDetLineB)) * LDetDivInv;
end;

function Intersection(const F0, T0, F1, T1: TXYPt; out V: TXYPt): Boolean;
begin
	Result := LinesCross(F0, T0, F1, T1);
end;

function PointLineDistance(const P, F0, T0: TXYPt): Double;
var D: Double;
begin
	D := GetSquaredDistance(T0, F0);
	if D = 0 then
		Result := GetSquaredDistance(P, F0)
	else
		Result := Abs((T0.X - F0.X) * (F0.Y - P.Y) - (F0.X - P.X) * (T0.Y - F0.Y)) / Sqrt(D);
end;

function PointVectorDistance(const P, F0, T0: TXYPt): Double;
const
	c = 100;
var
	D: Double;
begin
	N1.X := P.X + c * (F0.Y - T0.Y);
	N1.Y := P.Y - c * (F0.X - T0.X);
	N2.X := P.X - c * (F0.Y - T0.Y);
	N2.Y := P.Y + c * (F0.X - T0.X);
	// TODO
	if not LinesCross(F0, T0, N1, N2) then
	begin
(*	if Half(P, F0, Norm) then
		Result := GetSquaredDistance(P, F0);
	else if then
		Result := GetSquaredDistance(P, T0); *)
		Result := Sqrt(Min(GetSquaredDistance(P, F0), GetSquaredDistance(P, T0)));
//		status := 'lc';
	end
	else
	begin
		D := GetSquaredDistance(T0, F0);
		if D = 0 then
			Result := GetSquaredDistance(P, F0)
		else
			Result := Abs((T0.X - F0.X) * (F0.Y - P.Y) - (F0.X - P.X) * (T0.Y - F0.Y)) / Sqrt(D);
//		status := '0';
	end;
end;

function LineDistance(const F0, T0, F1, T1: TXYPt): Double;
begin
	Result :=
		Min(
			Min(PointVectorDistance(F0, F1, T1), PointVectorDistance(T0, F1, T1)),
			Min(PointVectorDistance(F1, F0, T0), PointVectorDistance(T1, F0, T0)));
end;

(**
	return true if part of rectangle is inside polygon
*)
function Overlap(const Polygon: TXYPtDynArray; const LabelPt: TXYPt; const Size: TXYPt): Boolean;
var
	P: array[TRectVertex] of TXYPt;
	V: TXYPt;
	rv: TRectVertex;
	i, j: Integer;
begin
	Result := False;
	if Length(Polygon) <= 1 then Exit;
	for rv := Low(rv) to High(rv) do
	begin
		P[rv] := OrientedEx(LabelPt, Size, rv);
	end;
	for i := 0 to Length(Polygon) - 1 do
	begin
		j := i + 1;
		if j >= Length(Polygon) then
			j := 0;
		if Intersection(Polygon[i], Polygon[j], P[rvLT], P[rvRT], V) or
			Intersection(Polygon[i], Polygon[j], P[rvRT], P[rvRB], V) or
			Intersection(Polygon[i], Polygon[j], P[rvRB], P[rvLB], V) or
			Intersection(Polygon[i], Polygon[j], P[rvLB], P[rvLT], V) then
		begin
			Result := True;
			Break;
		end;
	end;

	if Result = False then
	begin
		Result :=
			// Check if whole polygon is inside rectangle.
			((Polygon[0].X >= P[rvLT].X) and (Polygon[0].X <= P[rvRB].X) and
			(Polygon[0].Y >= P[rvLT].Y) and (Polygon[0].Y <= P[rvRB].Y)) or
			// Check if whole rectangle is inside polygon.
			(PtInPolygon(Polygon, LabelPt.X, LabelPt.Y));
	end;
end;

(**
	return true if position is ok
*)
function CorrectPosition(const Size: TXYPt; const Polygon:
		TXYPtDynArray; const InnerPolygons: TXYPtDynArray2D; const LabelPt: TXYPt;
		Precision: Double): Boolean;
var
	i: Integer;
	InnerPolygon: TXYPtDynArray;
begin
	if not PtInPolygon(Polygon, LabelPt.X, LabelPt.Y) then
	begin
		Result := False;
		Exit;
	end;
(*	if Overlap(Polygon, LabelPt, Size) then
	begin
		Result := False;
		Exit;
	end; *)
	for i := 0 to Length(InnerPolygons) - 1 do
	begin
		InnerPolygon := InnerPolygons[i];
		if Overlap(InnerPolygon, LabelPt, Size) then
		begin
			Result := False;
			Exit;
		end;
	end;
	Result := True;
end;

(*
function PolygonSize(const Polygon: TXYPtDynArray): Double;
var
	x1, y1, x2, y2: Double;
	i: Integer;
begin
	Result := 0;
	x1 := Polygon[0].X;
	y1 := Polygon[0].Y;
	i := 0;
	while (i <= Length(Polygon)) do
	begin
		if i >= Length(Polygon) then
		begin
			x2 := Polygon[0].X;
			y2 := Polygon[0].Y;
		end
		else
		begin
			x2 := Polygon[i].X;
			y2 := Polygon[i].Y;
		end;

		Result := Result + (x2 - x1) * (y2 + y1);
		x1 := x2;
		y1 := y2;
		Inc(i);
	end;
	Result := Abs(Result) / 2;
end;
*)

(*
function PolygonMiddle(const Polygon: TXYPtDynArray): TXYPt;
var
	i: Integer;
	PolygonLength: Integer;
begin
	PolygonLength := Length(Polygon);
	Result.X := 0;
	Result.Y := 0;
	if PolygonLength > 0 then
	begin
		for i := 0 to PolygonLength - 1 do
		begin
			Result.X := Result.X + Polygon[i].X;
			Result.Y := Result.Y + Polygon[i].Y;
		end;
		Result.X := Result.X / PolygonLength;
		Result.Y := Result.Y / PolygonLength;
	end;
end;
*)
(*
	return squared distance between A and B
*)
function GetSquaredDistance(const A, B: TXYPt): Double;
begin
	Result := Sqr(A.X - B.X) + Sqr(A.Y - B.Y);
end;

function LinePolygonDistance(const F0, T0: TXYPt; const Polygon: TXYPtDynArray): Double;
var i: Integer;
begin
	Result := Infinity;
	if Length(Polygon) = 0 then Exit;
	for i := 0 to Length(Polygon) - 2 do
	begin
		Result := Min(Result, LineDistance(F0, T0, Polygon[i], Polygon[i + 1]));
	end;
	Result := Min(Result, LineDistance(F0, T0, Polygon[Length(Polygon) - 1], Polygon[0]));
end;

procedure GetRectangleInPolygon(const Size: TXYPt; const Polygon:
		TXYPtDynArray; const InnerPolygons: TXYPtDynArray2D; out BestPt: TXYPt;
		Precision: Double);

(*	procedure CheckPos(const NowPt: TXYPt; const Orientation: TRectVertex);
	var
		Score: Double;
		Pt: TXYPt;
	begin
		Pt := Oriented(NowPt, Size, Orientation, Precision);
		if CorrectPosition(Size, Polygon, InnerPolygons, Pt, Precision) then
		begin
			Score := -GetDistance(Pt, OptimalPt);
			if Score > BestScore then
			begin
				BestPt := Pt;
				BestScore := Score;
			end;
		end;
	end; *)

	function DistanceFromPolygons(const F0, T0: TXYPt): Double;
	var i: Integer;
	begin
//		Result := Infinity;
		Result := LinePolygonDistance(F0, T0, Polygon);
		for i := 0 to Length(InnerPolygons) - 1 do
		begin
			Result := Min(Result, LinePolygonDistance(F0, T0, InnerPolygons[i]));
		end;
	end;

	function ShortestDistance(const LT, RB: TXYPt): Double;
	var
		LB, RT: TXYPt;
	begin
		LB.X := LT.X;
		LB.Y := RB.Y;
		RT.X := RB.X;
		RT.Y := LT.Y;
		Result :=
			Min(
				Min(DistanceFromPolygons(LT, RT), DistanceFromPolygons(LB, RB)),
				Min(DistanceFromPolygons(LT, LB), DistanceFromPolygons(RT, RB)));
	end;

(*	procedure CheckPos(const NowPt: TXYPt; const Orientation: TRectVertex);
	var
		Score: Double;
		Pt: TXYPt;
	begin
		Pt := Oriented(NowPt, Size, Orientation, Precision);
		if CorrectPosition(Size, Polygon, InnerPolygons, Pt, Precision) then
		begin
			Score := -ShortestDistance(Pt, Oriented(Pt, Size, rvLB, Precision));
			if Score > BestScore then
			begin
				BestPt := Pt;
				BestScore := Score;
			end;
		end;
	end; *)

	function GetOrientation(const F, T: TXYPt): TRectVertex;
	begin
		if T.X <= F.X then
		begin
			if T.Y > F.Y then
				Result := rvLT
			else
				Result := rvRT;
		end
		else
		begin
			if T.Y >= F.Y then
				Result := rvLB
			else
				Result := rvRB;
		end;
	end;

(*	procedure CheckEdge(const F, T: TXYPt);
	var
		NowPt: TXYPt;
		m, n: Double;
		Orientation: TRectVertex;
	begin
		m := 0;
		Orientation := GetOrientation(F, T);
		while m <= 1 do
		begin
			n := 1 - m;
			NowPt.X := m * F.X + n * T.X;
			NowPt.Y := m * F.Y + n * T.Y;
			CheckPos(NowPt, Orientation);
			m := m + Precision;
		end;
	end; *)

(*	procedure CheckPolygon(const InnerPolygon: TXYPtDynArray);
	var i: Integer;
	begin
		if Length(InnerPolygon) > 1 then
		begin
			for i := 0 to Length(InnerPolygon) - 2 do
			begin
				CheckEdge(InnerPolygon[i], InnerPolygon[i + 1]);
			end;
			CheckEdge(InnerPolygon[Length(InnerPolygon) - 1], InnerPolygon[0]);
		end;
	end; *)

	type
		TDirection = (diNone, diLeft, diRight, diTop, diBottom);

	function GetDirect(const Pt: TXYPt; const Delta: Double; const Direction: TDirection): TXYPt;
	begin
		case Direction of
		diNone: Result := Pt;
		diLeft:
		begin
			Result.X := Pt.X - Delta;
			Result.Y:= Pt.Y;
		end;
		diRight:
		begin
			Result.X := Pt.X + Delta;
			Result.Y:= Pt.Y;
		end;
		diTop:
		begin
			Result.X := Pt.X;
			Result.Y:= Pt.Y - Delta;
		end;
		diBottom:
		begin
			Result.X := Pt.X;
			Result.Y:= Pt.Y + Delta;
		end;
		end;
	end;

	procedure TryMove(const StartPt: TXYPt);
	const
		Delta = 2; // Bigger is faster
	var
		NowPt, LBestPt: TXYPt;
		Distance: Double;
		BestDistance: Double;
		Direction: TDirection;
		BestDirection: TDirection;
		ZeroP, BestPt2: TXYPt;
	begin
		ZeroP.X := Precision;
		ZeroP.Y := Precision;
		NowPt := StartPt;
		LBestPt := StartPt;
		BestPt2 := StartPt;
		BestDistance := -1000; //ShortestDistance(NowPt, Oriented(NowPt, Size, rvLB, Precision));
		while True do
		begin
			BestDirection := diNone;
			for Direction := Low(Direction) to High(Direction) do
			begin
				NowPt := GetDirect(LBestPt, Delta, Direction);
				Distance := DistanceFromPolygons(NowPt, NowPt);
				//ShortestDistance(OrientedEx(NowPt, Size, rvLT), OrientedEx(NowPt, Size, rvRB));
				if not CorrectPosition(Size, Polygon, InnerPolygons, NowPt, Precision) then
					Distance := -Distance;
				if Distance > BestDistance then
				begin
					BestPt2 := NowPt;
					BestDirection := Direction;
					BestDistance := Distance;
				end;
			end;
			LBestPt := BestPt2;
			if BestDistance > GBestDistance then
			begin
				BestPt := LBestPt;
				GBestDistance := BestDistance;
			end;
			if BestDirection = diNone then
			begin
				Break;
			end;
		end;
	end;

	procedure CheckVertex(const V, F, T: TXYPt);
	var
		NowPt: TXYPt;
		ZeroP: TXYPt;
	begin
//		m := 0;
//		Orientation := GetOrientation(F, T);
//			NowPt.X := m * F.X + n * T.X;
//			NowPt.Y := m * F.Y + n * T.Y;
		ZeroP.X := 0;
		ZeroP.Y := 0;
		NowPt := Oriented(V, Size, GetOrientation(F, T), Precision);
		TryMove(NowPt);
(*		while True do
		begin
			BestDistance := ShortestDistance(NowPt, Oriented(NowPt, Size, rvLB, Precision));
			BestOrientation := TRectVertex(-1);
			for Orientation := Low(Orientation) to High(Orientation) do
			begin
				Distance := ShortestDistance(NowPt, Oriented(NowPt, Size, rvLB, Precision));
				if Distance > BestDistance then
				begin
					BestOrientation := Orientation;
				end;
			end;
(*			Score := -GetSquaredDistance(D, NowPt);
			if Score > BestScore then
			begin
				BestPt := Pt;
				BestScore := Score;
			end; *)

(*			if BestOrientation = TRectVertex(-1) then Break;
			NowPt := Oriented(NowPt, ZeroP, BestOrientation, Precision);
(*			NowPt.X := (NowPt.X - D.X) * Precision;
			NowPt.Y := (NowPt.Y - D.Y) * Precision; *)
//			CheckPos(NowPt, Orientation);
		//end;
	end;

	procedure CheckPolygon(const InnerPolygon: TXYPtDynArray);
	var
		i: Integer;
		T: TXYPt;
	begin
		if Length(InnerPolygon) >= 1 then
		begin
			T := InnerPolygon[Length(InnerPolygon) - 1];
			for i := 0 to Length(InnerPolygon) - 1 do
			begin
				CheckVertex(InnerPolygon[i], T, InnerPolygon[i]);
				T := InnerPolygon[i];
			end;
		end;
	end;

var
	i: Integer;
begin
	BestPt.X := 0; //PolygonMiddle(Polygon);
	BestPt.Y := 0; //PolygonMiddle(Polygon);
	GBestDistance := NegInfinity;

//	if CorrectPosition(Size, Polygon, InnerPolygons, BestPt, Precision) then Exit;

//	TryMove(BestPt);
	CheckPolygon(Polygon);
	for i := 0 to Length(InnerPolygons) - 1 do
	begin
		CheckPolygon(InnerPolygons[i]);
	end;
end;

end.
