// * File:     UpdateManager\uMain.pas
// * Created:  2009-05-09
// * Modified: 2011-01-17
// * Version:  1.1.47.22
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	uTypes, uCore,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, uDButton, uDForm, Menus, ComCtrls, uDWinControl, uDImage, uDView,
	Dialogs;

type
	TfMain = class(TDForm)
		MainMenu1: TMainMenu;
		File1: TMenuItem;
		Options1: TMenuItem;
		Help1: TMenuItem;
		EditApplications1: TMenuItem;
		DView1: TDView;
		PopupMenu1: TPopupMenu;
		Update1: TMenuItem;
		ReloadLocalVersion1: TMenuItem;
		ReloadRemoteVersion1: TMenuItem;
		ReloadVersions1: TMenuItem;
		SelectUnpacker1: TMenuItem;
		OpenDialog1: TOpenDialog;
		ForceUpdate1: TMenuItem;
		N1: TMenuItem;
		N2: TMenuItem;
		N3: TMenuItem;
		Add1: TMenuItem;
		Delete1: TMenuItem;
		Run1: TMenuItem;
		UpdateAll1: TMenuItem;
		UpdateOnStartup1: TMenuItem;
		CustomWebAddress1: TMenuItem;
		UpdateMode1: TMenuItem;
		Unknown1: TMenuItem;
		Disabled1: TMenuItem;
		Manual1: TMenuItem;
		Auto1: TMenuItem;
		procedure FormCreate(Sender: TObject);
		procedure EditApplications1Click(Sender: TObject);
		procedure Update1Click(Sender: TObject);
		procedure ReloadVersions1Click(Sender: TObject);
		procedure ReloadRemoteVersion1Click(Sender: TObject);
		procedure ReloadLocalVersion1Click(Sender: TObject);
		procedure DView1GetData(Sender: TObject; var Data: String; ColIndex, RowIndex: Integer;
			Rect: TRect);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure SelectUnpacker1Click(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure Add1Click(Sender: TObject);
		procedure Delete1Click(Sender: TObject);
		procedure Run1Click(Sender: TObject);
		procedure UpdateAll1Click(Sender: TObject);
		procedure UpdateOnStartup1Click(Sender: TObject);
		procedure CustomWebAddress1Click(Sender: TObject);
		procedure PopupMenu1Popup(Sender: TObject);
		procedure Unknown1Click(Sender: TObject);
	private
		{ Private declarations }
		procedure ReloadLocalVersions;
		procedure ReloadRemoteVersions;
		procedure RWOptions(const Save: BG);
	public
		{ Public declarations }
	end;

var
	fMain: TfMain;

implementation

(*
	TODO :
	Automatically update an application
	update.exe {AppExeFile} [-a]
	if AppExeFile not used cvs file is used and dialog is displayed
	else Select AppExeFile and run udate

	DView appl,web (CSV)+DView progress (Id 1/8, Time, Done|Failed (ExitCode 2), message like Release+implement in DDM)+Update+Abort+Exit

	update.csv
	C:\Program Files\{ProjectName}\{ProjectName}.exe","http://www.doamin.cz/software/{ProjectName}/{ProjectName}.zip"
	C:\Program Files\{ProjectName2}\{ProjectName2}.exe","http://www.doamin.cz/software/{ProjectName2}/{ProjectName2}.zip"

	update.ini:
	[Options]
	LastAppExeFileName="C:\Program Files\{ProjectName}\{ProjectName}.exe"
	...

	if {AppExeFile} not specified then select dialog will be performed
*)
{$R *.DFM}

uses
	ufStatus,
	uFiles, uReg, uSplash, uAbout, uDBitmap, uProjectInfo, uOutputFormat, uCSVFile, uWatch, uGetStr,
	uDIniFile, uStrings, uFile, uSystem, uMenus, uDictionary,
	uAPI, uStart, uData, uCustomUser, uWebUpdate, uExtProcess, uMsg, uInputFormat, uProjectVersion,
	uStartup;

{ TfMain }

procedure TfMain.FormCreate(Sender: TObject);
begin
	Background := baNone;
	MenuSet(PopupMenu1);
	OpenDialog1.Filter := GetExecutableFilter + '|' + AllFiles;

	DView1.AddColumn('#');
	DView1.AddColumn('Id');
	DView1.AddColumn('Name');
	DView1.AddColumn('Executable File Name');
	DView1.AddColumn('Local Version');
	DView1.AddColumn('Remote Version');
	DView1.AddColumn('Update Mode');
	DView1.AddColumn('Web');
	DView1.AddColumn('Status');
	DView1.AddColumn('Packed Size');
	DView1.AddColumn('Last Updated');
	DView1.AddColumn('Created');

	RWOptions(False);
	UpdateOnStartup1.Checked := IsRegisteredStartup;

	DView1.RowCount := Applications.Count;
	DView1.SelectAll;
	ReloadLocalVersions;
	DView1.DataChanged;
{$IFOPT d-}
	ReloadRemoteVersions;
{$ENDIF}
end;

procedure TfMain.EditApplications1Click(Sender: TObject);
begin
	APIOpen(CustomCSVFileName);
end;

procedure TfMain.Update1Click(Sender: TObject);
var
	MyApplication: PMyApplication;
	i: SG;
	Count: SG;
begin
	BeginLongOperation;
	try
		ShowStatusWindow(nil, nil);
		UpdateStatus(0);
		ReloadRemoteVersions;
		i := 0;
		Count := 0;
		MyApplication := Applications.GetFirst;
		while MyApplication <> nil do
		begin
			if (MyApplication.UpdateMode in [umManual, umAuto]) and DView1.SelectedRows[i] then
			begin
				if (TMenuItem(Sender).Tag = 1) or
					(CompareVersion(MyApplication.LocalVersion, MyApplication.RemoteVersion) = FirstLess) then
				begin
					Inc(Count);
				end;
			end;
			Inc(i);
			Applications.Next(Pointer(MyApplication));
		end;

		UpdateMaximum(Count);
		UpdateStatus(0);
		Count := 0;
		i := 0;
		MyApplication := Applications.GetFirst;
		while MyApplication <> nil do
		begin
			if (MyApplication.UpdateMode in [umManual, umAuto]) and DView1.SelectedRows[i] then
			begin
				if (TMenuItem(Sender).Tag = 1) or
					(CompareVersion(MyApplication.LocalVersion, MyApplication.RemoteVersion) = FirstLess) then
				begin
					UpdateApplication(MyApplication);
					ReloadLocalVersion(MyApplication);
					DView1.DataChanged;
					Inc(Count);
					UpdateStatus(Count);
					Application.ProcessMessages;
					if Cancel then Exit;
				end;
			end;
			Inc(i);
			Applications.Next(Pointer(MyApplication));
		end;
	finally
		HideStatusWindow;
		EndLongOperation;
	end;
end;

procedure TfMain.ReloadLocalVersions;
var
	MyApplication: PMyApplication;
	i: SG;
begin
	i := 0;
	MyApplication := Applications.GetFirst;
	while MyApplication <> nil do
	begin
		if DView1.SelectedRows[i] then
		begin
			ReloadLocalVersion(MyApplication);
		end;
		Inc(i);
		Applications.Next(Pointer(MyApplication));
	end;
end;

procedure TfMain.ReloadRemoteVersions;
var
	MyApplication: PMyApplication;
	i: SG;
begin
	i := 0;
	MyApplication := Applications.GetFirst;
	while MyApplication <> nil do
	begin
		if (MyApplication.UpdateMode <> umDisabled) and DView1.SelectedRows[i] then
		begin
			ReloadRemoteVersion(MyApplication);
			DView1.DataChanged;
			Application.ProcessMessages;
		end;
		Inc(i);
		Applications.Next(Pointer(MyApplication));
	end;
end;

procedure TfMain.ReloadVersions1Click(Sender: TObject);
begin
	BeginLongOperation;
	try
		ReloadLocalVersions;
		ReloadRemoteVersions;
	finally
		EndLongOperation;
	end;
end;

procedure TfMain.ReloadRemoteVersion1Click(Sender: TObject);
begin
	BeginLongOperation;
	try
		ReloadRemoteVersions;
	finally
		EndLongOperation;
	end;
end;

procedure TfMain.ReloadLocalVersion1Click(Sender: TObject);
begin
	ReloadLocalVersions;
end;

procedure TfMain.DView1GetData(Sender: TObject; var Data: String; ColIndex, RowIndex: Integer;
	Rect: TRect);
var
	Application: PMyApplication;
begin
	Application := Applications.Get(RowIndex);
	case ColIndex of
	0:
		begin
			Data := NToS(RowIndex + 1);
		end;
	1:
		begin
			Data := NToS(Application.Id);
		end;
	2:
		begin
			Data := Application.Name;
		end;
	3:
		begin
			Data := Application.ExeFileName;
		end;
	4:
		begin
			Data := VersionToStr(Application.LocalVersion);
		end;
	5:
		begin
			Data := VersionToStr(Application.RemoteVersion);
		end;
	6:
		begin
			Data := UpdateModeToStr[Application.UpdateMode];
		end;
	7:
		begin
			Data := Application.Web;
		end;
	8:
		begin
			Data := ApplicationStatusToStr[Application.Status];
		end;
	9:
		begin
			Data := BToStr(Application.Size);
		end;
	10:
		begin
			Data := DateTimeToS(Application.Updated, 0, ofDisplay);
		end;
	11:
		begin
			Data := DateTimeToS(Application.Created, 0, ofDisplay);
		end;
	end;
end;

procedure TfMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	RWOptions(True);
end;

procedure TfMain.RWOptions(const Save: BG);
begin
	uCore.RWOptions(Save);
	MainIni.RWFormPos(Self, Save);
	DView1.Serialize(MainIni, Save);
end;

procedure TfMain.SelectUnpacker1Click(Sender: TObject);
begin
	OpenDialog1.Title := 'Select Unpacker Executable';
	ExecuteDialog(OpenDialog1, UnpackerFileName);
end;

procedure TfMain.FormShow(Sender: TObject);
begin
	if RunFirstTime then
	begin
//		SelectUnpacker1Click(Sender);
	end;
end;

procedure TfMain.Add1Click(Sender: TObject);
var
	MyApplication: PMyApplication;
	ExeFileName: TFileName;
begin
	OpenDialog1.Title := Translate('Add Executable Application');
	ExeFileName := '';
	if ExecuteDialog(OpenDialog1, ExeFileName) then
	begin
		MyApplication := Applications.Add;

		MyApplication.ExeFileName := ExeFileName;
		MyApplication.Name := DelFileExt(ExtractFileName(ExeFileName));
		MyApplication.InternalName := MyApplication.Name;
		MyApplication.Created := Now;

		ReloadVersion(MyApplication);

		DView1.RowCount := Applications.Count;
		DView1.DataChanged;
	end;
end;

procedure TfMain.Delete1Click(Sender: TObject);
var
	MyApplication: PMyApplication;
	i: SG;
begin
	if Confirmation('Delete ' + NToS(DView1.SelCount) + ' item' + Plural(DView1.SelCount) + '?',
		[mbYes, mbNo]) = mbYes then
	begin
		i := 0;
		MyApplication := Applications.GetFirst;
		while MyApplication <> nil do
		begin
			if (DView1.SelectedRows[i]) then
			begin
				MyApplication.Status := asDeleteMe;
			end;
			Inc(i);
			Applications.Next(Pointer(MyApplication));
		end;

		i := 0;
		while i < Applications.Count do
		begin
			MyApplication := Applications.Get(i);
			if MyApplication.Status = asDeleteMe then
				Applications.Delete(i)
			else
			begin
				Inc(i);
				Applications.Next(Pointer(MyApplication));
			end;
		end;

		DView1.RowCount := Applications.Count;
		DView1.DataChanged;
	end;
end;

procedure TfMain.Run1Click(Sender: TObject);
var
	Application: PMyApplication;
	i: SG;
begin
	i := 0;
	Application := Applications.GetFirst;
	while Application <> nil do
	begin
		if DView1.SelectedRows[i] then
		begin
			APIOpen(Application.ExeFileName);
		end;
		Inc(i);
		Applications.Next(Pointer(Application));
	end;
end;

procedure TfMain.UpdateAll1Click(Sender: TObject);
begin
	BeginLongOperation;
	try
		ShowStatusWindow(nil, nil);
		UpdateAll;
		HideStatusWindow;
	finally
		EndLongOperation;
	end;
end;

procedure TfMain.UpdateOnStartup1Click(Sender: TObject);
begin
	if UpdateOnStartup1.Checked then
	begin
		UnregisterStartup;
	end
	else
		RegisterStartup('-' + AutoUpdateParam);
	UpdateOnStartup1.Checked := IsRegisteredStartup;
end;

procedure FreeApplications;
var
	MyApplication: PMyApplication;
begin
	MyApplication := Applications.GetFirst;
	while MyApplication <> nil do
	begin
		Finalize(MyApplication^);
		Applications.Next(Pointer(MyApplication));
	end;
	FreeAndNil(Applications);
end;

procedure TfMain.CustomWebAddress1Click(Sender: TObject);
begin
	if GetStr('Custom Web Address', WebAddress, MyWeb) then
	begin
		ReloadRemoteVersion1Click(Sender);
	end;
end;

procedure SetMenuEnabled(AMenuItem: TMenuItem; const AEnabled: BG);
var
	i: SG;
begin
	AMenuItem.Enabled := AEnabled;
	for i := 0 to AMenuItem.Count - 1 do
	begin
		SetMenuEnabled(AMenuItem.Items[i], AEnabled);
	end;
end;

procedure TfMain.PopupMenu1Popup(Sender: TObject);
begin
	SetMenuEnabled(PopupMenu1.Items, DView1.SelCount > 0);
	Add1.Enabled := True;
end;

procedure TfMain.Unknown1Click(Sender: TObject);
var
	Application: PMyApplication;
	i: SG;
	UpdateMode: TUpdateMode;
begin
	UpdateMode := TUpdateMode(TMenuItem(Sender).Tag);
	i := 0;
	Application := Applications.GetFirst;
	while Application <> nil do
	begin
		if DView1.SelectedRows[i] then
		begin
			Application.UpdateMode := UpdateMode;
		end;
		Inc(i);
		Applications.Next(Pointer(Application));
	end;
	DView1.DataChanged;
	WriteToConfig(ConfigFileName);
end;

initialization

Applications := TData.Create;
Applications.ItemSize := SizeOf(TMyApplication);

finalization

FreeApplications;

end.
