// * File:     UpdateManager\UpdateManager.dpr
// * Created:  2009-05-09
// * Modified: 2011-01-17
// * Version:  1.1.47.22
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

program UpdateManager;

uses
	Forms,
	Windows,
	uWatch,
	uTypes,
	uCommon,
	uParams,
	uFiles,
	uStart,
	uMain in 'uMain.pas' {fMain},
	uCore in 'uCore.pas';

{$R *.RES}

const
	ApplicationsName = 'Applications.csv';
	ConfigName = 'LastStatus.csv';
var
	AutoUpdate: BG;

procedure AutoUpdateProc(const Value: string);
begin
	AutoUpdate := True;
end;

begin
	Application.Initialize;
	Application.Title := 'Update Manager';

	AutoUpdate := Pos(AutoUpdateParam, GetCommandLine) <> 0;
	CommonCreate(AutoUpdate);

	RegisterParam(AutoUpdateParam, 'Automatically update all applications and terminates.', AutoUpdateProc);

	CommonCSVFileName := WorkDir + 'Defaults\' + ApplicationsName;
	CustomCSVFileName := AppDataDir + ApplicationsName;
	ConfigFileName := AppDataDir + ConfigName;

	ReadFromCSV(CommonCSVFileName);

{	if RunFirstTime then
	begin
	end;}
	if FileExistsEx(CustomCSVFileName) then
		ReadFromCSV(CustomCSVFileName)
	else
		uFiles.CopyFile(WorkDir + 'Defaults\' + 'User.csv', CustomCSVFileName, True);

	if FileExistsEx(ConfigFileName) then
		ReadFromConfig(ConfigFileName);

	if AutoUpdate then
	begin
		ReadCommandLine(GetCommandLine);
		uCore.RWOptions(False);
		UpdateAll;
	end
	else
	begin
		Application.CreateForm(TfMain, fMain);
		CommonForm(fMain);
		Application.Run;
	end;
	WatchRemoveFile(CommonCSVFileName);
	WatchRemoveFile(CustomCSVFileName);
	WatchRemoveFile(ConfigFileName);
	CommonFree;
end.
