// * File:     Tree\uMain.pas
// * Created:  2004-11-19
// * Modified: 2009-12-08
// * Version:  1.0.47.20
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	uDForm,
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	StdCtrls, uDButton, Dialogs, uDMemo, Menus;

type
	TfMain = class(TDForm)
		ButtonTree: TDButton;
		MemoOutput: TDMemo;
		MemoParser: TDMemo;
		OpenDialog1: TOpenDialog;
		ButtonGenerateSamples: TDButton;
		ButtonSamples: TDButton;
		ButtonOutput: TDButton;
		ButtonTime: TDButton;
		MainMenu1: TMainMenu;
		File1: TMenuItem;
		Options1: TMenuItem;
		Help1: TMenuItem;
		procedure ButtonTreeClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormResize(Sender: TObject);
		procedure ButtonGenerateSamplesClick(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	fMain: TfMain;

implementation

{$R *.dfm}
uses uTypes, uStrings, uFiles, uInputFormat, uData, uDParser, uOutputFormat, uMath, uDictionary, uDIniFile;

const Solution = 0;
	{
		0: Binary tree
		1: Insert
		2: Full Allocation
	}

type
	TValue = U4;

	// Solution 0
	PKnot = ^TKnot;
	TKnot = packed record
		Value: TValue;
		LS, RS: PKnot;
	end;

	// Solution 1
	TNode = packed record // 8
		Pos: U4;
		Value: TValue;
	end;

const
	MaxDepth = 13; // 17 for samples
	ValueNone = High(TValue);
var
	// Solution 0
	Root: PKnot;
	// Solution 1, 2
	NodesC: array[0..MaxDepth] of UG;
	// Solution 1
	NodesF: array[0..MaxDepth] of array of TValue;
	// Solution 2
	NodesI: array[0..MaxDepth] of array of TNode;

procedure TfMain.ButtonGenerateSamplesClick(Sender: TObject);
var
	D, MaxD: UG;
	s: string;
	a: string;
	TreeType: SG; // 0 completni, 2 tenky

	procedure Depth;
	const LR: array[0..1] of Char = ('L', 'R');
	var
		i: SG;
		R: U2;
		En: array[0..1] of BG;
	begin
		Inc(D);

		case TreeType of
		0:
		begin
			En[0] := True;
			En[1] := True;
		end;
		1:
		begin
			R := Random(256);
			En[0] := R > 50;
			En[1] := R < 205;
		end;
		2:
		begin
			En[0] := Random(2) = 0;
			En[1] := not En[0];
		end;
		end;

		for i := 0 to 1 do
		begin
			if En[i] = False then Continue;
			a := a + LR[i];
			R := Random(256);
			if R <= 255 then
				s := s + '(' + IntToStr(R) + ',' + a + ') ';
			if D < MaxD then
			begin
				Depth;
			end;
			SetLength(a, Length(a) - 1);
		end;
		Dec(D);
	end;

var
	FileName: TFileName;
	MaD: SG;
begin
	// Generate Sample Trees
	for TreeType := 0 to 2 do
	begin
		for MaD := 0 to MaxDepth do
		begin
			// Random Data
			s := '(111,) ';
			a := '';
			D := 0;
			if TreeType = 2 then MaxD := MaD * 64 else MaxD := MaD;
			if MaxD > 0 then
				Depth;
			s := s + '()';
			FileName := AppDataDir + 'Tree' + NToS(TreeType, ofIO) + '-' + NToS(MaD, ofIO) + '.txt';
			WriteStringToFile(FileName, s, False);
		end;
	end;
end;

procedure ClearTree(var P: PKnot);
begin
	if P = nil then Exit;
	ClearTree(P.LS);
	ClearTree(P.RS);
	Dispose(P);
	P := nil;
end;

function WriteOutput(UnusedNodes: UG; Duplicate: BG; MaxLevel: UG): string;
var
	Level: UG;
	i, j: SG;
	Wave0, Wave1, WaveS, WaveT: TData;
	P2: ^PKnot;
begin
		// Write output
		if UnusedNodes > 0 then
		begin
			Result := Translate('not complete');
		end
		else if Duplicate then
			Result := Translate('duplicate node')
		else
		begin
			Result := '';
			if Solution = 0 then
			begin
				Wave0 := TData.Create;
				Wave0.ItemSize := SizeOf(Pointer);
				Wave1 := TData.Create;
				Wave1.ItemSize := SizeOf(Pointer);

//TODO :				Wave0.Add(Root);
				WaveS := Wave0;
				WaveT := Wave1;
				for Level := 0 to MaxLevel do
				begin
					// Expand wave
					P2 := WaveS.GetFirst;
					for i := 0 to SG(WaveS.Count) - 1 do
					begin
						Result := Result + IntToStr(P2^.Value) + ' ';
//TODO :						if P2^.LS <> nil then WaveT.Add(P2^.LS);
//TODO :						if P2^.RS <> nil then WaveT.Add(P2^.RS);
						Inc(P2);
					end;
	//				Result := Result + '|';
					Exchange(Pointer(WaveS), Pointer(WaveT));
					WaveT.Clear;
				end;
				Wave1.Free;
				Wave0.Free;
				ClearTree(Root);
			end
			else
			begin
				for Level := 0 to MaxLevel do
				begin
	{				if Solution = 0 then
					begin
						D := 0;
						Rec(Root);
						if Duplicate then Result := 'not complete';
					end
					else}
						for j := 0 to SG(NodesC[Level]) - 1 do
						begin
							if Solution = 1 then
							begin
								Result := Result + IntToStr(NodesI[Level, j].Value) + ' ';
							end
							else
							begin
								if NodesF[Level, j] <> ValueNone then
								begin
									if (Level > 0) and (NodesF[Level - 1, j div 2] = ValueNone) then
									begin
										Result := Translate('not complete');
										Exit;
									end;
									Result := Result + IntToStr(NodesF[Level, j]) + ' ';
								end;
							end;
						end;
	//				Result := Result + '|';
				end;
			end;
		end;
end;

procedure TfMain.ButtonTreeClick(Sender: TObject);
var
	UnusedNodes: UG;
	Duplicate: BG;
	MaxLevel: UG;

	// Input
	i, j: SG;
	s: string;
	FileName: TFileName;

	// Compute
	Level: UG;
	NodeValue: U1;
	NodePos: U4; // for Insert only
	Line: string;

	st: string;
	// Solution 1
	Ins: SG;
	NewSize: SG;

{	procedure Rec(P: PKnot);
	begin
		if P = nil then Exit;
		Inc(D);

		if D = Level + 1 then
		begin
			if P.Value = ValueNone then
			begin
				Duplicate := True;
			end
			else
				s := s + IntToStr(P.Value) + ' ';
		end
		else
		begin
			Rec(P.LS);
			if Duplicate = False then
				Rec(P.RS);
		end;

		Dec(D);
	end;}

var
	P: PKnot;
	Q: TKnot;
	P2: ^PKnot;
	Tim: U8;
	TreeType: SG;

	Parser: TDParser;
begin
	st := '----' + LineSep;
	Line := '';
	if TDButton(Sender).Tag <> 0 then
	begin
		// Read Samples
		for TreeType := 0 to 2 do
		for i := 0 to MaxDepth do
		begin
			FileName := AppDataDir + 'Tree' + NToS(TreeType, ofIO) + '-' + NToS(i, ofIO) + '.txt';
			Line := Line + ReadStringFromFile(FileName);
		end;
	end
	else
	begin
		FileName := DataDir + 'TreeO.txt';
		if ExecuteDialog(OpenDialog1, FileName) = False then Exit;
		ReadStringFromFile(FileName, Line);
	end;

	Parser := TDParser.Create(Line);
	try
		Parser.DecimalSep := '.';
		Parser.ThousandSep := #0;

		Parser.ReadInput;
		while Parser.InputType <> itEOI do
		begin
			// Clear
			if Solution = 1 then
			begin
				for i := 0 to MaxDepth do
				begin
					NodesC[i] := 0;
					SetLength(NodesI[i], 0);
				end;
				UnusedNodes := 0;
			end
			else if Solution = 2 then
			begin
				MaxLevel := 1;
				for i := 0 to MaxDepth do
				begin
					NodesC[i] := MaxLevel;
					SetLength(NodesF[i], MaxLevel);
					for j := 0 to MaxLevel - 1 do
						NodesF[i, j] := ValueNone;
					MaxLevel := MaxLevel shl 1;
				end;
				UnusedNodes := 0;
			end
			else if Solution = 0 then
			begin
				ClearTree(Root);
				UnusedNodes := 1;
				New(P);
				P^.Value := ValueNone;
				P^.LS := nil;
				P^.RS := nil;
				Root := P;
			end;

			Tim := PerformanceCounter;
			MaxLevel := 0;
			Duplicate := False;

			while Parser.InputType <> itEOI do
			begin
				// (
				if Parser.InputType = itLeftParenthesis then
				begin
					Parser.ReadInput;
				end
				else
					Parser.AddMes(mtEExpected, ['(', Parser.Id]);

				// Integer
				NodeValue := 0;
				if Parser.InputType = itInteger then
				begin
					if not (Parser.InInteger in [0..255]) then
						Parser.AddMes(mtWUserWarning, ['Value ' + NToS(Parser.InInteger) + ' out of range ' + NToS(0) + '..' + NToS(255)]);
					NodeValue := Parser.InInteger and $ff;
					Parser.ReadInput;
				end
				else
				begin
					if Parser.InputType = itRightParenthesis then
					begin
						Parser.ReadInput;
						// Tree finished
						Break;
					end;
					Parser.AddMes(mtEExpected, ['Integer', Parser.Id]);
					Parser.ReadInput;
				end;

				// ,
				if Parser.InputType = itComma then
				begin
					Parser.ReadInput;
				end
				else
					Parser.AddMes(mtEExpected, [',', Parser.Id]);

				// [L][R]
				Level := 0;
				NodePos := 0;
				P := Root;
				if Parser.InputType = itIdent then
				begin
					Level := Length(Parser.Id);
					if Level > MaxLevel then
						MaxLevel := Level;
					if Solution = 0 then
					begin
						P := Root;
						for i := 1 to Level do
						begin
							if UpCase(Parser.Id[i]) = 'R' then
								P2 := @P.RS
							else
								P2 := @P.LS;

							if P2^ = nil then
							begin
								New(P);
								Inc(UnusedNodes);
								P2^ := P;
								P^.Value := ValueNone;
								P^.LS := nil;
								P^.RS := nil;
							end
							else
								P := P2^;

						end;
					end
					else
					begin
						NodePos := 0;
						for i := 1 to Level do
						begin
							NodePos := NodePos shl 1;
							if UpCase(Parser.Id[i]) = 'R' then Inc(NodePos);

						end;
					end;
					Parser.ReadInput;
				end;

				// Add Node
				if Solution = 0 then
				begin
					if P.Value = ValueNone then
					begin
						P.Value := NodeValue;
						Dec(UnusedNodes);
					end
					else
						Duplicate := True;
				end
				else if Solution = 1 then
				begin
					{ TODO : Bin. insert }
					Ins := NodesC[Level];
					for i := 0 to SG(NodesC[Level]) - 1 do
					begin
						if NodePos < NodesI[Level, i].Pos then
						begin // Pos to insert found
							Ins := i;
							Break;
						end;
					end;
					Inc(NodesC[Level]);
					NewSize := NodesC[Level];
					if AllocByExp(Length(NodesI[Level]), NewSize) then
					begin
						SetLength(NodesI[Level], NewSize);
					end;

					for j := NodesC[Level] - 1 downto Ins + 1 do
					begin
						NodesI[Level, j] := NodesI[Level, j - 1];
					end;
					NodesI[Level, Ins].Value := NodeValue;
					NodesI[Level, Ins].Pos := NodePos;
				end
				else // Solution = 2
				begin
					if NodesF[Level, NodePos] = ValueNone then
						NodesF[Level, NodePos] := NodeValue
					else
						Duplicate := True;
				end;

				// )
				if Parser.InputType = itRightParenthesis then
				begin
					Parser.ReadInput;
				end
				else
					Parser.AddMes(mtEIdentifierExpected, [Parser.Id]);

			end;

			s := WriteOutput(UnusedNodes, Duplicate, MaxLevel);
			Tim := PerformanceCounter - Tim;

			if ButtonOutput.Down then
				MemoOutput.Lines.Add(s);
			s := NToS(RoundDivU8(1000000 * Tim, PerformanceFrequency), 6);
			st := st + s + LineSep;
			if ButtonTime.Down then
				MemoOutput.Lines.Add(Translate('Time:') + CharSpace + s);
		end;
		// Write time
		FileName := AppDataDir + 'Time.txt';
		WriteStringToFile(FileName, st, True);
	finally
		Parser.Free;
	end;
//	MesToStrings(MemoParser.Lines);
end;

procedure TfMain.FormCreate(Sender: TObject);
begin
	OpenDialog1.Filter := AllText;
	MainIni.RWFormPos(Self, False);
end;

procedure TfMain.FormDestroy(Sender: TObject);
begin
	ClearTree(Root);
end;

procedure TfMain.FormResize(Sender: TObject);
begin
	MemoOutput.SetBounds(MemoOutput.Left, MemoOutput.Top, ClientWidth - 2 * MemoOutput.Left, (ClientHeight - MemoOutput.Top - 2 * FormBorder) div 2);
	MemoParser.SetBounds(MemoParser.Left, MemoOutput.Top + MemoOutput.Height + FormBorder, MemoOutput.Width, MemoOutput.Height);
end;

procedure TfMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	MainIni.RWFormPos(Self, True);
end;

end.
.
