unit uRandomEngine;

interface

uses
  uTypes,
  uSxRandomGenerator,

  uMoveList,
  uMyInternalEngine;

type
  TRandomEngine = class(TMyInternalEngine)
  private
    FRandomGenerator: TSxRandomGenerator;
    function GetNumberOfAcceptedMoves(const AMoveList: PMoveList): UG;
  public
    constructor Create;
    destructor Destroy; override;

    procedure Start; override;
    function GetCurrentLine: string; override;
  end;

implementation

uses
  uTable,

  uETypes,
  uChessMove;

{ TRandomEngine }

procedure TRandomEngine.Start;
var
  MoveList: PMoveList;
  Move: PMove;
  MoveAsString: string;
  MoveIndex: UG;
  SelectedMoveIndex: UG;
  Status: TSubtreeStatus;
  NumberOfAcceptedMoves: UG;
begin
  inherited;

  MoveGenerator.Position := Position;
  MoveList := MoveGenerator.Generate;
  try
    NumberOfAcceptedMoves := GetNumberOfAcceptedMoves(MoveList);
    if NumberOfAcceptedMoves > 0 then
    begin
      SelectedMoveIndex := FRandomGenerator.RangeU4(NumberOfAcceptedMoves - 1);
      Move := MoveList.FirstMove;
      MoveIndex := 0;
      while Move <> nil do
      begin
        MoveAsString := Position.MoveToString(Move);
        if RootMoves.AcceptMove(MoveAsString) then
        begin
          if MoveIndex = SelectedMoveIndex then
          begin
            Status.Score := MoveGenerator.Score;
            Status.ScoreBound := sbExact;
            Status.VariationCut := vcNone;
            Status.MoveCount := 1;
            AnalysisInfo.AddAnalysis(Status, [MoveAsString]);
            Output.DrawAMoves;
            Break;
          end;
          Move := MoveList.NextMove;
          Inc(MoveIndex);
        end;
      end;
    end;
    DoBestMove;
  finally
    MoveGenerator.RemovePrevious;
  end;
end;

constructor TRandomEngine.Create;
begin
  inherited;

  FRandomGenerator := TSxRandomGenerator.Create;
  Options.DeleteAll;
  Options.Add(CommonOptions.ContemptValue); // Used for score of draw pv

  // Used for perft
  Options.Add(Threads);
  Options.Add(HashTable.SizeInMB);
end;

destructor TRandomEngine.Destroy;
begin
  try
    FRandomGenerator.Free;
  finally
    inherited;
  end;
end;

function TRandomEngine.GetCurrentLine: string;
begin
  Result := '';
end;

function TRandomEngine.GetNumberOfAcceptedMoves(const AMoveList: PMoveList): UG;
var
  Move: PMove;
  MoveAsString: string;
begin
  if RootMoves.AcceptAll then
    Result := AMoveList.Count
  else
  begin
    Result := 0;
    Move := AMoveList.FirstMove;
    while Move <> nil do
    begin
      MoveAsString := Position.MoveToString(Move);
      if RootMoves.AcceptMove(MoveAsString) then
      begin
        Inc(Result);
      end;
      Move := AMoveList.NextMove;
    end;
  end;
end;

end.

