// * File:     Sun\uResults.pas
// * Created:  1999-07-01
// * Modified: 2009-11-15
// * Version:  1.3.47.60
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uResults;

interface

uses
	uDBitmap,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, ExtCtrls, uDForm, uDImage, uDLabel, uDEdit, uDWinControl;

type
	TfResults = class(TDForm)
		ImageSU: TDImage;
		ImageSD: TDImage;
		ImageSun: TDImage;
		ImageNoSun: TDImage;
		LabelSunrise: TLabel;
		LabelSunset: TLabel;
		LabelDay: TLabel;
		LabelNight: TLabel;
		LabelSD: TLabel;
		LabelSU: TLabel;
		PanelAzimuth: TPanel;
		ImageAzimuth: TDImage;
		PanelDay: TPanel;
		ImageDay: TDImage;
		EditSU: TDEdit;
		EditSD: TDEdit;
		EditDayLength: TDEdit;
		EditNightLength: TDEdit;
		EditAD: TDEdit;
		EditAU: TDEdit;
		procedure FormCreate(Sender: TObject);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
		procedure ImageAzimuthFill(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure ImageDayFill(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
	private
		{ Private declarations }
		AzimuthBackground: TDBitmap;
	public
		{ Public declarations }
	end;

var
	fResults: TfResults;

implementation

{$R *.DFM}
uses
	uTypes, uDIniFile, uFiles, uSunInfo, uDrawStyle, uDictionary,
	uMain;

procedure TfResults.FormCreate(Sender: TObject);
begin
	Dictionary.TranslateForm(Self);
	Background := baGradient;
	MainIni.RWFormPos(Self, False);

	AzimuthBackground := TDBitmap.Create;
	AzimuthBackground.SetSize(ImageAzimuth.Width, ImageAzimuth.Height);
	AzimuthBackground.FormBitmap(clBtnFace);
	
	ImageSU.Bitmap.LoadFromFile(GraphDir + 'SunUp' + IconExt);
	ImageSU.Bitmap.Border(clWhite, clBlack, 2, ef12);

	ImageSD.Bitmap.LoadFromFile(GraphDir + 'SunDown' + IconExt);
	ImageSD.Bitmap.Border(clWhite, clBlack, 2, ef12);

	ImageSun.Bitmap.LoadFromFile(GraphDir + 'SunOn' + IconExt);
	ImageSun.Bitmap.Border(clWhite, clBlack, 1, ef08);

	ImageNoSun.Bitmap.LoadFromFile(GraphDir + 'NoSun' + IconExt);
	ImageNoSun.Bitmap.Border(clWhite, clBlack, 1, ef08);

	ImageAzimuth.Visible := fMain.Azimuth1.Checked;
	ImageDay.Visible := fMain.DayLine1.Checked;
end;

procedure TfResults.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	MainIni.RWFormPos(Self, True);
end;

procedure TfResults.ImageAzimuthFill(Sender: TObject);
const
	Smaller = 17;
	CrossSize = 48;
var
	i, l: SG;
begin
	if fMain.Azimuth1.Checked then
	begin
		with ImageAzimuth.Bitmap do
		begin
			Bmp(0, 0, AzimuthBackground, ef16);
			Canvas.Brush.Color := clWindow;
			Canvas.Brush.Style := bsClear;
			Canvas.Pen.Color := clWindowText;
			Canvas.Ellipse(0 + Smaller, 0 + Smaller, Width + 1 - Smaller, Height + 1 - Smaller);

			Line(CrossSize, Height / 2, Width - 1 - CrossSize, Height / 2, clWindowText, ef16);
			Line(Width / 2, CrossSize, Width / 2, Height - 1 - CrossSize, clWindowText, ef16);

			for i := 0 to 15 do
			begin
				if i mod 2 = 0 then l := 8 else l := 4;
				Line(
					Width / 2 + (Width / 2 - Smaller - l) * Sin(2 * Pi * i / 16),
					Height / 2 + ((Height / 2 - Smaller - l) * Cos(2 * Pi * i / 16)),
					Width / 2 + ((Width / 2 - Smaller) * Sin(2 * Pi * i / 16)),
					Height / 2 + ((Height / 2 - Smaller) * Cos(2 * Pi * i / 16)),
					clWindowText, ef16, 1);
			end;

			Canvas.Font.Color := clWindowText;
			Canvas.TextOut(
				Width div 2 - Canvas.TextWidth('N') div 2,
				2, 'N');
			Canvas.TextOut(
				Width div 2 - Canvas.TextWidth('S') div 2,
				Height - 2 - Canvas.TextHeight('S'), 'S');
			Canvas.TextOut(
				2,
				Height div 2 - Canvas.TextHeight('W') div 2, 'W');
			Canvas.TextOut(
				Width - 2 - Canvas.TextWidth('E'),
				Height div 2 - Canvas.TextHeight('E') div 2, 'E');
			if (SunPos = spUD) or (SunPos = spD) then
			begin
				Arrow(
					Width / 2, Height / 2,
					Width / 2 + ((Width / 2 - Smaller) * Sin(2 * Pi * AzimuthOn / 360)),
					Height / 2 - ((Height / 2 - Smaller) * Cos(2 * Pi * AzimuthOn / 360)),
					10,
					clRed, ef16, 1);

			end;
			if (SunPos = spUD) or (SunPos = spU) then
			begin
				Arrow(
					Width / 2, Height / 2,
					Width / 2 + ((Width / 2 - Smaller) * Sin(2 * Pi * AzimuthOff / 360)),
					Height / 2 - ((Height / 2 - Smaller) * Cos(2 * Pi * AzimuthOff / 360)),
					10,
					clBlue, ef16, 1);
			end;
		end;
	end;
end;

procedure TfResults.FormDestroy(Sender: TObject);
begin
	FreeAndNil(AzimuthBackground);
end;

procedure TfResults.ImageDayFill(Sender: TObject);
var
	i: Integer;
	S: string;
begin
	if fMain.DayLine1.Checked then
	begin
		with ImageDay.Bitmap do
		begin
			case SunPos of
			spUD:
			begin
				if TimeOn < TimeOff then
				begin
					Bar(0, 0, Trunc(Width * TimeOn / 24), Height - 1, clBlack, ef16);
					Bar(Trunc(Width * TimeOn / 24) + 1, 0, Trunc(Width * TimeOff / 24) - 1, Height - 1, clYellow, ef16);
					Bar(Trunc(Width * TimeOff / 24), 0, Width - 1, Height - 1, clBlack, ef16);
				end
				else
				begin
					Bar(0, 0, Trunc(Width * TimeOff / 24), Height - 1, clYellow, ef16);
					Bar(Trunc(Width * TimeOff / 24) + 1, 0, Trunc(Width * TimeOn / 24) - 1, Height - 1, clBlack, ef16);
					Bar(Trunc(Width * TimeOn / 24), 0, Width - 1, Height - 1, clYellow, ef16);
				end;
			end;
			spU:
			begin
				Bar(0, 0, Trunc(Width * TimeOff / 24), Height - 1, clYellow, ef16);
				Bar(Trunc(Width * TimeOff / 24) + 1, 0, Width - 1, Height - 1, clBlack, ef16);
			end;
			spD:
			begin
				Bar(0, 0, Trunc(Width * TimeOn / 24), Height - 1, clBlack, ef16);
				Bar(Trunc(Width * TimeOn / 24) + 1, 0, Width - 1, Height - 1, clYellow, ef16);
			end;
			spUA:
			begin
				Bar(0, 0, Width - 1, Height - 1, clBlack, ef16);
			end;
			spDA:
			begin
				Bar(0, 0, Width - 1, Height - 1, clYellow, ef16);
			end;
			end;
			Canvas.Font.Color := clRed;
			Canvas.Brush.Style := bsClear;
			for i := 1 to 23 do
			begin
				Line(Width * i div 24, 0, Width * i div 24, Height - 1, clSilver, ef08);

				S := IntToStr(i);
				if i and 1 = 0 then Canvas.TextOut(
					(Width * i div 12 - Canvas.TextWidth(S)) div 2,
					(Height - Canvas.TextHeight(S)) div 2, S);
			end;
		end;
	end;
end;

procedure TfResults.FormShow(Sender: TObject);
begin
	fMain.Results1.Checked := True;
end;

procedure TfResults.FormHide(Sender: TObject);
begin
	fMain.Results1.Checked := False;
end;

end.
