// * File:     Sun\uMap.pas
// * Created:  1999-07-01
// * Modified: 2010-01-07
// * Version:  1.3.47.60
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMap;

interface

uses
	uDBitmap,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	ExtCtrls, uDImage, uDForm, uDWinControl;

type
	TfMap = class(TDForm)
		Image: TDImage;
		procedure FormCreate(Sender: TObject);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
		procedure ImageMouseDown(Sender: TObject; Button: TMouseButton;
			Shift: TShiftState; X, Y: Integer);
		procedure ImageMouseMove(Sender: TObject; Shift: TShiftState; X,
			Y: Integer);
		procedure FormResize(Sender: TObject);
		procedure ImageFill(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	fMap: TfMap;

implementation

{$R *.DFM}
uses
	Math,
	uTypes, uDIniFile, uDButton, uGraph, uColor, uDrawStyle,
	uMain;

procedure TfMap.FormCreate(Sender: TObject);
begin
	MainIni.RWFormPos(Self, False);
end;

procedure TfMap.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	MainIni.RWFormPos(Self, True);
end;

procedure TfMap.ImageMouseDown(Sender: TObject;
	Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	// 1 [pixel] := 2 * pi * 6378 [km] / 384 [pixel] := 104.359781;  [km/pixel]
	if (Button = mbLeft) and (Image.MouseAction = mwNone) then
	begin
		Db.DbNew;
		fMain.PixToPos(Image.UserMouse);
		fMain.Calculate;
		fMain.DrawEdits;
		FillMap;
		fMain.DrawDayLine;
		fMain.DrawAzimuth;
	end;
end;

procedure TfMap.ImageMouseMove(Sender: TObject; Shift: TShiftState;
	X, Y: Integer);
begin
	if Image.MouseL and (Image.MouseAction = mwNone) then
	begin
		fMain.PixToPos(Image.UserMouse);
		fMain.Calculate;
		fMain.DrawEdits;
		FillMap;
		fMain.DrawDayLine;
		fMain.DrawAzimuth;
	end;
end;

procedure TfMap.FormResize(Sender: TObject);
begin
	FillMap;
end;

procedure TfMap.ImageFill(Sender: TObject);
var
	F, F1, F2: TFloPoint;
begin
	fMain.InitEnabledGoToCross;

	// TZ
	if (Db.DbItemCount > 0) then
	begin
		if fMain.TimeZone1.Checked then
		begin
			F1 := fMain.PosToPix(FloPoint(-15 * sTZ - 7.5, TPlace(Db.DbItems[Db.DbItemIndex].PData^).Y));
			F2 := fMain.PosToPix(FloPoint(-15 * sTZ + 7.5, TPlace(Db.DbItems[Db.DbItemIndex].PData^).Y));
//			P := Image.GetPoint((-15 * sTZ - Round(7.5 * PlaceDiv)) / PlaceDiv, TPlace(Db.DbItems[Db.DbItemIndex].PData^).Y / PlaceDiv);
//			X1 := P.X;
	{		fMain.PosToPix(-15 * sTZ - Round(7.5 * PlaceDiv),
				TPlace(Db.DbItems[Db.DbItemIndex].PData^).Y, X1, Y);
			Dec(X1, Image.OfsX);}
//			P := fMain.PosToPix(-15 * sTZ + Round(7.5 * PlaceDiv),
//				TPlace(Db.DbItems[Db.DbItemIndex].PData^).Y);
//			Dec(X2, Image.OfsX);
			Image.Bitmap.Border(Round(F1.X), 0, Round(F2.X), Image.UserArea.Bottom, clDepth[0], clDepth[2], Max(1, Round(2 * Image.ActualZoom)), ef08);
		end;

		if fMain.Cross1.Checked then
		begin
			F := fMain.PosToPix(TPlace(Db.DbItems[Db.DbItemIndex].PData^));

			// -
			if (F.Y >= 0) and (F.Y < Image.Bitmap.Height) then
			begin
				Image.Bitmap.Line(0, F.Y, Image.UserArea.Right, F.Y, clWhite, efNeg);
			end;

			// |
			if (F.X >= 0) and (F.X < Image.Bitmap.Width) then
			begin
				Image.Bitmap.Line(F.X, 0, F.X, Image.UserArea.Bottom, clWhite, efNeg);
			end;
		end;
	end;
end;

procedure TfMap.FormShow(Sender: TObject);
begin
	OnResize := FormResize;
	fMain.Map2.Checked := True;
	FillMap;
end;

procedure TfMap.FormHide(Sender: TObject);
begin
	fMain.Map2.Checked := False;
end;

end.
