// * File:     Sun\uMain.pas
// * Created:  1999-07-01
// * Modified: 2010-07-17
// * Version:  1.3.47.60
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	uTypes, uDBitmap, uSunInfo, uOpenedFileItem,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	ExtCtrls, Grids, Calendar, StdCtrls, Menus, ImgList,
	uDButton, uDImage, uDb, uDForm, uDLabel, Dialogs, uOpenedFiles, uDEdit;

type
	TfMain = class(TDForm)
		EditCX: TDEdit;
		EditCY: TDEdit;
		EditTZ: TDEdit;
		LabelLatitude: TLabel;
		LabelTimeZone: TLabel;
		LabelLongitude: TLabel;
		ComboBoxItems: TComboBox;
		LabelPlace: TLabel;
		MainMenu1: TMainMenu;
		File1: TMenuItem;
		Date1: TMenuItem;
		PreviousYear1: TMenuItem;
		NextYear1: TMenuItem;
		PreviousMonth1: TMenuItem;
		NextMonth1: TMenuItem;
		Today1: TMenuItem;
		N2: TMenuItem;
		Bevel2: TBevel;
		View1: TMenuItem;
		Cross1: TMenuItem;
		TimeZone1: TMenuItem;
		Map1: TMenuItem;
		ButtonAdd: TDButton;
		ButtonDelete: TDButton;
		Label2: TLabel;
		PanelIndex: TLabel;
		PanelCount: TLabel;
		Zoom1: TMenuItem;
		Azimuth1: TMenuItem;
		DayLine1: TMenuItem;
		N4: TMenuItem;
		ShortestDay1: TMenuItem;
		LongestDay1: TMenuItem;
		ButtonUpdate: TDButton;
		PreviousDay1: TMenuItem;
		NextDay1: TMenuItem;
		GotoCross1: TMenuItem;
		N5: TMenuItem;
		OpenDialog1: TOpenDialog;
		SaveDialog1: TSaveDialog;
		ButtonRename: TDButton;
		N9: TMenuItem;
		Date2: TMenuItem;
		Map2: TMenuItem;
		Results1: TMenuItem;
		Help1: TMenuItem;
		N1: TMenuItem;
		FileExtensions1: TMenuItem;
		SortByName1: TMenuItem;
		N3: TMenuItem;
		SortByLongitude1: TMenuItem;
		SortByLatitude1: TMenuItem;
		Bevel1: TBevel;
		OpenedFiles: TOpenedFiles;
		Options1: TMenuItem;
		procedure FormCreate(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure ComboBoxItemsChange(Sender: TObject);
		procedure EditCYChange(Sender: TObject);
		procedure EditCXChange(Sender: TObject);
		procedure EditTZChange(Sender: TObject);
		procedure Today1Click(Sender: TObject);
		procedure PreviousYear1Click(Sender: TObject);
		procedure NextYear1Click(Sender: TObject);
		procedure PreviousMonth1Click(Sender: TObject);
		procedure NextMonth1Click(Sender: TObject);
		procedure MapClick(Sender: TObject);
		procedure Cross1Click(Sender: TObject);
		procedure TimeZone1Click(Sender: TObject);
		procedure Azimuth1Click(Sender: TObject);
		procedure DayLine1Click(Sender: TObject);
		procedure ButtonDeleteClick(Sender: TObject);
		procedure ButtonAddClick(Sender: TObject);
		procedure ShortestDay1Click(Sender: TObject);
		procedure PreviousDay1Click(Sender: TObject);
		procedure NextDay1Click(Sender: TObject);
		procedure GotoCross1Click(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure ButtonRenameClick(Sender: TObject);
		procedure Date2Click(Sender: TObject);
		procedure Map2Click(Sender: TObject);
		procedure Results1Click(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FileExtensions1Click(Sender: TObject);
		procedure SortByX1Click(Sender: TObject);
		procedure OpenedFilesChangeFile(Sender: TObject);
		function OpenedFilesFreeFile(Sender: TObject;
			const Item: TOpenedFileItem): Boolean;
		function OpenedFilesLoadFromFile(Sender: TObject;
			var FileName: TFileName): Boolean;
		function OpenedFilesNewFile(Sender: TObject;
			const Item: TOpenedFileItem): Boolean;
		function OpenedFilesSaveToFile(Sender: TObject;
			var FileName: TFileName): Boolean;
	private
		{ Private declarations }
		CrossR: TRect;
		procedure RWOptions(const Save: Boolean);
		procedure CalcTZ;
		procedure DrawTZ;
		procedure LoadWorld;
		procedure LoadMaps;
		procedure WMDropFiles(var Msg: TWMDropFiles); message WM_DropFiles;
	public
		{ Public declarations }
		procedure InitEnabledGoToCross;
		procedure DrawEdits;
		procedure PixToPos(const Pix: TPoint);
		function PosToPix(const P: TFloPoint): TFloPoint;
		procedure Calculate;
		procedure DrawEditDate;
		procedure DrawEditYear;
		procedure DrawDayLine;
		procedure DrawAzimuth;
		procedure InitEnabled;
	end;

type
	TPlace = TFloPoint;
var
	fMain: TfMain;

	Db: TDb;

	CalendarYear: Integer;

	SunPos: TSunPos;
	TimeOn, TimeOff: Extended;
	AzimuthOn, AzimuthOff: Extended;

	BmpFile: TDBitmap; // Unpacked bitmap from file
	sTZ: Extended;

function ShortYear(const Year: Integer): Integer;
procedure FillMap;

implementation

{$R *.DFM}
uses
	MMSystem, Math,
	uFiles, uGraph, uAbout, uMenus, uInputFormat, uFileExt, uSounds, uParams, uProjectInfo, uParserMsg,
		uGetInt, uReg, uWave, uDIniFile, uStrings, uOutputFormat, uMath, uSystem, uSorts, uStart, uCSVFile,
	uDate, uMap, uResults;

var
	MapNames: TFileNames;
	MapIndex: Integer;
	MapCount: Integer;

// TfMain

procedure TfMain.DrawTZ;
begin
	EditTZ.OnChange := nil;
	EditTZ.Text := FToS(sTZ);
	EditTZ.Update;
	EditTZ.OnChange := EditTZChange;
end;

procedure TfMain.DrawEdits;
var
	P: PFloPoint;
begin
	if Db.DbItemCount <= 0 then Exit;

	P := Db.DbItems[Db.DbItemIndex].PData;

	EditCX.OnChange := nil;
	EditCX.Text := FToS(P.X);
	EditCX.Update;
	EditCX.OnChange := EditCXChange;
	if ButtonUpdate.Down then DrawTZ;

	EditCY.OnChange := nil;
	EditCY.Text := FToS(P.Y);
	EditCY.Update;
	EditCY.OnChange := EditCYChange;
end;

procedure TfMain.InitEnabled;
begin
	Today1.Enabled := Date <> EncodeDate(
		fDate.Calendar1.Year, fDate.Calendar1.Month, fDate.Calendar1.Day);
	fDate.ButtonToday.Enabled := Today1.Enabled;

	Map1.Items[MapIndex].Checked := True;
end;

procedure TfMain.PixToPos(const Pix: TPoint);
var
	P: PFloPoint;
begin
	if Db.DbItemCount > 0 then
	begin
		P := Db.DbItems[Db.DbItemIndex].PData;
		P^ := fMap.Image.SToL(Pix);
		P.X :=
			(360 * Pix.X - 185 * fMap.Image.UserBitmap.Width + 180) / fMap.Image.UserBitmap.Width;
		P.Y :=
			(180 * Pix.Y - 90 * fMap.Image.UserBitmap.Height + 90) / fMap.Image.UserBitmap.Height;
	end;
	if ButtonUpdate.Down then CalcTZ;
end;

function TfMain.PosToPix(const P: TFloPoint): TFloPoint;
var
	HC: TFloPoint;
	Rot: SG;
begin
	if (fMap.Image.UserArea.Right = 0) or (fMap.Image.UserArea.Bottom = 0) then
	begin
		Result.X := 0;
		Result.Y := 0;
		Exit;
	end;

	// Y
	HC.Y := P.Y + 90;
	HC.Y := ModE(HC.Y, (2 * 180));
	if Abs(HC.Y) < 180 then
	begin
		Rot := 0;
	end
	else
	begin
		Rot := 1;
		HC.Y := 2 * 180 - HC.Y;
	end;
	HC.Y := (fMap.Image.UserArea.Bottom + 1) * HC.Y / 180;

	// X
	HC.X := P.X + 185 + Rot * 180;
	HC.X := ModE(HC.X, 360);
	HC.X := (fMap.Image.UserArea.Right + 1) * HC.X / 360;
	Result := fMap.Image.GetFloPoint(HC);
end;

procedure TfMain.InitEnabledGoToCross;
const
	CrossSize = 16;
var
	B: Boolean;
	F: TFloPoint;
	P: TPoint;
begin
	if (Db.DbItemCount > 0) and ((fMap.Image.MaxOfsX > 0) or (fMap.Image.MaxOfsY > 0)) then
	begin
{		PosToPix(
			TPlace(Db.DbItems[Db.DbItemIndex].PData^).X,
			TPlace(Db.DbItems[Db.DbItemIndex].PData^).Y, fMap.Image.OfsX, fMap.Image.OfsY);
		FillMap;}


		F := PosToPix(TPlace(Db.DbItems[Db.DbItemIndex].PData^));
		P := FloPointToPoint(F);
		P.X := P.X + fMap.Image.OfsX - fMap.Image.Width div 2;
		P.Y := P.Y + fMap.Image.OfsY - fMap.Image.Height div 2;
		CrossR.TopLeft := P;
		CrossR.BottomRight := P;
		InflateRect(CrossR, CrossSize, CrossSize);
		B := True; //(fMap.Image.OfsX <> Round(P.X)) or (fMap.Image.OfsY <> Round(P.Y));
	end
	else
		B := False;
	GoToCross1.Enabled := B;
end;

function ShortYear(const Year: Integer): Integer;
begin
	Result := UnsignedMod(Year, 10000);
	if Result = 0 then
		Result := 2000;
end;

procedure TfMain.DrawEditDate;
begin

	fDate.EditDate.Text := DateToStr(EncodeDate(CalendarYear, fDate.Calendar1.Month, fDate.Calendar1.Day));
end;

procedure TfMain.LoadMaps;
var
{	Dir: string;
	SearchRec: TSearchRec;
	ErrorCode: Integer;}

	i: Integer;
{	Offset: Integer;
	MaxLimit: Integer;
	Switch: Integer;
	MapName: TFileName;}

	MenuItem: TMenuItem;
begin
	MapCount := 0;
	for i := 0 to Length(AllPictureExt) - 1 do
		ReadDir(MapNames, MapCount, WorkDir + 'Maps' + PathDelim, AllPictureExt[i], True, False, True, True);

	// Menu
	for i := 0 to MapCount - 1 do
	begin
		MenuItem := TMenuItem.Create(Map1);
		MenuItem.Caption := IntToStr(i) + ' ' + ExtractFileName(MapNames[i]);
		MenuItem.OnClick := MapClick;
		MenuItem.Tag := i;
		MenuItem.RadioItem := True;
		MenuItem.OnAdvancedDrawItem := Map1.OnAdvancedDrawItem;
		Map1.Insert(i, MenuItem);
	end;
end;

procedure TfMain.DrawEditYear;
begin
	fDate.EditYear.OnChange := nil;
	fDate.EditYear.Text := IntToStr(CalendarYear);
	fDate.EditYear.OnChange := fDate.EditYearChange;
end;

var
	MapName: TFileName;

procedure TfMain.RWOptions(const Save: Boolean);
var Section: string;
begin
//	Db.DbItemIndex := MainIni.RWSGF('Options', 'PlaceIndex', Db.DbItemIndex, 0, Save);
	if Db.DbItemCount > 0 then
	begin
		TPlace(Db.DbItems[0].PData^).X := MainIni.RWFGF('Options', 'Longitude', TPlace(Db.DbItems[0].PData^).X, 0, Save);
		TPlace(Db.DbItems[0].PData^).Y := MainIni.RWFGF('Options', 'Latitude', TPlace(Db.DbItems[0].PData^).Y, 0, Save);
	end;
	sTZ := MainIni.RWFGF('Options', 'TimeZone', sTZ, 0, Save);
	ButtonUpdate.Down := MainIni.RWBGF('Options', 'AutoupdateTimeZone', ButtonUpdate.Down, ButtonUpdate.Down, Save);
	fDate.Calendar1.OnChange := nil;
	CalendarYear := MainIni.RWSGF('Options', 'Year', CalendarYear, fDate.Calendar1.Year, Save);
	fDate.Calendar1.Month := MainIni.RWSGF('Options', 'Month', fDate.Calendar1.Month, fDate.Calendar1.Month, Save);
	fDate.Calendar1.Day := MainIni.RWSGF('Options', 'Day', fDate.Calendar1.Day, fDate.Calendar1.Day, Save);
	fDate.Calendar1.OnChange := fDate.Calendar1Change;

	Date2.Checked := MainIni.RWBGF('Options', 'FormDate', Date2.Checked, Date2.Checked, Save);
	Map2.Checked := MainIni.RWBGF('Options', 'FormMap', Map2.Checked, Map2.Checked, Save);
	Results1.Checked := MainIni.RWBGF('Options', 'FormResults', Results1.Checked, Results1.Checked, Save);

	Section := 'View';
	if Length(MapNames) > MapIndex then
	if (Save = False) or (MapCount > 0) then
		MapName := MainIni.RWStringF(Section, 'MapName', MapNames[MapIndex], 'Basic.jpg', Save);

	fMap.Image.Serialize(MainIni, Save);

	Cross1.Checked := MainIni.RWBGF(Section, 'Cross', Cross1.Checked, Cross1.Checked, Save);
	TimeZone1.Checked := MainIni.RWBGF(Section, 'TimeZone', TimeZone1.Checked, TimeZone1.Checked, Save);
	Azimuth1.Checked := MainIni.RWBGF(Section, 'Azimuth', Azimuth1.Checked, Azimuth1.Checked, Save);
	DayLine1.Checked := MainIni.RWBGF(Section, 'DayLine', DayLine1.Checked, DayLine1.Checked, Save);

	MainIni.RWFormPos(Self, Save);
end;

procedure DbItemsChanged;
begin
	fMain.OpenedFiles.Change;
end;

procedure TfMain.FormCreate(Sender: TObject);
var
	i: Integer;
begin
	Background := baGradient;

	AddFileType(
		'snp',
		'Sun Places',
		GraphDir + 'Earth.ico,0',
		[GetProjectInfo(piProductName)],
		['"' + ExeFileName + '" "%1"']);

	OpenDialog1.Filter := GetFileNameFilter('Sun Places', ['snp', 'csv']) + '|' + AllFiles;
	SaveDialog1.Filter := OpenDialog1.Filter;

	Db := TDb.Create;
	Db.New(SizeOf(TPlace), 'DSnp', 0);
	Db.DbPanelIndex := PanelIndex;
	Db.DbPanelCount := PanelCount;

	Db.DbComboBoxItems := ComboBoxItems;
	Db.DbButtonAdd := ButtonAdd;
	Db.DbButtonRename := ButtonRename;
	Db.DbButtonDelete := ButtonDelete;
	Db.OnDbItemsChanged := DbItemsChanged;
	Db.DbComboBoxItemsChange := ComboBoxItemsChange;

	OpenedFiles.ItemSize := 0; //SizeOf(TPlace);

	OpenedFiles.File1 := File1;
//	OpenedFiles.Window1 := Window1;
	OpenedFiles.CreateMenuFile(False);

	OpenedFiles.OpenDialog1 := OpenDialog1;
	OpenedFiles.SaveDialog1 := SaveDialog1;

	fDate := TfDate.Create(nil);
	fMap := TfMap.Create(nil);
	fMap.Image.CreateZoom(Zoom1);

	fResults := TfResults.Create(nil);
	LoadMaps;

	RWOptions(False);
	if RunFirstTime then
	begin
		OpenedFiles.OpenedFileLoadFromFile('Places' + PathDelim + 'World.csv');
	end;

	if Db.DbItemIndex > 0 then Db.DbItemIndex := 0;
	if ButtonUpdate.Down then CalcTZ;
	DrawEdits;
	MapIndex := 0;
	for i := 0 to MapCount - 1 do
	begin
		if MapName = MapNames[i] then
		begin
			MapIndex := i;
			Break;
		end;
	end;

	LoadWorld;
//	GotoCross1Click(Sender);
	if Assigned(fDate) then
	begin
		fDate.ComboBoxM.OnChange := nil;
		fDate.ComboBoxM.ItemIndex := fDate.Calendar1.Month - 1;
		fDate.ComboBoxM.OnChange := fDate.ComboBoxMChange;
	end;

	DrawEditYear;
	Calculate;
	DrawEditDate;
	DrawEdits;

	if Date2.Checked then Date2Click(Sender);
	if Map2.Checked then Map2Click(Sender);
	if Results1.Checked then Results1Click(Sender);
end;

procedure TfMain.FormDestroy(Sender: TObject);
begin
	FormFree(TForm(fResults));
	FormFree(TForm(fMap));
	FormFree(TForm(fDate));

	FreeAndNil(OpenedFiles);
	FreeAndNil(Db);

	FreeAndNil(BmpFile);
end;

procedure FillMap;
begin
	fMap.Image.Repaint;
end;

procedure TfMain.CalcTZ;
var
	X: Double;
begin
	if Db.DbItemCount > 0 then
	begin
		X := -TPlace(Db.DbItems[Db.DbItemIndex].PData^).X;
		sTZ := Floor({Sgn(X) *} (X + 7.5) / 15);
	end;
end;

procedure TfMain.ComboBoxItemsChange(Sender: TObject);
begin
	if Db.DbComboBoxItemsChanging then
	begin
		if ButtonUpdate.Down then
		begin
			CalcTZ;
		end;
		Calculate;
		DrawEdits;
		FillMap;
		DrawDayLine;
		DrawAzimuth;
	end;
end;

procedure TfMain.EditCXChange(Sender: TObject);
begin
	Db.DbNew;
	TPlace(Db.DbItems[0].PData^).X := StrToValE(EditCX.Text, True, -1000, 0, 1000);
	if ButtonUpdate.Down then
	begin
		CalcTZ;
		DrawTZ;
	end;

	Calculate;
	FillMap;
	DrawDayLine;
	DrawAzimuth;
end;

procedure TfMain.EditCYChange(Sender: TObject);
begin
	Db.DbNew;
	TPlace(Db.DbItems[0].PData^).Y := StrToValE(EditCY.Text, True, -1000, 0, 1000);

	Calculate;
	FillMap;
	DrawDayLine;
	DrawAzimuth;
end;

procedure TfMain.EditTZChange(Sender: TObject);
begin
	sTZ := StrToValE(EditTZ.Text, True, -1000, 0, 1000);

	Calculate;
	FillMap;
	DrawDayLine;
	DrawAzimuth;
end;

procedure TfMain.Today1Click(Sender: TObject);
var AYear, AMonth, ADay: Word;
begin
	fDate.Calendar1.OnChange := nil;
	DecodeDate(Date, AYear, AMonth, ADay);
	fDate.Calendar1.Year := AYear;
	CalendarYear := AYear;

	fDate.Calendar1.Month := AMonth;
	fDate.ComboBoxM.OnChange := nil;
	fDate.ComboBoxM.ItemIndex := fDate.Calendar1.Month - 1;
	fDate.ComboBoxM.OnChange := fDate.ComboBoxMChange;
	fDate.Calendar1.Day := ADay;
	fDate.Calendar1.OnChange := fDate.Calendar1Change;
	fMain.DrawEditDate;
	fMain.DrawEditYear;
	fMain.Calculate;
	fMain.DrawDayLine;
	fMain.DrawAzimuth;
	fMain.InitEnabled;
end;

procedure TfMain.PreviousYear1Click(Sender: TObject);
begin
	Dec(CalendarYear);
	fDate.Calendar1.OnChange := nil;
	fDate.Calendar1.Year := ShortYear(CalendarYear);
	fDate.Calendar1.OnChange := fDate.Calendar1Change;
	DrawEditDate;
	DrawEditYear;
	Calculate;
	DrawDayLine;
	DrawAzimuth;
	InitEnabled;
end;

procedure TfMain.NextYear1Click(Sender: TObject);
begin
	Inc(CalendarYear);
	fDate.Calendar1.OnChange := nil;
	fDate.Calendar1.Year := ShortYear(CalendarYear);
	fDate.Calendar1.OnChange := fDate.Calendar1Change;
	DrawEditDate;
	DrawEditYear;
	Calculate;
	DrawDayLine;
	DrawAzimuth;
	InitEnabled;
end;

procedure TfMain.PreviousMonth1Click(Sender: TObject);
begin
	fDate.Calendar1.OnChange := nil;
	fDate.Calendar1.PrevMonth;
	fDate.ComboBoxM.OnChange := nil;
	fDate.ComboBoxM.ItemIndex := fDate.Calendar1.Month - 1;
	fDate.ComboBoxM.OnChange := fDate.ComboBoxMChange;
	fDate.Calendar1.OnChange := fDate.Calendar1Change;
	DrawEditDate;
	Calculate;
	DrawDayLine;
	DrawAzimuth;
	InitEnabled;
end;

procedure TfMain.NextMonth1Click(Sender: TObject);
begin
	fDate.Calendar1.OnChange := nil;
	fDate.Calendar1.NextMonth;
	fDate.ComboBoxM.OnChange := nil;
	fDate.ComboBoxM.ItemIndex := fDate.Calendar1.Month - 1;
	fDate.ComboBoxM.OnChange := fDate.ComboBoxMChange;
	fDate.Calendar1.OnChange := fDate.Calendar1Change;
	DrawEditDate;
	Calculate;
	DrawDayLine;
	DrawAzimuth;
	InitEnabled;
end;

procedure TfMain.MapClick(Sender: TObject);
begin
	MapIndex := TMenuItem(Sender).Tag;
	InitEnabled;
	if Assigned(BmpFile) then
	begin
		FreeAndNil(BmpFile);
	end;
	LoadWorld;
	FillMap;
end;

procedure TfMain.Cross1Click(Sender: TObject);
begin
	Cross1.Checked := not Cross1.Checked;
	FillMap;
end;

procedure TfMain.TimeZone1Click(Sender: TObject);
begin
	TimeZone1.Checked := not TimeZone1.Checked;
	FillMap;
end;

procedure TfMain.Azimuth1Click(Sender: TObject);
begin
	Azimuth1.Checked := not Azimuth1.Checked;
	if Assigned(fResults) then
		fResults.ImageAzimuth.Visible := Azimuth1.Checked;
	if Azimuth1.Checked then DrawAzimuth;
end;

procedure TfMain.DayLine1Click(Sender: TObject);
begin
	DayLine1.Checked := not DayLine1.Checked;
	if Assigned(fResults) then
		fResults.ImageDay.Visible := DayLine1.Checked;
	if DayLine1.Checked then DrawDayLine;
end;

procedure TfMain.ButtonAddClick(Sender: TObject);
begin
	Db.DbAdd;
end;

procedure TfMain.ButtonDeleteClick(Sender: TObject);
begin
	Db.DbDelete;
end;

procedure TfMain.LoadWorld;
begin
	if not Assigned(BmpFile) then
	begin
		BeginLongOperation;
		BmpFile := TDBitmap.Create;
		if MapCount > 0 then
		begin
			BmpFile.LoadFromFile(WorkDir + 'Maps' + PathDelim + MapNames[MapIndex]);
			if Assigned(fMap) then
			begin
				fMap.Image.UserArea := BmpFile.GetFullRect;
				fMap.Image.UserBitmap := BmpFile;
			end;
		end
		else
		begin
			BmpFile.Sample(1024, 768);
		end;
		EndLongOperation(False);
	end;
end;

procedure TfMain.ShortestDay1Click(Sender: TObject);
var
	SL: Integer;
	TimeOn,
	TimeOff,
	AzimuthOn,
	AzimuthOff: Extended;
	ThisDay: TDateTime;
	DayLen2, DayLen1, DayLen: Extended;
	SunPos: TSunPos;

	AY, AM, AD: Word;
	i: Integer;
begin
	SL := TMenuItem(Sender).Tag;

	DayLen2 := 0;
	DayLen1 := 0;

	ThisDay := fDate.Calendar1.CalendarDate;
	for i := 0 to 511 do
	begin
		TimeOn := 0;
		TimeOff := 0;
		AzimuthOn := 0;
		AzimuthOff := 0;
		DecodeDate(ThisDay, AY, AM, AD);
		SunOnOff(
			TPlace(Db.DbItems[Db.DbItemIndex].PData^).X,
			- TPlace(Db.DbItems[Db.DbItemIndex].PData^).Y, sTZ,
			AY, AM, AD,
			TimeOn, TimeOff, AzimuthOn, AzimuthOff, SunPos);

		case SunPos of
		spUD: DayLen := Abs(TimeOff - TimeOn);
		spU:  DayLen := TimeOff;
		spD:  DayLen := 24 - TimeOn;
		spUA: DayLen := 0;
		else  DayLen := 24;
		end;

		if (DayLen2 <> 0) and (DayLen1 <> 0) then
		begin
			if ((SL = 1) and ((DayLen2 < DayLen1) and (DayLen < DayLen1)))
			or ((SL = 0) and ((DayLen2 > DayLen1) and (DayLen > DayLen1))) then
			begin
				DecodeDate(ThisDay - 1, AY, AM, AD);
				CalendarYear := AY;
				DrawEditYear;
				fDate.Calendar1.OnChange := nil;
				fDate.Calendar1.CalendarDate := ThisDay - 1;
				fDate.Calendar1.OnChange := fDate.Calendar1Change;
				fDate.ComboBoxM.OnChange := nil;
				fDate.ComboBoxM.ItemIndex := fDate.Calendar1.Month - 1;
				fDate.ComboBoxM.OnChange := fDate.ComboBoxMChange;
				DrawEditDate;
				DrawEditYear;
				Calculate;
				DrawDayLine;
				DrawAzimuth;
				InitEnabled;
				Break;
			end;
		end;
		ThisDay := ThisDay + 1;
		DayLen2 := DayLen1;
		DayLen1 := DayLen;
	end;
end;

procedure TfMain.DrawDayLine;
begin
	fResults.ImageDay.Repaint;
end;

procedure TfMain.DrawAzimuth;
begin
	fResults.ImageAzimuth.Repaint;
end;

procedure TfMain.Calculate;
var
	S: string;
	e: Extended;
begin
	if not Assigned(fResults) then Exit;
	TimeOn := 0;
	TimeOff := 0;
	AzimuthOn := 0;
	AzimuthOff := 0;
	if Db.DbItemCount > 0 then
		SunOnOff(
			TPlace(Db.DbItems[Db.DbItemIndex].PData^).X,
			- TPlace(Db.DbItems[Db.DbItemIndex].PData^).Y, sTZ,
			CalendarYear, fDate.Calendar1.Month, fDate.Calendar1.Day,
			TimeOn, TimeOff, AzimuthOn, AzimuthOff, SunPos);

	if (SunPos = spUD) or (SunPos = spD) then
		S := MsToStr(Round(Hour * TimeOn), diHMSD, 2, True)
	else
		S := '';
	fResults.EditSU.Text := S;
	fResults.EditSU.Update;
	if (SunPos = spUD) or (SunPos = spD) then
		S := NToS(Round(100 * AzimuthOn), 2)
	else
		S := '';
	fResults.EditAU.Text := S;
	fResults.EditAU.Update;

	if (SunPos = spUD) or (SunPos = spU) then
		S := MsToStr(Round(Hour * TimeOff), diHMSD, 2, True)
	else
		S := '';
	fResults.EditSD.Text := S;
	fResults.EditSD.Update;

	if (SunPos = spUD) or (SunPos = spU) then
		S := NToS(Round(100 * AzimuthOff), 2)
	else
		S := '';
	fResults.EditAD.Text := S;
	fResults.EditAD.Update;

	case SunPos of
	spUD: e := Abs(TimeOff - TimeOn);
	spU:  e := TimeOff;
	spD:  e := 24 - TimeOn;
	spUA: e := 0;
	else  e := 24;
	end;

	fResults.EditDayLength.Text := MsToStr(Round(Hour * e), diHMSD, 2, True);
	fResults.EditDayLength.Update;
	fResults.EditNightLength.Text := MsToStr(Round(Hour * (24 - e)), diHMSD, 2, True);
	fResults.EditNightLength.Update;
end;

procedure TfMain.PreviousDay1Click(Sender: TObject);
begin
	if Assigned(fDate) then
	begin
		fDate.Calendar1.OnChange := nil;
		fDate.Calendar1.Day := fDate.Calendar1.Day - 1;
		fDate.Calendar1.OnChange := fDate.Calendar1Change;
	end;
	DrawEditDate;
	Calculate;
	DrawDayLine;
	DrawAzimuth;
	InitEnabled;
end;

procedure TfMain.NextDay1Click(Sender: TObject);
begin
	if Assigned(fDate) then
	begin
		fDate.Calendar1.OnChange := nil;
		fDate.Calendar1.Day := fDate.Calendar1.Day + 1;
		fDate.Calendar1.OnChange := fDate.Calendar1Change;
	end;
	DrawEditDate;
	Calculate;
	DrawDayLine;
	DrawAzimuth;
	InitEnabled;
end;

procedure TfMain.GotoCross1Click(Sender: TObject);
begin
	if Assigned(fMap) then
	begin
		fMap.Image.OffsetOnRect(CrossR);
	end;
end;

procedure TfMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	CanClose := OpenedFiles.CanClose;
	if CanClose then
	begin
		RWOptions(True);
	end;
end;

procedure TfMain.ButtonRenameClick(Sender: TObject);
begin
	Db.DbRename;
end;

procedure TfMain.Date2Click(Sender: TObject);
begin
	if not Assigned(fDate) then fDate := TfDate.Create(Self);
	fDate.Visible := not fDate.Visible;
end;

procedure TfMain.Map2Click(Sender: TObject);
begin
	if not Assigned(fMap) then fMap := TfMap.Create(Self);
	fMap.Visible := not fMap.Visible;
end;

procedure TfMain.Results1Click(Sender: TObject);
begin
	if not Assigned(fResults) then fResults := TfResults.Create(Self);
	fResults.Visible := not fResults.Visible;
end;

procedure TfMain.FormShow(Sender: TObject);
begin
	OpenedFiles.OpenedFileChangeFile(Sender);
end;

procedure TfMain.FileExtensions1Click(Sender: TObject);
begin
	FormFileExt;
end;

procedure TfMain.SortByX1Click(Sender: TObject);
var
	i, j: SG;
	SortType: SG;

	AIndex: array of SG;
	AValueS: array of string;
	AValue: array of Extended;
begin
	SortType := TComponent(Sender).Tag;

	SetLength(AIndex, Db.DbItemCount);

	FillOrderU4(AIndex[0], Db.DbItemCount);

	case SortType of
	0:
	begin
		SetLength(AValueS, Db.DbItemCount);
		for i := 0 to Db.DbItemCount - 1 do
		begin
			AValueS[i] := Db.DbItems[i].Name;
		end;
	end;
	1:
	begin
		SetLength(AValue, Db.DbItemCount);
		for i := 0 to Db.DbItemCount - 1 do
		begin
			AValue[i] := TPlace(Db.DbItems[i].PData^).X;
		end;
	end;
	2:
	begin
		SetLength(AValue, Db.DbItemCount);
		for i := 0 to Db.DbItemCount - 1 do
		begin
			AValue[i] := TPlace(Db.DbItems[i].PData^).Y;
		end;
	end;
	end;

	case SortType of
	0: SortStr(PArraySG(AIndex), PArrayString(AValueS), Db.DbItemCount);
	1, 2: SortS4(True, False, PArraySG(AIndex), PArrayS4(AValue), Length(AIndex));
	end;

	for i := 0 to Db.DbItemCount - 1 do
	begin
{		TODO : j := 0;
		while True do
		begin
			if AIndex[j] = i then
				Break
			else
				Inc(j);
		end;}
		j := AIndex[i];
		Exchange(Db.DbItems[i], Db.DbItems[j], SizeOf(Db.DbItems[i]));
	end;
	SetLength(AIndex, 0);
	SetLength(AValue, 0);
	SetLength(AValueS, 0);

	Db.DbInitComboBoxItems;
	ComboBoxItems.OnChange := nil;
	ComboBoxItems.ItemIndex := Db.DbItemIndex;
	ComboBoxItems.OnChange := ComboBoxItemsChange;
	Db.DbInitPanels;
end;

procedure TfMain.OpenedFilesChangeFile(Sender: TObject);
begin
	Db.DbItemIndex := 0;
	Db.DbInitComboBoxItems;
	Db.DbInitPanels;
	Db.DbInitButtons;
	InitEnabled;
end;

function TfMain.OpenedFilesFreeFile(Sender: TObject;
	const Item: TOpenedFileItem): Boolean;
begin
	Result := True;
end;

function TfMain.OpenedFilesLoadFromFile(Sender: TObject;
	var FileName: TFileName): Boolean;
var
	CSVFile: TCSVFile;
	Line: TArrayOfString;
	Messages: TParserMessages;
begin
	if LowerCase(ExtractFileExt(FileName)) = '.csv' then
	begin
		Result := False;
		CSVFile := TCSVFile.Create(6);
		try
			if CSVFile.Open(FileName) then
			begin
				Messages := TParserMessages.Create;
				Db.SetItems(0);
				while not CSVFile.EOF do
				begin
					Line := CSVFile.ReadLine;
					if Length(Line) >= 3 then
					begin
						Db.SetItems(Db.DbItemCount + 1);
						Db.DbItems[Db.DbItemCount].Name := Line[0];
						TPlace(Db.DbItems[Db.DbItemCount].PData^).X := StrToValE(Line[1], False, MinInt, 0, MaxInt, Messages);
						TPlace(Db.DbItems[Db.DbItemCount].PData^).Y := StrToValE(Line[2], False, MinInt, 0, MaxInt, Messages);
					end;
				end;
				Messages.ShowAndClear;
				Messages.Free;
				Result := True;
			end;
		finally
			CSVFile.Free;
		end;
	end
	else
		Result := Db.LoadFromFile(FileName);
end;

function TfMain.OpenedFilesNewFile(Sender: TObject;
	const Item: TOpenedFileItem): Boolean;
begin
	AppendStr(Item.FileName, '.csv');
	Db.SetItems(0);
	Db.FileName := Item.FileName;
	Db.IsNew := True;
	Db.DbInitComboBoxItems;
	Db.DbInitPanels;
	Db.DbInitButtons;
	Result := True;
end;

function TfMain.OpenedFilesSaveToFile(Sender: TObject;
	var FileName: TFileName): Boolean;
var
	i: SG;
	s: string;
begin
	if LowerCase(ExtractFileExt(FileName)) = '.csv' then
	begin
		s := CSVRemark + 'Place' + CSVSep + 'Longitude' + CSVSep + 'Latitude' + FileSep;
		for i := 1 to Db.DbItemCount do
		begin
			s := s +
				CSVCell(Db.DbItems[i].Name) + CSVSep +
				CSVCell(FToS(TPlace(Db.DbItems[i].PData^).X, ofIO)) + CSVSep +
				CSVCell(FToS(TPlace(Db.DbItems[i].PData^).Y, ofIO)) + FileSep;
		end;
		Result := WriteStringToFile(FileName, s, False)
	end
	else
		Result := Db.SaveToFile(FileName);
end;

procedure TfMain.WMDropFiles(var Msg: TWMDropFiles);
begin
	OpenedFiles.DropFiles(Msg);
end;

end.
