// * File:     Sun\uDate.pas
// * Created:  1999-07-01
// * Modified: 2009-11-15
// * Version:  1.3.47.60
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uDate;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, uDButton, Grids, Calendar, uDForm, uDEdit;

type
	TfDate = class(TDForm)
		ComboBoxM: TComboBox;
		EditYear: TDEdit;
		Calendar1: TCalendar;
		EditDate: TDEdit;
		ButtonToday: TDButton;
		procedure FormResize(Sender: TObject);
		procedure EditYearChange(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
		procedure Calendar1Change(Sender: TObject);
		procedure ComboBoxMChange(Sender: TObject);
		procedure ButtonTodayClick(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	fDate: TfDate;

implementation

{$R *.DFM}
uses
	uDIniFile, uTypes, uInputFormat, uOutputFormat, uDictionary,
	uMain;

procedure TfDate.FormResize(Sender: TObject);
begin
	EditDate.Top := ClientHeight - EditDate.Height - 8;
	ButtonToday.Top := ClientHeight - ButtonToday.Height - 8;
	Calendar1.SetBounds(Calendar1.Left, Calendar1.Top, ClientWidth - 16, ClientHeight - 65);
end;

procedure TfDate.EditYearChange(Sender: TObject);
var
	AYear, AMonth, ADay: Word;
begin
	DecodeDate(Date, AYear, AMonth, ADay);
	CalendarYear := StrToValI(fDate.EditYear.Text, True, Low(CalendarYear), AYear, High(CalendarYear), 1);

	Calendar1.OnChange := nil;
	Calendar1.Year := ShortYear(CalendarYear);
	Calendar1.OnChange := Calendar1Change;
	fMain.DrawEditDate;
	fMain.Calculate;
	fMain.DrawDayLine;
	fMain.DrawAzimuth;
	fMain.InitEnabled;
end;

procedure TfDate.FormCreate(Sender: TObject);
var i: SG;
begin
	Dictionary.TranslateForm(Self);

	Background := baGradient;
	MainIni.RWFormPos(Self, False);
	ComboBoxM.Items.BeginUpdate;
	try
		for i := 1 to 12 do
			ComboBoxM.Items.Add(LongMonthNames[i] + ' (' + NToS(i) + ')');
	finally
		ComboBoxM.Items.EndUpdate;
	end;
end;

procedure TfDate.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	MainIni.RWFormPos(Self, True);
end;

procedure TfDate.Calendar1Change(Sender: TObject);
begin
	fMain.DrawEditDate;
	fMain.Calculate;
	fMain.DrawDayLine;
	fMain.DrawAzimuth;
	fMain.InitEnabled;
end;

procedure TfDate.ComboBoxMChange(Sender: TObject);
begin
	try
		Calendar1.OnChange := nil;
		Calendar1.Month := ComboBoxM.ItemIndex + 1;
	except
		Calendar1.Day := 28;
		Calendar1.Month := ComboBoxM.ItemIndex + 1;
	end;
	Calendar1.OnChange := Calendar1Change;
	fMain.DrawEditDate;
	fMain.Calculate;
	fMain.DrawDayLine;
	fMain.DrawAzimuth;
	fMain.InitEnabled;
end;

procedure TfDate.ButtonTodayClick(Sender: TObject);
begin
	fMain.Today1Click(Sender);
end;

procedure TfDate.FormShow(Sender: TObject);
begin
	fMain.Date2.Checked := True;
end;

procedure TfDate.FormHide(Sender: TObject);
begin
	fMain.Date2.Checked := False;
end;

end.
