// * File:     SortDemo\uMain.pas
// * Created:  1999-07-01
// * Modified: 2009-09-18
// * Version:  1.0.47.39
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	uDForm, uDImage, uDView, uDLabel, StdCtrls, Controls, ExtCtrls, uDButton,
	Classes, Windows, uDEdit, uDWinControl, Menus;

type
	TfMain = class(TDForm)
		ButtonRandomSeedIs0: TDButton;
		EditMaxP: TDEdit;
		EditMinP: TDEdit;
		LabelMin: TLabel;
		LabelMax: TLabel;
		LabelTim: TLabel;
		LabelCha: TLabel;
		LabelErr: TLabel;
		PanelErr: TDEdit;
		PanelTim: TDEdit;
		PanelCha: TDEdit;
		LabelSub: TLabel;
		PanelSub: TDEdit;
		EditRep: TDEdit;
		LabelRep: TLabel;
		EditMinV: TDEdit;
		EditMaxV: TDEdit;
		ComboBoxRandomStyle: TComboBox;
		Label1: TLabel;
		Label2: TLabel;
		Label3: TLabel;
		PanelCompared: TDEdit;
		Label4: TLabel;
		PanelStabErr: TDEdit;
		DViewData: TDView;
		DLabel1: TLabel;
		DLabel2: TLabel;
		DLabel3: TLabel;
		DLabel4: TLabel;
		BSelect: TDButton;
		BExchange: TDButton;
		BShell: TDButton;
		BHeap: TDButton;
		BQuick: TDButton;
		BInsertion: TDButton;
		BBubbleInt2: TDButton;
		BCounting: TDButton;
		BMerge: TDButton;
		BRadix: TDButton;
		BAuto: TDButton;
		BPos: TDButton;
		Bevel1: TBevel;
		LabelRandomStyle: TLabel;
		MainMenu1: TMainMenu;
		File1: TMenuItem;
		Options1: TMenuItem;
		Help1: TMenuItem;
		procedure ButtonClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure DViewDataGetData(Sender: TObject; var Data: String; ColIndex,
			RowIndex: Integer; Rect: TRect);
	private
		{ Private declarations }
		procedure RWOptions(const Save: Boolean);
	public
		{ Public declarations }
	end;

var
	fMain: TfMain;

implementation

{$R *.DFM}
uses
	MMSystem, SysUtils,
	uMath, uTypes, uFiles, uAbout, uWave, uSorts, uFind, uDIniFile, uInputFormat, uOutputFormat;

type
	TValue = S4;
	TIndex = SG;
var
	MinIndex, MaxIndex: Integer;
	AValue: array of S4;
	AIndex: array of SG;

procedure TfMain.ButtonClick(Sender: TObject);
var
	i, j: Integer;
	MaxNum: Integer;
	TotalTime, StartTime: U8;

	MinValue, MaxValue: TValue;
	Typ: Integer;
	Rep: LongWord;
	Err, StabErr: LongWord;

	SortType: SG;

	s1, s2: string;
begin
	SortType := TDButton(Sender).Tag;
	for i := 0 to ComponentCount - 1 do
	begin
		if Components[i] is TDButton then
		begin
			if TDButton(Components[i]).Tag <> SortType then
				TDButton(Components[i]).Enabled := False;
		end;
	end;
	TotalTime := 0;
	try
		Rep := StrToValI(EditRep.Text, True, Low(Rep), 1, High(Rep), 1);
		if SortType = 11 then
		begin
			SetLength(s1, 1000000);
			for i := 1 to Length(s1) do
				s1[i] := Char(Ord('a') + Random(26));
			SetLength(s2, 1000);
			for i := 1 to Length(s2) do
				s1[i] := Char(Ord('a') + Random(26));
			TotalTime := PerformanceCounter;
			for j := 1 to Rep do
			begin
//        i := Pos(s2, s1);
//				Find(s2, s1);
			end;
			TotalTime := PerformanceCounter - TotalTime;
		end
		else
		begin
			DViewData.RowCount := 0;
			if EditMinP.Text = '' then EditMinP.Text := '0';
			if EditMaxP.Text = '' then EditMaxP.Text := '0';
			if EditMinV.Text = '' then EditMinV.Text := '0';
			if EditMaxV.Text = '' then EditMaxV.Text := '0';
			MinIndex := StrToValI(EditMinP.Text, True, 0, 0, MaxInt, 1);
			MaxIndex := StrToValI(EditMaxP.Text, True, 0, 1000, MaxInt, 1);
			MinValue := StrToValI(EditMinV.Text, True, 0, 0, MaxInt, 1);
			MaxValue := StrToValI(EditMaxV.Text, True, 0, 1000, MaxInt, 1);
			SetLength(AValue, (MaxIndex - MinIndex + 1));
			SetLength(AIndex, (MaxIndex - MinIndex + 1));

			{LongInt(AV):=LongInt(AV)-99999999-MinA;
			LongInt(AP):=LongInt(AP)-99999999-MinA;}
			if ButtonRandomSeedIs0.Down then RandSeed := 0;
			Typ := ComboBoxRandomStyle.ItemIndex;

			for j := 1 to Rep do
			begin
				MaxNum := 0;
				for i := MinIndex to MaxIndex do
				begin
					case Typ of
					0: MaxNum := i;
					1: MaxNum := MaxIndex - i;
					2: if i > MinIndex then MaxNum := MaxNum + TValue(Random(2)) else MaxNum := 0;
					3: if i > MinIndex then MaxNum := MaxNum - TValue(Random(2)) else MaxNum := MaxValue;
					4: MaxNum := TValue(Random(Integer(MaxValue + 1 - MinValue))) + MinValue;
					end;
					//Dec(AV[i], 100);
					if MaxNum < MinValue then MaxNum := MinValue;
					if MaxNum > MaxValue then MaxNum := MaxValue;
					AValue[i] := MaxNum;
					AIndex[i] := i; //Random($0000ffff);
				end;
				StartTime := PerformanceCounter;
				uSorts.SortType := TSortType(SortType);
				SortS4(True, False, PArraySG(AIndex), PArrayS4(AValue), (MaxIndex - MinIndex + 1));
				uSorts.SortType := stAuto;
				TotalTime := TotalTime + PerformanceCounter - StartTime;
			end;

			{$ifopt d+}
			PanelCha.Text := NToS(SortSwaped);
			PanelCompared.Text := NToS(SortCompared);
			PanelSub.Text := NToS(SortMaxDepth);
			{$endif}

			MaxNum := MaxIndex; //if MaxNum > MinIndex + 9 then MaxNum := MinIndex + 9;
			Err := 0;
			StabErr := 0;
			for i := MinIndex to MaxIndex - 1 do
			begin
				if AValue[i] > AValue[i + 1] then
					Inc(Err)
				else if AValue[i] = AValue[i + 1] then
				begin
					if AIndex[i] > AIndex[i + 1] then
						Inc(StabErr);
				end;
			end;
			DViewData.RowCount := MaxNum;
			{LongInt(AV):=LongInt(AV)+99999999+MinA;
			LongInt(AP):=LongInt(AP)+99999999+MinA;}
			PanelErr.Text := NToS(Err);
			PanelStabErr.Text := NToS(StabErr);
		end;
	finally
		PanelTim.Text := MsToStr(RoundDivS8(1000 * TotalTime, PerformanceFrequency), diSD, 3, False);
{		SetLength(AValue, 0);
		SetLength(AIndex, 0);}
		for i := 0 to ComponentCount - 1 do
		begin
			if Components[i] is TDButton then
			begin
				TDButton(Components[i]).Enabled := True;
			end;
		end;
		PlayWinSound(wsAsterisk);
	end;
end;

procedure TfMain.RWOptions(const Save: Boolean);
const
	Section = 'Options';
begin
	MainIni.RWEdit(Section, EditMinP, Save);
	MainIni.RWEdit(Section, EditMaxP, Save);
	MainIni.RWEdit(Section, EditMinV, Save);
	MainIni.RWEdit(Section, EditMaxV, Save);
	MainIni.RWEdit(Section, EditRep, Save);
	MainIni.RWButton(Section, ButtonRandomSeedIs0, Save);
	MainIni.RWComboBox(Section, ComboBoxRandomStyle, Save);

	MainIni.RWFormPos(Self, Save);
	DViewData.Serialize(MainIni, Save);
end;

procedure TfMain.FormCreate(Sender: TObject);
begin
	Background := baGradient;
	DViewData.AddColumn('Index', 64);
	DViewData.AddColumn('Value', DViewData.Width - 64);
	DViewData.SetAllSortable(False);

	RWOptions(False);
end;

procedure TfMain.FormDestroy(Sender: TObject);
begin
	RWOptions(True);
end;

procedure TfMain.DViewDataGetData(Sender: TObject; var Data: String; ColIndex,
	RowIndex: Integer; Rect: TRect);
begin
	case ColIndex of
	0: Data := IntToStr(AIndex[RowIndex]);
	1: Data := IntToStr(AValue[RowIndex]);
	end;
end;

end.

