// * File:     SlowProc\uMain.pas
// * Created:  2000-11-22
// * Modified: 2011-02-22
// * Version:  1.2.47.24
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	uTypes, uProcess, uThreadPool, uParserMsg,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, uDButton, uDLabel, Buttons, ExtCtrls, uDForm, uDWinControl, uDEdit, Menus,
	ComCtrls, uDTimer, uSxLabel;

type
	TfMain = class(TDForm)
		ButtonRun: TDButton;
		ButtonStop: TDButton;
		cbIdleTime: TComboBox;
		cbBurnTime: TComboBox;
		cbBurnPercent: TComboBox;
		cbIdlePercent: TComboBox;
		LabelIdle: TLabel;
		LabelUsed: TLabel;
		Label2: TLabel;
		ComboBoxThreads: TComboBox;
		MainMenu1: TMainMenu;
		File1: TMenuItem;
		Options1: TMenuItem;
		Help1: TMenuItem;
		Bevel1: TBevel;
		FreezeLimit1: TMenuItem;
		TrackBarUsed: TTrackBar;
		tmr1: TTimer;
		Label1: TLabel;
		Label3: TLabel;
		RealTime1: TMenuItem;
		Prioroty1: TMenuItem;
		Normal1: TMenuItem;
		High1: TMenuItem;
		ButtonPause: TDButton;
    edCPUUsage: TDEdit;
		lblCPUUsage: TSxLabel;
		procedure ButtonRunClick(Sender: TObject);
		procedure ButtonStopClick(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure cbIdleTimeChange(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure ComboBoxThreadsChange(Sender: TObject);
		procedure FreezeLimit1Click(Sender: TObject);
		procedure TrackBarUsedChange(Sender: TObject);
		procedure cbBurnPercentChange(Sender: TObject);
		procedure cbIdlePercentChange(Sender: TObject);
		procedure tmr1Timer(Sender: TObject);
		procedure RealTime1Click(Sender: TObject);
		procedure Normal1Click(Sender: TObject);
		procedure High1Click(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure cbBurnTimeChange(Sender: TObject);
		procedure ButtonPauseClick(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
	private
		{ Private declarations }
		DisableCPUEvent: BG;
		Messages: TParserMessages;
		Process: TProcess;
		ThreadPool: TThreadPool;
		procedure RWOptions(const Save: Boolean);
		procedure Stop;
		procedure SetUsed(const Used: SG);
//		procedure Mes(var Message: TMessage); message WM_APP;
		procedure ApplicationEvents1Message(var Msg: tagMSG; var Handled: Boolean);
		procedure RatioChanged;
	public
		{ Public declarations }
	end;

var
	fMain: TfMain;

implementation

{$R *.DFM}
uses
	Math,
	uDIniFile, uAbout, uInputFormat, uSystem, uMath, uOutputFormat, uSimulation, uMsg, uNewThread, uProjectInfo, uStrings,
	uStart, uSysInfo, uGetTime, uParams;

{ MyCommand }

type
	TMyCommand = class(TCommand)
	protected
		procedure Execute; override;
	end;

const
	MaxBurnRatio = 1000;
var
	FreezeLimit: UG;

	BurnRatio: SG; // %%
	SleepTime: SG; // ms
	DelayTime: SG; // ms

	Running: BG;
	RunCount: SG;
	StartTime: U4;
	MessageTime: U8;

//procedure DelayThreadExecute(AThread: TThread);
procedure TMyCommand.Execute;
var
//	StartTime: U8;
//	IdleTime, BurnTime: U8;
	DelayTime2: U8;
	//AThread: TThread;
begin
	Inc(RunCount);
	try
//		BurnTime := DelayTime;
		while Running do //and ((FreezeLimit = 0) do //or (GetTickCount - StartTime{IntervalFrom(StartTime)} <= FreezeLimit)) do
		begin
//			SleepTime2 := Min(PerformanceFrequency, RoundDivU8(U8(SleepTime) * BurnTime, Max(1, DelayTime)));

//			StartTime := PerformanceCounter;
			Sleep(SleepTime);
//			IdleTime := TimeDifference(PerformanceCounter, StartTime);

//			DelayTime2 := Min(PerformanceFrequency, RoundDivU8(U8(DelayTime) * IdleTime, Max(1, SleepTime)));
			if BurnRatio >= MaxBurnRatio then
				DelayTime2 := PerformanceFrequency
			else
//				DelayTime2 := RoundDivU8(U8(BurnRatio) * IdleTime, MaxBurnRatio - BurnRatio);
				DelayTime2 := RoundDivU8(U8(BurnRatio) * SleepTime * PerformanceFrequency, (MaxBurnRatio - BurnRatio) * 1000);

//			StartTime := PerformanceCounter;
			DelayEx(Min(PerformanceFrequency, DelayTime2));
//			BurnTime := TimeDifference(PerformanceCounter, StartTime);

			if IntervalFrom(MessageTime) > FreezeLimit * PerformanceFrequency div Second then
				Running := False;
//      WaitFor;

{			if GetTickCount > MesTickCount then
			begin
				Application.ProcessMessages;
				MesTickCount := GetTickCount + 100;
			end;}
		end;
	finally
		Dec(RunCount);
		if RunCount = 0 then
		begin
			Thread.Synchronize(Thread, fMain.Stop);
		end;
		{$ifopt d-}
//		SetThreadPriority(GetCurrentThread, THREAD_PRIORITY_NORMAL);
//		SetPriorityClass(GetCurrentProcess, NORMAL_PRIORITY_CLASS);
		{$endif}
	end;
end;

var
	DisableWarning: BG;

const
	MaxThreadCount = 1024 * 1024;
var
	ThreadCount: SG;
const
	DefaultFreezeLimit = 5 * Second;
var
	NowThreadCount: UG;

procedure TfMain.ButtonRunClick(Sender: TObject);
var
	i: SG;
	MyCommand: TMyCommand;
begin
	Process.ProcessStatus := psRun;
	if Running then Exit;
	Running := True;
	StartTime := GetTickCount;
	NowThreadCount := ThreadCount;
	ThreadPool.MaxThreads := ThreadCount;
	for i := 0 to NowThreadCount - 1 do
	begin
//		RunInNewThread(DelayThreadExecute, {$ifopt d-}tpTimeCritical{$else}tpLowest{$endif});
		MyCommand := TMyCommand.Create;
		ThreadPool.AddCommand(MyCommand);
	end;
end;

procedure TfMain.ButtonStopClick(Sender: TObject);
begin
	Running := False;
end;

procedure TfMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	Running := False;
	RWOptions(True);
end;

procedure TfMain.cbIdleTimeChange(Sender: TObject);
begin
	RatioChanged;
end;

procedure TfMain.cbBurnTimeChange(Sender: TObject);
begin
	RatioChanged;
end;

procedure TfMain.ComboBoxThreadsChange(Sender: TObject);
begin
	Messages.Clear;
	ThreadCount := StrToValI(ComboBoxThreads.Text, True, 1, UG(1), MaxThreadCount, 1, Messages);
	SetDesign(ComboBoxThreads, Messages);

	ThreadPool.MaxThreads := ThreadCount;
end;

procedure TfMain.FreezeLimit1Click(Sender: TObject);
begin
	GetTime('Freeze Limit', FreezeLimit, 0, DefaultFreezeLimit, MaxInt, nil);
end;

procedure TfMain.RWOptions(const Save: Boolean);
const
	Section = 'Options';
begin
	MainIni.RWFormPos(Self, Save);
	MainIni.RWComboBox(Section, cbIdlePercent, Save);
	MainIni.RWComboBox(Section, cbBurnPercent, Save);
	MainIni.RWComboBox(Section, cbIdleTime, Save);
	MainIni.RWComboBox(Section, cbBurnTime, Save);

	MainIni.RWComboBox(Section, ComboBoxThreads, Save);
//	MainIni.RWBool(Section, 'DisableWarning', DisableWarning, Save);
	if Save = False then
		FreezeLimit := DefaultFreezeLimit;
	MainIni.RWNum(Section, 'Freeze Limit', FreezeLimit, Save);
end;

procedure TfMain.Stop;
begin
	Process.Abort;
end;

procedure ParamRun(const Value: string);
begin
	fMain.ButtonRunClick(nil);
end;

procedure TfMain.FormCreate(Sender: TObject);
begin
	Background := baGradient;
	Messages := TParserMessages.Create;

	RWOptions(False);
	RatioChanged;
//	ComboBoxSleep.OnChange(Self);
//	ComboBoxDelay.OnChange(Self);
//	TrackBarUsed.OnChange(Self);

	FillCPUTest(GSysInfo);
	PerformanceType := ptPerformanceCounter;
	Application.OnMessage := ApplicationEvents1Message;

	Process := TProcess.Create(Self);
	ThreadPool := TThreadPool.Create;
	ComboBoxThreads.OnChange(Self);

	RegisterParam('run', 'Slowdown processor', ParamRun);
end;

procedure TfMain.TrackBarUsedChange(Sender: TObject);
begin
	SetUsed(10 * TrackBarUsed.Position);

	cbIdlePercent.OnChange := nil;
	try
		cbIdlePercent.Text := NToS(MaxBurnRatio - BurnRatio, 1);
	finally
		cbIdlePercent.OnChange := cbIdlePercentChange;
		SetDesign(cbIdlePercent, nil);
	end;

	cbBurnPercent.OnChange := nil;
	try
		cbBurnPercent.Text := NToS(BurnRatio, 1);
	finally
		cbBurnPercent.OnChange := cbBurnPercentChange;
		SetDesign(cbBurnPercent, nil);
	end;
end;

procedure TfMain.cbBurnPercentChange(Sender: TObject);
begin
	Messages.Clear;
	SetUsed(StrToValI(cbBurnPercent.Text, True, 0, UG(MaxBurnRatio div 2), MaxBurnRatio, 10, Messages));
	SetDesign(cbBurnPercent, Messages);
	cbIdlePercent.Text := NToS(MaxBurnRatio - BurnRatio, 1);
end;

procedure TfMain.SetUsed(const Used: SG);
var
	s: Extended;
begin
	BurnRatio := Used;
	if Used >= MaxBurnRatio then
	begin
		SleepTime := 0;
	end
	else if Used <= 0 then
	begin
		SleepTime := 100; // ms
	end
	else
	begin
		SleepTime := Max(5, (MaxBurnRatio - Used) div 10);
	end;

	cbIdleTime.OnChange := nil;
	try
		cbIdleTime.Text := FToS(SleepTime / 1000, ofDisplay);
	finally
		cbIdleTime.OnChange := cbIdleTimeChange;
		SetDesign(cbIdleTime, nil);
	end;

	cbBurnTime.OnChange := nil;
	try
		if BurnRatio >= MaxBurnRatio then
			s := 1
		else
			s := 0.001 * BurnRatio * SleepTime / (MaxBurnRatio - BurnRatio);
		cbBurnTime.Text := FToS(s, ofDisplay);
	finally
		cbBurnTime.OnChange := cbIdleTimeChange;
		SetDesign(cbBurnTime, nil);
	end;

	TrackBarUsed.OnChange := nil;
	try
		TrackBarUsed.Position := RoundDiv(Used, 10);
	finally
		TrackBarUsed.OnChange := TrackBarUsedChange;
	end;
end;

procedure TfMain.cbIdlePercentChange(Sender: TObject);
begin
	Messages.Clear;
	SetUsed(MaxBurnRatio - StrToValI(cbIdlePercent.Text, True, 0, UG(MaxBurnRatio div 2), MaxBurnRatio, 10, Messages));
	SetDesign(cbIdlePercent, Messages);
	cbBurnPercent.Text := NToS(BurnRatio, 1);
end;

procedure TfMain.ApplicationEvents1Message(var Msg: tagMSG;
	var Handled: Boolean);
begin
	Handled := False;
	MessageTime := PerformanceCounter;
//	fMain.LabelFree.Caption := NToS(Second * MaxLag div PerformanceFrequency);
end;

procedure TfMain.tmr1Timer(Sender: TObject);
begin
	MessageTime := PerformanceCounter;
	try
		if DisableCPUEvent = False then
		begin
			GSysInfo.CPUUsage := GetCPUUsage;
			edCPUUsage.Text := NToS(GSysInfo.CPUUsage, 2);
		end;
	except
		on E: Exception do
		begin
			DisableCPUEvent := True;
			Fatal(E, nil);
		end;
	end;

end;

procedure TfMain.RealTime1Click(Sender: TObject);
begin
	RealTime1.Checked := True;
		if not DisableWarning then
	begin
		Warning('This option is dangerous. Please save all your work. If program or Windows do not respond please wait at least freeze limit (' + MsToStr(FreezeLimit, diMSD, 0) + ').');
		DisableWarning := True;
	end;
	SetPriorityClass(GetCurrentProcess, REALTIME_PRIORITY_CLASS);
	SetThreadPriority(GetCurrentThread, THREAD_PRIORITY_ABOVE_NORMAL);
end;

procedure TfMain.Normal1Click(Sender: TObject);
begin
	Normal1.Checked := True;
	SetPriorityClass(GetCurrentProcess, NORMAL_PRIORITY_CLASS);
	SetThreadPriority(GetCurrentThread, THREAD_PRIORITY_NORMAL);
end;

procedure TfMain.High1Click(Sender: TObject);
begin
	High1.Checked := True;
	SetPriorityClass(GetCurrentProcess, HIGH_PRIORITY_CLASS);
	SetThreadPriority(GetCurrentThread, THREAD_PRIORITY_ABOVE_NORMAL);
end;

procedure TfMain.FormShow(Sender: TObject);
begin
	High1Click(Sender);
end;

procedure TfMain.RatioChanged;
begin
	Messages.Clear;
	SleepTime := StrToValI(cbIdleTime.Text, True, 0, UG(50), Second, 1000, Messages);
	SetDesign(cbIdleTime, Messages);

	Messages.Clear;
	DelayTime := StrToValI(cbBurnTime.Text, True, 0, UG(50), Second, 1000, Messages);
	SetDesign(cbBurnTime, Messages);

	if DelayTime + SleepTime <= 0 then
	begin
		BurnRatio := 0;

		cbIdlePercent.OnChange := nil;
		try
			cbIdlePercent.Text := '';
		finally
			cbIdlePercent.OnChange := cbIdlePercentChange;
			SetDesign(cbIdlePercent, nil);
		end;

		cbBurnPercent.OnChange := nil;
		try
			cbBurnPercent.Text := '';
		finally
			cbBurnPercent.OnChange := cbBurnPercentChange;
			SetDesign(cbBurnPercent, nil);
		end;

		TrackBarUsed.OnChange := nil;
		try
			TrackBarUsed.Position := -1;
		finally
			TrackBarUsed.OnChange := TrackBarUsedChange;
		end;
	end
	else
	begin
		BurnRatio := RoundDiv(MaxBurnRatio * DelayTime, SleepTime + DelayTime);
		cbIdlePercent.OnChange := nil;
		try
			cbIdlePercent.Text := NToS(MaxBurnRatio - BurnRatio, 1);
		finally
			cbIdlePercent.OnChange := cbIdlePercentChange;
			SetDesign(cbIdlePercent, nil);
		end;
		cbBurnPercent.OnChange := nil;
		try
			cbBurnPercent.Text := NToS(BurnRatio, 1);
		finally
			cbBurnPercent.OnChange := cbBurnPercentChange;
			SetDesign(cbBurnPercent, nil);
		end;
		TrackBarUsed.OnChange := nil;
		try
			TrackBarUsed.Position := RoundDiv(BurnRatio, 10);
		finally
			TrackBarUsed.OnChange := TrackBarUsedChange;
		end;
	end;
end;

procedure TfMain.ButtonPauseClick(Sender: TObject);
begin
	if Process.ProcessStatus = psPaused then
	begin
		ThreadPool.Resume;
	end
	else
	begin
		ThreadPool.Pause;
	end;
	Process.Pause;
end;

procedure TfMain.FormDestroy(Sender: TObject);
begin
	FreeAndNil(Messages);
	FreeAndNil(Process);
	FreeAndNil(ThreadPool);
end;

end.
