// * File:     SetFileSize\SetFileSize.dpr
// * Created:  2007-08-14
// * Modified: 2009-05-13
// * Version:  1.0.47.31
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

program SetFileSize;

{$APPTYPE CONSOLE}

uses
	SysUtils,
	uTypes,
	uFile,
	uMsg,
	uInputFormat,
	uOutputFormat;

var
	F: TFile;
	FileName: TFileName;
	NewFileSize: U8;
begin
	if ParamCount <> 2 then
	begin
		Writeln('SetFileSize [Version ' + {$I version.inc} + ']');
		Writeln('Warning: Usage of this program is dangerous.');
		Writeln('         Make sure the ''FileName'' is correct.');
		Writeln('Usage: SetFileSize ''FileName'' ''NewFileSize''');
		Exit;
	end;

	FileName := ParamStr(1);
	NewFileSize := StrToSG(ParamStr(2), ifIO);

	if FileExists(FileName) then
	begin
		F := TFile.Create;
		try
			if F.Open(FileName, fmAppend) then
			begin
				F.Seek(NewFileSize);
				F.Truncate;
				Information('File %1 truncated to ' + BToStr(NewFileSize, ofIO) + '.', [FileName]);
				F.Close;
			end;
		finally
			F.Free;
		end;
	end
	else
	begin
		Warning('File %1 not found.', [FileName]);
	end;
end.
