//* File:     SDG\uSetup.pas
//* Created:  1997-01-01
//* Modified: 2005-11-06
//* Version:  2.1.35.309
//* Author:   Safranek David (Safrad)
//* E-Mail:   safrad at email.cz
//* Web:      http://safrad.webzdarma.cz

unit uSetup;

interface

uses
	uTypes,
	uEngine, uETypes,
	uDForm,
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, StdCtrls, ExtCtrls, uDButton, CheckLst;

type
	TfSetup = class(TDForm)
		ButtonSave: TDButton;
		ButtonCancel: TDButton;
		eMoveNumber: TLabeledEdit;
		cbEnPassant: TComboBox;
		eFEN: TLabeledEdit;
		ButtonClear: TDButton;
		ButtonDefault: TDButton;
		ButtonUp: TDButton;
		ButtonDown: TDButton;
		ButtonLeft: TDButton;
		ButtonRight: TDButton;
		cbSideToMove: TComboBox;
		LabelSideToMove: TLabel;
		CheckListBoxCastling: TCheckListBox;
		LabelCastling: TLabel;
		Bevel1: TBevel;
		ButtonMirrorToHorizontalLine: TDButton;
		ButtonMirrorToVerticalLine: TDButton;
		Bevel2: TBevel;
		eLongDraw: TLabeledEdit;
		Label2: TLabel;
		eMaxLongDraw: TEdit;
		ButtonSwapColors: TDButton;
		ButtonStartPosition: TDButton;
		LabelMove: TLabel;
		LabelEP: TLabel;
		cbSetupPiece: TComboBox;
		LabelPiece: TLabel;
		procedure FormCreate(Sender: TObject);
		procedure ButtonSaveClick(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure ButtonClearClick(Sender: TObject);
		procedure ButtonDefaultClick(Sender: TObject);
		procedure ButtonMirrorToVerticalLineClick(Sender: TObject);
		procedure ButtonMirrorToHorizontalLineClick(Sender: TObject);
		procedure ButtonSwapColorsClick(Sender: TObject);
		procedure ButtonStartPositionClick(Sender: TObject);
		procedure ButtonCancelClick(Sender: TObject);
		procedure eFENChange(Sender: TObject);
		procedure ButtonXClick(Sender: TObject);
		procedure CheckListBoxCastlingClickCheck(Sender: TObject);
		procedure cbSideToMoveChange(Sender: TObject);
		procedure eMoveNumberChange(Sender: TObject);
		procedure cbEnPassantChange(Sender: TObject);
		procedure eLongDrawChange(Sender: TObject);
		procedure cbSetupPieceChange(Sender: TObject);
	private
		{ Private declarations }
		DisableChange: BG;
		procedure DataToForm(Sender: TObject);
	public
		{ Public declarations }
	end;

var
	fSetup: TfSetup;

	WhereSetup: BG;

procedure DrawSetup;

procedure SetupMouseDown;
procedure SetupChangeSide;
procedure SetupSetPiece(Piece: TPiece);

implementation

{$R *.dfm}

uses
	uEHash, uEBoard, uEGen,
	uInput, uGraph, uGetInt, uError, uMath, uFormat, uStrings,
	uMain, uBoard, uMoves, uNextMove, uClock, uGame, uPGN;
var
	SetupPiece: TSquare = sqP0;
	SetupPos: TPos;

(*-------------------------------------------------------------------------*)
procedure SetupMouseDown;
begin
	if Game.CXY > 0 then
	begin
		if Game.Pos.Board[Game.CXY] <> sqOut then
		begin
			if Game.Pos.Board[Game.CXY] = sqEmpty then
			begin
				Game.Pos.Board[Game.CXY] := SetupPiece;
			end
			else
			begin
				if Game.Pos.Board[Game.CXY] > 0 then
				begin
					if Game.Pos.Board[Game.CXY] < PieceTypes then
						Inc(Game.Pos.Board[Game.CXY])
					else
						Game.Pos.Board[Game.CXY] := sqEmpty;
				end
				else
				begin
					if Game.Pos.Board[Game.CXY] > -PieceTypes then
						Dec(Game.Pos.Board[Game.CXY])
					else
						Game.Pos.Board[Game.CXY] := sqEmpty;
				end;

//        Game.Pos.Board[Game.CXY] := sqEmpty;
			end;
			if Game.Pos.Board[Game.CXY] = sqOut then FreeBoards;
		end
		else
		begin
			FreeBoards;
			Game.Pos.Board[Game.CXY] := sqEmpty;
		end;
		FillUsedSquares(Game.Pos.Board, False);
		if Assigned(fSetup) then
		begin
			fSetup.DataToForm(fMain);
		end;
	end;
end;
(*-------------------------------------------------------------------------*)
procedure SetupSave;
begin
	Game.StartTotTime[0] := 0;
	Game.StartTotTime[1] := 0;

	CopyPos(Game.Pos, Game.Variant.Pos);
{ fMain.DeleteRemainingMoves1;
	fMain.DeletePreviousMoves1;}
	FreeMoves(Game.FirstMove);
	GameLastMove := nil;
	GameNextMoves := nil;
	WhereSetup := False;
	InitSetupTags;
	InitPGN;
end;
(*-------------------------------------------------------------------------*)
procedure SetupChangeSide;
begin
	if SetupPiece <> sqEmpty then
	begin
		SetupPiece := -SetupPiece;
	end;

	if (SetupPiece = sqEmpty) or
	((SG(SetupPiece) < 0) and (Game.Pos.Side = 0)) or
	((SG(SetupPiece) > 0) and (Game.Pos.Side <> 0)) then
	begin
		Game.Pos.Side := Game.Pos.Side xor 1;
		if Assigned(fSetup) then
		begin
			fSetup.DataToForm(fMain);
		end;
	end;
end;
(*-------------------------------------------------------------------------*)
procedure SetupSetPiece(Piece: TPiece);
//var DoSome: BG;
begin
//  DoSome := False;
	if Abs(SetupPiece) <> Piece then
	begin
//    DoSome := True;
		if SetupPiece < 0 then
		begin
			SetupPiece := -Piece;
		end
		else
		begin
			SetupPiece := Piece;
		end;
	end
	else
		SetupPiece := -SetupPiece;

{ if (Game.Pos.Board[Game.CXY] <> Piece) then
	begin
		DoSome := True;
		Game.Pos.Board[Game.CXY] := SetupPiece;
	end;
	if DoSome then
	begin
		if Assigned(fSetup) then
		begin
			fSetup.Fill(nil);
		end;
	end
	else
	begin
		PlayASound(sndWarning);
	end;}
end;
(*-------------------------------------------------------------------------*)
procedure DrawSetup;
begin
	if FormDraw(fSetup) then
		fSetup.DataToForm(nil);
end;

var
	EPSquares: array[0..2 * BoardX - 1] of TEP;
	EPSquareCount: SG;

function TestSquare(Sq: TSquare; Player: U1): BG;
begin
	Result := (Sq <> sqEmpty) and (Sq <> sqOut) and (Sq = TSquare(1 - S1(2 * Player)));
end;

procedure TfSetup.DataToForm(Sender: TObject);
var
	i, j: SG;
	SqD, SqD1: SG;
begin
	DisableChange := True;
{ B := Kinds.Count > 0;
	SetControlEnabled(Self, B);}
	cbEnPassant.Enabled := GameType = gtCastleAndEP;
	LabelCastling.Enabled := GameType = gtCastleAndEP;
	CheckListBoxCastling.Enabled := GameType = gtCastleAndEP;

	if Sender <> nil then
	begin
		if WhereSetup = False then
		begin
			WhereSetup := True;
			SetupPos := Game.Pos;
//      CopyPos(Game.Pos, SetupPos);
		end;
	end;

	if Sender <> eFEN then
	begin
		eFEN.OnChange := nil;
		if Kinds.Count > 0 then
			eFEN.Text := PosToString(@Game.Pos, @Game)
		else
			eFEN.Text := '';
		eFEN.OnChange := eFENChange;
	end;

	if Kinds.Count <= 0 then
	begin
		cbSideToMove.Items.Clear;
		eMoveNumber.Text := '';
		cbEnPassant.Items.Clear;
		cbEnPassant.ItemIndex := -1;
		CheckListBoxCastling.Checked[0] := False;
		CheckListBoxCastling.Checked[1] := False;
		CheckListBoxCastling.Checked[2] := False;
		CheckListBoxCastling.Checked[3] := False;

		eLongDraw.Text := '';
		eMaxLongDraw.Text := '';
	end
	else
	begin
		if Sender <> cbSideToMove then
		begin
			cbSideToMove.Items.BeginUpdate;
			cbSideToMove.Items.Clear;
			for i := 0 to PlayerMax do
			begin
				cbSideToMove.Items.Add(SideToS[GameType, i])
			end;
			cbSideToMove.Items.EndUpdate;
			cbSideToMove.ItemIndex := Game.Pos.Side;
		end;
		if Sender <> eMoveNumber then
		begin
			eMoveNumber.OnChange := nil;
			eMoveNumber.Text := NToS((Game.Pos.MoveIndex) div 2 + 1);
			eMoveNumber.OnChange := eMoveNumberChange;
		end;
		if GameType = gtCastleAndEP then
		begin
			if Sender <> cbEnPassant then
			begin
				// Init EP squares
				EPSquareCount := 0;
				for i := 0 to UsedSquareCount - 1 do
				begin
					SqD := UsedSquares[i];
					if (DoubleSquares[SqD] = -1 + S1(2 * Game.Pos.Side)) and (Game.Pos.Board[SqD] = sqEmpty) then
					begin // double square must be free (last move could be double)
						Inc(SqD, Offsets[Game.Pos.Side][odD]);
						if (Game.Pos.Board[SqD] = sqEmpty) then
						begin
							SqD1 := SqD;
							Inc(SqD, Offsets[Game.Pos.Side][odD]);
							if (Game.Pos.Board[SqD] = -1 + S1(2 * Game.Pos.Side)) then
							begin // opponent pawn beside found
								Inc(SqD, Offsets[Game.Pos.Side][odL]);
								for j := 0 to 1 do // try left and right ep
								begin
									if TestSquare(Game.Pos.Board[SqD], Game.Pos.Side) then // my pawn can make ep
									begin
										EPSquares[EPSquareCount] := SqD1;
										Inc(EPSquareCount);
										Break;
									end;
									Inc(SqD, 2 * Offsets[Game.Pos.Side][odR]);
								end;
							end;
						end;
					end;
				end;

				cbEnPassant.OnChange := nil;
				cbEnPassant.Items.BeginUpdate;
				cbEnPassant.Items.Clear;
				cbEnPassant.Items.Add('None');
				cbEnPassant.ItemIndex := 0;
				for i := 0 to EPSquareCount - 1 do
				begin
					cbEnPassant.Items.Add(SquareToS(EPSquares[i], True, GetNotation(ntDefault)));
					if EPSquares[i] = Game.Pos.EP then cbEnPassant.ItemIndex := i + 1;
				end;
				cbEnPassant.Items.EndUpdate;
				cbEnPassant.OnChange := cbEnPassantChange;
			end;
			if Sender <> CheckListBoxCastling then
				if (GameType = gtCastleAndEP) then
				begin
					CheckListBoxCastling.OnClickCheck := nil;
					CheckListBoxCastling.ItemEnabled[0] := (Game.Pos.Board[CastleR[0, caK]] = sqR0) and (Game.Pos.Board[CastleK[0]] = sqK0);
					CheckListBoxCastling.ItemEnabled[1] := (Game.Pos.Board[CastleR[0, caQ]] = sqR0) and (Game.Pos.Board[CastleK[0]] = sqK0);
					CheckListBoxCastling.ItemEnabled[2] := (Game.Pos.Board[CastleR[1, caK]] = sqR1) and (Game.Pos.Board[CastleK[1]] = sqK1);
					CheckListBoxCastling.ItemEnabled[3] := (Game.Pos.Board[CastleR[1, caQ]] = sqR1) and (Game.Pos.Board[CastleK[1]] = sqK1);
					if CheckListBoxCastling.ItemEnabled[0] then
						CheckListBoxCastling.Checked[0] := Game.Pos.Castles[0, caK];
					if CheckListBoxCastling.ItemEnabled[1] then
						CheckListBoxCastling.Checked[1] := Game.Pos.Castles[0, caQ];
					if CheckListBoxCastling.ItemEnabled[2] then
						CheckListBoxCastling.Checked[2] := Game.Pos.Castles[1, caK];
					if CheckListBoxCastling.ItemEnabled[3] then
						CheckListBoxCastling.Checked[3] := Game.Pos.Castles[1, caQ];
					CheckListBoxCastling.OnClickCheck := CheckListBoxCastlingClickCheck;
				end;
		end;

		if Sender <> eLongDraw then
		begin
			eLongDraw.OnChange := nil;
			eLongDraw.Text := NToS(Game.Pos.LongDraw);
			eLongDraw.OnChange := eLongDrawChange;
		end;
		if Sender <> eMaxLongDraw then
		begin
			eMaxLongDraw.Text := NToS(ConstLongDraw);
		end;

		ButtonClear.Enabled := not CompareBoard(ClearBoard, Game.Pos.Board);
		ButtonClear.Down := not ButtonClear.Enabled;
		if WhereSetup then
		begin
			ButtonDefault.Enabled := not ComparePos(SetupPos, Game.Pos);
			ButtonStartPosition.Enabled := not ComparePos(StartPos, Game.Pos);
		end
		else
		begin
			ButtonDefault.Enabled := False;
			ButtonStartPosition.Enabled := False;
		end;

		ButtonDefault.Down := not ButtonDefault.Enabled;
		ButtonStartPosition.Down := not ButtonStartPosition.Enabled;

		if Sender <> cbSetupPiece then
		begin
			cbSetupPiece.Items.BeginUpdate;
			cbSetupPiece.Items.Clear;
			for i := 0 to PieceTypes - 1 do
				cbSetupPiece.Items.Add(PieceToS(TSquare(i + 1), False));
			cbSetupPiece.Items.Add('Out');
			cbSetupPiece.ItemIndex := Abs(SetupPiece) - 1;
			cbSetupPiece.Items.EndUpdate;
		end;

		if Sender <> nil then
		begin
			Game.Pos.Castles[0, caK] := Game.Pos.Castles[0, caK] and (Game.Pos.Board[CastleR[0, caK]] = sqR0) and (Game.Pos.Board[CastleK[0]] = sqK0);
			Game.Pos.Castles[0, caQ] := Game.Pos.Castles[0, caQ] and  (Game.Pos.Board[CastleR[0, caQ]] = sqR0) and (Game.Pos.Board[CastleK[0]] = sqK0);
			Game.Pos.Castles[1, caK] := Game.Pos.Castles[1, caK] and  (Game.Pos.Board[CastleR[1, caK]] = sqR1) and (Game.Pos.Board[CastleK[1]] = sqK1);
			Game.Pos.Castles[1, caQ] := Game.Pos.Castles[1, caQ] and (Game.Pos.Board[CastleR[1, caQ]] = sqR1) and (Game.Pos.Board[CastleK[1]] = sqK1);

			ResetDHash(Game.Pos);
			InitMoves;
			UpdateBoards;
			DrawBoards;
			DrawEnabledMoves;
		end;
	end;
	DisableChange := False;
end;

procedure TfSetup.FormCreate(Sender: TObject);
begin
	Background := baGradient;
	DataToForm(nil);
end;

procedure TfSetup.ButtonSaveClick(Sender: TObject);
begin
	SetupSave;
//  Close;
end;

procedure TfSetup.FormShow(Sender: TObject);
begin
	fMain.PositionSetup2.Checked := True;
end;

procedure TfSetup.FormHide(Sender: TObject);
begin
	fMain.PositionSetup2.Checked := False;
end;

procedure TfSetup.ButtonClearClick(Sender: TObject);
begin
	CopyBoard(ClearBoard, Game.Pos.Board);
	DataToForm(Sender);
end;

procedure TfSetup.ButtonDefaultClick(Sender: TObject);
begin
	WhereSetup := False;
	CopyPos(SetupPos, Game.Pos);
	DataToForm(Sender);
end;

procedure TfSetup.ButtonMirrorToVerticalLineClick(Sender: TObject);
var
	Index, IndexM: SG;
	x, y: SG;
begin
	for y := 0 to SqY do
	for x := 0 to SqX div 2 do
	begin
		Index := XYToI(x, y);
		IndexM := XYToI(SqX - x, y);
		if (Index = 0) or (IndexM = 0) then Continue;
		Exchange(U1(Game.Pos.Board[Index]), U1(Game.Pos.Board[IndexM]));
	end;
	if Game.Pos.EP <> 0 then
	begin
		IToXY(Game.Pos.EP, x, y);
		x := SqX - x;
		Game.Pos.EP := XYToI(x, y);
	end;

{ for i := 0 to (UsedSquareCount div 2) - 1 do
	begin
		Index := UsedSquares[i];
		IndexM := UsedSquares[UsedSquareCount - 1 - i];
		if Game.Pos.Board[Index] <> Game.Pos.Board[IndexM] then
		begin
			Exchange(U1(Game.Pos.Board[Index]), U1(Game.Pos.Board[IndexM]));
		end;
	end;}
	DataToForm(Sender);
end;

procedure TfSetup.ButtonMirrorToHorizontalLineClick(Sender: TObject);
var
	i, j: SG;
begin
	for i := 0 to (UsedSquareCount div 2) - 1 do
	begin
		case GameType of
		gtDraughts: j := UsedSquareCount div 2 + i;
		else j := UsedSquareCount - 1 - i;
		end;
		Exchange(U1(Game.Pos.Board[UsedSquares[i]]), U1(Game.Pos.Board[UsedSquares[j]]));
	end;
	if Game.Pos.EP <> 0 then
	begin
		Game.Pos.EP := 0;
	end;
	DataToForm(Sender);
end;

procedure TfSetup.ButtonSwapColorsClick(Sender: TObject);
var i: SG;
begin
	for i := 0 to UsedSquareCount - 1 do
	begin
		if Game.Pos.Board[UsedSquares[i]] <> sqEmpty then
		begin
			Game.Pos.Board[UsedSquares[i]] := -Game.Pos.Board[UsedSquares[i]];
		end;
	end;
	Game.Pos.EP := 0;
	DataToForm(Sender);
end;

procedure TfSetup.ButtonStartPositionClick(Sender: TObject);
begin
	CopyPos(StartPos, Game.Pos);
	DataToForm(Sender);
end;

procedure TfSetup.ButtonCancelClick(Sender: TObject);
begin
//  GoToMoveDraw(MaxInt);
	Close;
end;

procedure TfSetup.eFENChange(Sender: TObject);
var
	InLineIndex: SG;
begin
	InLineIndex := 1;
	eFEN.Hint := DelEndSpaceF(FENStrToGame(eFEN.Text, InLineIndex));

	CopyPos(Game.Variant.Pos, Game.Pos);

	DataToForm(Sender);
end;

procedure TfSetup.ButtonXClick(Sender: TObject);
var
	x, y, x2, y2: SG;
	DX, DY: SG;
	B: TBoard;
begin
	DX := 0;
	DY := 1;
	Rotate(DX, DY, 0, 0, TComponent(Sender).Tag);
	if GameType = gtDraughts then
	begin
		DX := DX * 2;
		DY := DY * 2;
	end;
	CopyBoard(Game.Pos.Board, B);
	for y := 0 to SqY do
	for x := 0 to SqX do
	begin
		x2 := UnsignedMod((x + DX), SqXC);
		y2 := UnsignedMod((y + DY), SqYC);
		Game.Pos.Board[XYToI(x, y)] := B[XYToI(x2, y2)];
	end;
	DataToForm(Sender);
end;

procedure TfSetup.CheckListBoxCastlingClickCheck(Sender: TObject);
begin
	if (GameType = gtCastleAndEP) then
	begin
		Game.Pos.Castles[0, caK] := CheckListBoxCastling.Checked[0] and CheckListBoxCastling.ItemEnabled[0];
		Game.Pos.Castles[0, caQ] := CheckListBoxCastling.Checked[1] and CheckListBoxCastling.ItemEnabled[1];
		Game.Pos.Castles[1, caK] := CheckListBoxCastling.Checked[2] and CheckListBoxCastling.ItemEnabled[2];
		Game.Pos.Castles[1, caQ] := CheckListBoxCastling.Checked[3] and CheckListBoxCastling.ItemEnabled[3];
	end;
	DataToForm(Sender);
end;

procedure TfSetup.cbSideToMoveChange(Sender: TObject);
begin
	Game.Pos.Side := cbSideToMove.ItemIndex;

	DataToForm(Sender);
end;

procedure TfSetup.eMoveNumberChange(Sender: TObject);
begin
	Game.Pos.MoveIndex := PlayerMax * (StrToValI(eMoveNumber.Text, True, 0, SG(Game.Variant.Pos.MoveIndex) div 2 + 1, MaxInt, 1) - 1);

	DataToForm(Sender);
end;

procedure TfSetup.cbEnPassantChange(Sender: TObject);
begin
	if cbEnPassant.ItemIndex <= 0 then
		Game.Pos.EP := 0
	else
		Game.Pos.EP := EPSquares[cbEnPassant.ItemIndex - 1];

	DataToForm(Sender);
end;

procedure TfSetup.eLongDrawChange(Sender: TObject);
begin
	Game.Pos.LongDraw := StrToValI(eLongDraw.Text, True, 0, 0, MaxInt, 1);

	DataToForm(Sender);
end;

procedure TfSetup.cbSetupPieceChange(Sender: TObject);
begin
	if cbSetupPiece.ItemIndex >= PieceTypes then
		SetupPiece := sqOut
	else
		SetupPiece := TSquare(cbSetupPiece.ItemIndex + 1);

	DataToForm(Sender);
end;

end.