//* File:     SDG\uNextMove.pas
//* Created:  1997-01-01
//* Modified: 2005-10-28
//* Version:  2.1.35.309
//* Author:   Safranek David (Safrad)
//* E-Mail:   safrad at email.cz
//* Web:      http://safrad.webzdarma.cz

unit uNextMove;

interface

uses
	uTypes, uDForm,
	uEngine,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, CheckLst, uDButton, uDLabel, Menus, uDImage, uDView;

type
	TfNextMove = class(TDForm)
		ButtonSelectAll: TDButton;
		ButtonDeselectAll: TDButton;
		ButtonInvert: TDButton;
		EditTotal: TDLabel;
		EditMoves: TDLabel;
		PopupMenuMoveList: TPopupMenu;
		DViewMoveList: TDView;
		ComboBoxECO: TComboBox;
		LabelTotal: TDLabel;
		ComboBoxGameECO: TComboBox;
		EditMaterial: TDLabel;
		LabelMaterial: TDLabel;
		EditActivity: TDLabel;
		LabelActivity: TDLabel;
		procedure ButtonSelectAllClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure FormResize(Sender: TObject);
		procedure DViewMoveListDblClick(Sender: TObject);
		procedure DViewMoveListMouseDown(Sender: TObject; Button: TMouseButton;
			Shift: TShiftState; X, Y: Integer);
		procedure DViewMoveListGetData(Sender: TObject; var Data: String; ColIndex,
			RowIndex: Integer; Rect: TRect);
		procedure DViewMoveListColumnClick(Sender: TObject; Column: TColumn);
	private
		FontHei: SG;
//    MoveIndex: SG;
		procedure InitButtons;
	public

	end;

var
	fNextMove: TfNextMove;
	ShowECO, ShowGameECO: BG;

function GetDisabledMoves: SG;
procedure DrawEnabledMoves;
procedure DrawNextBestMoves;

implementation

{$R *.dfm}
uses
	uDBitmap, uDIni, uStrings, uGraph, uSorts, uError, uFormat, uMath,
	uETypes, uEBoard, uEGen, uESearch,
	uGame, uMain, uAnalys, uSetup, uEBook;

function GetDisabledMoves: SG;
var i: SG;
begin
	Result := 0;
	for i := 0 to OMC - 1 do
	begin
		if MoveInfos[i].Disabled then
			Inc(Result);
	end;
end;

procedure DrawNextBestMoves;
begin
	if FormDraw(fNextMove) then
	begin
		fNextMove.DViewMoveList.RowCount := OMC;
		fNextMove.DViewMoveList.ActualRow := -1;
		fNextMove.DViewMoveList.SelectAll;
		fNextMove.DViewMoveList.SelectInvert;
		fNextMove.DViewMoveList.DataChanged;
		fNextMove.DViewMoveList.Fill;
	end;
end;

function BookToStr(const BookIndex: SG): string;
begin
	if (BookIndex < 0) or (BookIndex >= BookNameCount) then
		Result := ''
	else
	begin
		Result := BookNames[BookIndex].ECO + ' - ' + BookNames[BookIndex].Opening;
		if BookNames[BookIndex].Variation <> '' then
			Result := Result + ' (' + BookNames[BookIndex].Variation + ')';
	end;
end;

function BalanceToS(Scores: TScores): string;
var Score: TScore;
begin
	Score := Scores[0] - Scores[1];
	if ScoreForFirstPlayer and (Game.Pos.Side > 0) then Exchange(Scores[0], Scores[1]);
	Result :=
		ScoreToStr(Score, Game.Pos.Side, sfGUI, OStatus.ScoreBound) + ' = ' +
		ScoreToStr(Scores[0], 0, sfGUI, sbExact) + ' ' + #$96 + ' ' +
		ScoreToStr(Scores[1], 0, sfGUI, sbExact);
end;

procedure DrawEnabledMoves;
var
	i: SG;
	s: string;
	BHash: PBHashPos;
begin
	if FormDraw(fNextMove) then
	begin
{   s := s+ PosToString(Game.Pos) + ', ' +
			SideToS[GameType, Game.Pos.Side] + ' to Move' + ', ' +
			'Long Draw: ' + NToS(Game.Pos.LongDraw) + ' / ' + NToS(ConstLongDraw) + ', ';
		s := s + 'Position Repetition: ' + NToS(OFindDHash) + ' / ' + NToS(ConstPosRep[GameType]) + LineSep;
		if (GameType = gtChess) then
		begin
			if Game.Pos.EP <> 0 then s := s + 'EP: ' + SquareToStr(Game.Pos.EP, True) + ', '
			else s := s + 'EP: -, ';
			if Game.Pos.Castles[Game.Pos.Side, caK] then s := s + 'O-O, ';
			if Game.Pos.Castles[Game.Pos.Side, caQ] then s := s + 'O-O-O, ';
		end;}
		fNextMove.EditTotal.Caption := BalanceToS(OTotal);
		fNextMove.EditMaterial.Caption := BalanceToS(OMaterial);
		fNextMove.EditActivity.Caption := BalanceToS(OActivity);
		{$ifopt d+}
		s := '';
		s := s + VariantionCutToStr(OStatus.VariantionCut);
		s := s + ', ' + GameTerminationStr[VariantionCutToTermination(OStatus.VariantionCut)];
		s := s + '..' + IntToStr(OStatus.MoveCount);

			s := s + ', HashI: ' + NToS(Game.Pos.Hash.Index{ and MaxDHash}) + ' HashC: ' + NToS(Game.Pos.Hash.Code);
//    s := s + ', Hash Found: ' + NToS(OFindDHash);
		fNextMove.Caption := s;
		{$endif}

		fNextMove.ComboBoxGameECO.Items.BeginUpdate;
		fNextMove.ComboBoxGameECO.Clear;
		fNextMove.ComboBoxECO.Items.BeginUpdate;
		fNextMove.ComboBoxECO.Clear;
		if GameSupportECO and ((ShowECO) or (ShowGameECO)) and (BHashTable <> nil) then
		begin
			if ShowGameECO then
			begin
				if Game.ECO > 0 then
				begin
					fNextMove.ComboBoxGameECO.Items.Add(BookToStr(Game.ECO - 1));
					fNextMove.ComboBoxGameECO.ItemIndex := 0;
				end;
			end;
			if ShowECO then
			begin
				BHash := FindBHash(Game.Pos.Hash);
				if BHash <> nil then
				begin
	//        s := s + 'Opening: ';
					for i := BHash.OpeningNameIndexFrom to BHash.OpeningNameIndexTo do
						fNextMove.ComboBoxECO.Items.Add(
							BookToStr(i - 1));
				end;
				fNextMove.ComboBoxECO.ItemIndex := fNextMove.ComboBoxECO.Items.Count - 1;
			end;
		end
		else
		begin

		end;
		fNextMove.ComboBoxECO.Items.EndUpdate;
		fNextMove.ComboBoxGameECO.Items.EndUpdate;
		DrawNextBestMoves;
		fNextMove.InitButtons;
	end;
end;

// TfNextMove

procedure TfNextMove.ButtonSelectAllClick(Sender: TObject);
var i: SG;
begin
	for i := 0 to OMC - 1 do
	begin
		case TDButton(Sender).Tag of
		0: MoveInfos[i].Disabled := False;
		1: MoveInfos[i].Disabled := True;
		2: MoveInfos[i].Disabled := not MoveInfos[i].Disabled;
		end;
	end;
	DrawNextBestMoves;
	InitButtons;
end;

procedure TfNextMove.FormCreate(Sender: TObject);
begin
//  Background := baStandard;
	FontHei := DViewMoveList.Bitmap.Canvas.TextHeight('W');
	MainIni.RWFormPos(Self, False);

	DViewMoveList.ColumnCount := 5;
	DViewMoveList.Columns[0].Caption := 'Status';
	DViewMoveList.Columns[0].Click := True;
	DViewMoveList.Columns[0].Width := DViewMoveList.Bitmap.Canvas.TextWidth('*am') + CellBorder;
	DViewMoveList.Columns[1].Caption := 'Book';
	DViewMoveList.Columns[1].Click := True;
	DViewMoveList.Columns[1].Width := DViewMoveList.Bitmap.Canvas.TextWidth('1 152') + CellBorder;
	DViewMoveList.Columns[1].Alignment := taRightJustify;
	DViewMoveList.Columns[2].Caption := 'Move';
	DViewMoveList.Columns[2].Click := True;
	DViewMoveList.Columns[2].Width := 2 * DViewMoveList.Bitmap.Canvas.TextWidth(' c7xd8/Q+') + CellBorder;
	DViewMoveList.Columns[3].Caption := 'Score';
	DViewMoveList.Columns[3].Click := True;
	DViewMoveList.Columns[3].Alignment := taRightJustify;
	DViewMoveList.Columns[3].Width := DViewMoveList.Bitmap.Canvas.TextWidth('>= 255.25 / 60') + CellBorder;
	DViewMoveList.Columns[4].Caption := 'Priority';
	DViewMoveList.Columns[4].Click := True;
	DViewMoveList.Columns[4].Alignment := taRightJustify;
	DViewMoveList.Columns[4].Width := DViewMoveList.Bitmap.Canvas.TextWidth('255') + CellBorder;
	DViewMoveList.SortBy := 2;

	MainIni.RWDView(DViewMoveList, False);
	DViewMoveList.ChangeColumns;
end;

procedure TfNextMove.FormShow(Sender: TObject);
begin
	fMain.List2.Checked := True;
	DrawEnabledMoves;
end;

procedure TfNextMove.FormHide(Sender: TObject);
begin
	fMain.List2.Checked := False;
end;

procedure TfNextMove.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	MainIni.RWFormPos(Self, True);
	MainIni.RWDView(DViewMoveList, True);
end;

procedure TfNextMove.FormResize(Sender: TObject);
var w: SG;
begin
//  DLabelMoves.Width := ClientWidth;

	w := ClientWidth - EditMoves.Width;
//  ButtonSelectAll.Top := ClientHeight - FormBorder - ButtonSelectAll.Height;
	ButtonSelectAll.Width := w div 3;
	ButtonDeselectAll.SetBounds(ButtonSelectAll.Left + ButtonSelectAll.Width, ButtonDeselectAll.Top, w div 3, ButtonSelectAll.Height);
	ButtonInvert.SetBounds(ButtonDeselectAll.Left + ButtonDeselectAll.Width, ButtonInvert.Top, ClientWidth - ButtonInvert.Left, ButtonInvert.Height);

	{ ButtonSelectAll.Top := ClientHeight - FormBorder - ButtonSelectAll.Height;
	ButtonDeselectAll.Top := ButtonSelectAll.Top;
	ButtonInvert.Top := ButtonSelectAll.Top;}

//  DLabelInfo.Top := ClientHeight - ComboBoxECO.Height - DLabelInfo.Height;//ButtonSelectAll.Top - DLabelInfo.Height - FormBorder;

	LabelTotal.Top := ClientHeight - ComboBoxECO.Height - ComboBoxGameECO.Height - 3 * EditTotal.Height;
	EditTotal.SetBounds(EditTotal.Left, LabelTotal.Top, ClientWidth - LabelTotal.Width, EditTotal.Height);

	LabelMaterial.Top := ClientHeight - ComboBoxECO.Height - ComboBoxGameECO.Height - 2 * EditTotal.Height;
	EditMaterial.SetBounds(EditMaterial.Left, LabelMaterial.Top, ClientWidth - LabelMaterial.Width, EditMaterial.Height);

	LabelActivity.Top := ClientHeight - ComboBoxECO.Height - ComboBoxGameECO.Height - EditTotal.Height;
	EditActivity.SetBounds(EditActivity.Left, LabelActivity.Top, ClientWidth - LabelActivity.Width, EditActivity.Height);

	ComboBoxGameECO.SetBounds(ComboBoxGameECO.Left, ClientHeight - ComboBoxGameECO.Height - ComboBoxECO.Height, ClientWidth, ComboBoxGameECO.Height);
	ComboBoxECO.SetBounds(ComboBoxECO.Left, ClientHeight - ComboBoxECO.Height, ClientWidth, ComboBoxECO.Height);

	DViewMoveList.SetBounds(DViewMoveList.Left, DViewMoveList.Top, ClientWidth, EditTotal.Top - DViewMoveList.Top);
	//  DLabelMoves.Top := ButtonSelectAll.Top - FormBorder - DLabelInfo.Height;
end;

procedure TfNextMove.InitButtons;
var
	s: string;
begin
	if OStatus.VariantionCut = vcNone then
	begin
		s := NToS(OMC - GetDisabledMoves) + ' / ' + NToS(OMC);
		s := s + ' move';
		if OMC > 1 then s := s + 's';
	end
	else
	begin
		s := VariantionCutToStr(OStatus.VariantionCut);
	end;
	EditMoves.Caption := s;

	ButtonSelectAll.Enabled := GetDisabledMoves <> 0;
	ButtonDeselectAll.Enabled := OMC <> GetDisabledMoves;
	ButtonInvert.Enabled := OMC > 0;
end;

procedure TfNextMove.DViewMoveListDblClick(Sender: TObject);
begin
	if DViewMoveList.Where in [vaRow] then
		if DViewMoveList.ActualRow >= 0 then
			DoImportMove(DViewMoveList.RowOrder[DViewMoveList.ActualRow], False);
end;

procedure TfNextMove.DViewMoveListMouseDown(Sender: TObject; Button: TMouseButton;
	Shift: TShiftState; X, Y: Integer);
var i, j: SG;
begin
	if Button = mbRight then
	begin
		for i := 0 to OMC - 1 do
		begin
			if DViewMoveList.SelRows[i] then
			begin
				j := DViewMoveList.RowOrder[i];
				MoveInfos[j].Disabled := not MoveInfos[j].Disabled;
			end;
		end;
		DrawNextBestMoves;
		InitButtons;
	end;
end;

procedure TfNextMove.DViewMoveListGetData(Sender: TObject; var Data: String;
	ColIndex, RowIndex: Integer; Rect: TRect);
var
	i: SG;
	s: string;
	LFCMove: PMove;
	HPos: TPos;
begin
	i := RowIndex;
	if Kinds.Count = 0 then Exit;
	if MoveInfos[i].Disabled then
	begin
		DViewMoveList.Bitmap.Canvas.Font.Style := [fsStrikeOut];
	end
	else
		DViewMoveList.Bitmap.Canvas.Font.Style := [];
{ if MoveInfos[i].Enabled = False then
	begin
//        Bmp.Line(2, GY + FontHei div 2, GX - 2, GY + FontHei div 2, clWindowText, ef16);
		Bmp.Bar(0, GY, GX, GY + FontHei - 1, clWindow, ef08);
	end;}
	if i >= OMC then
	begin
		{$ifopt d+}IE('MoveList');{$endif}
		Exit;
	end;
	case ColIndex of
	0:
	begin
		if MoveInfos[i].EV and 1 <> 0 then s := '*' else s := '';
		if MoveInfos[i].EV and 2 <> 0 then s := s + 'a';
		if MoveInfos[i].EV and 4 <> 0 then s := s + 'm';
		if MoveInfos[i].EV and 8 <> 0 then s := s + 'b';
{   if s <> '' then
			DView.Bitmap.Canvas.TextOut(Rect.Left, Rect.Top, s);}
		Data := s;
	end;
	1:
	begin
		if MoveInfos[i].BookCount <> 0 then
			Data := NToS(MoveInfos[i].BookCount)
		else
			Data := '';
	end;
	2:
	begin
		CopyPos(CPos, HPos);
		CopyPos(Game.Pos, CPos);
		LFCMove := FCMove;
		FCMove := PMove(@OMove);

		DViewMoveList.Bitmap.Canvas.Brush.Style := bsClear;
		if i = MX[1] then
		begin
//      DViewM.Bitmap.Canvas.Brush.Color := clHighlight;
//      DViewM.Bitmap.Canvas.Font.Color := clWhite;
			DViewMoveList.Bitmap.Canvas.Brush.Style := bsClear;
			DViewMoveList.Bitmap.Bar(Rect.Left, Rect.Top, Rect.Right - 1, Rect.Bottom - 1, clHighlight, ef08);
		end;
		Inc(Rect.Left);
		CMC := OMC;
		MoveToBmp(DViewMoveList.Bitmap, Rect.Left, Rect.Top, Pointer(SG(@OMove) + i shl ShlTMove), True, True);
		Data := '';
		FCMove := LFCMove;
		CopyPos(HPos, CPos);
	end;
	3:
	begin
		if MoveInfos[i].Depth = 0 then
			Data := ''
		else
			Data := {$ifopt d+}VariantionCutToStr(MoveInfos[i].VariantionCut) + ' ' + {$endif}ScoreToStr(MoveInfosScore[i], Game.Pos.Side, sfGUI, MoveInfos[i].ScoreBound) + ' / ' + NToS(MoveInfos[i].Depth);

	end;
	4:
		Data := NToS(PMove(SG(@OMove) + i shl ShlTMove).Prior);
	end;
end;

procedure TfNextMove.DViewMoveListColumnClick(Sender: TObject; Column: TColumn);
var
	i: SG;
	SortD: array of S4;
begin
	if DViewMoveList.RowCount = 0 then Exit;
	if (DViewMoveList.SortBy = -1) then
	begin
		for i := 0 to DViewMoveList.RowCount - 1 do
			DViewMoveList.RowOrder[i] := i;
	end
	else
	begin
		if DViewMoveList.SortBy in [2, 3] then
		begin
			for i := 0 to DViewMoveList.RowCount - 1 do
				DViewMoveList.RowOrder[i] := MovesOrder[i];
		end
		else
		begin
			for i := 0 to DViewMoveList.RowCount - 1 do
				DViewMoveList.RowOrder[i] := i;
		end;
		SetLength(SortD, DViewMoveList.RowCount);
//    Caption := IntToStr(DViewM.RowCount);
		for i := 0 to DViewMoveList.RowCount - 1 do
		begin
			case DViewMoveList.SortBy of
			0:
			begin
				SortD[i] := -MoveInfos[i].EV;
			end;
			1:
			begin
				SortD[i] := -MoveInfos[i].BookCount;
			end;
			3:
			begin
				SortD[i] := -MoveInfosScore[DViewMoveList.RowOrder[i]];
			end;
			4:
			begin
				SortD[i] := -PMove(SG(@OMove) + i shl ShlTMove).Prior;
			end;
			end;
		end;
		if DViewMoveList.SortBy <> 2 then
			SortS4(True, False, PArraySG(@DViewMoveList.RowOrder[0]), PArrayS4(@SortD[0]), DViewMoveList.RowCount);
		SetLength(SortD, 0);
	end;
end;

end.