//* File:     SDG\uEngineP.pas
//* Created:  2005-09-25
//* Modified: 2005-09-25
//* Version:  2.1.35.309
//* Author:   Safranek David (Safrad)
//* E-Mail:   safrad at email.cz
//* Web:      http://safrad.webzdarma.cz

unit uEngineP;

interface

uses
	uTypes, uDForm, uDIni,
	uGame, uEngine,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, ExtCtrls, uDButton;

type
	TfEngineP = class(TDForm)
		ButtonOk: TDButton;
		ButtonCancel: TDButton;
		ButtonDefault: TDButton;
		Bevel1: TBevel;
		ButtonApply: TDButton;
	procedure EditChange(Sender: TObject);
		procedure ButtonCancelClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure ButtonOkClick(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure ButtonDefaultClick(Sender: TObject);
		procedure FormResize(Sender: TObject);
		procedure ButtonApplyClick(Sender: TObject);
	private
		{ Private declarations }
		procedure ButtonXClick(Sender: TObject);
		procedure DataToForm(Sender: TObject);
		procedure FormToData(Sender: TObject);
	public
		{ Public declarations }
		GameInfoChanged: BG;
	end;

var
	fEngineP: TfEngineP;
	EngineIni: TDIniFile;

procedure ChangeEngine;

implementation

uses
	Types,
	uOptions, uEParams, uEGen, uETimer,
	uStrings, uFormat, uInput,
	uMain, uNextMove;

{$R *.dfm}

procedure TfEngineP.EditChange(Sender: TObject);
begin
	GameInfoChanged := True;
end;

procedure TfEngineP.ButtonCancelClick(Sender: TObject);
begin
	Close;
end;

function OptionNameToComponentName(s: string): string;
begin
	Result := DelCharsF(DelCharsF(s, ' '), '-')
end;

procedure TfEngineP.FormCreate(Sender: TObject);
const
	LabelWidth = 128;
	ControlWidth = 2 * LabelWidth + FormBorder;
	ControlHeight = 32;
	LabelHeight = 21;
var
	i, j: SG;
	X, Y,
	ScreenXCount, ScreenYCount: SG;
	XCount, YCount: SG;
	O: TOption;

	L: TLabel;
	E: TEdit;
	B: TDButton;
	C: TCheckBox;
	CB: TComboBox;
	Control: TControl;

	Rect: TRect;
begin
	Background := baGradient;
//  Position := poDefault;

	GetScreen(Rect);

	ScreenXCount := (Rect.Right - Rect.Left - FormBorder - (Width - ClientWidth)) div ControlWidth;
	ScreenYCount := (Rect.Bottom - Rect.Top - (Height - ClientHeight + 3 * FormBorder + ButtonOk.Height)) div ControlHeight;

	XCount := 2;
	YCount := 0;
	while True do
	begin
		YCount := (Length(EO) + XCount - 1) div XCount;
		if XCount >= ScreenXCount then Break;

		if YCount < ScreenYCount then Break;
		// Y overflow screen
		Inc(XCount);
	end;
{ XCount := (Length(EO) + ScreenYCount - 1) div ScreenYCount;
	if XCount < 2 then
		ScreenYCount := (Screen.Height - 96) div ControlHeight;}


	X := FormBorder;
	Y := 0;
	for i := 0 to Length(EO) - 1 do
	begin
		if Y >= YCount then
		begin
			Y := 0;
			Inc(X, 2 * LabelWidth + FormBorder);
		end;

		O := EO[TEngineOption(i)];
		if O.Typ <> vsButton then
		begin
			L := TLabel.Create(Self);
			L.AutoSize := False;
			L.Layout := tlCenter;
			L.SetBounds(X, FormBorder + Y * ControlHeight, LabelWidth, LabelHeight);
			L.Caption := AddSpace(EngineOptionNames[TEngineOption(i)]);
			L.Transparent := True;
			InsertControl(L);
		end
		else
			L := nil;
		case O.Typ of
		vsCheck:
		begin
			C := TCheckBox.Create(Self);
//      C.AutoChange := True;
//      C.Down := O.Num <> 0;
			C.Caption := ' ';
//      C.Caption := EngineOptionNames[TEngineOption(i)];
			Control := C;
			Control.Hint := FalseTrue[O.Default];
			Control.ShowHint := True;
		end;
		vsSpin:
		begin
			E := TEdit.Create(Self);
//      E.Text := NToS(O.Num);
			Control := E;
			Control.Hint := NToS(O.Default) + ' (' + NToS(O.Minimum) + '..' + NToS(O.Maximum) + ')';
			Control.ShowHint := True;
		end;
		vsCombo:
		begin
			CB := TComboBox.Create(Self);
			for j := O.Minimum to O.Maximum do
				CB.Items.Add('Item' + IntToStr(j));
			CB.ItemIndex := O.Default - O.Minimum;
			Control := CB;
			Control.Hint := NToS(O.Default);
			Control.ShowHint := True;
		end;
		vsButton:
		begin
			B := TDButton.Create(Self);
			B.Caption := AddSpace(EngineOptionNames[TEngineOption(i)]);
			B.Height := 21;
			B.OnClick := ButtonXClick;
			Control := B;
		end;
		vsString:
		begin
			E := TEdit.Create(Self);
//      E.Text := O.Str;
			Control := E;
			Control.Hint := O.DefaultStr;
			Control.ShowHint := True;
		end
		else
			Control := nil;
		end;
		if L <> nil then
		begin
			L.Hint := Control.Hint;
			L.ShowHint := Control.ShowHint;
		end;
		if Control <> nil then
		begin
			Control.Tag := i;
			Control.SetBounds(X + LabelWidth, FormBorder + Y * ControlHeight + (LabelHeight - Control.Height) div 2, LabelWidth, Control.Height);
			Control.Name := OptionNameToComponentName(EngineOptionNames[TEngineOption(i)]);
			InsertControl(Control);
			Inc(Y);
		end;
	end;
	ClientWidth := X + 2 * LabelWidth + FormBorder;
	ClientHeight := YCount * ControlHeight + ButtonOk.Height + 3 * FormBorder;

	MainIni.RWFormPos(Self, False);
end;

procedure TfEngineP.FormShow(Sender: TObject);
begin
	fMain.Parameters1.Checked := True;
	DataToForm(Sender);
end;

procedure TfEngineP.FormHide(Sender: TObject);
begin
	fMain.Parameters1.Checked := False;
end;

procedure TfEngineP.ButtonOkClick(Sender: TObject);
begin
	ButtonApplyClick(Sender);
	Close;
end;

procedure TfEngineP.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	MainIni.RWFormPos(Self, True);
end;

procedure TfEngineP.ButtonDefaultClick(Sender: TObject);
begin
	DefaultEngineOptions(Game.Params[Game.SeparatedEngine]);
	DataToForm(Sender);
	fMain.InitMenuEngine;
	LoadEvaluation;
//  InitMoves; D???
	DrawEnabledMoves;
end;

procedure TfEngineP.FormResize(Sender: TObject);
begin
	ButtonOk.Top := ClientHeight - FormBorder - ButtonOk.Height;
	ButtonCancel.Top := ClientHeight - FormBorder - ButtonCancel.Height;
	ButtonDefault.Top := ClientHeight - FormBorder - ButtonDefault.Height;
	ButtonApply.Top := ClientHeight - FormBorder - ButtonApply.Height;
	Bevel1.Top := ButtonOk.Top - FormBorder;
	Bevel1.Width := ClientWidth - 2 * Bevel1.Left;
end;

procedure TfEngineP.FormToData(Sender: TObject);
var
	i: SG;
	n: SG;
	O: POption;
	P: PParam;
	C: TComponent;
begin
	for i := 0 to Length(EO) - 1 do
	begin
		O := @EO[TEngineOption(i)];
		P := @Game.Params[Game.SeparatedEngine, TEngineOption(i)];
		C := FindComponent(OptionNameToComponentName(EngineOptionNames[TEngineOption(i)]));
		if C <> nil then
		begin
			case O.Typ of
			vsCheck:
			begin
				n := SG(TCheckBox(C).Checked);
				if P.Num <> n then
				begin
					P.Num := n;
					OptionChanged(TEngineOption(i));
				end;
			end;
			vsSpin:
			begin
				n := StrToValI(TEdit(C).Text, True, O.Minimum, O.Default, O.Maximum, 1);
				if P.Num <> n then
				begin
					P.Num := n;
					OptionChanged(TEngineOption(i));
				end;
			end;
			vsCombo:
			begin
				n := TComboBox(C).ItemIndex + O.Minimum;
				if P.Num <> n then
				begin
					P.Num := n;
					OptionChanged(TEngineOption(i));
				end;
			end;
			vsString:
			begin
				if P.Str <> TEdit(C).Text then
				begin
					P.Str := TEdit(C).Text;
					OptionChanged(TEngineOption(i));
				end;
			end;
			end;
		end;
	end;
	ShowAndClearErrors;
end;

procedure TfEngineP.DataToForm(Sender: TObject);
var
	i: SG;
	O: POption;
	P: PParam;
	C: TComponent;
begin
	Caption := 'Engine Parameters' + SeparatedToS(Game.SeparatedEngine);
	for i := 0 to Length(EO) - 1 do
	begin
		O := @EO[TEngineOption(i)];
		P := @Game.Params[Game.SeparatedEngine, TEngineOption(i)];
		C := FindComponent(OptionNameToComponentName(EngineOptionNames[TEngineOption(i)]));
		if C <> nil then
		case O.Typ of
		vsCheck:
		begin
			TCheckBox(C).Checked := P.Num <> 0;
		end;
		vsSpin:
		begin
			TEdit(C).Text := NToS(P.Num);
		end;
		vsCombo:
		begin
			TComboBox(C).ItemIndex := P.Num - O.Minimum;
		end;
		vsString:
		begin
			TEdit(C).Text := P.Str;
		end;
		end;
	end;
end;

procedure TfEngineP.ButtonApplyClick(Sender: TObject);
begin
	FormToData(Sender);
	RWEngine(EngineIni, True);
	InitEngine;
	fMain.InitMenuEngine;
	LoadEvaluation;
//  InitMoves;  D???
	DrawEnabledMoves;
end;

procedure TfEngineP.ButtonXClick(Sender: TObject);
begin
	OptionChanged(TEngineOption(TControl(Sender).Tag));
end;

procedure ChangeEngine;
begin
	if FormDraw(fEngineP) then
	begin
		fEngineP.DataToForm(nil);
	end;
	fMain.InitMenuEngine;
	LoadEvaluation;
//  InitMoves; D???
	DrawOb(dpEnabledMoves);
end;

end.