unit uEGen;

interface

uses
	uTypes,
	uETypes;

var
	FCMove: PMove; // Start Index of Free block of CMove
	PCMove: PMove; // Data ok, Size wrong
	BEvals: array[0..PlayerMax, 0..BoardSize - 1] of U2; // Jungle
	BEval: array[0..BoardSize - 1] of U2 absolute BEvals; // Draughts, Gomoku, Othello, BlobWars

	// Positions of castling pieces
	CastleK: array[0..PlayerMax] of U1;
	CastleR: array[0..PlayerMax, TCastleType] of U1;

const
	odLU = 0; odRU = 1; odLD = 2; odRD = 3;
	odU = 4; odL = 5; odR = 6; odD = 7;
	odNUL = 8; odNUR = 9; odNLU = 10; odNLD = 11;
	odNRU = 12; odNRD = 13; odNDL = 14; odNDR = 15;
type
	TOffsetA = array[0..15] of S2; // 32B; S1: 116nps S2: 121nps S4: 121nps
var
	Offsets: array[0..PlayerMax] of TOffsetA; // 2 * 16 = 32

	DoubleSquares: TBoard;
	WaterSquares: TBoard absolute DoubleSquares;
	
procedure FillChessVariant;
procedure FillStartPos;
procedure LoadEvaluation;
procedure FillPlus(M: PMove; AndMate: BG = False);
procedure RemoveIllegalMoves(BookPlusReindex: BG = False);

procedure FillHashIC(var CPos: TPos);
{$ifndef UCI}procedure SwapHashColor(var CPos: TPos);
procedure Stalemate(var Result: TSubtreeStatus);
{$endif}
var
	MIncCMC: BG = True;
function GenerateMoves: TSubtreeStatus;
procedure DoMove;
procedure BackMove(const LastPos: TPos);

function CanWin: BG;
{$ifdef Debug}
procedure CheckMove(M: PMove); // Check if move is correct
procedure CheckHash(const CPos: TPos);
{$endif}

implementation

uses
	Math,
	uMath,
	{$ifndef UCI}
	uError,
	uNew,
	{$endif}
	uEBook,
	uEParams, uEBoard, uEngine, uEHash, uESearch;

var
	HashRandomPlayer, HashRandomEP: THash; // Chess, Shogi, Jungle
	HashRandomCastle: array[0..PlayerMax, TCastleType] of THash;
	HashRandom: array[TPiece, 0..BoardSize - 1] of THash; // Large Array 128 kB
{$ifndef UCI}
	//
{$endif}
	Pri: array[0..BoardSize - 1] of U1;
	Material: array[0..MaxPieces] of U4;
type
	TPieceActivity = array[-MaxPieces..-MaxPieces + 31 {MaxPieces}] of S2;
	PPieceActivity = ^TPieceActivity;
var
	PieceActivities: array[-MaxPieces..MaxPieces] of TPieceActivity;
	MoveBonus: array[0..MaxMoves] of U2;
	Den0, Den1: SG; // Jungle
const
	MaxMoveBonus = 11;
var
	Unpromote: array[TPiece] of TPiece;

function Distance(I0, I1: SG): SG;
var x0, y0, x1, y1: SG;
begin
	IToXY(I0, x0, y0);
	IToXY(I1, x1, y1);
	Result := Abs(x0 - x1) + Abs(y0 - y1);
end;

function Distance2(I0, I1: SG): SG;
var x0, y0, x1, y1: SG;
begin
	IToXY(I0, x0, y0);
	IToXY(I1, x1, y1);
	Result := Max(Abs(x0 - x1), Abs(y0 - y1));
end;

(*-------------------------------------------------------------------------*)
// Generators
var
	Ofst: TOffsetA; // For procedure Moves only, not for DoMove/BackMove! DCheck 3
	PromotionSquares: array[0..PlayerMax] of TBoard;

function Rnd(Value: SG): SG;
begin
	if AEP[eoRandomPlay].Bool = True then
		Result := (Value * (100 + AEP[eoRandomValue].Num - Random(2 * AEP[eoRandomValue].Num + 1)) + 50) div 100
	else
		Result := Value;
end;

procedure LoadEvaluation;
var
	i, j: SG;
	X, Y: SG;
	xx, yy: SG;
	Index: SG;
	Sc: SG;
	{$ifndef UCI}
	Dir: SG;
	A, T: SG;
	{$endif}
begin
	// Priority
{ Draughts 8x8 sample
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 05, 05, 05, 05, 05, 05, 11,
	11, 05, 08, 08, 08, 08, 05, 11,
	11, 05, 08, 07, 07, 08, 05, 11,
	11, 05, 08, 07, 07, 08, 05, 11,
	11, 05, 08, 08, 08, 08, 05, 11,
	11, 05, 05, 05, 05, 05, 05, 11,
	11, 11, 11, 11, 11, 11, 11, 11
}
	FillChar(Pri, SizeOf(Pri), 0);
	FillChar(BEvals, SizeOf(BEvals), 0);
	for i := 0 to UsedSquareCount - 1 do
	begin
		Index := UsedSquares[i];
		IToXY(Index, x, y);

		if x > SqX div 2 then
			xx := SqX - x
		else
			xx := x;

		if y > SqY div 2 then
			yy := SqY - y
		else
			yy := y;

		Sc := Min(xx, yy);
		case GameType of
		gtDraughts:
		begin
			// Calibrate
			if (Sc = 1) then
				Sc := 4 + Sc
			else
				Sc := 11 + Sc;

			Pri[Index] := Sc;
		end;
		gtExplosion:
			Pri[Index] := Rnd(Sc + 2);
		else
			Pri[Index] := Sc + 1;
		end;
	end;

	for i := 0 to MaxMoves do
	begin
		{
		Toga: 0.00
		Fritz 0.05
		Ruffian -0.20
		SOS 0.11
		}
		// Float
		if GameType = gtJungle then
			MoveBonus[i] := 10
		else
			MoveBonus[i] := Round(MaxMoveBonus * (1 - Exp(-i / 8))); // Calibrate
	end;
	{
	Chess material
	Standard: Q=9, R=5, B=2.94 and N=2.87, P=1
	Bughouse: Q=4, N=2, R=2, B=2, P=1
	}
	Material[sqEmpty] := 0;
	FillChar(PieceActivities, SizeOf(PieceActivities), 0);

	case GameType of
	gtDraughts:
	begin
		Material[sqP0] := 100;
		Material[sqN0] := 150;
	end;
	gtChess:
	begin
		PieceActivities[sqP0, sqEmpty] := 6;
		Material[sqP0] := 100;

		PieceActivities[sqN0, sqEmpty] := 10;
		if Game.Variant.Options[voRCP].Bool then
			Material[sqN0] := 200 - 50
		else
			Material[sqN0] := 287 - 50;

		PieceActivities[sqB0, sqEmpty] := 6;
		if Game.Variant.Options[voRCP].Bool then
			Material[sqB0] := 200 - 50
		else
			Material[sqB0] := 294 - 60;

		PieceActivities[sqR0, sqEmpty] := 4;
		if Game.Variant.Options[voRCP].Bool then
			Material[sqR0] := 200 - 50
		else
			Material[sqR0] := 500 - 56;

		PieceActivities[sqQ0, sqEmpty] := 1;
		if Game.Variant.Options[voRCP].Bool then
			Material[sqQ0] := 400 - 24
		else
			Material[sqQ0] := 900 - 24;

		PieceActivities[sqK0, sqEmpty] := -10; // King safety
		Material[sqK0] := 350;
	end;
	gtChineseChess:
	begin
		PieceActivities[sqP0, sqEmpty] := 6;
		Material[sqP0] := 100;

		PieceActivities[sqN0, sqEmpty] := 10;
		if Game.Variant.Options[voRCP].Bool then
			Material[sqN0] := 200 - 50
		else
			Material[sqN0] := 287 - 50;

		PieceActivities[sqB0, sqEmpty] := 6;
		if Game.Variant.Options[voRCP].Bool then
			Material[sqB0] := 200 - 50
		else
			Material[sqB0] := 294 - 60;

		PieceActivities[sqR0, sqEmpty] := 4;
		if Game.Variant.Options[voRCP].Bool then
			Material[sqR0] := 200 - 50
		else
			Material[sqR0] := 500 - 56;

		PieceActivities[sqQ0, sqEmpty] := 1;
		if Game.Variant.Options[voRCP].Bool then
			Material[sqQ0] := 400 - 24
		else
			Material[sqQ0] := 900 - 24;

		PieceActivities[sqK0, sqEmpty] := 5;
		Material[sqK0] := 350;

		PieceActivities[sqC0, sqEmpty] := 1;
		if Game.Variant.Options[voRCP].Bool then
			Material[sqC0] := 400 - 24
		else
			Material[sqC0] := 900 - 24;
	end;
	gtShogi:
	begin
		PieceActivities[sqP0, sqEmpty] := 8;
		Material[sqP0] := 72;

		PieceActivities[sqN0, sqEmpty] := 10;
		if Game.Variant.Options[voRCP].Bool then
			Material[sqN0] := 200 - 50
		else
			Material[sqN0] := 287 - 50;

		PieceActivities[sqShogiB0, sqEmpty] := 6;
		if Game.Variant.Options[voRCP].Bool then
			Material[sqShogiB0] := 200 - 50
		else
			Material[sqShogiB0] := 294 - 60;

		PieceActivities[sqShogiR0, sqEmpty] := 4;
		if Game.Variant.Options[voRCP].Bool then
			Material[sqShogiR0] := 200 - 50
		else
			Material[sqShogiR0] := 500 - 56;

		PieceActivities[sqQ0, sqEmpty] := 1;
		if Game.Variant.Options[voRCP].Bool then
			Material[sqQ0] := 400 - 24
		else
			Material[sqQ0] := 900 - 24;

		PieceActivities[sqShogiK0, sqEmpty] := 5;
		Material[sqShogiK0] := 350;

		PieceActivities[sqH0, sqEmpty] := 15;
		Material[sqH0] := 110;

		PieceActivities[sqL0, sqEmpty] := 25;
		Material[sqL0] := 100;

		PieceActivities[sqS0, sqEmpty] := 40;
		Material[sqS0] := 170;

		PieceActivities[sqG0, sqEmpty] := 45;
		Material[sqG0] := 200;

		PieceActivities[sqAP0, sqEmpty] := 45;
		Material[sqAP0] := 200;

		PieceActivities[sqHP0, sqEmpty] := 45;
		Material[sqHP0] := 200;

		PieceActivities[sqLP0, sqEmpty] := 45;
		Material[sqLP0] := 200;

		PieceActivities[sqSP0, sqEmpty] := 45;
		Material[sqSP0] := 200;

		PieceActivities[sqBP0, sqEmpty] := 50;
		Material[sqBP0] := 294 - 60 + 220;

		PieceActivities[sqRP0, sqEmpty] := 60;
		Material[sqRP0] := 500 - 56 + 220;
	end;
	gtJungle:
	begin
		for i := 1 to PieceTypes do
		begin
			Material[i] := 100 + 10 * i;
		end;
	end;
	gtBlobWars:
		Material[1] := 100;
	end;
	for i := 1 to PieceTypes do
	begin
		if PieceActivities[i, sqEmpty] = 0 then
			PieceActivities[i, sqEmpty] := 6; // Default Value
		// Friend
		for j := 1 to PieceTypes do
			PieceActivities[i, j] := 0;
		// Emeny
		for j := 1 to PieceTypes do
			PieceActivities[i, -j] := Material[j] div 15;
	end;
	if GameType = gtChess then
	begin
		// King safety
		for j := 1 to PieceTypes do
			Inc(PieceActivities[sqK0, j], 16);
	end;

	{$ifndef UCI}
	case GameType of
	gtDraughts:
	begin
(*    for i := 0 to UsedSquareCount - 1 do
		begin
			Index := UsedSquares[i];
			IToXY(Index, X, Y);
			Sc := (10 * (1000 - AEP[eoMaterial].Num) +
				1 * AEP[eoPieceActivity].Num {* (1 shl Max(0, Y)) } {- StylePA * (1 shl 4)} +
				(2 * AEP[eoMaterial].Num) * Pri[Index]) div 100;

			if Game.Variant.Options[voBackwardCapture].Bool then Sc := Sc + 50; // Calibrate
			{$ifdef Debug}
{     if Sc < 1 then
			begin
				IE('LoadEvaluation0');
				Sc := 1
			end
			else if Sc > High(E10[0]) then
			begin
				IE('LoadEvaluation1');
				Sc := High(E10[0]);
			end;}
			{$endif}
{     E10[Index] := Sc;
			E11[UsedSquares[UsedSquareCount - 1 - i]]:= Sc;}
		end; *)
		for i := 0 to UsedSquareCount - 1 do
		begin
			Index := UsedSquares[i];
			Sc := (10 * (1000 - AEP[eoMaterial].Num) +
				(AEP[eoMaterial].Num) * Pri[Index]) div 100;
			case Game.Variant.Options[voFlyingKing].Num of
			1: Inc(Sc, 500); // Calibrate
			2: Inc(Sc, 350); // Calibrate
			end;
			if Game.Variant.Options[voStrongKing].Bool then Inc(Sc, 300); // Calibrate
(*      if Sc < 1 then
			begin
				{$ifdef Debug}
				IE('LoadEvaluation2');
				{$endif}
				Sc := 1
			end
			else if Sc > High(BEval[0]) then
			begin
				{$ifdef Debug}IE('LoadEvaluation3');{$endif}
				Sc := High(BEval[0]) div 16;
			end;*)
			BEval[Index] := Range(1, Sc, High(BEval[0]) div 16);
		end;
	end;
	gtJungle:
	begin
		for i := 0 to UsedSquareCount - 1 do
		begin
			BEvals[0][UsedSquares[i]] := 100 - Distance(UsedSquares[i], Den1);
			BEvals[1][UsedSquares[i]] := 100 - Distance(UsedSquares[i], Den0);
		end;
	end;
	gtGomoku:
	begin
		for i := 0 to UsedSquareCount - 1 do
		begin
			Index := UsedSquares[i];
			Sc := 0;
			for Dir := 0 to 3 do
			begin
				T := 1;
				A := Index;
				while True do
				begin
					Inc(A, Offsets[0][2 * Dir]);
					if StartPos.Board[A] <> sqEmpty then Break;
					Inc(T);
				end;
				A := Index;
				while True do
				begin
					Dec(A, Offsets[0][2 * Dir]);
					if StartPos.Board[A] <> sqEmpty then Break;
					Inc(T);
				end;
				if T >= Game.Variant.Options[voLineSize].Num then
					Inc(Sc, T + 10);
			end;

			BEval[Index] := Sc;
		end;
	end;
	gtOthello:
	begin
		for i := 0 to UsedSquareCount - 1 do
		begin
			Index := UsedSquares[i];
			IToXY(Index, x, y);
			// Calibrate
			Sc := 100;
			if (x in [1, SqX - 1]) then
				Dec(Sc, 25);
			if (y in [1, SqY - 1]) then
				Dec(Sc, 25);

			if (x in [0, SqX]) then
				if not (y in [0, 2, SqY, SqY - 2]) then Dec(Sc, 25);

			if (y in [0, SqY]) then
				if not (x in [0, 2, SqX, SqX - 2]) then Dec(Sc, 25);

			if (x in [0, SqX]) and (y in [0, SqY]) then Inc(Sc, 50); // Corner Bonus

			if (x in [1, SqX - 1]) and (y in [1, SqY - 1]) then
				Dec(Sc, 25);

			BEval[Index] := Sc;
		end;
	end;
	gtBlobWars:
	begin
		for i := 0 to UsedSquareCount - 1 do
		begin
			Index := UsedSquares[i];
			IToXY(Index, x, y);
			// Calibrate
			Sc := (SqX + SqY) - Abs(2 * x - SqX) - Abs(2 * y - SqY);
			BEval[Index] := Sc;
		end;
	end;
	end;

	// Randomize
	for j := 0 to PlayerMax do
	for i := 0 to UsedSquareCount - 1 do
	begin
		Index := UsedSquares[i];
		BEvals[j, Index] := Rnd(SG(BEvals[j, Index]) * AEP[eoPieceActivity].Num div 100);
	end;
	{$endif}
	for i := 1 to PieceTypes do
	begin
//    DEv[i] := Rnd(Material[i] * AEP[eoMaterial].Num div(50{Calibrate} * 100));
		Material[i] := Rnd(SG(Material[i]) * AEP[eoMaterial].Num div 100);
		for j := -PieceTypes to PieceTypes do
			PieceActivities[i, j] := Rnd(SG(PieceActivities[i, j]) * AEP[eoPieceActivity].Num div 100);
	end;
	// Symetric activity
	for i := 1 to PieceTypes do
	begin
		for j := -MaxPieces to MaxPieces do
			PieceActivities[-i, -j] := PieceActivities[i, j];
	end;
end;
(*-------------------------------------------------------------------------*)



var
	IncCMC: BG;
	// Chess
	Affect: array[0..PlayerMax, 0..BoardSize - 1] of U1; // Affected squares
	SqS, SqD: S4;
	PieceS, PieceD: TSquare;
	TM: TTM;
	King: TSquare;
	// Draghts
	ASq: array[0..MaxMoveL] of U1;
	MustCapture: U1;

procedure AddDraughtsMove(Lng: U1);
begin
	if Lng > 1 then
	begin
		if Remove[CPos.Side] = 0 then
		begin
			Remove[CPos.Side] := MustCapture;
			if MustCapture = 2 then
			begin
				// Clear added moves
				PCMove := FCMove;
			end;
		end;
	end
	else if Remove[CPos.Side] = 2 then
	begin
		Exit;
	end;

	if IncCMC then
	begin
		PCMove.Prior := 126 + Lng;
		PCMove.F1 := PieceS;
		PCMove.DraughtsMove := TM;
		PCMove.Lng := Lng;
		Move(ASq, PCMove.Sq[0], Lng + 1);
		Inc(SG(PCMove), SizeTMoveDraughts);
	end;
end;

procedure AddChessMove;
begin
	if PieceD <> sqEmpty then
	begin
		if (Game.Variant.Options[voMateKing].Bool) and (Abs(PieceD) = King) and (Sgn(PieceS) <> Sgn(PieceD)) then
			CCheck[CPos.Side xor 1] := True;
		if Remove[CPos.Side] = 0 then
		begin
			Remove[CPos.Side] := MustCapture;
			if MustCapture = 2 then
			begin
				// Clear added moves
				PCMove := FCMove;
			end;
		end;
	end
	else if Remove[CPos.Side] = 2 then
	begin
		Exit;
	end;

	if IncCMC then
	{$ifdef Debug}if SG(PCMove) + SizeTMoveChess <= SG(@CMove) + SizeOf(CMove) then{$endif}
	begin
		// Calibrate
		if PieceD = sqEmpty then
		begin
			if Affect[CPos.Side xor 1, SqD] <> 0 then
				PCMove.Prior := 127 - 2 * Affect[CPos.Side xor 1, SqD] - (SG(Material[Abs(PieceS)])) div 32
				//(SG(SEv[Abs(PieceS)])) div 8{ + (T - F)}
			else
				PCMove.Prior := 127 + Pri[SqD] - Pri[SqS]; //(SG(SEv[Abs(PieceS)])) div 8{ + (T - F)}
		end
		else
		begin
			if Affect[CPos.Side xor 1, SqD] <> 0 then
				PCMove.Prior := 128 + (SG(Material[Abs(PieceD)]) - SG(Material[Abs(PieceS)])) div 32{ + 40} // for Russian Opening
			else
				PCMove.Prior := 128 + (SG(Material[Abs(PieceD)])) div 32;

		end;
		if (TM <> tmNormal) and (Abs(TPiece(TM)) <= MaxPieces) then
		begin
			// Promote
			Inc(PCMove.Prior, (SG(Material[Abs(TPiece(TM))]) - SG(Material[Abs(PieceS)])) div 32);
			CPromote := 2;
		end;

		if PCMove.Prior > CMaxPrior then CMaxPrior := PCMove.Prior;
{     if PieceD = 0 then
			P.Prior := 127
		else
			P.Prior := 127 + (SG(SEv[Abs(PieceD)]) - SG(SEv[Abs(PieceS)])) div 8;}

		PCMove.FrSq := SqS;
		PCMove.ToSq := SqD;
		PCMove.F1 := PieceS;
		PCMove.F2 := PieceD;
//      PU4(@PMove(CMC).FrSq)^ := PU4(@SqS)^;
		PCMove.TM := TM;
		PCMove.Plus := msNone;
		{$ifdef Debug}if CPos.Board[PCMove.ToSq] <> PieceD then
			IE('AddMove');{$endif}
		Inc(SG(PCMove), SizeTMoveChess);
	end;
end;

(*-------------------------------------------------------------------------*)

// Draughts Generator

(*-------------------------------------------------------------------------*)

(*
procedure MovePiece(Sq: TSquare; Dir: S1; ContMove: TContMove); register;
begin
	SqS := Sq;
	while True do
	begin
		Inc(Sq, Dir);
		PieceD := CPos.Board[Sq];
		if PieceD = sqOut then Break;
		Inc(Affect[CPos.Side, SqD]);
		if PieceD = sqEmpty then
		begin // Free
			SqD := Sq;
			AddChessMove;
			if ContMove = cmMoveOne then Break;
		end
		else if U1(PieceD) shr 7 <> CPos.Side then
		begin // Enemy
			SqD := Sq;
			AddChessMove;
			if ContMove = cmMoveOne then Break;
		end
		else // Friend
		begin
			if Game.Variant.Options[voSelfCaptures].Bool then
			begin
				SqD := Sq;
				AddChessMove;
			end;
			if ContMove = cmMoveOne then Break;
		end;
	end;
end; *)

type
	TContMove = (
		cmMoveOne, // 0
		cmMoveX, // 1
		cmMoveBeyond, // 2
		cmCaptureOne,
		cmCaptureX,
		cmCaptureBeyond
		);
	TContMoveD = packed record
		CM: TContMove;
		D: 0..MaxMoveL;
	end;
var
	CapturedKings: UG;
	MaxCapturedKings: UG;
	PieceActivity: PPieceActivity;

procedure MoveDraughtsPiece(Dir: S1; ContMove: TContMoveD); register;
var
	SqD, SqD2: SG;
	LastPiece: TPiece;
	LastPieceS: TPiece;
	LCapturedKings: UG;
begin
	SqD := ASq[ContMove.D];
	while True do
	begin
		Inc(SqD, Dir);
		PieceD := CPos.Board[SqD];
		if PieceD = sqOut then Break;
		if PieceD = sqEmpty then
		begin // Free
			if ContMove.CM < cmCaptureOne then
			begin
				Inc(CSco[0], PieceActivity[PieceS]);
				ASq[1] := SqD;
				if (PromotionSquares[CPos.Side, SqD] = PieceS) then TM := TTM(2 * PieceS);
				AddDraughtsMove(1);
				if not (ContMove.CM in [cmMoveX, cmCaptureX]) then Break;
			end
			else
				Break;
		end
		else if (U1(PieceD) shr 7 <> CPos.Side) or (Game.Variant.Options[voSelfCaptures].Bool) then
		begin // Enemy
			if Game.Variant.Options[voStrongKing].Bool then
			begin
				if Abs(PieceS) < Abs(PieceD) then Break;
			end;

			LCapturedKings := CapturedKings;
			if Game.Variant.Options[voQualityRule].Bool and (Abs(PieceD) > 1) then
			begin
				Inc(CapturedKings);
			end;
			SqD2 := SqD;
			while True do
			begin
				Inc(SqD2, Dir);
				PieceD := CPos.Board[SqD2];
				if PieceD = sqEmpty then
				begin // Free
					LastPiece := CPos.Board[SqD];
					LastPieceS := PieceS;
					if ContMove.CM < cmCaptureOne then
						Inc(ContMove.CM, 3);
					if ContMove.D < MaxMoveL - 1 then
					begin
						Inc(ContMove.D, 2);
						if ContMove.D > CRemove then CRemove := ContMove.D;
						CPos.Board[SqD] := sqEmpty;
						ASq[ContMove.D - 1] := SqD;
						ASq[ContMove.D - 0] := SqD2;

						if (Game.Variant.Options[voPromote].Num = 2) then
						begin
							if (PromotionSquares[CPos.Side, SqD] = PieceS) then
							begin
								PieceS := 2 * PieceS;
								TM := TTM(PieceS);
							end;
						end;
						MoveDraughtsPiece(Ofst[0], ContMove);
						MoveDraughtsPiece(Ofst[1], ContMove);
						if (Game.Variant.Options[voBackwardCapture].Bool) or (Abs(PieceS) > 1) then
						begin
							MoveDraughtsPiece(Ofst[2], ContMove);
							MoveDraughtsPiece(Ofst[3], ContMove);
						end;
						if (ContMove.D >= CRemove) and (CapturedKings >= MaxCapturedKings) then
						begin
							if (TM = tmNormal) and (PromotionSquares[CPos.Side, SqD] = PieceS) then TM := TTM(2 * PieceS);
							AddDraughtsMove(ContMove.D);
						end;
						TM := tmNormal;
						Dec(ContMove.D, 2);
					end;
					CPos.Board[SqD] := LastPiece;
					PieceS := LastPieceS;
					if not (ContMove.CM in [cmCaptureX]) then
						Break;
				end
				else
					Break;
			end;
			CapturedKings := LCapturedKings;
			Break;
		end
		else // Friend
		begin
			if ContMove.CM <> cmMoveX then Break;
		end;
	end;
end;

procedure MoveDraughtsMan;
var CM: TContMoveD;
begin
	PieceActivity := @PieceActivities[PieceS];
	CM.CM := cmMoveOne;
	CM.D := 0;
	ASq[0] := SqS;
	MoveDraughtsPiece(Ofst[0], CM);
	MoveDraughtsPiece(Ofst[1], CM);
	if Game.Variant.Options[voBackwardCapture].Bool then
	begin
		CM.CM := cmCaptureOne;
		MoveDraughtsPiece(Ofst[2], CM);
		MoveDraughtsPiece(Ofst[3], CM);
	end;
end;

procedure MoveDraughtsKing;
var CM: TContMoveD;
begin
	PieceActivity := @PieceActivities[PieceS];
	CM.CM := TContMove(Game.Variant.Options[voFlyingKing].Num);
	CM.D := 0;
	ASq[0] := SqS;
	MoveDraughtsPiece(Ofst[0], CM);
	MoveDraughtsPiece(Ofst[1], CM);
	MoveDraughtsPiece(Ofst[2], CM);
	MoveDraughtsPiece(Ofst[3], CM);
end;

(*-------------------------------------------------------------------------*)

// Chess Generator

(*-------------------------------------------------------------------------*)

procedure MoveEmptyPiece;
begin
end;

var
	PromotePawnTo: SG;
	
procedure MoveChessP;
var
	j: SG;
	k: SG;
	PieceActivity: PPieceActivity;
begin
	PieceActivity := @PieceActivities[PieceS];
	// Pawn try x-move
	for j := SG(odLU) to SG(odRU) do
	begin
		SqD := SqS + Ofst[j];
		PieceD := CPos.Board[SqD];
		if PieceD <> sqOut then
		begin
			Inc(Affect[CPos.Side, SqD]);
			if PieceD = sqEmpty then
			begin
				if (SqD = CPos.EP) then
				begin
					TM := tmEP;
					AddChessMove;
					TM := tmNormal;
				end;
			end
			else
			begin
				if (U1(PieceD) shr 7 <> CPos.Side) or (Game.Variant.Options[voSelfCaptures].Bool) then
				begin
					// Promote
					if PromotionSquares[CPos.Side, SqD] <> 0 then
					begin
						for k := PromotePawnTo downto S1(sqN0) do
						begin
							TM := TTM(k);
							AddChessMove;
						end;
						TM := tmNormal;
					end
					else
					begin
						AddChessMove;
					end;
					Inc(CSco[0], PieceActivity[PieceD]);
				end;
				
				if PieceD = PieceS then
				begin
					Inc(CSco[0], AEP[eoPawnStructure].Num);
				end;
			end;
		end;
	end;

	// Pawn try move
	SqD := SqS + Ofst[SG(odU)];
	PieceD := CPos.Board[SqD];
	if PieceD = sqEmpty then
	begin
		Inc(CSco[0], PieceActivity[sqEmpty]);
		// Promote
		if PromotionSquares[CPos.Side, SqD] <> 0 then
		begin
			for k := PromotePawnTo downto S1(sqN0) do
			begin
				TM := TTM(k);
				AddChessMove;
			end;
			TM := tmNormal;
			Inc(CSco[0], AEP[eoPassedPawns].Num);
		end
		else
		begin
			AddChessMove;
//            Dec(Affect[CP0a, SqD]);
			if DoubleSquares[SqS] = PieceS {(SqD >= Ofst[SG(odPDF)]) and (SqD <= Ofst[SG(odPDT)])} then
			begin
				// Double
				Inc(SqD, Ofst[SG(odU)]);
				PieceD := CPos.Board[SqD];
				if PieceD = sqEmpty then
				begin
					Inc(CSco[0], PieceActivity[sqEmpty]);
					TM := tmDouble;
					AddChessMove;
					TM := tmNormal;
				end;
			end;
		end;
	end;

	// Pawn structure
	SqD := SqS + Ofst[SG(odL)];
	PieceD := CPos.Board[SqD];
	if (PieceD = PieceS) then
	begin
		Inc(CSco[0], AEP[eoPawnStructure].Num);
	end;
	SqD := SqS + Ofst[SG(odR)];
	PieceD := CPos.Board[SqD];
	if (PieceD = PieceS) then
	begin
		Inc(CSco[0], AEP[eoPawnStructure].Num);
	end;

	// Pawn square rule - calculated
{ if RemainPieces[] then
	begin
		SqD := PromoteSquare(SqS);
		if Distance2(SqS, SqD) < Distance2(NearestKing, SqD) then
			Inc(CSco[0], SEv[sqQ0] - 2 * SEv[sqP0]);
	end;}
end;

procedure MoveChessK;
var
	j: SG;
	PieceActivity: PPieceActivity;
begin
	PieceActivity := @PieceActivities[PieceS];
(*    if (Affect[CPos.Side xor 1, SqS] > 0) and (Game.Variant.Illegal = False) then
	begin
		// Stojim v sachu
		CCheck[CPos.Side] := True;
		Dec(CSco[0], AEP[eoKingSafety].Num);
		if Affect[CPos.Side xor 1, SqS] > 1 then
		begin
			// Stojim ve 2-sachu
			Dec(CSco[0], 2 * AEP[eoKingSafety].Num); // Calibrate
			{$ifdef Debug}
			if Where <> whNone then
			if Affect[CPos.Side xor 1, SqS] > 2 then
			begin
				IE('MoveChessK');
			end;
			{$endif}
		end;
	end; Must be applied to both sides! *)

	for j := 0 to 7 do
	begin
		SqD := SqS + Ofst[j];
		PieceD := CPos.Board[SqD];
		if PieceD = sqOut then Continue;
		Inc(Affect[CPos.Side, SqD]);
		Inc(CSco[0], PieceActivity[PieceD]);
		if (PieceD = sqEmpty) or (U1(PieceD) shr 7 <> CPos.Side) or (Game.Variant.Options[voSelfCaptures].Bool) then
		begin
			if (Affect[CPos.Side xor 1, SqD] = 0) or (Game.Variant.Options[voMateKing].Bool = False) then
			begin
				AddChessMove;
//        Inc(CSco[0], PieceActivity[PieceD]);
				if (Affect[CPos.Side xor 1, SqS] = 0) or (Game.Variant.Options[voMateKing].Bool = False) then
				begin
					// Kral se dotyka volneho nenapadeneho pole
//          Inc(CSco[0], PieceActivity[PieceD]);
					if (CPos.Castles[CPos.Side, caK]) and (j = odR) then
					begin
						Inc(SqD);
						PieceD := CPos.Board[SqD];
						if ((Affect[CPos.Side xor 1, SqD] = 0) or (Game.Variant.Options[voMateKing].Bool = False)) and (PieceD = 0) and (CPos.Board[CastleR[CPos.Side, caK] - 1] = 0) then
						begin
							TM := tmOO;
							AddChessMove;
							TM := tmNormal;
						end;
//                  Dec(SqD);
					end;
					if CPos.Castles[CPos.Side, caQ] and (j = odL) then
					begin
						Dec(SqD);
						PieceD := CPos.Board[SqD];
						if ((Affect[CPos.Side xor 1, SqD] = 0) or (Game.Variant.Options[voMateKing].Bool = False)) and (PieceD = 0) and (CPos.Board[CastleR[CPos.Side, caQ] + 1] = 0) then
						begin
							TM := tmOOO;
							AddChessMove;
							TM := tmNormal;
						end;
//                  Inc(SqD);
					end;
				end;
			end
(*      else // Pole kam muze kral tahnout je napadene souperem, trpi bezpecnost krale
			begin
				if Game.Variant.Options[voMateKing].Bool = True then
				begin
					// Dec(CSco[0], AEP[eoKingSafety].Num);
					if PieceD2 < 0 then
					begin
						// Kral se dotyka souperovy kryteho kamene
{           if Affect[CPos.Side xor 1, SqS] > 0 then
							Dec(CSco[0], DEv[-PieceD2]);}
//              Dec(CSco[0], AEP[eoKingSafety].Num);
					end;
//          else
						// Kral se dotyka volneho pole napadeneho souperem
				end;
			end*);
		end
		else
		begin
			// Kral se dotyka vlastnich kamenu
//            Dec(CSco[0], Affect[CP0p, SqD] shl 2);}
		end;
	end;
end;

procedure MoveChessN;
var
	j: SG;
	PieceActivity: PPieceActivity;
begin
	PieceActivity := @PieceActivities[PieceS];
	for j := SG(odNUL) to SG(odNDR) do
	begin
		SqD := SqS + Ofst[j];
		PieceD := CPos.Board[SqD];
		if PieceD = sqOut then Continue;
		Inc(Affect[CPos.Side, SqD]);
		Inc(CSco[0], PieceActivity[PieceD]);
		if (PieceD = sqEmpty) or (U1(PieceD) shr 7 <> CPos.Side) or (Game.Variant.Options[voSelfCaptures].Bool) then
		begin
			AddChessMove;
		end;
	end;
end;

procedure MoveMao;
var
	j: SG;
	PieceActivity: PPieceActivity;
begin
	PieceActivity := @PieceActivities[PieceS];
	for j := SG(odNUL) to SG(odNDR) do
	begin
		// Mao specific
		SqD := SqS + Ofst[(j - odNul) div 2 + odU];
		PieceD := CPos.Board[SqD];
		if PieceD <> sqEmpty then Continue;

		SqD := SqS + Ofst[j];
		PieceD := CPos.Board[SqD];
		if PieceD = sqOut then Continue;
		Inc(Affect[CPos.Side, SqD]);
		Inc(CSco[0], PieceActivity[PieceD]);
		if (PieceD = sqEmpty) or (U1(PieceD) shr 7 <> CPos.Side) or (Game.Variant.Options[voSelfCaptures].Bool) then
		begin
			AddChessMove;
		end;
	end;
end;

procedure MoveElephant;
var
	k: SG;
	PieceActivity: PPieceActivity;
begin
	PieceActivity := @PieceActivities[PieceS];
	for k := SG(odLU) to SG(odRD) do
	begin
		SqD := SqS;
		Inc(SqD, Ofst[k]);
		PieceD := CPos.Board[SqD];
		if PieceD <> sqEmpty then Continue;
		Inc(SqD, Ofst[k]);
		PieceD := CPos.Board[SqD];
		if PieceD = sqOut then Break;
		Inc(Affect[CPos.Side, SqD]);
		Inc(CSco[0], PieceActivity[PieceD]);
		if (PieceD = sqEmpty) or (U1(PieceD) shr 7 <> CPos.Side) or (Game.Variant.Options[voSelfCaptures].Bool) then
		begin
			AddChessMove;
		end;
	end;
end;

procedure MoveMandarin;
var
	k: SG;
	PieceActivity: PPieceActivity;
begin
	PieceActivity := @PieceActivities[PieceS];
	for k := SG(odLU) to SG(odRD) do
	begin
		SqD := SqS;
		Inc(SqD, Ofst[k]);
		PieceD := CPos.Board[SqD];
		if PieceD = sqOut then Break;
		Inc(Affect[CPos.Side, SqD]);
		Inc(CSco[0], PieceActivity[PieceD]);
		if (PieceD = sqEmpty) or (U1(PieceD) shr 7 <> CPos.Side) or (Game.Variant.Options[voSelfCaptures].Bool) then
		begin
			AddChessMove;
		end;
	end;
end;

procedure MoveDiagonal;
var
	k: SG;
	PieceActivity: PPieceActivity;
begin
	PieceActivity := @PieceActivities[PieceS];
	for k := SG(odLU) to SG(odRD) do
	begin
		SqD := SqS;
		Inc(SqD, Ofst[k]);
		PieceD := CPos.Board[SqD];
		if PieceD = sqOut then Break;
		Inc(Affect[CPos.Side, SqD]);
		Inc(CSco[0], PieceActivity[PieceD]);
		if (PieceD = sqEmpty) or (U1(PieceD) shr 7 <> CPos.Side) or (Game.Variant.Options[voSelfCaptures].Bool) then
		begin
			AddChessMove;
		end;
	end;
end;

procedure MoveOrthogonal;
var
	k: SG;
	PieceActivity: PPieceActivity;
begin
	PieceActivity := @PieceActivities[PieceS];
	for k := SG(odU) to SG(odD) do
	begin
		SqD := SqS;
		Inc(SqD, Ofst[k]);
		PieceD := CPos.Board[SqD];
		if PieceD = sqOut then Break;
		Inc(Affect[CPos.Side, SqD]);
		Inc(CSco[0], PieceActivity[PieceD]);
		if (PieceD = sqEmpty) or (U1(PieceD) shr 7 <> CPos.Side) or (Game.Variant.Options[voSelfCaptures].Bool) then
		begin
			AddChessMove;
		end;
	end;
end;

procedure MoveChineseK;
begin
	MoveChessK; // D???
end;

procedure MoveCannon;
var
	k: SG;
	Capture: BG;
	PieceActivity: PPieceActivity;
begin
	PieceActivity := @PieceActivities[PieceS];
	for k := SG(odU) to SG(odD) do
	begin
		SqD := SqS;
		Capture := False;
		while True do
		begin
			Inc(SqD, Ofst[k]);
			PieceD := CPos.Board[SqD];
			if PieceD = sqOut then Break;
			Inc(Affect[CPos.Side, SqD]);
			Inc(CSco[0], PieceActivity[PieceD]);
			if Capture = False then
			begin
				if PieceD <> sqEmpty then
				begin
					Capture := True;
				end
				else
					AddChessMove;
			end
			else
			begin
				if PieceD <> sqEmpty then
				begin
					if (U1(PieceD) shr 7 <> CPos.Side) or (Game.Variant.Options[voSelfCaptures].Bool) then
					begin
						AddChessMove;
					end;
					Break;
				end;
			end;
		end;
	end;
end;

procedure MoveChessB;
var
	k: SG;
	PieceActivity: PPieceActivity;
begin
	PieceActivity := @PieceActivities[PieceS];
	for k := SG(odLU) to SG(odRD) do
	begin
		SqD := SqS;
		while True do
		begin
			Inc(SqD, Ofst[k]);
			PieceD := CPos.Board[SqD];
			if PieceD = sqOut then Break;
			Inc(Affect[CPos.Side, SqD]);
			Inc(CSco[0], PieceActivity[PieceD]);
			if (PieceD = sqEmpty) then
			begin
				if (GameType = gtShogi) and (PromotionSquares[CPos.Side, SqD] <> 0) then
				begin
					TM := TTM(sqBP0);
					AddChessMove;
					TM := tmNormal;
				end
				else
					AddChessMove;
			end
			else if (U1(PieceD) shr 7 <> CPos.Side) or (Game.Variant.Options[voSelfCaptures].Bool) then
			begin
				if (GameType = gtShogi) and (PromotionSquares[CPos.Side, SqD] <> 0) then
				begin
					TM := TTM(sqBP0);
					AddChessMove;
					TM := tmNormal;
				end
				else
					AddChessMove;
				Break;
			end
			else
				Break;
		end;
	end;
end;

procedure MoveChessR;
var
	k: SG;
	PieceActivity: PPieceActivity;
begin
	PieceActivity := @PieceActivities[PieceS];
	for k := SG(odU) to SG(odD) do
	begin
		SqD := SqS;
		while True do
		begin
			Inc(SqD, Ofst[k]);
			PieceD := CPos.Board[SqD];
			if PieceD = sqOut then Break;
			Inc(Affect[CPos.Side, SqD]);
			Inc(CSco[0], PieceActivity[PieceD]);
			if (PieceD = sqEmpty) then
			begin
				if (GameType = gtShogi) and (PromotionSquares[CPos.Side, SqD] <> 0) then
				begin
					TM := TTM(sqRP0);
					AddChessMove;
					TM := tmNormal;
				end
				else
					AddChessMove;
			end
			else if (U1(PieceD) shr 7 <> CPos.Side) or (Game.Variant.Options[voSelfCaptures].Bool) then
			begin
				if (GameType = gtShogi) and (PromotionSquares[CPos.Side, SqD] <> 0) then
				begin
					TM := TTM(sqRP0);
					AddChessMove;
					TM := tmNormal;
				end
				else
					AddChessMove;
				Break;
			end
			else
				Break;
		end;
	end;
end;

procedure MoveChessQ;
var
	k: SG;
	PieceActivity: PPieceActivity;
begin
	PieceActivity := @PieceActivities[PieceS];
	for k := SG(odLU) to SG(odD) do
	begin
		SqD := SqS;
		while True do
		begin
			Inc(SqD, Ofst[k]);
			PieceD := CPos.Board[SqD];
			if PieceD = sqOut then Break;
			Inc(Affect[CPos.Side, SqD]);
			Inc(CSco[0], PieceActivity[PieceD]);
			if (PieceD = sqEmpty) then
			begin
				AddChessMove;
			end
			else if (U1(PieceD) shr 7 <> CPos.Side) or (Game.Variant.Options[voSelfCaptures].Bool) then
			begin
				AddChessMove;
				Break;
			end
			else
				Break;
		end;
	end;
end;

procedure MoveShogiA;
var
	PieceD2: TSquare;
	PieceActivity: PPieceActivity;
begin
	PieceActivity := @PieceActivities[PieceS];
	SqD := SqS + Ofst[SG(odU)];
	PieceD := CPos.Board[SqD];
	if PieceD <> sqOut then
	begin
		Inc(Affect[CPos.Side, SqD]);
		Inc(CSco[0], PieceActivity[PieceD]);
		if CPos.Side <> 0 then
			PieceD2 := -PieceD
		else
			PieceD2 := PieceD;
		if (PieceD2 <= 0) or (Game.Variant.Options[voSelfCaptures].Bool) then
		begin
			if PromotionSquares[CPos.Side, SqD] <> 0 then
			begin
				TM := TTM(sqAP0);
				AddChessMove;
				TM := tmNormal;
			end;
			AddChessMove;
		end;
	end;
end;

procedure MoveShogiH;
var
	j: SG;
	PieceD2: TSquare;
	PieceActivity: PPieceActivity;
begin
	PieceActivity := @PieceActivities[PieceS];
	for j := SG(odNUL) to SG(odNUR) do
	begin
		SqD := SqS + Ofst[j];
		PieceD := CPos.Board[SqD];
		if PieceD = sqOut then Continue;
		Inc(Affect[CPos.Side, SqD]);
		Inc(CSco[0], PieceActivity[PieceD]);
		if CPos.Side <> 0 then
			PieceD2 := -PieceD
		else
			PieceD2 := PieceD;
		if (PieceD2 <= 0) or (Game.Variant.Options[voSelfCaptures].Bool) then
		begin
			if PromotionSquares[CPos.Side, SqD] <> 0 then
			begin
				TM := TTM(sqHP0);
				AddChessMove;
				TM := tmNormal;
			end;
			AddChessMove;
		end;
	end;
end;

procedure MoveShogiL;
var
	PieceD2: TSquare;
	PieceActivity: PPieceActivity;
begin
	PieceActivity := @PieceActivities[PieceS];
	SqD := SqS;
	while True do
	begin
		Inc(SqD, Ofst[SG(odU)]);
		PieceD := CPos.Board[SqD];
		if PieceD = sqOut then Break;
		Inc(Affect[CPos.Side, SqD]);
		Inc(CSco[0], PieceActivity[PieceD]);
		if CPos.Side <> 0 then
			PieceD2 := -PieceD
		else
			PieceD2 := PieceD;
		if (PieceD2 <= 0) or (Game.Variant.Options[voSelfCaptures].Bool) then
		begin
			AddChessMove;
			if (PieceD2 < 0) then Break;
		end
		else
			Break;
	end;
end;

procedure MoveShogiS;
var
	j: SG;
	PieceD2: TSquare;
	PieceActivity: PPieceActivity;
begin
	PieceActivity := @PieceActivities[PieceS];
	for j := 0 to 7 do
	begin
		if (j in [odL, odR, odD]) then Continue;
		SqD := SqS + Ofst[j];
		PieceD := CPos.Board[SqD];
		if PieceD = sqOut then Continue;
		Inc(Affect[CPos.Side, SqD]);
		Inc(CSco[0], PieceActivity[PieceD]);
		if CPos.Side <> 0 then
			PieceD2 := -PieceD
		else
			PieceD2 := PieceD;
		if (PieceD2 <= 0) or (Game.Variant.Options[voSelfCaptures].Bool) then
		begin
			if PromotionSquares[CPos.Side, SqD] <> 0 then
			begin
				TM := TTM(sqSP0);
				AddChessMove;
				TM := tmNormal;
			end;
			AddChessMove;
		end;
	end;
end;

procedure MoveShogiG;
var
	j: SG;
	PieceD2: TSquare;
	PieceActivity: PPieceActivity;
begin
	PieceActivity := @PieceActivities[PieceS];
	for j := 0 to 7 do
	begin
		if (j in [odLD, odRD]) then Continue;
		SqD := SqS + Ofst[j];
		PieceD := CPos.Board[SqD];
		if PieceD = sqOut then Continue;
		Inc(Affect[CPos.Side, SqD]);
		Inc(CSco[0], PieceActivity[PieceD]);
		if CPos.Side <> 0 then
			PieceD2 := -PieceD
		else
			PieceD2 := PieceD;
		if (PieceD2 <= 0) or (Game.Variant.Options[voSelfCaptures].Bool) then
		begin
			AddChessMove;
		end;
	end;
end;

procedure MoveShogiBP;
begin
	MoveChessB;
	MoveOrthogonal;
end;

procedure MoveShogiRP;
begin
	MoveChessR;
	MoveDiagonal;
end;

{
function CanCapture(PieceS, PieceD: TPiece): BG;
begin

end;}

procedure MoveJunglePiece;
var
	j: SG;
	PieceD2: TPiece;
	PieceActivity: PPieceActivity;
begin
	PieceActivity := @PieceActivities[PieceS];
	Inc(CSco[0], BEvals[CPos.Side][SqS]);
	for j := SG(odU) to SG(odD) do
	begin
		SqD := SqS + Ofst[j];
		PieceD := CPos.Board[SqD];
		if (PieceD = sqOut) then Continue;
		if WaterSquares[SqD] = sqWater then
		begin
			if (Abs(PieceS) = sqRat) then
			begin
				TM := tmNormal;
				AddChessMove;
			end
			else if Abs(PieceS) in [6, 7] then
			begin
				// Jump over water
				while True do
				begin
					Inc(SqD, Ofst[j]);
					PieceD := CPos.Board[SqD];
					if PieceD = sqOut then Break;

					if WaterSquares[SqD] = 0 then
					begin
						if (Sgn(PieceS) <> Sgn(PieceD)) and (Abs(PieceS) >= Abs(PieceD)) then
							AddChessMove;
						Break;
					end
					else
						if PieceD <> sqEmpty then Break;
				end;
			end;
			Continue;
		end;
		if CPos.Side <> 0 then
		begin
			if PieceD = sqDen0 then
			begin
				Inc(CSco[0], 500);
{         CScore := scWin;
				CMC := 0;}
				CCheck[CPos.Side] := True;
//          goto LExit;
			end;
			PieceD2 := -PieceD
		end
		else
		begin
			if PieceD = sqDen1 then
			begin
				Inc(CSco[0], 500);
{         CScore := scWin;
				CMC := 0;}
				CCheck[CPos.Side] := True;
//          goto LExit;
			end;
			PieceD2 := PieceD;
		end;

		Inc(CSco[0], PieceActivity[PieceD]);
		if (PieceD2 = sqEmpty) then
		begin
			AddChessMove;
		end
		else if (PieceD2 < 0) or (Game.Variant.Options[voSelfCaptures].Bool) then
		begin
			// Animal Strength
			if ((Abs(PieceS) = 8) and (Abs(PieceD2) = 1)) then Continue; // Elephant can not be capture rat
			if (Abs(PieceS) < Abs(PieceD2))
			and (not ((Abs(PieceS) = 1) and (Abs(PieceD2) = 8)))
			or (WaterSquares[SqS] <> 0) // it may not capture the Elephant from the water
{         and ((Abs(PieceS) = -1) or (PieceD2 <> -8))} then Continue;
			// Can X
//          Inc(CSco[0], 20);
			AddChessMove;
{         Dec(CSco[0], DEv[sqN0]);}
		end;
	end;
end;

var
	LPiece: array[0..MaxPieces] of procedure;
	LDoMove: procedure;
	LBackMove: procedure(const LastPos: TPos);

procedure MovesChess;
{ Player To move can capture King (previous move was illegal): CCheck[CP0a xor 1] = True
	Player To move must move with King (previous move was + or #): CCheck[CP0a] = True }
label LCont;
const
	ShlUsedSquare = 2;
	SizeUsedSquare = 4;
var
	I, F, T: SG;

	j: SG;
	Sid: SG;

begin
	IncCMC := False;
	CMaxPrior := 0;
	for i := 0 to PlayerMax do
	begin
		Remove[i] := 0;
		CCheck[i] := False;
//    if Game.Variant[gvMateKing].Bool then
		begin
			FillChar(Affect[i][StP], EnP - StP + 1, 0);
		end;
{   for j := 0 to UsedSquareCount - 1 do
			Affect[i, UsedSquares[j]] := 0;}
	end;

	TM := tmNormal;
	for Sid := 0 to PlayerMax do
	begin
		CPos.Side := CPos.Side xor 1;
		Ofst := Offsets[CPos.Side];
		if Sid = 1 then
		begin
			IncCMC := MIncCMC;
			CMaterial[1] := CMaterial[0];
			CSco[1] := CSco[0];
		end
		{$ifdef Debug}
		else
		if CPos.EP <> 0 then
		begin
			if CPos.Board[CPos.EP + Ofst[SG(odU)]] <> 1 - SG(2 * CPos.Side) then
				IE('MovesChess');
		end{$endif};

		//CMC := SG(FCMove);
		PCMove := FCMove;
		CSco[0] := 0;
		CMaterial[0] := 0;
		if CPos.Castles[CPos.Side, caK] then
			Inc(CSco[0], 10);
		if CPos.Castles[CPos.Side, caQ] then
			Inc(CSco[0], 7);

		{$ifdef Debug}
		if CPos.Side = 0 then
		begin
			F := 0;
			T := UsedSquareCount;
			I := 1;
		end
		else
		begin
			F := UsedSquareCount - 1;
			T := -1;
			I := -1;
		end;

		while F <> T do
		begin
			SqS := UsedSquares[F];
			PieceS := CPos.Board[SqS];
			if PieceS = sqEmpty then goto LCont;
			if CPos.Side = 0 then
			begin
				if PieceS > 0 then
				begin
					Inc(CMaterial[0], Material[PieceS]);
					LPiece[PieceS];
				end;
			end
			else
			begin
				if PieceS < 0 then
				begin
					Inc(CMaterial[0], Material[-PieceS]);
					LPiece[-PieceS];
				end;
			end;

			LCont:
			Inc(F, I);
		end;
		{$else}
		if CPos.Side = 0 then
		begin
			// White
			asm // Duplicate
			push esi
			push edi
			mov esi, 0
			mov edi, UsedSquareCount
			shl edi, ShlUsedSquare
			@Loop:
				mov edx, U4 ptr UsedSquares[esi]

				cmp S1 ptr CPos.Board[edx], 0
				jle @NextSquare

				mov SqS, edx

				movzx eax, S1 ptr CPos.Board[edx]
				mov PieceS, al

				mov ecx, U4 ptr [Material + 4*eax]
				add CMaterial[0], cx
				call Pointer(LPiece + 4*eax)

				@NextSquare:
				add esi, SizeUsedSquare
				cmp esi, edi
			jl @Loop
			pop edi
			pop esi
			end;
		end
		else
		begin
			// Black
			asm // Duplicate
			push esi
			push edi
			mov esi, UsedSquareCount
			dec esi
			shl esi, ShlUsedSquare
			mov edi, -SizeUsedSquare
			@Loop:
				mov edx, U4 ptr UsedSquares[esi]

				cmp S1 ptr CPos.Board[edx], 0
				jge @NextSquare

				mov SqS, edx

				movzx eax, S1 ptr CPos.Board[edx]
				mov PieceS, al

				neg al // -
				mov ecx, U4 ptr [Material + 4*eax]
				add CMaterial[0], cx
				call Pointer(LPiece + 4*eax)

				@NextSquare:
				sub esi, SizeUsedSquare
				cmp esi, edi
			jg @Loop
			pop edi
			pop esi
			end;
		end;
		{$endif}

		if Game.Variant.Options[voRCP].Bool and (Remove[CPos.Side] < 2) then
		begin
			TM := tmPut;
			for j := PieceTypes downto 1 do
			begin
				if CPos.Side <> 0 then
					PieceS := -j
				else
					PieceS := j;
				if CPos.CapturedPieces[-PieceS] > 0 then
				begin
					Inc(CMaterial[0], 100 + (Material[j] * UG(Max(2, CPos.CapturedPieces[-PieceS])))); // Calibrate
					if CPos.Side = 0 then
					begin
						F := 0;
						T := UsedSquareCount;
						I := 1;
					end
					else
					begin
						F := UsedSquareCount - 1;
						T := -1;
						I := -1;
					end;
					while F <> T do
					begin
						SqD := UsedSquares[F];
						PieceD := CPos.Board[SqD];
						if PieceD = sqEmpty then
						begin

	//              Inc(CSco[0], SEv[j]);
							if MoveFormat = mfDraughts then
							begin
								ASq[0] := SqD;
								ASq[1] := SqD;
								AddDraughtsMove(0)
							end
							else
							begin
								SqS := SqD;
								AddChessMove;
							end;
	{             if IncCMC then
								begin
									Inc(PMove(CMC).Prior, 10);
								end;}
						end;
						Inc(F, I);
					end;
				end;
			end;
			TM := tmNormal;
		end;
	end;
	Inc(CSco[0], MoveBonus[CMC]);
	CRemove := Remove[CPos.Side];
end;
(*-------------------------------------------------------------------------*)
{$ifndef UCI}
function FindAttack(const Index: SG; const Side: TSide): BG;
var
	i, o, d: SG;
	Count: SG;
begin
	Result := False;
	Count := 1;
	for d := 0 to 7 do
	begin
		i := Index;
		o := Offsets[0, d];
		Inc(i, o);
		while True do
		begin
			case CPos.Board[i] of
			sqOut, sqEmpty: Break;
			end;
			if U1(CPos.Board[i]) shr 7 = U1(Side) then
			begin
				Inc(Count);
				if Count >= Game.Variant.Options[voLineSize].Num then
				begin
					Result := True;
					Exit;
				end;
			end
			else
				Break;
			Inc(i, o);
		end;
		if d and 1 <> 0 then Count := 1;
	end;
end;

procedure MovesGomoku;
label LExit, LNextColumn;
{type
	TColumnStatus = (csLose, csDraw, csWin);
var
	ColumnStatus: array[0..PlayerMax, 0..BoardX - 1] of TColumnStatus; // [Side, Column] Game Result when Side begin
	CS: TColumnStatus;
	ColumnFree: array[ 0..BoardX - 1] of U1;}
var
	i, Index: SG;
	Sq: SG;
	Dir: SG;
	A: SG;

	// Fall
	Good, Bad: array[0..PlayerMax, 0..BoardX - 1] of U1;
const
	None = 255;
var
	x, y
//  , y2
	: SG;
	P1a, P1p: SG;
	Side: SG;
	GP, BP, GBP, BGP: array[0..PlayerMax] of SG;
	NoDraw: BG;

	// Gomoku
//  CNow: array[1..BoardX{Y}] of SG;
	CTotal: array[-1..1, 1..BoardX{Y}] of SG;
	GoPrior: array[0..BoardSize - 1] of U1;
	Sc: SG;
	FreeC, MeC: SG;
	j: SG;
	FreeD: BG;
	R: SG;
begin
	P1a := 1 - SG(2 * CPos.Side);
	P1p := -P1a;

	if Game.Variant.Options[voFallDown].Bool then
	begin
		NoDraw := False;

		// Static Score
		for i := 0 to UsedSquareCount - 1 do
		begin
			Index := UsedSquares[i];
			if CPos.Board[Index] = sqEmpty then
//        Inc(FreeP)
			else if CPos.Board[Index] > 0 then
				Inc(CSco[0], BEval[Index])
			else
				Inc(CSco[1], BEval[Index]);
		end;

		for Side := 0 to PlayerMax do
			for x := 0 to SqX do
			begin
				Good[Side, x] := None;
				Bad[Side, x] := None;
			end;

		for x := 0 to SqX do
		begin
			Index := XYToI(x, 0);
			y := 0;
//      y2 := 0;
			while True do
			begin
				case CPos.Board[Index] of
				sqEmpty:
				begin
//          if y = 0 then ColumnFree[x] := SqYC - y2;
					for Side := 0 to PlayerMax do
					begin
						begin
							if FindAttack(Index, Side) then
							begin
								if (y + Side) and 1 = 0 then
									Good[Side, x] := Min(Good[Side, x], y)
								else
									Bad[Side, x] := Min(Bad[Side, x], y)
							end;
						end;
					end;
					Inc(y);
				end;
				sqOut: Break;
				end;
//        Inc(y2);
				Inc(Index, SqXC2);
			end;
			LNextColumn:
		end;
(*
		if D mod 2 = FreeP mod 2 then GAx := 0 else GAx := 1;
		GPx := GAx xor 1;
		CW := 0;
		// Phase 1 - Lines
		for T := 0 TO 3 do
		begin
			case T of
			0:
			begin
				X := 1; Y := 0
			end;
			1:
			begin
				X := 0; Y := 1
			end;
			2:
			begin
				X := 1; Y := 1
			end;
			3:
			begin
				X := -1; Y := 1
			end
			end;

			if (X = 0) AND (Y = 1) then Z := SqXC else Z := SqX;
			for III := 1 TO Z do
			begin
				Q := 1; P := 0;
				FillChar(C, SizeOf(C), 0);
				CASE T of
				0:
				begin
					SX := 1; SY := III;
				end;
				1:
				begin
					SX := III; SY := 1;
				end;
				2:
				begin
						CASE III of
						1:
						begin
							SX := 4; SY := 1;
						end;
						2:
						begin
							SX := 3; SY := 1;
						end;
						3:
						begin
							SX := 2; SY := 1;
						end;
						4:
						begin
							SX := 1; SY := 1;
						end;
						5:
						begin
							SX := 1; SY := 2;
						end;
						6:
						begin
							SX := 1; SY := 3;
						end;
						end;
				end;
				3:
				begin
					CASE III of
					1:
					begin
						SX := 4; SY := 1
					end;
					2:
					begin
						SX := 5; SY := 1
					end;
					3:
					begin
						SX := 6; SY := 1
					end;
					4:
					begin
						SX := 7; SY := 1
					end;
					5:
					begin
						SX := 7; SY := 2
					end;
					6:
					begin
						SX := 7; SY := 3
					end;
					end;
				end;
				end;

				// Selected square and direction analysis
				AX := SX;
				AY := SY;
				while True do
				begin
					Sq := CPos.Board[XYToI(AX, AY)];
					if Sq = sqOut then
						Break
					else
					begin
						if P < Game.Variant.Options[voLineSize].Num then Inc(P);
						if Sq = P1a then
						begin
							for II := Q TO P do
								Inc(C[II], 1);
						end
						else if Sq = P1p then
						begin
							for II := Q TO P do
								Inc(C[II], 10);
						end;
						begin
							case SG(Game.Variant.Options[voLineSize].Num) - SG(C[Q]) of
							0:
							begin
								CScore := scWin - D;
								goto LExit;
							end;
							1:
							begin
								Inc(CSco[0], 100);
								for II := 0 TO 3 do
								begin
									TX := AX - II * X;
									TY := AY - II * Y;
									if CPos.Board[XYToI(TX, TY)] = sqEmpty then
									begin
										if TY = 1 then
											CW := TX
										else
										begin
											if (CPos.Board[XYToI(TX, TY - 1)] <> sqEmpty) AND (CW >= 0) then CW := TX;
										end;
										if TY MOD 2 = GAx then
										begin
											if Good[CPos.Side, TX] > TY then Good[CPos.Side, TX] := TY;
										end
										else
										begin
											if Bad[CPos.Side, TX] > TY then Bad[CPos.Side, TX] := TY;
										end;
										Break;
									end;
								end;
							end;
							else
							begin
								if 10 * (Game.Variant.Options[voLineSize].Num - 1) = C[Q] then
								begin
									Inc(CSp, 100);
									for II := 0 TO 3 do
									begin
										TX := AX - II * X;
										TY := AY - II * Y;
										if CPos.Board[XYToI(TX, TY)] = sqEmpty then
										begin
											if TY = 1 then
											begin
												CW := -TX; Break;
											end;
											if CPos.Board[XYToI(TX, TY - 1)] <> sqEmpty then
											begin
												CW := -TX; Break;
											end;
											if TY MOD 2 = GPx then
											begin
												if Good[CPos.Side xor 1, TX] > TY then Good[CPos.Side xor 1, TX] := TY;
											end
											else
											begin
												if Bad[CPos.Side xor 1, TX] > TY then Bad[CPos.Side xor 1, TX] := TY;
											end;
											Break;
										end;
									end;
								end;
							end;
							end;
							Inc(Q); // D???
						end;
					end;
					Inc(AX, X);
					Inc(AY, Y);
				end;
			end;
		end;
*)
		for x := 0 to SqX do
		begin
{     Assert(Good[CPos.Side, x] <> Good[CPos.Side xor 1, x]);
			Assert(Bad[CPos.Side, x] <> Bad[CPos.Side xor 1, x]);}
			if Good[CPos.Side, x] = 0 then
			begin
				CScore := scWin;
				goto LExit;
			end;
			if Good[CPos.Side, x] < Good[CPos.Side xor 1, x] then Good[CPos.Side xor 1, x] := None else Good[CPos.Side, x] := None;
			if Bad[CPos.Side, x] < Bad[CPos.Side xor 1, x] then Bad[CPos.Side xor 1, x] := None else Bad[CPos.Side, x] := None;
		end;

		// Phase 2
		FillChar(GP, SizeOf(GP), 0);
		FillChar(BP, SizeOf(BP), 0);
		FillChar(GBP, SizeOf(GBP), 0);
		FillChar(BGP, SizeOf(BGP), 0);
		Side := 0;
		for I := 0 TO SqX do
		begin
			if Good[0, I] < None then
			begin
				if Bad[0, I] = None then
				begin
					Side := Side xor 1;
					if Bad[1, I] = None then Inc(GP[0]) else NoDraw := True;
				end
				else
				begin
					if Good[0, I] < Bad[0, I] then
					begin
						Inc(GBP[0]);
						Side := Side xor 1;
					end
					else
					begin
						Inc(BGP[0]);
					end;
					if Abs(Good[0, I] - Bad[0, I]) = 1 then
					begin
						Inc(CSco[0], 9000);
					end;
				end;
				Continue;
			end;

			if Bad[0, I] < None then
			begin
				if Good[1, I] = None then Inc(BP[0]) else NoDraw := True;
				Continue;
			end;

			if Good[1, I] < None then
			begin
				if Bad[1, I] = None then
					Inc(GP[1])
				else
				begin
					if Good[1, I] > Bad[1, I] then
					begin
						Inc(BGP[1]);
						Side := Side xor 1
					end
					else
					begin
						Inc(GBP[1]);
					end;
					if Abs(Good[1, I] - Bad[1, I]) = 1 then
					begin
						Inc(CSco[1], 9000);
					end;
				end;
				Continue;
			end;

			if Bad[1, I] < None then
			begin
				Side := Side xor 1;
				Inc(BP[1]);
			end;
		end;

		while True do
		begin
			if Side <> 0 then
			begin
				if BP[Side] <> 0 then
				begin
					Dec(BP[Side]);
					Side := Side xor 1
				end
				else if GBP[Side] <> 0 then
				begin
					Dec(GBP[Side]);
					Inc(BP[Side]);
					Side := Side xor 1;
				end
				else if BGP[Side] <> 0 then
				begin
					Dec(BGP[Side]);
					Inc(GP[Side]);
					Side := Side xor 1
				end
				else if (NoDraw) or (GP[Side xor 1] <> 0) or (BP[Side xor 1] <> 0) or (GBP[Side xor 1] <> 0) or (BGP[Side xor 1] <> 0) then
				begin
					Inc(CSco[0], 10000);
					Break;
				end
				else
				begin
//          CScore := GetDrawScore;
//          goto LExit;
					Break;
				end;
			end
			else
			begin
				if GP[Side] <> 0 then
				begin
					Dec(GP[Side]);
					Side := Side xor 1
				end
				else if BGP[Side] <> 0 then
				begin
					Dec(BGP[Side]);
					Inc(GP[Side]);
					Side := Side xor 1
				end
				else if GBP[Side] <> 0 then
				begin
					Dec(GBP[Side]);
					Inc(BP[Side]);
					Side := Side xor 1
				end
				else if (NoDraw) or (GP[Side xor 1] <> 0) or (BP[Side xor 1] <> 0) or (GBP[Side xor 1] <> 0) or (BGP[Side xor 1] <> 0) then
				begin
					Inc(CSco[1], 10000);
					Break;
				end
				else
				begin
//          CScore := GetDrawScore;
//          goto LExit;
					Break;
				end;
			end;
		end;
		if CPos.Side = 0 then
			Exchange(CSco[0], CSco[1]);
		LExit:

		// Add moves
		for x := 0 to SqX do
		begin
			Index := XYToI(x, 0);
			while True do
			begin
				case CPos.Board[Index] of
				sqEmpty:
				begin
//          PMove(CMC).Prior := 10 * (SG(ColumnStatus[CPos.Side xor 1, x]) + 1) + SG(ColumnStatus[CPos.Side, x]) + 1;
					PCMove.Prior := 10 * (SG(Good[CPos.Side, x] <> None) + 1) + SG(Bad[CPos.Side, x] <> None) + 1;
					PCMove.T := Index;
					Inc(SG(PCMove), SizeTMoveGO);
					Break;
				end;
				sqOut: Break;
				end;
				Inc(Index, SqXC2);
			end;
		end;
	end
	else
(*-------------------------------------------------------------------------*)
	begin // Standard
		FillChar(CTotal, SizeOf(CTotal), 0);
		FillChar(GoPrior[StP], EnP - StP + 1, 0);

		for i := 0 to UsedSquareCount - 1 do
		begin
			Index := UsedSquares[i];
			if CPos.Board[Index] <> 0 then
			begin
				for j := 0 to 7 do
					Inc(GoPrior[Index + Offsets[0, j]]);
			end;
		end;

		for i := 0 to UsedSquareCount - 1 do
		begin
			Index := UsedSquares[i];
			Sq := CPos.Board[Index];
			if Sq = 0 then
			begin
				PCMove.Prior := GoPrior[Index];
				PCMove.T := Index;
				Inc(SG(PCMove), SizeTMoveGO);

{       if GoPrior[Index] > 0 then
				begin

				end;}
			end
			else
			begin
				Sc := 0; // D??? analyse only 1x dir.
//        FillChar(CNow, SizeOf(CNow), 0);

				for Dir := 0 to 3 do
				begin
					MeC := 1;
					FreeC := 0;
					for j := 0 to 1 do
					begin
						A := Index;
						FreeD := False;
						R := 0;
						while R < 3 do
						begin
							Inc(A, Offsets[j][2 * Dir]);
							if CPos.Board[A] = sqEmpty then
							begin
								Inc(FreeC);
								if FreeD then
									Break;
								// XXaXX
								FreeD := True;
							end
							else if CPos.Board[A] = sqOut then
								Break
							else if CPos.Board[A] = Sq then
							begin
//                if FreeC >= 2 then FreeC := 1; // after XXaXX

								Inc(MeC);
							end
							else
								Break;
							Inc(R);
						end;
					end;

					if FreeC >= 2 then
					begin
						Inc(Sc, MeC);
					end;
					if MeC + FreeC < Game.Variant.Options[voLineSize].Num then

					else if MeC >= Game.Variant.Options[voLineSize].Num then
					begin
						Inc(CTotal[Sq][1]); // Win
					end
					else if (MeC = Game.Variant.Options[voLineSize].Num - 1) then // 4
					begin
						if FreeC = 2 then
						begin
							// 4 win
							Inc(CTotal[Sq][2]);
						end
						else
						begin
							// 4 can be stopped
							if Sq = P1a then
							begin
								Inc(CTotal[Sq][2]);
							end
							else
							begin
								//Must
							end;
						end;
					end
					else if (MeC = Game.Variant.Options[voLineSize].Num - 2) then // 3
					begin
						if FreeC = 2 then
						begin
							// 3 win?
							Inc(CTotal[Sq][3]);
						end;

					end;
				end;

				if Sq = P1a then
					Inc(CSco[0], Sc)
				else
					Inc(CSco[1], Sc);
			end;
		end;

		// Final analysis
		if CTotal[P1a][1] > 0 then
		begin
			CScore := scWin;
		end
		else if CTotal[P1p][1] > 0 then
		begin
			CScore := -scWin;
//      PCMove := FCMove;
		end
		else if CTotal[P1a][2] > 0 then
		begin
			CScore := scWin;
		end
		else if CTotal[P1p][2] > 1 then
		begin
			CScore := -scWin + 1;
		end
		else if (CTotal[P1a][3] > 1) and (CTotal[P1p][2] = 0) then // mam vic 3, a ty nemas 4
			CScore := scWin - 2;
	end;
	if CScore = scoNone then
		Inc(CSco[0], 30); // Calibrate
end;

procedure MajorityGameResult(out Result: TSubtreeStatus);
var
	k: SG;
	PieceCount: array[-1..1] of UG;
begin
	// Win rule
	PieceCount[-1] := 0;
	PieceCount[0] := 0;
	PieceCount[1] := 0;
	for k := 0 to UsedSquareCount - 1 do
	begin
		Inc(PieceCount[CPos.Board[UsedSquares[k]]]);
	end;
//  if PieceCount[0] = 0 then
	begin
		if PieceCount[-1] > PieceCount[1] then
		begin
			Result.Score := -scWin;
			Result.VariantionCut := vcStalemateLose;
		end
		else if PieceCount[-1] < PieceCount[1] then
		begin
			Result.Score := scWin;
			Result.VariantionCut := vcStalemateWin;
		end
		else
		begin
			Result.Score := GetDrawScore;
			Result.VariantionCut := vcStalemateDraw;
		end;
	end;
end;

procedure Stalemate(var Result: TSubtreeStatus);
begin
	case Game.Variant.Options[voStalemateResult].Num of
	0: // Draw
	begin
		Result.Score := GetDrawScore;
		Result.VariantionCut := vcStalemateDraw;
	end;
	1: // Win
	begin
		Result.Score := -scWin - 1 + DPlus div 2;
		Result.VariantionCut := vcStalemateWin;
	end;
	2: // Lose
	begin
		Result.Score := scWin + 1 - DPlus div 2;
		Result.VariantionCut := vcStalemateLose;
	end;
	else // 3:
	begin // Material
		Assert(GameType in [gtOthello, gtBlobWars]);
		{$ifndef UCI}MajorityGameResult(Result);{$endif}
	end;
	end;
end;

procedure MovesOthello;
label LNext;
var
	i, k: SG;
	SqS, SqD: SG;
	n: SG;
	Piece, OppPiece: TSquare;
	Empty: UG;
begin
	Piece := -2 * S1(CPos.Side) + 1;
	OppPiece := -Piece;
	Empty := 0;
	for k := 0 to UsedSquareCount - 1 do
	begin
		SqS := UsedSquares[k];
		if CPos.Board[SqS] = sqEmpty then
		begin
			Inc(Empty);
			// Can Reverse?
			for i := 0 to 7 do
			begin
				n := 0;
				SqD := SqS + Offsets[0, i];
				while True do
				begin
					if CPos.Board[SqD] <> OppPiece then
					begin
						if CPos.Board[SqD] = Piece then
						begin
							if n > 0 then
							begin
								PCMove.Prior := 128; // GoPrior[Index];
								PCMove.T := SqS;
								Inc(SG(PCMove), SizeTMoveGO);
								goto LNext;
							end;
						end;
						Break;
					end;
					Inc(n);
					Inc(SqD, Offsets[0, i]);
				end;
			end;
		end
		else
		begin
			if CPos.Board[SqS] = Piece then
				Inc(CSco[0], BEval[SqS])
			else
				Inc(CSco[1], BEval[SqS]);
		end;
		LNext:
	end;
	Inc(CSco[0], 150); // Calibrate

	if (PCMove = FCMove) and (Empty > 0) then
	begin
		// Pass
		PCMove.Prior := 128; // GoPrior[Index];
		PCMove.T := NullSquare;
		Inc(SG(PCMove), SizeTMoveGO);
	end;
end;

procedure MovesExplos;
const
	ExplosVal: array[1..3] of U2 = (100, 200, 300); // Calibrate
var
	Index: SG;
	Sq: TSquare;
	i: SG;
	Sc: S2;
begin
	for i := 0 to UsedSquareCount - 1 do
	begin
		Index := UsedSquares[i];
		Sq := CPos.Board[Index];
		if Sq = sqEmpty then
		begin
			PCMove.Prior := (5 - ExplosMax[Index]) shl 4 + Pri[Index];
			PCMove.T := Index;
			Inc(SG(PCMove), SizeTMoveGO);
		end
		else
		begin
			if Abs(Sq) >= ExplosMax[Index] then
				Sc := 0
			else
			begin

				Sc := (3 + Abs(Sq) - ExplosMax[Index]) shl 4; // Calibrate
				if AEP[eoMaterial].Num <> 100 then
					Sc := Sc * AEP[eoMaterial].Num div 100;
				Inc(Sc, ExplosVal[Abs(Sq)]);
			end;
			if (U1(Sq) shr 7) = CPos.Side then
			begin
				PCMove.Prior := 160 + (Abs(Sq) - ExplosMax[Index]) shl 4 + Pri[Index];
				PCMove.T := Index;
				Inc(SG(PCMove), SizeTMoveGO);
				if Abs(Sq) >= ExplosMax[Index] then
				begin
					CScore := -scWin;
					CSco[0] := 32767;
					CSco[1] := 0;
					PCMove := FCMove;
					Exit;
				end;
				Inc(CMaterial[0], Sc);
				Inc(CSco[0], Pri[Index]);
			end
			else
			begin
				if Abs(Sq) >= ExplosMax[Index] then
				begin
					CScore := scWin;
					CSco[1] := 32767;
					CSco[0] := 0;
					PCMove := FCMOve;
					Exit;
				end;
				Inc(CMaterial[1], Sc);
				Inc(CSco[1], Pri[Index]);
			end;
		end;
	end;
	Inc(CSco[0], 50);
end;

procedure DoMoveBlobWars;
var i, Index: SG;
begin
	case PCMove.TM of
	tmNormal:
	begin
		CPos.Board[PCMove.ToSq] := PCMove.F1;
		CPos.Board[PCMove.FrSq] := sqEmpty;
		CPos.Hash.A := CPos.Hash.A xor HashRandom[PCMove.F1, PCMove.FrSq].A;
		CPos.Hash.A := CPos.Hash.A xor HashRandom[PCMove.F1, PCMove.ToSq].A;
	end;
	tmPut:
	begin
		CPos.Hash.A := CPos.Hash.A xor HashRandom[PCMove.F1, PCMove.ToSq].A;
		CPos.Board[PCMove.ToSq] := PCMove.F1;
	end;
	end;
	for i := 0 to 7 do
	begin
		Index := PCMove.ToSq + Offsets[0, i];
		if CPos.Board[Index] = -1 + S1(2 * CPos.Side) then
		begin
			CPos.Hash.A := CPos.Hash.A xor HashRandom[1, Index].A;
			CPos.Hash.A := CPos.Hash.A xor HashRandom[-1, Index].A;
			CPos.Board[Index] := PCMove.F1;
		end;
	end;
	Inc(CPos.LongDraw);
end;

procedure MovesBlobWars;
var
	Index: SG;
	Sq: TSquare;
	i, j: SG;
	ToSq: SG;
	HelpBoard: TBoard;
begin
	CopyBoard(ClearBoard, HelpBoard);

	Ofst := Offsets[CPos.Side];

	// jump
	for i := 0 to UsedSquareCount - 1 do
	begin
		Index := UsedSquares[i];
		Sq := CPos.Board[Index];
		if Sq = sqEmpty then
		begin
		end
		else
		begin
			if (U1(Sq) shr 7) = CPos.Side then
			begin // Friend
				for j := 0 to 7 do
				begin
					ToSq := Index + Ofst[j];
					if CPos.Board[ToSq] = sqOut then Continue;
					if CPos.Board[ToSq] = sqEmpty then
						HelpBoard[ToSq] := 1;
					Inc(ToSq, Ofst[j]);
					if CPos.Board[ToSq] <> sqEmpty then Continue;
					PCMove.Prior := 64 + BEval[ToSq];
					PCMove.F1 := 1 - S1(2 * CPos.Side);
					PCMove.F2 := sqEmpty;
					PCMove.FrSq := Index;
					PCMove.ToSq := ToSq;
					PCMove.TM := tmNormal;
					PCMove.Plus := msNone;
					Inc(SG(PCMove), SizeTMoveChess);
				end;
				for j := 8 to 15 do
				begin
					ToSq := Index + Ofst[j];
					if CPos.Board[ToSq] <> sqEmpty then Continue;
					PCMove.Prior := 64 + BEval[ToSq];
					PCMove.F1 := 1 - S1(2 * CPos.Side);
					PCMove.F2 := sqEmpty;
					PCMove.FrSq := Index;
					PCMove.ToSq := ToSq;
					PCMove.TM := tmNormal;
					PCMove.Plus := msNone;
					Inc(SG(PCMove), SizeTMoveChess);
				end;
				Inc(CMaterial[0], Material[1]);
				Inc(CSco[0], BEval[Index]);
			end
			else
			begin // Enemy
				Inc(CMaterial[1], Material[1]);
				Inc(CSco[1], BEval[Index]);
			end;
		end;
	end;

	// spawn
	for i := 0 to UsedSquareCount - 1 do
	begin
		Index := UsedSquares[i];
		if HelpBoard[Index] <> 0 then
		begin
			PCMove.Prior := 128 + BEval[Index];
			PCMove.F1 := 1 - S1(2 * CPos.Side);
			PCMove.F2 := sqEmpty;
			PCMove.FrSq := Index;
			PCMove.ToSq := Index;
			PCMove.TM := tmPut;
			PCMove.Plus := msNone;
			Inc(SG(PCMove), SizeTMoveChess);
		end;
	end;

	Inc(CSco[0], 50);

	if (PCMove = FCMove) {and (Empty > 0)} then
	begin
		// Pass
		PCMove.Prior := 128; // GoPrior[Index];
		PCMove.F1 := 0;
		PCMove.F2 := 0;
		PCMove.FrSq := NullSquare;
		PCMove.ToSq := NullSquare;
		PCMove.TM := tmNormal;
		PCMove.Plus := msNone;
		Inc(SG(PCMove), SizeTMoveGO);
	end;
end;
{$endif}

procedure EmptyProc;
asm
end;

var
	LMoves: procedure;


type
	PChessCapturedPieces = ^TChessCapturedPieces;
	TChessCapturedPieces = array[-6..6] of U1;
	TEndGame = (egNone, egK_K, egKN_K, egKB_K, egKNN_K{, egKNB_K});
	TEndGameHash = packed record // 4
		HashC: U4;
	end;
const
	MaxEndGameHash = 31;
var
	EndGameHash: array[0..MaxEndGameHash] of TEndGameHash;

function GetEndGameHash(RemainPieces: TChessCapturedPieces): U4;
var i: SG;
begin
	Result := 0;
	for i := -6 to 6 do
		if i <> 0 then
			Result := Result xor (RemainPieces[i] * (HashRandom[i, UsedSquares[1]].Code and $7FFFFFFF));
end;

function GetEndGameHashSwap(RemainPieces: TChessCapturedPieces): U4;
var i: SG;
begin
	Result := 0;
	for i := -6 to 6 do
		if i <> 0 then
			Result := Result xor (RemainPieces[i] * (HashRandom[-i, UsedSquares[1]].Code and $7FFFFFFF));
end;

procedure CalcEndgameHash;
const
	EndGames: array[egK_K..High(TEndGame)] of TChessCapturedPieces = (

	(1, 0, 0, 0, 0, 0,
	0,
	0, 0, 0, 0, 0, 1),

	(1, 0, 0, 0, 0, 0,
	0,
	0, 1, 0, 0, 0, 1),

	(1, 0, 0, 0, 0, 0,
	0,
	0, 0, 1, 0, 0, 1),

	(1, 0, 0, 0, 0, 0,
	0,
	0, 2, 0, 0, 0, 1){,

	(1, 0, 0, 0, 0, 0,
	0,
	0, 1, 1, 0, 0, 1)}
	);
var
	i: TEndGame;
	j: SG;
	H: U4;
begin
	FillChar(EndGameHash, SizeOf(EndgameHash), 0);
	for i := egK_K to High(i) do
	begin
		H := GetEndgameHash(EndGames[TEndGame(i)]);
		j := H and MaxEndGameHash;
		{$ifdef Debug}if EndGameHash[j].HashC <> 0 then
			IE('CalcEndgameHash0');{$endif}
//    EndGameHash[j].Typ := i;
		EndGameHash[j].HashC := H;

		// Transposition
		H := GetEndgameHashSwap(EndGames[TEndGame(i)]);
		j := H and MaxEndGameHash;
		{$ifdef Debug}
		if i <> egK_K then
		if EndGameHash[j].HashC <> 0 then
			IE('CalcEndgameHash1');{$endif}
//    EndGameHash[j].Typ := i;
		EndGameHash[j].HashC := H;
	end;
end;

const
	// Chess only
	LowMtrl = 350 + 400; // Direct draw: KxK, K+NxK, K+BxK
	HighMtrl = 350 + 800; // May be draw: 2xN+KxK

function CanWin: BG;
begin
	Result := not ((MoveFormat = mfChess) and (OMaterial[1] <= LowMtrl));
end;

function InsufficientMaterial(Pos: TPos; Sa, Sp: SG): SG{0, 1, 2};
var
	i: SG;
	RemainPieces: TChessCapturedPieces;
	H: U4;
begin
	// Calibrate
	case GameType of
	gtChess:
	begin
		FillChar(RemainPieces, SizeOf(RemainPieces), 0);
		for i := StP to EnP do // Perf slower 15% in endgame
		begin
			if Pos.Board[i] in [sqEmpty, sqOut] then Continue;
			if (Pos.Board[i] = sqP0) or (Pos.Board[i] = sqP1){[sqP0, sqP1] DNW} then
			begin
				Result := 0;
				Exit;
			end;
			Inc(RemainPieces[Pos.Board[i]]);
			if (RemainPieces[Pos.Board[i]] > 2) then
			begin
				Result := 0;
				Exit;
			end;
		end;

		H := GetEndgameHash(RemainPieces);
		i := H and MaxEndGameHash;
//    if EndGameHash[i].Typ = egNone then Exit;
		if EndGameHash[i].HashC = H then
		begin
			if (Sa < LowMtrl) and (Sp < LowMtrl) then
				Result := 2
			else
				Result := 1;
		end
		else
			Result := 0;
(*    case EndGameHash[i].Typ of
		egK_K: // egK_K
			Result := True;
		egKN_K: // egKN_K
			Result := True;
		egKB_K: // egKB_K
			Result := True;
		egKNN_K: // egKNN_K
			Result := True;
		egKNB_K: // egKNB_K
//    Result := False; // Program can win - False
			Result := True;
		// bad B, a, h pawn, king occupy -> Draw
		{$ifdef Debug}
		else
			IE('InsufficientMaterial'); // Unknown endgame
		{$endif}
		end;*)
	end;
	else
		Result := 0;
	end;
end;

{$ifdef Debug}
procedure CheckMove(M: PMove); // Check if move is correct
begin
	if M = nil then Exit;
	if M.Prior = $ff then
	begin
		IE('CheckMove0');
		M.Prior := 1;
	end;
{ if M.Prior = 0 then
	begin
		IE('CheckMove1');
		M.Prior := 1;
	end;}
	case MoveFormat of
	mfDraughts:
	begin
{   if (CPos.Board[M.ToXY[0]] <> sqEmpty) and (M.Lng <> 8) and (M.Lng <> 12) then
			IE('CheckMoveX');}
//    if M.DraughtsMove > 2 then IE('CheckMove2');
//    if M.Lng = 0 then IE('CheckMove3');
		if M.Lng = $ff then IE('CheckMove4');
		if M.Lng >= 2 then
		if CPos.Board[M.Sq[2]] <> sqEmpty then
			IE('CheckMove5');
	end;
	mfChess:
	begin
		if M.T = High(M.T) then
			IE('CheckMove6');
		if Game.Variant.Options[voSelfCaptures].Bool = False then
		begin
			if (M.F1 > 0) and (M.F2 > 0) then
				IE('CheckMove7');
			if (M.F1 < 0) and (M.F2 < 0) then
				IE('CheckMove8');
		end;
//        M.Plus := False;
		if M.F1 = 0 then
			IE('CheckMove9');
		if CPos.Board[M.FrSq] = sqOut then
				IE('CheckMove10');
		if CPos.Board[M.ToSq] = sqOut then
				IE('CheckMove11');
{   if CPos.Board[M.ToSq] <> M.F2 then
			IE('CheckMove13');}
	end;
	mfGO:
	begin
		if GameType = gtGoMoku then
			if CPos.Board[M.T] <> sqEmpty then
					IE('CheckMove12');
	end;
	end;
end;
{$endif}
(*-------------------------------------------------------------------------*)
{$ifdef Debug}var MFCMove: PMove;{$endif}

function GenerateMoves: TSubtreeStatus;
label LSkip;
var
	M: PMove;
{$ifdef Debug}
	i: SG;
{$endif}
begin
	{$ifdef Debug}
	if FCMove = PMove(@OMove) then
		//
	else if SG(FCMove) < SG(@CMove) then
		IE('GenerateMoves0')
	else if SG(FCMove) + 64 shl ShlTMove >= SG(@CMove) + SizeOf(CMove) then
	begin
		IE('Buffer may overflow');
		Exit;
	end;

	if MIncCMC then
		FillChar(PMove(SG(FCMove))^, SizeOf(CMove) - (SG(FCMove) - SG(@CMove)), $ff);

	if GameType <> gkNone then
		if CPos.Board[0] <> sqOut then IE('GenerateMoves1');

	{$endif}
	Result.VariantionCut := vcNone;
	CMaterial[0] := 0;
	CMaterial[1] := 0;
	CSco[0] := 0;
	CSco[1] := 0;
	CScore := scoNone;
	CRemove := 0;
	CPromote := 0;
	M := PCMove;
	PCMove := FCMove;
	LMoves;
	CTotal[0] := CMaterial[0] + CSco[0];
	CTotal[1] := CMaterial[1] + CSco[1];
	if CScore = scoNone then
		CScore := CTotal[0] - CTotal[1];
	if MIncCMC then
	begin
		CMC := (SG(PCMove) - SG(FCMove)) shr ShlTMove;
	end;
	PCMove := M;
	Result.Score := CScore;
	Result.ScoreBound := sbExact;
	Result.MoveCount := D;

	if Result.Score = -scWin then
	begin
		Result.Score := -scWin - 1 + DPlus div 2;
		Result.VariantionCut := vcMate;
		CMC := 0;
	end;
	if Result.VariantionCut = vcNone then
	begin
		if CCheck[CPos.Side xor 1] then
		begin
			// Engine Late Mate
			Result.Score := scWin + 1 - D div 2;
			Result.VariantionCut := vcMate;
			Result.MoveCount := D{$ifdef Debug} + 1{$endif};
			CMC := 0;
		end
		else if CMC = 0 then
		begin
			if (CSco[0] = 0) then
			begin
				Result.Score := -scWin - 1 + DPlus div 2;
				Result.VariantionCut :=  vcNoPiece;
			end
			else
			begin
				if CCheck[CPos.Side] then
				begin
					// Actual Mate
					Result.Score := -scWin - 1 + DPlus div 2;
					Result.VariantionCut := vcMate;
				end
				else
				begin
					Stalemate(Result);
					goto LSkip;
				end;
			end;
		end
		else
		begin
			if (CSco[0] < HighMtrl) and (CSco[1] < HighMtrl) then
			if Game.Variant.Options[voMateKing].Bool = True then
			case InsufficientMaterial(CPos, CSco[0], CSco[1]) of
			1:
			begin
				Result.Score := GetDrawScore;
				goto LSkip;
			end;
			2:
			begin
				Result.Score := GetDrawScore;
				Result.VariantionCut := vcLowMaterial;
				CMC := 0;
				goto LSkip;
			end;
			end;
		end;
		// Game
	(*  if CSp = 0 then
			begin
				Status.VariantionCut := vcNoPiece;
				CMC := 0;
			end;
		*)
	end;

	if Game.Variant.Options[voSuicide].Bool then
		Result.Score := -Result.Score;

	LSkip:
	{$ifdef Debug}
{ if (MoveFormat <> mfGO) and (CSp = 0) then
	begin
		IE('GenerateMoves3');
	end;}
	{$endif}

	{$ifdef Debug}
	// Checks moves
	if MIncCMC then
	begin
{   if SG(FCMove) + CMC shl ShlTMove > SG(MFCMove) then
		begin
			MFCMove := PMove(SG(FCMove) + CMC shl ShlTMove);
			Echo('Move Stack: ' + IntToStr(SG(MFCMove) - SG(@CMove)) + ' / ' + NToS(SizeOf(CMove)));
		end;}
		M := FCMove;
		for i := 0 to CMC - 1 do
		begin
			CheckMove(M);
			Inc(SG(M), SizeTMove);
		end;
	end;
	{$endif}
end;
(*-------------------------------------------------------------------------*)
procedure MoveChessPiece(FrSq, ToSq: U1);
var Square: TSquare;
begin
	Square := CPos.Board[FrSq];
	CPos.Board[FrSq] := sqEmpty;
	CPos.Board[ToSq] := Square;
	CPos.Hash.A := CPos.Hash.A xor HashRandom[Square, FrSq].A;
	CPos.Hash.A := CPos.Hash.A xor HashRandom[Square, ToSq].A;
end;

procedure BackMove(const LastPos: TPos);
begin
	if PCMove <> nil then
	begin
		LBackMove(LastPos);
	end;
	// Undo
	CPos.Hash := LastPos.Hash;
	CPos.Side := LastPos.Side;
	CPos.LongDraw := LastPos.LongDraw;
	{$ifdef Debug}CheckMove(PCMove);{$endif}
end;

procedure BackMoveChess(const LastPos: TPos);
var
	Piece: TPiece;
	CP0a: U1;
	Castle: U1;
begin
	case PCMove.TM of
	tmNormal:
	begin
		CPos.Board[PCMove.FrSq] := PCMove.F1;
		CPos.Board[PCMove.ToSq] := PCMove.F2;
	end;
	tmDouble:
	begin
		CPos.Board[PCMove.FrSq] := PCMove.F1;
		CPos.Board[PCMove.ToSq] := sqEmpty;
	end;
	tmPut:
	begin
		CPos.Board[PCMove.ToSq] := sqEmpty;
		Inc(CPos.CapturedPieces[-PCMove.F1]);
	end;
	tmOO, tmOOO:
	begin
		CP0a := U1(PCMove.F1) shr 7;
		CPos.Board[PCMove.FrSq] := PCMove.F1; // K
		CPos.Board[PCMove.ToSq] := sqEmpty;

		Castle := S1(PCMove.TM) - S1(tmOO);

		Piece := CPos.Board[PCMove.ToSq + 2 * Castle - 1];
		CPos.Board[PCMove.ToSq + 2 * Castle - 1] := sqEmpty;
		CPos.Board[CastleR[CP0a, TCastleType(Castle)]] := Piece;
	end;
	tmEP:
	begin
		CPos.Board[PCMove.FrSq] := PCMove.F1;
		CPos.Board[PCMove.ToSq] := sqEmpty;
		Dec(CPos.CapturedPieces[-PCMove.F1]);
		if PCMove.FrSq < PCMove.ToSq then
		begin
			CPos.Board[PCMove.ToSq - SqXC2] := -PCMove.F1;
		end
		else
		begin
			CPos.Board[PCMove.ToSq + SqXC2] := -PCMove.F1;
		end;
	end;
	else // Promote
	begin
		CPos.Board[PCMove.FrSq] := PCMove.F1;
		CPos.Board[PCMove.ToSq] := PCMove.F2;
	end;
	end;
	if PCMove.F2 <> sqEmpty then
	begin
		Dec(CPos.CapturedPieces[Unpromote[PCMove.F2]]);
	end;
	CPos.EP := LastPos.EP;
	CPos.Castles := LastPos.Castles;
end;

procedure BackMoveFull(const LastPos: TPos);
begin
	CopyPos(LastPos, CPos);
	{$ifdef Debug}CheckMove(PCMove);{$endif}
end;

procedure BackMoveGomoku(const LastPos: TPos);
begin
	CPos.Board[PCMove.T] := sqEmpty;
	CPos.Hash := LastPos.Hash;
	{$ifdef Debug}CheckMove(PCMove);{$endif}
end;

(*-------------------------------------------------------------------------*)
procedure DoMove;
begin
	{$ifdef Debug}CheckHash(CPos);{$endif}
	if PCMove = nil then
		Inc(CPos.LongDraw)
	else
	begin
		{$ifdef Debug}CheckMove(PCMove);{$endif}
		LDoMove;
	end;

	if PlayerMax = 1 then
	begin
		CPos.Side := CPos.Side xor 1;
	end
	else
	begin
		if CPos.Side = PlayerMax then CPos.Side := 0 else Inc(CPos.Side);
	end;
	CPos.Hash.A := CPos.Hash.A xor HashRandomPlayer.A;
	{$ifdef Debug}CheckHash(CPos);{$endif}
end;

procedure DoMoveChess;
var
	Piece: TPiece;
	CP0a: U1;
	Castle: U1;
begin
	if CPos.EP <> 0 then
	begin
		CPos.Hash.A := CPos.Hash.A xor HashRandomEP.A;
		CPos.EP := 0;
	end;
	if PCMove.F2 <> sqEmpty then
	begin
		CPos.Hash.A := CPos.Hash.A xor HashRandom[PCMove.F2, PCMove.ToSq].A;
		Inc(CPos.CapturedPieces[Unpromote[PCMove.F2]]);
	end;

	case PCMove.TM of
	tmNormal:
	begin
		CPos.Board[PCMove.ToSq] := PCMove.F1;
		CPos.Board[PCMove.FrSq] := sqEmpty;
		CPos.Hash.A := CPos.Hash.A xor HashRandom[PCMove.F1, PCMove.FrSq].A;
		CPos.Hash.A := CPos.Hash.A xor HashRandom[PCMove.F1, PCMove.ToSq].A;

		if GameType = gtCastleAndEP then
		begin
			if PCMove.F1 < 0 then
				CP0a := 1
			else
				CP0a := 0;
			case Abs(PCMove.F1) of
			sqK0:
			begin
				// move with castle king
				if PCMove.FrSq = CastleK[CP0a] then
				begin
					if CPos.Castles[CP0a, caQ] then
					begin
						CPos.Castles[CP0a, caQ] := False;
						CPos.Hash.A := CPos.Hash.A xor HashRandomCastle[CP0a, caQ].A;
					end;
					if CPos.Castles[CP0a, caK] then
					begin
						CPos.Castles[CP0a, caK] := False;
						CPos.Hash.A := CPos.Hash.A xor HashRandomCastle[CP0a, caK].A;
					end;
				end;
			end;
			sqR0:
			begin
				// move with castle rook
				if PCMove.FrSq = CastleR[CP0a, caK] then
				begin
					if CPos.Castles[CP0a, caK] then
					begin
						CPos.Castles[CP0a, caK] := False;
						CPos.Hash.A := CPos.Hash.A xor HashRandomCastle[CP0a, caK].A;
					end;
				end
				else if PCMove.FrSq = CastleR[CP0a, caQ] then
				begin
					if CPos.Castles[CP0a, caQ] then
					begin
						CPos.Castles[CP0a, caQ] := False;
						CPos.Hash.A := CPos.Hash.A xor HashRandomCastle[CP0a, caQ].A;
					end;
				end;
			end;
			end;
			// remove castle rook
			if PCMove.ToSq = CastleR[CP0a xor 1, caK] then
			begin
				if CPos.Castles[CP0a xor 1, caK] then
				begin
					CPos.Castles[CP0a xor 1, caK] := False;
					CPos.Hash.A := CPos.Hash.A xor HashRandomCastle[CP0a xor 1, caK].A;
				end;
			end
			else if PCMove.ToSq = CastleR[CP0a xor 1, caQ] then
			begin
				if CPos.Castles[CP0a xor 1, caQ] then
				begin
					CPos.Castles[CP0a xor 1, caQ] := False;
					CPos.Hash.A := CPos.Hash.A xor HashRandomCastle[CP0a xor 1, caQ].A;
				end;
			end;
		end;
	end;
	tmDouble:
	begin
		CPos.Hash.A := CPos.Hash.A xor HashRandom[PCMove.F1, PCMove.FrSq].A;
		CPos.Board[PCMove.FrSq] := sqEmpty;

		CPos.Hash.A := CPos.Hash.A xor HashRandom[PCMove.F1, PCMove.ToSq].A;
		CPos.Board[PCMove.ToSq] := PCMove.F1;

		if PCMove.F1 < 0 then
			Piece := sqP0
		else
			Piece := sqP1;

		if (CPos.Board[PCMove.ToSq + 1] = Piece) or (CPos.Board[PCMove.ToSq - 1] = Piece) then
		begin
			CPos.Hash.A := CPos.Hash.A xor HashRandomEP.A;
			CPos.EP := (PCMove.ToSq + PCMove.FrSq) div 2;
		end;
	end;
	tmPut:
	begin
		CPos.Hash.A := CPos.Hash.A xor HashRandom[PCMove.F1, PCMove.ToSq].A;
		CPos.Board[PCMove.ToSq] := PCMove.F1;
		Dec(CPos.CapturedPieces[-PCMove.F1]);
	end;
	tmOO, tmOOO:
	begin
		CP0a := U1(PCMove.F1) shr 7;

		// Move King
		CPos.Board[PCMove.FrSq] := sqEmpty;
		CPos.Hash.A := CPos.Hash.A xor HashRandom[PCMove.F1, PCMove.FrSq].A;

		CPos.Board[PCMove.ToSq] := PCMove.F1; // K
		CPos.Hash.A := CPos.Hash.A xor HashRandom[PCMove.F1, PCMove.ToSq].A;

		Castle := S1(PCMove.TM) - S1(tmOO);

		// Move Rook
		MoveChessPiece(CastleR[CP0a, TCastleType(Castle)], PCMove.ToSq + 2 * Castle - 1);

		if CPos.Castles[CP0a, caK] then
		begin
			CPos.Castles[CP0a, caK] := False;
			CPos.Hash.A := CPos.Hash.A xor HashRandomCastle[CP0a, caK].A;
		end;
		if CPos.Castles[CP0a, caQ] then
		begin
			CPos.Castles[CP0a, caQ] := False;
			CPos.Hash.A := CPos.Hash.A xor HashRandomCastle[CP0a, caQ].A;
		end;
	end;
	tmEP:
	begin
		CPos.Hash.A := CPos.Hash.A xor HashRandom[PCMove.F1, PCMove.FrSq].A;
		CPos.Hash.A := CPos.Hash.A xor HashRandom[PCMove.F1, PCMove.ToSq].A;
		CPos.Board[PCMove.FrSq] := sqEmpty;
		CPos.Board[PCMove.ToSq] := PCMove.F1;
		Inc(CPos.CapturedPieces[-PCMove.F1]);
		if PCMove.FrSq < PCMove.ToSq then
		begin
			CPos.Hash.A := CPos.Hash.A xor HashRandom[-PCMove.F1, PCMove.ToSq - SqXC2].A;
			CPos.Board[PCMove.ToSq - SqXC2] := sqEmpty
		end
		else
		begin
			CPos.Hash.A := CPos.Hash.A xor HashRandom[-PCMove.F1, PCMove.ToSq + SqXC2].A;
			CPos.Board[PCMove.ToSq + SqXC2] := sqEmpty;
		end;
	end;
	else // Promote
	begin
		CPos.Hash.A := CPos.Hash.A xor HashRandom[PCMove.F1, PCMove.FrSq].A;
		if PCMove.F1 < 0 then
			Piece := -TPiece(PCMove.TM)
		else
			Piece := TPiece(PCMove.TM);
		CPos.Hash.A := CPos.Hash.A xor HashRandom[Piece, PCMove.ToSq].A;
		CPos.Board[PCMove.FrSq] := sqEmpty;
		CPos.Board[PCMove.ToSq] := Piece;
		if GameType = gtCastleAndEP then
		begin
			if PCMove.F1 < 0 then
				CP0a := 1
			else
				CP0a := 0;
			// remove castle rook
			if PCMove.ToSq = CastleR[CP0a xor 1, caK] then
			begin
				if CPos.Castles[CP0a xor 1, caK] then
				begin
					CPos.Castles[CP0a xor 1, caK] := False;
					CPos.Hash.A := CPos.Hash.A xor HashRandomCastle[CP0a xor 1, caK].A;
				end;
			end
			else if PCMove.ToSq = CastleR[CP0a xor 1, caQ] then
			begin
				if CPos.Castles[CP0a xor 1, caQ] then
				begin
					CPos.Castles[CP0a xor 1, caQ] := False;
					CPos.Hash.A := CPos.Hash.A xor HashRandomCastle[CP0a xor 1, caQ].A;
				end;
			end;
		end;
	end;
	end;
	if (Abs(PCMove.F1) <> sqP0) and (PCMove.F2 = sqEmpty) then
	begin
		Inc(CPos.LongDraw);
	end
	else
	begin
		CPos.LongDraw := 0;
	end;
end;

{$ifndef UCI}
procedure DoMoveDraughts;
var
	x: SG;
begin
	case PCMove.DraughtsMove of
	tmNormal:
	begin
		if (PCMove.Lng <= 1) then Inc(CPos.LongDraw) else CPos.LongDraw := 0;
		CPos.Board[PCMove.Sq[PCMove.Lng]] := PCMove.F1;
		CPos.Hash.A := CPos.Hash.A xor HashRandom[PCMove.F1, PCMove.Sq[PCMove.Lng]].A;
	end;
	tmPut:
	begin
		Inc(CPos.LongDraw);
		CPos.Hash.A := CPos.Hash.A xor HashRandom[PCMove.F1, PCMove.Sq[1]].A;
		CPos.Board[PCMove.Sq[1]] := PCMove.F1;
		Dec(CPos.CapturedPieces[-PCMove.F1]);
	end
	else // Promote
	begin
		CPos.LongDraw := 0;
		CPos.Board[PCMove.Sq[PCMove.Lng]] := TPiece(PCMove.DraughtsMove);
		CPos.Hash.A := CPos.Hash.A xor HashRandom[TPiece(PCMove.DraughtsMove), PCMove.Sq[PCMove.Lng]].A;
	end;
	end;

	CPos.Hash.A := CPos.Hash.A xor HashRandom[CPos.Board[PCMove.Sq[0]], PCMove.Sq[0]].A;
	CPos.Board[PCMove.Sq[0]] := sqEmpty;

	x := 1;
	while x < PCMove.Lng do
	begin
		CPos.Hash.A := CPos.Hash.A xor HashRandom[CPos.Board[PCMove.Sq[x]], PCMove.Sq[x]].A;
		Inc(CPos.CapturedPieces[CPos.Board[PCMove.Sq[x]]]);
		CPos.Board[PCMove.Sq[x]] := sqEmpty;
		Inc(x, 2);
	end;
end;

procedure DoMoveGomoku;
var
	Piece: TSquare;
begin
	Piece := -2 * S1(CPos.Side) + 1;
	CPos.Board[PCMove.T] := Piece;
	CPos.Hash.A := CPos.Hash.A xor HashRandom[Piece, PCMove.T].A;
end;

procedure DoMoveOthello;
var
	SqD: SG;
	Piece, OppPiece: TSquare;
	n: SG;
	i, j: SG;
begin
	if PCMove.T = NullSquare then Exit;
	Piece := -2 * S1(CPos.Side) + 1;
	OppPiece := -Piece;
	SqS := PCMove.T;
	CPos.Board[SqS] := Piece;
	CPos.Hash.A := CPos.Hash.A xor HashRandom[Piece, PCMove.T].A;

	// Reverse
	for i := 0 to 7 do
	begin
		n := 0;
		SqD := SqS + Offsets[0, i];
		while True do
		begin
			if CPos.Board[SqD] <> OppPiece then
			begin
				if CPos.Board[SqD] = Piece then
				begin
					SqD := SqS + Offsets[0, i];
					for j := 0 to n - 1 do
					begin
						CPos.Hash.A := CPos.Hash.A xor HashRandom[OppPiece, SqD].A;
						CPos.Board[SqD] := Piece;
						CPos.Hash.A := CPos.Hash.A xor HashRandom[Piece, SqD].A;
						Inc(SqD, Offsets[0, i]);
					end;
				end;
				Break;
			end;
			Inc(n);
			Inc(SqD, Offsets[0, i]);
		end;
	end;
end;

{

SUB Blast (MAX%(), A%(), P%(), X%, Y%, PL%, SA%(), SF%(), Move%, MX%, MY%, B%)
	P%(X%, Y%) = 0: A%(X%, Y%) = 0
	SF%(PL%) = SF%(PL%) - 1
	CALL Scatter1(SA%(), SF%(), Move%, X%, Y%, SX%, SY%, MX%, MY%, A%(), P%(), PL%, B%)
	DO
		for Y% = 0 TO MY%
			for X% = 0 TO MX%
				if A%(X%, Y%) = MAX%(X%, Y%) then
					Bla% = 1
					P%(X%, Y%) = 0: A%(X%, Y%) = 0
					SF%(PL%) = SF%(PL%) - 1
					CALL Scatter1(SA%(), SF%(), Move%, X%, Y%, SX%, SY%, MX%, MY%, A%(), P%(), PL%, B%)
				end if

				if A%(X%, Y%) > MAX%(X%, Y%) then
					Bla% = 1
					A%(X%, Y%) = A%(X%, Y%) - MAX%(X%, Y%)
					CALL Scatter1(SA%(), SF%(), Move%, X%, Y%, SX%, SY%, MX%, MY%, A%(), P%(), PL%, B%)
				end if
			NEXT X%
		NEXT Y%
		if Bla% = 0 then EXIT DO
		if B% > (MX% + 1) * (MY% + 1) * 3 then EXIT DO
		Bla% = 0
	LOOP
end SUB

}

procedure ScatterMove(FrSq, ToSq: SG);
begin
	if CPos.Board[FrSq] = sqOut then Exit;
	if CPos.Board[ToSq] = sqOut then Exit;

	if CPos.Side = 0 then
	begin
		CPos.Hash.A := CPos.Hash.A xor HashRandom[CPos.Board[FrSq], FrSq].A;
		Dec(CPos.Board[FrSq]);
		CPos.Hash.A := CPos.Hash.A xor HashRandom[CPos.Board[FrSq], FrSq].A;

		CPos.Hash.A := CPos.Hash.A xor HashRandom[CPos.Board[ToSq], ToSq].A;
		if (U1(CPos.Board[ToSq]) shr 7) <> CPos.Side then
			CPos.Board[ToSq] := -CPos.Board[ToSq];

		Inc(CPos.Board[ToSq]);
		CPos.Hash.A := CPos.Hash.A xor HashRandom[CPos.Board[ToSq], ToSq].A;
	end
	else
	begin
		CPos.Hash.A := CPos.Hash.A xor HashRandom[CPos.Board[FrSq], FrSq].A;
		Inc(CPos.Board[FrSq]);
		CPos.Hash.A := CPos.Hash.A xor HashRandom[CPos.Board[FrSq], FrSq].A;

		CPos.Hash.A := CPos.Hash.A xor HashRandom[CPos.Board[ToSq], ToSq].A;
		if (U1(CPos.Board[ToSq]) shr 7) <> CPos.Side then
			CPos.Board[ToSq] := -CPos.Board[ToSq];

		Dec(CPos.Board[ToSq]);
		CPos.Hash.A := CPos.Hash.A xor HashRandom[CPos.Board[ToSq], ToSq].A;
	end;
end;

var
	ExplosDepth: SG;

procedure Scatter(Index: SG);
begin
	if CPos.Board[Index] = sqOut then Exit;
	Inc(ExplosDepth);
	if Abs(CPos.Board[Index]) >= ExplosMax[Index] then
	begin
		while Abs(CPos.Board[Index]) >= ExplosMax[Index] do
		begin
			ScatterMove(Index, Index + Offsets[0, 0]);
			ScatterMove(Index, Index + Offsets[0, 1]);
			ScatterMove(Index, Index + Offsets[0, 2]);
			ScatterMove(Index, Index + Offsets[0, 3]);
		end;
		// Reaction
		if ExplosDepth < 30 then // D???
		begin
			Scatter(Index + Offsets[0, 0]);
			Scatter(Index + Offsets[0, 1]);
			Scatter(Index + Offsets[0, 2]);
			Scatter(Index + Offsets[0, 3]);
		end;
	end;
	Dec(ExplosDepth);
end;

procedure DoMoveExplos;
begin
	if CPos.Side = 0 then
	begin
		CPos.Hash.A := CPos.Hash.A xor HashRandom[CPos.Board[PCMove.T], PCMove.T].A;
		Inc(CPos.Board[PCMove.T]);
		CPos.Hash.A := CPos.Hash.A xor HashRandom[CPos.Board[PCMove.T], PCMove.T].A;
	end
	else
	begin
		CPos.Hash.A := CPos.Hash.A xor HashRandom[CPos.Board[PCMove.T], PCMove.T].A;
		Dec(CPos.Board[PCMove.T]);
		CPos.Hash.A := CPos.Hash.A xor HashRandom[CPos.Board[PCMove.T], PCMove.T].A;
	end;

	Scatter(PCMove.T);
end;
{$endif}

(*-------------------------------------------------------------------------*)
procedure FillPlus(M: PMove; AndMate: BG = False);
var
	i: SG;
	HPos: TPos;
	LFCMove: PMove;
	LPCMove: PMove;
	LCMC: SG;
begin
	if (M = nil) then Exit;
	if Game.Variant.Options[voMateKing].Bool then
	begin
		LCMC := CMC;
		MIncCMC := False;
		GenerateMoves;
		MIncCMC := True;
		if CCheck[CPos.Side] then
		begin
{     if CMC = 0 then
				M.Plus := msMate
			else
			begin}
				if AndMate then
				begin
					M.Plus := msMate;
					CopyPos(CPos, HPos);
					LFCMove := FCMove;
					LPCMove := PCMove;
					{$ifdef Debug}
					if FCMove = PMove(@OMove) then IE('FillPlus');
					{$endif}
					Inc(SG(FCMove), (MaxMoves + 1) shl ShlTMove);
					GenerateMoves;
					for i := 0 to CMC - 1 do
					begin
						PCMove := PMove(SG(FCMove) + i shl ShlTMove);
						DoMove;
						MIncCMC := False;
						GenerateMoves;
						MIncCMC := True;
						CopyPos(HPos, CPos);
						if CCheck[CPos.Side] = False then
						begin
							M.Plus := msCheck;
							Break;
						end;
					end;
					PCMove := LPCMove;
					FCMove := LFCMove;
				end
				else
					M.Plus := msCheck;
//      end;
		end
		else
			M.Plus := msNone;
		CMC := LCMC;
	end
	else if GameType = gtJungle then
		M.Plus := msNone;
end;

procedure RemoveIllegalMoves({var CPos: TPos; }BookPlusReindex: BG = False);
label LCont;
var
	i: SG;
	InCheck: BG;
	MoveD: PMove;
	MC: SG;
	HPos: TPos;
	BHash: PBHashPos;
	LFCMove: PMove;
begin
	if Game.Variant.Options[voMateKing].Bool then
	begin
		CopyPos(CPos, HPos);
		PCMove := FCMove;
		InCheck := CCheck[CPos.Side];

		MoveD := PCMove;
		{$ifdef Debug}CheckHash(CPos);{$endif}
		MC := 0;
		for i := 0 to CMC - 1 do
		begin
			if InCheck and (PCMove.TM in [tmOO, tmOOO]) then
			begin // Can not castling after check
				goto LCont; // Remove move
			end
			else
			begin
				DoMove;
				MIncCMC := False;
				GenerateMoves;
				MIncCMC := True;
				if CCheck[CPos.Side xor 1] then
				begin
					CopyPos(HPos, CPos);
					goto LCont; // Remove move
				end;
				// Move is legal
				if BookPlusReindex then
				begin
					if (BHashTable <> nil) then
					begin
						BHash := FindBHash(CPos.Hash);
						if BHash <> nil then
						begin
							MoveInfos[MC].BookCount := BHash.Found;
						end
						else
							MoveInfos[MC].BookCount := 0;
					end
					else
						MoveInfos[MC].BookCount := 0;

					LFCMove := FCMove;
					FCMove := PMove(@CMove);
					FillPlus(PCMove, True);
					FCMove := LFCMove;
				end;
				CopyPos(HPos, CPos);
			end;
			if PCMove <> MoveD then
				Move(PCMove^, MoveD^, SizeTMove);
			Inc(SG(MoveD), SizeTMove);
			if BookPlusReindex then
			begin
				RMoveToIndex[MC] := i;
				IndexToRMove[i] := MC;
			end;
			Inc(MC);
			LCont:
			Inc(SG(PCMove), SizeTMove);
		end;
		CMC := MC;
		CCheck[CPos.Side] := InCheck;
	end
	else
	begin
		if BookPlusReindex then
		begin
			for i := 0 to CMC - 1 do
			begin
				MoveInfos[i].BookCount := 0;
				RMoveToIndex[i] := i;
				IndexToRMove[i] := i;
			end;
			if MoveFormat = mfChess then
			begin
				PCMove := FCMove;
				for i := 0 to CMC - 1 do
				begin
					PCMove.Plus := msNone;
					Inc(SG(PCMove), SizeTMove);
				end;
			end;
		end;
	end;
end;


procedure FillChessVariant;
begin
	Game.GameType := gtChess;
	Game.Variant.Options[voWidth].Num := 8;
	Game.Variant.Options[voHeight].Num := 8;
	Game.Variant.Options[voShuffle].Num := NoShuffle;
	Game.Variant.Options[voSuicide].Bool := False;
	Game.Variant.Options[voRCP].Bool := False;
	Game.Variant.Options[voMustCapture].Bool := False;
	Game.Variant.Options[voPromote].Num := 1;
	Game.Variant.Options[voMateKing].Bool := True;
	// Add Option
end;

procedure FillStartPos;
	procedure SymetricBoard(var B: TBoard);
	var i, Index, Index2: SG;
	begin
		for i := 0 to UsedSquareCount - 1 do
		begin
			Index := UsedSquares[i];
			Index2 := UsedSquares[UsedSquareCount - 1 - i];
			if PieceOnSquare(B[Index]) {and (B[Index2] = sqEmpty)} then
				B[Index2] := -B[Index];
		end;
	end;

label LCont;
var
	x, y, i, Index: SG;
//  c, c2: UG;
	Piece: TPiece;
//  Sq: TSquare;
	LRandSeed: S4;
	Id: SG;
	B: BG;
const
	// Chess 960
	KRNCode: array[0..9, 0..4] of TPiece = (
		(sqN0, sqN0, sqR0, sqK0, sqR0),
		(sqN0, sqR0, sqN0, sqK0, sqR0),
		(sqN0, sqR0, sqK0, sqN0, sqR0),
		(sqN0, sqR0, sqK0, sqR0, sqN0),
		(sqR0, sqN0, sqN0, sqK0, sqR0),
		(sqR0, sqN0, sqK0, sqN0, sqR0),
		(sqR0, sqN0, sqK0, sqR0, sqN0),
		(sqR0, sqK0, sqN0, sqN0, sqR0),
		(sqR0, sqK0, sqN0, sqR0, sqN0),
		(sqR0, sqK0, sqR0, sqN0, sqN0));
var
	Res, Rem: U4;
begin
	// Params
	{$ifndef UCI}
	GameType := Game.GameType;
	case GameType of
	gtGomoku, gtExplosion, gtOthello: MoveFormat := mfGO;
	gtDraughts: MoveFormat := mfDraughts;
	else MoveFormat := mfChess;
	// Add Game
	end;
	{$endif}

	MustCapture := Game.Variant.Options[voMustCapture].Num and 1 + 1;
	if Game.Variant.Options[voWidth].Num < 2 then
	begin
		Game.Variant.Options[voWidth].Num := 8;
	end;
	if Game.Variant.Options[voHeight].Num < 2 then
	begin
		Game.Variant.Options[voHeight].Num := 8;
	end;

	SqXC := Game.Variant.Options[voWidth].Num;
	SqYC := Game.Variant.Options[voHeight].Num;
	SqX := SqXC - 1;
	SqY := SqYC - 1;

	// SqXC2
	if GameType in [gtChess, gtChineseChess, gtBlobWars] then i := 2 else i := 1; // Add Game
	SqXC2 := {Max(SqXC and 1, UG(i)) +} SqXC + i;
	if (GameType = gtDraughts) and (SqXC and 1 <> 0) then
		Inc(SqXC2);

	ShlTMove := OShlTMove[MoveFormat];
	SizeTMove := 1 shl ShlTMove;

	GetStEnP(SqXC, SqYC);
	FillChar(StartPos.Board, SizeOf(StartPos.Board), sqOut);

	FillUsedSquares(StartPos.Board, True);

	// Piece Procedures
	for i := Low(LPiece) to High(LPiece) do
		LPiece[i] := MoveEmptyPiece;

	PromotePawnTo := 0;
	LDoMove := nil;
	LBackMove := nil;
	LMoves := nil;
	case MoveFormat of
	mfChess:
	begin
		LDoMove := DoMoveChess;
		LBackMove := BackMoveChess;
		LMoves := MovesChess;
	end;
	{$ifndef UCI}
	mfDraughts:
	begin
		LDoMove := DoMoveDraughts;
		LBackMove := BackMoveFull;
		LMoves := MovesChess;
	end;
	mfGO:
	begin
		LDoMove := DoMoveGomoku;
		LBackMove := BackMoveFull;
		LMoves := MovesGomoku;
	end;
	{$endif}
	end;

	// Pieces
	case GameType of
	gkNone:
	begin
		PieceTypes := 0;
	end;
	gtChess:
	begin
		King := sqK0;
		PromotePawnTo := King - (Game.Variant.Options[voMateKing].Num and 1);
		LPiece[sqP0] := MoveChessP;
		LPiece[sqN0] := MoveChessN;
		LPiece[sqB0] := MoveChessB;
		LPiece[sqR0] := MoveChessR;
		LPiece[sqQ0] := MoveChessQ;
		LPiece[sqK0] := MoveChessK;
		PieceTypes := 6;
	end;
	{$ifndef UCI}
	gtDraughts:
	begin
		LPiece[sqP0] := MoveDraughtsMan;
		LPiece[sqN0] := MoveDraughtsKing;
		PieceTypes := 2;
	end;
	gtChineseChess:
	begin
		King := sqK0;
		PromotePawnTo := King - (Game.Variant.Options[voMateKing].Num and 1);
		LPiece[sqP0] := MoveChessP;
		LPiece[sqN0] := MoveMao;
		LPiece[sqB0] := MoveElephant;
		LPiece[sqR0] := MoveChessR;
		LPiece[sqQ0] := MoveMandarin;
		LPiece[sqK0] := MoveChineseK;
		LPiece[sqC0] := MoveCannon;
		PieceTypes := 7;
	end;
	gtShogi:
	begin
		King := sqShogiK0;
		LPiece[sqA0] := MoveShogiA;
		LPiece[sqShogiB0] := MoveChessB;
		LPiece[sqShogiR0] := MoveChessR;
		LPiece[sqL0] := MoveShogiL;
		LPiece[sqH0] := MoveShogiH;
		LPiece[sqS0] := MoveShogiS;
		LPiece[sqG0] := MoveShogiG;
		LPiece[sqShogiK0] := MoveChessK;

		LPiece[sqSP0] := MoveShogiG;
		LPiece[sqHP0] := MoveShogiG;
		LPiece[sqLP0] := MoveShogiG;
		LPiece[sqAP0] := MoveShogiG;

		LPiece[sqBP0] := MoveShogiBP;
		LPiece[sqRP0] := MoveShogiRP;
		PieceTypes := 14;
	end;
	gtGomoku:
	begin
		LDoMove := DoMoveGomoku;
		LBackMove := BackMoveGomoku;
		LMoves := MovesGomoku;
		PieceTypes := 1;
	end;
	gtOthello:
	begin
		LDoMove := DoMoveOthello;
		LBackMove := BackMoveFull;
		LMoves := MovesOthello;
		PieceTypes := 1;
	end;
	gtExplosion:
	begin
		LDoMove := DoMoveExplos;
		LBackMove := BackMoveFull;
		LMoves := MovesExplos;
		PieceTypes := 4;
	end;
	gtJungle:
	begin
		LDoMove := DoMoveChess;
		LBackMove := BackMoveChess;
		LMoves := MovesChess;
		King := sqDen0;
		LPiece[1] := MoveJunglePiece;
		LPiece[2] := MoveJunglePiece;
		LPiece[3] := MoveJunglePiece;
		LPiece[4] := MoveJunglePiece;
		LPiece[5] := MoveJunglePiece;
		LPiece[6] := MoveJunglePiece;
		LPiece[7] := MoveJunglePiece;
		LPiece[8] := MoveJunglePiece;
		PieceTypes := 8;
	end;
	gtBlobWars:
	begin
		LDoMove := DoMoveBlobWars;
		LBackMove := BackMoveFull;
		LMoves := MovesBlobWars;
		PieceTypes := 1;
	end;
	// Add Game
	{$endif}
	end;

	if MoveFormat = mfChess then
	begin
		for i := -PieceTypes to PieceTypes do
		begin
			Piece := i;
			if Abs(i) >= sqAP0 then
			begin
				case i of
				sqAP0: Piece := sqA0;
				sqAP1: Piece := sqA1;
				sqHP0: Piece := sqH0;
				sqHP1: Piece := sqH1;
				sqLP0: Piece := sqL0;
				sqLP1: Piece := sqL1;
				sqSP0: Piece := sqS0;
				sqSP1: Piece := sqS1;
				sqBP0: Piece := sqShogiB0;
				sqBP1: Piece := sqShogiB1;
				sqRP0: Piece := sqShogiR0;
				sqRP1: Piece := sqShogiR1;
				end;
			end;
			Unpromote[i] := Piece;
		end;
	end;
	// Hash
	LRandSeed := RandSeed;
	RandSeed := 0;
	Random(0);
	for i := 0 to UsedSquareCount - 1 do
	begin
		Index := UsedSquares[i];
		for Piece := -PieceTypes to PieceTypes do
		begin
//      if Piece <> fiNone then
			begin
				HashRandom[Piece, Index].Index := RandomU4;
				HashRandom[Piece, Index].Code := RandomU4;
			end;
			if Piece = sqEmpty then
			begin
				HashRandom[Piece, Index].Index := 0;
				HashRandom[Piece, Index].Code := 0;
			end;
		end;
	end;
	HashRandomPlayer.Index := RandomU4;
	HashRandomPlayer.Code := RandomU4;
	HashRandomEP.Index := RandomU4;
	HashRandomEP.Code := RandomU4;
	for i := 0 to PlayerMax do
	begin
		for Index := 0 to 1 do
		begin
			HashRandomCastle[i, TCastleType(Index)].Index := RandomU4;
			HashRandomCastle[i, TCastleType(Index)].Code := RandomU4;
		end;
	end;
	if GameType = gtChess then
		CalcEndgameHash;
	RandSeed := LRandSeed;

	// StartPos
	for Index := 0 to UsedSquareCount - 1 do
		StartPos.Board[UsedSquares[Index]] := sqEmpty;
	ClearBoard := StartPos.Board;

	// Automatic start position
	for i := 0 to UsedSquareCount - 1 do
	begin
//    Index := XYToI(x, y);
		Index := UsedSquares[i];
		IToXY(Index, x, y);

		case GameType of
		gtDraughts:
		begin
			if Game.Variant.Options[voLineSize].Num > SqX div 2 then
				Game.Variant.Options[voLineSize].Num := SqX div 2;
			if (x and 1) = (y and 1) then
			if (y < Game.Variant.Options[voLineSize].Num{SqY div 2}) or (y = 0) then
			begin
				StartPos.Board[Index] := sqP0;
			end;
{     else if y in [SqY, SqY - 1, SqY - 2] then
			begin
				StartPos[Index] := sqP1;
			end;}
		end;
		gtChess:
		begin
			if SqYC = 3 then
			begin
				if y = 0 then
					StartPos.Board[Index] := sqP0;
			end
			else if (y = 0) and (Game.Variant.Options[voShuffle].Num = NoShuffle) then
			begin
				if (x = 1) or (x = SqX - 1) then StartPos.Board[Index] := sqN0;
				if (x = 2) or (x = SqX - 2) then StartPos.Board[Index] := sqB0;
				if (x = 0) then
				begin
					StartPos.Board[Index] := sqR0;
					CastleR[0, caQ] := Index;
					CastleR[1, caQ] := XYToI(x, SqY - y);
				end;
				if (x = SqX) then
				begin
					StartPos.Board[Index] := sqR0;
					CastleR[0, caK] := Index;
					CastleR[1, caK] := XYToI(x, SqY - y);
				end;
				if {(x = 3)} (x = SqX div 2) then StartPos.Board[Index] := sqQ0;
				if {(x = SqX - 3)} (x = SqXC div 2) then
				begin
					StartPos.Board[Index] := sqK0;
					CastleK[0] := Index;
					CastleK[1] := XYToI(x, SqY - y);
				end;
			end
			else if (y = 1) then StartPos.Board[Index] := sqP0;
		end;
		gtShogi:
		begin
			if (y = 2) and (SqYC div 2 > 2) then StartPos.Board[Index] := sqA0
			else if (y = 1) and (SqYC div 2 > 1) then
			begin
				if x = 1 then StartPos.Board[Index] := sqShogiB0
				else if x = SqX - 1 then StartPos.Board[Index] := sqShogiR0;
			end
			else if y = 0 then
			begin
				if (x = 4) then StartPos.Board[Index] := sqShogiK0
				else if (x = 3) or (x = SqX - 3) then StartPos.Board[Index] := sqG0
				else if (x = 2) or (x = SqX - 2) then StartPos.Board[Index] := sqS0
				else if (x = 1) or (x = SqX - 1) then StartPos.Board[Index] := sqH0
				else if (x = 0) or (x = SqX - 0) then StartPos.Board[Index] := sqL0;
			end;
		end;
		gtJungle:
		begin
			if (x = 0) and (y = 2) then StartPos.Board[Index] := 8
			else if (x = 0) and (y = 0) then StartPos.Board[Index] := 7
			else if (x = SqX) and (y = 0) then StartPos.Board[Index] := 6
			else if (x = SqX - 2) and (y = 2) then StartPos.Board[Index] := 5
			else if (x = SqX - 1) and (y = 1) then StartPos.Board[Index] := 4
			else if (x = 2) and (y = 2) then StartPos.Board[Index] := 3
			else if (x = 1) and (y = 1) then StartPos.Board[Index] := 2
			else if (x = SqX) and (y = 2) then StartPos.Board[Index] := 1
			else if (x = SqX div 2) and (y = 0) then
			begin
				StartPos.Board[Index] := sqDen0;
				Den0 := Index;
			end
			else if (x = SqX div 2) and (y = SqY) then
			begin
				StartPos.Board[Index] := sqDen1;
				Den1 := Index;
			end
			else
				StartPos.Board[Index] := sqEmpty;
		end;
		// Add Game
		end;
	end;

	if GameType = gtChess then
	if (Game.Variant.Options[voShuffle].Num <> NoShuffle) then
	begin
		// Shuffle, 518 = Standard position
		Id := Game.Variant.Options[voShuffle].Num;

		// Clear
		for x := 0 to SqX do
		begin
			Index := XYToI(x, SqY);
			Game.Variant.Pos.Board[Index] := sqEmpty;
			Index := XYToI(x, 0);
			Game.Variant.Pos.Board[Index] := sqEmpty;
		end;

		DivModU8(Id, Max(4, SqXC div 2), Res, Rem);
		if Rem < UG(SqXC) div 2 then
			Game.Variant.Pos.Board[XYToI(2 * Rem + 1, 0)] := sqB0;
		Id := Res;

		DivModU8(Id, Max(4, (SqXC + 1) div 2), Res, Rem);
		if Rem < (UG(SqXC) + 1) div 2 then
			Game.Variant.Pos.Board[XYToI(2 * Rem, 0)] := sqB0;
		Id := Res;

		DivModU8(Id, Max(6, SqXC - 2), Res, Rem);
		i := 0;
		for x := 0 to SqX do
		begin
			Index := XYToI(x, 0);
			if Game.Variant.Pos.Board[Index] = sqEmpty then
			begin
				if UG(i) = Rem then
				begin
					Game.Variant.Pos.Board[Index] := sqQ0;
					Break;
				end;
				Inc(i);
			end;
		end;
		Id := Res;

		DivModU8(Id, 10, Res, Rem);
		i := 0;
		for x := 0 to SqX do
		begin
			Index := XYToI(x, 0);
			if Game.Variant.Pos.Board[Index] = sqEmpty then
			begin
				Game.Variant.Pos.Board[Index] := TSquare(KRNCode[Rem, i]);
				Inc(i); if i >= Length(KRNCode[Rem]) then Break;
			end;
		end;

		SymetricBoard(Game.Variant.Pos.Board);
		FillHashIC(Game.Variant.Pos);
	end;
	SymetricBoard(StartPos.Board);
	StartPos.LongDraw := 0;
	StartPos.MoveIndex := 0;
	StartPos.Side := 0;
	StartPos.EP := 0;

	B := (Game.Variant.Options[voWidth].Num > 5) and (GameType = gtCastleAndEP) and (Game.Variant.Options[voShuffle].Num = NoShuffle);
	for i := 0 to PlayerMax do
	begin
		StartPos.Castles[i, caQ] := B;
		StartPos.Castles[i, caK] := B;
	end;
	FillChar(StartPos.CapturedPieces, SizeOf(StartPos.CapturedPieces), 0);
	FillHashIC(StartPos);

	// Fill Other Boards, do not use CopyBoard!
	CPos := StartPos;
	APos := StartPos;
	AStartPos := StartPos;
{ CopyPos(StartPos, CPos);
	CopyPos(StartPos, APos);
	CopyPos(StartPos, AStartPos);}

	// Promote
	FillChar(PromotionSquares, SizeOf(PromotionSquares), 0);
	if Game.Variant.Options[voPromote].Num > 0 then
	begin
		for Index := 0 to UsedSquareCount - 1 do
		begin
			i := UsedSquares[Index];
			IToXY(i, x, y);
			if y in [0] then
				PromotionSquares[1, i] := sqP0;
			if y in [SqY] then
				PromotionSquares[0, i] := sqP1;

			if (GameType = gtShogi) then
			begin
				if SqY >= 7 then
				begin
					if y in [2] then
						PromotionSquares[1, i] := sqP0;
					if y in [SqY - 2] then
						PromotionSquares[0, i] := sqP1;
				end;
				if SqY >= 5 then
				begin
					if y in [1] then
						PromotionSquares[1, i] := sqP0;
					if y in [SqY - 1] then
						PromotionSquares[0, i] := sqP1;
				end;
			end;
		end;
	end;

	// Double
	FillChar(DoubleSquares, SizeOf(DoubleSquares), 0);
	case GameType of
	gtChess:
	begin
		if SqYC >= 8 then
		begin
			for Index := 0 to UsedSquareCount - 1 do
			begin
				i := UsedSquares[Index];
				IToXY(i, x, y);
				if y in [1] then
					DoubleSquares[i] := sqP0;
			end;
			SymetricBoard(DoubleSquares);
		end;
	end;
	gtJungle:
	begin
		for Index := 0 to UsedSquareCount - 1 do
		begin
			i := UsedSquares[Index];
			IToXY(i, x, y);
				if ((x = 0) or (x = SqX) or (x = SqX div 2) or (x = (SqX + 1) div 2))
				or ((y < 3) or (y > SqY - 3)) then
				begin

				end
				else
					WaterSquares[i] := sqWater;
		end;
	end;
	end;

	// Offsets
	FillChar(Offsets, SizeOf(Offsets), 0);
	case GameType of
	gtDraughts:
	begin
		// x
{   Offsets[0, odLU] := SqXC2 - 1;
		Offsets[0, odRU] := SqXC2 + 1;
		Offsets[0, odLD] := -SqXC2 - 1;
		Offsets[0, odRD] := -SqXC2 + 1;}
		Offsets[0, odLU] := SG(XYToI(0, 2)) - SG(XYToI(1, 1));
		Offsets[0, odRU] := SG(XYToI(2, 2)) - SG(XYToI(1, 1));
		Offsets[0, odLD] := SG(XYToI(0, 0)) - SG(XYToI(1, 1));
		Offsets[0, odRD] := SG(XYToI(2, 0)) - SG(XYToI(1, 1));

		for i := 0 to Length(Offsets[1]) - 1 do
			Offsets[1, i] := -Offsets[0, i];

{   Offsets[0, odU] := StP; //Offsets[0, odL] - SqXC2 div 2 - 1; // XYToI(0, SqY);
		Offsets[0, odL] := XYToI(SqX, SqY - 2);
		Offsets[0, odR] := Offsets[0, odL] + 1;
		Offsets[0, odD] := Offsets[0, odR] + SqXC2 div 2; //XYToI(SqX, SqY - 1);}
		Offsets[0, odU] := StP; //Offsets[0, odL] - SqXC2 div 2 - 1; // XYToI(0, SqY);
		Offsets[0, odL] := XYToI(SqX, SqY - 2);
		Offsets[0, odR] := Offsets[0, odL] + 1;
		Offsets[0, odL] := Offsets[0, odR] + SqXC2 div 2; //XYToI(SqX, SqY - 1);

{   Offsets[0, odNUL] := S2($ff01);
		Offsets[0, odNUR] := S2($fe02);}

{   Offsets[1, odU] := XYToI(0, 2);
		Offsets[1, odL] := EnP; //Offsets[1, odU] + SqXC2 div 2 - 1;// XYToI(SqX, 0);
		Offsets[1, odR] := StP + UG(SqXC2 div 2); //XYToI(SqX, 1);
		Offsets[1, odD] := Offsets[1, odR] + SqXC2 div 2; // XYToI(1, 1);}
		Offsets[1, odU] := XYToI(0, 2);
		Offsets[1, odL] := EnP; //Offsets[1, odU] + SqXC2 div 2 - 1;// XYToI(SqX, 0);
		Offsets[1, odU] := StP + UG(SqXC2 div 2); //XYToI(SqX, 1);
//    Offsets[1, odL] := Offsets[1, odR] + SqXC2 div 2; // XYToI(1, 1);

{   Offsets[1, odNUL] := S2($01ff);
		Offsets[1, odNUR] := S2($02fe);}
	end;
	gtChess, gtChineseChess, gtShogi, gtBlobWars:
	begin
		// x
		Offsets[0, odLU] := SqXC2 - 1;
		Offsets[0, odRU] := SqXC2 + 1;
		Offsets[0, odLD] := -SqXC2 - 1;
		Offsets[0, odRD] := -SqXC2 + 1;

		Offsets[1, odLU] := -SqXC2 - 1;
		Offsets[1, odRU] := -SqXC2 + 1;
		Offsets[1, odLD] := SqXC2 - 1;
		Offsets[1, odRD] := SqXC2 + 1;
		// +
		Offsets[0, odU] := SqXC2;
		Offsets[0, odL] := -1;
		Offsets[0, odR] := +1;
		Offsets[0, odD] := -SqXC2;

		Offsets[1, odU] := -SqXC2;
		Offsets[1, odL] := -1;
		Offsets[1, odR] := +1;
		Offsets[1, odD] := SqXC2;
		// N
		Offsets[0, odNUL] := 2 * SqXC2 - 1;
		Offsets[0, odNUR] := 2 * SqXC2 + 1;
		Offsets[0, odNLU] := SqXC2 - 2;
		Offsets[0, odNRU] := SqXC2 + 2;
		Offsets[0, odNLD] := -SqXC2 - 2;
		Offsets[0, odNRD] := -SqXC2 + 2;
		Offsets[0, odNDL] := -2 * SqXC2 - 1;
		Offsets[0, odNDR] := -2 * SqXC2 + 1;

		Offsets[1, odNUL] := -2 * SqXC2 - 1;
		Offsets[1, odNUR] := -2 * SqXC2 + 1;
		Offsets[1, odNLU] := -SqXC2 - 2;
		Offsets[1, odNRU] := -SqXC2 + 2;
		Offsets[1, odNLD] := SqXC2 - 2;
		Offsets[1, odNRD] := SqXC2 + 2;
		Offsets[1, odNDL] := 2 * SqXC2 - 1;
		Offsets[1, odNDR] := 2 * SqXC2 + 1;

//    i := Max(0, Min(2, SqYC div 2 - 2));

{   Offsets[0, odPDF] := XYToI(0, 1);
		Offsets[0, odPDT] := XYToI(SqX, i);
		Offsets[0, odPCF] := XYToI(0, SqY - 2 * SG(GameType = gtShogi));
		Offsets[0, odPCT] := XYToI(SqX, SqY);

		Offsets[1, odPDF] := XYToI(0, SqY - i);
		Offsets[1, odPDT] := XYToI(SqX, SqY - 1);
		Offsets[1, odPCF] := XYToI(0, 0);
		Offsets[1, odPCT] := XYToI(SqX, 0 + 2 * SG(GameType = gtShogi));}
	end;
	gtJungle:
	begin
		// +
		Offsets[0, odU] := SqXC2;
		Offsets[0, odL] := -1;
		Offsets[0, odR] := +1;
		Offsets[0, odD] := -SqXC2;

		Offsets[1, odU] := -SqXC2;
		Offsets[1, odL] := -1;
		Offsets[1, odR] := +1;
		Offsets[1, odD] := SqXC2;
	end;
	gtExplosion:
	begin
		// +
		Offsets[0, odLU] := -SqXC2;
		Offsets[0, odRU] := -1;
		Offsets[0, odLD] := +1;
		Offsets[0, odRD] := +SqXC2;
	end;
	else
	begin
		Offsets[0, 0] := -SqXC2;
		Offsets[0, 1] := +SqXC2;
		Offsets[0, 2] := -1;
		Offsets[0, 3] := +1;
		Offsets[0, 4] := -(SqXC2 + 1);
		Offsets[0, 5] := +(SqXC2 + 1);
		Offsets[0, 6] := -(SqXC2 - 1);
		Offsets[0, 7] := +(SqXC2 - 1);

(*    Offsets[0, odLU] := SqXC2 - 1;
		Offsets[0, odRU] := SqXC2 + 1;
		Offsets[0, odLD] := -SqXC2 - 1;
		Offsets[0, odRD] := -SqXC2 + 1;

		Offsets[1, odLU] := -Offsets[0, odLU];
		Offsets[1, odRU] := -Offsets[0, odRU];
		Offsets[1, odLD] := -Offsets[0, odLD];
		Offsets[1, odRD] := -Offsets[0, odRD];
		// +
		Offsets[0, odU] := SqXC2;
		Offsets[0, odL] := -1;
		Offsets[0, odR] := +1;
		Offsets[0, odD] := -SqXC2;

		Offsets[1, odU] := -SqXC2;
		Offsets[1, odL] := +1;
		Offsets[1, odR] := -1;
		Offsets[1, odD] := SqXC2;*)
	end;
	end;

	case GameType of
	gtExplosion:
	begin
		FillChar(ExplosMax, SizeOf(ExplosMax), 0);
		for i := 0 to UsedSquareCount - 1 do
		begin
			Index := UsedSquares[i];
			for Id := 0 to 3 do
				if StartPos.Board[Index + Offsets[0, Id]] <> sqOut then
					Inc(ExplosMax[Index]);
		end;
	end;
	end;

	// Time Strategy
	if GameType = gtExplosion then
	begin
		GameMaxMoves := 0;
		for i := 0 to UsedSquareCount - 1 do
		begin
			Index := UsedSquares[i];
			Inc(GameMaxMoves, ExplosMax[Index] - 1);
		end;
		GameAvgMoves := GameMaxMoves - UsedSquareCount div 8;
	end
	else
		case MoveFormat of
		mfGO:
		begin
			GameMaxMoves := UsedSquareCount;
			if GameType = gtGomoku then
				GameAvgMoves := GameMaxMoves div 2
			else
				GameAvgMoves := GameMaxMoves;
		end
		else
			GameAvgMoves := 3 * ConstLongDraw div 4; // Calibrate
			GameMaxMoves := MaxGameMoves;
		end;

	// ConstLongDraw
	if MoveFormat <> mfGO then
	begin
		case GameType of
		gtDraughts: ConstLongDraw := (SqXC * SqYC - 4) div 2;
		else ConstLongDraw := 2 * (((SqX) * (SqY)) + 1);
		end;
	end
	else
		ConstLongDraw := GameMaxMoves;

	// ConstPosRep
	if MoveFormat <> mfGO then
	begin
		if GameType = gtShogi then ConstPosRep := 4 else ConstPosRep := 3;
	end
	else
		ConstPosRep := 2;
	// Add Game

	LoadEvaluation;
	{$ifndef UCI}
	GameSupportECO := (GameType = gtChess) and SameData(@Game.Variant, @GameVariants[gtChess, 0], SizeOf(Game.Variant));
	if GameSupportECO then ReadBook;
	{$endif}
end;

function GetHashIC(const CPos: TPos): THash;
var
	i, Index: SG;
	Sq: TSquare;
begin
	Result.A := 0;
	if CPos.Side <> 0 then
	begin
		Result.A := Result.A xor HashRandomPlayer.A;
	end;
	if GameType = gtCastleAndEP then
	begin
		if CPos.EP <> 0 then
		begin
			Result.A := Result.A xor HashRandomEP.A;
		end;
		// Ruffian missed this!
		for i := 0 to PlayerMax do
		begin
			for Index := 0 to 1 do
			begin
				if CPos.Castles[i, TCastleType(Index)] then
				begin
					Result.A := Result.A xor HashRandomCastle[i, TCastleType(Index)].A;
				end;
			end;
		end;
	end;
	for i := 0 to UsedSquareCount - 1 do
	begin
		Index := UsedSquares[i];
		Sq := CPos.Board[Index];
		if PieceOnSquare(Sq) then
		begin
			Result.A := Result.A xor HashRandom[Sq, Index].A;
		end;
	end;
end;

procedure FillHashIC(var CPos: TPos);
begin
	CPos.Hash := GetHashIC(CPos);
end;

{$ifndef UCI}
procedure SwapHashColor(var CPos: TPos);
var i, Index, Index2: SG;
begin
	CPos.Hash.A := CPos.Hash.A xor HashRandomPlayer.A;
	if GameType = gtCastleAndEP then
	begin
		for i := 0 to PlayerMax do
		begin
			for Index := 0 to 1 do
			begin
				if CPos.Castles[i, TCastleType(Index)] then
				begin
					CPos.Hash.A := CPos.Hash.A xor HashRandomCastle[i, TCastleType(Index)].A;
					CPos.Hash.A := CPos.Hash.A xor HashRandomCastle[i xor 1, TCastleType(Index)].A;
				end;
			end;
		end;
	end;
	for i := 0 to UsedSquareCount - 1 do
	begin
		Index := UsedSquares[i];
		if ((CPos.Board[Index] <> sqEmpty)) then
		begin
			CPos.Hash.A := CPos.Hash.A xor HashRandom[CPos.Board[Index], Index].A;
			Index2 := UsedSquares[UsedSquareCount - 1 - i];
			CPos.Hash.A := CPos.Hash.A xor HashRandom[-CPos.Board[Index], Index2].A;
		end;
	end;
end;
{$endif}

{$ifdef Debug}
procedure CheckHash(const CPos: TPos);
var
	Hash: THash;
begin
	Hash := GetHashIC(CPos);
	if (Hash.A <> CPos.Hash.A) then
		IE('Hashing problem');
end;
{$endif}

end.