//* File:     SDG\uAnalys.pas
//* Created:  1997-01-01
//* Modified: 2005-11-11
//* Version:  2.1.35.309
//* Author:   Safranek David (Safrad)
//* E-Mail:   safrad at email.cz
//* Web:      http://safrad.webzdarma.cz

unit uAnalys;

interface

uses
	uTypes, uDForm,
	uEngine, uETypes,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	ExtCtrls, StdCtrls, uDImage,
	uGame, Menus;

type
	TfAnalys = class(TDForm)
		PanelDepth: TPanel;
		PanelSelDepth: TPanel;
		PanelActualDepth: TPanel;
		LabelDepth: TLabel;
		PanelWindow: TPanel;
		PanelAvgNodes: TPanel;
		PanelNodesSec: TPanel;
		PanelMN1: TPanel;
		PanelMN2: TPanel;
		PanelMM1: TPanel;
		PanelMM2: TPanel;
		PanelMS1: TPanel;
		LabelAvgNodes: TLabel;
		LabelNodesSec: TLabel;
		ImageAV: TDImage;
		PanelHash: TPanel;
		PopupMenuEngine: TPopupMenu;
		PopupMenuAnalys: TPopupMenu;
		PanelM1: TDImage;
		PanelM2: TDImage;
		DLabel1: TLabel;
		DLabel2: TLabel;
		LabelTN: TLabel;
		PanelTN: TPanel;
		LabelWindow: TLabel;
		Score: TLabel;
		LabelHash: TLabel;
		procedure FormCreate(Sender: TObject);
		procedure ImageAVFill(Sender: TObject);
		procedure ImageAVMouseMove(Sender: TObject; Shift: TShiftState; X,
			Y: Integer);
		procedure ImageAVMouseDown(Sender: TObject; Button: TMouseButton;
			Shift: TShiftState; X, Y: Integer);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure FormResize(Sender: TObject);
		procedure PopupMenuEnginePopup(Sender: TObject);
		procedure PopupMenuAnalysPopup(Sender: TObject);
		procedure PanelMXFill(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure LabelTNDblClick(Sender: TObject);
		procedure ScoreDblClick(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	fAnalys: TfAnalys;

var
	NodesTime: BG;

function ScoreToRes(Score: TScore): string;

procedure DrawDepth;
procedure DrawActualDepth;
procedure DrawSelDepth;
procedure DrawAlphaBeta;

procedure DrawNodes;

procedure DrawMove1;
procedure DrawMoveCount1;
procedure DrawMoveScore1;
procedure DrawMove2;
procedure DrawMoveCount2;

procedure DrawLabelTimeNodes;

// Group

procedure DrawAMoves;
procedure ReadAnalysisFromFile(FileName: TFileName);
procedure WriteAnalysisToFile(FileName: TFileName);

implementation

{$R *.dfm}
uses
	Math,
	uEHash, uEGen, uEBoard, uESearch, uETimer,
	uDBitmap, uGraph, uError, uDIni, uMenus, uFiles, uMath, uFormat,
	uPieces, uBoard, uMain, uEBook;

var
	FontWid,
	FontHei: SG;
	cX2: array[0..MaxDepth + 1] of SG;

function ScoreToRes(Score: TScore): string;
begin
	case Score of
	- scMax..-scWin0: Result := 'I see how you win';
	- scWin0 + 1..-scEasyWin: Result := {'+-'}'You are winning';
	- scEasyWin + 1..-scLongWin: Result := {'-/+'}'You have a clear adventage';
	- scLongWin + 1..-scAdvance: Result := {'=+'}'You have an edge';
	- scAdvance + 1..scAdvance - 1: Result := {'='} 'The position is equal';
	scAdvance..scLongWin - 1: Result := {'+='} 'I have an edge';
	scLongWin..scEasyWin - 1: Result := {'+/-'} 'I have a clear adventage';
	scEasyWin..scWin0 - 1: Result := {'-+'}'I''m winning';
	scWin0..scMax: Result := 'I see how I win';
	end;
end;

(*-------------------------------------------------------------------------*)
procedure DrawMove1;
begin
	if FormDraw(fAnalys) then
	begin
		fAnalys.PanelMN1.Caption := NToS(AnalysisInfo.MoveIndex[1] + 1);
		fAnalys.PanelM1.Fill;
	end;
end;
(*-------------------------------------------------------------------------*)
procedure DrawMoveCount1;
begin
	if FormDraw(fAnalys) then
	begin
		fAnalys.PanelMM1.Caption := NToS(AnalysisInfo.MoveCount[1]);
		fAnalys.PanelMM1.Repaint;
	end;
end;
(*-------------------------------------------------------------------------*)
procedure DrawMove2;
begin
	if FormDraw(fAnalys) then
	begin
		fAnalys.PanelMN2.Caption := NToS(AnalysisInfo.MoveIndex[2] + 1);
		fAnalys.PanelM2.Fill;
	end;
end;
(*-------------------------------------------------------------------------*)
procedure DrawMoveCount2;
begin
	if FormDraw(fAnalys) then
	begin
		fAnalys.PanelMM2.Caption := NToS(AnalysisInfo.MoveCount[2]);
		fAnalys.PanelMM2.Repaint;
	end;
end;
(*-------------------------------------------------------------------------*)
procedure DrawMoveScore1;
begin
	if FormDraw(fAnalys) then
	begin
		fAnalys.PanelMS1.Caption := ScoreToStr(AnalysisInfo.Score, AStartPos.Side, sfGUI, AnalysisInfo.ScoreBound);
		fAnalys.PanelMS1.Repaint;
	end;
end;
(*-------------------------------------------------------------------------*)
procedure DrawDepth;
begin
	if FormDraw(fAnalys) then
	begin
		fAnalys.PanelDepth.Caption := NToS(AnalysisInfo.Depth, '#0');
		fAnalys.PanelDepth.Repaint;
	end;
end;
(*-------------------------------------------------------------------------*)
procedure DrawActualDepth;
begin
	if FormDraw(fAnalys) then
	begin
		fAnalys.PanelActualDepth.Caption := NToS(D, '#0');
		fAnalys.PanelActualDepth.Repaint;
	end;
end;
(*-------------------------------------------------------------------------*)
procedure DrawSelDepth;
begin
	if FormDraw(fAnalys) then
	begin
		fAnalys.PanelSelDepth.Caption := NToS(AnalysisInfo.SelDepth, '#0');
		fAnalys.PanelSelDepth.Repaint;
	end;
end;

procedure DrawLabelTimeNodes;
begin
	if FormDraw(fAnalys) then
	begin
		if NodesTime then
		begin
			fAnalys.LabelTN.Caption := 'Nodes';
		end
		else
		begin
			fAnalys.LabelTN.Caption := 'Time';
		end;
		fAnalys.LabelTN.Repaint;
	end;
end;
(*-------------------------------------------------------------------------*)
procedure DrawAlphaBeta;
begin
	if FormDraw(fAnalys) then
	begin
		fAnalys.PanelWindow.Caption :=
			ScoreToStr(AnalysisInfo.Alpha, AStartPos.Side, sfGUI, sbExact) + '..' + ScoreToStr(AnalysisInfo.Beta, AStartPos.Side, sfGUI, sbExact);
		fAnalys.PanelWindow.Repaint;
	end;
end;
(*-------------------------------------------------------------------------*)

function TimeToStr(T: U8): string;
begin
	if T > Hour then
		Result := MsToStr(T, True, diHMSD, 0, True)
	else
		Result := MsToStr(T, True, diSD, 3, True);
end;

procedure DrawNodes;
var s: string;
begin
	if FormDraw(fAnalys) then
	begin
		if NodesTime then
			fAnalys.PanelTN.Caption := NodesToS(AnalysisInfo.Nodes)
		else
			fAnalys.PanelTN.Caption := TimeToStr(AnalysisInfo.Time);
		fAnalys.PanelTN.Repaint;
		fAnalys.PanelNodesSec.Caption := NodesToS(AnalysisInfo.NodesPerSec);
		fAnalys.PanelNodesSec.Repaint;
		UseNA := True;
		fAnalys.PanelAvgNodes.Caption := NodesToS(AnalysisInfo.AvgNodes);
		fAnalys.PanelAvgNodes.Repaint;
		UseNA := False;
		if AnalysisInfo.HashPos = 0 then
			s := '-%'
		else
			s := NToS(RoundDiv(1000 * AnalysisInfo.HashNew, AnalysisInfo.HashPos), 1) + '%';
		fAnalys.PanelHash.Caption := s;
		fAnalys.PanelHash.Repaint;
		{$ifopt d+}
		fAnalys.Caption := HashStatToStr(HashStat);
		{$endif}
	end;
end;
(*-------------------------------------------------------------------------*)
procedure DrawAMoves;
begin
	if FormDraw(fAnalys) then
	begin
		if fAnalys.ImageAV.Visible then
			fAnalys.ImageAV.Fill;
	end;
end;
(*-------------------------------------------------------------------------*)
procedure ReadAnalysisFromFile(FileName: TFileName);
label LRetry;
var
	F: TFile;
begin
	F := TFile.Create;
	LRetry:
	if F.Open(FileName, fmReadOnly, FILE_FLAG_SEQUENTIAL_SCAN, False) then
	begin
		if not F.BlockRead(AStartPos, SizeOf(AStartPos)) then goto LRetry;
		AnalysisC := (F.FileSize - SizeOf(AStartPos)) div SizeOf(TAnalysis);
		SetLength(Analysis, 0);
		SetLength(Analysis, AnalysisC);
		if not F.BlockRead(Analysis[0], SizeOf(TAnalysis) * AnalysisC) then goto LRetry;
		if not F.Close then goto LRetry;
	end;
	F.Free;
end;

procedure WriteAnalysisToFile(FileName: TFileName);
label LRetry;
var
	F: TFile;
begin
	F := TFile.Create;
	LRetry:
	if F.Open(FileName, fmWriteOnly, FILE_FLAG_SEQUENTIAL_SCAN, False) then
	begin
		if not F.BlockWrite(AStartPos, SizeOf(AStartPos)) then goto LRetry;
		if not F.BlockWrite(Analysis[0], SizeOf(TAnalysis) * AnalysisC) then goto LRetry;
		if not F.Close then goto LRetry;
	end;
	F.Free;
end;

procedure TfAnalys.FormCreate(Sender: TObject);
begin
	Background := baStandard;
	MainIni.RWFormPos(Self, False);
	MenuCreate(fMain.Engine1, PopupMenuEngine.Items);
	MenuSet(PopupMenuEngine, fMain.OnAdvancedMenuDraw);
	MenuCreate(fMain.Analysis1, PopupMenuAnalys.Items);
	MenuSet(PopupMenuAnalys, fMain.OnAdvancedMenuDraw);
end;

(*-------------------------------------------------------------------------*)
procedure TfAnalys.ImageAVFill(Sender: TObject);
const
	TextSpace = 4;
var
	x, y: SG;
	MoveNumber: SG;

	procedure DrawText(s: string; C: TColor);
	begin
		ImageAV.Bitmap.Canvas.Font.Color := C;
		ImageAV.Bitmap.Canvas.TextOut(x, y, s);
		Inc(x, ImageAV.Bitmap.Canvas.TextWidth(s) + TextSpace);
	end;

var
	s: string;
	AnalysisIndex: SG;
	A: PAnalysis;
	MaxX: SG;
	Bmp: TDBitmap;
	MoveIndex: SG;
	VisA: SG;
	VariantMove: SG;
	HPos: TPos;
	C: TColor;
begin
	// Init
	Bmp := ImageAV.Bitmap;
	FontWid := Bmp.Canvas.TextWidth('8');
	FontHei := Bmp.Canvas.TextHeight('W');
	Bmp.Bar(clWindow, ef16);
	Bmp.Canvas.Brush.Style := bsClear;
	ImageAV.UserHeight := FontHei * AnalysisC;
	y := -ImageAV.OfsY;
	MaxX := 0;
	VisA := Min(VisAnalysis, AnalysisC - 1);

	for AnalysisIndex := AnalysisC - 1 downto 0 do
	begin
		A := @Analysis[AnalysisIndex];
		x := -ImageAV.OfsX;
		if (VisA = AnalysisIndex) then
			Bmp.Bar(0, y, Bmp.Width - 1, y + FontHei - 1, clHighLight, ef08);

		Inc(x, TextSpace);

		Bmp.Canvas.Font.Color := clWindowText;
		s := NToS(A.Depth);
		Bmp.Canvas.TextOut(x + 2 * FontWid - Bmp.Canvas.TextWidth(s), y, s);
		Inc(x, TextSpace + 2 * FontWid);

		s := NToS(Abs(A.Status.MoveCount));
		Bmp.Canvas.TextOut(x + 2 * FontWid - Bmp.Canvas.TextWidth(s), y, s);
		Inc(x, TextSpace + FontWid * 2);

		s := NToS(A.SelDepth);
		Bmp.Canvas.TextOut(x + 2 * FontWid - Bmp.Canvas.TextWidth(s), y, s);
		Inc(x, TextSpace + 2 * FontWid);
		Inc(x, TextSpace + FontWid + 3);

		if NodesTime then
			s := NodesToS(A.Nodes)
		else
			s := TimeToStr(A.Time);

		if A.Status.ScoreBound = sbLower then
			C := MixColors(clWindowText, clRed)
		else
			C := clWindowText;
		Bmp.Canvas.Font.Color := C;
		Inc(x, TextSpace + FontWid * 7);
		Bmp.Canvas.TextOut(x - Bmp.Canvas.TextWidth(s), y, s);
		Inc(x, TextSpace);

		cX2[0] := x;

		s := ScoreToStr(A.Status.Score, AStartPos.Side, sfGUI, A.Status.ScoreBound);
		Inc(x, TextSpace + 2);
		Inc(x, TextSpace + FontWid * 7);
		Bmp.Canvas.TextOut(x - Bmp.Canvas.TextWidth(s), y, s);
		Inc(x, TextSpace);

		// Variantion Moves
		CopyPos(CPos, HPos);
		CopyPos(AStartPos, CPos);

		cX2[1] := x;

		VariantMove := 0;
		MoveNumber := 0;
		PCMove := nil;
		while True do
		begin
			// Number
			if ((MoveNumber mod (PlayerMax + 1)) = 0) and (VariantMove < A.Status.MoveCount) then
			begin
				DrawText(NToS((AStartPos.MoveIndex + MoveNumber) div 2 + 1) + '.', clWindowText);
			end;

			if (MoveNumber = 0) and (AStartPos.Side > 0) then
			begin
				DrawText('...', clWindowText);
			end
			else if VariantMove > A.Status.MoveCount then
			begin
				Break;
			end
			else
			begin

				if (VisA = AnalysisIndex) and (A.ActMove = VariantMove) then
				begin
					if (ABoardVisAnalysis <> VisA) or (ABoardMoveIndex <> A.ActMove) then
					begin
						DrawBoardMove(2, @CPos, PCMove);
					end;
				end;
				// Board
				GenerateMoves;
				PCMove := FCMove;

				if (VisA = AnalysisIndex) and (A.ActMove = VariantMove) then
				begin
					if (ABoardVisAnalysis <> VisA) or (ABoardMoveIndex <> A.ActMove) then
					begin
						ABoardVisAnalysis := VisA;
						ABoardMoveIndex := A.ActMove;
						CopyPos(CPos, APos);
						InitSquareStatus(2);
						DrawOb(dpABoard);
					end;
				end;

				// Final message
				if VariantMove = A.Status.MoveCount then
				begin
					DrawText(VariantionCutToStr(A.Status.VariantionCut), clWindowText);
					Break;
				end;
					
				if VariantMove < A.Status.MoveCount then
				begin
					MoveIndex := A.Moves[VariantMove + 1];
					if MoveIndex <> NullMoveIndex then
					begin
						if MoveIndex >= CMC then
						begin
							PCMove := nil;
						end
						else
						begin
							PCMove := Pointer(SG(FCMove) + MoveIndex shl ShlTMove);
						end;
					end
					else
						PCMove := nil;

					DoMove;
					FillPlus(PCMove);

					// Out
					ImageAV.Bitmap.Canvas.Font.Style := [];
					if (VisA = AnalysisIndex) and (A.ActMove = VariantMove + 1) then
					begin
						ImageAV.Bitmap.Canvas.Font.Style := [fsUnderline];
					end;
					MoveToBmp(ImageAV.Bitmap, x, y, PCMove, True, False);
					Inc(x, TextSpace);
					ImageAV.Bitmap.Canvas.Font.Style := [];

					if (VisA = AnalysisIndex) then
						cX2[VariantMove + 2] := x;

				end;
				Inc(VariantMove);
			end;
			Inc(MoveNumber);
		end;
		CopyPos(HPos, CPos);

		Inc(y, FontHei);
		Inc(x, ImageAV.OfsX);
		if x > MaxX then MaxX := x;
	end;
	ImageAV.UserWidth := MaxX;
end;
(*-------------------------------------------------------------------------*)
function ChangeAnalysis(X, Y: SG; const TestOnly: BG): BG;
var
	WantAnalysis,
	AnalysisActMove: SG;
	i: SG;
begin
	Result := False;
	if AnalysisC = 0 then Exit;
	Inc(Y, fAnalys.ImageAV.OfsY);
	WantAnalysis := AnalysisC - 1 - Range(0, Y div Max(FontHei, 1), AnalysisC - 1);

	AnalysisActMove := -1;
	for i := 0 to Analysis[WantAnalysis].Status.MoveCount do
	begin
		if X < cX2[AnalysisActMove + 1] then Break;
		Inc(AnalysisActMove);
	end;

	if (AnalysisActMove < 0) or
		(AnalysisActMove > Analysis[WantAnalysis].Status.MoveCount) then AnalysisActMove := Analysis[WantAnalysis].Status.MoveCount;

	if ((WantAnalysis <> VisAnalysis) or (Analysis[WantAnalysis].ActMove <> AnalysisActMove)) then
	begin
		Result := True;
		if TestOnly = False then
		begin
			if (WantAnalysis <> VisAnalysis) and (WantAnalysis <> 0) then
			begin
				if Where <> whNone then
					SetCurrentLine;
			end;

			VisAnalysis := WantAnalysis;
			Analysis[WantAnalysis].ActMove := AnalysisActMove;
			DrawAMoves;
		end;
	end;
end;

procedure TfAnalys.ImageAVMouseMove(Sender: TObject; Shift: TShiftState; X,
	Y: Integer);
begin
	if (ImageAV.MouseAction = mwNone) and ImageAV.MouseL then
		ChangeAnalysis(X, Y, False)
	else
	begin
		if (ImageAV.MouseAction = mwNone) and (ImageAV.MouseWhere in [mwNone, mwScroll]) and ChangeAnalysis(X, Y, True) then
			ImageAV.Cursor := crHandPoint
		else
			ImageAV.Cursor := crDefault;
	end;
end;
(*-------------------------------------------------------------------------*)
procedure TfAnalys.ImageAVMouseDown(Sender: TObject; Button: TMouseButton;
	Shift: TShiftState; X, Y: Integer);
begin
	if ImageAV.MouseAction = mwNone then
	begin
		case Button of
		mbLeft:
		begin
			ChangeAnalysis(X, Y, False);
		end;
		end;
	end;
end;
(*-------------------------------------------------------------------------*)
procedure TfAnalys.FormShow(Sender: TObject);
begin
	fMain.Analysis2.Checked := True;
	DrawLabelTimeNodes;
	DrawAMoves;
end;
(*-------------------------------------------------------------------------*)
procedure TfAnalys.FormHide(Sender: TObject);
begin
	fMain.Analysis2.Checked := False;
end;
(*-------------------------------------------------------------------------*)
procedure TfAnalys.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	MainIni.RWFormPos(Self, True);
end;
(*-------------------------------------------------------------------------*)
procedure TfAnalys.FormResize(Sender: TObject);
begin
	ImageAV.Width := ClientWidth - 2 * ImageAV.Left;
	ImageAV.Height := ClientHeight - ImageAV.Top - ImageAV.Left;
end;
(*-------------------------------------------------------------------------*)

procedure TfAnalys.PopupMenuEnginePopup(Sender: TObject);
begin
	MenuUpdate(fMain.Engine1, PopupMenuEngine.Items);
end;

procedure TfAnalys.PopupMenuAnalysPopup(Sender: TObject);
begin
	MenuUpdate(fMain.Analysis1, PopupMenuAnalys.Items);
end;

procedure TfAnalys.PanelMXFill(Sender: TObject);
var
	x, y: SG;
	I: TDImage;
	HPos: TPos;
	LPCMove: PMove;
begin
	I := Sender as TDImage;
	x := 3;
	y := 1;
	I.Bitmap.Bar(clWindow, ef16);
	I.Bitmap.Border(clDepth[1], clDepth[3], 1, ef16);
	if AnalysisInfo.Move[I.Tag + 1].Prior <> 0 then
	begin
		CopyPos(CPos, HPos);
		CopyPos(AStartPos, CPos);
		if I.Tag <> 0 then
		begin
			LPCMove := PCMove;
			PCMove := @AnalysisInfo.Move[1];
			DoMove;
			PCMove := LPCMove;
		end;
		GenerateMoves;
		MoveToBmp(I.Bitmap, x, y, @AnalysisInfo.Move[I.Tag + 1], True, True);
		CopyPos(HPos, CPos);
	end;
end;

procedure TfAnalys.FormDestroy(Sender: TObject);
begin
	MenuFree(PopupMenuEngine.Items);
	MenuFree(PopupMenuAnalys.Items);
end;

procedure TfAnalys.LabelTNDblClick(Sender: TObject);
begin
	fMain.NodesTime1Click(Sender);
end;

procedure TfAnalys.ScoreDblClick(Sender: TObject);
begin
	fMain.ScoreForFirstPlayer1Click(Sender);
end;

end.