//* File:     SDG\uPrint.pas
//* Created:  1997-01-01
//* Modified: 2005-09-21
//* Version:  2.1.35.309
//* Author:   Safranek David (Safrad)
//* E-Mail:   safrad at email.cz
//* Web:      http://safrad.webzdarma.cz

unit uPrint;

interface

uses
	uTypes,
	uEngine, uETypes,
	uDBitmap, uDForm,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, uDButton;

type
	TfPrint = class(TDForm)
		GroupBox1: TGroupBox;
		GroupBox2: TGroupBox;
		RadioButtonFil: TRadioButton;
		RadioButtonPri: TRadioButton;
		ButtonOk: TDButton;
		ButtonCancel: TDButton;
		ButtonPrinterSetup: TDButton;
		EditFile: TEdit;
		GroupBox3: TGroupBox;
		RadioButtonTex: TRadioButton;
		RadioButtonGra: TRadioButton;
		OpenDialog1: TOpenDialog;
		ButtonOpen: TDButton;
		ButtonGIn: TDButton;
		ButtonOvr: TDButton;
		ButtonDia: TDButton;
		ButtonMov: TDButton;
		ButtonTim: TDButton;
		procedure ButtonPrinterSetupClick(Sender: TObject);
		procedure ButtonOkClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure ButtonOpenClick(Sender: TObject);
	private
		{ Private declarations }
		procedure RWOptions(const Save: BG);

		procedure PrintOnlyGInfo(
			var FileText: TextFile; var Bmp: TDBitmap; var NowY: UG);
		procedure PrintOnlyBoard(TP: TBoard;
			var FileText: TextFile; var Bmp: TDBitmap; var NowY: UG);
		procedure PrintOnlyMoves(
			var FileText: TextFile; var Bmp: TDBitmap; var NowY: UG);
		procedure PrintDG(
			var FileText: TextFile; var Bmp: TDBitmap; var NowY: UG);
	public
		{ Public declarations }
	end;

var
	fPrint: TfPrint;
	PrntHead: string[64];
	PrntName: string;

implementation

{$R *.dfm}
uses
	uEBoard,
	Printers,
	uFiles, uError, uDIni, uStrings, uFormat,
	uMain, uGame, uBoard, uAnalys;

(*-------------------------------------------------------------------------*)
procedure TfPrint.PrintOnlyGInfo(
	var FileText: TextFile; var Bmp: TDBitmap; var NowY: UG);
var
	S: string;
begin
	S := '';
{ if Game.Head.Name0 <> '' then S := S + Game.Head.Name0 + ': ';

	if (Game.Head.Name1 <> '') or (Game.Head.Name2 <> '') then
		S := S + Game.Head.Name1 + ' : ' + Game.Head.Name2;}

	if RadioButtonTex.Checked then
	begin
		if S <> '' then
		begin
			Writeln(FileText, S);
			Writeln(FileText);
		end;
	end
	else
	begin
		if S <> '' then
		begin
//      Bmp.Height := Bmp.Height + Abs(Bmp.Canvas.Font.Height) shl 1;
			Bmp.Canvas.TextOut(0, NowY, S);
			Inc(NowY, Abs(Bmp.Canvas.Font.Height) shl 1);
		end;
	end;
end;
(*-------------------------------------------------------------------------*)
procedure TfPrint.PrintOnlyBoard(TP: TBoard;
	var FileText: TextFile; var Bmp: TDBitmap; var NowY: UG);
var
	X, Y: SG;
	s: string;
begin
	if RadioButtonTex.Checked = False then
	begin

	end
	else
	begin
		s := '';
		for x := 0 to SqX do
			s := s + '';
		s := s + 'ͻ';
		Writeln(FileText, s);
		for Y := SqX downto 0 do
		begin
			Write(FileText, '');
			for X := 0 to 7 do
			begin
				if ((X + Y) and 1) <> 0 then
				begin
					Write(FileText, '  ');
				end
				else
				begin
					case TP[XYToI(X, Y)] of
					 sqEmpty:   Write(FileText, '  ');
					 sqP1: Write(FileText, '');
					 sqP0: Write(FileText, '');
					 sqN1: Write(FileText, 'WW');
					 sqN0: Write(FileText, 'MM');
					end;
				end;
				if X = 7 then
					Writeln(FileText, '')
				else
					Write(FileText, '');
			end;

			if Y = 0 then
			begin
				s := '';
				for x := 0 to SqX do
					s := s + '';
				s := s + 'ͼ';
			end
			else
			begin
				s := '';
				for x := 0 to SqX do
					s := s + '';
				s := s + 'Ķ';
			end;
			Writeln(FileText, s);
		end;
		Writeln(FileText);
	end;
end;
(*-------------------------------------------------------------------------*)
procedure TfPrint.PrintOnlyMoves(
	var FileText: TextFile; var Bmp: TDBitmap; var NowY: UG);
var
{ Mv: PGameMoves;
	M: PGameMove;}
	MvI: SG;
	S: string;
	C: TColor;
	NowX: SG;
	HPos: TPos;
begin
	NowX := 0;
	CopyPos(CPos, HPos);
	CopyPos(Game.Variant.Pos, CPos);
	for MvI := -(Game.Variant.Pos.Side) to - 1 + Game.Pos.MoveIndex do
	begin
		if (MvI and 1) = 0 then
		begin
			S := NToS(((Game.Variant.Pos.MoveIndex + MvI) div 2) + 1, '##0') + '. ';
			if RadioButtonTex.Checked = False then
			begin
				NowX := 0;
	//      Bmp.Height := Bmp.Height + Abs(Bmp.Canvas.Font.Height);
				Bmp.Canvas.Font.Color := clBlack;
				Bmp.Canvas.TextOut(0, NowY, S);
				Inc(NowX, 32);
			end
			else
				Write(FileText, S);
		end;

		C := clBlack;
		if MvI = -1 then
		begin
			S := ' . . .       ';
		end
		else
		begin
(*      Mv := Game.FirstMove;
			i := 0;
			while Mv <> nil do
			begin
				GenerateMoves;
				M := @Mv.Moves[Mv.Actual];
				PCMove := PMove(SG(FCMove) + M.Index shl ShlTMove);
				FillPlus;
				MoveToBmp(Bmp, NowX, NowY, PCMove, C, False);
{       if ButtonTim.Down then
				begin
					S := S + '<' + msToStr(Game.TotTime[Mv], diHMSD, Precision, True) + '>';
				end;}
				DoMove;
				Mv := M.Moves;
				Inc(i);
			end; *)
		end;
		if RadioButtonTex.Checked = False then
		begin
			Bmp.Canvas.Font.Color := C;
			Bmp.Canvas.TextOut(NowX, NowY, S);
			Inc(NowX, 64);
		end
		else
			Write(FileText, S);

		if MvI + 1 = Game.Pos.MoveIndex then
		begin
			if RadioButtonTex.Checked = False then
			begin
	//      Bmp.Height := Bmp.Height + Abs(Bmp.Canvas.Font.Height);
				NowX := 0;
				Inc(NowY, Abs(Bmp.Canvas.Font.Height));
			end
			else
				Writeln(FileText);
		end
		else
		begin
			if (MvI and 1) <> 0 then
			begin
				if RadioButtonTex.Checked = False then
				begin
					NowX := 0;
					Inc(NowY, Abs(Bmp.Canvas.Font.Height));
				end
				else
					Writeln(FileText);
			end
			else
			begin
				if RadioButtonTex.Checked = False then
				begin
					Inc(NowX, 8);
				end
				else
					Write(FileText, ' ');
			end;
		end;
	end;
	CopyPos(HPos, CPos);
end;
(*-------------------------------------------------------------------------*)
procedure TfPrint.PrintDG(
	var FileText: TextFile; var Bmp: TDBitmap; var NowY: UG);
begin
	if ButtonGIn.Down then
	begin
		PrintOnlyGInfo(FileText, Bmp, NowY);
	end;
	if ButtonDia.Down then
	begin
		PrintOnlyBoard(Game.Pos.Board, FileText, Bmp, NowY);
	end;
	if ButtonMov.Down then
	begin
		PrintOnlyMoves(FileText, Bmp, NowY);
	end;
end;
(*-------------------------------------------------------------------------*)
procedure TfPrint.ButtonOkClick(Sender: TObject);
label NotGame, LRetry1, LRetry2, LRetry3;
var
	FileText: TextFile;
	Bmp: TDBitmap;

	FName: TFileName;
	FileHead: string[64];
	S: string;
	FExists: BG;

	ScaleX, ScaleY: SG;
	R: TRect;

	NowY: UG;
	ErrorCode: SG;
begin
	if RadioButtonTex.Checked = False then
	begin
		Bmp := TDBitmap.Create;
		if RadioButtonPri.Checked = False then
		begin
			FName := PrntName + '.png';
			FExists := FileExists(FName);
			if FExists then Bmp.LoadFromFile(FName);
			NowY := Bmp.Height;
//      if Bmp.Width < 256 then Bmp.Width := 256;
		end
		else
		begin
			NowY := 0;
//      Bmp.Width := 256;
		end;
		Bmp.Canvas.Font.Name := 'Courier New';
		Bmp.Canvas.Font.Height := 14;
		PrintDG(FileText, Bmp, NowY);
		if RadioButtonPri.Checked then
		begin
//      S := ProgHead + ' ';
			if (ButtonDia.Down) and
				(ButtonMov.Down) then
				S := S + 'Game'
			else if ButtonDia.Down then
				S := S + 'Diagram'
			else if ButtonMov.Down then
				S := S + 'Moves';
			Printer.Title := S;
//      PrintDG(FileText, Printer.Canvas);
			Printer.BeginDoc;  // **

			try
			{ ScaleX:=GetDeviceCaps(Handle, HorzSize);
				ScaleY:=GetDeviceCaps(Handle, VertSize);}
				ScaleX := (GetDeviceCaps(Handle, logPixelsX) * Bmp.Width div PixelsPerInch);
				ScaleY := (GetDeviceCaps(Handle, logPixelsY) * Bmp.Height div PixelsPerInch);
				R := Rect(0, 0, ScaleX, ScaleY);
				Printer.Canvas.StretchDraw(R, Bmp);
			finally
				Printer.EndDoc;  // **
			end
		end
		else
		begin
			Bmp.SaveToFile(FName);
		end;
		Bmp.Free;
	end
	else
	if RadioButtonPri.Checked then
	begin
		FName := 'Lpt1';
		LRetry1:
		AssignFile(FileText, FName);
		Rewrite(FileText);
		ErrorCode := IOResult;
		if ErrorCode <> 0 then
			if IOErrorRetry(FName, ErrorCode) then goto LRetry1;
		Write(FileText, CharCR);
		ErrorCode := IOResult;
		if ErrorCode <> 0 then
			if IOErrorRetry(FName, ErrorCode) then goto LRetry1;
		PrintDG(FileText, Bmp, NowY);
		CloseFile(FileText);
		IOResult;
	end
	else
	begin
		FName := PrntName + '.txt';
		LRetry2:
		FExists := FileExists(FName);
		if FExists then
		begin
			AssignFile(FileText, FName);
			FileMode := 0; Reset(FileText);
			ErrorCode := IOResult;
			if ErrorCode <> 0 then
				if IOErrorRetry(FName, ErrorCode) then goto LRetry2;
			if FileSize(FileText) < 256 then goto NotGame;
			Readln(FileText, FileHead);
			ErrorCode := IOResult;
			if ErrorCode <> 0 then
			begin
				CloseFile(FileText);
				IOResult;
				if IOErrorRetry(FName, ErrorCode) then goto LRetry1;
				Exit;
			end;
//      NameHead: string[64] = '(p) 1997-1999 Safranek David';
//      PrntHead := ProgHead + ' Print      ' + NameHead + CharCR + CharLF;
			S := PrntHead;
			SetLength(FileHead, 32);
			SetLength(S, 32);
			if (FileHead <> S) then
			begin
				NotGame:
				MessageD(FName + ' is not print file', mtError, [mbOK]);
				Exit;
			end;
		end;

		if ButtonOvr.Down then FExists := False;
		// Now print it
		LRetry3:
		AssignFile(FileText, FName);
		if FExists then Append(FileText) else Rewrite(FileText);
		ErrorCode := IOResult;
		if ErrorCode <> 0 then
			if IOErrorRetry(FName, ErrorCode) then goto LRetry3;
		PrintDG(FileText, Bmp, NowY);
		CloseFile(FileText);
		IOResult;
		if IOErrorRetry(FName, ErrorCode) then goto LRetry3;
		if FExists then
			Echo('Overwrited ' + FName)
		else
			Echo('Created ' + FName);
	end;
end;
(*-------------------------------------------------------------------------*)
procedure TfPrint.ButtonPrinterSetupClick(Sender: TObject);
begin
	fMain.PrinterSetupDialog1.Execute;
end;
(*-------------------------------------------------------------------------*)
procedure TfPrint.RWOptions(const Save: BG);
const
	Section = 'Print';
begin
	MainIni.RWString(Section, 'FileName', PrntName, Save);
	MainIni.RWButton(Section, ButtonGIn, Save);
	MainIni.RWButton(Section, ButtonDia, Save);
	MainIni.RWButton(Section, ButtonMov, Save);
	MainIni.RWButton(Section, ButtonTim, Save);
	MainIni.RWButton(Section, ButtonOvr, Save);
{ MainIni.RWButton(Section, 'Text', RadioButtonTex.Checked, True, Save);
	RadioButtonGra.Checked := not RadioButtonTex.Checked;
	MainIni.RWBoolM(Section, 'Printer', RadioButtonPri.Checked, True, Save);
	RadioButtonFil.Checked := not RadioButtonTex.Checked;}
end;

procedure TfPrint.FormCreate(Sender: TObject);
begin
	Background := baStandard;
	OpenDialog1.Filter := AllPictures;
	RWOptions(False);
end;

procedure TfPrint.FormDestroy(Sender: TObject);
begin
	RWOptions(True);
end;

procedure TfPrint.FormShow(Sender: TObject);
begin
	fMain.Print1.Checked := True;
end;

procedure TfPrint.FormHide(Sender: TObject);
begin
	fMain.Print1.Checked := False;
end;

procedure TfPrint.ButtonOpenClick(Sender: TObject);
begin
	if ExecuteDialog(OpenDialog1, PrntName) then
	begin
		PrntName := OpenDialog1.FileName;
		EditFile.Text := ShortDir(PrntName);
	end;
end;

end.