//* File:     SDG\uPGN.pas
//* Created:  1997-01-01
//* Modified: 2005-12-13
//* Version:  2.1.35.309
//* Author:   Safranek David (Safrad)
//* E-Mail:   safrad at email.cz
//* Web:      http://safrad.webzdarma.cz

unit uPGN;

interface

uses
	uTypes,
	uDForm, uData,
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, uDImage, uDView, Menus;

type
	TfPGN = class(TDForm)
		DViewGames: TDView;
		PopupMenuPGN: TPopupMenu;
		N1: TMenuItem;
		OptimalColumnsWidth1: TMenuItem;
		procedure FormCreate(Sender: TObject);
		procedure FormDeactivate(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure DViewGamesDblClick(Sender: TObject);
		procedure DViewGamesColumnClick(Sender: TObject; Column: TColumn);
		procedure PopupMenuPGNPopup(Sender: TObject);
		procedure DViewGamesGetData(Sender: TObject; var Data: String; ColIndex,
			RowIndex: Integer; Rect: TRect);
		procedure OptimalColumnsWidth1Click(Sender: TObject);
	private
		{ Private declarations }
		procedure RWOptions(const Save: BG);
	public
		{ Public declarations }
	end;

var
	fPGN: TfPGN;

procedure InitPGN;

implementation

uses
	uMenus,
	uDIni, uSorts, uFormat,
	uMain, uGame, uEngine;

{$R *.dfm}

procedure TfPGN.RWOptions(const Save: BG);
begin
	MainIni.RWFormPos(Self, Save);
	MainIni.RWDView(DViewGames, Save);
end;

procedure TfPGN.FormCreate(Sender: TObject);
var
	i: SG;
begin
	Background := baNone;

	MenuCreate(fMain.Game1, PopupMenuPGN.Items);
	MenuSet(PopupMenuPGN, fMain.OnAdvancedMenuDraw);

	DViewGames.ColumnCount := Length(Game.PGNTags) + 1;
	DViewGames.Columns[0].Caption := '#';
	DViewGames.Columns[0].Alignment := taRightJustify;
	DViewGames.Columns[0].Click := True;
	for i := 0 to Length(Game.PGNTags) - 1 do
	begin
		DViewGames.Columns[i + 1].Caption := PGNTagNames[TPGNTag(i)];
		DViewGames.Columns[i + 1].Click := True;
	end;
	RWOptions(False);

	DViewGames.ChangeColumns;
end;

procedure TfPGN.FormDeactivate(Sender: TObject);
begin
	RWOptions(True);
end;

procedure InitPGN;
var
	i, j: SG;
	s: string;
	G: PGame;
begin
	if (Kinds.Count = 0) or (Games = nil) then
	begin
		fMain.NewGame1.Enabled := False;
		fMain.DeleteGame1.Enabled := False;
		fMain.Up1.Enabled := False;
		fMain.Down1.Enabled := False;
		fMain.Previous1.Enabled := False;
		fMain.Next1.Enabled := False;
		fMain.FirstGame1.Enabled := False;
		fMain.LastGame1.Enabled := False;
	end
	else
	begin
		fMain.NewGame1.Enabled := True;
		fMain.DeleteGame1.Enabled := Games.Count > 0;
		fMain.Up1.Enabled := Games.Index > 0;
		fMain.Down1.Enabled := UG(Games.Index + 1) < Games.Count;
		fMain.Previous1.Enabled := Games.Index > 0;
		fMain.Next1.Enabled := UG(Games.Index + 1) < Games.Count;
		fMain.FirstGame1.Enabled := Games.Index <> 0;
		fMain.LastGame1.Enabled := UG(Games.Index + 1) <> Games.Count;
	end;
	UpdateIcons(fMain.MainMenu, fMain.PanelTool);

	if FormDraw(fPGN) then
	begin
		if (Kinds.Count > 0) then
		begin
			s := Kinds.Items[Kinds.Index].FileName;
			if Games.Count <> 0 then
			begin
				s := s + ', ' + NToS(Games.Count) + ' Game';
				if Games.Count > 1 then
					s := s + 's';

				for i := 1 to Length(fPGN.DViewGames.Columns) - 1 do
					fPGN.DViewGames.Columns[i].Visible := False;

				Games.Update;
				G := Games.GetFirst;
				for i := 0 to Games.Count - 1 do
				begin
					for j := 0 to Length(Game.PGNTags) - 1 do
					begin
						if G.PGNTags[TPGNTag(j)] <> '' then
							if fPGN.DViewGames.Columns[j + 1].Visible = False then
								fPGN.DViewGames.Columns[j + 1].Visible := True;
					end;
					Inc(SG(G), Games.ItemMemSize);
				end;
				fPGN.DViewGames.RowCount := Games.Count;
				fPGN.DViewGames.ChangeColumns;
			end
			else
				fPGN.DViewGames.RowCount := 0;
		end
		else
		begin
			s := '';
			fPGN.DViewGames.RowCount := 0;
		end;
		fPGN.Caption := s;
		fPGN.DViewGames.Fill;
	end;
end;

procedure TfPGN.FormShow(Sender: TObject);
begin
	fMain.PGN2.Checked := True;
	InitPGN;
end;

procedure TfPGN.FormHide(Sender: TObject);
begin
	fMain.PGN2.Checked := False;
end;

procedure TfPGN.DViewGamesDblClick(Sender: TObject);
var
	i: SG;
begin
	if DViewGames.Where in [vaRow] then
		if DViewGames.ActualRow >= 0 then
		begin
			i := DViewGames.RowOrder[DViewGames.ActualRow];
			if (i <> Games.Index) then
			begin
				Games.Index := i;
				GameChanged;
		//    Close;
			end;
		end;
end;

procedure TfPGN.DViewGamesColumnClick(Sender: TObject; Column: TColumn);
var
	i: SG;
	SortD: array of string;
	SortF: array of F8;
	G: PGame;
	IsNum: BG;
begin
	if (Games = nil) or (Games.Count = 0) then Exit;
	if DViewGames.SortBy <= 0 then
	begin
		for i := 0 to DViewGames.RowCount - 1 do
			DViewGames.RowOrder[i] := i;
	end
	else
	begin
		SetLength(SortD, Games.Count);
		SetLength(SortF, Games.Count);
		Games.Update;
		G := Games.GetFirst;
		IsNum :=
			(DViewGames.Columns[DViewGames.SortBy].Caption = 'Round') or
			(DViewGames.Columns[DViewGames.SortBy].Caption = 'PlyCount');
		for i := 0 to DViewGames.RowCount - 1 do
		begin
			if IsNum then
				SortF[i] := StrToF8(G.PGNTags[TPGNTag(DViewGames.SortBy - 1)])
			else
				SortD[i] := G.PGNTags[TPGNTag(DViewGames.SortBy - 1)];
			DViewGames.RowOrder[i] := i;
			Inc(SG(G), Games.ItemMemSize);
		end;
		if IsNum then
			SortF8(True, False, PArraySG(@DViewGames.RowOrder[0]), PArrayF8(@SortF[0]), Games.Count)
		else
			SortS(False, PArraySG(@DViewGames.RowOrder[0]), SortD);
		SetLength(SortF, 0);
		SetLength(SortD, 0);
	end;
end;

procedure TfPGN.PopupMenuPGNPopup(Sender: TObject);
begin
	MenuUpdate(fMain.Game1, PopupMenuPGN.Items);
end;

procedure TfPGN.DViewGamesGetData(Sender: TObject; var Data: String; ColIndex,
	RowIndex: Integer; Rect: TRect);
var
	i: SG;
	G: PGame;
begin
	if Games = nil then Exit;
	if Games.Index < 0 then Exit;
	i := RowIndex;
//  Games.Update;
	if i = Games.Index then
		G := @Game
	else
		G := Games.Get(i);
	case ColIndex of
	0: Data := NToS(i + 1);
	else Data := G.PGNTags[TPGNTag(ColIndex - 1)];
	end;
end;

procedure TfPGN.OptimalColumnsWidth1Click(Sender: TObject);
var
	i, j, w, wm: SG;
	G: PGame;
begin
	if (Games = nil) or (Games.Count = 0) then Exit;
	Games.Update;
	for j := -1 to Length(Game.PGNTags) - 1 do
	begin
		if DViewGames.Columns[j + 1].Visible then
		begin
			if j = -1 then
				wm := DViewGames.Bitmap.Canvas.TextWidth(NToS(Games.Count))
			else
			begin
				wm := MinColumnWidth;
				G := Games.GetFirst;
				for i := 0 to Games.Count - 1 do
				begin
					if G.PGNTags[TPGNTag(j)] <> '' then
					begin
						w := DViewGames.Bitmap.Canvas.TextWidth(G.PGNTags[TPGNTag(j)]);
						if w > wm then wm := w;
					end;
					Inc(SG(G), Games.ItemMemSize);
				end;
			end;
			DViewGames.Columns[j + 1].Width := wm + CellBorder;
		end;
	end;

	DViewGames.ChangeColumns;
	DViewGames.Fill;
end;

end.