//* File:     SDG\uNew.pas
//* Created:  1997-01-01
//* Modified: 2005-10-08
//* Version:  2.1.35.309
//* Author:   Safranek David (Safrad)
//* E-Mail:   safrad at email.cz
//* Web:      http://safrad.webzdarma.cz

unit uNew;

interface

uses
	uEngine, uETypes,
	uTypes, uDForm,
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, StdCtrls, uDButton, uDLabel, ExtCtrls;

type
	TfNew = class(TDForm)
		ButtonOK: TDButton;
		ButtonCancel: TDButton;
		ComboBoxGameType: TComboBox;
		LabelGameType: TLabel;
		ComboBoxX: TComboBox;
		ComboBoxY: TComboBox;
		LabelBoardSize: TLabel;
		DLabelX: TLabel;
		LabelVariant: TLabel;
		ComboBoxVariantion: TComboBox;
		Suicide: TDButton;
		MustCapture: TDButton;
		RCP: TDButton;
		FallDown: TDButton;
		Shuffle: TComboBox;
		LabelShuffle: TLabel;
		LineSize: TComboBox;
		LabelLineSize: TLabel;
		Bevel1: TBevel;
		BackwardCapture: TDButton;
		LongestCapture: TDButton;
		MateKing: TDButton;
		SelfCaptures: TDButton;
		StrongKing: TDButton;
		Promote: TComboBox;
		LabelPromote: TLabel;
		Bevel2: TBevel;
		Bevel3: TBevel;
		Bevel4: TBevel;
		LabelFlyingKing: TLabel;
		FlyingKing: TComboBox;
		QualityRule: TDButton;
		LabelMan: TLabel;
		LabelStalemateResult: TLabel;
		StalemateResult: TComboBox;
		procedure FormCreate(Sender: TObject);
		procedure ComboBoxGameTypeChange(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure ComboBoxXYChange(Sender: TObject);
		procedure ShuffleChange(Sender: TObject);
		procedure ComboBoxVariantionChange(Sender: TObject);
		procedure ButtonChange(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure CobmoBoxChange(Sender: TObject);
	private
		{ Private declarations }
		procedure RWOptions(const Save: BG);
		procedure InitVariantion;
		procedure InitOptions;
	public
		{ Public declarations }
		GameType: TGameType;
		GameOpt: array[TGameType] of TGameVariant;
	end;

var
	fNew: TfNew;

const
	MinimumXY = 2; // Can test 1
var
	GameVariants: array[TGameType, 0..15] of TGameVariant;

implementation

{$R *.dfm}
uses
	uInput, uDIni, uFormat, uMath,
	uGame, uEBoard,
	Math, uOptions;

procedure TfNew.RWOptions(const Save: BG);
var
//  i: SG;
	gt: TGameType;
//  Section: string;
begin
	MainIni.RWFormPos(Self, Save);
	MainIni.RWNum('New', 'GameType', U1(GameType), Save);
	for gt := Low(gt) to High(gt) do
	begin
	if Save = False then GameOpt[gt] := GameVariants[gt][0];
{   Section := 'New' + GameNames[gt];
		for i := 0 to Length(NamesTGameVariant) - 1 do
			MainIni.RWNum(Section, NamesTGameVariant[TVariantOption(i)], GameOpt[gt].Options[TVariantOption(i)].Num, Save);}
	end;
end;

procedure TfNew.FormCreate(Sender: TObject);
var
	i: SG;
	C: TComponent;
begin
	Background := baGradient;
	ComboBoxGameType.Items.BeginUpdate;
	for i := 1 to Length(GameNames) - 1 do
	begin
		ComboBoxGameType.Items.Add(GameNames[TGameType(i)]);
	end;
	ComboBoxGameType.Items.EndUpdate;

	for i := 0 to Length(NamesTGameVariant) - 1 do
	begin
		C := FindComponent(NamesTGameVariant[TVariantOption(i)]);
		if C <> nil then
			C.Tag := i;
	end;
	RWOptions(False);
end;

function FindVariant(var GV: TGameVariant; GameType: TGameType): SG;
var i: SG;
begin
	Result := -1;
	for i := 0 to Length(GameVariants[GameType]) - 1 do
	begin
		if GameVariants[GameType][i].Name = '' then Break;
		if SameData(@GameVariants[GameType, i].Options, @GV.Options, SizeOf(TVariantParams))
		and ComparePos(GameVariants[GameType, i].Pos, GV.Pos) then
		begin
			Result := i;
			Break;
		end;
	end;
end;

procedure TfNew.InitVariantion;
var i: SG;
begin
	{$ifdef Debug}Caption := NToS(GetBoardSize(GameType, GameOpt[GameType].Options[voWidth].Num, GameOpt[GameType].Options[voHeight].Num));{$endif}
	ComboBoxVariantion.Items.BeginUpdate;
	ComboBoxVariantion.Items.Clear;

	for i := 0 to Length(GameVariants[GameType]) - 1 do
	begin
		if GameVariants[GameType][i].Name = '' then Break;
		ComboBoxVariantion.Items.Add(GameVariants[GameType][i].Name);
	end;
	ComboBoxVariantion.ItemIndex := FindVariant(GameOpt[GameType], GameType);
	ComboBoxVariantion.Items.EndUpdate;
end;

procedure TfNew.FormShow(Sender: TObject);
begin
	ComboBoxGameType.ItemIndex := SG(GameType) - 1;
	InitVariantion;
	InitOptions
end;

procedure TfNew.InitOptions;
var
	i: SG;
	MoveFormat: TMoveFormat;
begin
	case GameType of
	gtGomoku, gtExplosion, gtOthello: MoveFormat := mfGO;
	gtDraughts: MoveFormat := mfDraughts;
	else MoveFormat := mfChess;
	// Add Game
	end;
	ComboBoxX.Items.BeginUpdate;
	ComboBoxX.Items.Clear;
	for i := MinimumXY to BoardX {- BoardRedX[GameType]} do
		ComboBoxX.Items.Add(NToS(i));
	ComboBoxX.DropDownCount := Min(ComboBoxX.Items.Count, 24);
	ComboBoxX.ItemIndex := Max(0, SG(GameOpt[GameType].Options[voWidth].Num) - MinimumXY);
	ComboBoxX.Items.EndUpdate;

	ComboBoxY.Items.BeginUpdate;
	ComboBoxY.Items.Clear;
	for i := MinimumXY to BoardY {- 2 * BoardRedY[GameType]} do
		ComboBoxY.Items.Add(NToS(i));
	ComboBoxY.DropDownCount := Min(ComboBoxY.Items.Count, 24);
	ComboBoxY.ItemIndex := Max(0, SG(GameOpt[GameType].Options[voHeight].Num) - MinimumXY);
	ComboBoxY.Items.EndUpdate;

	Shuffle.Text := NToS(GameOpt[GameType].Options[voShuffle].Num);
	Suicide.Down := GameOpt[GameType].Options[voSuicide].Bool;
	RCP.Down := GameOpt[GameType].Options[voRCP].Bool;
	MustCapture.Down := GameOpt[GameType].Options[voMustCapture].Bool;
	Promote.ItemIndex := GameOpt[GameType].Options[voPromote].Num;
	StalemateResult.ItemIndex := GameOpt[GameType].Options[voStalemateResult].Num;
	SelfCaptures.Down := GameOpt[GameType].Options[voSelfCaptures].Bool;
	MateKing.Down := GameOpt[GameType].Options[voMateKing].Bool;
	LongestCapture.Down := GameOpt[GameType].Options[voLongestCapture].Bool;
	QualityRule.Down := GameOpt[GameType].Options[voQualityRule].Bool;
	BackwardCapture.Down := GameOpt[GameType].Options[voBackwardCapture].Bool;
	FlyingKing.ItemIndex := GameOpt[GameType].Options[voFlyingKing].Num;
	StrongKing.Down := GameOpt[GameType].Options[voStrongKing].Bool;
	FallDown.Down := GameOpt[GameType].Options[voFallDown].Bool;
	LineSize.Items.BeginUpdate;
	LineSize.Items.Clear;
	for i := 1 to Max(BoardX, BoardY) - 1 do
		LineSize.Items.Add(NToS(i));
	LineSize.ItemIndex := GameOpt[GameType].Options[voLineSize].Num - 1;
	LineSize.Items.EndUpdate;

	RCP.Visible := (MoveFormat <> mfGO) and not (GameType in [gtBlobWars]); // Add Game
	MustCapture.Visible := (MoveFormat <> mfGO) and not (GameType in [gtBlobWars]);
	Promote.Visible := (MoveFormat <> mfGO) and not (GameType in [gtJungle, gtBlobWars]); // Add Game
	LabelPromote.Visible := Promote.Visible;
	StalemateResult.Enabled := not (GameType in [gtExplosion, gtOthello]); // Add Game
	LabelStalemateResult.Enabled := StalemateResult.Enabled;
	SelfCaptures.Visible := (MoveFormat <> mfGO) and not (GameType in [gtBlobWars]); // Add Game
	MateKing.Visible := GameType in [gtChess, gtChineseChess, gtShogi];
	LongestCapture.Visible := GameType = gtDraughts;
	QualityRule.Visible := GameType = gtDraughts;
	LabelMan.Visible := GameType = gtDraughts;
	BackwardCapture.Visible := GameType = gtDraughts;
	LabelFlyingKing.Visible := GameType = gtDraughts;
	FlyingKing.Visible := GameType = gtDraughts;
	StrongKing.Visible := GameType = gtDraughts;
	FallDown.Visible := GameType = gtGomoku;
	LineSize.Visible := GameType in [gtGomoku];
	LabelLineSize.Visible := LineSize.Visible;
	LabelShuffle.Visible := GameType = gtChess;
	Shuffle.Visible := LabelShuffle.Visible;
	// Add Game
end;

procedure TfNew.ComboBoxGameTypeChange(Sender: TObject);
begin
	GameType := TGameType(ComboBoxGameType.ItemIndex + 1);

	InitVariantion;
	InitOptions;
end;

procedure TfNew.ComboBoxXYChange(Sender: TObject);
begin
	GameOpt[GameType].Options[voWidth].Num := ComboBoxX.ItemIndex + MinimumXY;
	GameOpt[GameType].Options[voHeight].Num := ComboBoxY.ItemIndex + MinimumXY;

	case TComponent(Sender).Tag of
	2:
	begin
		GetMaxX(GameType, GameOpt[GameType].Options[voWidth].Num, GameOpt[GameType].Options[voHeight].Num);
		ComboBoxX.ItemIndex := GameOpt[GameType].Options[voWidth].Num  - MinimumXY;
	end;
	1:
	begin
		GetMaxY(GameType, GameOpt[GameType].Options[voWidth].Num, GameOpt[GameType].Options[voHeight].Num);
		ComboBoxY.ItemIndex := GameOpt[GameType].Options[voHeight].Num - MinimumXY;
	end;
	end;

	if (GameType <> gkNone) and (GameOpt[GameType].Options[voWidth].Num >= MinimumXY) and (GameOpt[GameType].Options[voHeight].Num >= MinimumXY) then
	begin
		ButtonOK.Enabled := True; //ModalResult := mrOk;
	end
	else
		ButtonOK.Enabled := False; // ModalResult := mrNone;

	GameOpt[GameType].Options[voLineSize].Num := LineSize.ItemIndex + 1; //StrToValI(GCount1.Text, True, 2, 4 + SG(GameOpt[GameType].Fall), Max(SqX, SqY) + 1, 1);
	InitVariantion;
end;

procedure TfNew.ShuffleChange(Sender: TObject);
begin
	if Shuffle.Text = 'No suffle' then
		GameOpt[GameType].Options[voShuffle].Num := NoShuffle
	else
		GameOpt[GameType].Options[voShuffle].Num := StrToValI(Shuffle.Text, True, 0, NoShuffle, High(GameOpt[GameType].Options[voShuffle].Num), 1);
	InitVariantion;
end;

procedure TfNew.ComboBoxVariantionChange(Sender: TObject);
var i: SG;
begin
	i := ComboBoxVariantion.ItemIndex;
	GameOpt[GameType] := GameVariants[GameType, i];
	InitOptions;
end;

procedure TfNew.ButtonChange(Sender: TObject);
begin
	GameOpt[GameType].Options[TVariantOption(TComponent(Sender).Tag)].Num := SG(TDButton(Sender).Down) and 1;
	InitVariantion;
end;

procedure TfNew.FormDestroy(Sender: TObject);
begin
	RWOptions(True);
end;

procedure TfNew.CobmoBoxChange(Sender: TObject);
begin
	GameOpt[GameType].Options[TVariantOption(TComponent(Sender).Tag)].Num := TComboBox(Sender).ItemIndex;
	InitVariantion;
end;

initialization
	// Default Variants D???
	GameVariants[gtChess, 0].Options[voStalemateResult].Num := 0;
	GameVariants[gtDraughts, 0].Options[voStalemateResult].Num := 1;
	GameVariants[gtDraughts, 0].Options[voMustCapture].Bool := True;
	GameVariants[gtOthello, 0].Options[voStalemateResult].Num := 3;
	GameVariants[gtBlobWars, 0].Options[voStalemateResult].Num := 3;
end.