//* File:     SDG\uMain.pas
//* Created:  1997-01-01
//* Modified: 2005-11-14
//* Version:  2.1.35.309
//* Author:   Safranek David (Safrad)
//* E-Mail:   safrad at email.cz
//* Web:      http://safrad.webzdarma.cz

unit uMain;

interface

uses
	uTypes,
	uEngine, uETypes,
	uGame,
	uDButton, uDTimer, uDForm, uKinds, uParser, uMenus,
	Messages, Forms, Graphics, Windows, SysUtils,
	Dialogs, ExtCtrls, Menus, Controls, ComCtrls, Classes, uDLabel;

type
	TfMain = class(TDForm)
		StatusBar: TStatusBar;
		BevelMenu: TBevel;
		MainMenu: TMainMenu;
		File1: TMenuItem;
		Information2: TMenuItem;
		OfferDraw1: TMenuItem;
		NN13: TMenuItem;
		Print1: TMenuItem;
		PrinterSetup1: TMenuItem;
		About1: TMenuItem;
		Exit1: TMenuItem;
		Moves1: TMenuItem;
		NoMove1: TMenuItem;
		Move1: TMenuItem;
		NN50: TMenuItem;
		AnalyseNextNoMove1: TMenuItem;
		AnalyseNextDoMove1: TMenuItem;
		List2: TMenuItem;
		NN22: TMenuItem;
		Back1: TMenuItem;
		Forward1: TMenuItem;
		FirstMove1: TMenuItem;
		LastMove1: TMenuItem;
		GoToMove1: TMenuItem;
		NN20: TMenuItem;
		ReplayMoves1: TMenuItem;
		PlayerTypes1: TMenuItem;
		StopAnalysis1: TMenuItem;
		AutomaticAnalysis1: TMenuItem;
		NN10: TMenuItem;
		Human1: TMenuItem;
		HumanProgram1: TMenuItem;
		ProgramHuman1: TMenuItem;
		Program1: TMenuItem;
		NN14: TMenuItem;
		AutomaticNewGame1: TMenuItem;
		BeforeNewGame1: TMenuItem;
		Levels1: TMenuItem;
		Levels2: TMenuItem;
		NN42: TMenuItem;
		Infinite1: TMenuItem;
		FixedDepth1: TMenuItem;
		Hourglass1: TMenuItem;
		LevelMove1: TMenuItem;
		LevelGame1: TMenuItem;
		MinimalNodes1: TMenuItem;
		LevelControls1: TMenuItem;
		NN41: TMenuItem;
		ShortestWin1: TMenuItem;
		WinIn1: TMenuItem;
		Engine1: TMenuItem;
		Suicide1: TMenuItem;
		Ponder1: TMenuItem;
		PieceActivity1: TMenuItem;
		RandomPlay1: TMenuItem;
		NN63: TMenuItem;
		HashTable1: TMenuItem;
		HashTablePositions1: TMenuItem;
		ClearHashTable1: TMenuItem;
		FreeHashTable1: TMenuItem;
		NN60: TMenuItem;
		ContemptValue1: TMenuItem;
		ProgramOfferDraw1: TMenuItem;
		ProgramResign1: TMenuItem;
		Clock1: TMenuItem;
		StopClock1: TMenuItem;
		PlayClock1: TMenuItem;
		NN30: TMenuItem;
		P0Clock1: TMenuItem;
		P1Clock1: TMenuItem;
		NN31: TMenuItem;
		FreeTime1: TMenuItem;
		RemainTime1: TMenuItem;
		View1: TMenuItem;
		Coordinates1: TMenuItem;
		Notation1: TMenuItem;
		AnalysisPreviousLine1: TMenuItem;
		AnalysisNextLine1: TMenuItem;
		AnalysisBoard2: TMenuItem;
		NN80: TMenuItem;
		Comment2: TMenuItem;
		NN81: TMenuItem;
		Precision1: TMenuItem;
		MenuNoDigit1: TMenuItem;
		Menu1Digit1: TMenuItem;
		Menu2Digits1: TMenuItem;
		Menu3Digits1: TMenuItem;
		Logo1: TMenuItem;
		Board1: TMenuItem;
		Rotate1801: TMenuItem;
		P0Visible1: TMenuItem;
		P1Visible1: TMenuItem;
		NN72: TMenuItem;
		Design2: TMenuItem;
		ActiveSquare1: TMenuItem;
		MouseCursor1: TMenuItem;
		Default1: TMenuItem;
		Hand1: TMenuItem;
		Cross1: TMenuItem;
		NN71: TMenuItem;
		OneClickMove1: TMenuItem;
		SlidePieces1: TMenuItem;
		DelayScreen1: TMenuItem;
		DelayScreenTime1: TMenuItem;
		NN52: TMenuItem;
		EnableAnalysisAutosave1: TMenuItem;
		AnalysisSavePeriod1: TMenuItem;
		Open2: TMenuItem;
		Save2: TMenuItem;
		SaveAs2: TMenuItem;
		NN82: TMenuItem;
		ProcessPriority1: TMenuItem;
		Idle1: TMenuItem;
		NormalP1: TMenuItem;
		High1: TMenuItem;
		RealTime1: TMenuItem;
		MainThreadPriority1: TMenuItem;
		Idle2: TMenuItem;
		Lowest2: TMenuItem;
		Belownormal2: TMenuItem;
		NormalP2: TMenuItem;
		Abovenormal2: TMenuItem;
		Highest2: TMenuItem;
		Timecritical2: TMenuItem;
		EngineThreadPriority1: TMenuItem;
		Idle3: TMenuItem;
		Lowest3: TMenuItem;
		Belownormal3: TMenuItem;
		NormalP3: TMenuItem;
		Abovenormal3: TMenuItem;
		Highest3: TMenuItem;
		Timecritical3: TMenuItem;
		NN01: TMenuItem;
		_SaveSettings1: TMenuItem;
		NN92: TMenuItem;
		NN61: TMenuItem;
		ECO1: TMenuItem;
		BookUse1: TMenuItem;
		PrinterSetupDialog1: TPrinterSetupDialog;
		TimerFast: TTimer;
		OpenDialog1: TOpenDialog;
		SaveDialog1: TSaveDialog;
		Clock2: TMenuItem;
		Board2: TMenuItem;
		Analysis2: TMenuItem;
		Moves2: TMenuItem;
		Help1: TMenuItem;
		ReadMe1: TMenuItem;
		SquareHighlight1: TMenuItem;
		Rotate901: TMenuItem;
		NN70: TMenuItem;
		Resign1: TMenuItem;
		Short1: TMenuItem;
		NN25: TMenuItem;
		Analog1: TMenuItem;
		FindMove1: TMenuItem;
		Help2: TMenuItem;
		DefaultLayout1: TMenuItem;
		Material1: TMenuItem;
		_ExportGame1: TMenuItem;
		_ExportPosition1: TMenuItem;
		Import1: TMenuItem;
		InsertNullmove1: TMenuItem;
		Mark1: TMenuItem;
		Analysis1: TMenuItem;
		NN51: TMenuItem;
		DeleteRemainingMoves1: TMenuItem;
		EvaluationProfile1: TMenuItem;
		Window1: TMenuItem;
		NN24: TMenuItem;
		NN43: TMenuItem;
		NN44: TMenuItem;
		CapturedPieces1: TMenuItem;
		CopyGraphicsContent1: TMenuItem;
		BackA1: TMenuItem;
		ForwardA1: TMenuItem;
		PGN2: TMenuItem;
		Figurine1: TMenuItem;
		Messages1: TMenuItem;
		NN90: TMenuItem;
		ParamsHelp1: TMenuItem;
		NN02: TMenuItem;
		NN65: TMenuItem;
		NN73: TMenuItem;
		Sounds1: TMenuItem;
		Clear2: TMenuItem;
		RefreshHashTable1: TMenuItem;
		FreeWindows1: TMenuItem;
		PanelTool: TPanel;
		GameRules1: TMenuItem;
		SpeedMark1: TMenuItem;
		GenerateNumbers1: TMenuItem;
		DeleteVariantion1: TMenuItem;
		SetVariantionAsMain1: TMenuItem;
		DeletePreviousMoves1: TMenuItem;
		GenerateDiagrams1: TMenuItem;
		Homepage1: TMenuItem;
		GenerateResultStats1: TMenuItem;
		NN91: TMenuItem;
		SaveAsGraphicsContent1: TMenuItem;
		SlidePiecesTime1: TMenuItem;
		PositionSetup2: TMenuItem;
		SetMoveTime1: TMenuItem;
		NodesTime1: TMenuItem;
		TimeMove1: TMenuItem;
		MultiPV1: TMenuItem;
		RandomValue1: TMenuItem;
		ECOPositions1: TMenuItem;
		EnterMoves1: TMenuItem;
		AcceptBookValue1: TMenuItem;
		AutoFlag1: TMenuItem;
		ScoreForFirstPlayer1: TMenuItem;
		SideToMove1: TMenuItem;
		PromoteTo1: TMenuItem;
		Queen1: TMenuItem;
		Rook1: TMenuItem;
		Bishop1: TMenuItem;
		Knight1: TMenuItem;
		NN21: TMenuItem;
		Ask1: TMenuItem;
		GameECO1: TMenuItem;
		ResignValue1: TMenuItem;
		CommonLevels1: TMenuItem;
		NN45: TMenuItem;
		NN40: TMenuItem;
		Player1Levels1: TMenuItem;
		Player2Levels1: TMenuItem;
		DeleteAllAnalysis1: TMenuItem;
		DeleteAllCommentary1: TMenuItem;
		DeleteAllMoveTime1: TMenuItem;
		DeleteMove1: TMenuItem;
		NN23: TMenuItem;
		DeleteAllMarks1: TMenuItem;
		GameAnalysis1: TMenuItem;
		Game1: TMenuItem;
		NewGame1: TMenuItem;
		DeleteGame1: TMenuItem;
		Up1: TMenuItem;
		Down1: TMenuItem;
		Previous1: TMenuItem;
		Next1: TMenuItem;
		NN11: TMenuItem;
		NN12: TMenuItem;
		Compact1: TMenuItem;
		Standard1: TMenuItem;
		Full1: TMenuItem;
		Template1: TMenuItem;
		DelaySound1: TMenuItem;
		DelaySoundTime1: TMenuItem;
		PauseClock1: TMenuItem;
		Parameters1: TMenuItem;
		NN62: TMenuItem;
		IncrementalTime1: TMenuItem;
		ActiveAndTarget1: TMenuItem;
		_BookFile1: TMenuItem;
		Priority1: TMenuItem;
		NN64: TMenuItem;
		RestartClock1: TMenuItem;
		WideVariants1: TMenuItem;
		TimeStrategy1: TMenuItem;
		FirstGame1: TMenuItem;
		LastGame1: TMenuItem;
		GeneratePieces1: TMenuItem;
		FileExtensions1: TMenuItem;
		ImageToFEN1: TMenuItem;
		Unknown1: TMenuItem;
		File2: TMenuItem;
		N1: TMenuItem;
		ECO2: TMenuItem;
		CommonParameters1: TMenuItem;
		Player1Parameters1: TMenuItem;
		Player2Parameters1: TMenuItem;
		N2: TMenuItem;
		N3: TMenuItem;
		SwapPlayers1: TMenuItem;
		N4: TMenuItem;
		N5: TMenuItem;
		OnSquares1: TMenuItem;
		AroundBoard1: TMenuItem;
		Off1: TMenuItem;
		ExportGames1: TMenuItem;
		_Export1: TMenuItem;
		Size1: TMenuItem;
		Off2: TMenuItem;
		Active1: TMenuItem;
		procedure Exit1Click(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure HashTablePositions1Click(Sender: TObject);
		procedure About1Click(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure Coordinates1Click(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure Rotate1Click(Sender: TObject);
		procedure PrinterSetup1Click(Sender: TObject);
		procedure Print1Click(Sender: TObject);
		procedure LevelsXClick(Sender: TObject);
		procedure Information2Click(Sender: TObject);
		procedure OfferDraw1Click(Sender: TObject);
		procedure BackwardForwardMove1Click(Sender: TObject);
		procedure FirstLastMove1Click(Sender: TObject);
		procedure GoToMove1Click(Sender: TObject);
		procedure ReplayMoves1Click(Sender: TObject);
		procedure StopAnalysis1Click(Sender: TObject);
		procedure AutomaticAnalysis1Click(Sender: TObject);
		procedure Move1Click(Sender: TObject);
		procedure PlayerType1Click(Sender: TObject);
		procedure Infinite1Click(Sender: TObject);
		procedure FixedDepth1Click(Sender: TObject);
		procedure Hourglass1Click(Sender: TObject);
		procedure LevelGame1Click(Sender: TObject);
		procedure LevelMove1Click(Sender: TObject);
		procedure MinimalNodes1Click(Sender: TObject);
		procedure LevelControls1Click(Sender: TObject);
		procedure ShortestWin1Click(Sender: TObject);
		procedure WinIn1Click(Sender: TObject);
		procedure RandomPlay1Click(Sender: TObject);
		procedure Ponder1Click(Sender: TObject);
		procedure ContemptValue1Click(Sender: TObject);
		procedure ProgramOfferDraw1Click(Sender: TObject);
		procedure ProgramResign1Click(Sender: TObject);
		procedure StopClock1Click(Sender: TObject);
		procedure PlayClock1Click(Sender: TObject);
		procedure PSetClock1Click(Sender: TObject);
		procedure RemainTime1Click(Sender: TObject);
		procedure SlidePieces1Click(Sender: TObject);
		procedure Design2Click(Sender: TObject);
		procedure Save2Click(Sender: TObject);
		procedure DelayScreen1Click(Sender: TObject);
		procedure _SaveSettings1Click(Sender: TObject);
		procedure OneClickMove1Click(Sender: TObject);
		procedure BookUse1Click(Sender: TObject);
		procedure AnalysisSavePeriod1Click(Sender: TObject);
		procedure NextMove1Click(Sender: TObject);
		procedure BeforeNewGame1Click(Sender: TObject);
		procedure TimerFastTimer(Sender: TObject);
		procedure Sounds1Click(Sender: TObject);
		procedure Suicide1Click(Sender: TObject);
		procedure PieceActivity1Click(Sender: TObject);
		procedure P0Visible1Click(Sender: TObject);
		procedure EnableAnalysisAutosave1Click(Sender: TObject);
		procedure DelayScreenTime1Click(Sender: TObject);
		procedure FreeTime1Click(Sender: TObject);
		procedure HashTable1Click(Sender: TObject);
		procedure MouseCursorX1Click(Sender: TObject);
		procedure FreeHashTable1Click(Sender: TObject);
		procedure ClearHashTable1Click(Sender: TObject);
		procedure List2Click(Sender: TObject);
		procedure ActiveSquare1Click(Sender: TObject);
		procedure MenuNoDigit1Click(Sender: TObject);
		procedure ProcessPriorityClick(Sender: TObject);
		procedure ThreadMainPriorityClick(Sender: TObject);
		procedure EnginePriorityClick(Sender: TObject);
		procedure LastNextAnalysis1Click(Sender: TObject);
		procedure Comment2Click(Sender: TObject);
		procedure Open2Click(Sender: TObject);
		procedure Normalmove1Click(Sender: TObject);
		procedure Logo1Click(Sender: TObject);
		procedure Board2Click(Sender: TObject);
		procedure Clock2Click(Sender: TObject);
		procedure Analysis2Click(Sender: TObject);
		procedure Moves2Click(Sender: TObject);
		procedure FormKeyDown(Sender: TObject; var Key: Word;
			Shift: TShiftState);
		procedure FormShow(Sender: TObject);
		procedure ReadMe1Click(Sender: TObject);
		procedure Resign1Click(Sender: TObject);
		procedure Short1Click(Sender: TObject);
		procedure Analog1Click(Sender: TObject);
		procedure FindMove1Click(Sender: TObject);
		procedure Help2Click(Sender: TObject);
		procedure DefaultLayout1Click(Sender: TObject);
		procedure Material1Click(Sender: TObject);
		procedure _ExportGame1Click(Sender: TObject);
		procedure Import1Click(Sender: TObject);
		procedure InsertNullmove1Click(Sender: TObject);
		procedure DeleteRemainingMoves1Click(Sender: TObject);
		procedure EvaluationProfile1Click(Sender: TObject);
		procedure CapturedPieces1Click(Sender: TObject);
		procedure CopyGraphicsContent1Click(Sender: TObject);
		procedure PGN2Click(Sender: TObject);
		procedure Figurine1Click(Sender: TObject);
		procedure Messages1Click(Sender: TObject);
		procedure ParamsHelp1Click(Sender: TObject);
		procedure Clear2Click(Sender: TObject);
		procedure RefreshHashTable1Click(Sender: TObject);
		procedure FreeWindows1Click(Sender: TObject);
		procedure GenerateNumbers1Click(Sender: TObject);
		procedure DeletePreviousMoves1Click(Sender: TObject);
		procedure SetVariantionAsMain1Click(Sender: TObject);
		procedure DeleteVariantion1Click(Sender: TObject);
		procedure GenerateDiagrams1Click(Sender: TObject);
		procedure Homepage1Click(Sender: TObject);
		procedure GenerateResultStats1Click(Sender: TObject);
		procedure SpeedMark1Click(Sender: TObject);
		procedure SlidePiecesTime1Click(Sender: TObject);
		procedure PositionSetup2Click(Sender: TObject);
		procedure SetMoveTime1Click(Sender: TObject);
		procedure NodesTime1Click(Sender: TObject);
		procedure TimeMove1Click(Sender: TObject);
		procedure EngineParameter1Click(Sender: TObject);
		procedure RandomValue1Click(Sender: TObject);
		procedure ECOPositions1Click(Sender: TObject);
		procedure EnterMoves1Click(Sender: TObject);
		procedure AcceptBookValue1Click(Sender: TObject);
		procedure ECO1Click(Sender: TObject);
		procedure AutoFlag1Click(Sender: TObject);
		procedure ScoreForFirstPlayer1Click(Sender: TObject);
		procedure SideToMove1Click(Sender: TObject);
		procedure PromoteToFigure1Click(Sender: TObject);
		procedure SaveAs2Click(Sender: TObject);
		procedure GameECO1Click(Sender: TObject);
		procedure ResignValue1Click(Sender: TObject);
		procedure CommonLevels1Click(Sender: TObject);
		procedure DeleteAllX1Click(Sender: TObject);
		procedure GameAnalysis1Click(Sender: TObject);
		procedure NewGame1Click(Sender: TObject);
		procedure DeleteGame1Click(Sender: TObject);
		procedure UpDown1Click(Sender: TObject);
		procedure Previous1Click(Sender: TObject);
		procedure Next1Click(Sender: TObject);
		procedure Compact1Click(Sender: TObject);
		procedure DelaySound1Click(Sender: TObject);
		procedure DelaySoundTime1Click(Sender: TObject);
		procedure PanelToolResize(Sender: TObject);
		procedure PauseClock1Click(Sender: TObject);
		procedure IncrementalTime1Click(Sender: TObject);
		procedure Parameters1Click(Sender: TObject);
		procedure ActiveAndTarget1Click(Sender: TObject);
		procedure _BookFile1Click(Sender: TObject);
		procedure AutomaticNewGame1Click(Sender: TObject);
		procedure RestartClock1Click(Sender: TObject);
		procedure WideVariants1Click(Sender: TObject);
		procedure TimeStrategy1Click(Sender: TObject);
		procedure FirstGame1Click(Sender: TObject);
		procedure LastGame1Click(Sender: TObject);
		procedure GeneratePieces1Click(Sender: TObject);
		procedure FileExtensions1Click(Sender: TObject);
		procedure ImageToFEN1Click(Sender: TObject);
		procedure Unknown1Click(Sender: TObject);
		procedure CommonParameters1Click(Sender: TObject);
		procedure SwapPlayers1Click(Sender: TObject);
		procedure AroundBoard1Click(Sender: TObject);
		procedure Size1Click(Sender: TObject);
	private
		{ Private declarations }
		procedure NotationXClick(Sender: TObject);
		procedure InitMenuRotate;
		procedure MoveMarkXClick(Sender: TObject);
		procedure LevelXClick(Sender: TObject);
		procedure GameRuleXClick(Sender: TObject);
		procedure RWOptions(const Save: BG);
		procedure FileIsDropped(var Msg: TMessage); message WM_DropFiles;
//    procedure InitForm(Form: TForm);
		procedure InitForms;
	public
		{ Public declarations }
		procedure InitMenuEngine;
		procedure InitMenuTimeGo;
		procedure InitMenuPlayerTypes;
		procedure InitMenuAnalysis;
		procedure OnAdvancedMenuDraw(Sender: TObject; ACanvas: TCanvas;
			ARect: TRect; State: TOwnerDrawState);
		{$ifdef Thread}
		procedure ParallelDone(Sender: TObject);
		{$endif}
		procedure ChangeFile(Sender: TObject);
	end;

var
	fMain: TfMain;

	Kinds: TKinds;

// Delay
var
	DelayScreen: BG;
const
	DefDelayScreenTime = 400;
var
	DelayScreenTime: U4 = DefDelayScreenTime;

var
	DelaySound: BG;
const
	DefDelaySoundTime = 400;
var
	DelaySoundTime: U4 = DefDelaySoundTime;

	// System
	PriorityProcess: UG = 1;
	PriorityMainThread: UG = 3;
	PriorityEngineThread: UG = 3;
var
	Precision: U1;

function PosToString(Pos: PPos; Game: PGame; EPD: BG = False): string;
function StringToGame(FileData: string; UnspecGameType: TGameType): BG;
//function LoadFromFile(const Kind: SG): BG;
procedure FreeMoves(var P: PGameMoves);
function SaveToFile(var FileName: TFileName): BG;
procedure InitMenuTM;
function StrToMove(Line: string; var InLineIndex: SG; const Nota: TNotation): string;
procedure FillGameECO;
procedure NewSubGameEx;
procedure GameChanged;
procedure KindsChange;
function GetPlyCount(Game: PGame; Main: BG): SG;
function VariantToStr(GameType: TGameType; V: TVariantParams): string;

implementation

{$R *.dfm}
uses
	ShellAPI, Math, ClipBrd, StdCtrls,
	{$ifdef ResultStats}
	Chart, Series, uDChart,
	{$endif}
	uMath, uAPI, uFormat, uSystem, uSysInfo, uFileExt,
	uFiles, uError, uGetTime, uGetInt, uDBitmap, uReg, uGetStr, uFind,
		uLogo, uAbout, uDIni, uStrings, uData, uInput, uSounds, uHTML, uStats,
		uGraph,
	{$ifdef Thread}
	uParallel,
	{$endif}
		uSetup, uPieces, uLevels, uGameInfo, uEBook, uBoard,
		uNextMove, uPrint, uComment, uClock, uAnalys, uMoves, uFEN,
	uNew, uPGN, uEngineP, uEParams, uOptions, uEBoard, uEGen, uEHash, uESearch, uETimer,
	uDView;

var
	EnableHashTable: BG;
	WantHashPos: UG;

const
	DefReplayTime = 1000;
var
	ReplayTime: U4 = DefReplayTime;

procedure FreeMoves(var P: PGameMoves);
var i: SG;
begin
	if P <> nil then
	begin
		for i := 0 to P.Count - 1 do
		begin
			P.Moves[i].CommentBefore := '';
			P.Moves[i].CommentAfter := '';
			FreeMoves(P.Moves[i].Moves);
		end;
		FreeMem(P); P := nil;
	end;
end;

procedure FreeGame(Game: PGame);
var i, j: SG;
begin
	Game.StartCommnent := '';
	for j := 0 to PlayerMax do
	for i := 0 to Length(Game.Params[j]) - 1 do
	begin
		if EO[TEngineOption(i)].Typ = vsString then
			Game.Params[j, TEngineOption(i)].Str := '';
	end;
	for i := 0 to Length(Game.PGNTags) - 1 do
		Game.PGNTags[TPGNTag(i)] := '';
	FreeMoves(Game.FirstMove);
	FillChar(Game^, SizeOf(TGame), 0);
end;

procedure FreeFile(const Kind: SG);
var
	i: SG;
{ Game: PGame;
	Games: TDatas;}
begin
{ Game := PGame(Kinds.Items[Kind].PData);
	Games := TDatas(SG(Kinds.Items[Kind].PData) + SizeOf(TGame));}
	if Games <> nil then
	begin
		for i := 0 to SG(Games.Count) - 1 do
		begin
			if i <> Games.Index then
				FreeGame(PGame(Games.Get(i)));
		end;
	end;
	FreeGame(@Game);
//  FillChar(Game, SizeOf(Game), 0);
	FreeAndNil(Games);
end;

function GetPlyCount(Game: PGame; Main: BG): SG;
var
	P: PGameMoves;
begin
	Result := 0;
	P := Game.FirstMove;
	while P <> nil do
	begin
		if Main = False then
			P := P.Moves[P.Actual].Moves
		else
			P := P.Moves[P.Main].Moves;
		Inc(Result);
	end;
end;

procedure ClearAnalysisInfoAndAnalysis;
begin
	ClearAnalysisInfo(AnalysisInfo);
	DrawAnalysisInfo;

	AnalysisC := 0; SetLength(Analysis, 0);
	ABoardVisAnalysis := -1;
	ABoardMoveIndex := -1;
	DrawAMoves;
	fMain.InitMenuAnalysis;
end;

procedure StrToGameType(const IdValue: string);
var
	i, SubVariant: SG;
	LineIndex: SG;
	s: string;
begin
	SubVariant := 0;
	LineIndex := 1;
	if IdValue[LineIndex] in ['0'..'9'] then
	begin
		i := ReadSGFast(IdValue, LineIndex);
		case i of
		0: Game.GameType := gtChess;
		1: Game.GameType := gtChineseChess;
		20..28:
		begin
			Game.GameType := gtDraughts;
			SubVariant := i - 20;
		end;
		50: Game.GameType := gtOthello;
		51: Game.GameType := gtGomoku;
		end;
	end
	else
	begin
		s := ReadToChar(IdValue, LineIndex, ',');
		for i := 0 to SG(High(TGameType)) do
			if s = LowerCase(GameNames[TGameType(i)]) then
			begin
				Game.GameType := TGameType(i);
				SubVariant := 0;
				Break;
			end;
	end;
	Game.Variant := GameVariants[Game.GameType, SubVariant];
	if LineIndex < Length(IdValue) then
	begin
		Game.Variant.Options[voWidth].Num := ReadSGFast(IdValue, LineIndex);
{   Game.Variant.Options[voHeight].Num := ReadSGFast(IdValue, LineIndex);
		case IdValue[LineIndex] of
		'A':
		'N':
		'S':
		end;
		dd
		s :=
		if s = '1' then
			InvertFlag

		// D???} 
	end;
end;

function VariantToStr(GameType: TGameType; V: TVariantParams): string;
var i: SG;
begin
	for i := 0 to Length(V) - 1 do
		if V[TVariantOption(i)].Num <> GameVariants[GameType, 0].Options[TVariantOption(i)].Num then
			Result := Result + NamesTGameVariant[TVariantOption(i)] + ' ' + IntToStr(V[TVariantOption(i)].Num) + ', ';
	Result := DeleteLastChar(Result, 2);
end;

procedure StrToVariant(const IdValue: string);
var i, j, Num: SG;
begin
	if IdValue = 'suicide' then
	begin
		Game.Variant.Options[voSuicide].Bool := True;
		Game.Variant.Options[voMustCapture].Bool := True;
		Game.Variant.Options[voMateKing].Bool := False;
	end
	else if IdValue = 'crazyhouse' then
	begin
		Game.Variant.Options[voRCP].Bool := True;
		Game.Variant.Options[voMustCapture].Bool := False;
		Game.Variant.Options[voMateKing].Bool := True;
	end
	else
{ else if IdValue = 'wild' then
	else if IdValue = 'fisherrandom' then}
		for i := 0 to Length(NamesTGameVariantL) - 1 do
		begin
			j := Pos(LowerCase(NamesTGameVariantL[TVariantOption(i)]), IdValue);
			if j <> 0 then
			begin
				Inc(j, Length(NamesTGameVariantL[TVariantOption(i)]));
				Num := ReadSGFast(IdValue, j);
	//      if Num = 0 then Num := 1;
				Game.Variant.Options[TVariantOption(i)].Num := Num;
	// GameVariants[GameType, 0].Variant[TGameVariant(i)].Num then
			end;
		end;
end;

procedure NewSubGameOne(G: PGame);
begin
	PlayASound(snNewGame);

	if G <> nil then
	begin
		Game.SeparatedLevel := G.SeparatedLevel;
		Game.Levels := G.Levels;
		Game.SeparatedEngine := G.SeparatedEngine;
		Game.Params := G.Params;
		Game.PlayerTypes := G.PlayerTypes;
		Game.PGNTags := G.PGNTags;
	end
	else
	begin
		RWLevels(LevelsIni, False);
		RWEngine(EngineIni, False);
	end;

	// PGN Tags
	FillGameDateTime(Now);
	Game.PGNTags[ptResult] := GameTerminationStr[gtNone];
	Game.PGNTags[ptTermination] := 'unterminated';
	Game.PGNTags[ptGameType] := GameNames[Game.GameType];
	Game.PGNTags[ptVariant] := VariantToStr(Game.GameType, Game.Variant.Options);
end;

procedure NewSubGame(GameType: TGameType; var G: TGameVariant);
var i: SG;
begin
	// Erase New empty game
	if Games = nil then
	begin
		Games := TDatas.Create;
		Games.ItemAddr := @Game;
		Games.ItemSize := SizeOf(Game);
	end;
	Games.Add;
	Games.Index := Games.Count - 1;

	Game.GameType := GameType;
	Game.Variant := G;

	Game.FirstMove := nil;
	Game.CXY := StP;

	Game.SeparatedLevel := PlayerMax + 1;
	Game.SeparatedEngine := PlayerMax + 1;
	for i := 0 to PlayerMax + 1 do
	begin
		Game.Levels[i] := DefLevel;
		DefaultEngineOptions(Game.Params[i]);
	end;
	InitEngine;

	FillStartPos;
	CopyPos(Game.Variant.Pos, Game.Pos);
	
	GameLastMove := nil;
	GameNextMoves := nil;
end;

function NewSubGameDialog(G: PGame): BG;
begin
	if not Assigned(fNew) then
	begin
		fNew := TfNew.Create(nil);
	end;
	Result := fNew.ShowModal = mrOk;
	if Result then
	begin
		NewSubGame(fNew.GameType, fNew.GameOpt[fNew.GameType]);
		NewSubGameOne(G);
	end;
end;

procedure NewSubGameEx;
var
	G: PGame;
begin
	if Games.Count <= 0 then
		G := nil
	else
		G := Games.Get(Games.Index);
	NewSubGameOne(G);
	NewSubGame(Game.GameType, Game.Variant);
	CopyPos(Game.Variant.Pos, Game.Pos);
end;

function NewFile(const Kind: SG): BG;
var G: PGame;
begin
	Kinds.Items[Kind].FileName := Kinds.Items[Kind].FileName + '.pgn';

	if (Kinds.Count > 1) then
		G := PGame(Kinds.Items[Kinds.Count - 2].PData)
	else
		G := nil;
	Result := NewSubGameDialog(G);
end;

function StrToMove(Line: string; var InLineIndex: SG; const Nota: TNotation): string; // Change AMin
var
	a: SG;
	x, y: array[0..MaxMoveL] of SG;

	procedure NextA;
	var
		i: SG;
		ax, ay: SG;
		M2: PMove;
	begin
		M2 := FCMove;
		if Nota = ntShogi then
			Exchange(x[a], y[a]);
		for i := 0 to CMC - 1 do
		begin
			if M2.Prior <> 0 then
			begin
				case MoveFormat of
				mfDraughts:
				begin
					if M2.Lng = 0 then
					{$ifopt d+}
						IE('StrToMove')
					{$endif}
					else if M2.Lng = 1 then
					begin
						IToXY(M2.Sq[a], ax, ay);
						if ((x[a] <> -1) and (ax <> x[a]))
						or ((y[a] <> -1) and (ay <> y[a])) then
						begin
							M2.Prior := 0;
						end;
					end
					else
					begin
						IToXY(M2.Sq[2 * a], ax, ay);
						if ((x[a] <> -1) and (ax <> x[a]))
						or ((y[a] <> -1) and (ay <> y[a])) then
						begin
							M2.Prior := 0;
						end;
					end;
				end;
				mfChess:
				begin
					if M2.Prior <> 0 then
					begin
						if a = 0 then
							IToXY(M2.FrSq, ax, ay)
						else if a = 1 then
							IToXY(M2.ToSq, ax, ay)
						{$ifopt d+}
						else
							IE('StrToMove'){$endif};

						if ((x[a] <> -1) and (ax <> x[a]))
						or ((y[a] <> -1) and (ay <> y[a])) then
						begin
							M2.Prior := 0;
						end;
					end;
				end;
				else
				begin
					IToXY(M2.T, ax, ay);
					if ((x[a] <> -1) and (ax <> x[a]))
					or ((y[a] <> -1) and (ay <> y[a])) then
					begin
						M2.Prior := 0;
					end;
				end;
				end;
			end;

			Inc(SG(M2), SizeTMove);
		end;
		Inc(a);
	end;

	procedure NextA2;
	begin
		if (x[a] <> -1) or (y[a] <> -1) then
		begin
			if a = 0 then
			begin
				x[1] := x[0];
				y[1] := y[0];
				a := 1;
			end;
			NextA;
		end;
	end;

var
	i: SG;
	M2: PMove;
	Piece, TmpPiece: SG;
	LegM, LegMCount: SG;

	procedure Promote;
	var
		i: SG;
		Prom: SG;
	begin
		NextA2;
		// Select promotion
		Prom := DecodePiece(Line, InLineIndex, False);
		if Prom = sqEmpty then Exit;
		M2 := FCMove;
		for i := 0 to CMC - 1 do
		begin
			if (M2.Prior <> 0) and (Abs(TPiece(M2.TM)) <> Prom) then
			begin
				M2.Prior := 0;
			end;
			Inc(SG(M2), SizeTMove);
		end;
	end;

label LFin, LAgain;
var
	Typ: TTM;
	Put: BG;
	StartInLineIndex: SG;
	HPos: TPos;
begin
	// Init Result
	Result := '';
	AMin := NullMoveIndex;

	if Line = '' then Exit;
	if Line = NullMoveStr then
	begin
		Exit;
	end;

	StartInLineIndex := InLineIndex;

	LAgain:

	if GameType = gtCastleAndEP then
	if Line[InLineIndex] = 'O' then
	begin
		Typ := tmOO;
		if (Length(Line) >= InLineIndex + 3) and (Line[InLineIndex + 3] = '-') then
		begin
			Typ := tmOOO;
			Inc(InLineIndex, 5);
		end
		else
			Inc(InLineIndex, 3);

		M2 := FCMove;
		LegMCount := 0;
		LegM := NullMoveIndex;
		for i := 0 to CMC - 1 do
		begin
			if M2.TM = Typ then
			begin
				Inc(LegMCount);
				LegM := i;
			end;
			Inc(SG(M2), SizeTMove);
		end;
		goto LFin;
	end;

	// Decode piece
	Piece := 1;
	if (MoveFormat <> mfGO) and (PieceTypes > 1) then
	begin
		if (Length(Line) <= InLineIndex + 1) or (Line[InLineIndex + 2] = ' ') then
			Piece := sqP0 // B3
		else
		begin
			Piece := DecodePiece(Line, InLineIndex, False); // Bc4
			if Piece = 0 then Piece := sqP0;
		end;

		M2 := FCMove;
		for i := 0 to CMC - 1 do
		begin
			case MoveFormat of
			mfDraughts: TmpPiece := Abs(CPos.Board[PCMove.Sq[0]]);
			else // mfChess
				TmpPiece := Abs(M2.F1);
			end;

			if TmpPiece <> Piece then
			begin
				M2.Prior := 0;
			end;
			Inc(SG(M2), SizeTMove);
		end;
	end;

	Put := False;
	FillChar(x, SizeOf(x), -1);
	FillChar(y, SizeOf(y), -1);
	a := 0;
	if Nota = ntDraughts then
	begin
		while InLineIndex <= Length(Line) do
		begin
			case Line[InLineIndex] of
			'-', 'x', 'X':
			begin
				NextA;
				Inc(InLineIndex);
			end;
			'=', '/':
			begin
//        NextA;
				Inc(InLineIndex);
				Break;
			end;
			'0'..'9':
			begin
				if (x[a] <> -1) or (y[a] <> -1) then
					NextA;
				ReadSquare(Line, InLineIndex, x[a], y[a]);
			end;
			else
			begin
				Inc(InLineIndex);
				Result := 'Illegal move format ' + Copy(Line, StartInLineIndex, InLineIndex - StartInLineIndex);
				Exit;
			end;
			end;
		end;
	end
	else
	begin
		while InLineIndex <= Length(Line) do
		begin
			case Line[InLineIndex] of
			'-', 'x', 'X':
			begin
				NextA;
				Inc(InLineIndex);
			end;
			'@':
			begin
				if MoveFormat <> mfGO then
				begin
					if Game.Variant.Options[voRCP].Bool = False then
					begin
						Game.Variant.Options[voRCP].Bool := True;
						GenerateMoves;
						InLineIndex := StartInLineIndex;
						goto LAgain;
					end;
					Put := True;
					M2 := FCMove;
					for i := 0 to CMC - 1 do
					begin
						if (M2.TM <> tmPut) then
						begin
							M2.Prior := 0;
						end;
						Inc(SG(M2), SizeTMove);
					end;
				end;
				Inc(InLineIndex);
			end;
			'=', '/':
			begin
				Inc(InLineIndex);
				if Game.Variant.Options[voPromote].Num = 0 then
				begin
					Inc(InLineIndex);
					Break;
				end;
				Promote;
				Break;
			end;
			'0'..'9':
			begin
				if (x[a] <> -1) or (y[a] <> -1) then
					if (Nota = ntShogi) then NextA;
				if y[a] <> -1 then NextA;
				y[a] := ReadSGFast(Line, InLineIndex) - 1;
				if Nota = ntOthello then
					y[a] := SqY - y[a];
			end;
			'a'..'w': //Char(Ord('a') + BoardX - 1):
			begin
				if (x[a] <> -1) or (y[a] <> -1) then
					if (Nota in [ntChess, ntOthello]) then NextA;
				if x[a] <> -1 then NextA;
				x[a] := Ord(Line[InLineIndex]) - Ord('a'); Inc(InLineIndex);
			end;
			'A'..'W':
			begin
				if (Piece = 1) and (a > 1) then
					Promote
				else
				begin
					if (x[a] <> -1) or (y[a] <> -1) then
						if (Nota in [ntChess, ntOthello]) then NextA;
					if x[a] <> -1 then NextA;
					x[a] := Ord(Line[InLineIndex]) - Ord('A');
				end;
				Inc(InLineIndex);
			end;
			'+', '#':
			begin
				Inc(InLineIndex);
				Break;
			end;
			' ', '{': Break;
			else
			begin
				Inc(InLineIndex);
				Result := 'Illegal move format ' + Copy(Line, StartInLineIndex, InLineIndex - StartInLineIndex);
				Exit;
			end;
			end;
		end;
	{ for i := 0 to a - 2 do
		begin
			if x[a] = -1 then
			begin
				x[a] := x[a + 1];
			end;
			if y[a] = -1 then
			begin
				y[a] := y[a + 1];
			end;
		end;}
	end;
	NextA2;

	M2 := FCMove;
	LegMCount := 0;
	LegM := NullMoveIndex;
	for i := 0 to CMC - 1 do
	begin
		if Put = False then
			if M2.TM = tmPut then M2.Prior := 0;

		if M2.Prior <> 0 then
		begin
			Inc(LegMCount);
			LegM := i;
		end;
		Inc(SG(M2), SizeTMove);
	end;

	LFin:
	if LegMCount > 1 then
	begin
		if (Game.Variant.Options[voMateKing].Bool) then
		begin
			// Remove illegal moves
			PCMove := FCMove;
			for i := 0 to CMC - 1 do
			begin
				if PCMove.Prior <> 0 then
				begin
					CopyPos(CPos, HPos);
					DoMove;
					MIncCMC := False;
					GenerateMoves;
					MIncCMC := True;
					CopyPos(HPos, CPos);
					if CCheck[CPos.Side] then
					begin
						PCMove.Prior := 0;
						Dec(LegMCount);
					end
					else
					begin
						LegM := i;
					end;
				end;
				Inc(SG(PCMove), SizeTMove);
			end;
		end;
	end;
	if LegMCount = 0 then
	begin
		if Length(Line) >= StartInLineIndex + 1 then
		if (Line[StartInLineIndex] = UpCase(Line[StartInLineIndex])) and (Line[StartInLineIndex + 1] = 'X') then
		begin
			// Uppercase ambiguity problem bxc3 / Bxc3
			M2 := FCMove;
			for i := 0 to CMC - 1 do
			begin
				M2.Prior := 127;
				Inc(SG(M2), SizeTMove);
			end;
			Line[StartInLineIndex] := LowCase(Line[StartInLineIndex]);
			InLineIndex := StartInLineIndex;
			goto LAgain;
		end;
		Result := Result + 'Can not translate move ' + Copy(Line, StartInLineIndex, InLineIndex - StartInLineIndex);
	end
	else if LegMCount > 1 then
		Result := Result + NToS(LegMCount) + ' translations for move ' + Copy(Line, StartInLineIndex, InLineIndex - StartInLineIndex);

	AMin := LegM;
end;

const
	MaxTime = 100 * Hour - 1;

function SetMark(M: PGameMove; Mark: SG): BG;
begin
	if Mark < 0 then
	begin
		Result := False;
	end
	else if Mark <= mmQuestionableMove then
	begin
		M.Mark[0] := Mark;
		Result := True;
	end
	else if Mark <= mmMaxStdMark then
	begin
		M.Mark[1] := Mark;
		Result := True;
	end
	else if (Mark <= SG(High(TMoveMark))) then
	begin
		M.Mark[2] := Mark;
		Result := True;
	end
	else
		Result := False;
end;

function MoveIndexToS(MoveIndex: SG): string;
begin
	Result := IntToStr(MoveIndex div (PlayerMax + 1) + 1) + '.';
	if MoveIndex mod (PlayerMax + 1) <> 0 then
		Result := Result + '..';
end;


const
	EMTStr = '%emt';
	EVALStr = '%eval';

function StringToGame(FileData: string; UnspecGameType: TGameType): BG;
var
	Parser: TDParser;
	s: string;
	InLineIndex: SG;
	Terminated: BG;

	procedure SetTermination(GT: TGameTermination);
	begin
		Terminated := True;
		if Game.GameTermination = gtNone then
		begin
			Game.GameTermination := GT;
		end
{   if Game.PGNTags[ptResult] = '' then
		begin
			Game.PGNTags[ptResult] := Id
		end}
		else if Game.PGNTags[ptResult] <> GameTerminationStr[GT] then
		begin
			Parser.AddMes2(mtUserWarning, ['Game termination and Result tag not equal']);
		end;
	end;

	var
		MovesDepth: SG;
		LastCharsTable: TCharsTable;

	procedure ReadLevelMoves;
	label LMove, LNext;
	var
		i: SG;
		sx: string;
		LActMove: SG;
	begin
		Inc(MovesDepth);

		while True do
		begin
			LNext:
			case Parser.InputType of
			itEOI: Break;
			itSemicolon:
			begin
				Parser.ReadToNewLine;
			end;
			itLBracket2: Break;
			itMul:
			begin
				Parser.ReadInput;
				SetTermination(gtNone);
				Break;
			end;
			itLBracket:
			begin
				Parser.ReadInput;
//        CopyPos(CPos, LPos);

				// Save
				LActMove := Game.Pos.MoveIndex - Game.Variant.Pos.MoveIndex;

				// Back Moves
				Game.Pos.MoveIndex := 9999999;
				GoToMove(LActMove - 1);
				CopyPos(Game.Pos, CPos);

				ReadLevelMoves;

				// Restore
				Game.Pos.MoveIndex := 9999999;
				GoToMove(LActMove - 1);
				GameNextMoves.Actual := GameNextMoves.Main;
//        GameLastMove.Moves.Actual := GameLastMove.Moves.Main;
				Game.Pos.MoveIndex := 9999999;
				GoToMove(LActMove);
				CopyPos(Game.Pos, CPos);
//        CopyPos(LPos, CPos);
			end;
			itDollar:
			begin
				LastCharsTable := CharsTable;
				CharsTable['-'] := ctMinus;
				CharsTable['.'] := ctPoint;
				CharsTable['0'] := ctNumber;
				CharsTable['1'] := ctNumber;
				CharsTable['2'] := ctNumber;
				CharsTable['3'] := ctNumber;
				CharsTable['4'] := ctNumber;
				CharsTable['5'] := ctNumber;
				CharsTable['6'] := ctNumber;
				CharsTable['7'] := ctNumber;
				CharsTable['8'] := ctNumber;
				CharsTable['9'] := ctNumber;
				if SetMark(GameLastMove, Parser.ReadSGFast(0, 0, SG(High(TMoveMark)))) = False then
					Parser.AddMes2(mtUserError, ['Bad mark number ' + NToS(Parser.InInteger)]);
				CharsTable := LastCharsTable;
				Parser.ReadInput;
			end;
			itRBracket:
			begin
				Parser.ReadInput;
				Break;
			end;
(*      itInteger:
			begin
				Id0 := Parser.Id;
				i := 2 * (Parser.InInteger - 1);
				Parser.ReadInput;
				if (i = -2) and ((Parser.Id = '-0') or (Parser.Id = '-0-0')) then // Bad castle (numeric)
				begin
					Parser.Id := 'O-' + ReplaceF(Parser.Id, '0', 'O');
					goto LMove;
				end;
				if (Parser.Id = '-0') or (Parser.Id = '-1') or (Parser.Id = '/2-1/2') then
				begin
					if (Parser.Id = '/2-1/2') then
					begin
						SetTermination(gt1212);
					end
					else
					begin
						if Id0 = '1' then
							SetTermination(gt10)
						else
							SetTermination(gt01);
					end;
					Parser.ReadInput;
					Break;
				end;
				if Parser.InputType = itPeriod then
				begin
					Parser.ReadInput;
					if Parser.InputType = itPeriod then
					begin
						Inc(i);
						while True do
						begin
							Parser.ReadInput;
							if Parser.InputType <> itPeriod then Break;
						end;
					end;
				end
				else
				begin
					Parser.Id := Id0 + Parser.Id; // D??? Draughts notation DNW 10-15, 15
					goto LMove;
				end;

				if FoundOffset = False then
				begin
					FoundOffset := True;
					if Game.Variant.Pos.MoveIndex <> i then
					begin
						// FEN contains Offset
						Parser.AddMes2(mtUserWarning,
							['Bad number of move "' + MoveIndexToS(i) + '" may be "' + MoveIndexToS(Game.Variant.Pos.MoveIndex)])
					end;
				end
				else
				begin

				end;
			end; *)
			itIdent:
			begin
//        if MovesDepth = 1 then // Read only main variant
				if Length(Parser.Id) > 0 then
				if Parser.Id[Length(Parser.Id)] = '.' then
				begin

				end
				else
				begin
					for i := 0 to Length(GameTerminationStr) - 1 do
						if GameTerminationStr[TGameTermination(i)] = Parser.Id then
						begin
							SetTermination(TGameTermination(i));
							Parser.ReadInput;
							goto LNext;
						end;

					LMove:
					for i := 1 to Length(MoveMarks) - 1 do
					begin
						if Parser.Id = MoveMarks[i] then
						begin
							SetMark(GameLastMove, i);
							Parser.ReadInput;
							goto LNext;
						end;
					end;
					GenerateMoves;
					i := 1;
					s := StrToMove(Parser.Id, i, GetNotation(ntDefault));
					if s = '' then
					begin
						if AMin <> NullMoveIndex then
						begin
							PCMove := PMove(SG(FCMove) + AMin shl ShlTMove);
							DoMove;
						end;
					end
					else
						Parser.AddMes2(mtUserError, [s]);
					if DoGameMove(AMin, False) = False then
					begin
						{$ifopt d+}IE('StringToGame2'){$endif};
						DoGameMove(NullMoveIndex, False);
					end;
//          Inc(SG(FCMove), CMC shl ShlTMove);
				end;
				Parser.ReadInput;
			end;
			itLBracket3: // itComment, MoveTime etc.
			begin
{       Parser.EnableSpace := 2;
				Parser.EnableReturn := True;}
				Parser.ReadToChar('}');
{       Parser.EnableSpace := 2;
				Parser.EnableReturn := True;}

				s := Parser.Id;

				LastCharsTable := CharsTable;
				CharsTable['-'] := ctMinus;
				CharsTable['.'] := ctPoint;
				CharsTable['0'] := ctNumber;
				CharsTable['1'] := ctNumber;
				CharsTable['2'] := ctNumber;
				CharsTable['3'] := ctNumber;
				CharsTable['4'] := ctNumber;
				CharsTable['5'] := ctNumber;
				CharsTable['6'] := ctNumber;
				CharsTable['7'] := ctNumber;
				CharsTable['8'] := ctNumber;
				CharsTable['9'] := ctNumber;

				i := Pos('[' + EMTStr, s);
				if i <> 0 then
				begin
					Inc(i, Length(EMTStr) + 1);
					sx := ReadToChar(s, i, ']');
					GameLastMove.MovTime := StrToMs(sx, 0, 0, MaxTime);

					Delete(s, i - Length(sx) - 5 - 1, Length(sx) + 5 + 1);
				end;

				i := Pos('[' + EVALStr, s);
				if i <> 0 then
				begin
					Inc(i, Length(EVALStr) + 1);
					sx := ReadToChar(s, i, ']');
					InLineIndex := 1;
					GameLastMove.Analysis.Status.VariantionCut := vcDepth;
					GameLastMove.Analysis.Status.Score := StrToValI(ReadToChar(sx, InLineIndex, ','), False, -scMax, 0, scMax, 1);
					if CPos.Side = 0 then
						GameLastMove.Analysis.Status.Score := -GameLastMove.Analysis.Status.Score;
					GameLastMove.Analysis.Depth := StrToValI(ReadToChar(sx, InLineIndex, ','), False, -scMax, 0, scMax, 1);

					Delete(s, i - Length(sx) - 6 - 1, Length(sx) + 6 + 1);
				end;
				CharsTable := LastCharsTable;

				if GameLastMove <> nil then
				begin
					if GameLastMove.CommentAfter <> '' then
						GameLastMove.CommentAfter := GameLastMove.CommentAfter + FullSep;
					GameLastMove.CommentAfter := GameLastMove.CommentAfter + s;
				end
				else
				begin
					if Game.StartCommnent <> '' then
						Game.StartCommnent := Game.StartCommnent + FullSep;
					Game.StartCommnent := Game.StartCommnent + s;
				end;

				Parser.ReadInput; // }
				Parser.ReadInput;

(*
				while True do
				begin
					case Parser.InputType of
					itEOI: Break;
					itRBracket3:
					begin
						Parser.ReadInput;
						Break;
					end;
					itLBracket2:
					begin
						Parser.ReadInput;
						if Parser.InputType = itPercent then
						begin
							Parser.ReadInput;
							if Parser.InputType = itIdent then
							begin
								if Parser.Id = 'emt' then
								begin
									if GameLastMove <> nil then
									begin
										GameLastMove.MovTime := Parser.ReadMs(0, 0, MaxInt);
									end;
								end;
							end;


						end;
					end;
					end;
					Parser.ReadInput;*)
			end;
			itSpaceTab:
			begin
				Parser.ReadInput;
			end;
			itExclamation:
				goto LMove;
			else
			begin
				Parser.AddMes2(mtUserError, ['Move required but ''' + Parser.Id + ''' found']);
				Parser.ReadInput;
			end;
			end;
		end;

		Dec(MovesDepth);
	end;

	procedure CloseGame;
	begin
		Terminated := False;
{   if Games <> nil then
			Games.Update;}
{   if Games.Count = 0 then Exit;
		if G <> Games.GetLast then
			G := Games.GetLast;
		if G <> nil then}
		begin
//      G := Game.Games.GetLast;
///     Move(Game, G^, SizeOf(TGame));
//      G^ := Game;
//    FillChar(Game, SizeOf(Game), 0);
//      G := nil;
		end;
	end;

var
	i: SG;
	IdName, IdValue: string;
	FoundMoves: BG;
	From, ToV: SG;
	Tag: TPGNTag;
//  IdSG: SG;

//  HPos: TPos;
begin
//  Result := False;
//  CopyPos(CPos, HPos);

(*  if Games.Count <> 0 then
	begin
		G := Games.GetFirst;
		for i := 0 to Games.Count - 1 do
		begin
			FreeMoves(G.FirstMove);
			Inc(SG(G), Games.ItemMemSize);
		end;
//    FreeAndNil(Games);
	end;*)
	// New Game
	FoundMoves := True;

	// Setup Lexical Analyser
	ClearErrors;
	Parser := TDParser.Create(FileData);
	StdCharTable;
	CharsTable['@'] := ctLetter;
	CharsTable['-'] := ctLetter;
	CharsTable['/'] := ctLetter;
	CharsTable['='] := ctLetter;
	CharsTable['+'] := ctLetter;
	CharsTable['#'] := ctLetter;
	CharsTable['$'] := ctDollar;
	CharsTable['0'] := ctLetter;
	CharsTable['1'] := ctLetter;
	CharsTable['2'] := ctLetter;
	CharsTable['3'] := ctLetter;
	CharsTable['4'] := ctLetter;
	CharsTable['5'] := ctLetter;
	CharsTable['6'] := ctLetter;
	CharsTable['7'] := ctLetter;
	CharsTable['8'] := ctLetter;
	CharsTable['9'] := ctLetter;
	CharsTable['.'] := ctLetter;

	Parser.FloatNumber := False;
	Parser.EnableString := True;
	Parser.StringSep := '"';
	Parser.ReadInput;
	while True do // Read Games
	begin
		case Parser.InputType of
		itEOI:
		begin
			CloseGame;
			Break;
		end;
		itLBracket2:
		begin
			Parser.ReadInput;
			if FoundMoves then
			begin
				CloseGame;

				// Begin New Game
				NewSubGame(UnspecGameType, GameVariants[UnspecGameType, 0]);
				FoundMoves := False;
			end;
			IdName := Parser.Id;
			Parser.ReadToChar(']');
			IdValue := DelQuoteF(DelBESpaceF(Parser.Id));
			if FindS(PGNTagNamesU, UpperCase(IdName), From, ToV) = False then
			begin
				Parser.AddMes2(mtUserWarning, ['Tag ''' + IdName + ''' not supported']);
{       Parser.EnableString := True;
				Parser.StringSep := '"';}
//        Parser.ReadInput;
//        Parser.ReadInput;
			end
			else
			begin
				Tag := TPGNTag(IToPGNTag[TPGNTag(From)]);
				if Game.PGNTags[Tag] <> '' then
				begin
					Parser.AddMes2(mtUserWarning, ['Tag ''' + IdName + ''' redeclared']);
					Game.PGNTags[Tag] := Game.PGNTags[Tag] + IdValue;
				end
				else
					Game.PGNTags[Tag] := IdValue;

				// Apply Tag to Game
				case Tag of
(*        ptSquareX, ptSquareY, ptShuffle, ptSuicide, ptMustCapture, ptPromote, ptReuseCaptured,
				ptLongestCapture, ptBackwardCapture, ptFlyingKing, ptFallDown, ptLineSize:
				begin
{         Parser.EnableString := False;
					Parser.ReadInput; // Quote
					IdSG := Parser.ReadSG(0, 0, MaxInt);
					IdValue := Parser.Id;}
					IdSG := StrToValI(IdValue, False, 0, 0, MaxInt, 1);
					case Tag of
					ptSquareX: Game.Opt.X := Range(MinimumXY, IdSG, BoardX - 1);
					ptSquareY: Game.Opt.Y := Range(MinimumXY, IdSG, BoardX - 2);
					ptShuffle: Game.Opt.Shuffle := Range(0, UG(IdSG), High(Game.Opt.Shuffle));
					ptSuicide: Game.Opt.Suicide := BG(Range(0, IdSG, 1));
					ptMustCapture: Game.Opt.MustCapture := BG(Range(0, IdSG, 1));
					ptPromote: Game.Opt.Promote := BG(Range(0, IdSG, 1));
					ptReuseCaptured: Game.Opt.ReuseCaptured := BG(Range(0, IdSG, 1));
					ptLongestCapture: Game.Opt.LongestCapture := BG(Range(0, IdSG, 1));
					ptBackwardCapture: Game.Opt.BackwardCapture := BG(Range(0, IdSG, 1));
					ptFlyingKing: Game.Opt.FlyingKing := BG(Range(0, IdSG, 1));
					ptFallDown: Game.Opt.Fall := BG(Range(0, IdSG, 1));
					ptLineSize: Game.Opt.LineSize := Range(0, IdSG, SG(Game.Opt.Y));
					end;
{         Parser.ReadInput;
					if Parser.InputType <> itQuote then
						Parser.AddMes2(mtExpected, ['"', ''])
					else
						Parser.ReadInput;}
				end;
				*)

				ptGameType, ptVariant:
				begin
					IdValue := Lowercase(IdValue);
					if Length(IdValue) > 0 then
						if Tag = ptGameType then
						begin
							StrToGameType(IdValue);
						end
						else
						begin
							StrToVariant(IdValue);
						end;
				end;
				ptSetUp:
				begin
					// SetUp is dependent on FEN tag
				end;
				ptFEN:
				begin
					FillStartPos;
					InLineIndex := 1;
					s := FENStrToGame(IdValue, InLineIndex);
					if s <> '' then
						Parser.AddMes2(mtUserError, [s]);
				end;
				ptResult:
				begin
					for i := 0 to Length(GameTerminationStr) - 1 do
						if Game.PGNTags[ptResult] = GameTerminationStr[TGameTermination(i)] then
						begin
							Game.GameTermination := TGameTermination(i);
							Break;
						end;
				end;
				ptTimeControl:
				begin
					Game.SeparatedLevel := PlayerMax + 1;
					StrToLevel(Game.PGNTags[ptTimeControl], @Game.Levels[PlayerMax + 1]);
				end;
				ptWhiteTimeControl, ptBlackTimeControl:
				begin
					Game.SeparatedLevel := SG(Tag) - SG(ptWhiteTimeControl);
					StrToLevel(Game.PGNTags[Tag], @Game.Levels[Game.SeparatedLevel]);
				end;
				ptWhiteType, ptBlackType:
				begin
					IdValue := Lowercase(IdValue);
					for i := 0 to Length(PlayerTypeStr) - 1 do
						if IdValue = PlayerTypeStr[i] then
						begin
							Game.PlayerTypes[SG(Tag) - SG(ptWhiteType)] := i;
							Break;
						end;
				end;
				end;
			end;
			Parser.ReadInput; // "

{     ReadInput;
			if InputType <> itQuote then
				AddMes2(mtExpected, ['"', ''])
			else
				ReadInput;}
			if Parser.InputType <> itRBracket2 then
				Parser.AddMes2(mtExpected, [']', ''])
			else
				Parser.ReadInput;
			Parser.StringSep := '"';
		end;
		else //itIdent, itInteger:
		begin
			if Terminated then
			begin
				if Parser.Id <> '' then
					Parser.AddMes2(mtExpected, ['[', Parser.Id]);
				Parser.ReadInput;
			end
			else
			begin
				FoundMoves := True;
//        Parser.EnableMarks := True;

				FillStartPos;
				CopyPos(Game.Variant.Pos, Game.Pos);

//        Parser.EnableMarks := False;
				Terminated := False;
				MovesDepth := 0;
				FCMove := PMove(@CMove);
				CopyPos(Game.Variant.Pos, CPos);

				ReadLevelMoves;
				while Parser.InputType <> itEOI do
				begin
					if Parser.Id = '[' then Break;
					Parser.ReadInput;
				end;
//        Parser.EnableMarks := True;
				if Parser.Id = '[' then Continue;
			end;

{
while InLineIndex < Length(FileData) do
			begin
				if FileData[InLineIndex] = '[' then
				begin
					Dec(InLineIndex);
					Break;
				end;
				s := UpperCase(DelBESpaceF(ReadToChar(s, InLineIndex, ' ')));
				if s <> '' then
				begin
				end;
			end;}
		end;
{   else
			FoundMoves := True;
			AddMes2(mtExpected, ['Move', '']);
			ReadInput;}
		end;
	end;
	FileData := '';
	Parser.Free;
	ShowAndClearErrors;
	ClearErrors;
	StdCharTable;

	// Select a game from pgn games
	if Games <> nil then
	begin
		if Games.Count = 0 then
			Result := False
		else
		begin
			Games.Update;
			Games.Index := Games.Count - 1;
			Result := True;
		end;
	end
	else
		Result := False;

//  CopyPos(HPos, CPos);
end;

function PosToString(Pos: PPos; Game: PGame; EPD: BG = False): string;
// Sample chess output: rnbqkbnr/pppp1ppp/4p3/8/4P3/8/PPPP1PPP/RNBQKBNR w KQkq - 0 2
// Sample draughts output: W:WK4,30:B27,22.
var
	FreeS: UG;
	Index: SG;
	x, y, i, Side: SG;
	Found: BG;
begin
	Result := '';
	if GameType <> gtDraughts then
	begin
		FreeS := 0;
		for y := SqY downto 0 do
		begin
			for x := 0 to SqX do
			begin
				Index := XYToI(x, y);
				if Index = 0 then Continue;
				if GameType = gtDraughts then
					if Pos.Board[Index] = sqOut then Continue;

				if Pos.Board[Index] = sqEmpty then
					Inc(FreeS)
				else
				begin
					if FreeS > 0 then
					begin
						Result := Result + IntToStr(FreeS);
						FreeS := 0;
					end;
					Result := Result + PieceToS(TSquare(Pos.Board[Index]), False);
				end;
			end;
			if FreeS > 0 then
			begin
				Result := Result + IntToStr(FreeS);
				FreeS := 0;
			end;
			if y <> 0 then
				Result := Result + '/';
		end;
		Result := Result + ' ' + SideToC[GameType, Pos.Side];
	end
	else
	begin
		Result := Result + Upcase(SideToC[GameType, Pos.Side]);
		for Side := 0 to PlayerMax do
		begin
			Result := Result + ':' + UpCase(SideToC[GameType, Side]);
			for i := 0 to UsedSquareCount - 1 do
			begin
				Index := UsedSquares[i];
				if Pos.Board[Index] <> sqEmpty then
				begin
					if Side = (Pos.Board[Index] and $80) shr 7 then
						Result := Result + PieceToS(Abs(Pos.Board[Index]), True) + SquareToS(Index, False, ntDraughts) + ',';
				end;
			end;
			Result := DeleteLastChar(Result);
		end;
	end;
	case GameType of
	gtCastleAndEP:
	begin
		// Castling
		Found := False;
		Result := Result + ' ';
		if Pos.Castles[0, caK] then
		begin
			Result := Result + 'K';
			Found := True;
		end;
		if Pos.Castles[0, caQ] then
		begin
			Result := Result + 'Q';
			Found := True;
		end;
		if Pos.Castles[1, caK] then
		begin
			Result := Result + 'k';
			Found := True;
		end;
		if Pos.Castles[1, caQ] then
		begin
			Result := Result + 'q';
			Found := True;
		end;
		if Found = False then
			Result := Result + '-';

		 // EP
		if Pos.EP <> 0 then
			Result := Result + ' ' + SquareToS(Pos.EP, False, GetNotation(ntDefault))
		else
			Result := Result + ' -';
	end;
	end;
	Result := Result + ' ' + IntToStr(Pos.LongDraw);
	Result := Result + ' ' + IntToStr(Pos.MoveIndex div (PlayerMax + 1) + 1);

	if (Game <> nil) and (Game.Variant.Options[voRCP].Bool) then
	begin
		for x := -PieceTypes to PieceTypes do
			if Game.Variant.Pos.CapturedPieces[x] > 0 then
			begin
				for i := 1 to PieceTypes do
				begin
					Result := Result + NToS(Game.Variant.Pos.CapturedPieces[TPiece(i)], False) + ';';
				end;
				for i := -1 downto - PieceTypes do
				begin
					Result := Result + NToS(Game.Variant.Pos.CapturedPieces[TPiece(i)], False) + ';';
				end;
				SetLength(Result, Length(Result) - 1);
				Break;
			end;
	end;

	if EPD then
	begin
		if NotEmpty(Game.PGNTags[ptEvent]) then
			Result := Result + ' id "' + Game.PGNTags[ptEvent] + '";';
		if NotEmpty(Game.PGNTags[ptECO]) then
			Result := Result + ' eco "' + Game.PGNTags[ptECO] + '";';
		if NotEmpty(Game.PGNTags[ptNIC]) then
			Result := Result + ' nic "' + Game.PGNTags[ptECO] + '";';
		if NotEmpty(Game.PGNTags[ptComment]) then
			Result := Result + ' c0 "' + Game.PGNTags[ptECO] + '";';
		// D??? ToDo
	end;
end;

function GameToString(Game: PGame; HTML: BG): string;
const
	SaveTime = True;
var
	TextX: SG;
	MoveIndex: SG;
	sm, sc: string;

	function AddComment(const sc: string): string;
	begin
		if sc <> '' then
		begin
			if HTML then
				Result := '<i>' + sc + '</i> '
			else
				Result := '{' + sc + '} ';
		end;
	end;

	procedure SaveMove(Mv: PGameMoves);
	var
		i, j: SG;
		sx: string;
		M: PGameMove;
		HPos: TPos;
	begin
		if (Mv = nil) or (Mv.Count = 0) then Exit;

		Inc(MoveIndex);

		i := 0;
		for j := -1 to Mv.Count - 1 do
		begin
			if j = -1 then
				i := Mv.Main
			else if j <> Mv.Main then
				i := j
			else
			begin
				Continue;
			end;

			if j >= 0 then sm := '(' else sm := '';
			if ((Game.Variant.Pos.MoveIndex + MoveIndex) mod (PlayerMax + 1) = 0) or (j >= 0) or (MoveIndex = 0) then
			begin
				sm := sm + IntToStr((MoveIndex + Game.Variant.Pos.MoveIndex) div 2 + 1) + '.';
				if ((Game.Variant.Pos.MoveIndex + MoveIndex) mod (PlayerMax + 1) <> 0) then
					sm := sm + '..';
				sm := sm + ' ';
			end
			else
				sm := sm + '';

			GenerateMoves;
			M := @Mv.Moves[i];
			{$ifopt d+}
			if M.Index > CMC then
			begin
				IE('GameToString');
				PCMove := nil;
			end
			else
			{$endif}
			begin
				PCMove := PMove(SG(FCMove) + M.Index shl ShlTMove);
			end;

			CopyPos(CPos, HPos);
			DoMove;
			FillPlus(PCMove, True);

			sx := MoveToStr(PCMove, False, False);

			if HTML then
			begin
				// Translate to Czech Pieces
				Replace(sx, 'N', 'J');
				Replace(sx, 'B', 'S');
				Replace(sx, 'R', 'V');
				Replace(sx, 'Q', 'D');
			end;
			sm := sm + sx;

			sm := sm + ' ' + MarkToStr(M, 1 + U1(HTML));

			sc := '';
			if M.CommentBefore <> '' then
				sc := sc + M.CommentBefore;
			if (HTML = False) and SaveTime and (M.MovTime > 0) then
				sc := sc + '[' + EMTStr + ' ' + MsToStr(M.MovTime, False, diHMSD, -3, False) + ']';
{       if (HTML = False) and (Mv.Actual = i) then
				sc := sc + ' ' + ActualMoveStr;}
			if M.Analysis.Status.VariantionCut <> vcNone then
			begin
				sc := sc + '[' + EVALStr + ' ' + ScoreToStr(M.Analysis.Status.Score, CPos.Side xor 1, sfPGN, M.Analysis.Status.ScoreBound) + ',' +
					IntToStr(M.Analysis.Depth) + ']';
			end;
			if M.CommentAfter <> '' then
				sc := sc + M.CommentAfter;
			sm := sm + AddComment(sc);

			Inc(TextX, Length(sm));
			if TextX > 80 then
			begin
				Result := Result + FileSep;
				TextX := Length(sm);
			end;
			Result := Result + sm;

			if j >= 0 then
			begin
				SaveMove(M.Moves);
				CopyPos(HPos, CPos);
				if Result[Length(Result)] = ' ' then
					SetLength(Result, Length(Result) - 1);
				Result := Result + ') ';
			end
			else
				CopyPos(HPos, CPos);
		end;
		GenerateMoves;
		M := @Mv.Moves[Mv.Main];
		PCMove := PMove(SG(FCMove) + M.Index shl ShlTMove);
		CopyPos(CPos, HPos);
		DoMove;
		SaveMove(M.Moves);
		CopyPos(HPos, CPos);
		Dec(MoveIndex);
	end;

var
	i: SG;
	HPos: TPos;
	s: string;
begin
	Result := '';
	if HTML = False then
	begin
		for i := 0 to Length(PGNTagNames) - 1 do
		begin
			s := Game.PGNTags[TPGNTag(i)];
			if i <= 6 then
			begin
				if s = '' then s := '?'; // STR
			end
			else
				if s = '?' then s := ''; // TimeControl
			if s <> '' then
				Result := Result + '[' + PGNTagNames[TPGNTag(i)] + ' "' + s + '"]' + FileSep;
		end;
		Result := Result + FileSep;
	end;

	Result := Result + AddComment(Game.StartCommnent);

	CopyPos(CPos, HPos);
	CopyPos(Game.Variant.Pos, CPos);

	TextX := 0;
	MoveIndex := -1;
	SaveMove(Game.FirstMove);
	CopyPos(HPos, CPos);
	if HTML then
	begin
		Result := Result + '<b>';
		Result := Result + GameTerminationHTML[Game.GameTermination] + FileSep + FileSep;
		Result := Result + '</b>';
	end
	else
		Result := Result + ' '{Program signature} + GameTerminationStr[Game.GameTermination] + FileSep + FileSep;
end;

function EPDStrToGame(Line: string; var InLineIndex: SG): string;
label LExit;
var
	IdName, IdValue: string;
	From, ToV: SG;
	Tag: TEPDTag;
begin
	while InLineIndex <= Length(Line) do
	begin
		if Line[InLineIndex] = ' ' then
		begin
			Inc(InLineIndex);
			Continue;
		end;
		IdName := ReadToChar(Line, InLineIndex, ' ');
		IdValue := ReadToChar(Line, InLineIndex, ';');
		DelQuote(IdValue);

		if FindS(EPDTagNames, LowerCase(IdName), From, ToV) = False then
		begin
//      Parser.AddMes2(mtUserWarning, ['Tag ''' + IdName + ''' not supported']);
		end
		else
		begin
			Tag := TEPDTag(From);
{     if Game.PGNTags[Tag] <> '' then
			begin
				Parser.AddMes2(mtUserWarning, ['Tag ''' + IdName + ''' redeclared']);
				Game.PGNTags[Tag] := Game.PGNTags[Tag] + IdValue;
			end
			else
				Game.PGNTags[Tag] := IdValue;}

			// Apply Tag to Game
			case Tag of
			etECO: Game.PGNTags[ptECO] := IdValue;
			etNIC: Game.PGNTags[ptNIC] := IdValue;
			etC0: Game.PGNTags[ptComment] := IdValue;
			etID: Game.PGNTags[ptEvent] := IdValue;
			// D??? ToDo
			end;
		end;
	end;
end;

function LoadFromFile(const Kind: SG): BG;
label LRetry;
const
	MaxMoveL = 14;
type
	TFileMove = packed record // 32
		Lng: U1; // +0
		ToXY: array[0..MaxMoveL] of U1; // 15 +1
		What: array[0..MaxMoveL - 1] of U1; // 14 +16
		Promote: U1; // 1 +30 (0,1,2)
		Prior: U1; // +0
	end;
	PFileGameMove = ^TFileGameMove;
	TFileGameMove = packed record // 64
		Mov: TFileMove; // 32
		Tim: U4; // 4
		Mar: U1; // 1
		Reserved: array[0..26] of U1; // 27
	end;
	TFileGameHead = packed record // 256
		Head: array[0..63] of Char; //64
		Board: array[0..31] of TSquare; //32
		OffSet: U2;  //2
		ActMove: U2; //2
		MaxMove: U2; //2
		TotTime: array[-2..-1] of U4; //8
		Give: BG; //1
		RotReserve: S1; //1
		Date0, Date1: S4; // 8
		Name0, Name1, Name2: string[19]; // 60
		Reserved: array[0..75] of U1; // 76
	end;
var
	F: TFile;
	FileName: TFileName;

	// Binary
	GameHead: TFileGameHead;
	L: UG;
	M, Mem: PFileGameMove;
	MCount: SG;
	s, Line: string;
	i, InLineIndex: SG;
	B: BG;
	LTim: array[0..1] of U4;
	ErrorS: string;
	Res, Rem: U1;
	UnspecGameType: TGameType;
begin
	Result := False;
	FileName := Kinds.Items[Kind].FileName;

	s := UpperCase(ExtractFileExt(FileName));
	if (s = '.DGM') or (s = '.DAT') then
	begin // Compatibility only
		F := TFile.Create;
		LRetry:
		if F.Open(FileName, fmReadOnly, FILE_FLAG_SEQUENTIAL_SCAN, False) then
		begin
			if F.FileSize < 256 then
			begin
				MessageD(FileName + LineSep + 'Is too short', mtError, [mbOk]);
				Exit;
			end;
			F.Seek(0);
			if not F.BlockRead(GameHead, SizeOf(GameHead)) then goto LRetry;
			FillChar(GameHead.Reserved, SizeOf(GameHead.Reserved), 0);

			if (Copy(GameHead.Head, 1, 22) <> 'D-Checkers Version 2.0') and
				(Copy(GameHead.Head, 1, 32) <> 'D-Checkers Version 1.1 Game     ') then
			begin
				MessageD(FileName + LineSep + 'Is not game file', mtError, [mbOK]);
			end
			else
			begin
				NewSubGame(gtDraughts, GameVariants[gtDraughts, 1{English}]);
				// Implicit options
				Game.GameType := gtDraughts;
				Game.Variant := GameVariants[gtDraughts, 1{English}];

				Game.PGNTags[ptEvent] := GameHead.Name0;
				Game.PGNTags[ptWhite] := GameHead.Name1;
				Game.PGNTags[ptBlack] := GameHead.Name2;
				try
				FillGameDateTime(FileDateToDateTime(GameHead.Date0));
{       if GameHead.Date0 <> GameHead.Date1 then
					Game.PGNTags[ptDate] := Game.PGNTags[ptDate] + '-' + DTToStr(FileDateToDateTime(GameHead.Date1));}
{       if (GameHead.Date0 < 0) or (GameHead.Date0 > Now) then GameHead.Date0 := Now;
				if (GameHead.Date1 < 0) or (GameHead.Date1 > Now) then GameHead.Date1 := Now;}
				except
				end;

	//      if not (Game.Head.RotReserve in [0, 1]) and (Game.Head.Rot <> -1) then Game.Head.Rot := 1;
				Game.StartTotTime[0] := GameHead.TotTime[-2] * 10;
				Game.StartTotTime[1] := GameHead.TotTime[-1] * 10;

				FillStartPos;
//        CopyPos(StartPos, Game.StartPos);
				Game.CursorX := 0;
				Game.CursorY := 0;
				Game.CXY := StP;

				Game.Variant.Pos.MoveIndex := GameHead.OffSet;
				for i := 0 to UsedSquareCount - 1 do
				begin
					Game.Variant.Pos.Board[UsedSquares[UsedSquareCount - 1 - i]] := GameHead.Board[i];
				end;
				FillCapturedPieces(Game.Variant.Pos);
				FillHashIC(Game.Variant.Pos);

				FillChar(SquareStatus, SizeOf(SquareStatus), ssNone);

				CopyPos(Game.Variant.Pos, CPos);
				LTim[CPos.Side] := GameHead.TotTime[-2];
				LTim[CPos.Side xor 1] := GameHead.TotTime[-1];

				ErrorS := '';
				if GameHead.MaxMove > 0 then
				begin
					L := SizeOf(TFileGameMove) * GameHead.MaxMove;
					GetMem(Mem, L);
					if not F.BlockRead(Mem^, L) then goto LRetry;
					MCount := L div SizeOf(TFileGameMove);
					if MCount <> GameHead.MaxMove then
					begin
						if MCount > GameHead.MaxMove then
						begin
							MCount := GameHead.MaxMove;
							ErrorS := ErrorS + 'File too long' + LineSep;
						end
						else
							ErrorS := ErrorS + 'File truncated' + LineSep;
					end;
					M := Mem;
					while MCount > 0 do
					begin
						for i := 0 to Max(M.Mov.Lng, 0) do
						begin
							DivModU2(M.Mov.ToXY[i] - 11, 10, Res, Rem);
							M.Mov.ToXY[i] := XYToI(Rem, Res);
{             M.Mov.ToXY[i] := XYToI(
								(M.Mov.ToXY[i] - 11) mod 10,
								(M.Mov.ToXY[i] - 11) div 10);}
						end;
						GenerateMoves;
						ALng := 0;
						AMin := 0;
						AMax := CMC - 1;
						B := False;
						i := 0;
						while i <= M.Mov.Lng do
						begin
							B := B or PressSquare(CPos, M.Mov.ToXY[i], False);
							if B then Break; // Move to one click
							if M.Mov.Lng = 1 then
								Inc(i)
							else
								Inc(i, 2);
						end;

						if B then
						begin
							PCMove := PMove(SG(FCMove) + AMin shl ShlTMove);
							DoMove;
							if DoGameMove(AMin, False) = False then
							begin
								ErrorS := ErrorS + 'Can not do move ' + NToS(AMin) + LineSep;
								DoGameMove(NullMoveIndex, False);
							end;
						end
						else
						begin
							DoGameMove(NullMoveIndex, False);
							ErrorS := ErrorS + 'Can not make move' + LineSep;
						end;
						if (M.Tim = $2D2D2D2D) then
							GameLastMove.MovTime := 0
						else if (M.Tim > MaxInt div 10) or (M.Tim < LTim[CPos.Side]) then
						begin
							ErrorS := ErrorS + 'Invalid move time' + LineSep;
						end
						else
						begin
							GameLastMove.MovTime := 10 * (M.Tim - LTim[CPos.Side]);
							LTim[CPos.Side] := M.Tim;
						end;
						case SG(M.Mar) of
						0, 45: GameLastMove.Mark[0] := mmNone;
						1: GameLastMove.Mark[0] := mmPoorMove;
						2: GameLastMove.Mark[0] := mmGoodMove;
						else
						begin
							GameLastMove.Mark[0] := mmNone;
							ErrorS := ErrorS + 'Invalid mark' + LineSep;
						end;
						end;
						Dec(MCount);
						Inc(M);
					end;
					Game.GameTermination := gtNone;
					FreeMem(Mem);
				end;
				if ErrorS <> '' then
					MessageD(ErrorS, mtError, [mbOk]);

				Game.Pos.MoveIndex := High(Game.Pos.MoveIndex);
				GoToMove(GameHead.ActMove + Game.Variant.Pos.MoveIndex);

				Result := True;
			end;
			if not F.Close then goto LRetry;
		end;
		F.Free;
	end
	else if (s = '.EPD') or (s = '.FEN') then
	begin
		if ReadStringFromFile(FileName, s) = False then Exit;
		i := 1;
		while i < Length(s) do
		begin
			Line := ReadToNewLine(s, i);
			if Line = '' then Break;
			NewSubGame(gtChess, GameVariants[gtChess, 0]);
			Result := True;
			InLineIndex := 1;
			FENStrToGame(Line, InLineIndex);
			Game.PGNTags[ptSetUp] := '1';
			Game.PGNTags[ptFEN] := Copy(Line, 1, InLineIndex - 1);
			EPDStrToGame(Line, InLineIndex);
		end;
	end
	else if (s = '.PGN') or (s = '.PDN') then
	begin
		if (s = '.PDN') then
			UnspecGameType := gtDraughts
		else
			UnspecGameType := gtChess;
		if ReadStringFromFile(FileName, s) = False then Exit;
		Result := StringToGame(s, UnspecGameType);
	end
	else
	begin
		MessageD('Unknown Game Type', mtError, [mbOk]);
	end;
end;

function GamesToString(SavePos: SG = 0): string;
var
	G: PGame;
	i: SG;
begin
	Result := '';
{   if Games.Count = 0 then
	begin
		if SavePos > 0 then
			s := s + PosToString(Game.StartPos, SavePos = 2) + FileSep
		else
			s := s + GameToString(@Game, False);
	end
	else
	begin}
		Games.Update;
		G := Games.GetFirst;
		for i := 0 to Games.Count - 1 do
		begin
			if SavePos = 2 then
				Result := Result + PosToString(@G.Variant.Pos, G, True) + FileSep
			else if SavePos = 1 then
				Result := Result + PosToString(@G.Variant.Pos, G) + FileSep
			else
				Result := Result + GameToString(G, False);
			Inc(SG(G), Games.ItemMemSize);
		end;
//    end;
end;

function SaveToFile(var FileName: TFileName): BG;
var
	Append: BG;
	s: string;
	SavePos: SG;
begin
	Result := False;
	s := UpperCase(ExtractFileExt(FileName));
	if (s = '.DAT') then
	begin
		MessageD('Save format not supported', mtError, [mbOk]);
	end
	else if (s = '.PGN') or (s = '.PDN') or (s = '.EPD') or (s = '.FEN') then
	begin
		if (s = '.FEN') then
			SavePos := 1
		else if (s = '.EPD') then
			SavePos := 2
		else
			SavePos := 0;

		if SavePos <> 0 then
		begin
			if MessageD('Because of the limitation of specified format, the saved file will be limited' + LineSep + 'Would you like to save file anyway?', mtWarning, [mbYes, mbNo]) <> mbYes then
				Exit;
		end;
		s := GamesToString(SavePos);

		Append := FileExists(FileName);
		if Append and (SaveBeforeNewGame = False) then
			case MessageDEx('File' + LineSep + FileName + LineSep + 'exists', mtConfirmation, ['Append', 'Overwrite', 'Cancel'], 0, nil) of
			0: Append := True;
			1: Append := False;
			else Exit;
			end;

		Result := WriteStringToFile(FileName, s, Append);
{   if Append then
			Kinds.Revert D??? }
	end
	else
	begin
		MessageD('Unknown Game Type', mtError, [mbOk]);
	end;
end;

(*-------------------------------------------------------------------------*)
procedure ChangeXY(X, Y: SG);
begin
	if X < 0 then
		X := SqX
	else if X > SG(SqX) then
		X := 0;

	if Y < 0 then
		Y := SqY
	else if Y > SG(SqY) then
		Y := 0;

	if (Game.CursorX <> X) or (Game.CursorY <> Y) then
	begin
		Game.CXY := XYToI(X, Y);
		Game.CursorX := X;
		Game.CursorY := Y;
		if ActiveSquare then
		begin
			DrawBoard(1);
		end;
	end;
end;

procedure OffsetXY(X, Y: SG);
begin
	Rotate(X, Y, 0, 0, -Rotated);
	ChangeXY(Game.CursorX + X, Game.CursorY + Y);
end;

(*-------------------------------------------------------------------------*)

// TfMain

(*-------------------------------------------------------------------------*)
procedure TfMain.RWOptions(const Save: BG);
var
	i: SG;
	Section: string;
begin
	AboutRW(Save);
	Kinds.RWOptions(Save);
	MainIni.RWFormPos(Self, Save);

	Section := 'File';
	MainIni.RWNum(Section, 'PriorityProcess', PriorityProcess, Save);
	MainIni.RWNum(Section, 'PriorityMainThread', PriorityMainThread, Save);
	MainIni.RWNum(Section, 'PriorityEngineThread', PriorityEngineThread, Save);

	Section := 'Game';
	MainIni.RWBoolM(Section, AutomaticNewGame1, AutomaticNewGame, Save);
	MainIni.RWBoolM(Section, BeforeNewGame1, SaveBeforeNewGame, Save);

	Section := 'Moves';
	MainIni.RWNumM(Section, Notation1, U1(Notation), Save, True);
	MainIni.RWBoolM(Section, Short1, ShortNot, Save);
	MainIni.RWBoolM(Section, Figurine1, Figurine, Save);
	MainIni.RWBoolM(Section, WideVariants1, WideVariants, Save);
	MainIni.RWBoolM(Section, EvaluationProfile1, EvaluationProfile, Save);
	MainIni.RWBoolM(Section, TimeMove1, TimePerMove, Save);
	MainIni.RWNum(Section, 'ReplayTime', ReplayTime, Save);


	Section := 'Analysis';
	if Save = False then AnalysisFile := WorkDir + 'Analysis\Analysis.dat';
	AnalysisFile := FullDir(MainIni.RWStringF(Section, 'AnalysisFile', ShortDir(AnalysisFile), AnalysisFile, Save));
	MainIni.RWBoolM(Section, EnableAnalysisAutosave1, EnableAnalysisAutosave, Save);
	MainIni.RWNum(Section, 'SaveAnalysisTime', SaveAnalysisTime, Save);
	MainIni.RWBoolM(Section, NodesTime1, NodesTime, Save);
	MainIni.RWBoolM(Section, ScoreForFirstPlayer1, ScoreForFirstPlayer, Save);

	Section := 'Clock';
	MainIni.RWBoolM(Section, AutoFlag1, AutoFlag, Save);
	MainIni.RWBoolM(Section, RemainTime1, RemainTime, Save);
	MainIni.RWBoolM(Section, Analog1, Analog, Save);
	MainIni.RWNumM(Section, Precision1, Precision, Save, True);
	MainIni.RWBoolM(Section, TimeStrategy1, TimeStrategy, Save);

	Section := 'Board';
	MainIni.RWNum(Section, 'Rotated', Rotated, Save);
	MainIni.RWBoolM(Section, CapturedPieces1, CapturedPieces, Save);
	MainIni.RWBoolM(Section, SideToMove1, SideToMove, Save);
	MainIni.RWNumM(Section, Coordinates1, U1(Coordinates), Save, True);
	MainIni.RWNumM(Section, SquareHighlight1, U1(SquareHighlight), Save, True);
	MainIni.RWBoolM(Section, ActiveSquare1, ActiveSquare, Save);
	MainIni.RWNumM(Section, MouseCursor1, S2(MouseCursor), Save, True);

	for i := 0 to PlayerMax do
	begin
		if Save = False then Visi[i] := 16;
		MainIni.RWNum(Section, 'Visibled' + NToS(i, False), Visi[i], Save);
	end;
	MainIni.RWFileName(Section, 'SavedFileName', SavedFileName, Save);
	MainIni.RWNum(Section, 'SavedWidth', SavedWidth, Save);
	MainIni.RWNum(Section, 'SavedHeight', SavedHeight, Save);
	MainIni.RWBoolM(Section, OneClickMove1, OneClickMove, Save);
	MainIni.RWBoolM(Section, SlidePieces1, SlidePieces, Save);
	MainIni.RWNum(Section, 'SlideTime', SlideTime, Save);

{ if Save then
	begin
		RWLevels(LevelsIni, Save);
		RWEngine(EngineIni, Save);
	end; D??? }
	
	// GUI
	Section := 'Engine';
	MainIni.RWBoolM(Section, HashTable1, EnableHashTable, Save);
	if Save = False then WantHashPos := DefHashPos;
	MainIni.RWNum(Section, 'HashPositions', WantHashPos, Save);

	MainIni.RWBoolM(Section, ProgramOfferDraw1, PrgOfferDraw, Save);
	MainIni.RWBoolM(Section, ProgramResign1, PrgResign, Save);
	MainIni.RWNum(Section, 'ResignScore', ResignScore, Save);

	MainIni.RWBoolM(Section, GameECO1, ShowGameECO, Save);
	MainIni.RWBoolM(Section, ECO1, ShowECO, Save);

	Section := 'View';
	MainIni.RWBoolM(Section, Logo1, Save);

	MainIni.RWMenuItem(Section, Analysis2, Save);
	MainIni.RWMenuItem(Section, AnalysisBoard2, Save);
	MainIni.RWMenuItem(Section, Board2, Save);
	MainIni.RWMenuItem(Section, Clock2, Save);
	MainIni.RWMenuItem(Section, Comment2, Save);
	MainIni.RWMenuItem(Section, Information2, Save);
	MainIni.RWMenuItem(Section, Levels2, Save);
	MainIni.RWMenuItem(Section, Moves2, Save);
	MainIni.RWMenuItem(Section, List2, Save);
	MainIni.RWMenuItem(Section, Design2, Save);
	MainIni.RWMenuItem(Section, PGN2, Save);
	MainIni.RWMenuItem(Section, PositionSetup2, Save);

	MainIni.RWMenuItem(Section, FreeWindows1, Save);

	MainIni.RWBoolM(Section, DelayScreen1, DelayScreen, Save);
	MainIni.RWNum(Section, 'DelayScreenTime', DelayScreenTime, Save);
	MainIni.RWBoolM(Section, DelaySound1, DelaySound, Save);
	MainIni.RWNum(Section, 'DelaySoundTime', DelaySoundTime, Save);

	RWPieceSet(Save);
end;

procedure TfMain.OnAdvancedMenuDraw(Sender: TObject; ACanvas: TCanvas;
	ARect: TRect; State: TOwnerDrawState);
begin
	MenuAdvancedDrawItem(Sender, ACanvas, ARect, State)
end;

procedure InitMenuTM;
var
	B: BG;
	i: SG;
begin
	if fMain = nil then Exit;
	fMain.SetMoveTime1.Enabled := (Kinds.Count > 0) and (GameLastMove <> nil);
	fMain.SpeedMark1.Enabled := Kinds.Count > 0;

	FormatCaption(fMain.GoToMove1, (Game.Pos.MoveIndex) div 2 + 1, False, False);
	fMain.GoToMove1.Enabled := Kinds.Count > 0;

	fMain.FindMove1.Enabled := fMain.GoToMove1.Enabled;
	fMain.ReplayMoves1.Enabled := fMain.GoToMove1.Enabled;

//  fMain.Levels2.Enabled := Kinds.Count > 0;
	fMain.DeleteMove1.Enabled := Kinds.Count > 0;
	fMain.PlayerTypes1.Enabled := Kinds.Count > 0;
	fMain.Suicide1.Enabled := Kinds.Count > 0;

	fMain.Mark1.Enabled := Kinds.Count > 0;
	fMain.InsertNullmove1.Enabled := Kinds.Count > 0;
	fMain.EnterMoves1.Enabled := Kinds.Count > 0;
	fMain.ExportGames1.Enabled := Kinds.Count > 0;
	fMain._ExportGame1.Enabled := Kinds.Count > 0;
	fMain._ExportPosition1.Enabled := Kinds.Count > 0;
	fMain.Print1.Enabled := Kinds.Count > 0;

	fMain.Exit1.Enabled := Where = whNone;

	fMain.OfferDraw1.Enabled := Kinds.Count > 0;
	fMain.Resign1.Enabled := Kinds.Count > 0;
	// Back
	B := GameLastMove <> nil;
	fMain.FirstMove1.Enabled := B;
	fMain.Back1.Enabled := B;
	fMain.BackA1.Enabled := B;
	fMain.DeletePreviousMoves1.Enabled := B;
	fMain.DeleteVariantion1.Enabled := B;

	// Forward
	B := GameNextMoves <> nil;
	fMain.LastMove1.Enabled := B;
	fMain.Forward1.Enabled := B;
	fMain.ForwardA1.Enabled := B;
	fMain.DeleteRemainingMoves1.Enabled := B;

	fMain.SetVariantionAsMain1.Enabled := (Kinds.Count > 0) and (Game.FirstMove <> nil);

	for i := 0 to Length(GameLastMove.Mark) - 1 do
	begin
		if GameLastMove <> nil then
		begin
			if GameLastMove.Mark[i] <> 0 then
				fMain.Mark1.Items[SG(GameLastMove.Mark[i])].Checked := True;
		end;
	end;

	fMain.StopAnalysis1.Enabled := Where <> whNone;
	case Where of
	whNone:
	begin
		fMain.NoMove1.Enabled := OMC > 0;
		fMain.NoMove1.Checked := False;
		fMain.Move1.Enabled := OMC > 0;
		fMain.Move1.Checked := False;
	end;
	whTN:
	begin
		fMain.NoMove1.Enabled := True;
		fMain.NoMove1.Checked := True;
		fMain.Move1.Enabled := True;
		fMain.Move1.Checked := False;
	end;
	whTD:
	begin
		fMain.NoMove1.Enabled := True;
		fMain.NoMove1.Checked := False;
		fMain.Move1.Enabled := True;
		fMain.Move1.Checked := True;
	end;
	end;

	fMain.GameAnalysis1.Enabled := fMain.NoMove1.Enabled;
	fMain.AnalyseNextNoMove1.Enabled := fMain.NoMove1.Enabled;//(Where = whNone){ and (ActMove>0)};
	fMain.AnalyseNextDoMove1.Enabled := (Where = whNone) and (Game.Pos.MoveIndex > 0);

	UpdateIcons(fMain.MainMenu, fMain.PanelTool);
end;

procedure TfMain.InitMenuTimeGo;
begin
	StopClock1.Enabled := (Kinds.Count > 0) and (TimeGo = tgGame);
	StopClock1.Checked := (TimeGo <> tgGame);
	PauseClock1.Enabled := TimeGo in [tgGame, tgPause];
	PauseClock1.Checked := TimeGo = tgPause;
	PlayClock1.Enabled := (Kinds.Count > 0) and (TimeGo <> tgGame);
	PlayClock1.Checked := (TimeGo = tgGame);
	RestartClock1.Enabled := StopClock1.Enabled;
	P0Clock1.Enabled := Kinds.Count > 0;
	P1Clock1.Enabled := Kinds.Count > 0;

	UpdateIcons(fMain.MainMenu, fMain.PanelTool);
end;

procedure TfMain.InitMenuPlayerTypes;
var i, j: SG;
begin
	j := 0;
	for i := 0 to PlayerMax do
		Inc(j, Game.PlayerTypes[i] * (1 shl (PlayerMax - i)));
	PlayerTypes1.Items[j].Checked := True;
end;

procedure TfMain.InitMenuAnalysis;
begin
	AnalysisPreviousLine1.Enabled := VisAnalysis > 0;
	AnalysisNextLine1.Enabled := VisAnalysis < AnalysisC - 1;

	Open2.Enabled := Kinds.Count > 0;
	Clear2.Enabled := AnalysisC > 0;
	Save2.Enabled := AnalysisC > 0;
	SaveAs2.Enabled := AnalysisC > 0;
end;

procedure TfMain.InitMenuEngine; // Engine + Book
var
	FormEngine: SG;
begin
	FormEngine := Game.SeparatedEngine;
	// Book
	BookUse1.Checked := Game.Params[FormEngine, eoOwnBook].Bool;
	FormatCaption(AcceptBookValue1, Game.Params[FormEngine, eoBookAccept].Num);

	// Engine
	Engine1.Items[Game.SeparatedEngine].Checked := True;

	FormatCaption(MultiPV1, Game.Params[FormEngine, eoMultiPV].Num);
	MultiPV1.Checked := Game.Params[FormEngine, eoMultiPV].Num > 1;
	RandomPlay1.Checked := Game.Params[FormEngine, eoRandomPlay].Bool;
	FormatCaption(RandomValue1, Game.Params[FormEngine, eoRandomValue].Num, False, True);

//  Ponder1.Checked := Game.Params[FormEngine, eoPonder].Bool;

	FormatCaption(Material1, Game.Params[FormEngine, eoMaterial].Num);
	FormatCaption(PieceActivity1, Game.Params[FormEngine, eoPieceActivity].Num);

	// Hash
	FreeHashTable1.Enabled := (EnableHashTable = False) and (AloHashPos > 0);
	RefreshHashTable1.Enabled := AloHashPos > 0;
	ClearHashTable1.Enabled := AloHashPos > 0;

	// Others
	FormatCaption(ResignValue1, ResignScore, False, False);
	FormatCaption(ContemptValue1, Game.Params[FormEngine, eoContemptValue].Num, False, False);
	FormatCaption(SlidePiecesTime1, SlideTime, True, True);
	FormatCaption(DelaySoundTime1, DelaySoundTime, True, True);
	FormatCaption(DelayScreenTime1, DelayScreenTime, True, True);
	UpdateIcons(fMain.MainMenu, fMain.PanelTool);
end;

procedure TfMain.InitMenuRotate;
begin
	Rotate1801.Checked := Rotated and 2 <> 0;
	Rotate901.Checked := Rotated and 1 <> 0;
end;

procedure KindsChange;
begin
	Kinds.Change;
	UpdateIcons(fMain.MainMenu, fMain.PanelTool);
end;

procedure TfMain.MoveMarkXClick(Sender: TObject);
var i: SG;
begin
	if GameLastMove <> nil then
	begin
		i := TMenuItem(Sender).Tag;
		SetMark(GameLastMove, TMoveMark(i));
		KindsChange;
		Mark1.Items[i].Checked := True;
		DrawMoves;
	end;
end;

procedure TfMain.LevelXClick(Sender: TObject);
var i: SG;
begin
	i := TMenuItem(Sender).Tag;
	CopyLevel(@TemplateLevels[i], @Game.Levels[Game.SeparatedLevel]);
	ChangeLevel;
end;

procedure TfMain.GameRuleXClick(Sender: TObject);
const
	Rules: array[TGameType] of string = (
		'',
		'angl-dama.htm',
		'sachy.htm',
		'',
		'sogi.htm',
		'jungle.htm',
		'connect4.htm',
		'othello.htm',
		'exploze.htm',
		''
		// Add Game
		);
begin
//  ExtOpenFile(WorkDir + 'Rules\' + GameNames[TGameType(TMenuItem(Sender).Tag)] + '.htm');
	ExtOpenFile('http://www.sweb.cz/klub-deskovych-her/pravidla/' + Rules[TGameType(TMenuItem(Sender).Tag)]);
end;

const
	FileExt: array[0..3] of string = ('pgn', 'pdn', 'fen', 'epd');
	FileDesc: array[0..3] of string = ('Portable Game Notation', 'Portable Draughts Notation', 'Fortysh-Edward Notation', 'Enhaced Position Description');

procedure ReadGameVars;
var
	s: string;
	i: SG;
	gt: array[TGameType] of SG;
	G: PGame;
begin
	s := ReadStringFromFile(DataDir + 'New.pgn') + ReadStringFromFile(DataDir + 'UserNew.pgn');
	StringToGame(s, gtChess);
	G := Games.GetFirst;
	FillChar(gt, SizeOf(gt), 0);
	for i := 0 to Games.Count - 1 do
	begin
		if gt[G.GameType] <= 15 then
		begin
			GameVariants[G.GameType][gt[G.GameType]].Name := G.PGNTags[ptEvent];
			GameVariants[G.GameType][gt[G.GameType]].Options := G.Variant.Options;
			GameVariants[G.GameType][gt[G.GameType]].Pos := G.Variant.Pos;
			Inc(gt[G.GameType]);
		end;
		Inc(SG(G), Games.ItemMemSize);
	end;
//  FreeGame(@Game);
	FreeFile(0);
end;

procedure TfMain.FormCreate(Sender: TObject);
const
	ScreenMinX = 1024;
	ScreenMinY = 3 * ScreenMinX div 4;
var
	i: SG;
	S: string;
	MenuItem: TMenuItem;
	g: TGameType;
begin
	Background := baStandard;
	{$ifopt d-}
	GenerateResultStats1.Enabled := False;
	ImageToFEN1.Enabled := False;
	{$endif}
	FreeWindows1.Enabled := False; // DNW

	for i := 0 to Length(FileExt) - 1 do
	begin
		AddFileType(
			FileExt[i],
			FileDesc[i],
			GraphDir + 'Icons\' + FileExt[i] + '.ico,0',
			[Application.Title],
			['"' + ExeFileName + '" "%1"']);
	end;

	for g := Succ(Low(GameType)) to High(GameType) do
	begin
		MenuItem := TMenuItem.Create(MainMenu);
		MenuItem.Name := 'GameRuleX' + IntToStr(SG(g));
		MenuItem.Tag := SG(g);
		MenuItem.Caption := GameNames[g];
{   MenuItem.RadioItem := True;
		MenuItem.GroupIndex := 15;}
		MenuItem.OnClick := GameRuleXClick;
		GameRules1.Add(MenuItem);
	end;
	for i := 0 to Length(MoveMarks2) - 1 do
	begin
		MenuItem := TMenuItem.Create(Mark1);
		MenuItem.Name := 'MarkX' + IntToStr(i);
		MenuItem.Tag := i;
		MenuItem.RadioItem := True;
		MenuItem.Caption := MoveMarks2[TMoveMark(i)];
		MenuItem.OnClick := MoveMarkXClick;
		Mark1.Add(MenuItem);
	end;
	for i := 0 to Length(NotationStr) - 1 do
	begin
		MenuItem := TMenuItem.Create(Notation1);
		MenuItem.Name := 'NotationX' + IntToStr(i);
		MenuItem.Tag := i;
		MenuItem.Caption := NotationStr[TNotation(i)];
		MenuItem.RadioItem := True;
		MenuItem.OnClick := NotationXClick;
		Notation1.Insert(i, MenuItem);
	end;
	for i := 0 to Length(TemplateLevels) - 1 do
	begin
		MenuItem := TMenuItem.Create(Template1);
		MenuItem.Name := 'LevelX' + IntToStr(i);
		MenuItem.Tag := i;
		MenuItem.RadioItem := True;
		MenuItem.Caption := TemplateNames[i] + ' (' + LevelToStr(@TemplateLevels[i], True) + ')';
		MenuItem.OnClick := LevelXClick;
		Template1.Add(MenuItem);
	end;
	OpenDialog1.Filter := DialogStr(FileExt, FileDesc);
	SaveDialog1.Filter := OpenDialog1.Filter;

	Kinds := TKinds.Create;
	Kinds.AdvancedMenuDrawItemEvent := OnAdvancedMenuDraw;
	Kinds.ItemAddr := @Game;
	Kinds.ItemSize := SizeOf(Game) + SizeOf(Games);
	Kinds.MultiFiles := True;

	Kinds.File1 := File1;
	Kinds.Window1 := Window1;
	Kinds.CreateMenuFile(True);

	Kinds.OpenDialog1 := OpenDialog1;
	Kinds.SaveDialog1 := SaveDialog1;

	Kinds.FreeFile := FreeFile;
	Kinds.NewFile := NewFile;
	Kinds.LoadFromFile := LoadFromFile;
	Kinds.SaveToFile := SaveToFile;
	Kinds.ChangeFile := ChangeFile;

	// Menu
	MenuSet(MainMenu, OnAdvancedMenuDraw);
	{$ifopt d-}
	IconsFromMenu(MainMenu, PanelTool);
	{$endif}

	InitMaxHashPos;
	ReadGameVars;

	MainIniCreate;
	EngineIni := TDIniFile.Create(WorkDir + 'Engine.ini');
	LevelsIni := TDIniFile.Create(WorkDir + 'Levels.ini');
	RWOptions(False);
	AddSounds(SoundNames);

	AcceptParams(True, ['NoHash', 'NoGame'], ['Do not allocate memory for hash table', 'Do not load last opened games']);
	while True do
	begin
		case CompareParams of
		paFile: Kinds.KindLoadFromFile(ParamFile);
		0: EnableHashTable := False;
		1: Kinds.SkipStartup := True;
		else Break;
		end;
	end;
	CloseParams;

	// Apply Options
	if Logo1.Checked then
	begin
		ShowLogo;
	end;

	if EnableHashTable then
	begin
		SetHashSize(WantHashPos);
	end;

	InitMenuRotate;
	InitMenuEngine;
	InitMenuAnalysis;
	InitMenuLevel;

	S := '';
	if (Screen.Width < ScreenMinX) or (Screen.Height < ScreenMinY) then
		S := 'Minimal resolution for program is ' + NToS(ScreenMinX) + CharTimes + NToS(ScreenMinY);
	if S <> '' then
	begin
		MessageD(S, mtWarning, [mbOK]);
	end;

	InitForms;

	// Last
	SetPriorityClass(GetCurrentProcess, ProcessPriority(PriorityProcess));
	SetThreadPriority(GetCurrentThread, ThreadPriority(PriorityMainThread));
	DragAcceptFiles(Handle, True);
end;

procedure TfMain.FormDestroy(Sender: TObject);
var i: SG;
begin
	FreeAndNil(Kinds);

	// Forms
	for i := Low(fBoard) to High(fBoard) do
		FormFree(TForm(fBoard[i]));
	FormFree(TForm(fAnalys));
	FormFree(TForm(fClock));
	FormFree(TForm(fComment));
	FormFree(TForm(fGameInfo));
	FormFree(TForm(fLevels));
	FormFree(TForm(fMoves));
	FormFree(TForm(fNew));
//  FormFree(TForm(fNewMove));
	FormFree(TForm(fNextMove));
	FormFree(TForm(fPieces));
	FormFree(TForm(fPGN));
	FormFree(TForm(fPrint));
	FormFree(TForm(fSetup));

	FreeFileExt;
	FreeSounds;

	FreeAndNil(LevelsIni);
	FreeAndNil(EngineIni);
	MainIniFree;
	SetHashSize(0);
end;

procedure TfMain.HashTablePositions1Click(Sender: TObject);
var
	M: UG;
	T: SG;
begin
	InitMaxHashPos;
	M := MaxHashPos;
{ if M < 1 then
		M := 1
	else
		M := 1 shl CalcShr(M);}
	T := Min(WantHashPos, MaxHashPos);
	if GetNumber('Hash Positions', T, 1, DefHashPos, M, nil) then
	begin
		WantHashPos := T;
		NowHashPos := 0;
		SetHashSize(WantHashPos);
		InitMenuEngine;
	end;
end;

procedure TfMain.Coordinates1Click(Sender: TObject);
begin
end;

(*-------------------------------------------------------------------------*)
procedure TfMain.Rotate1Click(Sender: TObject);
var R: SG;
begin
	R := TMenuItem(Sender).Tag;
	Inc(Rotated, R);
	if Rotated >= 4 then
		Dec(Rotated, 4);
	FreeBoards;
	UpdateBoards;
	DrawBoards;
	InitMenuRotate;
end;

procedure GameChanged;
var
	AMove: SG;
begin
	if Where <> whNone then
		Ext := exFin;
	Presumption := False;
	FillStartPos;
	FillUsedSquares(Game.Pos.Board, False);
	FillGameECO;

	SetTimeGo(tgNone);
	fMain.InitMenuTimeGo;

	if (Kinds.Count > 0) and (Games <> nil) and (Games.Count > 0) then
	begin
		FreeBoards;
		if GameType <> PieceGameType then
		begin
			LoadPieces;
		end;
		UpdateBoards;

		AMove := Game.Pos.MoveIndex;
		CopyPos(Game.Variant.Pos, Game.Pos);
		Game.Pos.MoveIndex := High(Game.Pos.MoveIndex);
		GoToMoveDraw(AMove);
	end
	else
	begin
		GameLastMove := nil;
		GameNextMoves := nil;
		FreeBoards;
		ClearAnalysisInfoAndAnalysis;
		MoveChanged;
	end;

	// Game Changed
	DrawWhoPlay;
	fMain.InitMenuPlayerTypes;

	// fAnalys, fBoard
{ ABoardVisAnalysis := -1;
	ABoardMoveIndex := -1;
	DrawOb(dpAMoves);}
	DrawOb(dpABoard);

	// fGameInfo
	InitGameInfo;

	// fPGN
	InitPGN;

	ChangeLevel;
	ChangeEngine;
end;

procedure TfMain.ChangeFile;
begin
{ if Kinds.Count > 0 then
		Application.Title := ProgramName + ' - ' + GameNames[Game.GameType]
	else
		Application.Title := ApplicationTitle;}

	GameChanged;
end;

procedure TfMain.About1Click(Sender: TObject);
begin
	ExecuteAbout(Self, False);
end;

procedure TfMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	CanClose := Kinds.CanClose;
	if CanClose then
	begin
		if Where in [whTN, whTD, whReplay] then
			Ext := exStop;
		RWOptions(True);
	end;
end;

procedure TfMain.Exit1Click(Sender: TObject);
begin
	Close;
end;

procedure TfMain.PrinterSetup1Click(Sender: TObject);
begin
	PrinterSetupDialog1.Execute;
end;

procedure TfMain.Print1Click(Sender: TObject);
begin
	if not Assigned(fPrint) then fPrint := TfPrint.Create(Self);
	fPrint.EditFile.Text := PrntName;
	fPrint.ShowModal;
end;

procedure TfMain.LevelsXClick(Sender: TObject);
begin
	if not Assigned(fLevels) then fLevels := TfLevels.Create(Self);
	fLevels.Visible := not fLevels.Visible;
end;

procedure TfMain.Information2Click(Sender: TObject);
begin
	if not Assigned(fGameInfo) then fGameInfo := TfGameInfo.Create(Self);
	fGameInfo.Visible := not fGameInfo.Visible;
	UpdateIcons(fMain.MainMenu, fMain.PanelTool);
end;

function OfferDraw: BG;
var s: string;
begin
	if (AnalysisC <= 0) or (AbortDepth = adNoChoise) then
	begin // No data
		s := 'I have no idea about this position';
		Result := False;
	end
	else if VariantionCutToTermination(Analysis[AnalysisC - 1].Status.VariantionCut) = gt1212 then
	begin // Draw by variantion
		s := 'Yes, I think game is really a draw';
		Result := True;
	end
	else if (Analysis[AnalysisC - 1].Status.Score <= Game.Params[Game.SeparatedEngine, eoContemptValue].Num - scLongWin) then
	begin // Draw accepted
		s := 'I accept (' + ScoreToRes(Analysis[AnalysisC - 1].Status.Score) + ')';
		Result := True;
	end
	else // Draw refused
	begin
		s := 'I refuse'{$ifopt d+} + ' (' + ScoreToRes(Analysis[AnalysisC - 1].Status.Score) + ')'{$endif};
{   if (OSa + OSp) > 2000 then
		begin
			Echo('Is too early to a draw', clNormal);
		end
		else
		begin
			Echo('I do not want a draw', clNormal);
		end;}
		Result := False;
	end;
	MessageD(s, mtInformation, [mbOk]);
end;
(*-------------------------------------------------------------------------*)
procedure TfMain.OfferDraw1Click(Sender: TObject);
begin
	if OfferDraw then
	begin
		OStatus.VariantionCut := vcDrawByPlayer;
		SetGameTermination(False);
	end
	else
	begin
		PlayASound(snNoDraw);
	end;
end;

procedure TfMain.Resign1Click(Sender: TObject);
begin
	OStatus.VariantionCut := vcResign;
	SetGameTermination(True);
end;

procedure TfMain.BackwardForwardMove1Click(Sender: TObject);
begin
	GoToMoveDraw(Game.Pos.MoveIndex - Game.Variant.Pos.MoveIndex + TComponent(Sender).Tag)
end;

procedure TfMain.FirstLastMove1Click(Sender: TObject);
var i: SG;
begin
	if TMenuItem(Sender).Tag = 0 then
		i := 0
	else
		i := High(i);
	GoToMoveDraw(i);
end;

procedure TfMain.GoToMove1Click(Sender: TObject);
var
	MaxMove, M: SG;
begin
	MaxMove := ((GetPlyCount(@Game, False) + Game.Variant.Pos.MoveIndex) div 2) + 1;

	M := (Game.Pos.MoveIndex) div 2 + 1;
	if GetNumber('Go To Move', M, (Game.Variant.Pos.MoveIndex div 2), (Game.Pos.MoveIndex div 2), MaxMove, nil) then
	begin
		M := (M - 1) * 2 - Game.Variant.Pos.MoveIndex + 1;
//    if M + 1 >= MaxMove then M := MaxMove;
		GoToMoveDraw(M);
	end;
end;

var
	NextReplayTime: U4;

procedure TfMain.ReplayMoves1Click(Sender: TObject);
begin
	if Where = whReplay then
	begin
		fMain.ReplayMoves1.Checked := False;
		fMain.OfferDraw1.Enabled := True;
		fMain.Resign1.Enabled := True;
		Where := whNone;
		InitMenuTM;
	end
	else
		if GetTime('Replay Time', ReplayTime, 0, DefReplayTime, MaxTime, nil) then
		begin
			SetTimeGo(tgNone);
			Presumption := False;
			Where := whReplay;
			fMain.ReplayMoves1.Checked := True;
			fMain.OfferDraw1.Enabled := False;
			fMain.Resign1.Enabled := False;
			NextReplayTime := GTime + ReplayTime;
		end;
end;

procedure TfMain.StopAnalysis1Click(Sender: TObject);
begin
	if (Where <> whNone) then
		Ext := exFin;
end;

procedure TfMain.AutomaticAnalysis1Click(Sender: TObject);
begin
	AutomaticAnalysis := not AutomaticAnalysis;
	AutomaticAnalysis1.Checked := AutomaticAnalysis;
end;

procedure TfMain.Move1Click(Sender: TObject);
var i: SG;
begin
	if Kinds.Count = 0 then Exit;
	if OMC <= 0 then Exit;
	i := TComponent(Sender).Tag; // 0 - no move, 1 - do move
	case Where of
	whNone:
	begin
		Where := TWhere(SG(whTN) + i); RunEngine;
	end;
	whTN, whTD:
	begin
		Where := TWhere(SG(whTN) + i); InitMenuTM;
		SetTimeGo(TTimeGo(i + 1));
		DrawTotalTime(Game.Pos.Side);
	end;
	end;
end;

procedure TfMain.NextMove1Click(Sender: TObject);
var i: SG;
begin
	if Kinds.Count = 0 then Exit;
	if TMenuItem(Sender).Tag <> 0 then
		GoToMoveDraw(Game.Pos.MoveIndex - Game.Variant.Pos.MoveIndex - 1);
	if OMC <= 0 then Exit;
	if (GetDisabledMoves + 1) < OMC then
	begin
		if TMenuItem(Sender).Tag <> 0 then
		begin
			for i := 0 to GameNextMoves.Count - 1 do
				MoveInfos[GameNextMoves.Moves[i].Index].Disabled := True;
		end
		else
			MoveInfos[MovesOrder[0]].Disabled := True;
		DrawOb(dpNextBestMoves);
	end;
	Echo('Remain moves: ' +
//    NToS(OMC - GetDisabledMoves, '#0') + ',' +
		NToS(OMC - GetDisabledMoves, '#0') + '/' +
		NToS(OMC, '#0'));
	Where := TWhere(SG(whTN) + TMenuItem(Sender).Tag); RunEngine;
end;

procedure TfMain.PlayerType1Click(Sender: TObject);
var
	Tg: SG;
begin
	Tg := TMenuItem(Sender).Tag;
	Game.PlayerTypes[0] := Tg and 1;
	Game.PlayerTypes[1] := (Tg and 2) shr 1;

	InitMenuPlayerTypes;
	InitPlayEngineTags;
	DrawWhoPlay;
	InitPGN;
end;

// Levels

procedure TfMain.Unknown1Click(Sender: TObject);
begin
	Game.Levels[Game.SeparatedLevel].Typ := ltUnknown;
	ChangeLevel;
end;

procedure TfMain.Infinite1Click(Sender: TObject);
begin
	Game.Levels[Game.SeparatedLevel].Typ := ltInfinite;
	ChangeLevel;
end;

procedure TfMain.FixedDepth1Click(Sender: TObject);
begin
	if GetNumber('Fixed Depth', Game.Levels[Game.SeparatedLevel].MaxD, 0, DefLevel.MaxD, MaxDepth - 1, nil) then
	begin
		Game.Levels[Game.SeparatedLevel].Typ := ltFixedDepth;
		ChangeLevel;
	end;
end;

procedure TfMain.Hourglass1Click(Sender: TObject);
begin
	if GetTime('Hourglass', Game.Levels[Game.SeparatedLevel].Time, 0, DefLevel.Time, MaxTime, nil) then
	begin
		Game.Levels[Game.SeparatedLevel].Typ := ltHourglass;
		ChangeLevel;
	end;
end;

procedure TfMain.LevelMove1Click(Sender: TObject);
begin
	if GetTime('Time / Move', Game.Levels[Game.SeparatedLevel].Time, 0, DefLevel.Time, MaxTime, nil) then
	begin
		Game.Levels[Game.SeparatedLevel].Typ := ltAverage;
		Game.Levels[Game.SeparatedLevel].TimeNodes := False;
		Game.Levels[Game.SeparatedLevel].IncTime := 0;
		Game.Levels[Game.SeparatedLevel].FreeTime := 0;
		ChangeLevel;
	end;
end;

procedure TfMain.LevelGame1Click(Sender: TObject);
begin
	if GetTime('Time / Game', Game.Levels[Game.SeparatedLevel].ControlTime[0], 0, DefLevel.ControlTime[0], MaxTime, nil) then
	begin
		Game.Levels[Game.SeparatedLevel].Typ := ltTimeControls;
		Game.Levels[Game.SeparatedLevel].IncTime := 0;
		Game.Levels[Game.SeparatedLevel].ControlCount := 1;
		ChangeLevel;
	end;
end;

procedure TfMain.MinimalNodes1Click(Sender: TObject);
begin
	if GetNumber('Minimal Nodes', Game.Levels[Game.SeparatedLevel].Nodes, 0, DefLevel.Nodes, High(DefLevel.Nodes), nil) then
	begin
		Game.Levels[Game.SeparatedLevel].Typ := ltMinimal;
		Game.Levels[Game.SeparatedLevel].TimeNodes := True;
		ChangeLevel;
	end;
end;

procedure TfMain.LevelControls1Click(Sender: TObject);
var
	S: string;
	i: SG;
begin
	if GetNumber('Count of Controls', Game.Levels[Game.SeparatedLevel].ControlCount, 1, DefLevel.ControlCount, MaxControl + 1, nil) then
	begin
		Game.Levels[Game.SeparatedLevel].Typ := ltTimeControls;
		if GetTime('Incremental Time / Move', Game.Levels[Game.SeparatedLevel].IncTime, 0, DefLevel.IncTime, MaxTime, nil) then
		begin
			for i := 0 to Game.Levels[Game.SeparatedLevel].ControlCount - 1 do
			begin
				S := 'Control ' + NToS(i + 1) + ' / ' + NToS(Game.Levels[Game.SeparatedLevel].ControlCount);
				if GetTime(S + ' Time', Game.Levels[Game.SeparatedLevel].ControlTime[i], 0,
					DefLevel.ControlTime[i], MaxTime, nil) = False then Break;
				if i < Game.Levels[Game.SeparatedLevel].ControlCount - 1 then
				begin
					if GetNumber(S + ' Moves', Game.Levels[Game.SeparatedLevel].ControlMoveCount[i], 1, DefLevel.ControlMoveCount[i], MaxGameMoves, nil) = False then
						Break;
				end;
			end;
		end;
		ChangeLevel;
	end;
end;

procedure TfMain.ShortestWin1Click(Sender: TObject);
begin
	Game.Levels[Game.SeparatedLevel].Typ := ltShortestWin;
	ChangeLevel;
end;

procedure TfMain.WinIn1Click(Sender: TObject);
begin
	if GetNumber('Win In', Game.Levels[Game.SeparatedLevel].WinIn, 1, DefLevel.WinIn, MaxDepth, nil) then
	begin
		Game.Levels[Game.SeparatedLevel].Typ := ltWinIn;
		ChangeLevel;
	end;
end;

// Engine Options

procedure OptionClick(i: TEngineOption);
var
	O: POption;
	P: PParam;
begin
	O := @EO[i];
	P := @Game.Params[Game.SeparatedEngine, i];
	case O.Typ of
	vsCheck:
	begin
		P.Bool := not P.Bool;
		OptionChanged(i);
		fMain.InitMenuEngine;
	end;
	vsSpin, vsCombo:
		if GetNumber(EngineOptionNames[i], P.Num, O.Minimum, O.Default, O.Maximum, nil) then
		begin
			OptionChanged(i);
			fMain.InitMenuEngine;
		end;
	vsString:
		if GetStr(EngineOptionNames[i], P.Str, O.DefaultStr, 0) then
		begin
			OptionChanged(i);
			fMain.InitMenuEngine;
		end;
	vsButton:
		OptionChanged(i);
	end;
end;

procedure TfMain.RandomPlay1Click(Sender: TObject);
begin
	OptionClick(eoRandomPlay);
end;

procedure TfMain.Ponder1Click(Sender: TObject);
begin
//  OptionClick(eoPonder);
end;

procedure TfMain.ContemptValue1Click(Sender: TObject);
begin
	OptionClick(eoContemptValue);
end;

procedure TfMain.ProgramOfferDraw1Click(Sender: TObject);
begin
	PrgOfferDraw := not PrgOfferDraw;
	ProgramOfferDraw1.Checked := PrgOfferDraw;
	if PrgOfferDraw = False then Echo('Program can not offer a draw') else Echo('Program can offer a draw');
end;

procedure TfMain.ProgramResign1Click(Sender: TObject);
begin
	PrgResign := not PrgResign;
	ProgramResign1.Checked := PrgResign;
	if PrgResign = False then Echo('Program can not resign') else Echo('Program can resign');
end;

procedure TfMain.StopClock1Click(Sender: TObject);
begin
	SetTimeGo(tgNone);
end;

procedure TfMain.PlayClock1Click(Sender: TObject);
begin
	SetTimeGo(tgGame);
end;

var
	VisiI: SG;

procedure OnApplyStartTotTime(Value: S8);
begin
	Game.StartTotTime[VisiI] := Value;
	InitTotalTime;
	DrawTotalTime(VisiI);
end;

procedure OnApplyMoveTime(Value: S8);
begin
	if GameLastMove <> nil then
	begin
		GameLastMove.MovTime := Value;
		InitTotalTime;
		DrawTotalTime(VisiI);
		DrawOb(dpMoves);
	end;
end;

procedure TfMain.PSetClock1Click(Sender: TObject);
begin
	VisiI := TMenuItem(Sender).Tag;
	if GetTime(SideToS[GameType][VisiI] + ' Clock', UG(Game.StartTotTime[VisiI]), 0, 0, MaxTime, OnApplyStartTotTime) then
	begin
		PlayASound(snSetClock);
		KindsChange;
	end;
end;

procedure TfMain.SetMoveTime1Click(Sender: TObject);
begin
	if GameLastMove <> nil then
	begin
		VisiI := Game.Pos.Side xor 1;
		if GetTime('Move Time', GameLastMove.MovTime, 0, 0, MaxTime, OnApplyMoveTime) then
		begin
			PlayASound(snSetClock);
			KindsChange;
		end;
	end;
end;


procedure TfMain.RemainTime1Click(Sender: TObject);
begin
	RemainTime := not RemainTime;
	RemainTime1.Checked := RemainTime;
	DrawTotalTime01;
end;

procedure TfMain.SlidePieces1Click(Sender: TObject);
begin
	SlidePieces := not SlidePieces;
	SlidePieces1.Checked := SlidePieces;
	if SlidePieces then Echo('Sliding pieces') else Echo('Jumping pieces');
end;

procedure TfMain.Design2Click(Sender: TObject);
begin
	if not Assigned(fPieces) then fPieces := TfPieces.Create(Self);
	fPieces.Visible := not fPieces.Visible;
end;

procedure TfMain.Save2Click(Sender: TObject);
begin
	WriteAnalysisToFile(AnalysisFile);
	InitMenuAnalysis;
end;

procedure TfMain._SaveSettings1Click(Sender: TObject);
begin
	RWOptions(True);
	MainIni.Save;
end;

procedure TfMain.OneClickMove1Click(Sender: TObject);
begin
	OneClickMove := not OneClickMove;
	OneClickMove1.Checked := OneClickMove;
end;

procedure TfMain.BookUse1Click(Sender: TObject);
begin
	OptionClick(eoOwnBook);
end;

procedure TfMain.AnalysisSavePeriod1Click(Sender: TObject);
begin
	if GetTime('Analysis Autosave Period', SaveAnalysisTime, 0, DefSaveAnalysisTime, MaxTime, nil) then
	begin

	end;
end;

procedure TfMain.NotationXClick(Sender: TObject);
begin
	Notation := TNotation(TMenuItem(Sender).Tag);
	Notation1.Items[SG(Notation)].Checked := True;

	Echo(NotationStr[Notation] + ' notation');
	DrawOb(dpMove1);
	DrawOb(dpMove2);
	FreeBoards;
	DrawBoards;
	DrawMoves;
	DrawOb(dpNextBestMoves);
	DrawOb(dpSetup);
	DrawOb(dpAMoves);
end;

procedure TfMain.Short1Click(Sender: TObject);
begin
	ShortNot := not ShortNot;
	Short1.Checked := ShortNot;
	DrawOb(dpMove1);
	DrawOb(dpMove2);
	DrawMoves;
	DrawOb(dpNextBestMoves);
	DrawOb(dpAMoves);
end;

procedure TfMain.TimerFastTimer(Sender: TObject);
var
	LActMove: SG;
	i: SG;
begin
	GetGTime;
	DelayedTimer;

	// fBoard
	for i := Low(fBoard) to High(fBoard) do
		if Assigned(fBoard[i]) then
			fBoard[i].Timer;

	case Where of
	whReplay:
	begin
		if GTime >= NextReplayTime then
		begin
			LActMove := Game.Pos.MoveIndex;
			GoToMoveDraw(Game.Pos.MoveIndex - Game.Variant.Pos.MoveIndex + 1);
			if Game.Pos.MoveIndex = LActMove then // Cannot offset move
			begin
				ReplayMoves1Click(Sender);
			end;
			NextReplayTime := GTime + ReplayTime;
		end;
	end;
	end;
end;

procedure TfMain.Sounds1Click(Sender: TObject);
begin
	FormSounds;
end;

{$ifdef Thread}
procedure TfMain.ParallelDone(Sender: TObject);
begin
	SetThreadPriority(GetCurrentThread, ThreadPriority(PriorityMainThread));
end;
{$endif}

procedure TfMain.Suicide1Click(Sender: TObject);
begin
	Game.Variant.Options[voSuicide].Bool := not Game.Variant.Options[voSuicide].Bool;
	Suicide1.Checked := Game.Variant.Options[voSuicide].Bool;
end;

procedure TfMain.PieceActivity1Click(Sender: TObject);
begin
	OptionClick(eoPieceActivity);
end;

procedure TfMain.Material1Click(Sender: TObject);
begin
	OptionClick(eoMaterial);
end;

procedure OnApplyVisible(Value: S8);
begin
	Visi[VisiI] := Value;
	DrawBoards;
end;

procedure TfMain.P0Visible1Click(Sender: TObject);
begin
	VisiI := TMenuItem(Sender).Tag;
	GetNumber('Visible', Visi[VisiI], 0, 16, 16, OnApplyVisible);
end;

procedure TfMain.EnableAnalysisAutosave1Click(Sender: TObject);
begin
	EnableAnalysisAutosave := not EnableAnalysisAutosave;
	EnableAnalysisAutosave1.Checked := EnableAnalysisAutosave;
end;

procedure TfMain.DelayScreen1Click(Sender: TObject);
begin
	DelayScreen := not DelayScreen;
	DelayScreen1.Checked := DelayScreen;
	if DelayScreen = False then Echo('Prompt screen is actived') else Echo('Delay screen is actived');
end;

procedure TfMain.DelayScreenTime1Click(Sender: TObject);
begin
	if GetTime('Delay Screen Time', DelayScreenTime, 0, DefDelayScreenTime, Minute, nil) then
		InitEngine;
end;

procedure TfMain.DelaySound1Click(Sender: TObject);
begin
	DelaySound := not DelaySound;
	DelaySound1.Checked := DelaySound;
end;

procedure TfMain.DelaySoundTime1Click(Sender: TObject);
begin
	if GetTime('Delay Sound Time', DelaySoundTime, 0, DefDelaySoundTime, Minute, nil) then
		InitEngine;
end;


procedure TfMain.FreeTime1Click(Sender: TObject);
begin
	if GetTime('Free Time', Game.Levels[Game.SeparatedLevel].FreeTime, 0, 2 * Second, MaxTime, nil) then
		InitMenuLevel;
end;

procedure TfMain.HashTable1Click(Sender: TObject);
begin
	EnableHashTable := not EnableHashTable;
	HashTable1.Checked := EnableHashTable;
	if EnableHashTable then
	begin
		if AloHashPos = 0 then
		begin
			InitMaxHashPos;
			SetHashSize(WantHashPos)
		end
		else
			NowHashPos := AloHashPos;
	end
	else
		NowHashPos := 0;
	InitMenuEngine;
end;


procedure TfMain.MouseCursorX1Click(Sender: TObject);
const C: array[0..2] of TCursor = (crDefault, crHandPoint, crCross);
begin
	MouseCursor := C[TMenuItem(Sender).Tag];
	MouseCursor1.Items[TMenuItem(Sender).Tag].Checked := True;
end;

procedure TfMain.FreeHashTable1Click(Sender: TObject);
begin
	SetHashSize(0);
	InitMenuEngine;
end;

procedure TfMain.ClearHashTable1Click(Sender: TObject);
begin
	OptionClick(eoClearHash);
end;

procedure TfMain.RefreshHashTable1Click(Sender: TObject);
var
	Tim: U4;
begin
	Tim := GetTickCount;
	RefreshHash;
	Tim := GetTickCount - Tim;
	Echo('Hash refreshed at ' + MsToStr(Tim, diSD, 3, False));
end;

procedure TfMain.List2Click(Sender: TObject);
begin
	if not Assigned(fNextMove) then fNextMove := TfNextMove.Create(Self);
	fNextMove.Visible := not fNextMove.Visible;
	UpdateIcons(fMain.MainMenu, fMain.PanelTool);
end;

procedure TfMain.ActiveSquare1Click(Sender: TObject);
begin
	ActiveSquare := not ActiveSquare;
	ActiveSquare1.Checked := ActiveSquare;
	DrawBoard(1);
end;

procedure TfMain.MenuNoDigit1Click(Sender: TObject);
begin
	Precision := TMenuItem(Sender).Tag;
	Precision1.Items[Precision].Checked := True;
	DrawTotalTime01;
	DrawMoveTime01;
	if TimePerMove then
		DrawMoves;
end;

procedure TfMain.ProcessPriorityClick(Sender: TObject);
begin
	PriorityProcess := TMenuItem(Sender).Tag;
	ProcessPriority1.Items[PriorityProcess].Checked := True;
	SetPriorityClass(GetCurrentProcess, ProcessPriority(PriorityProcess));
end;

procedure TfMain.ThreadMainPriorityClick(Sender: TObject);
begin
	PriorityMainThread := TMenuItem(Sender).Tag;
	MainThreadPriority1.Items[PriorityMainThread].Checked := True;
	SetThreadPriority(GetCurrentThread, ThreadPriority(PriorityMainThread));
end;

procedure TfMain.EnginePriorityClick(Sender: TObject);
begin
	PriorityEngineThread := TMenuItem(Sender).Tag;
	EngineThreadPriority1.Items[PriorityEngineThread].Checked := True;
	{$ifdef Thread}
	if Parallel <> nil then
		Parallel.Priority := TThreadPriority(PriorityEngineThread);
	{$endif}
end;

procedure TfMain.LastNextAnalysis1Click(Sender: TObject);
var Dir: SG;
begin
	Dir := TMenuItem(Sender).Tag;
	if (VisAnalysis + Dir >= 0) and (VisAnalysis + Dir < AnalysisC) then
	begin
		VisAnalysis := VisAnalysis + Dir;
		DrawOb(dpAMoves);
	end;
	InitMenuAnalysis;
end;

procedure TfMain.Comment2Click(Sender: TObject);
begin
	if not Assigned(fComment) then fComment := TfComment.Create(Self);
	fComment.Visible := not fComment.Visible;
	UpdateIcons(fMain.MainMenu, fMain.PanelTool);
end;

procedure TfMain.Normalmove1Click(Sender: TObject);
begin
	SetMark(GameLastMove, TMoveMark(TMenuItem(Sender).Tag));
	DrawMoves;
	KindsChange;
end;

procedure TfMain.Logo1Click(Sender: TObject);
begin
	Logo1.Checked := not Logo1.Checked;
	if Logo1.Checked then
	begin
		ShowLogo;
		HideLogo;
	end
	else
		HideLogoPromptly;
end;

procedure TfMain.Board2Click(Sender: TObject);
var i: SG;
begin
	i := TMenuItem(Sender).Tag;
	if not Assigned(fBoard[i]) then
	begin
		fBoard[i] := TfBoard.Create(Self, i);
	end;


	if FreeWindows1.Checked then
	begin
		fBoard[i].Visible := not fBoard[i].Visible;
		TMenuItem(Sender).Checked := fBoard[i].Visible;
	end
	else
	begin
{   if fBoard.Visible then
		begin
			fBoard.Close;
			fBoard.FormStyle := fsNormal;
			fBoard.Visible := False;
		end
		else
		begin
			fBoard.FormStyle := fsMDIChild;
			fBoard.Visible := True;
		end;
		}
	end;
	UpdateIcons(fMain.MainMenu, fMain.PanelTool);
end;

procedure TfMain.Clock2Click(Sender: TObject);
begin
	if not Assigned(fClock) then fClock := TfClock.Create(Self);
	fClock.Visible := not fClock.Visible;
	UpdateIcons(fMain.MainMenu, fMain.PanelTool);
end;

procedure TfMain.Analysis2Click(Sender: TObject);
begin
	if not Assigned(fAnalys) then fAnalys := TfAnalys.Create(Self);
	fAnalys.Visible := not fAnalys.Visible;
end;

procedure TfMain.Moves2Click(Sender: TObject);
begin
	if not Assigned(fMoves) then fMoves := TfMoves.Create(Self);
	fMoves.Visible := not fMoves.Visible;
	UpdateIcons(fMain.MainMenu, fMain.PanelTool);
end;

procedure TfMain.FormKeyDown(Sender: TObject; var Key: Word;
	Shift: TShiftState);
var i: SG;
begin
	if Kinds.Count <= 0 then Exit;
	if (ssShift in Shift) and (Key <> 16) then
	begin
		if WhereSetup then
			for i := 1 to PieceTypes do
			begin
				if Char(Lo(Key)) = PieceToS(TSquare(i), False) then
					SetupSetPiece(TPiece(i));
			end;
		Exit;
	end;

	case Key of
	VK_ESCAPE: if Where = whReplay then Where := whNone else PlayASound(snWarning);
	VK_RETURN: PressSquare(Game.Pos, Game.CXY, True);
	VK_LEFT:
	begin
		if Shift = [ssCtrl] then
		begin
			if Back1.Enabled then
				GoToMoveDraw(Game.Pos.MoveIndex - Game.Variant.Pos.MoveIndex - 1)
			else
				PlayASound(snWarning);
		end
		else
		begin
			OffsetXY(-1, 0);
		end;
	end;
	VK_RIGHT:
	begin
		if Shift = [ssCtrl] then
		begin
			if Forward1.Enabled then
				GoToMoveDraw(Game.Pos.MoveIndex - Game.Variant.Pos.MoveIndex + 1)
			else
				PlayASound(snWarning);
		end
		else
		begin
			OffsetXY(1, 0);
		end;
	end;
	VK_UP:
	begin
		OffsetXY(0, 1);
	end;
	VK_DOWN:
	begin
		OffsetXY(0, -1);
	end;
{ 112..121: // Ctrl+F1..F10
	begin
		if Shift = [ssCtrl] then
		begin
			if Clipboard1.Enabled then
			begin
				LoadClipBoard(Key - 112);
			end
			else
			begin
				PlayASound(sndWarn1);
			end;
		end;
	end;}
	Ord('0')..Ord('9'):
	begin
		if Shift = [ssAlt] then
		begin
			if (Game.Levels[Game.SeparatedLevel].Typ <> ltFixedDepth) or (Game.Levels[Game.SeparatedLevel].MaxD <> UG(Key - Ord('1'))) then
			begin
				Game.Levels[Game.SeparatedLevel].Typ := ltFixedDepth;
				Game.Levels[Game.SeparatedLevel].MaxD := Key - Ord('1') + 1;
				ChangeLevel;
			end
			else
			begin
				PlayASound(snWarning);
			end;
		end
		else
		if (Shift = [ssShift]) and (Key = Ord('1')) then
		begin
			if (GameLastMove <> nil) and (GameLastMove.Mark[0] <> mmGoodMove) then
			begin
				GameLastMove.Mark[0] := mmGoodMove;
				KindsChange;
				DrawMoves;
			end
			else
			begin
				PlayASound(snWarning);
			end;
		end;
		if Shift = [] then
		begin
			i := Key - Ord('1');
			if i < SqYC then
			begin
				ChangeXY(Game.CursorX, i);
			end;
		end;
	end;
//  Ord('a')..Ord('n'):
	96..105: // Numbers
	begin
		if Key = 96 then
			i := 9
		else
			i := Key - 97;
		if i < SqYC then
			ChangeXY(Game.CursorX, i);
	end;
	Ord('s'):
	begin
		if Shift = [ssAlt] then
		begin
			Application.Minimize;
		end;
	end;
	Ord('A')..Ord('N'):
	begin
		if Shift = [] then
		begin
			i := Key - Ord('A');
			if i < SqXC then
				ChangeXY(i, Game.CursorY);
		end;
	end;
	192: // `
	begin
		if (GameLastMove <> nil) and (GameLastMove.Mark[0] <> mmNone) then
		begin
			GameLastMove.Mark[0] := mmNone;
			KindsChange;
			DrawMoves;
		end
		else
		begin
			PlayASound(snWarning);
		end;
	end;
{ 191:
	begin
		if (GameLastMove <> nil) and (GameLastMove.Mark <> mmGoodMove) and (Shift = [ssShift]) then
		begin
			GameLastMove.Mark := mmGoodMove;
			Kinds.Change;
			DrawMoves;
		end
		else
		begin
			PlayASound(sndWarning);
		end;
	end;
	189:
	begin
		if (Game.Levels[FormLevel].Typ = ltFixedDepth) and (Game.Levels[FormLevel].MaxD > 0) then
		begin
			Dec(Game.Levels[FormLevel].MaxD);
		end
		else
		begin
			PlayASound(sndWarning);
		end;
	end;
	187:
	begin
		if (Game.Levels[FormLevel].Typ = ltFixedDepth) and (Game.Levels[FormLevel].MaxD < MaxDepth) then
		begin
			Inc(Game.Levels[FormLevel].MaxD);
		end
		else
		begin
			PlayASound(sndWarning);
		end;
	end;}
{ 186: // J ;
		if Where = whSetup then SetupPut(fiP0) else PlayASound(sndWarning);
	222: // K '
		if Where = whSetup then SetupPut(fiN0) else PlayASound(sndWarning);}
	end;
end;

var
	FirstShow: BG;

procedure TfMain.FormShow(Sender: TObject);
begin
	if FirstShow = False then
	begin
		FirstShow := True;

		if Logo1.Checked then
		begin
			HideLogo;
		end;
		if RunCount = 1 then
		begin
			Kinds.New1.Click;
		end;
		Kinds.KindChangeFile(Sender);

		// Forms (Screen Z-Order), fMain is upper
		if Analysis2.Checked then Analysis2Click(Sender);
		if AnalysisBoard2.Checked then Board2Click(AnalysisBoard2);
		if Board2.Checked then Board2Click(Board2);
		if Clock2.Checked then Clock2Click(Sender);
		if Comment2.Checked then Comment2Click(Sender);
		if Moves2.Checked then Moves2Click(Sender);
		if List2.Checked then List2Click(Sender);
		if Design2.Checked then Design2Click(Sender);
		if Information2.Checked then Information2Click(Sender);
		if Levels2.Checked then LevelsXClick(Sender);
		if PGN2.Checked then PGN2Click(Sender);
		if PositionSetup2.Checked then PositionSetup2Click(Sender);

		if RunCount = 1 then
		begin
			DefaultLayout1Click(Sender);
		end;
		InitGTime;
		TimerFast.Enabled := True;
	end;
end;

procedure TfMain.ReadMe1Click(Sender: TObject);
begin
	ReadMe;
end;

procedure TfMain.FileIsDropped(var Msg: TMessage);
var
	Files: TStrings;
begin
	Files := DropFiles(Msg.WParam);
	Kinds.KindOpenFiles(Files);
	Files.Free;
end;

procedure TfMain.Analog1Click(Sender: TObject);
begin
	Analog := not Analog;
	Analog1.Checked := Analog;
	if FormDraw(fClock) then
	begin
		fClock.UpdateAnalog;
		if Analog = False then
		begin
			DrawTotalTime01;
			DrawMoveTime01;
		end;
	end;
end;

var
	MoveString: string;

procedure TfMain.FindMove1Click(Sender: TObject);
label LExit;
var
	i: SG;
	Mv: PGameMoves;
	M: PGameMove;
	HPos: TPos;
begin
	if GetStr('Find Move', MoveString, '', 0) then
	begin
		CopyPos(CPos, HPos);
		CopyPos(Game.Variant.Pos, CPos);
		Mv := Game.FirstMove;
		i := 0;
		while Mv <> nil do
		begin
			GenerateMoves;
			M := @Mv.Moves[Mv.Actual];
			PCMove := PMove(SG(FCMove) + M.Index shl ShlTMove);
			if PosEx(MoveString, MoveToStr(PCMove, True, False)) <> 0 then
			begin
				GoToMoveDraw(i + 1);
				goto LExit;
			end;
			DoMove;
			Mv := M.Moves;
			Inc(i);
		end;
		MessageD('Move not found', mtInformation, [mbOk]);
		LExit:
		CopyPos(HPos, CPos);
	end;
end;

procedure TfMain.Help2Click(Sender: TObject);
begin
	Help;
end;

procedure TfMain.DefaultLayout1Click(Sender: TObject);
var
	x0, y0, x1, y1,
	w, h: SG;
	Rect: TRect;
begin
	GetScreen(Rect);
	w := Rect.Right - Rect.Left;
	h := Rect.Bottom - Rect.Top;
	x0 := Rect.Left;
	y0 := Rect.Top;
{ x1 := Rect.Right;
	y1 := Rect.Bottom;}
	Constraints.MinHeight := Height - ClientHeight + StatusBar.Height + 2 * (IconSize + 1);

	if FreeWindows1.Checked then
	begin
		Left := x0;
		Top := y0;
		Width := 512 + 60;// w div 2; // Constrains.Height
		Height := Constraints.MinHeight;
	end;

	if FormDraw(fBoard[1]) then
	begin
		fBoard[1].SetBounds(x0, Constraints.MinHeight, Width, h div 2);
	end;

	if FormDraw(fMoves) then
	begin
		fMoves.SetBounds(x0 + Width, y0, w - Width - w div 4, Constraints.MinHeight + h div 2);
	end;

	if FormDraw(fClock) then
	begin
		fClock.SetBounds(x0 + Width + w - Width - w div 4, y0, w div 4, h div 6);
	end;

	if FormDraw(fNextMove) then
	begin
		fNextMove.SetBounds(x0 + Width + w - Width - w div 4, y0 + h div 6, w div 4, Constraints.MinHeight + h div 2 - h div 6);
	end;

	if FormDraw(fBoard[2]) then
	begin
		y1 := y0 + Constraints.MinHeight + h div 2;
		fBoard[2].SetBounds(x0, y1, w div 4 + w div 8, Rect.Bottom - y1);
	end;

	if FormDraw(fAnalys) then
	begin
		x1 := x0 + w div 4 + w div 8;
		y1 := y0 + Constraints.MinHeight + h div 2;
		fAnalys.SetBounds(x1, y1, Rect.Right - x1, Rect.Bottom - y1);
	end;
end;

procedure TfMain._ExportGame1Click(Sender: TObject);
var
	Buffer: string;
begin
	case TMenuItem(Sender).Tag of
	0: Buffer := GamesToString;
	1: Buffer := GameToString(@Game, False);
	2: Buffer := PosToString(@Game.Pos, @Game, True);
	end;
	Clipboard.SetTextBuf(PChar(Buffer));
end;

procedure TfMain.Import1Click(Sender: TObject);
const MaxSize = 256 * 1024; // Limit
var
	s, e: string;
	InLineIndex: SG;
begin
	if (Clipboard.FormatCount <= 0) then
		Echo('Clipboard is empty')
	else
	if not (Clipboard.HasFormat(CF_TEXT)) then
		Echo('Invalid clipboard format')
	else
	begin
		SetLength(s, MaxSize);
		SetLength(s, Clipboard.GetTextBuf(PChar(s), MaxSize));
		if Length(s) < 2 then Exit;
		if Kinds.Count = 0 then
			Kinds.KindNewFile(nil, 'Clipboard')
		else
			NewSubGameEx;

		if s[1] = '[' then
		begin
			StringToGame(s, gtChess);
		end
		else
		begin
			InLineIndex := 1;
			e := FENStrToGame(s, InLineIndex);
			EPDStrToGame(s, InLineIndex);
			if e <> '' then
				MessageD(e, mtError, [mbOk]);
		end;
		KindsChange;
		GameChanged;
	end;
end;

procedure TfMain.InsertNullmove1Click(Sender: TObject);
begin
	DoImportMove(NullMoveIndex, False);
end;

procedure TfMain.EvaluationProfile1Click(Sender: TObject);
begin
	EvaluationProfile := not EvaluationProfile;
	EvaluationProfile1.Checked := EvaluationProfile;
	DrawMoves;
end;

procedure TfMain.CapturedPieces1Click(Sender: TObject);
begin
	CapturedPieces := not CapturedPieces;
	CapturedPieces1.Checked := CapturedPieces;
	UpdateBoards;
	DrawBoards;
end;

var
	BmpOutputBoard: TDBitmap;

procedure PosToBmpEx(out Bmp: TDBitmap; Pos: PPos; W, H: SG);
var
	DefBoardSize: TBoardSize;
begin
//  XY := Max(SqXC, SqYC);
	if SqXC > SqYC then
	begin
		DefBoardSize.Width := W;
		DefBoardSize.Height := MaxInt div 2;
	end
	else
	begin
		DefBoardSize.Width := MaxInt div 2;
		DefBoardSize.Height := H;
	end;
	FillBoardSize(DefBoardSize, 4);

	Bmp := TDBitmap.Create;
	Bmp.SetSize(DefBoardSize.Width, DefBoardSize.Height);
	PosToBmp(Bmp, BmpOutputBoard, @DefBoardSize, Pos, nil, False, 0, 0, nil, nil, 4);
end;

procedure TfMain.CopyGraphicsContent1Click(Sender: TObject);
var
	Bmp: TDBitmap;
	F: TComponent;
begin
	F := TMenuItem(Sender).GetParentMenu.Owner;
	if (F is TfBoard) and (TfBoard(F).BIndex = 2) then
		PosToBmpEx(Bmp, @APos, SavedWidth, SavedHeight)
	else
		PosToBmpEx(Bmp, @Game.Pos, SavedWidth, SavedHeight);
	if TMenuItem(Sender).Tag = 0 then
		Bmp.SaveToClipboard
	else
		Bmp.SaveToFileDialog(SavedFileName);
	Bmp.Free;
end;

procedure TfMain.PGN2Click(Sender: TObject);
begin
	if not Assigned(fPGN) then fPGN := TfPGN.Create(Self);
	fPGN.Visible := not fPGN.Visible;
end;

procedure TfMain.Figurine1Click(Sender: TObject);
begin
	Figurine := not Figurine;
	Figurine1.Checked := Figurine;
	DrawOb(dpMove1);
	DrawOb(dpMove2);
	DrawMoves;
	DrawOb(dpNextBestMoves);
	DrawOb(dpAMoves);
end;

procedure TfMain.Messages1Click(Sender: TObject);
begin
	ShowMessages;
end;

procedure TfMain.ParamsHelp1Click(Sender: TObject);
begin
	HelpParams;
end;

procedure TfMain.Clear2Click(Sender: TObject);
begin
	ClearAnalysisInfoAndAnalysis;
end;
{
procedure TfMain.InitForm(Form: TForm);
begin
	if Assigned(Form) then
	begin
		if FreeWindows1.Checked then
		begin
//      Form.Parent := nil;
//      Form.ParentWindow := 0;//InvalidHandle;
			Form.FormStyle := fsNormal;
		end
		else
		begin
//      Form.Parent := Self;
//      Form.ParentWindow := Handle;
			Form.FormStyle := fsMDIChild;
		end;
	end;
end;}

procedure TfMain.InitForms;
begin
	if FreeWindows1.Checked then
	begin
		BevelMenu.Visible := True;
		FormStyle := fsNormal;
//    Width := Constraints.MinWidth;
//    Height := Constraints.MinHeight;
//    BorderStyle := bsSingle;
		WindowState := wsNormal;
	end
	else
	begin
		BevelMenu.Visible := False;
		FormStyle := fsMDIForm;
//    BorderStyle := bsSizeable;
		WindowState := wsMaximized;
	end;

	// Forms
{ InitForm(TForm(fABoard));
	InitForm(TForm(fAnalys));
	InitForm(TForm(fBoard));
	InitForm(TForm(fClock));
	InitForm(TForm(fComment));
	InitForm(TForm(fGameInfo));
	InitForm(TForm(fLevels));
	InitForm(TForm(fMoves));
	InitForm(TForm(fNew));
	InitForm(TForm(fNewMove));
	InitForm(TForm(fNextMove));
	InitForm(TForm(fPieces));
	InitForm(TForm(fPGN));
	InitForm(TForm(fPrint));
	InitForm(TForm(fSetup));
	}

	VertScrollBar.Tracking := False;
	HorzScrollBar.Tracking := False;
	VertScrollBar.Visible := False;
	HorzScrollBar.Visible := False;
end;

procedure TfMain.FreeWindows1Click(Sender: TObject);
begin
	FreeWindows1.Checked := not FreeWindows1.Checked;
	InitForms;
end;

procedure TfMain.GenerateNumbers1Click(Sender: TObject);
var
	i: SG;
	Bmp: TDBitmap;
	s: string;
const
	NumDir = 'Numbers\';
	BackColor = $F5ECCC;
	PIndex = 0;

	DefX = 16;
	DefY = 36;
	k = 3;
var
	x1,
	y1,
	x2,
	y2,
	x12,
	y12: SG;
begin
	x1 := 0 * k;
	y1 := 0 * k;
	x2 := 4 * k;
	y2 := 4 * k;
	x12 := 2 * k;
	y12 := 2 * k;
	for i := 0 to 9 do
	begin
		Bmp := TDBitmap.Create;
		Bmp.SetSize(k * DefX, k * DefY);
		Bmp.Bar(BackColor, ef16);
		case i of
		0:
		begin
			Bmp.Bmp(x12, y12, BmpPieces[PIndex, 2 * 5], ef16);
		end;
		1:
		begin
			Bmp.Bmp(x12, y12, BmpPieces[PIndex, 0], ef16);
		end;
		2:
		begin
			Bmp.Bmp(x2, y2, BmpPieces[PIndex, 1], ef16);
			Bmp.Bmp(x1, y1, BmpPieces[PIndex, 2 * 1], ef16);
		end;
		3:
		begin
			Bmp.Bmp(x12, y12, BmpPieces[PIndex, 2 * 1], ef16);
		end;
		4:
		begin
			Bmp.Bmp(x2, y2, BmpPieces[PIndex, 1], ef16);
			Bmp.Bmp(x1, y1, BmpPieces[PIndex, 2 * 3], ef16);
		end;
		5:
		begin
			Bmp.Bmp(x12, y12, BmpPieces[PIndex, 2 * 3], ef16);
		end;
		6:
		begin
			Bmp.Bmp(x2, y2, BmpPieces[PIndex, 2 * 1], ef16);
			Bmp.Bmp(x1, y1, BmpPieces[PIndex, 2 * 2], ef16);
		end;
		7:
		begin
			Bmp.Bmp(x2, y2, BmpPieces[PIndex, 2 * 2], ef16);
			Bmp.Bmp(x1, y1, BmpPieces[PIndex, 2 * 2], ef16);
		end;
		8:
		begin
			Bmp.Bmp(x2, y2, BmpPieces[PIndex, 1], ef16);
			Bmp.Bmp(x1, y1, BmpPieces[PIndex, 2 * 4], ef16);
		end;
		9:
		begin
			Bmp.Bmp(x12, y12, BmpPieces[PIndex, 2 * 4], ef16);
		end;
		end;

		Bmp.Transparent := True;
		Bmp.TransparentColor := BackColor;
		Bmp.Resize(16, 36);

		s := IntToStr(i);
		Bmp.Canvas.Font.Color := $FF6666;
//    Bmp.Canvas.Font.Name := 'Digiface';
		Bmp.Canvas.Font.Name := 'Comic Sans MS';
		Bmp.Canvas.Font.Style := [fsItalic];
		Bmp.Canvas.Font.Size := 17;
		Bmp.Canvas.TextOut(-1, 11, s);

		CreateDir(DataDir + NumDir);
		Bmp.SaveToFile(DataDir + NumDir + s + '.png');

		Bmp.Free;
	end;
end;

procedure TfMain.GeneratePieces1Click(Sender: TObject);
const
	Colors: array[0..1] of Char = ('w', 'b');
	UD: array[0..1] of Char = ('u', 'd');
	LR: array[0..1] of Char = ('l', 'r');
	PiecesDir = 'F\';
	Size = 40;
	Ext = '.png';
var
	SquareColor, PieceIndex: SG;
	Bmp, BmpB: TDBitmap;
	s: string;
	BackColor: TColor;
	BoardSize: TBoardSize;
	sx, sy: string;
	x, y: SG;
	i, j: SG;
begin
	BoardSize.Width := 360;
	BoardSize.Height := 360;
	BoardSize.SquareSize := 40;
	BoardSize.BorderSize := 20;
	BoardSize.SquareBorderSize := 0;

	CreateDir(DataDir + PiecesDir);

	// Border
	PosToBmpEx(BmpB, @StartPos, BoardSize.Width, BoardSize.Height);
	BmpB.SaveToFile(DataDir + PiecesDir + 'StartPos' + Ext);
	Bmp := TDBitmap.Create;

	for j := 0 to 1 do
	for i := 0 to SqXC - 1 do
	begin
		Bmp.SetSize(Size, Size div 2);
		x := 20 + i * Size;
		y := 0 + j * 340;
		Bmp.Bmp(0, 0, BmpB, x, y, x + Bmp.Width - 1, y + Bmp.Height - 1, ef16);
		XYToS(XYToI(i, 0), sx, sy, GetNotation(ntDefault));
		Bmp.SaveToFile(DataDir + PiecesDir + sx + UD[j] + Ext);
	end;

	for j := 0 to 1 do
	for i := 0 to SqYC - 1 do
	begin
		Bmp.SetSize(Size div 2, Size);
		y := 20 + i * Size;
		x := 0 + j * 340;
		Bmp.Bmp(0, 0, BmpB, x, y, x + Bmp.Width - 1, y + Bmp.Height - 1, ef16);
		XYToS(XYToI(0, i), sx, sy, GetNotation(ntDefault));
		Bmp.SaveToFile(DataDir + PiecesDir + sy + LR[j] + Ext);
	end;


	for j := 0 to 1 do
	for i := 0 to 1 do
	begin
		Bmp.SetSize(Size div 2, Size div 2);
		x := 0 + i * 340;
		y := 0 + j * 340;
		Bmp.Bmp(0, 0, BmpB, x, y, x + Bmp.Width - 1, y + Bmp.Height - 1, ef16);
		if (i = 1) and (j = 1) then s := Colors[0] else s := '';
		Bmp.SaveToFile(DataDir + PiecesDir + LR[i] + UD[j] + s + Ext);
	end;

	StartPos.Side := 1;
	PosToBmpEx(BmpB, @StartPos, BoardSize.Width, BoardSize.Height);
	StartPos.Side := 0;

	for j := 0 to 1 do
	for i := 1 to 1 do
	begin
		Bmp.SetSize(Size div 2, Size div 2);
		x := 0 + i * 340;
		y := 0 + j * 340;
		Bmp.Bmp(0, 0, BmpB, x, y, x + Bmp.Width - 1, y + Bmp.Height - 1, ef16);
		if (i = 1) and (j = 0) then s := Colors[1] else s := '';
		Bmp.SaveToFile(DataDir + PiecesDir + LR[i] + UD[j] + s + Ext);
	end;

	Bmp.Free;
	BmpB.Free;

	// Pieces
	for SquareColor := 0 to 1 do
	for PieceIndex := -PieceTypes to PieceTypes do
	begin
		Bmp := TDBitmap.Create;
		Bmp.SetSize(Size, Size);
		if SquareColor = 0 then
			BackColor := PieceSet.LightSquare.Colors[0]
		else
			BackColor := PieceSet.DarkSquare.Colors[0];

		Bmp.Bar(BackColor, ef16);


//    Bmp.Bmp(0, 0, BmpPieces[0, 2 * Abs(PieceIndex)], ef16);
		DrawPiece(@BoardSize, Bmp, 0, 0, PieceIndex, 2, 1);
//    Bmp.Bmp(0, 0, PieceToBmp(0, PieceIndex), ef16);

{   case i of
		0:
		begin
			Bmp.Bmp(x12, y12, BmpPieces[PIndex, 2 * 5], ef16);
		end;
		1:
		begin
			Bmp.Bmp(x12, y12, BmpPieces[PIndex, 0], ef16);
		end;
		2:
		begin
			Bmp.Bmp(x1, y1, BmpPieces[PIndex, 2 * 1], ef16);
		end;
		3:
		begin
			Bmp.Bmp(x12, y12, BmpPieces[PIndex, 2 * 1], ef16);
		end;
		4:
		begin
			Bmp.Bmp(x2, y2, BmpPieces[PIndex, 1], ef16);
			Bmp.Bmp(x1, y1, BmpPieces[PIndex, 2 * 3], ef16);
		end;
		5:
		begin
			Bmp.Bmp(x12, y12, BmpPieces[PIndex, 2 * 3], ef16);
		end;
		6:
		begin
			Bmp.Bmp(x2, y2, BmpPieces[PIndex, 2 * 1], ef16);
			Bmp.Bmp(x1, y1, BmpPieces[PIndex, 2 * 2], ef16);
		end;
		7:
		begin
			Bmp.Bmp(x2, y2, BmpPieces[PIndex, 2 * 2], ef16);
			Bmp.Bmp(x1, y1, BmpPieces[PIndex, 2 * 2], ef16);
		end;
		8:
		begin
			Bmp.Bmp(x2, y2, BmpPieces[PIndex, 1], ef16);
			Bmp.Bmp(x1, y1, BmpPieces[PIndex, 2 * 4], ef16);
		end;
		9:
		begin
			Bmp.Bmp(x12, y12, BmpPieces[PIndex, 2 * 4], ef16);
		end;
		end;}

		Bmp.Transparent := False;
//    Bmp.TransparentColor := BackColor;

		if PieceIndex = 0 then
			s := ''
		else
			s := Colors[SG(PieceIndex < 0) and 1] + PieceToS(-PieceIndex, False);
		s := s + Colors[SquareColor];
		Bmp.SaveToFile(DataDir + PiecesDir + s + Ext);

		Bmp.Free;
	end;
end;

procedure TfMain.DeleteRemainingMoves1Click(Sender: TObject);
begin
	if GameLastMove = nil then
	begin
		Game.FirstMove := nil;
	end
	else
		GameLastMove.Moves := nil;
	FreeMoves(GameNextMoves);
	DrawMoves;
	DrawOb(dpEnabledMoves);
	InitMenuTM;
	FillGameECO;
	InitECOTags;
	InitPGN;
end;

procedure FreeMovesWithout(var P: PGameMoves; Without: PGameMove);
var i: SG;
begin
	if P <> nil then
	begin
		for i := 0 to P.Count - 1 do
		begin
			if @P.Moves[i] = Without then
			begin
				P.Moves[i].Moves := nil;
				Continue;
			end;
			P.Moves[i].CommentBefore := '';
			P.Moves[i].CommentAfter := '';
			FreeMoves(P.Moves[i].Moves);
		end;
		FreeMem(P); P := nil;
	end;
end;

procedure TfMain.DeletePreviousMoves1Click(Sender: TObject);
begin
	Exit; // D??? bug
	CopyPos(Game.Pos, Game.Variant.Pos);
	FreeMovesWithout(Game.FirstMove, GameLastMove);

	Game.FirstMove := GameLastMove.Moves; //GameNextMoves;
	GameNextMoves := GameLastMove.Moves;
	DrawMoves;
	DrawOb(dpEnabledMoves);
	InitMenuTM;
	InitSetupTags;
	FillGameECO;
	InitECOTags;
	InitPGN;
end;

procedure FillGameECO;
var
	HPos: TPos;
	Mv: PGameMoves;
	M: PGameMove;
	BHash: PBHashPos;
begin
	if GameSupportECO then
	if BHashTable <> nil then
	begin
		Game.ECO := 0;
		CopyPos(CPos, HPos);
		CopyPos(Game.Variant.Pos, CPos);

		Mv := Game.FirstMove;
		while True do
		begin
			BHash := FindBHash(CPos.Hash);
			if BHash <> nil then
			begin
				Game.ECO := BHash.OpeningNameIndexTo;
			end;

			if Mv = nil then Break;

			GenerateMoves;
			M := @Mv.Moves[Mv.Main];

			if M.Index = NullMoveIndex then
			begin
				PCMove := nil;
			end
			else
			begin
				{$ifdef Debug}if M.Index > CMC then
				begin
					IE('FillGameECO');
					PCMove := nil;
				end
				else{$endif}
				PCMove := PMove(SG(FCMove) + M.Index shl ShlTMove);
			end;
			DoMove;

			Mv := M.Moves;
		end;
		CopyPos(HPos, CPos);
	end;
end;

procedure TfMain.SetVariantionAsMain1Click(Sender: TObject);
var Ms: PGameMoves;
begin
	Ms := Game.FirstMove;
	if Ms <> nil then
	begin
		while Ms <> nil do
		begin
			Ms.Main := Ms.Actual;
			Ms := Ms.Moves[Ms.Actual].Moves;
		end;
		FillGameECO;
	end;
	DrawMoves;
	DrawOb(dpEnabledMoves);
	InitMenuTM;
	FillGameECO;
	InitECOTags;
	InitPGN;
end;

procedure TfMain.DeleteVariantion1Click(Sender: TObject);
var
	Ms: PGameMoves;
	LastDiv, i: SG;
begin
	LastDiv := -1;
	i := 0;
	Ms := Game.FirstMove;
	while Ms <> nil do
	begin
		if Ms.Count > 1 then LastDiv := i;
		Ms := Ms.Moves[Ms.Actual].Moves;
		Inc(i);
	end;

	GoToMove(LastDiv);

	i := 0;
	Ms := Game.FirstMove;
	while Ms <> nil do
	begin
		if i = LastDiv + 1 then
		begin
			FreeMoves(Ms.Moves[Ms.Actual].Moves);
			Move(Ms.Moves[Ms.Actual + 1], Ms.Moves[Ms.Actual], SizeOf(Ms.Moves[Ms.Actual + 1]) * (Ms.Count - Ms.Actual - 1));
			if Ms.Main = Ms.Actual then
			begin
				Ms.Main := 0;
				Ms.Actual := 0;
			end
			else
			begin
				if Ms.Main > Ms.Actual then
					Dec(Ms.Main);
				Ms.Actual := Ms.Main;
			end;
			Dec(Ms.Count);
//      if Ms.Count = 0 then

			Break;
		end;
		FillGameECO;
		Ms := Ms.Moves[Ms.Actual].Moves;
		Inc(i);
	end;

	DrawMoves;
	DrawOb(dpEnabledMoves);
	InitMenuTM;
	FillGameECO;
	InitECOTags;
	InitPGN;
end;

procedure TfMain.GenerateDiagrams1Click(Sender: TObject);
const
	Zeros = '000';
	Size = 9 * 8 * 5;
	Aliasing = 2;
	images = False;
var
	HTMLFileName: TFileName;
	HTMLTemplate, HTMLData, HTMLDataNext, Diagrams: string;
	HTMLIndex: SG;
	HTMLCount: SG;

var
{ FileName: TFileName;
	Bmp: TDBitmap;
	Quality: SG;}

	i: SG;
	PGNFileName: TFileName;

	Desc: TStrings;
	s: string;
	Diagramy: string;
	HTMLDiagram: string;
	SaveDir: string;
	Reseni: string;
	InLineIndex, DiagramsPerPage: SG;
	GameIndex: SG;
	Name: string;

	LIndex: SG;
begin
	if Kinds.Count > 0 then
	begin
		if Games.Count = 0 then Exit;
		BeginLongOperation;
		PGNFileName := Kinds.Items[Kinds.Index].FileName;
		SaveDir := ExtractFilePath(PGNFileName);
		Diagrams := DelFileExt(ExtractFileName(PGNFileName));
		if images then
		begin
			CreateDir(SaveDir + 'images/');
			DeleteDirs(SaveDir + 'images/', False);
		end;

		HTMLFileName := {DataDir}SaveDir + 'Template.html';
		ReadStringFromFile(HTMLFileName, HTMLTemplate);

		HTMLFileName := DataDir + 'Diagram.html';
		ReadStringFromFile(HTMLFileName, HTMLDiagram);

		HTMLFileName := SaveDir + Diagrams + '.txt';
		Desc := TStringList.Create;
		ReadLinesFromFile(HTMLFileName, Desc);
		HTMLCount := Desc.Count;

		GameIndex := 0;
		HTMLIndex := 0;
		HTMLData := HTMLTemplate;
		DiagramsPerPage := 2;
		Games.Update;
		LIndex := Games.Index;
		Games.Index := -1;
		while (GameIndex < SG(Games.Count)) and (HTMLIndex < HTMLCount) do
		begin
			HTMLFileName := SaveDir + Diagrams + NToS(HTMLIndex + 1, Zeros) + '.html';
			HTMLDataNext := HTMLTemplate;
			Replace(HTMLData, '%Id', NToS(HTMLIndex + 1)); // Id
			InLineIndex := 1;
			s := ReadToChar(Desc[HTMLIndex], InLineIndex, CharTab);
			Replace(HTMLData, '%Description', s); // Popis
			s := ReadToChar(Desc[HTMLIndex], InLineIndex, #0);
			if s <> '' then
			begin
				DiagramsPerPage := StrToValI(s, False, 1, 2, MaxInt, 1);
			end;
			Diagramy := '';
			Reseni := '';
			for i := 0 to DiagramsPerPage - 1 do
			begin
				if GameIndex >= SG(Games.Count) then Break;
				Game := TGame(Games.Get(GameIndex)^);
				Name := Game.PGNTags[ptWhite] + ' - ' + Game.PGNTags[ptBlack];

				s := HTMLDiagram;

				Replace(s, '%Annotator', Game.PGNTags[ptAnnotator]);
				Replace(s, '%DiagramId', IntToStr(i + 1)); // Image name
				Replace(s, '%DiagramDescription', Game.PGNTags[ptComment]); // Popis diagramu

				Replace(s, '%DiagramFEN', PosToString(@Game.Variant.Pos, @Game)); // FEN

				if NotEmpty(Game.PGNTags[ptWhite]) or NotEmpty(Game.PGNTags[ptWhite]) then
					Name := Game.PGNTags[ptWhite] + ' - ' + Game.PGNTags[ptBlack] + ', '
				else
					Name := '';
				if NotEmpty(Game.PGNTags[ptEvent]) then
					Name := Name + Game.PGNTags[ptEvent] + ', ';
				if NotEmpty(Game.PGNTags[ptSite]) then
					Name := Name + Game.PGNTags[ptSite] + ', ';
				if NotEmpty(Game.PGNTags[ptDate]) then
				begin
					if NotEmpty(Game.PGNTags[ptSite]) then
						SetLength(Name, Length(Name) - 2);
					Name := Name + Game.PGNTags[ptDate] + ', ';
				end;
				if Length(Name) >= 2 then
					SetLength(Name, Length(Name) - 2);

{       if images then
				begin
					FileName := SaveDir + 'images\' + LegalFileName(Game.PGNTags[ptWhite] + ' - ' + Game.PGNTags[ptBlack]) + '.png';
					NewFileOrDir(string(FileName));

					PosToBmpEx(Bmp, @Game.StartPos, Aliasing * Size, Aliasing * Size);
					Bmp.Resize(Bmp.Width div Aliasing, Bmp.Height div Aliasing);
	//        BitmapCopy(Bmp, fBoard.BackBitmap);
					Quality := -75;
					Bmp.SaveToFileEx(FileName, Quality);

					Replace(s, '%DiagramFile',
						'<img hspace="12" vspace="4" width="' + IntToStr(Bmp.Width) +
						'" height="' + IntToStr(Bmp.Height) + '" alt="' + Name + '" src="' + RelativePath(HTMLFileName, FileName) + '" />');
					FreeAndNil(Bmp);
				end
				else}
					Replace(s, '%DiagramFile', FENToHTML);

				if HTMLIndex < HTMLCount - 1 then
					Replace(s, '%Solution', '<a href="' + Diagrams + NToS(HTMLIndex + 1, Zeros) + '.html#Solution' +
						NToS(i + 1, False) + '">een</a>')
				else
					Replace(s, '%Solution', '');

				Diagramy := Diagramy + s;
				Reseni := Reseni + '<a name="Solution' + NToS(i + 1, False) + '"></a><h4>Diagram ' + NToS(i + 1) + '</h4>';
				Reseni := Reseni + GameToString(@Game, True) + ' ' + Name;

				Inc(GameIndex);
			end;
			Replace(HTMLData, '%Diagrams', Diagramy); // Diagramy
			if (GameIndex < SG(Games.Count)) and (HTMLIndex < HTMLCount) then
				Replace(HTMLData, '%Solution', Reseni) // Reseni
			else
				Replace(HTMLData, '%Solution', '');
			Replace(HTMLData, '%Content', '<br/>' + GetContent(HTMLIndex, HTMLCount, 11, Diagrams + '.html', Zeros));

			WriteStringToFile(HTMLFileName, HTMLData, False);
			HTMLData := HTMLDataNext;

			Inc(HTMLIndex);
		end;
		HTMLRedirect(SaveDir + 'index.html', ExtractFileName(HTMLFileName));
		Games.Index := LIndex;
		EndLongOperation;
	end;
end;

procedure TfMain.Homepage1Click(Sender: TObject);
begin
	Homepage;
end;

procedure StatDataToHTML(const Data: array of FG; FileName: TFileName);
{$ifdef ResultStats}
var
	HTML: THTML;
	A, Suma, Delta: FG;
	i, DataCount: SG;
	s: string;
{$endif}
begin
{$ifdef ResultStats}
	DataCount := Length(Data);

	HTML := THTML.Create(FileName);
	HTML.Title := 'Statistika';
	HTML.AddCommand('table border="1" cellpadding="4" cellspacing="0"');
	HTML.AddCommand('tr');
	HTML.AddDataCell('Poet dat');
	HTML.AddDataCell(FToS(CountData(Data))) ;
	HTML.AddCommand('/tr');
	HTML.AddCommand('tr');
	HTML.AddDataCell('Minimum');
	HTML.AddDataCell(FToS(Minimum(Data))) ;
	HTML.AddCommand('/tr');
	HTML.AddCommand('tr');
	HTML.AddDataCell('Maximum');
	HTML.AddDataCell(FToS(Maximum(Data))) ;
	HTML.AddCommand('/tr');
	HTML.AddCommand('tr');
	HTML.AddDataCell('Stedn hodnota');
	HTML.AddDataCell(FToS(Avg(Data))) ;
	HTML.AddCommand('/tr');
	HTML.AddCommand('tr');
	HTML.AddDataCell('var X');
	HTML.AddDataCell(FToS(Variance0(Data))) ;
	HTML.AddCommand('/tr');
	HTML.AddCommand('tr');
	HTML.AddDataCell('varian koeficient');
	HTML.AddDataCell(FToS(VarianceCoef(Data))) ;
	HTML.AddCommand('/tr');
	HTML.AddCommand('tr');
	HTML.AddDataCell('piatost');
	HTML.AddDataCell(FToS(Skew(Data))) ;
	HTML.AddCommand('/tr');

	A := Avg(Data);
	Suma := DataCount * A;
	Delta := Suma - DataCount * 0.5;
	HTML.AddCommand('tr');
	HTML.AddDataCell('P[EX>0.5] na hladin vznamnosti');
	if Delta > 0 then
		HTML.AddDataCell(FToS(100 * (Variance0(Data) / Sqr(Delta))) + '%') ;
	HTML.AddCommand('/tr');
	HTML.AddCommand('/table');
	HTML.HorizontalRule;

	if FileExists(RootDir + 'images\' + DelFileExt(ExtractFileName(FileName)) + '.png') then
	begin
		HTML.AddBody('<h2>Graf</h2>');
		HTML.AddImage(RootDir + 'images\' + DelFileExt(ExtractFileName(FileName)) + '.png');
		HTML.HorizontalRule;
	end;

	HTML.AddBody('<h2>Pouit data</h2>');
	s := '';
	for i := 0 to DataCount - 1 do
		s := s + FToS(Data[i]) + '; ';
	SetLength(s, Length(s) - 2);

	HTML.AddBody(s);

	FreeAndNil(HTML);
{$endif}
end;

procedure TfMain.GenerateResultStats1Click(Sender: TObject);
{$ifdef ResultStats}
const
	Step = 100;
	OutputDir = 'C:\My Documents\www\safrad.webzdarma.cz\Elo\';
type
	PGameStat = ^TGameStat;
	TGameStat = packed record // 8
		WhiteELO, BlackELO: U2;
		Result: F4;
//    Reserved: array[0..2] of U1;
	end;
var
	ResultCount: array[0..4] of UG;
	Status: SG;
	Output: string;
	PGNFileName: TFileName;
	PGNData: string;
	i, j, GameIndex: SG;
	FileName: TFileName;
	WE, BE: SG;
	RealF, TheorF: Extended;
	Count: UG;
	G: PGame;
	GameStat: TData;
	GS: PGameStat;
	Suma: Double;
	s2: Double;
	AvgSum: Double;
	MinELO, MaxELO: SG;
	D: SG;
//  Groups: array[0..99] of TG

	FileNames: TFileNames;
	FileNameCount: SG;
	FileIndex: SG;

	Data: array of FG;
	DataCount: UG;

	{$ifdef ResultStats}
	// Chart
	Chart: TChart;
	ASeries: TLineSeries;
	Bmp: TDBitmap;
	{$endif}

	// HTML
	HTML: THTML;
	s: string;

begin
	BeginLongOperation;
	RootDir := OutputDir;

	FillChar(ResultCount, SizeOf(ResultCount), 0);
	RealF := 0;
	TheorF := 0;
	DataCount := 0;
	SetLength(Data, 65536 * 2);

	// Load
	GameStat := TData.Create;
	GameStat.ItemSize := SizeOf(TGameStat);

	ReadDir(FileNames, FileNameCount, DataDir, '.PGN', True, False, True, False);
	for FileIndex := 0 to FileNameCount - 1 do
	begin
		PGNFileName := DataDir + FileNames[FileIndex];//'C:\Chess\Games=-\CT-May-2004.pgn';
		ReadStringFromFile(PGNFileName, PGNData);
		UnspecGameType := gtChess;
		StringToGame(PGNData);

		G := Game.Games.GetFirst;
		Games.Update;
		for GameIndex := 0 to Games.Count - 1 do
		begin
			Status := SG(G.GameTermination);

			if Status <> 0 then
			begin
				WE := StrToValI(G.PGNTags[ptWhiteElo], False, 0, 0, MaxInt, 1);
				BE := StrToValI(G.PGNTags[ptBlackElo], False, 0, 0, MaxInt, 1);
				if (WE > 0) and (BE > 0) then
				begin
					TheorF := TheorF + ArcElo(WE + 59 - BE);

					GS := GameStat.Add;
					GS.WhiteELO := WE;
					GS.BlackELO := BE;
					GS.Result := 3 - (Status - 1) / 2;
					case Status of
					1: GS.Result := 1;
					2: GS.Result := 0.5;
					3: GS.Result := 0;
					end;
					if Status <> 2 then
					begin
						Data[DataCount] := GS.Result;
						Inc(DataCount);
					end;
					case Status of
					1, 2, 3: RealF := RealF + (GS.Result);
					end;
				end;
			end;

			Inc(ResultCount[Status]);

			Inc(SG(G), Game.Games.ItemMemSize);
		end;
//    FreeAndNil(Game.Games);
	end;
//  DataCount := 100;
	SetLength(Data, DataCount);

	HTML := THTML.Create(OutputDir + 'All.html');
	HTML.Title := 'Kompletn pouit data';
	HTML.AddCommand('table border="1"');
	HTML.AddCommand('tr');
	HTML.AddDataCell('<b>Elo blho</b>');
	HTML.AddDataCell('<b>Elo ernho</b>');
	HTML.AddDataCell('<b>Vsledek</b>');
	HTML.AddCommand('/tr');
	GS := GameStat.GetFirst;
	for i := 0 to DataCount - 1 do
	begin
		HTML.AddCommand('tr');
		HTML.AddDataCell(NToHTML(GS.WhiteElo, False));
		HTML.AddDataCell(NToHTML(GS.BlackElo, False));
		case Round(2 * GS.Result) of
		0: s := '0&thinsp;:&thinsp;1';
		1: s := '&frac12;&thinsp;:&thinsp;&frac12;';
		2: s := '1&thinsp;:&thinsp;0';
		end;
		HTML.AddDataCell(s);
		HTML.AddCommand('/tr');
		Inc(SG(GS), GameStat.ItemMemSize);
	end;
	HTML.AddCommand('/table');
	FreeAndNil(HTML);

	StatDataToHTML(Data, OutputDir + 'Stat.html');

	Suma := 0;
	MinELO := High(MinELO);
	MaxELO := Low(MinELO);
	GS := GameStat.GetFirst;
	D := 0;
	for i := 0 to GameStat.Count - 1 do
	begin
		if GS.WhiteELO < MinELO then
			MinELO := GS.WhiteELO
		else if GS.WhiteELO > MaxELO then
			MaxELO := GS.WhiteELO;
		if GS.BlackELO < MinELO then
			MinELO := GS.BlackELO
		else if GS.BlackELO > MaxELO then
			MaxELO := GS.BlackELO;

		D := D + GS.WhiteELO - GS.BlackELO;

		Suma := Suma + GS.Result;
		Inc(SG(GS), GameStat.ItemMemSize);
	end;
	AvgSum := Suma / GameStat.Count;

	Suma := 0;
	GS := GameStat.GetFirst;
	for i := 0 to GameStat.Count - 1 do
	begin
		Suma := Suma + Sqr(GS.Result - AvgSum);
		Inc(SG(GS), GameStat.ItemMemSize);
	end;
	s2 := Suma / (GameStat.Count - 1);

	for i := 0 to Length(ResultCount) - 1 do
		Output := Output + 'Total: ' + NToS(ResultCount[i], False) + ListSeparator + ' ' + LineSep;

	Output := Output + 'ELO Theor/Real: ' + FToS(TheorF / GameStat.Count) + ListSeparator + ' ' + FToS(RealF / GameStat.Count);
	Output := Output + ' s2: ' + FToS(s2) + ListSeparator;
	Output := Output + ' Dif: ' + FToS(D / GameStat.Count) + ListSeparator;

	FileName := DataDir + 'Stats.txt';
	WriteStringToFile(FileName, Output, False);

	SetLength(Data, 1024);
	DataCount := 0;
	Output := '';
	for j := 0 to 99 do
	begin
		MinElo := 1250 + Step * j;
		MaxElo := MinELo + Step - 1;
		if MinElo >= 2800 then Break;
		GS := GameStat.GetFirst;
		Suma := 0;
		Count := 0;
		ResultCount[0] := 0;
		ResultCount[1] := 0;
		ResultCount[2] := 0;
		for i := 0 to GameStat.Count - 1 do
		begin
{     if (GS.WhiteELO >= MinELO) and (GS.WhiteELO <= MaxELO) and
			(GS.BlackELO >= MinELO) and (GS.BlackELO <= MaxELO) then}
			D := (GS.WhiteELO + GS.BlackELO) div 2;
			if (D >= MinELO) and (D <= MaxELO) {and (GS.Result <> 0.5)} then
			begin
				Suma := Suma + GS.Result;
				Inc(ResultCount[Round(2 * GS.Result)]);
				Inc(Count);
			end;
			Inc(SG(GS), GameStat.ItemMemSize);
		end;
		if Count > 0 then
		begin
			AvgSum := Suma / Count;
			Data[DataCount] := AvgSum;
			Inc(DataCount);
		end
		else
			AvgSum := -1;
		if Count > 0 then
		Output := Output + NToS(MinELO) + '..' + NToS(MaxELO) + ': ' + FToS(AvgSum) + ' (' + NToS(Count) + ',' +
			NToS(100 * ResultCount[2] div Count) + '+ ,' + NToS(100 * ResultCount[0] div Count) + '- ' +
			NToS(100 * ResultCount[1] div Count) + '=)' + LineSep;
//      NToS(ResultCount[2]) + '+ ,' + NToS(ResultCount[0]) + '- ' + NToS(ResultCount[1]) + '=)' + LineSep;
	end;
	// var X = 1 / 12
	SetLength(Data, DataCount);
	Chart := TChart.Create(Self);
	Chart.Width := 800;
	Chart.Height := 600;
	Chart.View3D := False;
//  Chart.Color := clWhite;
	HTMLStyle(Chart);
//  Chart.LeftWall.Color := clWhite;

	Chart.Title.Text.Clear;
	Chart.Title.Text.Add('Zvislost spnosti F na Elu hr');
	Chart.SeriesList.Clear;
	Chart.Legend.Visible := False;
	Chart.BottomAxis.Title.Caption := 'Elo';
	Chart.LeftAxis.Title.Caption := 'spnost F';
	Chart.LeftAxis.AutomaticMinimum := False;
	Chart.LeftAxis.AutomaticMaximum := False;
	Chart.LeftAxis.Increment := 0.1;  uDIni
	Chart.LeftAxis.Minimum := 0;
	Chart.LeftAxis.Maximum := 1;

	ASeries := TLineSeries.Create(Self);
	ASeries.SeriesColor := clBlue;
	ASeries.Stairs := True;

	Bmp := TDBitmap.Create;
	Bmp.SetSize(Chart.Width, Chart.Height);
	for i := 0 to DataCount - 1 do
	begin
		ASeries.AddXY(1250 + Step * i, Data[i]);
	end;
	Chart.AddSeries(ASeries);
	Chart.Draw(Bmp.Canvas, Bmp.GetRect);
	Bmp.SaveToFile(ImagesDir + 'StatE.png');
	Bmp.Free;

	FreeAndNil(Chart);

	StatDataToHTML(Data, OutputDir + 'StatE.html');


	FileName := DataDir + 'Groups.txt';
	WriteStringToFile(FileName, Output, False);

	// Free
	FreeAndNil(GameStat);
	EndLongOperation;
{$else}
begin
{$endif}
end;

procedure TfMain.SpeedMark1Click(Sender: TObject);
const
	Rep = 100;
	TestString: array[0..1] of string = ('move generations', 'do-back move');
var
	Tim, STim: U4;
	Count: U8;
	i: SG;
	Tag: SG;
	HPos: TPos;
	s: string;
begin
	if (Kinds.Count > 0) and (GameType <> gkNone) then
	begin
		BeginLongOperation;
		//Tag := TMenuItem(Sender).Tag;
		for Tag := 0 to 1 do
		begin
			CopyPos(CPos, HPos);
			CopyPos(Game.Pos, CPos);
			if Tag <> 0 then
			begin
				if OMC <= 0 then Break;
				PCMove := PMove(@OMove);
			end;
			Count := 0;
			STim := GetTickCount;
			repeat
				if Tag = 0 then
				begin
					for i := 0 to Rep - 1 do
						GenerateMoves;
				end
				else
				begin
					for i := 0 to Rep - 1 do
					begin
						DoMove;
						BackMove(Game.Pos);
					end;
				end;
				Inc(Count);
				Tim := GetTickCount - STim;
			until Tim >= Second;

			CopyPos(HPos, CPos);

			s := s + NToS(RoundDivU8(Second * Rep * Count, Tim)) + ' ' + TestString[Tag] + ' / sec' + LineSep;
		end;
		EndLongOperation(False);
		MessageD(s, mtInformation, [mbOk]);
	end;
end;

procedure TfMain.SlidePiecesTime1Click(Sender: TObject);
begin
	if GetTime('Slide Time', SlideTime, 0, DefSlideTime, MaxTime, nil) then
		InitMenuEngine;
end;

procedure TfMain.PositionSetup2Click(Sender: TObject);
begin
	if not Assigned(fSetup) then fSetup := TfSetup.Create(Self);
	fSetup.Visible := not fSetup.Visible;
end;

procedure TfMain.NodesTime1Click(Sender: TObject);
begin
	NodesTime1.Checked := not NodesTime1.Checked;
	NodesTime := NodesTime1.Checked;
	DrawLabelTimeNodes;
	DrawNodes;
	DrawAMoves;
end;

procedure TfMain.TimeMove1Click(Sender: TObject);
begin
	TimePerMove := not TimePerMove;
	TimeMove1.Checked := TimePerMove;
	DrawMoves;
	UpdateIcons(fMain.MainMenu, fMain.PanelTool);
end;

procedure TfMain.EngineParameter1Click(Sender: TObject);
begin
	OptionClick(eoMultiPV);
end;

procedure TfMain.RandomValue1Click(Sender: TObject);
begin
	OptionClick(eoRandomValue);
end;

procedure TfMain.ECOPositions1Click(Sender: TObject);
begin
	MessageD('Book contains ' + NToS(BHashStat.Added) + ' positions with transpositions', mtInformation, [mbOk]);
end;

procedure TfMain.EnterMoves1Click(Sender: TObject);
var
	HPos: TPos;
	s, ErrorS: string;
	InLineIndex: SG;
begin
	if GetStr('Enter Moves', MoveString, '', 0) then
	begin
		CopyPos(CPos, HPos);
		CopyPos(Game.Pos, CPos);
		ErrorS := '';
		InLineIndex := 1;
		while InLineIndex <= Length(MoveString) do
		begin
			GenerateMoves;
			RemoveIllegalMoves;
			s := StrToMove(MoveString, InLineIndex, GetNotation(Notation));
			if s = '' then
			begin
				DoImportMove(AMin, False);
				CopyPos(Game.Pos, CPos);
			end
			else
			begin
				if Length(ErrorS) < 1024 then
					ErrorS := ErrorS + s + LineSep;
			end;
			Inc(InLineIndex);
		end;
		if ErrorS <> '' then
			MessageD(ErrorS, mtError, [mbOk]);
		CopyPos(HPos, CPos);
	end;
end;

procedure TfMain.AcceptBookValue1Click(Sender: TObject);
begin
	OptionClick(eoBookAccept);
end;

procedure TfMain.AutoFlag1Click(Sender: TObject);
begin
	AutoFlag := not AutoFlag;
	AutoFlag1.Checked := AutoFlag;
end;

procedure TfMain.ScoreForFirstPlayer1Click(Sender: TObject);
begin
	ScoreForFirstPlayer := not ScoreForFirstPlayer;
	ScoreForFirstPlayer1.Checked := ScoreForFirstPlayer;
	DrawMoveScore1;
	DrawAlphaBeta;
	DrawEnabledMoves;
	DrawAMoves;
end;

procedure TfMain.SideToMove1Click(Sender: TObject);
begin
	SideToMove := not SideToMove;
	SideToMove1.Checked := SideToMove;
	DrawBoards;
end;

procedure TfMain.PromoteToFigure1Click(Sender: TObject);
begin
	DefaultPromote := TMenuItem(Sender).Tag;
	PromoteTo1.Items[DefaultPromote].Checked := True;
end;

procedure TfMain.SaveAs2Click(Sender: TObject);
var
	HFilter: string;
begin
	HFilter := SaveDialog1.Filter;
	if ExecuteDialog(SaveDialog1, AnalysisFile) then
		WriteAnalysisToFile(AnalysisFile);
	SaveDialog1.Filter := HFilter;
	InitMenuAnalysis;
end;

procedure TfMain.Open2Click(Sender: TObject);
var
	HFilter: string;
begin
	HFilter := OpenDialog1.Filter;
	OpenDialog1.Filter := 'Any analysis (*.dat)|*.dat|Any file (*.*)|*.*';
	if ExecuteDialog(OpenDialog1, AnalysisFile) then
	begin
		AnalysisFile := OpenDialog1.FileName;
		ReadAnalysisFromFile(AnalysisFile);
		DrawAMoves;
	end;
	OpenDialog1.Filter := HFilter;
end;

procedure TfMain.GameECO1Click(Sender: TObject);
begin
	ShowGameECO := not ShowGameECO;
	GameECO1.Checked := ShowGameECO;
	DrawEnabledMoves;
end;

procedure TfMain.ECO1Click(Sender: TObject);
begin
	ShowECO := not ShowECO;
	ECO1.Checked := ShowECO;
	DrawEnabledMoves;
end;

procedure TfMain.ResignValue1Click(Sender: TObject);
begin
	if GetNumber('Resign Score', ResignScore, -scMax, DefResignScore, {$ifopt d+}scMax{$else}scAdvance{$endif}, nil) then
	begin
		InitMenuEngine;
	end;
end;

procedure TfMain.CommonLevels1Click(Sender: TObject);
begin
	if TMenuItem(Sender).Checked = False then
	begin
		Game.SeparatedLevel := TMenuItem(Sender).Tag;
		InitLevel;
		ChangeLevel;
	end;
end;

procedure TfMain.DeleteAllX1Click(Sender: TObject);
var
	Mv: PGameMoves;
	M: PGameMove;
	i: SG;
begin
	i := TMenuItem(Sender).Tag;
	Mv := Game.FirstMove;
	while Mv <> nil do
	begin
		GenerateMoves;
		M := @Mv.Moves[Mv.Actual];
		case i of
		0:
		begin
			M.CommentBefore := '';
			M.CommentAfter := '';
		end;
		1:
		begin
			M.Mark[0] := mmNone;
			M.Mark[1] := mmNone;
			M.Mark[2] := mmNone;
		end;
		2: M.MovTime := 0;
		3:
		begin
			ClearAnalysisInfo(M.AnalysisInfo);
			ClearAnalysis(M.Analysis);
		end;
		end;
		Mv := M.Moves;
	end;
	case i of
	0:
	begin
		DrawComment;
	end;
	1: DrawMoves;
	2: DrawMoves;
//  3: DrawAMoves;
	end;
	KindsChange;
end;

procedure TfMain.GameAnalysis1Click(Sender: TObject);
begin
	if Where = whNone then
	begin
		Where := whTN;
		GoToMoveDraw(MaxInt);
		while True do
		begin
			RunEngine;
			if Game.Pos.MoveIndex <= Game.Variant.Pos.MoveIndex then Exit;
			GoToMoveDraw(Game.Pos.MoveIndex - Game.Variant.Pos.MoveIndex - 1);
		end;
	end;
end;

procedure TfMain.NewGame1Click(Sender: TObject);
var
	G: PGame;
begin
	if Games.Count <= 0 then
		G := nil
	else
		G := Games.Get(Games.Index);
	if NewSubGameDialog(G) then
	begin
		KindsChange;
		GameChanged;
	end;
end;

procedure TfMain.DeleteGame1Click(Sender: TObject);
var
	GamesIndex, i, j: SG;
begin
	if Assigned(fPGN) then
	begin
		GamesIndex := Games.Index;
		Games.Index := -1;
		if Sender = MainMenu then
			Games.Delete(GamesIndex)
		else
		begin
			j := 0;
			for i := 0 to fPGN.DViewGames.RowCount - 1 do
			begin
				if fPGN.DViewGames.SelRows[i] then
					Games.Delete(j)
				else
					Inc(j);
			end;
		end;

		if Games.Count > 0 then
			Games.Index := 0;
		KindsChange;
		GameChanged;
	end;
end;

procedure TfMain.UpDown1Click(Sender: TObject);
var LIndex, LIndex2: SG;
begin
	LIndex := Games.Index;
	LIndex2 := LIndex + TComponent(Sender).Tag;
	if (LIndex2 >= 0) and (LIndex2 < SG(Games.Count)) then
	begin
		Games.Index := -1;
		Games.Swap(LIndex, LIndex2);
		Games.Index := LIndex2;
		KindsChange;
		GameChanged;
	end;
end;

procedure TfMain.Previous1Click(Sender: TObject);
begin
	if Games.Index > 0 then
	begin
		Games.Index := Games.Index - 1;
		GameChanged;
	end;
end;

procedure TfMain.Next1Click(Sender: TObject);
begin
	if UG(Games.Index + 1) < Games.Count then
	begin
		Games.Index := Games.Index + 1;
		GameChanged;
	end;
end;

procedure TfMain.Compact1Click(Sender: TObject);
var
	i: SG;
	Tg: SG;
	B: BG;
	M: TMenuItem;
//  F: TDForm;
begin
	TG := TMenuItem(Sender).Tag;
{ for i := 0 to Application.ComponentCount - 1 do
	begin
		if Application.Components[i] is TDForm then
		begin
			F := TDForm(Application.Components[i]);
			if F.BorderStyle = bsSizeToolWin then F.BorderStyle := bsToolWindow;
		end;
	end;}
	for i := 0 to 9 do
	begin
		M := View1.Items[i + 1 + NN80.MenuIndex];
		case TG of
		0: // Compact
			if M.Name = 'Board2' then B := True else B := False;
		1: // Standard
		begin
			if (M.Name = 'PGN2')
			or (M.Name = 'Information2')
			or (M.Name = 'PositionSetup2')
			or (M.Name = 'Comment2')

			then B := False else B := True;
		end;
		else // Full
			B := True;
		end;
		if M.Checked <> B then
			M.Click;
	end;
end;

procedure TfMain.PanelToolResize(Sender: TObject);
begin
	IconsResize(PanelTool);
end;

procedure TfMain.PauseClock1Click(Sender: TObject);
begin
	SetTimeGo(tgPause);
end;

procedure TfMain.IncrementalTime1Click(Sender: TObject);
begin
	if GetTime('Incremental Time', Game.Levels[Game.SeparatedLevel].IncTime, 0, 2 * Second, MaxTime, nil) then
		InitMenuLevel;
end;

procedure TfMain.Parameters1Click(Sender: TObject);
begin
	if not Assigned(fEngineP) then fEngineP := TfEngineP.Create(Self);
	ChangeEngine;
	fEngineP.Visible := not fEngineP.Visible;
end;

procedure TfMain.ActiveAndTarget1Click(Sender: TObject);
begin
	SquareHighlight := TMenuItem(Sender).Tag;
	SquareHighlight1.Items[TMenuItem(Sender).Tag].Checked := True;
	DrawBoards;
end;

procedure TfMain._BookFile1Click(Sender: TObject);
begin
	OptionClick(eoBookFile);
end;

procedure TfMain.AutomaticNewGame1Click(Sender: TObject);
begin
	AutomaticNewGame := not AutomaticNewGame;
	AutomaticNewGame1.Checked := AutomaticNewGame;
end;

procedure TfMain.BeforeNewGame1Click(Sender: TObject);
begin
	SaveBeforeNewGame := not SaveBeforeNewGame;
	BeforeNewGame1.Checked := SaveBeforeNewGame;
end;

procedure TfMain.RestartClock1Click(Sender: TObject);
begin
	SetTimeGo(tgNone);
	SetTimeGo(tgGame);
end;

procedure TfMain.WideVariants1Click(Sender: TObject);
begin
	WideVariants := not WideVariants;
	WideVariants1.Checked := WideVariants;
	DrawMoves;
end;

procedure TfMain.TimeStrategy1Click(Sender: TObject);
begin
	TimeStrategy := not TimeStrategy;
	TimeStrategy1.Checked := TimeStrategy;
	if FormDraw(fClock) then
	begin
		DrawTimeStrategy;
		fClock.UpdateAnalog;
		fClock.ResizeMessage;
	end;
	UpdateIcons(fMain.MainMenu, fMain.PanelTool);
end;

procedure TfMain.FirstGame1Click(Sender: TObject);
begin
	if Games.Index <> 0 then
	begin
		Games.Index := 0;
		GameChanged;
	end;
end;

procedure TfMain.LastGame1Click(Sender: TObject);
begin
	if UG(Games.Index + 1) <> Games.Count then
	begin
		Games.Index := Games.Count - 1;
		GameChanged;
	end;
end;

procedure TfMain.FileExtensions1Click(Sender: TObject);
begin
	FormFileExt;
end;

procedure TfMain.ImageToFEN1Click(Sender: TObject);
{$ifopt d+}
var
	B, Bmp: TDBitmap;
	x, y, xc, yc, PieceIndex: SG;
	BorderX, BorderY: array[0..99] of SG;
	Dif, MinDif: UG;
	D: array[0..1024] of U4;
	C0, C1: TRGBA;
	BoardSize: TBoardSize;
	Size: SG;
	BackColor: TColor;
	s: string;
	Index: SG;
begin
	Kinds.New1.Click;
	if Kinds.Count > 0 then
	begin
		B := TDBitmap.Create('C:\Upload\sachy\root\clanky\Franta\stross1.jpg');

		// 1 Grate
		// 1.1X Analyse
		FillChar(D, SizeOf(D), 0);
		for y := 0 to B.Height - 1 do
		begin
			GetPix(B.Data, B.ByteX, 0, y, C0);
			for x := 0 to B.Width - 2 do
			begin
				GetPix(B.Data, B.ByteX, x + 1, y, C1);
				D[x] := D[x] + UG(Abs(C0.R - C1.R)) + UG(Abs(C0.G - C1.G)) + UG(Abs(C0.B - C1.B));
				C0 := C1;
			end;
		end;
		// 1.2X Maximum
		Dif := Low(MinDif);
		for x := 0 to B.Width - 2 do
		begin
			if D[x] > Dif then Dif := D[x];
		end;
		// 1.3X.Create
		Dif := 2 * Dif div 4; // Calibrate
		xc := 0;
		for x := 0 to B.Width - 2 do
		begin
			if D[x] > Dif then
			begin
				BorderX[xc] := x;
				Inc(xc);
			end;
		end;

		// 1.1Y Analyse
		FillChar(D, SizeOf(D), 0);
		for x := 0 to B.Width - 1 do
		begin
			GetPix(B.Data, B.ByteX, x, 0, C0);
			for y := 0 to B.Height - 2 do
			begin
				GetPix(B.Data, B.ByteX, x, y + 1, C1);
				if Abs(C0.R - C1.R) + Abs(C0.G - C1.G) + Abs(C0.B - C1.B) > 200{Calibrate} then
					D[y] := D[y] + 1; // Zlom
				C0 := C1;
			end;
		end;
		// 1.2Y Maximum
		Dif := Low(MinDif);
		for x := 0 to B.Height - 2 do
		begin
			if D[x] > Dif then Dif := D[x];
		end;
		// 1.3Y.Create
		Dif := 7 * Dif div 8; // Calibrate
		yc := 0;
		for x := 0 to B.Height - 2 do
		begin
			if D[x] > Dif then
			begin
				BorderY[yc] := x;
				Inc(yc);
			end;
		end;

		// 2 compare
		BoardSize.Width := 360;
		BoardSize.Height := 360;
		BoardSize.BorderSize := BorderX[0];
		BoardSize.SquareBorderSize := 0;

		s := '';
		Bmp := TDBitmap.Create;
		for y := 0 to yc - 2 do
		for x := 0 to xc - 2 do
		begin
			MinDif := High(MinDif);
//      GetPix(B.Data, B.ByteX, BorderX[x + 1] - 2, BorderY[y + 1] - 2, C0);
			GetPix(B.Data, B.ByteX, BorderX[x] + 3, BorderY[y] + 3, C0);
//      BackColor := MixColors(C0.L, C1.L);
			BackColor := C0.L;
			for PieceIndex := -PieceTypes to PieceTypes do
			begin
				Size := BorderX[x + 1] - BorderX[x];
				ReqPieceSize[4] := 4 * Size div 5;
				BoardSize.SquareSize := Size;
	//      FillBoardSize(BoardSize, 4);
				Bmp.SetSize(Size, Size);
				Bmp.Transparent := False;
	{     if (x and 1) = (y and 1) then
					BackColor := C;
				else
					BackColor := PieceSet.DarkSquare.Colors[0];}
				Bmp.Bar(BackColor, ef16);
				if PieceIndex <> 0 then
					DrawPiece(@BoardSize, Bmp, 0, 0, PieceIndex, 4, 1);

// i := Abs(i);
//        Bmp.SaveToFile('C:\x.bmp');
				// Bmp is transparent, B not
				BitmapDif := 0;
				B.Bmp(BorderX[x] + 1, BorderY[y] + 1, Bmp, 0, 0, Size - 1, Size - 1, efDif);
				if BitmapDif < MinDif then
				begin
					MinDif := BitmapDif;
					Index := XYToI(x, yc - 2 - y);
					if Index <> 0 then
						Game.Variant.Pos.Board[Index] := PieceIndex;
				end;
			end;
		end;
		Bmp.Free;
		B.Free;

		KindsChange;
		GameChanged;
	end;
{$else}
begin
{$endif}
end;

procedure TfMain.CommonParameters1Click(Sender: TObject);
begin
	if TMenuItem(Sender).Checked = False then
	begin
		Game.SeparatedEngine := TMenuItem(Sender).Tag;
		InitEngine;
		ChangeEngine;
	end;
end;

procedure TfMain.SwapPlayers1Click(Sender: TObject);
begin
	Exchange(Game.PGNTags[ptWhite], Game.PGNTags[ptBlack]);
	Exchange(Game.PGNTags[ptWhiteTitle], Game.PGNTags[ptBlackTitle]);
	Exchange(Game.PGNTags[ptWhiteELO], Game.PGNTags[ptBlackELO]);
	Exchange(Game.PGNTags[ptWhiteUSCF], Game.PGNTags[ptBlackUSCF]);
	Exchange(Game.PGNTags[ptWhiteNA], Game.PGNTags[ptBlackNA]);
	Exchange(Game.PGNTags[ptWhiteType], Game.PGNTags[ptBlackType]);
	Exchange(Game.PGNTags[ptWhiteTeam], Game.PGNTags[ptBlackTeam]);
	Exchange(Game.PGNTags[ptWhiteTeamCountry], Game.PGNTags[ptBlackTeamCountry]);
	Exchange(Game.PlayerTypes[0], Game.PlayerTypes[1]);

	InitMenuPlayerTypes;
	DrawWhoPlay;
	InitGameInfo;
	InitPGN;
end;

procedure TfMain.AroundBoard1Click(Sender: TObject);
begin
	Coordinates := TCoordinatesPosition(TMenuItem(Sender).Tag);
	Coordinates1.Items[TMenuItem(Sender).Tag].Checked := True;
	FreeBoards;
	DrawBoards;
end;

procedure TfMain.Size1Click(Sender: TObject);
begin
	GetNumber('Saved Width', SavedWidth, 1, 800, MaxBitmapWidth, nil);
	GetNumber('Saved Height', SavedHeight, 1, 600, MaxBitmapHeight, nil);
end;

end.