//* File:     SDG\uLevels.pas
//* Created:  1997-01-01
//* Modified: 2005-11-08
//* Version:  2.1.35.309
//* Author:   Safranek David (Safrad)
//* E-Mail:   safrad at email.cz
//* Web:      http://safrad.webzdarma.cz

unit uLevels;

interface

uses
	uTypes, uDForm, uGame, uEngine, uDIni,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, uDButton, ExtCtrls;

type
	TfLevels = class(TDForm)
		ButtonApply: TDButton;
		ButtonCancel: TDButton;
		RBInfinite: TRadioButton;
		RBFixedDepth: TRadioButton;
		RBHourglass: TRadioButton;
		RBMinimal: TRadioButton;
		RBTimeControls: TRadioButton;
		RBShortestWin: TRadioButton;
		RBWinIn: TRadioButton;
		ComboBoxFixedDepth: TComboBox;
		ComboBoxWinIn: TComboBox;
		ComboBoxControlCount: TComboBox;
		LabelTime: TLabel;
		LabelMoves: TLabel;
		ComboBoxTimeNodes: TComboBox;
		Bevel2: TBevel;
		Bevel3: TBevel;
		Bevel4: TBevel;
		RBEqual: TRadioButton;
		ComboBoxTim: TComboBox;
		RBAverage: TRadioButton;
		ComboBoxIncTime: TComboBox;
		LabelIncTime: TLabel;
		RBMaximal: TRadioButton;
		ComboBoxNodes: TComboBox;
		ButtonOK: TDButton;
		LabelTemplate: TLabel;
		ComboBoxTemplate: TComboBox;
		Bevel1: TBevel;
		EditLevel: TEdit;
		Bevel5: TBevel;
		LabelFreeTime: TLabel;
		ComboBoxFreeTime: TComboBox;
		Bevel6: TBevel;
		Bevel7: TBevel;
		Bevel8: TBevel;
		Bevel9: TBevel;
		Bevel10: TBevel;
		Bevel11: TBevel;
		Bevel12: TBevel;
		Bevel13: TBevel;
		Bevel14: TBevel;
		Bevel15: TBevel;
		Label1: TLabel;
		procedure FormCreate(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure ButtonApplyClick(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure ButtonCancelClick(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure ButtonOKClick(Sender: TObject);
		procedure ComboBoxTemplateChange(Sender: TObject);
		procedure ComponentChanged(Sender: TObject);
		procedure EditLevelChange(Sender: TObject);
	private
		{ Private declarations }
		DisableChange: BG;
		Level: TLevel;
		ComboBoxTime: array[0..MaxControl] of TComboBox;
		ComboBoxMoveC: array[0..MaxControl - 1] of TComboBox;
		procedure FormToData;
		procedure DataToForm(Sender: TObject);
	public
		{ Public declarations }
	end;

const
	MaxTemplate = 18;
	TemplateLevels: array[0..MaxTemplate] of TLevel = (
		(Typ: ltUnknown),
		(Typ: ltTimeControls; IncTime: 0; ControlCount: 1; ControlTime: (5 * Minute, 0, 0, 0)),
		(Typ: ltTimeControls; IncTime: 0; ControlCount: 1; ControlTime: (25 * Minute, 0, 0, 0)),
		(Typ: ltTimeControls; IncTime: 0; ControlCount: 2; ControlTime: (2 * Hour, 1 * Hour, 0, 0); ControlMoveCount: (40, 0, 0)),
		(Typ: ltTimeControls; IncTime: 0; ControlCount: 3; ControlTime: (2 * Hour, 1 * Hour, 30 * Minute, 0); ControlMoveCount: (40, 20, 0)),
		(Typ: ltTimeControls; IncTime: 2 * Second; ControlCount: 1; ControlTime: (3 * Minute, 0, 0, 0)),
		(Typ: ltTimeControls; IncTime: 5 * Second; ControlCount: 1; ControlTime: (20 * Minute, 0, 0, 0)),
		(Typ: ltTimeControls; IncTime: 10 * Second; ControlCount: 1; ControlTime: (1 * Hour, 0, 0, 0)),
		(Typ: ltTimeControls; IncTime: 20 * Second; ControlCount: 1; ControlTime: (2 * Hour, 0, 0, 0)),
		(Typ: ltTimeControls; IncTime: 20 * Second; ControlCount: 2; ControlTime: (90 * Minute, 30 * Minute, 0, 0); ControlMoveCount: (40, 0, 0)),
		(Typ: ltTimeControls; IncTime: 20 * Second; ControlCount: 2; ControlTime: (2 * Hour, 1 * Hour, 0, 0); ControlMoveCount: (40, 0, 0)),
		(Typ: ltTimeControls; FreeTime: 3 * Second; ControlCount: 1; ControlTime: (5 * Minute, 0, 0, 0)),
		(Typ: ltTimeControls; FreeTime: 10 * Second; ControlCount: 1; ControlTime: (20 * Minute, 0, 0, 0)),
		(Typ: ltTimeControls; IncTime: 2 * Second; ControlCount: 1; ControlTime: (3 * Minute, 0, 0, 0)),
		(Typ: ltTimeControls; IncTime: 10 * Second; ControlCount: 1; ControlTime: (20 * Minute, 0, 0, 0)),
		(Typ: ltTimeControls; IncTime: 1 * Minute; ControlCount: 3; ControlTime: (80 * Minute, 40 * Minute, 80 * Minute, 0); ControlMoveCount: (40, 20, 0)),
		(Typ: ltHourglass; TimeNodes: False; Time: 1 * Minute),
		(Typ: ltEqual; TimeNodes: False; Time: 10 * Second),
		(Typ: ltTimeControls; IncTime: 12 * Second; ControlCount: 1; ControlTime: (2 * Minute, 0, 0, 0))
	);
var
	TemplateNames: array[0..MaxTemplate] of string = (
		'Unknown',
		'Blitz',
		'Rapid',
		'Long',
		'Long',
		'FIDE rapid',
		'FIDE rapid',
		'FIDE rapid',
		'FIDE rapid',
		'FIDE tournament',
		'FIDE tournament',
		'Bronstein',
		'Bronstein',
		'Fisher rapid',
		'Fisher rapid',
		'Fisher tournament',
		'Hour-glass',
		'Gong',
		'Internet'
{   'Blitz (5 min)',
		'Rapid (25 min)',
		'2 hrs / 40 + 1 hr',
		'2 hrs / 40 + 1 hr / 20 + 30 min',
		'FIDE rapid 3 min, 2 sec / move',
		'FIDE rapid 20 min, 5 sec / move',
		'FIDE rapid 1 hr, 10 sec / move',
		'FIDE rapid 2 hr, 20 sec / move',
		'FIDE tournament 1:30 / 40 + 30, 20sec / move',
		'FIDE tournament 2 hrs / 40 + 1 hr, 20sec / move',
		'Bronstein 5 min, 3 sec / move',
		'Bronstein 20 min, 10 sec / move',
		'Fisher rapid 3 min, 2 sec / move',
		'Fisher rapid 20 min, 10 sec / move',
		'Fisher tournament 80 min/40, 40 min/20, 1min/move',
		'Hour-glass 1 min',
		'Gong 10 sec',
		'Internet 2 min, 12 sec / move'}
{   'Go with byo-yomi 1 hr + 1x20sec',
		'Go with byo-yomi 2 hr + 1x30sec',}
	);

procedure InitTimeLimit;
procedure DrawTimeStrategy;
procedure InitMenuLevel;
procedure CopyLevel(SL, DL: PLevel);
function LevelToStr(Level: PLevel; UseWinFormat: BG): string;
function NotEmpty(const s: string): BG;
procedure StrToLevel(s: string; Level: PLevel);

var
	fLevels: TfLevels;
	LevelsIni: TDIniFile;

procedure ChangeLevel;
procedure RWLevels(MainIni: TDIniFile; const Save: BG);

implementation

{$R *.dfm}
uses
	Math,
	uETypes,
	uMain, uClock, uMath, uPGN,
	uInput, uFormat, uStrings, uMenus;

(*-------------------------------------------------------------------------*)
var
	SRemainMoves: SG;
procedure DrawTimeStrategy;
var s: string;
begin
	if FormDraw(fClock) then
	begin
		if TimeStrategy then
//    if (RemainMoves <> SRemainMoves) then
		begin
			SRemainMoves := RemainMoves;
			if (TimeLimitAvg <> High(TimeLimitAvg)) or (TimeLimitMax <> High(TimeLimitMax)) then
				s := s + 'Time / move - ';
			if TimeLimitAvg <> High(TimeLimitAvg) then
				s := s + ' | Avg: ' + MsToStr(TimeLimitAvg, diSD, Precision, False);
			if TimeLimitMax <> High(TimeLimitMax) then
				s := s + ' | Max: ' + MsToStr(TimeLimitMax, diSD, Precision, False);

			case SRemainMoves of
			0, High(RemainMoves):
				s := s + ''
			else
				s := s + ' | ' + 'Remain ' + NToS(RemainMoves) + ' moves'
			end;
			fClock.PanelTS.Caption := s;
			fClock.PanelTS.ShowHint := True;
			fClock.PanelTS.Hint := 'Game moves - Avg: ' + NToS((GameAvgMoves + 1) div 2) + ', Max: ' + NToS((GameMaxMoves + 1) div 2);
		end;
	end;
end;
(*-------------------------------------------------------------------------*)
function LevelToStr(Level: PLevel; UseWinFormat: BG): string;
var
	s: string;
	i: SG;
begin
	case Level.Typ of
	ltInfinite:
	begin
		if UseWinFormat then
			s := 'Infinite'
		else
			s := '-';
	end;
	ltFixedDepth:
	begin
		if UseWinFormat then
			s := 'Fixed depth ' + NToS(Level.MaxD)
		else
			s := 'depth ' + IntToStr(Level.MaxD);
	end;
	ltHourglass:
	begin
		if UseWinFormat then
			s := 'Hourglass ' + MsToStr(Level.Time, diMSD, -3, False)
		else
			s := '*' + FloatToStr(Level.Time / 1000);
	end;
	ltMinimal, ltAverage, ltEqual, ltMaximal:
	begin
		if UseWinFormat then
		begin
			case Level.Typ of
			ltMinimal: s := 'Minimal ';
			ltAverage: s := 'Average ';
			ltEqual: s := 'Equal ';
			ltMaximal: s := 'Maximal ';
			end;

			if Level.TimeNodes = False then
				s := s + MsToStr(Level.Time, diMSD, -3, False)
			else
				s := s + NToS(Level.Nodes) + ' nodes';
			s := s + ' / move';
		end
		else
			s := '?';
	end;
	ltTimeControls:
	begin
		if UseWinFormat then
		begin
			if Level.ControlCount = 1 then
			begin
				s := MsToStr(Level.ControlTime[0], diMSD, -3, False) + ' / game';
			end
			else
			begin
				s := '';
				for i := 0 to Level.ControlCount - 1 do
				begin
					s := s + MsToStr(Level.ControlTime[i], diMSD, -3, False);
					if i + 1 < Level.ControlCount then
						s := s + ' / ' + NToS(Level.ControlMoveCount[i]) + ', ';
				end;
	//      SetLength(s, Length(s) - 2);
			end;
			if Level.IncTime <> 0 then
				s := s + ', ' + MsToStr(Level.IncTime, diMSD, -3, False) + ' increment';
			if Level.FreeTime <> 0 then
				s := s + ', ' + MsToStr(Level.FreeTime, diMSD, -3, False) + ' free';
		end
		else
		begin
			s := '';
			for i := 0 to Level.ControlCount - 1 do
			begin
				if i + 1 < Level.ControlCount then
					s := s + IntToStr(Level.ControlMoveCount[i]) + '/';
				s := s + FloatToStr(Level.ControlTime[i] / 1000);
				if i < Level.ControlCount - 1 then
					s := s + ':';
			end;
			if Level.IncTime <> 0 then
				s := s + '+' + FloatToStr(Level.IncTime / 1000);
		end;
	end;
	ltShortestWin:
	begin
		if UseWinFormat then
			s := 'Shortest win'
		else
			s := '?';
	end;
	ltWinIn:
	begin
		if UseWinFormat then
			s := 'Win in ' + NToS(Level.WinIn) + ' moves'
		else
			s := '?';
	end
	else
	begin
		if UseWinFormat then
			s := 'Unknown'
		else
			s := '';
	end;
	end;
	Result := s;

{ if Game.Give then
	begin
		s := 'GvAway';
	end
	else
	begin
		s := 'Normal';
	end;}
end;

function NotEmpty(const s: string): BG;
begin
	Result := (s <> '') and (s <> '?')
end;

procedure StrToLevel(s: string; Level: PLevel);
var
	InLineIndex: SG;
	i: SG;
	Time: SG;
begin
	s := UpperCase(s);
	InLineIndex := 1;
	if not NotEmpty(s) then
		Level.Typ := ltUnknown
	else if (s = 'CORRESPONDENCE') or (s = 'INFINITE') or (s = '-') then
		Level.Typ := ltInfinite
	else if s[1] = '*' then
	begin
		Level.Typ := ltHourglass;
		InLineIndex := 2;
		Level.Time := ReadSGFast(s, InLineIndex) * Second;
		Level.IncTime := 0;
		Level.FreeTime := 0;
	end
	else if s[1] in ['0'..'9'] then
	begin
		// 120+6
		// 300
		// 30/5400:0/0:2400
		// 40/7200:20/3600:1800
		// 0:25:00
		// 105/40+25
		// 60/36000:60/36000:60/36000
		// 40/7200:20/3600:1800
		// 30/5400:2400
		Level.Typ := ltTimeControls;
		Level.ControlCount := 1;
		Level.IncTime := 0;
		Level.FreeTime := 0;
//    Level.ContTime[1] := ReadNum(s, InLineIndex) * Sec;
		Time := 2;
		i := 0;
		while InLineIndex <= Length(s) do
		begin
			case s[InLineIndex] of
			':':
			begin
				Level.ControlTime[Level.ControlCount - 1] := i * Second;
				if Level.ControlCount <= MaxControl then
					Inc(Level.ControlCount);
				Time := 0;
				Inc(InLineIndex);
			end;
			'/':
			begin
				if Level.ControlCount <= Length(Level.ControlMoveCount) then
					Level.ControlMoveCount[Level.ControlCount - 1] := i;
				Time := 1;
				Inc(InLineIndex);
			end;
			'0'..'9':
			begin
				i := ReadSGFast(s, InLineIndex);
				Time := 1;
			end;
			'+':
			begin
				Level.ControlTime[Level.ControlCount - 1] := i * Second;
				Time := 2;
				Inc(InLineIndex);
				Level.IncTime := ReadSGFast(s, InLineIndex) * Second;
			end;
			else
				Inc(InLineIndex);
			end;

		end;
		if Time = 1 then
			Level.ControlTime[Level.ControlCount - 1] := i * Second
		else if Time = 0 then
			Level.ControlMoveCount[Level.ControlCount - 1] := i;
	end
	else if Copy(s, 1, 5) = 'DEPTH' then
	begin
		Level.Typ := ltFixedDepth;
		InLineIndex := 6;
		SkipSpace(s, InLineIndex);
		Level.MaxD := Range(0, ReadSGFast(s, InLineIndex), MaxDepth - 1);
	end;
end;

procedure InitMenuLevel;
var
	B: BG;
	Level: PLevel;
	i: SG;
	s: string;
begin
	if Kinds.Count = 0 then Exit;

	fMain.Suicide1.Checked := Game.Variant.Options[voSuicide].Bool;

	fMain.Levels1.Items[Game.SeparatedLevel].Checked := True;

	Level := @Game.Levels[Game.SeparatedLevel];
	if Game.SeparatedLevel = PlayerMax + 1 then
	begin
		s := LevelToStr(Level, True);
	end
	else
	begin
		s := '';
		for i := 0 to PlayerMax do
		begin
			Level := @Game.Levels[i];
			s := s + LevelToStr(@Game.Levels[i], True) + ' | ';
		end;
	end;
	Echo('Time Control: ' + s);

	if Level.Typ = ltUnknown then B := True else B := False;
	fMain.Unknown1.Checked := B;
	fMain.Unknown1.Enabled := not B;
	if Level.Typ = ltInfinite then B := True else B := False;
	fMain.Infinite1.Checked := B;
	fMain.Infinite1.Enabled := not B;
	if Level.Typ = ltFixedDepth then B := True else B := False;
	fMain.FixedDepth1.Checked := B;
	FormatCaption(fMain.FixedDepth1, Level.MaxD);
	if Level.Typ = ltHourglass then B := True else B := False;
	fMain.Hourglass1.Checked := B;

	if (Level.Typ = ltTimeControls)
	and (Level.ControlCount = 1) and (Level.ControlTime[0] = 0) and (Level.IncTime <> 0) then B := True else B := False;
	fMain.LevelMove1.Checked := B;

	if (Level.Typ = ltTimeControls)
	and (Level.ControlCount = 1) and (Level.ControlTime[0] <> 0) and (Level.IncTime = 0) then B := True else B := False;
	fMain.LevelGame1.Checked := B;

	if (Level.Typ = ltTimeControls) and
	(fMain.LevelGame1.Checked = False) and
	(fMain.LevelMove1.Checked = False)
	then B := True else B := False;
	fMain.LevelControls1.Checked := B;

	if Level.Typ = ltMinimal then B := True else B := False;
	B := B and Level.TimeNodes;
	fMain.MinimalNodes1.Checked := B;

	if Level.Typ = ltShortestWin then B := True else B := False;
	fMain.ShortestWin1.Checked := B;
	fMain.ShortestWin1.Enabled := not B;
	if Level.Typ = ltWinIn then B := True else B := False;
	fMain.WinIn1.Checked := B;

	FormatCaption(fMain.IncrementalTime1, Level.IncTime, True);
	FormatCaption(fMain.FreeTime1, Level.FreeTime, True);

	DrawTimeStrategy;
end;

procedure CopyLevel(SL, DL: PLevel);
var
	i: SG;
begin
	DL.Typ := SL.Typ;
	case DL.Typ of
	ltFixedDepth: DL.MaxD := SL.MaxD;
	ltWinIn: DL.WinIn := SL.WinIn;
	ltHourglass: DL.Time := SL.Time;
	ltMinimal,
	ltEqual,
	ltAverage,
	ltMaximal,
	ltTimeControls:
	begin
		case SL.Typ of
		ltMinimal,
		ltEqual,
		ltAverage,
		ltMaximal:
		begin
			DL.TimeNodes := SL.TimeNodes;
			if SL.TimeNodes then
			begin
				DL.Nodes := SL.Nodes;
			end
			else
			begin
				DL.Time := SL.Time;
			end;
		end;
		ltTimeControls:
		begin
			DL.IncTime := SL.IncTime;
			DL.FreeTime := SL.FreeTime;
			DL.ControlCount := SL.ControlCount;
			for i := 0 to SL.ControlCount - 1 do
				DL.ControlTime[i] := SL.ControlTime[i];
			for i := 0 to SL.ControlCount - 2 do
				DL.ControlMoveCount[i] := SL.ControlMoveCount[i];
		end;
		end;
	end;
	end;
end;

function CompareLevel(SL, DL: PLevel): BG;
var i: SG;
begin
	Result := False;
	if SL.Typ <> DL.Typ then Exit;
	case SL.Typ of
	ltFixedDepth: if SL.MaxD <> DL.MaxD then Exit;
	ltWinIn: if SL.WinIn <> DL.WinIn then Exit;
	ltHourglass: if SL.Time <> DL.Time then Exit;
	ltMinimal,
	ltEqual,
	ltAverage,
	ltMaximal,
	ltTimeControls:
	begin
		if SL.FreeTime <> DL.FreeTime then Exit;
		if SL.IncTime <> DL.IncTime then Exit;
		case SL.Typ of
		ltMinimal,
		ltEqual,
		ltAverage,
		ltMaximal:
		begin
			if SL.TimeNodes <> DL.TimeNodes then Exit;
			if SL.TimeNodes then
			begin
				if SL.Nodes <> DL.Nodes then Exit;
			end
			else
			begin
				if SL.Time <> DL.Time then Exit;
			end;
		end;
		ltTimeControls:
		begin
			if SL.ControlCount <> DL.ControlCount then Exit;
			for i := 0 to SL.ControlCount - 1 do
				if SL.ControlTime[i] <> DL.ControlTime[i] then Exit;
			for i := 0 to SL.ControlCount - 2 do
				if SL.ControlMoveCount[i] <> DL.ControlMoveCount[i] then Exit;
		end;
		end;
	end;
	end;
	Result := True;
end;

procedure TfLevels.ComboBoxTemplateChange(Sender: TObject);
begin
	if ComboBoxTemplate.ItemIndex >= 0 then
		CopyLevel(@TemplateLevels[ComboBoxTemplate.ItemIndex], @Level);
	DataToForm(Sender);
end;

(*-------------------------------------------------------------------------*)
procedure TfLevels.FormCreate(Sender: TObject);
const
	Hei = 22;
var
	i, j: SG;
	Ps: U8;
begin
	Background := baGradient;

	for i := 0 to Length(TemplateNames) - 1 do
	begin
		ComboBoxTemplate.Items.Add(TemplateNames[i] + ' (' + LevelToStr(@TemplateLevels[i], True) + ')');
	end;

	ComboBoxFixedDepth.Items.BeginUpdate;
	ComboBoxWinIn.Items.BeginUpdate;
	for i := 0 to MaxDepth - 1 do
	begin
		ComboBoxFixedDepth.Items.Add(NToS(i));
		if i > 0 then
			ComboBoxWinIn.Items.Add(NToS(i));
	end;
	ComboBoxFixedDepth.DropDownCount := Min(32, MaxDepth - 1);
	ComboBoxWinIn.DropDownCount := Min(32, MaxDepth - 1);
	ComboBoxWinIn.Items.EndUpdate;
	ComboBoxFixedDepth.Items.EndUpdate;
	ComboBoxControlCount.Items.BeginUpdate;
	for i := 1 to MaxControl + 1 do
	begin
		ComboBoxControlCount.Items.Add(NToS(i));
	end;
	ComboBoxControlCount.Items.EndUpdate;

	ComboBoxIncTime.Items.Add(MsToStr(0, diMSD, 0, False));
	ComboBoxIncTime.Items.Add(MsToStr(2 * Second, diMSD, 0, False));
	ComboBoxIncTime.Items.Add(MsToStr(5 * Second, diMSD, 0, False));
	ComboBoxIncTime.Items.Add(MsToStr(10 * Second, diMSD, 0, False));
	ComboBoxIncTime.Items.Add(MsToStr(20 * Second, diMSD, 0, False));
	ComboBoxIncTime.Items.Add(MsToStr(1 * Minute, diMSD, 0, False));

	ComboBoxFreeTime.Items.Add(MsToStr(0, diMSD, 0, False));
	ComboBoxFreeTime.Items.Add(MsToStr(3 * Second, diMSD, 0, False));
	ComboBoxFreeTime.Items.Add(MsToStr(10 * Second, diMSD, 0, False));

	ComboBoxTim.Items.Add(MsToStr(2 * Second, diMSD, 0, False));
	ComboBoxTim.Items.Add(MsToStr(5 * Second, diMSD, 0, False));
	ComboBoxTim.Items.Add(MsToStr(10 * Second, diMSD, 0, False));
	ComboBoxTim.Items.Add(MsToStr(20 * Second, diMSD, 0, False));
	ComboBoxTim.Items.Add(MsToStr(1 * Minute, diMSD, 0, False));

	ComboBoxNodes.Items.BeginUpdate;
	Ps := 1000;
	for i := 0 to 5 do
	begin
		ComboBoxNodes.Items.Add((NToS(Ps)));
		Ps := Ps * 10;
	end;
	ComboBoxNodes.Items.EndUpdate;
	for i := 0 to MaxControl do
	begin
		ComboBoxTime[i] := TComboBox.Create(Self);
		ComboBoxTime[i].SetBounds(LabelTime.Left, LabelTime.Top + LabelTime.Height {+ FormBorder} + Hei * i, LabelTime.Width, ComboBoxTime[i].Height);
		ComboBoxTime[i].OnChange := ComponentChanged;
		InsertControl(ComboBoxTime[i]);
		ComboBoxTime[i].DropDownCount := 9;
		ComboBoxTime[i].Items.BeginUpdate;
		ComboBoxTime[i].Items.Add(MsToStr(0, diMSD, 0, False));
		ComboBoxTime[i].Items.Add(MsToStr(3 * Minute, diMSD, 0, False));
		ComboBoxTime[i].Items.Add(MsToStr(5 * Minute, diMSD, 0, False));
		ComboBoxTime[i].Items.Add(MsToStr(20 * Minute, diMSD, 0, False));
		ComboBoxTime[i].Items.Add(MsToStr(25 * Minute, diMSD, 0, False));
		ComboBoxTime[i].Items.Add(MsToStr(1 * Hour, diMSD, 0, False));
		ComboBoxTime[i].Items.Add(MsToStr(80 * Minute, diMSD, 0, False));
		ComboBoxTime[i].Items.Add(MsToStr(90 * Minute, diMSD, 0, False));
		ComboBoxTime[i].Items.Add(MsToStr(2 * Hour, diMSD, 0, False));
		ComboBoxTime[i].Items.EndUpdate;

		if i < MaxControl then
		begin
			ComboBoxMoveC[i] := TComboBox.Create(Self);
			ComboBoxMoveC[i].SetBounds(LabelMoves.Left, LabelMoves.Top + LabelMoves.Height + {FormBorder +} Hei * i, LabelMoves.Width, ComboBoxMoveC[i].Height);
			ComboBoxMoveC[i].OnChange := ComponentChanged;
			InsertControl(ComboBoxMoveC[i]);
			for j := 1 to 2 do
				ComboBoxMoveC[i].Items.Add(NToS(j * 20));
		end;
	end;

	MainIni.RWFormPos(Self, False);
end;

(*-------------------------------------------------------------------------*)
procedure TfLevels.DataToForm(Sender: TObject);
var
	i: SG;
begin
	DisableChange := True;
	Caption := 'Levels' + SeparatedToS(Game.SeparatedLevel);
	case Level.Typ of
	ltInfinite: RBInfinite.Checked := True;
	ltFixedDepth: RBFixedDepth.Checked := True;
	ltShortestWin: RBShortestWin.Checked := True;
	ltWinIn: RBWinIn.Checked := True;
	ltHourglass: RBHourglass.Checked := True;
	ltMinimal: RBMinimal.Checked := True;
	ltEqual: RBEqual.Checked := True;
	ltAverage: RBAverage.Checked := True;
	ltMaximal: RBMaximal.Checked := True;
	ltTimeControls: RBTimeControls.Checked := True;
	end;

	if Sender <> ComboBoxFixedDepth then
		ComboBoxFixedDepth.ItemIndex := Level.MaxD;
	if Sender <> ComboBoxWinIn then
		ComboBoxWinIn.ItemIndex := Level.WinIn - 1;
	if Sender <> ComboBoxTimeNodes then
		ComboBoxTimeNodes.ItemIndex := SG(Level.TimeNodes);
	if Sender <> ComboBoxTim then
		ComboBoxTim.Text := MsToStr(Level.Time, diMSD, -3, False);
	if Sender <> ComboBoxNodes then
		ComboBoxNodes.Text := NToS(Level.Nodes);

	if Sender <> ComboBoxIncTime then
		ComboBoxIncTime.Text := MsToStr(Level.IncTime, diMSD, -3, False);

	if Sender <> ComboBoxFreeTime then
		ComboBoxFreeTime.Text := MsToStr(Level.FreeTime, diMSD, -3, False);

	if Sender <> ComboBoxTimeNodes then
	begin
		if ComboBoxControlCount.ItemIndex + 1 <> Level.ControlCount then
		begin
			ComboBoxControlCount.ItemIndex := Level.ControlCount - 1;
		end;
	end;
	ComboBoxTim.Enabled := ComboBoxTimeNodes.ItemIndex = 0;
	ComboBoxNodes.Enabled := ComboBoxTimeNodes.ItemIndex = 1;

	for i := 0 to MaxControl do
	begin
		if Sender <> ComboBoxTime[i] then
			ComboBoxTime[i].Text := MsToStr(Level.ControlTime[i], diMSD, -3, False);

		if i < MaxControl then
		begin
			if Sender <> ComboBoxMoveC[i] then
				ComboBoxMoveC[i].Text := NToS(Level.ControlMoveCount[i]);
		end;
	end;

	for i := 0 to MaxControl do
	begin
		ComboBoxTime[i].Enabled := i < ComboBoxControlCount.ItemIndex + 1;

		if i < MaxControl then
		begin
			ComboBoxMoveC[i].Enabled := i < ComboBoxControlCount.ItemIndex;

		end;
	end;

	EditLevel.Hint := LevelToStr(@Level, True);

	if Sender <> EditLevel then
	begin
		EditLevel.OnChange := nil;
		EditLevel.Text := LevelToStr(@Level, False);
		EditLevel.OnChange := EditLevelChange;
	end;

	if Sender <> ComboBoxTemplate then
	begin
		ComboBoxTemplate.ItemIndex := -1;
		for i := 0 to MaxTemplate do
			if CompareLevel(@TemplateLevels[i], @Level) then
			begin
				ComboBoxTemplate.ItemIndex := i;
				Break;
			end;
	end;
	DisableChange := False;
end;

procedure TfLevels.FormShow(Sender: TObject);
begin
	fMain.Levels2.Checked := True;
	fLevels.Level := Game.Levels[Game.SeparatedLevel];
	DataToForm(nil);
end;

procedure TfLevels.FormHide(Sender: TObject);
begin
	fMain.Levels2.Checked := False;
end;

procedure TfLevels.FormToData;
var i: SG;
begin
	if RBInfinite.Checked then
		Level.Typ := ltInfinite
	else if RBFixedDepth.Checked then
		Level.Typ := ltFixedDepth
	else if RBShortestWin.Checked then
		Level.Typ := ltShortestWin
	else if RBWinIn.Checked then
		Level.Typ := ltWinIn
	else if RBHourglass.Checked then
		Level.Typ := ltHourglass
	else if RBMinimal.Checked then
		Level.Typ := ltMinimal
	else if RBEqual.Checked then
		Level.Typ := ltEqual
	else if RBAverage.Checked then
		Level.Typ := ltAverage
	else if RBMaximal.Checked then
		Level.Typ := ltMaximal
	else if RBTimeControls.Checked then
		Level.Typ := ltTimeControls;

	Level.MaxD := ComboBoxFixedDepth.ItemIndex;
	Level.WinIn := ComboBoxWinIn.ItemIndex + 1;
	Level.TimeNodes := BG(ComboBoxTimeNodes.ItemIndex);
	Level.Time := StrToMs(ComboBoxTim.Text, 0, 10000, MaxInt);
	Level.Nodes := StrToValS8(ComboBoxNodes.Text, True, 0, 100000, High(Level.Nodes), 1);

	Level.IncTime := StrToMs(ComboBoxIncTime.Text, 0, 10000, MaxInt);
	Level.FreeTime := StrToMs(ComboBoxFreeTime.Text, 0, 10000, MaxInt);

	Level.ControlCount := ComboBoxControlCount.ItemIndex + 1;

	for i := 0 to MaxControl do
	begin
		Level.ControlTime[i] := StrToMs(ComboBoxTime[i].Text, 0, 10000, MaxInt);

		if i < MaxControl then
		begin
			Level.ControlMoveCount[i] := StrToValI(ComboBoxMoveC[i].Text, True, 0, 20 * (i + 1), MaxGameMoves, 1);
		end;
	end;
end;

procedure InitTimeLimit;
var
	i: SG;
	Mvs: UG;
	Player: UG;
	Level: PLevel;
begin
	InitRemainMoves;
	for Player := 0 to PlayerMax do
	begin
		Level := @Game.Levels[ActualLevel(Player)];
		if Level.Typ = ltTimeControls then
		begin
			TimeLimitClock[Player] := 0;
			Mvs := 0;
			for i := 0 to Level.ControlCount - 1 do
			begin
				if i < MaxControl then Inc(Mvs, Level.ControlMoveCount[i]);
				Inc(TimeLimitClock[Player], Level.ControlTime[i]);
				if i + 1 = Level.ControlCount then Break;
				if Mvs > (UG(Game.Pos.MoveIndex) + (Player xor 1)) div 2 then
				begin
					if Game.Pos.Side = Player then RemainMoves := Mvs - (UG(Game.Pos.MoveIndex) + (Player xor 1)) div 2;
					Break;
				end;
			end;
		end
		else
			TimeLimitClock[Player] := High(TimeLimitClock[Player]);
	end;
	InitTimeLimitAvgMax;
end;

procedure RWLevels(MainIni: TDIniFile; const Save: BG);
var
	Section: string;
	i: SG;
	Player: SG;
	Level: PLevel;
begin
	for Player := 0 to PlayerMax + 1 do
	begin
		Section := 'Levels' + IntToStr(Player);
		Level := @Game.Levels[Player];
		if Save = False then
			Level^ := DefLevel;
		MainIni.RWNum(Section, 'Type', U1(Level.Typ), Save);
		MainIni.RWNum(Section, 'MaxD', Level.MaxD, Save);
		MainIni.RWNum(Section, 'IncTime', Level.IncTime, Save);
		MainIni.RWNum(Section, 'FreeTime', Level.FreeTime, Save);
		MainIni.RWBool(Section, 'TimeNodes', Level.TimeNodes, Save);
		MainIni.RWNum(Section, 'Nodes', Level.Nodes, Save);
		MainIni.RWNum(Section, 'WinIn', Level.WinIn, Save);
		MainIni.RWNum(Section, 'ControlCount', Level.ControlCount, Save);
		for i := 0 to MaxControl do
		begin
			MainIni.RWNum(Section, 'ControlTime' + NToS(i + 1, False), Level.ControlTime[i], Save);
			if i < MaxControl then
			begin
				MainIni.RWNum(Section, 'ControlMoveCount' + NToS(i + 1, False), Level.ControlMoveCount[i], Save);
			end;
		end;
	end;
end;

procedure TfLevels.ButtonApplyClick(Sender: TObject);
var
	L: PLevel;
begin
	L := @Game.Levels[Game.SeparatedLevel];
	L^ := Level;
	RWLevels(LevelsIni, True);
	InitTimeLimit;
	InitMenuLevel;
	DrawTotalTime01;
end;

procedure TfLevels.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	MainIni.RWFormPos(Self, True);
end;

procedure TfLevels.ButtonCancelClick(Sender: TObject);
begin
	Close;
end;

procedure TfLevels.FormDestroy(Sender: TObject);
var i: SG;
begin
	for i := 0 to MaxControl do
	begin
		FreeAndNil(ComboBoxTime[i]);
		if i < MaxControl then
		begin
			FreeAndNil(ComboBoxMoveC[i]);
		end;
	end;
end;

procedure TfLevels.ButtonOKClick(Sender: TObject);
begin
	ButtonApplyClick(Sender);
	Close;
end;

procedure TfLevels.ComponentChanged(Sender: TObject);
begin
	if DisableChange = False then
	begin
		FormToData;
		DataToForm(Sender);
	end;
end;

procedure TfLevels.EditLevelChange(Sender: TObject);
begin
	if DisableChange = False then
	begin
		StrToLevel(EditLevel.Text, @Level);
		DataToForm(Sender);
	end;
end;

procedure ChangeLevel;
begin
	if FormDraw(fLevels) then
	begin
		fLevels.Level := Game.Levels[Game.SeparatedLevel];
		fLevels.DataToForm(nil);
	end;
	InitTotalTime;
	InitTimeLimit;
	InitMenuLevel;
	DrawTotalTime01;
	InitLevelTags;
	InitPGN;
end;

end.