unit uETypes;

interface

uses uTypes;

// Main
type
	TGameType = (gkNone, gtDraughts, gtChess, gtChineseChess, gtShogi, gtJungle, gtGomoku, gtOthello, gtExplosion, gtBlobWars); // Add Game
	TMoveFormat = (mfDraughts, mfChess, mfGO);
const
	gtCastleAndEP = gtChess;
	PlayerMax = 1;

// Board & Pieces
	MaxPieces = 14; // Max(PieceTypes)
var
	PieceTypes: SG;

type
	TSquare = S1;
const
	sqEmpty = 0;
	sqOut = 127; // sqNone

	// Chess
	sqP0 = 1; sqP1 = -1;
	sqN0 = 2; sqN1 = -2;
	sqB0 = 3; sqB1 = -3;
	sqR0 = 4; sqR1 = -4;
	sqQ0 = 5; sqQ1 = -5;
	sqK0 = 6; sqK1 = -6;
	sqC0 = 7; sqC1 = -7;

	// Shogi
	sqA0 = 1; sqA1 = -1;
	sqShogiB0 = 2; sqShogiB1 = -2;
	sqShogiR0 = 3; sqShogiR1 = -3;
	sqL0 = 4; sqL1 = -4;
	sqH0 = 5; sqH1 = -5;
	sqS0 = 6; sqS1 = -6;
	sqG0 = 7; sqG1 = -7;
	sqShogiK0 = 8; sqShogiK1 = -8;

	sqAP0 = 9; sqAP1 = -9;
	sqBP0 = 10; sqBP1 = -10;
	sqRP0 = 11; sqRP1 = -11;
	sqLP0 = 12; sqLP1 = -12;
	sqHP0 = 13; sqHP1 = -13; // ShogiN
	sqSP0 = 14; sqSP1 = -14;

	// Jungle
	sqRat = 1;

	sqElephant = sqRat + 7;

	sqDen0 = 9;
	sqDen1 = -9;
	sqWater = 10;
type
	TPiece = -MaxPieces..MaxPieces;

// Board Representation
{ Standard:
	Draughts
	8x8 in 9x10
	10x10 in 11x12

	Chess
	8x8 in 10x12

	Shogi
	9x9 in 10x13
}
const
	ShlE = {$ifdef UCI}7{$else}9{$endif}; // 2 ^ ShlE = BoardSize
	BoardSize = 1 shl ShlE; // <= BoardX * BoardY
	MaxGameMovesShl = 9;
	MaxGameMoves = 1 shl MaxGameMovesShl - 1; //511; // 255 for Draughts, 511 for Chess, used for Hash and limits, but can be more that this value!
	BoardX = 23 {a..w}; // 2^x, > SqXc + 2/4
	BoardY = 23 {a..w}; // > SqYc + 2/4
type
	THash = packed record // 8
		case Integer of
		0:(
			Index: U4;
			Code: U4;
		);
		1: (
			A: U8;
		);
	end;

	PBoard = ^TBoard;
	TBoard = array[0..BoardSize - 1] of TSquare;
	TCaptureCount = SG;
	TCapturedPieces = array[-MaxPieces..MaxPieces] of TCaptureCount;
	TCastleType = (caK, caQ);
	TCastles = array[0..PlayerMax, TCastleType] of BG;
	TEP = U1;
	TSide = U4; // 0..PlayerMax
	PPos = ^TPos;
	TPos = record // 1200
		Board: TBoard; // 1024
		Hash: THash; // 8
		LongDraw: U4;
		MoveIndex: S4; // Side = MoveIndex mod (PlayerMax + 1)
		Castles: TCastles; // 4
		Side: TSide;
		EP: TEP; // 1
		CapturedPieces: TCapturedPieces; // 29 * 4 mfChess
	end;

const
	MaxMoves = 511; {BoardSize - 1;} // BoardSize for Gomoku, Chess: 128, Draughts: 48 all kings
	MaxDepth = 65; // 17, 33, 65, 129, FAn+CBestAn is 2..65=64
type
	TScore = S2;
	TScoreBound = (sbNone, sbExact, sbLower{vfFailHigh}, sbUpper{vfFailLow});
const
	scMax = 32767;
	scWin = 32766; // #1
	scWin0 = scWin - MaxDepth div 2; // 32734
	scoNone = -32768; // 32768, scNone is used in Classes
	{
	-scMax = -32767
	-scWin = -32766 -#1

	-scWin0 = -32734 -#33

	Fritz: -32001 -#766
	Normal Score -32733..32733

	scWin0 = 32734 #33

	scWin = 32766 #1
	scMax = 32767
	}
	scEasyWin = 141;
	scLongWin = 71;
	scAdvance = 26;

type
	TVariantionCut = (
		vcNone, // "unterminated": game not terminated.
								// "normal": game terminated in a normal fashion.
		// Engine only
		vcSpecific,
		vcAlpha, // FailLow
		vcBeta, // FailHigh
		vcLimit,
		vcCalm,
		vcDepth,
		vcSelectivity,
		vcFutility,
		vcMaxDepth,
		vcHashAlpha,
		vcHashBeta,
		// Game & Engine
		vcMate,
		vcNoPiece,
		vcLowMaterial,
		vcStalemateDraw,
		vcStalemateWin,
		vcStalemateLose,
		vcRepetition,
		vcMovesRule,
		// Game
		vcTimeUp, // "time forfeit": loss due to losing player's failure to meet time control requirements.
		vcDrawByPlayer,
		vcResign);
		{"abandoned": abandoned game.
		"adjudication": result due to third party adjudication process.
		"death": losing player called to greater things, one hopes.
		"emergency": game concluded due to unforeseen circumstances.
		"rules infraction": administrative forfeit due to losing player's failure to observe either the Laws of Chess or the event regulations.
		}

type
	TSubtreeStatus = packed record // 8
		Score: TScore; // 2
		ScoreBound: TScoreBound; // 1
		VariantionCut: TVariantionCut; // 1
		MoveCount: U1; // 1
		Reserved: array[0..2] of U1;
	end;
const
	MaxAnalysisDepth = 54;
type
	TMoveIndex = U2;
type
	PAnalysis = ^TAnalysis;
	TAnalysis = packed record // 128
		Time: U4;
		Nodes: U4;
		Status: TSubtreeStatus; // 8
		Depth: U1;
		SelDepth: U1;
		ActMove: U1;
		Reserved: U1;
		// 20
		Moves: array[1..MaxAnalysisDepth] of TMoveIndex; // 54 * 2 = 108
	end;

{$ifndef UCI}
var
	GameType: TGameType;
	MoveFormat: TMoveFormat;
{$else}
const
	GameType = gtChess;
	MoveFormat = mfChess;
{$endif}
const
	NullMoveStr = '--';
const
	MaxMoveL = 27; // Theoretical maximum is 18 (board 8x8), 24 (board 10x10), 30 (board 12x12)
const
	OShlTMove: array[TMoveFormat] of SG = (5, 3, 2);
	ShlTMoveDraughts = 5;
	ShlTMoveChess = 3;
	ShlTMoveGO = 2;
var
	ShlTMove: SG;
const
	SizeTMoveDraughts = 1 shl ShlTMoveDraughts;
	SizeTMoveChess = 1 shl ShlTMoveChess;
	SizeTMoveGO = 1 shl ShlTMoveGO;
var
	SizeTMove: SG;
const
	NullMoveIndex = High(TMoveIndex);
	NullSquare = 0;
type
	TTM = (tmNormal = 0,
		tmP0 = 1, tmP1 = -1,
		tmN0 = 2, tmN1 = -2,
		tmB0 = 3, tmB1 = -3,
		tmR0 = 4, tmR1 = -4,
		tmQ0 = 5, tmQ1 = -5,
		tmK0 = 6, tmK1 = -6,
		tmA0 = 7, tmA1 = -7,
		tmH0 = 8, tmH1 = -8,
		tmL0 = 9, tmL1 = -9,
		tmS0 = 10, tmS1 = -10,
		tmG0 = 11, tmG1 = -11,
		tmAP0 = 12, tmAP1 = -12,
		tmHP0 = 13, tmHP1 = -13,
		tmLP0 = 14, tmLP1 = -14,
		tmPut = 15,
		tmOO = 16, tmOOO = 17, tmEP = 18, tmDouble = 19);

	TPlus = (msNone, msCheck, msMate);

	PMove = ^TMove;
	TMove = packed record // Dynamic type 4-32, do not use SizeOf(TMove), use SizeTMove, ShlTMove
		Prior: U1; // +0
		F1: TPiece; // 1 +3 piece which move
		case TMoveFormat of
(*    mfDraughts: (
			Lng: U1; // +1
			ToXY: array[0..MaxMoveL] of U1; // 15 +2
			What: array[0..MaxMoveL - 1] of TPiece; // 14 +16
			Promote: U1; // 1 +31
		);*)
		mfDraughts: (
			DraughtsMove: TTM; // 1 +31
			Lng: U1; // +1
			Sq: array[0..MaxMoveL] of U1; // 28 +2
		);
{     Typ: (tpNormal, tpJump, tpJumpCont);
			Sou, Des: U1; New implementation }
		mfChess: ( // F1 FrSq x(F2) ToSq
			FrSq: U1; // 1 +1
			ToSq: U1; // 1 +2
			F2: TPiece; // 1 +4 piece which is removed F2 = CP[ToSq] - required for BackMove
			TM: TTM; // 1 +5
			Plus: TPlus; // 1 +6
			Reserved0: U1; // 1 +7
		);
		mfGO: (
//      Reserved1: U1; // 1
			T: U2; // 2
		);
	end;

implementation

end.