unit uETimer;

interface

uses uTypes;

var
	GTime: U4;
procedure InitGTime;
procedure GetGTime;

type
	TDelayedProcedure = (
		dpMove1,
		dpMoveCount1,
		dpMoveScore1,
		dpMove2,
		dpMoveCount2,
		dpDepth,
		dpActualDepth,
		dpSelDepth,
		dpAlphaBeta,
		dpNodes,

		dpNextBestMoves,

		dpBoard, dpABoard, dpMoves, dpEnabledMoves, dpAMoves, dpSetup, dpComment,
		dpTotalTime0, dpMoveTime0, dpTotalTime1, dpMoveTime1, dpTimeStrategy);
procedure DrawOb(Ob: TDelayedProcedure);

procedure ResetEventsBreak;
procedure DelayedTimer;
procedure EventsBreak;
{$ifdef UCI}
procedure DrawBestMove;
{$endif}

implementation

uses
	Math,
	Windows,
	TypInfo,
	SysUtils,
	{$ifndef UCI}
	Forms,
	uDTimer,
	uGame,
	uAnalys, uNextMove, uMoves, uBoard, uClock, uSetup, uComment, uLevels, uNew,
	uMain, uError,
	{$endif}
	{$ifdef Thread}
	Classes,
	{$endif}
	uEBook,
	uSorts, uMath, uFormat, uStrings,
	uEBoard, uEHash, uEGen, uESearch, uETypes, uEParams,
	uEngine;

// Time functions
//{$define Prec} // Precision Timer, but slower (3%)
var
	LGTime, LagOffset: {$ifdef Prec}U8{$else}U4{$endif};
procedure InitGTime;
begin
	LagOffset := {$ifdef Prec}PerformanceCounter{$else}GetTickCount{$endif};
	LGTime := 0;
end;

procedure GetGTime;
var
	GTimeStep, GTime2: {$ifdef Prec}U8{$else}U4{$endif};
begin
	GTime2 := {$ifdef Prec}PerformanceCounter{$else}GetTickCount{$endif} - LagOffset;
	GTimeStep := GTime2 - LGTime;
	if GTimeStep > 2 * {$ifdef Prec}PerformanceFrequency{$else}1000{$endif} then // Long lag and hibernation
	begin
		Dec(GTimeStep, 1); // increment 1 if lag found, 0 can be problem for UCI!
		Inc(LagOffset, GTimeStep);
		Dec(GTime2, GTimeStep);
		Echo('Lag ' + MsToStr(GTimeStep, diDHMSD, 3, False));
	end;
	LGTime := GTime2;
	{$ifdef Prec}GTime := RoundDivU8(1000 * GTime2, PerformanceFrequency);{$else}GTime := GTime2{$endif} // Readable value
end;


{$ifndef UCI}
procedure DrawGameBoard;
begin
	DrawBoard(1);
end;

procedure DrawAnalysisBoard;
begin
	DrawBoard(2);
end;
{$else}
procedure DrawMove1;
begin
	if MNX[1] = -1 then
		TellGUI('info currmove -- currmovenumber ' + IntToStr(MNX[1] + 1))
	else
		TellGUI('info currmove ' + MoveToS(@AnalysisInfo.Move[1])  + ' currmovenumber ' + IntToStr(MNX[1] + 1));
end;

procedure DrawDepth;
begin
	TellGUI('info depth ' + IntToStr(AnalysisInfo.Depth));
end;

procedure DrawSelDepth;
begin
	TellGUI('info ' + { depth ' + IntToStr(Depth) +} 'seldepth ' + IntToStr(AnalysisInfo.SelDepth));
end;

procedure DrawBestMove;
var
	HPos: TPos;
begin
	CopyPos(CPos, HPos);
	CopyPos(Game.Pos, CPos);
	PCMove := PMove(SG(@OMove) + {RMoveToIndex[}MovesOrder[0]{]} shl ShlTMove);
	TellGUI('bestmove ' + MoveToS(PCMove)); // ponder D???
	CopyPos(HPos, CPos);
end;

procedure DrawNodes;
var s: string;
begin
	if NowHashPos = 0 then
		s := ''
	else
		s := ' hashfull ' + IntToStr(RoundDiv(1000 * HashStat.New, NowHashPos));
	TellGUI('info time ' + IntToStr(AnalysisInfo.Time) + ' nodes ' + IntToStr(AnalysisInfo.Nodes) + ' nps ' + IntToStr(AnalysisInfo.AvgNodes) + s);
	if AEP[eoUCI_ShowCurrLine].Bool then
	begin
		SetCurrentLine;
		TellGUI('info currline ' + AnalysisToS(0));
	end;
end;

procedure DrawAMoves;
var
	s, s2: string;
begin
	if AnalysisC > 0 then
	begin
		s := ' pv ' + AnalysisToS(AnalysisC - 1);
	end
	else
		s := '';

	if AEP[eoMultiPV].Num > 1 then
		s2 := ' multipv ' + IntToStr(MNX[D])
	else
		s2 := '';

	TellGUI(
		'info' + s2 + ' depth ' + IntToStr(AnalysisInfo.Depth) +
		' seldepth ' + IntToStr(Analysis[AnalysisC - 1].SelDepth) +
		' time ' + IntToStr(Analysis[AnalysisC - 1].Time) +
		' nodes ' + IntToStr(Analysis[AnalysisC - 1].Nodes) +
		' nps ' + IntToStr(AnalysisInfo.AvgNodes) +
		' score ' + ScoreToStr(Analysis[AnalysisC - 1].Status.Score, 0, sfUCI, Analysis[AnalysisC - 1].Status.ScoreBound) +
		s);
	{$ifdef Debug}
{ s := VariantionCutToStr(Analysis[AnalysisC - 1].VariantionCut);
	if s <> '' then
		Echo(s);}
	{$endif}
end;

{$endif}
const
	DelayedProcedures: array[TDelayedProcedure] of procedure = (
		DrawMove1,
		{$ifndef UCI}DrawMoveCount1{$else}nil{$endif},
		{$ifndef UCI}DrawMoveScore1{$else}nil{$endif},
		{$ifndef UCI}DrawMove2{$else}nil{$endif},
		{$ifndef UCI}DrawMoveCount2{$else}nil{$endif},
		DrawDepth,
		{$ifndef UCI}DrawActualDepth{$else}nil{$endif},
		DrawSelDepth,
		{$ifndef UCI}DrawAlphaBeta{$else}nil{$endif},
		DrawNodes,

		{$ifndef UCI}DrawNextBestMoves{$else}nil{$endif},
		{$ifndef UCI}DrawGameBoard{$else}nil{$endif},
		{$ifndef UCI}DrawAnalysisBoard{$else}nil{$endif},
		{$ifndef UCI}DrawMoves{$else}nil{$endif},
		{$ifndef UCI}DrawEnabledMoves{$else}nil{$endif},
		DrawAMoves,
		{$ifndef UCI}DrawSetup{$else}nil{$endif},
		{$ifndef UCI}DrawComment{$else}nil{$endif},
		{$ifndef UCI}DrawTotalTime0{$else}nil{$endif},
		{$ifndef UCI}DrawMoveTime0{$else}nil{$endif},
		{$ifndef UCI}DrawTotalTime1{$else}nil{$endif},
		{$ifndef UCI}DrawMoveTime1{$else}nil{$endif},
		{$ifndef UCI}DrawTimeStrategy{$else}nil{$endif});

{$ifndef UCI}
var
	MissedCount: array[TDelayedProcedure] of UG;
	NextDrawTime: array[TDelayedProcedure] of U4;
{$endif}

procedure DrawOb(Ob: TDelayedProcedure);
begin
	{$ifdef Thread}
	Inc(MissedCount[Ob]);
	Exit;
	{$endif}
	{$ifndef UCI}
	if DelayScreen then
	begin
		if NextDrawTime[Ob] + DelayScreenTime > GTime then
		begin
			Inc(MissedCount[Ob]);
		end
		else
		begin
			DelayedProcedures[Ob];
			MissedCount[Ob] := 0;
			GetGTime;
			NextDrawTime[Ob] := GTime;
		end;
	end
	else
	{$else}
	if Assigned(DelayedProcedures[Ob]) then
	{$endif}
		DelayedProcedures[Ob];
end;

// Breaks
{$ifndef Thread}
const
	BreakTick = 40; // ms
	StartPsTick = 16; // 1..256 for D1800
var
	LGetTickCount: U4;
	PsTick, MaxPsTick: UG;
	LNodes: U8;

procedure ResetEventsBreak;
begin
	LNodes := 0;
	MaxPsTick := StartPsTick;
	PsTick := 0; // Next event run, required stop on depth=0
	LGetTickCount := GTime;
end;

procedure OneSec;
begin
	DrawOb(dpActualDepth);
	if AnalysisInfo.Time > 0 then
	begin
		AnalysisInfo.AvgNodes := RoundDivU8((1000 * AnalysisInfo.Nodes), AnalysisInfo.Time);
	end
	else
	begin
		AnalysisInfo.AvgNodes := 0;
	end;
	AnalysisInfo.NodesPerSec := AnalysisInfo.Nodes - LNodes;
	AnalysisInfo.HashNew := HashStat.New;
	AnalysisInfo.HashPos := NowHashPos;
	DrawNodes; // DrawOb(dpNodes);
	LNodes := AnalysisInfo.Nodes;
end;

procedure DelayedTimer;
var
{$ifndef UCI}
	i: TDelayedProcedure;
{$endif}
	HTime: U4;
begin
	// Init
	GetGTime;

	// Delay Screen
	{$ifndef UCI}
	if DelayScreen then
		HTime := GTime
	else
		HTime := High(HTime); // or GTime
	{$endif}

	{$ifndef UCI}
	for i := Low(TDelayedProcedure) to High(TDelayedProcedure) do
	begin
		if (MissedCount[i] > 0) and (HTime >= NextDrawTime[i] + DelayScreenTime) then
		begin
			{$ifdef Thread}
			if Parallel <> nil then
				Parallel.Suspend;
			{$endif}
			DelayedProcedures[i];
			MissedCount[i] := 0;
			GetGTime;
			NextDrawTime[i] := GTime;
			{$ifdef Thread}
			if Parallel <> nil then
				Parallel.Resume;
			{$endif}
		end;
	end;
	{$endif}

	if TimeGo <> tgNone then
	begin
		MoveTime[Game.Pos.Side] := GTime - BeginTime;
		{$ifndef UCI}
		UpdateMovTime(Game.Pos.Side);
		{$endif}
		if ((SMoveTime[Game.Pos.Side] div 1000) <> (MoveTime[Game.Pos.Side] div 1000)) then
		begin
			{$ifndef UCI}
			PlayASound(snTick);
			{$endif}
			if Where <> whNone then OneSec;
			SMoveTime[Game.Pos.Side] := MoveTime[Game.Pos.Side];
		end;

		if Game.Levels[ActLevel].Typ = ltTimeControls then
			HTime := Game.Levels[ActLevel].FreeTime
		else
			HTime := 0;
		NowTotTime := TotTime[Game.Pos.Side] + Max(0, SG(MoveTime[Game.Pos.Side]) - SG(HTime));
		{$ifndef UCI}
		if TimeGo = tgGame then
			UpdateTotTime(Game.Pos.Side, False);
		{$endif}
	end;
end;

procedure EventsBreak;
var
	GTCDelta: U4;
begin
	if PsTick <= 0 then
	begin
		GetGTime;
		GTCDelta := GTime - LGetTickCount;
		if (GTCDelta = 0){ First run } then
			MaxPsTick := MaxPsTick * 2
		else
			MaxPsTick := Max(1, RoundDiv(BreakTick * MaxPsTick, GTCDelta));
		PsTick := MaxPsTick;
		AnalysisInfo.Time := GTime - CBeginTime;
		LGetTickCount := GTime;
		{$ifdef UCI}
		DelayedTimer;
		{$else}
		Application.ProcessMessages;
		TryTimer;
		{$endif}
		GetGTime;
		Inc(CBeginTime, GTime - LGetTickCount); // Do not count interrupt delay
		LGetTickCount := GTime;
	end
	else
		Dec(PsTick);
end;
{$endif}


end.