//* File:     SDG\uComment.pas
//* Created:  1997-01-01
//* Modified: 2005-10-08
//* Version:  2.1.35.309
//* Author:   Safranek David (Safrad)
//* E-Mail:   safrad at email.cz
//* Web:      http://safrad.webzdarma.cz

unit uComment;

interface

uses
	uGame,
	uTypes, uDForm,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, uDButton;

type
	TfComment = class(TDForm)
		MemoB: TMemo;
		ButtonApply: TDButton;
		ButtonClose: TDButton;
		ButtonDefault: TDButton;
		MemoA: TMemo;
		procedure MemoBAChange(Sender: TObject);
		procedure ButtonApplyClick(Sender: TObject);
		procedure ButtonCloseClick(Sender: TObject);
		procedure FormResize(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure ButtonDefaultClick(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
	private
		{ Private declarations }
		procedure RWOptions(const Save: BG);
		procedure InitButtons;
	public
		{ Public declarations }
	end;

var
	fComment: TfComment;

procedure DrawComment;

implementation

{$R *.dfm}
uses
	uFiles, uError, uDIni, uStrings, uEngine,
	uMain;

var
	CommentChanged: BG;

procedure TfComment.InitButtons;
begin
{ ButtonApply.Enabled := CommentChanged and (GameLastMove <> nil);}
	ButtonDefault.Enabled := CommentChanged{ and (GameLastMove <> nil)};
end;

procedure TfComment.MemoBAChange(Sender: TObject);
var
	NCommentChanged: BG;
begin
{ if GameLastMove = nil then
		NCommentChanged := GameLastMove.CommentBefore <> TMemo(Sender).Lines.GetText;
	else
	begin
		NCommentChanged := GameLastMove.CommentBefore <> TMemo(Sender).Lines.GetText
			or GameLastMove.CommentAfter <> TMemo(Sender).Lines.GetText
	end;}
	NCommentChanged := True;
	if CommentChanged <> NCommentChanged then
	begin
		CommentChanged := NCommentChanged; InitButtons;
	end;
end;

procedure TfComment.ButtonApplyClick(Sender: TObject);
begin
	if CommentChanged then
	begin
		if GameLastMove <> nil then
		begin
			GameLastMove.CommentBefore := MemoB.Lines.GetText;
			GameLastMove.CommentAfter := MemoA.Lines.GetText;
			KindsChange;
		end
		else
		begin
			Game.PGNTags[ptComment] := MemoB.Lines.GetText;
			Game.StartCommnent := MemoA.Lines.GetText;
		end;
	end;
end;

procedure TfComment.ButtonCloseClick(Sender: TObject);
begin
	Close;
end;

procedure TfComment.FormResize(Sender: TObject);
begin
	ButtonApply.Top := ClientHeight - 8 - ButtonApply.Height;
	ButtonDefault.Top := ClientHeight - 8 - ButtonDefault.Height;
	ButtonClose.Top := ClientHeight - 8 - ButtonClose.Height;
	MemoB.Height := (ClientHeight - 8 - ButtonApply.Height - 8) div 2;
	MemoA.Height := MemoB.Height;
	MemoA.Top := MemoB.Height;
end;

procedure TfComment.RWOptions(const Save: BG);
begin
	MainIni.RWFormPos(Self, Save);
end;

procedure TfComment.FormCreate(Sender: TObject);
begin
	Background := baGradient;
	RWOptions(False);
end;

procedure TfComment.FormDestroy(Sender: TObject);
begin
	RWOptions(True);
end;

procedure DrawComment;
begin
	if FormDraw(fComment) then
	begin
{   fComment.MemoB.Enabled := GameLastMove <> nil;
		fComment.MemoA.Enabled := GameLastMove <> nil;}
		if GameLastMove = nil then
		begin
			fComment.MemoB.Text := Game.PGNTags[ptComment];
			fComment.MemoA.Text := Game.StartCommnent;
		end
		else
		begin
			fComment.MemoB.Text := GameLastMove.CommentBefore;
			fComment.MemoA.Text := GameLastMove.CommentAfter;
		end;
		fComment.MemoB.Repaint;
		fComment.MemoA.Repaint;
	end;
end;

procedure TfComment.ButtonDefaultClick(Sender: TObject);
begin
	DrawComment;
	InitButtons;
end;

procedure TfComment.FormShow(Sender: TObject);
begin
	fMain.Comment2.Checked := True;
	DrawComment;
end;

procedure TfComment.FormHide(Sender: TObject);
begin
	fMain.Comment2.Checked := False;
end;

end.