//* File:     SDG\uPieces.pas
//* Created:  1997-01-01
//* Modified: 2005-10-15
//* Version:  2.1.35.309
//* Author:   Safranek David (Safrad)
//* E-Mail:   safrad at email.cz
//* Web:      http://safrad.webzdarma.cz

unit uPieces;

interface

uses
	uDBitmap, uDForm, uTypes,
	uEngine, uETypes,
	uGame,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, ExtDlgs, ExtCtrls, uDButton;

type
	TfPieces = class(TDForm)
		ButtonOk: TDButton;
		ButtonClose: TDButton;
		OpenPictureDialogP: TOpenPictureDialog;
		LabelPieces: TLabel;
		LabelBoard: TLabel;
		EditPieces: TEdit;
		ButtonPiecesSelect: TDButton;
		ButtonDarkSquare: TDButton;
		ButtonRounded: TDButton;
		BevelBoard: TBevel;
		ComboBoxScale: TComboBox;
		DLabelScale: TLabel;
		BevelPieces: TBevel;
		ButtonLightSquare: TDButton;
		ButtonWC1: TDButton;
		ButtonBC1: TDButton;
		LabelBlack: TLabel;
		ButtonWC0: TDButton;
		ButtonBC0: TDButton;
		ButtonMeFrom: TDButton;
		ButtonSameTo: TDButton;
		ButtonOthersTo: TDButton;
		ButtonLastMove: TDButton;
		ButtonGridLines: TDButton;
		CBShadows: TComboBox;
		LabelWhite: TLabel;
		ButtonBackground: TDButton;
		ButtonActiveSquare: TDButton;
		DButtonDefault: TDButton;
		Label1: TLabel;
		Label2: TLabel;
		Label3: TLabel;
		procedure ButtonCloseClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure ButtonOkClick(Sender: TObject);
		procedure OpenFClick(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure ButtonDrawStyleClick(Sender: TObject);
		procedure ControlChange(Sender: TObject);
		procedure ButtonWC0Click(Sender: TObject);
		procedure DButtonDefaultClick(Sender: TObject);
	private
		{ Private declarations }
		DisableChange: BG;
		procedure PieceSetToForm;
		procedure InitPiecesPaths;
	public
		{ Public declarations }
	end;

procedure RWPieceSet(const Save: BG);
function PieceToBmp(Index: SG; Piece: TPiece): TDBitmap;
procedure LoadPieces;
procedure FreePieces(j: SG); overload;

var
	fPieces: TfPieces;
	{Loaded, Board, Analysis Board, Notation, Output}
	PieceGameType: TGameType;
	ReqPieceSize: array[0..4] of SG;
	BmpPieces: array[0..4, 0..31] of TDBitmap;

type
	TPieceColor = array[0..2 * (PlayerMax + 1) - 1] of TColor;
	{Back Player
	 0  0
	 0  1
	 1  0
	 1  1
	}

type
	TPieceSet = record
		// Board
		Background,
		DarkSquare, LightSquare,
		ActiveSquare,
		LastMoveColor: TDrawStyle;
		SquareStatus: array[ssMeOk..ssTheTo] of TDrawStyle; // 16 * 8 = 128

//    Name: string; // 4
		GridLineColor: TColor;

		// Pieces
		PieceName: array[TGameType] of TFileName;
		PieceColor: TPieceColor; // 2 * 8 = 16
		PieceScale: S4;
		GridLines: BG;
		PieceShadows: U1;
		PieceRounded: BG;
		LastMoveArrow: BG;
	end;
var
	PieceSet, LPieceSet, DefPieceSet: TPieceSet;
	PieceColor: TPieceColor; // For swap colors

implementation

{$R *.dfm}
uses
	Math,
	uMain, uBoard, uAnalys,
	uInput, uMath, uFiles, uGraph, uDIni, uError, uGColor, uStyle, uAbout, uFormat, uMenus, uStrings;

(*-------------------------------------------------------------------------*)
procedure DefaultPieceSet(var PieceSet: TPieceSet);
const
	DefScale = 75;

	DefaultPieceFileName: array[TGameType] of string = ('',
		'Draughts\Circle.png',
		'Chess\Ftoz.png',
		'Chess\Ftoz.png',
		'Shogi\Shogi.png',
		'Gomoku\Gomoku.png',
		'Draughts\Circle.gif',
		'Jungle\Book.png',
		'Explosion\Explosion.png',
		'BlobWars\BlobWars.png'
		// Add Game
		);

	// MCP
{ PieceColor: TPieceColor = ($00c0f0, $000000);
	PieceColorB: TPieceColor = ($000000, $67a0aa);
	BoardLight = $9dbfbf; // $90b0b0;
	BoardDark = $4c6c6c;}

	// Fritz
//  DefPieceColor: TPieceColor = ($f5fdf3, $131313, $131313, $c5cdc3);
	BoardLight = $eeeeee;
	BoardDark = $a1a379;
var
	i: SG;
begin
	// Board
	PieceSet.GridLines := False;
	PieceSet.GridLineColor := clBlack;

	PieceSet.Background.Style := gsSolid;
	PieceSet.Background.Effect := ef16;
	PieceSet.Background.Colors[0] := $4e523c; // clGray; MCP

	PieceSet.LightSquare.Style := gsSolid;
	PieceSet.LightSquare.Effect := ef16;
	PieceSet.LightSquare.Colors[0] := BoardLight;
	PieceSet.DarkSquare.Style := gsSolid;
	PieceSet.DarkSquare.Effect := ef16;
	if GameType in [gtGomoku, gtJungle, gtExplosion] then
	begin
		PieceSet.DarkSquare.Colors[0] := BoardDark; //BoardLight
	end
	else
		PieceSet.DarkSquare.Colors[0] := BoardDark;

	PieceSet.ActiveSquare.Style := gsGradient;
	PieceSet.ActiveSquare.Effect := ef04;
	PieceSet.ActiveSquare.Colors[0] := clBlue;
	PieceSet.ActiveSquare.Colors[1] := clNavy;

	for i := SG(ssMeOk) to SG(ssTheTo) do
		PieceSet.SquareStatus[TSquareStatus(i)].Effect := ef06;

	PieceSet.SquareStatus[ssMeOk].Colors[0] := clLime;
	PieceSet.SquareStatus[ssSomeTo].Colors[0] := clYellow;
	PieceSet.SquareStatus[ssTheTo].Colors[0] := clGreen;

	// Pieces
//  PieceSet.PieceName[gtNone] := ''
	for i := 0 to Length(DefaultPieceFileName) - 1 do
		PieceSet.PieceName[TGameType(i)] := 'Graphics\' + DefaultPieceFileName[TGameType(i)];

//  PieceSet.PieceColor := DefPieceColor;
	PieceSet.PieceColor[0] := $f5fdf3;
	PieceSet.PieceColor[1] := $131313;
	PieceSet.PieceColor[2] := $131313;
	PieceSet.PieceColor[3] := $c5cdc3;

	PieceSet.PieceColor[3] := MixColors(BoardLight, BoardDark);
	PieceSet.PieceScale := DefScale;
	PieceSet.PieceRounded := True;
	PieceSet.PieceShadows := 1;
	PieceSet.LastMoveArrow := True;
	PieceSet.LastMoveColor.Effect := ef16;
	PieceSet.LastMoveColor.Style := gsCross; //gsSolid;
	PieceSet.LastMoveColor.Colors[0] := clBlack; //PieceSet.ActiveSquare.Colors[0];
	PieceSet.LastMoveColor.Colors[1] := clBlack;
end;

procedure RWPieceSet(const Save: BG);
var
	Section: string;
	i: SG;
begin
	if Save = False then
		PieceSet := DefPieceSet;
//    DefaultPieceSet(PieceSet);

	Section := 'Piece Set';

	// Board
	RWDrawStyle(MainIni, 'Background', PieceSet.Background, Save);
	RWDrawStyle(MainIni, 'DarkSquare', PieceSet.DarkSquare, Save);
	RWDrawStyle(MainIni, 'LightSquare', PieceSet.LightSquare, Save);
	RWDrawStyle(MainIni, 'HighlitedSquare', PieceSet.ActiveSquare, Save);
	RWDrawStyle(MainIni, 'LastMoveColor', PieceSet.LastMoveColor, Save);
	RWDrawStyle(MainIni, 'LightSquare', PieceSet.LightSquare, Save);

	RWDrawStyle(MainIni, 'ssMeOk', PieceSet.SquareStatus[ssMeOk], Save);
	RWDrawStyle(MainIni, 'ssMeThe', PieceSet.SquareStatus[ssMeThe], Save);
	RWDrawStyle(MainIni, 'ssSomeTo', PieceSet.SquareStatus[ssSomeTo], Save);
	RWDrawStyle(MainIni, 'ssTheTo', PieceSet.SquareStatus[ssTheTo], Save);

//  MainIni.RWString(Section, 'Name', PieceSet.Name, Save);
	MainIni.RWBool(Section, 'GridLines', PieceSet.GridLines, Save);

	// Pieces
	for i := 1 to Length(GameNames) - 1 do
		MainIni.RWString(Section, GameNames[TGameType(i)] + 'PieceFileName', string(PieceSet.PieceName[TGameType(i)]), Save);
	for i := 0 to Length(PieceSet.PieceColor) - 1 do
		MainIni.RWNum(Section, 'PieceColor' + IntToStr(i), SG(PieceSet.PieceColor[i]), Save);
	MainIni.RWNum(Section, 'PieceScale', PieceSet.PieceScale, Save);
	MainIni.RWNum(Section, 'PieceShadows', PieceSet.PieceShadows, Save);
	MainIni.RWBool(Section, 'PieceRounded', PieceSet.PieceRounded, Save);
	MainIni.RWBool(Section, 'LastMoveArrow', PieceSet.LastMoveArrow, Save);
end;

(*-------------------------------------------------------------------------*)
procedure CreatePiece(i: SG; BIndex: SG);
var
//  i: SG;
	X, Y, GX, GY: SG;
begin
	X := ReqPieceSize[BIndex];
	Y := ReqPieceSize[BIndex];
	if not Assigned(BmpPieces[BIndex][i]) then
{     if Assigned(BmpPieces[BIndex][i]) then
			FreeAndNil(BmpPieces[BIndex][i]);}
		BmpPieces[BIndex][i] := TDBitmap.Create;
	if (BmpPieces[BIndex][i].Width <> X) or (BmpPieces[BIndex][i].Height <> Y) then
	begin
		BmpPieces[BIndex][i].SetSize(0, 0);
		if Assigned(BmpPieces[0][i]) then
		begin
{     if BmpPieces[0][i].Width = BmpPieces[0][i].Height then
			begin}
				GX := X;
				GY := Y;
{     end
			else if BmpPieces[0][i].Width > BmpPieces[0][i].Height then
			begin
				GX := X;
				GY := RoundDiv(X * BmpPieces[0][i].Height, BmpPieces[0][i].Width);
			end
			else
			begin
				GX := RoundDiv(X * BmpPieces[0][i].Width, BmpPieces[0][i].Height);
				GY := Y;
			end;
			if GX < 1 then GX := 1;
			if GY < 1 then GY := 1;}
			BmpPieces[BIndex][i].Transparent := True;
			BmpPieces[BIndex][i].TransparentColor := BmpPieces[0][i].TransparentColor;
			BmpPieces[BIndex][i].Resize(GX, GY, BmpPieces[0][i]);
		end;
	end;
end;

function PieceToBmp(Index: SG; Piece: TPiece): TDBitmap;
var
	i: SG;
begin
	if (Piece > 0) then
		i := 2 * (SG(Piece) - 1)
	else
		i := -2 * SG(Piece) - 1;

	if (i >= 0) and (i < 2 * PieceTypes) then
	begin
		if Index <> 0 then
			CreatePiece(i, Index);
		Result := BmpPieces[Index][i]
	end
	else
		Result := nil;
end;

procedure FreePieces(j: SG); overload;
var i: SG;
begin
	for i := 0 to High(BmpPieces[j]) do
	begin
		if Assigned(BmpPieces[j][i]) then
		begin
			FreeAndNil(BmpPieces[j][i]);
		end;
	end;
end;

procedure FreePieces; overload;
var j: SG;
begin
	for j := 0 to Length(ReqPieceSize) - 1 do
	begin
		FreePieces(j);
	end;
end;

procedure LoadPieces;
const
	NoPieceSize = 48;
var
	PieceX, PieceY: SG;

procedure DefaultPiece(i: SG);
var
	Text: string;
	Size: TSize;
begin
	BmpPieces[0][i].SetSize(PieceX, PieceY);
	BmpPieces[0][i].Bar(PieceColor[i mod (PlayerMax + 1)], ef16);
	BmpPieces[0][i].Border(PieceColor[2 + i and 1], PieceColor[(PlayerMax + 1) + i mod (PlayerMax + 1)], 2, ef16);
	BmpPieces[0][i].Canvas.Brush.Style := bsClear;
	BmpPieces[0][i].Canvas.Font.Name := 'Times New Roman';
	BmpPieces[0][i].Canvas.Font.Color := PieceColor[(PlayerMax + 1) + i mod (PlayerMax + 1)];
	BmpPieces[0][i].Canvas.Font.Size := PieceY div 2;
	Text := PieceToS(TSquare(i div 2 + 1), False);
	Size := BmpPieces[0][i].Canvas.TextExtent(Text);
	BmpPieces[0][i].Canvas.TextOut(
		(BmpPieces[0][i].Width - Size.cx) div 2,
		(BmpPieces[0][i].Height - Size.cy) div 2,
		Text);
end;

var
	ConvertOthers: BG;
	i: SG;
	Bmp: TDBitmap;
	LowColor: BG;
	InputFormat: (ifEmpty, ifUnknown, ifOne,
		ifHorz, ifHorz2, ifHorz3,
		ifVert, ifVert2, ifVert3);
	x, y: SG;
	s: string;
	Co: array[0..3] of TColor;
	BmpTransparent: BG;
	BmpTransparentColor: TColor;
begin
	PieceGameType := GameType;
	FreePieces;
	if GameType = gkNone then Exit;
	Bmp := nil;
	BmpTransparent := False;
	BmpTransparentColor := clNone;

	LowColor := True;
	if PieceSet.PieceName[GameType] <> '' then
	begin
		if (GameType = gtExplosion){can be automaticly generated} and (FileExists(FullDir(PieceSet.PieceName[GameType])) = False) then Exit;
		Bmp := TDBitmap.Create;
		Bmp.LoadFromFile(FullDir(PieceSet.PieceName[GameType]));
		LowColor := Bmp.ColorCount(16) <= 16;

		if Bmp.Empty then
		begin
			InputFormat := ifEmpty;
			PieceX := NoPieceSize;
			PieceY := NoPieceSize;
			ConvertOthers := False;
		end
		else if Bmp.Width = Bmp.Height then
		begin
			InputFormat := ifOne;
			PieceX := Bmp.Width;
			PieceY := Bmp.Height;
			ConvertOthers := True;
		end
		else if Bmp.Height * PieceTypes = Bmp.Width then
		begin
			InputFormat := ifHorz;
			PieceX := Bmp.Height;
			PieceY := Bmp.Height;
			ConvertOthers := True;
		end
		else if Bmp.Height * PieceTypes div 2 = Bmp.Width then
		begin
			InputFormat := ifHorz2;
			PieceX := Bmp.Height div 2;
			PieceY := Bmp.Height div 2;
			ConvertOthers := False;
		end
		else if Bmp.Height * 2 * PieceTypes = Bmp.Width then
		begin
			InputFormat := ifHorz3;
			PieceX := Bmp.Height;
			PieceY := Bmp.Height;
			ConvertOthers := False;
		end
		else if Bmp.Width * PieceTypes = Bmp.Height then
		begin
			InputFormat := ifVert;
			PieceX := Bmp.Width;
			PieceY := Bmp.Width;
			ConvertOthers := True;
		end
		else if Bmp.Width * PieceTypes div 2 = Bmp.Height then
		begin
			InputFormat := ifVert2;
			PieceX := Bmp.Width div 2;
			PieceY := Bmp.Width div 2;
			ConvertOthers := False;
		end
		else if Bmp.Width * 2 * PieceTypes = Bmp.Height then
		begin
			InputFormat := ifVert3;
			PieceX := Bmp.Width;
			PieceY := Bmp.Width;
			ConvertOthers := False;
		end
		else if (Bmp.Height mod PieceTypes = 0) and (Bmp.Height > 2 * Bmp.Width) then
		begin
			InputFormat := ifVert2;
			PieceX := Bmp.Width div 2;
			PieceY := Bmp.Height div PieceTypes;
			ConvertOthers := False;
		end
		else if (Bmp.Height mod (2 * PieceTypes) = 0)  and (Bmp.Height > 2 * Bmp.Width) then
		begin
			InputFormat := ifVert3;
			PieceX := Bmp.Width;
			PieceY := Bmp.Height div (2 * PieceTypes);
			ConvertOthers := False;
		end
		else if (Bmp.Width mod PieceTypes = 0)  and (Bmp.Width > Bmp.Height) then
		begin
			InputFormat := ifHorz2;
			PieceX := Bmp.Width div PieceTypes;
			PieceY := Bmp.Height div 2;
			ConvertOthers := False;
		end
		else
		begin
			InputFormat := ifOne;
			PieceX := Bmp.Width;
			PieceY := Bmp.Height;
			ConvertOthers := True;
{     InputFormat := ifUnknown;
			PieceX := NoPieceSize;
			PieceY := NoPieceSize;
			ConvertOthers := False;
			MessageD('Piece format not supported', mtError, [mbOk]);}
		end;
		BmpTransparent := Bmp.Transparent;
		BmpTransparentColor := Bmp.TransparentColor;
		Bmp.Transparent := False;
	end
	else
	begin
		InputFormat := ifUnknown;
		PieceX := NoPieceSize;
		PieceY := NoPieceSize;
		ConvertOthers := False;
	end;

	for i := 0 to 2 * PieceTypes - 1 do
	begin
		BmpPieces[0][i] := TDBitmap.Create;
		if InputFormat <> ifOne then
			BmpPieces[0][i].SetSize(PieceX, PieceY);
	end;

	if (GameType in [gtOthello, gtGomoku]) or ((GameType = gtDraughts) and Game.Variant.Options[voLongestCapture].Bool) then // D???
	begin
		PieceColor[0] := PieceSet.PieceColor[1];
		PieceColor[1] := PieceSet.PieceColor[0];
		PieceColor[2] := PieceSet.PieceColor[3];
		PieceColor[3] := PieceSet.PieceColor[2];
	end
	else
		PieceColor := PieceSet.PieceColor;

	case InputFormat of
	ifEmpty, ifUnknown:
	begin
		for i := 0 to (PlayerMax + 1) * PieceTypes - 1 do
		begin
			DefaultPiece(i);
		end;
	end;
	ifOne:
	begin
		BmpPieces[0][0] := Bmp; Bmp := nil;
		s := FullDir(DelFileExt(PieceSet.PieceName[GameType]));
		for i := 1 to PieceTypes - 1 do
		begin
			if BmpPieces[0][2 * i].LoadFromFileEx(s + PieceToS(TSquare(i + 1), False) + ExtractFileExt(PieceSet.PieceName[GameType])) = False then
			begin
				DefaultPiece(2 * i);
				if (SG(ConvertOthers and (LowColor = False)) and 1) <> 0 then
					BmpPieces[0][2 * i].Neg;
			end;
		end;
	end;
	ifHorz, ifVert:
	begin
		x := 0;
		y := 0;
		for i := 0 to PieceTypes - 1 do
		begin
			BmpPieces[0][2 * i].Bmp(0, 0, Bmp, x, y, x + PieceX - 1, y + PieceY - 1, ef16);
			case InputFormat of
			ifHorz: Inc(x, Bmp.Height);
			else Inc(y, Bmp.Width);
			end;
		end;
	end;
	ifHorz2, ifVert2:
	begin
		x := 0;
		y := 0;
		for i := 0 to PieceTypes - 1 do
		begin
			BmpPieces[0][2 * i].Bmp(0, 0, Bmp, x, y, x + PieceX - 1, y + PieceY - 1, ef16);
			case InputFormat of
			ifHorz2: Inc(x, PieceX);
			else Inc(y, PieceY);
			end;
		end;
		case InputFormat of
		ifHorz2:
		begin
			x := 0;
			y := Bmp.Height div 2;
		end
		else
		begin
			x := Bmp.Width div 2;
			y := 0;
		end;
		end;
		for i := 0 to PieceTypes - 1 do
		begin
			BmpPieces[0][2 * i + 1].Bmp(0, 0, Bmp, x, y, x + PieceX - 1, y + PieceY - 1, ef16);
			case InputFormat of
			ifHorz2: Inc(x, PieceX);
			else Inc(y, PieceY);
			end;
		end;
	end;
	ifHorz3, ifVert3:
	begin
		x := 0;
		y := 0;
		for i := 0 to 2 * PieceTypes - 1 do
		begin
			BmpPieces[0][2 * (i mod PieceTypes) + i div PieceTypes].Bmp(0, 0, Bmp, x, y, x + PieceX - 1, y + PieceY - 1, ef16);
			case InputFormat of
			ifHorz3: Inc(x, PieceX);
			else Inc(y, PieceY);
			end;
		end;
	end;
	end;
	if Assigned(Bmp) then
		Bmp.Free;

{ for i := 0 to PieceTypes - 1 do
	begin
//    BmpPieces[0][2 * i].TryTransparent;
		BmpPieces[0][2 * i].Transparent := Bmp.Transparent;
		BmpPieces[0][2 * i].TransparentColor := Bmp.TransparentColor;
	end;}

	if ConvertOthers then
	begin
		for i := 0 to PieceTypes - 1 do
		begin
//      BmpPieces[0][2 * i].TryTransparent;
			BmpPieces[0][2 * i + 1].CopyBitmap(BmpPieces[0][2 * i]);
			if LowColor then
			begin
				BmpPieces[0][2 * i].ChangeColor2(clWhite, clBlack, PieceColor[0], PieceColor[2]);
				BmpPieces[0][2 * i + 1].ChangeColor2(clWhite, clBlack, PieceColor[1], PieceColor[3]);
{       BmpPieces[0][2 * i].ChangeColor(clWhite, PieceColor[0]);
				BmpPieces[0][2 * i].ChangeColor(clBlack, PieceColor[2]);
				BmpPieces[0][2 * i + 1].ChangeColor(clBlack, PieceColor[3]);
				BmpPieces[0][2 * i + 1].ChangeColor(clWhite, PieceColor[1]);}
			end
			else
			begin
				BmpPieces[0][2 * i].Neg;
				BmpPieces[0][2 * i].ChangeBW(PieceColor[0]);
				BmpPieces[0][2 * i + 1].ChangeBW(PieceColor[3]);
{       BmpPieces[0][2 * i].TryTransparent;
				BmpPieces[0][2 * i + 1].TryTransparent;}
				BmpTransparent := False;
			end;
		end;
	end
	else
	begin
		for i := 0 to PieceTypes - 1 do
		begin
			if LowColor then
			begin
				BmpPieces[0][2 * i].ChangeColor2(clWhite, clBlack, PieceColor[0], PieceColor[2]);
				BmpPieces[0][2 * i + 1].ChangeColor2(clWhite, clBlack, PieceColor[3], PieceColor[1]);
{       BmpPieces[0][2 * i].ChangeColor(clWhite, PieceColor[0]);
				BmpPieces[0][2 * i].ChangeColor(clBlack, PieceColor[2]);
				BmpPieces[0][2 * i + 1].ChangeColor(clBlack, PieceColor[1]);
				BmpPieces[0][2 * i + 1].ChangeColor(clWhite, PieceColor[3]);}
			end
			else
			begin
				BmpPieces[0][2 * i].ChangeBW(PieceColor[0]);
				BmpPieces[0][2 * i + 1].ChangeBW(PieceColor[3]);
			end;
		end;
	end;

	for i := 0 to 2 * PieceTypes - 1 do
	begin
		if (BmpTransparent = False) or (LowColor = False) then
			BmpPieces[0][i].TryTransparent // Make transparent, if not loaded or ChangeBW applied
		else
		begin
			// Restore Transparent
			BmpPieces[0][i].Transparent := BmpTransparent;
			BmpPieces[0][i].TransparentColor := BmpTransparentColor;
		end;
	end;

	if PieceSet.PieceRounded then
	begin
		for i := 0 to 2 * PieceTypes - 1 do
		begin
			Co[0] := $A0A0A0;
			Co[1] := $A0A0A0;
{     Co[2] := $808080;
			Co[3] := clBlack;}
			BmpPieces[0][i].GenerateRGB(gfFadeIOH, Co, 0, ef04, nil);
{     Co[0] := clWhite;
			Co[1] := $808080;
			Co[2] := $808080;
			Co[3] := clBlack;
			BmpPieces[0][i].GenerateRGB(BmpPieces[0][i].TransparentColor, gfFade2x, Co, 0, ef16, nil);}
		end;
	end;

	// Small Version
	ReqPieceSize[3] := 12;
end;

(*-------------------------------------------------------------------------*)
procedure TfPieces.InitPiecesPaths;
begin
	EditPieces.Text := PieceSet.PieceName[GameType];
end;
(*-------------------------------------------------------------------------*)
procedure ChangePieceSet(ReloadBoard, ReloadPieces: BG);
begin
	if ReloadBoard then
	begin
		FreeBoards;
	end;
	UpdateBoards;
	if ReloadPieces then
		LoadPieces;
	DrawBoards;
end;

procedure TfPieces.ButtonCloseClick(Sender: TObject);
begin
	PieceSet := LPieceSet;
	ChangePieceSet(True, True);
	Close;
end;

procedure TfPieces.ButtonOkClick(Sender: TObject);
begin
	Close;
end;

procedure TfPieces.PieceSetToForm;
begin
	DisableChange := True;
	ComboBoxScale.Text := NToS(PieceSet.PieceScale);
	CBShadows.ItemIndex := Range(0, PieceSet.PieceShadows, CBShadows.Items.Count - 1);
	ButtonRounded.Down := PieceSet.PieceRounded;
	ButtonGridLines.Down := PieceSet.GridLines;
	ButtonWC0.Color := PieceSet.PieceColor[0];
	InitButton(ButtonWC0);

	ButtonBC0.Color := PieceSet.PieceColor[1];
	InitButton(ButtonBC0);

	ButtonWC1.Color := PieceSet.PieceColor[2];
	InitButton(ButtonWC1);

	ButtonBC1.Color := PieceSet.PieceColor[3];
	InitButton(ButtonBC1);

	DisableChange := False;
end;

procedure TfPieces.FormCreate(Sender: TObject);
var i: SG;
begin
	Background := baGradient;
	OpenPictureDialogP.Filter := AllPictures;

	CBShadows.Items.Add('None');
	for i := SG(ef16) to Length(EffectNames) - 1 do
		CBShadows.Items.Add(EffectNames[TEffect(i)]);

	MainIni.RWFormPos(Self, False);
	InitPiecesPaths;
end;

procedure TfPieces.FormShow(Sender: TObject);
begin
	LPieceSet := PieceSet;
	fMain.Design2.Checked := True;
	PieceSetToForm;
end;

procedure TfPieces.OpenFClick(Sender: TObject);
var
	W: SG;
	S: TFileName;
begin
	W := TComponent(Sender).Tag;
	case W of
	0: S := PieceSet.PieceName[GameType];
	end;
	S := FullDir(S);
	if ExecuteDialog(OpenPictureDialogP, S) then
	begin
		S := ShortDir(OpenPictureDialogP.FileName);
		case W of
		0: PieceSet.PieceName[GameType] := S;
		end;
		InitPiecesPaths;
		ChangePieceSet(False, True);
	end;
end;

procedure TfPieces.FormHide(Sender: TObject);
begin
	fMain.Design2.Checked := False;
end;

procedure TfPieces.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	MainIni.RWFormPos(Self, True);
end;

procedure TfPieces.ButtonDrawStyleClick(Sender: TObject);
var
	C: PDrawStyle;
	D: TDrawStyle;
begin
	case TDButton(Sender).Tag of
	0: C := @PieceSet.Background;
	1: C := @PieceSet.DarkSquare;
	2: C := @PieceSet.LightSquare;
	3: C := @PieceSet.ActiveSquare;
	4: C := @PieceSet.LastMoveColor;
	5: C := @PieceSet.SquareStatus[ssMeOk];
	6: C := @PieceSet.SquareStatus[ssSomeTo];
	7: C := @PieceSet.SquareStatus[ssTheTo];
	else Exit;
	end;
	D := C^;
	if GetStyle(AddSpace(ButtonNameToFileName(TDButton(Sender).Name)), C^, D, nil) then
		ChangePieceSet(True, False);
end;

procedure TfPieces.ControlChange(Sender: TObject);
var
	ReloadBoard, ReloadPieces: BG;
	i: SG;
begin
	if DisableChange = False then
	begin
		ReloadBoard := False;
		ReloadPieces := False;
		i := StrToValI(ComboBoxScale.Text, True, 25, DefPieceSet.PieceScale, 400, 1);
		ClearErrors;
		if PieceSet.PieceScale <> i then
		begin
			PieceSet.PieceScale := i;
			ReloadPieces := True;
		end;
		if PieceSet.PieceShadows <> CBShadows.ItemIndex then
		begin
			PieceSet.PieceShadows := CBShadows.ItemIndex;
		end;
		if PieceSet.PieceRounded <> ButtonRounded.Down then
		begin
			PieceSet.PieceRounded := ButtonRounded.Down;
			ReloadPieces := True;
		end;
		if PieceSet.GridLines <> ButtonGridLines.Down then
		begin
			PieceSet.GridLines := ButtonGridLines.Down;
			ReloadBoard := True;
		end;
		ChangePieceSet(ReloadBoard, ReloadPieces);
	end;
end;

var
	ColorIndex: SG;
procedure OnApplyColor(Color: TColor);
begin
	PieceSet.PieceColor[ColorIndex] := Color;
	ChangePieceSet(False, True);
	fPieces.PieceSetToForm;
end;

procedure TfPieces.ButtonWC0Click(Sender: TObject);
var
	B: TDButton;
begin
	B := TDButton(Sender);
	ColorIndex := B.Tag;
	GetColor(B.Hint, PieceSet.PieceColor[ColorIndex], DefPieceSet.PieceColor[ColorIndex], OnApplyColor);
end;

procedure TfPieces.DButtonDefaultClick(Sender: TObject);
begin
	PieceSet := DefPieceSet;
	ChangePieceSet(True, True);
	fPieces.PieceSetToForm;
end;

initialization
	DefaultPieceSet(DefPieceSet);
finalization
	FreePieces;
end.