//* File:     SDG\uMoves.pas
//* Created:  1997-01-01
//* Modified: 2005-10-03
//* Version:  2.1.35.309
//* Author:   Safranek David (Safrad)
//* E-Mail:   safrad at email.cz
//* Web:      http://safrad.webzdarma.cz

unit uMoves;

interface

uses
	uDForm, uTypes,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	Menus, ExtCtrls, uDImage, StdCtrls;

type
	TfMoves = class(TDForm)
		PopupMenuMoves: TPopupMenu;
		ScrollToActualMove1: TMenuItem;
		N30: TMenuItem;
		ImageGM: TDImage;
		procedure ImageGMFill(Sender: TObject);
		procedure ImageGMMouseMove(Sender: TObject; Shift: TShiftState; X,
			Y: Integer);
		procedure ImageGMMouseDown(Sender: TObject; Button: TMouseButton;
			Shift: TShiftState; X, Y: Integer);
		procedure FormCreate(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure FormDestroy(Sender: TObject);
		procedure ScrollToActualMove1Click(Sender: TObject);
		procedure PopupMenuMovesPopup(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	fMoves: TfMoves;
	EvaluationProfile,
	WideVariants,
	TimePerMove: BG;

procedure DrawMoves;

implementation

{$R *.dfm}
uses
	Math,
	uETypes, uEGen, uEBoard,
	uDBitmap, uGraph, uError, uDIni, uMenus, uFormat, uMath,
	uGame, uEngine, uBoard, uEBook, uPieces, uAnalys, uMain;

(*-------------------------------------------------------------------------*)

var
	FontHei,
	cMY1,
	cMX1,
	cMX2: SG;
	MaxMove: SG;

	// ToDo Autoscroll down
	// D??? WideVariants - SaveGame, GameMoves, PrintGame
{type
	TRec = packed record // 16
		X0, X1, Y: S4;
		Reserve: U4;
	end;
	Rec: array of TRec;}

procedure TfMoves.ImageGMFill(Sender: TObject);
const
	EvalSize = 64;
	Ratio = 4;
	StartHeight = 12;
	TimeHeight = 8;
var
	TmpMove: SG;
	TmpXY: SG;
	s: string;
	MaxMoveW: SG;
	x, x2, y: SG;
	i, n, ny: SG;
	M: PGameMove;
	Ms: PGameMoves;
	MoveIndex: SG;
	Bmp: TDBitmap;
	HPos: TPos;
	Vis: BG;
	R: TRect;
begin
	Bmp := ImageGM.Bitmap;

	// Head
	Bmp.Bar(clWindow, ef16);
//  Bmp.FormBitmap(clWindow);
	ImageGM.UserWidth := 0;
	ImageGM.UserHeight := 0;
	if Kinds.Count <= 0 then Exit;

	Bmp.Canvas.Brush.Style := bsClear;
	Bmp.Canvas.Font.Name := 'Arial'; //'Times New Roman';
	Bmp.Canvas.Font.Height := -StartHeight;
	// Init
	cMY1 := 16;
	FontHei := Bmp.Canvas.TextHeight('W');
	MaxMoveW := Bmp.Canvas.TextWidth('888.');
	cMX1 := MaxMoveW + 8;
	case MoveFormat of
	mfDraughts: s := 'Kw8xw8xw8xw8xw8xw8';
	mfChess: s := 'Pw8-w8';
	mfGO: s := 'Pw8';
	end;
	if Game.Variant.Options[voPromote].Num > 0 then s := s + '=W';
	if Game.Variant.Options[voMateKing].Bool then s := s + '+';

	cMX2 := Bmp.Canvas.TextWidth(s);
	if TimePerMove then
	begin
		Bmp.Canvas.Font.Height := -TimeHeight;
		s := '00:00:00.000';
		Inc(cMX2, Bmp.Canvas.TextWidth(s));
	end;
	if cMX2 < 64 then cMX2 := 64;
	Bmp.Canvas.Font.Height := -10;

	for i := 0 to PlayerMax do
	begin
		R.Left := -ImageGM.OfsX + cMX1 + i * cMX2 + 1;
		R.Top := -ImageGM.OfsY + 1;
		R.Right := R.Left + cMX2 - 1 - 2;
		R.Bottom := R.Top + cMY1 - 1 - 2;
		Bmp.Bar(R, PieceColor[i], ef16);
		Bmp.Border(R, clWhite, PieceColor[2 + i], 2, ef08);
		Bmp.Canvas.Font.Color := PieceColor[2 + i];
		DrawCutedText(Bmp.Canvas, R, taCenter, tlCenter, Game.PGNTags[TPGNTag(SG(ptWhite) + i)]);
	end;
	Bmp.Canvas.Font.Height := -StartHeight;

	// Moves
	TmpMove := -SG(Game.Variant.Pos.Side);
	y := cMY1 - ImageGM.OfsY;
	{$ifopt d+}
	if FCMove = PMove(@OMove) then
		IE('GMFill');
	{$endif}
	CopyPos(CPos, HPos);
	CopyPos(Game.Variant.Pos, CPos);
	TmpXY := 0;
	Ms := Game.FirstMove;
	while True do
	begin
		Vis := (y < Bmp.Height) and (y + FontHei > 0);
		if (Ms = nil) or (TmpMove < 0) then
		begin
			if Vis then
			begin
				if TmpMove < 0 then
				begin
					s := ' . . .';
				end
				else
				begin
					s := GameTerminationStr[Game.GameTermination];
				end;
				Bmp.Canvas.Font.Color := clWindowText;
				Bmp.Canvas.TextOut(-ImageGM.OfsX + cMX1 + cMX2 * (TmpXY mod (PlayerMax + 1)), y, s);
			end;
			if Ms = nil then Break;
		end
		else
		begin
			{$ifopt d+}
			if Ms.Count = 0 then IE('GMFill1');
			{$endif}
			M := @Ms.Moves[Ms.Actual];

			GenerateMoves;
			x2 := -ImageGM.OfsX + cMX1 + cMX2 * (TmpXY mod (PlayerMax + 1));
			x := x2;
			if M.Index = NullMoveIndex then
				PCMove := nil
			else if M.Index >= CMC then
			begin
				{$ifopt d+}
//        IE('GMFill2');
				{$endif}
				PCMove := nil;
			end
			else
			begin
				PCMove := PMove(SG(FCMove) + M.Index shl ShlTMove);
			end;
			DoMove;
			if Vis then
			begin
				FillPlus(PCMove, True);
				MoveToBmp(Bmp, x, y, PCMove, True, True);

				if Ms.Count > 1 then
					Bmp.Bar(x, y, x + 4, y + 4, clBlack, ef08);
				// Actual Move
				if TmpMove + 1 + Game.Variant.Pos.MoveIndex = Game.Pos.MoveIndex then
				begin
					Bmp.Bar(x2 + 1, y + 1, cMX2 - 1 + x2 - 1, y + FontHei - 1 - 1, clHighlight, ef08);
					Bmp.Border(x2, y, cMX2 - 1 + x2, y + FontHei - 1, clBlack, clWhite, 1, ef08);
				end;
			end;

			Ms := M.Moves;
			if Vis then
			begin
				Bmp.Canvas.Font.Color := clWindowText;

				s := MarkToStr(M, 0);

{       if M.Mark = 0 then
					s := ''
				else if M.Mark <= High(MoveMarks) then
					s := MoveMarks[M.Mark]
				else
				begin
					s := ' $' + NToS(M.Mark);
					Bmp.Canvas.Font.Height := -8;
				end;}
				if s <> '' then
				begin
					if s[1] = '$' then
						Bmp.Canvas.Font.Height := -8;
{         if Length(s) > 4 then
					begin
						SetLength(s, 4);
						s := s + '...';
					end;}
					Bmp.Canvas.TextOut(x, y, s);
					Inc(x, Bmp.Canvas.TextWidth(s));
				end;
				if TimePerMove then
				begin
					Bmp.Canvas.Font.Height := -TimeHeight;
					Bmp.Canvas.Font.Color := clHighlight{Text};
					x := -ImageGM.OfsX + cMX1 + cMX2 * (1 + (TmpXY mod (PlayerMax + 1)));
					s := MsToStr(M.MovTime, diSD, Precision, False);
					if s <> '' then
						Bmp.Canvas.TextOut(x - 1 - 2 - Bmp.Canvas.TextWidth(s), y, s);
				end;
				Bmp.Canvas.Font.Height := -StartHeight;
				if EvaluationProfile then
				begin
					if M.Analysis.Status.Score <> scoNone then
					begin
						x := -ImageGM.OfsX + cMX1 + cMX2 * 2 + EvalSize;

						if M.Analysis.Status.Score = 0 then
							n := 0
						else
						begin
							if CPos.Side <> 0 then
								n := -M.Analysis.Status.Score div Ratio
							else
								n := M.Analysis.Status.Score div Ratio;

							n := Range(-EvalSize, n, EvalSize);
						end;

						if CPos.Side <> 0 then
							ny := y
						else
							ny := y + FontHei div 2;

						Bmp.Bar(x, ny, x + n, ny + FontHei div 2 - 1, PieceSet.PieceColor[CPos.Side xor 1], ef16);
					end;
				end;
			end;
		end;

		if TmpXY mod (PlayerMax + 1) = PlayerMax then Inc(y, FontHei);
		Inc(TmpXY);
		Inc(TmpMove);
	end;
	CopyPos(HPos, CPos);
	ImageGM.UserHeight := y + FontHei + ImageGM.OfsY;
	MaxMove := TmpMove;

	// Move Numbers
	Bmp.Canvas.Brush.Style := bsClear;
	Bmp.Canvas.Font.Color := clWindowText;
	x := MaxMoveW - ImageGM.OfsX;
	MoveIndex := (Game.Variant.Pos.MoveIndex div (PlayerMax + 1)) + 1;
	y := cMY1 - ImageGM.OfsY;
	for TmpXY := 0 to (TmpMove + PlayerMax + SG(Game.Variant.Pos.Side mod (PlayerMax + 1))) div (PlayerMax + 1) - 1 do
	begin
		s := NToS(MoveIndex) + '.';
		Bmp.Canvas.TextOut(x - Bmp.Canvas.TextWidth(s), y, S);
		Inc(MoveIndex);
		Inc(y, FontHei);
	end;

	ImageGM.UserWidth := cMX1 + 2 * cMX2;
	if EvaluationProfile then
	begin
		ImageGM.UserWidth := ImageGM.UserWidth + 2 * EvalSize + 1;
	end;
end;

function CalcActMove(X, Y: SG): SG;
begin
	Inc(X, fMoves.ImageGM.OfsX);
	Inc(Y, fMoves.ImageGM.OfsY);

	if Y < cMY1 then
	begin
		Result := 0;
		Exit;
	end
	else if Y >= fMoves.ImageGM.UserHeight then
	begin
		Result := -1;
		Exit;
	end;
	Dec(Y, cMY1);

	if X < cMX1 then
	begin
		Result := (PlayerMax + 1) * (Y div FontHei) + 1;
	end
	else if X < cMX1 + (PlayerMax + 1) * cMX2 then
	begin
		Result := (PlayerMax + 1) * (Y div FontHei) + (X - cMX1) div cMX2 + 1 - SG(Game.Variant.Pos.Side);
	end
	else
		Result := -1;
	if Result > MaxMove then Result := MaxMove;
end;

function ChangeMove(const X, Y: SG; const TestOnly: BG): BG;
var GameActMove: SG;
begin
	Result := False;
	GameActMove := CalcActMove(X, Y);
	if (GameActMove >= 0) and (Game.Pos.MoveIndex - Game.Variant.Pos.MoveIndex <> GameActMove) then
	begin
		if TestOnly then
		begin
			Result := True;
		end
		else
		begin
			GoToMoveDraw(GameActMove);
		end;
	end;
end;

procedure TfMoves.ImageGMMouseMove(Sender: TObject; Shift: TShiftState; X,
	Y: Integer);
begin
	if (ImageGM.MouseAction = mwNone) and ImageGM.MouseL then
		ChangeMove(X, Y, False)
	else
	begin
		if (ImageGM.MouseAction = mwNone) and (ImageGM.MouseWhere in [mwNone, mwScroll]) and ChangeMove(X, Y, True) then
			ImageGM.Cursor := crHandPoint
		else
			ImageGM.Cursor := crDefault;
	end;
end;

procedure TfMoves.ImageGMMouseDown(Sender: TObject; Button: TMouseButton;
	Shift: TShiftState; X, Y: Integer);
begin
	if (ImageGM.MouseAction = mwNone) and (ImageGM.MouseWhere in [mwNone, mwScroll]) then
	begin
		case Button of
		mbLeft{, mbRight}:
		begin
			ChangeMove(X, Y, False);
		end;
		end;
	end;
end;

procedure TfMoves.FormCreate(Sender: TObject);
begin
	Background := baNone;
	MainIni.RWFormPos(Self, False);

	MenuCreate(fMain.Moves1, PopupMenuMoves.Items);
	MenuSet(PopupMenuMoves, fMain.OnAdvancedMenuDraw);
end;

procedure TfMoves.PopupMenuMovesPopup(Sender: TObject);
begin
	MenuUpdate(fMain.Moves1, PopupMenuMoves.Items);
end;

procedure TfMoves.FormDestroy(Sender: TObject);
begin
	MenuFree(PopupMenuMoves.Items);
end;

procedure DrawMoves;
begin
	if FormDraw(fMoves) then
	begin
		fMoves.ImageGM.Fill;
	end;
end;

procedure TfMoves.FormShow(Sender: TObject);
begin
	fMain.Moves2.Checked := True;
	DrawMoves;
end;

procedure TfMoves.FormHide(Sender: TObject);
begin
	fMain.Moves2.Checked := False;
end;

procedure TfMoves.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	MainIni.RWFormPos(Self, True);
end;

procedure TfMoves.ScrollToActualMove1Click(Sender: TObject);
var Y: SG;
begin
	Y := cMY1 + FontHei * ((Game.Pos.MoveIndex - 1 + SG(Game.Pos.Side)) div 2);
	if Y <> ImageGM.OfsY then
	begin
		ImageGM.OfsY := Y;
		ImageGM.Fill;
	end;
end;

end.