//* File:     SDG\uGameInfo.pas
//* Created:  1997-01-01
//* Modified: 2005-10-03
//* Version:  2.1.35.309
//* Author:   Safranek David (Safrad)
//* E-Mail:   safrad at email.cz
//* Web:      http://safrad.webzdarma.cz

unit uGameInfo;

interface

uses
	uTypes, uDForm,
	uGame,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, ExtCtrls, uDButton;

type
	TfGameInfo = class(TDForm)
		ButtonOk: TDButton;
		ButtonClose: TDButton;
		LabelEvent: TLabel;
		LabelBlack: TLabel;
		LabelWhite: TLabel;
		Bevel1: TBevel;
		LabelFileName: TLabel;
		LabelResult: TLabel;
		EditEvent: TEdit;
		EditBlack: TEdit;
		EditWhite: TEdit;
		EditDate: TEdit;
		EditF: TEdit;
		cbResult: TComboBox;
		ButtonApply: TDButton;
		LabelGame: TLabel;
		EditGame: TEdit;
		Bevel3: TBevel;
		Label1: TLabel;
		EditRound: TEdit;
		EditSite: TEdit;
		Label2: TLabel;
		Label3: TLabel;
		Label4: TLabel;
		EditVariant: TEdit;
		Label5: TLabel;
		EditMoveRule: TEdit;
	procedure EditChange(Sender: TObject);
		procedure ButtonCloseClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure ButtonOkClick(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure ButtonApplyClick(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
		GameInfoChanged: BG;
	end;

var
	fGameInfo: TfGameInfo;

procedure InitGameInfo;

implementation

uses
	uETypes, uETimer,
	uDIni, uStrings, uEngine, uFormat,
	uMain;

{$R *.dfm}

procedure TfGameInfo.EditChange(Sender: TObject);
begin
	GameInfoChanged := True;
end;

procedure TfGameInfo.ButtonCloseClick(Sender: TObject);
begin
	Close;
end;

procedure TfGameInfo.FormCreate(Sender: TObject);
var i: SG;
begin
	Background := baGradient;
	cbResult.Items.BeginUpdate;
	for i := 0 to Length(GameTerminationStr) - 1 do
		cbResult.Items.Add(GameTerminationStr[TGameTermination(i)]);
	cbResult.Items.EndUpdate;
	MainIni.RWFormPos(Self, False);
end;

procedure TfGameInfo.FormShow(Sender: TObject);
begin
	fMain.Information2.Checked := True;
	InitGameInfo;
end;

procedure TfGameInfo.FormHide(Sender: TObject);
begin
	fMain.Information2.Checked := False;
end;

procedure InitGameInfo;
var
	B: BG;
begin
	if FormDraw(fGameInfo) then
	begin
		B := Kinds.Count > 0;
		SetControlEnabled(fGameInfo, B);
		if B then
		begin
			fGameInfo.EditF.Text := Kinds.Items[Kinds.Index].FileName;
			fGameInfo.EditGame.Text := GameNames[GameType];
			fGameInfo.EditVariant.Text := VariantToStr(GameType, Game.Variant.Options);
			fGameInfo.EditMoveRule.Text := NToS(ConstLongDraw div 2);
//      fGameInfo.EditN.Enabled := True;
			fGameInfo.EditEvent.Text := Game.PGNTags[ptEvent];
			fGameInfo.EditSite.Text := Game.PGNTags[ptSite];
			fGameInfo.EditDate.Text := Game.PGNTags[ptDate];
			fGameInfo.EditRound.Text := Game.PGNTags[ptRound];
			fGameInfo.EditWhite.Text := Game.PGNTags[ptWhite];
			fGameInfo.EditBlack.Text := Game.PGNTags[ptBlack];
			fGameInfo.cbResult.ItemIndex := SG(Game.GameTermination);

			fGameInfo.GameInfoChanged := False;
//      fGameInfo.ButtonApply.Enabled := True;
			fGameInfo.ButtonOk.Enabled := True;
		end
		else
		begin
			fGameInfo.EditF.Text := '';
			fGameInfo.EditGame.Text := '';
			fGameInfo.EditVariant.Text := '';
			fGameInfo.EditMoveRule.Text := '';
//      fGameInfo.EditN.Enabled := False;
			fGameInfo.EditEvent.Text := '';
			fGameInfo.EditSite.Text := '';
			fGameInfo.EditDate.Text := '';
			fGameInfo.EditRound.Text := '';
			fGameInfo.EditWhite.Text := '';
			fGameInfo.EditBlack.Text := '';
			fGameInfo.cbResult.ItemIndex := 0;

//      fGameInfo.ButtonApply.Enabled := False;
//      fGameInfo.ButtonOk.Enabled := False;
		end;

	end;
end;

procedure TfGameInfo.ButtonOkClick(Sender: TObject);
begin
	ButtonApplyClick(Sender);
	Close;
end;

procedure TfGameInfo.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	MainIni.RWFormPos(Self, True);
end;

procedure TfGameInfo.ButtonApplyClick(Sender: TObject);
begin
	if fGameInfo.GameInfoChanged then
	begin
		Game.PGNTags[ptEvent] := fGameInfo.EditEvent.Text;
		Game.PGNTags[ptSite] := fGameInfo.EditSite.Text;
		Game.PGNTags[ptDate] := fGameInfo.EditDate.Text;
		Game.PGNTags[ptRound] := fGameInfo.EditRound.Text;
		Game.PGNTags[ptWhite] := fGameInfo.EditWhite.Text;
		Game.PGNTags[ptBlack] := fGameInfo.EditBlack.Text;
		Game.GameTermination := TGameTermination(cbResult.ItemIndex);
		Game.PGNTags[ptResult] := GameTerminationStr[Game.GameTermination];
		KindsChange;
		DrawOb(dpMoves);
	end;
end;

end.