unit uFEN;

interface

function FENToHTML: string;

implementation

uses
	SysUtils, Math,
	uTypes,
	uEngine, uETypes, uEBoard;

function FENToHTML: string;
const
	Size = 40;
	Colors: array[0..1] of Char = ('w', 'b');
	UD: array[0..1] of Char = ('u', 'd');
	LR: array[0..1] of Char = ('l', 'r');
var
	x, y: SG;
	FileName, Alt: string;
	h, v: BG;
	Width, Height: SG;
	Sq: TSquare;
	sx, sy: string;
	Index: SG;
begin
	Result := '';
	for y := -1 to SqYC do
	begin
//    Result := Result + '<tr>';
		for x := -1 to SqXC do
		begin
			Width := Size;
			Height := Size;
			h := (y = -1) or (y = SqYC);
			v := (x = -1) or (x = SqXC);
			Index := XYToI(x, SqY - y);
			if h or v then
				Sq := sqOut
			else
				Sq := Game.Variant.Pos.Board[Index];
			if Abs(Sq) <= PieceTypes then
			begin
				if Sq = sqEmpty then
				begin
					FileName := '';
					Alt := '_';
				end
				else
				begin
					FileName := Colors[SG(Sq < 0) and 1] + PieceToS(-Abs(Sq), False);
					Alt := PieceToS(Sq, False);
					if Sq < 0 then
						Alt := LowerCase(Alt);
				end;
				FileName := FileName + Colors[(x xor y) and 1];
			end
			else
			begin
				if v then
					Width := Width div 2;
				if h then
					Height := Size div 2;
				XYToS(XYToI(Min(Max(0, x), SqX), Min(Max(0, y), SqY)), sx, sy, ntChess);

				if h and v then
				begin
					Alt := '+';
					if (x = -1) and (y = -1) then
						FileName := 'lu'
					else if (x = -1) and (y = SqYC) then
						FileName := 'ld'
					else if (x = SqXC) and (y = -1) then
					begin
						FileName := 'ru';
						if Game.Variant.Pos.Side <> 0 then FileName := fileName + 'b';
					end
					else if (x = SqXC) and (y = SqYC) then
					begin
						FileName := 'rd';
						if Game.Variant.Pos.Side = 0 then FileName := fileName + 'w';
					end
					else
						FileName := '';
				end
				else if h then
				begin
					Alt := '-';
					FileName := sx + UD[SG(y <> -1) and 1];
				end
				else if v then
				begin
					Alt := '|';
					FileName := sy + LR[SG(x <> -1) and 1];
				end
				else
				begin
					Alt := '?';
					FileName := '';
				end;

			end;
			Result := Result + '<img alt="' + Alt + '" src="/F/' + FileName + '.png" width="' + IntToStr(Width) + '" height="' + IntToStr(Height) +  '" />';
		end;
		Result := Result + '<br />';
	end;
end;

end.