unit uESearch;

interface

uses
	Math,
	uTypes, uMath,
	uETypes;

type
	TAnalysisInfo = packed record // 64
		Depth, // Maximal Tree-Depth
//    ActDepth, // Actual Tree-Depth
		SelDepth: U1; // Stats and AbortDepth

		Score: TScore; // 2
		ScoreBound: TScoreBound; // 1
		Reserved0: U1;

		Alpha, Beta: TScore;

		MoveIndex, MoveCount: array[1..2] of S2;
		Move: array[1..2] of TMove;
		// 22
		Reserved: array[0..5] of U1; // 6

		HashNew,
		HashPos: U4;
		Time: U4;
		Nodes, NodesPerSec, AvgNodes: U8;
	end;
var
	AnalysisInfo: TAnalysisInfo;

type
	TWhere = (whNone, whTN, whTD, whReplay);
var
	Where: TWhere;
	Ext: (
		exNone,
		exStop, exRestart,
		exFin, exBook,
		exEnter
	);
type
	TAbortDepth = (adNone, adMaxDepth, adNoIncrement, adNoChoise, adLevel, adWin);
const
	AbortDepthStrings: array[TAbortDepth] of string = ('', 'Max Depth', 'No Increment', 'No Choise', 'Level', 'Win');
var
	AbortDepth: TAbortDepth;
	Presumption: BG;

	D, DPlus: SG;
	MC: array[1..MaxDepth] of TMoveIndex;
	MNX: array[1..MaxDepth] of SG;
	MX: array[1..MaxDepth] of SG;

	MoveInfosScore: array[0..MaxMoves] of TScore;
	MovesOrder: array[0..MaxMoves] of SG;//TMoveIndex;

	CBeginTime: U4; // When calculation starts

function GetDrawScore: TScore;
procedure  TryAbortDepth(Wher: SG);
procedure RunEngine;

implementation

uses
	{$ifndef UCI}
	uError, uClock, uGame,
	uMain, uAnalys, {$ifdef Log}uLog, uStrings, uFormat, {$endif}
	{$endif}
	uFiles, uSorts,
	uEngine, uEParams, uEHash, uEBoard, uEGen, uETimer;

var
// Depth Vars
	CHashA: array[1..MaxDepth] of THash;

	FAn: array[2..MaxDepth, 0..MaxMoves] of TMoveIndex; // First Move, Large array 64 kB
	CBestAn: array[2..MaxDepth, 2..MaxDepth] of TMoveIndex;
	Killer: array[U2{, 1..MaxDepth - 1{ Calibrate }] of SG; // Large array 256 kB
	ContPrior: array[1..MaxDepth] of U1;

// Time
	DepthTime, LastDepthTime: U4;
	DepthNodes, LastDepthNodes: U4;

	MaxD: SG; // Search Limit

	SrType: (stNormal, stWin, stLose);



(*-------------------------------------------------------------------------*)
const
	GrowFactor = 3; // Calibrate 2..n

function NextDepthTime: U8;
begin
	if LastDepthTime <= 0 then
		Result := GrowFactor * U8(DepthTime)
	else
		Result := Max(DepthTime, RoundDivU8(U8(DepthTime + 100) * (DepthTime + 100), LastDepthTime + 100)) + AnalysisInfo.Time;
end;

function NextDepthNodes: U8;
begin
	if LastDepthNodes <= 0 then
		Result := GrowFactor * U8(DepthTime)
	else
		Result := RoundDivU8(U8(DepthNodes) * DepthNodes, LastDepthNodes) + AnalysisInfo.Nodes;
end;

function GetDrawScore: TScore;
begin
	if Game.Variant.Options[voSuicide].Bool xor BG(D and 1) then
		Result := -AEP[eoContemptValue].Num
	else
		Result := AEP[eoContemptValue].Num;
end;

procedure TryAbortDepth(Wher: SG); // Wher: 0-Next Depth, 1-NewAnal, 2-Player do move, stop Presumption
var
	TimeLevel: BG;
	T: U8;
begin
	AbortDepth := adNone;
	case Game.Levels[ActLevel].Typ of
	ltUnknown, ltInfinite, ltFixedDepth, ltShortestWin, ltWinIn, ltEqual:
		TimeLevel := False;
	else
{   lvHourglass,
		lvMinimal,
		lvAverage,
		lvMaximal,
		lvTimeControls);}
		TimeLevel := True {$ifndef Debug} and (Where = whTD){$endif};
	end;

	if Wher = 0 then
	begin
		if AnalysisInfo.Depth >= MaxDepth then
		begin
			AbortDepth := adMaxDepth;
			Exit;
		end;
		if Game.Levels[ActLevel].Typ = ltShortestWin then
		begin
{     if (AnalysisInfo.Depth >= MaxD) then
			begin
				AbortDepth := adMaxD;
				Exit;
			end;}
		end
		else
		begin
			if AnalysisInfo.Depth + 1 >= MaxD then
			begin
				AbortDepth := adMaxDepth;
				Exit;
			end;
			if (AnalysisInfo.Depth > AnalysisInfo.SelDepth) and (NowHashPos = 0) then
			begin
				AbortDepth := adNoIncrement;
				Exit;
			end;
		end;
	end;

	if (Wher <> 1) then // <> NewAnal
	begin
		// Time level
		if TimeLevel and (Presumption = False) then
		begin
			if MC[1] = 1 then
			begin
				AbortDepth := adNoChoise;
				Exit;
			end;
			if (AnalysisInfo.Depth >= 1) then
			begin
				if Abs(MoveInfosScore[MovesOrder[0]]) >= scWin0 then
				begin
					AbortDepth := adWin; // Play and win/lose
					Exit;
				end;
			end;
			if SrType <> stNormal then
			begin
				AbortDepth := adWin;
				Exit;
			end;
			if Game.Levels[ActLevel].Typ = ltTimeControls then
				if AnalysisInfo.Time < Game.Levels[ActLevel].FreeTime then Exit;

			case Game.Levels[ActLevel].Typ of
			ltMinimal:
			begin
				if Game.Levels[ActLevel].TimeNodes = False then
				begin
					if AnalysisInfo.Time > Game.Levels[ActLevel].Time then
					begin
						AbortDepth := adLevel;
						Exit;
					end;
				end
				else
				begin
					if AnalysisInfo.Nodes > Game.Levels[ActLevel].Nodes then
					begin
						AbortDepth := adLevel;
						Exit;
					end;
				end;
			end;
{     ltAverage:
			begin
				if Game.Levels[ActLevel].TimeNodes = False then
				begin
					T := NextDepthTime;
					if (T + AnalysisInfo.Time) > 2 * Game.Levels[ActLevel].Time then
					begin
						AbortDepth := adLevel;
						Exit;
					end;
				end
				else
				begin
					T := NextDepthNodes;
					if (T + AnalysisInfo.Nodes) > 2 * Game.Levels[ActLevel].Nodes then
					begin
						AbortDepth := adLevel;
						Exit;
					end;
				end;
			end;
			ltMaximal:
			begin
				if Game.Levels[ActLevel].TimeNodes = False then
				begin
					T := NextDepthTime;
					if T > Game.Levels[ActLevel].Time then
					begin
						AbortDepth := adLevel;
						Exit;
					end;
				end
				else
				begin
					T := NextDepthNodes;
					if T > Game.Levels[ActLevel].Nodes then
					begin
						AbortDepth := adLevel;
						Exit;
					end;
				end;
			end;}
			ltTimeControls, ltHourglass, ltAverage:
			begin
				T := NextDepthTime;
				if T + AnalysisInfo.Time > 2 * TimeLimitAvg then
				begin
					AbortDepth := adLevel;
					Exit;
				end;
			end;
			end;
		end;

		{$ifndef Debug}if (Where = whTD) then{$endif}
		case Game.Levels[ActLevel].Typ of
		ltFixedDepth: if AnalysisInfo.Depth >= Game.Levels[ActLevel].MaxD then
		begin
			AbortDepth := adLevel;
			Exit;
		end;
		end;
	end
	else if Wher = 1 then
	begin
		if Game.Levels[ActLevel].Typ = ltShortestWin then
		begin
			if (MaxD < AnalysisInfo.Depth) then
			begin
				AbortDepth := adLevel;
				Exit;
			end;
		end
		else
		begin
			if MaxD < AnalysisInfo.Depth then
			begin
				AbortDepth := adLevel;
				Exit;
			end;
		end;
{   if TimeLevel and (SrType = stWin) then
		begin
			AbortDepth := adWin;
			Exit;
		end; da prednost matu 2.tahem v 1/1 pred matem 1.tahem v 1/X, proto pri nalezeni rychleho matu dojedem hloubku}
	end;
end;

procedure AddAnalysis(BestStatus: TSubtreeStatus);
var
	i: SG;
	NewSize: SG;
	HashPos: PHashPos;
	HPos: TPos;
	A: PAnalysis;
begin
	NewSize := AnalysisC + 1;
	if AllocByExp(Length(Analysis), NewSize) then
		SetLength(Analysis, NewSize);
	A := @Analysis[AnalysisC];
	A.Status.Score := BestStatus.Score;
	A.Status.ScoreBound := BestStatus.ScoreBound;
	A.Status.MoveCount := BestStatus.MoveCount;
	A.Status.VariantionCut := BestStatus.VariantionCut;
	A.Depth := AnalysisInfo.Depth;
	A.SelDepth := AnalysisInfo.SelDepth;
	A.Time := AnalysisInfo.Time;
{ if ScoreBound = sbLowerBound then
		A.NodesFrom := AnalysisInfo.Nodes;}
	A.Nodes := AnalysisInfo.Nodes;
	A.Moves[1] := RMoveToIndex[MX[1]];

	if NowHashPos > 0 then
	begin
		CopyPos(CPos, HPos);
		CopyPos(AStartPos, CPos);
		GenerateMoves;
		{$ifdef Debug}if A.Moves[1] >= CMC then IE('AddAnalysis1');{$endif}
		PCMove := PMove(SG(FCMove) + A.Moves[1] shl ShlTMove);
		DoMove;
		A.Status.MoveCount := 1;
		while True do
		begin
			HashPos := Pointer(UG(HashTable) + SizeOf(THashPos) * (CPos.Hash.Index and NowHashAnd));
			{$ifdef Debug}CheckHash(CPos);{$endif}

			if (HashPos.ScoreBound = sbExact{<> htNone D??? }) then
			begin
				// Some pos found
				if (HashPos.Code = CPos.Hash.Code) then
				begin
					if HashPos.MoveIndex = NullMoveIndex then Break;
					Inc(A.Status.MoveCount);
					A.Moves[A.Status.MoveCount] := HashPos.MoveIndex;
					if A.Status.MoveCount >= MaxAnalysisDepth then Break;
					GenerateMoves;
					{$ifdef Debug}
					if HashPos.MoveIndex >= CMC then
					begin
						IE('AddAnalysis2');
						Break;
					end;
					{$endif}
					PCMove := PMove(SG(FCMove) + HashPos.MoveIndex shl ShlTMove);
					DoMove;
				end
				else
					Break;
			end
			else
				Break;
		end;
		CopyPos(HPos, CPos);
	end
	else
	begin
		for i := 2 to Min(BestStatus.MoveCount, MaxAnalysisDepth) do
		begin
			{$ifdef Debug}
			if CBestAn[2, i] = NullMoveIndex then
				IE('AddAnalysis3');
			{$endif}
			A.Moves[i] := CBestAn[2, i];
		end;
{   if BestStatus[2].MoveCount > 1 then
			Move(CBestAn[2, 2], A.Moves[2], SizeOf(CBestAn[2, 2]) * (BestStatus[2].MoveCount - 1));}
	end;

	A.ActMove := A.Status.MoveCount;
	if A.Status.Score >= scWin0 then
	begin
		MaxD := 2 * (scWin - A.Status.Score) - 1;// D??? 3;
		SrType := stWin;
	end;

	{$ifndef UCI}
	if VisAnalysis = AnalysisC - 1 then
	begin
		Inc(VisAnalysis);
	end;
	{$endif}
	Inc(AnalysisC);

	DrawOb(dpAMoves);
	{$ifndef UCI}
	fMain.InitMenuAnalysis;
	if EnableAnalysisAutosave and (AnalysisInfo.Time >= SaveAnalysisTime) then
	begin
		WriteAnalysisToFile(WorkDir + DefAnalysisFile);
	end;
	{$endif}
end;

function AbortEqualMaximal: BG;
begin
	if Where <> whTD then
		Result := False
	else
	begin
		if Game.Levels[ActLevel].TimeNodes = True then
			Result := AnalysisInfo.Nodes >= TimeLimitMax
		else
			Result := AnalysisInfo.Time >= TimeLimitMax;
	end;
end;

function GetMoveHash(M: PMove): U2;
begin
	case MoveFormat of
	mfDraughts:
	begin
		TU2(Result).B0 := M.Sq[0];
		TU2(Result).B1 := M.Sq[M.Lng];
	end;
	mfChess:
	begin
		TU2(Result).B0 := M.FrSq;
		TU2(Result).B1 := M.ToSq;
	end;
	else
	begin
		Result := M.T;
	end;
	end;
end;

{$ifdef UCI}
procedure DrawRefutation;
var j: SG;
begin;
	if AEP[eoUCI_ShowRefutations].Bool then
	begin
		Analysis[0].Status.MoveCount := AnalysisInfo.Depth;
		Analysis[0].Moves[1] := MX[1];
		for j := 2 to Analysis[0].Status.MoveCount do
		begin
			Analysis[0].Moves[j] := MX[j];//CBestAn[2, j];
		end;
		TellGUI('info refutation ' + AnalysisToS(0));
	end;
end;
{$endif}

(*-------------------------------------------------------------------------*)
{$ifndef noengine}
var
	Stat: record
		Count, AvgMoves, Expadns, Gener: UG;
	end;

procedure UpdateAlphaBeta(Alpha, Beta: TScore);
begin
	AnalysisInfo.Alpha := Alpha;
	AnalysisInfo.Beta := Beta;
	DrawOb(dpAlphaBeta);
end;

var
	MovValue: array[0..MaxMoves] of SG;

	MovIndex: array[0..MaxDepth, 0..MaxMoves] of SG;
	MovHash: array[0..MaxDepth, 0..MaxMoves] of U2;

	HashBest: TMoveIndex;
	CMultiPV: SG;
	InitialMaxD: SG;
	PLastMove: array[1..MaxDepth] of PMove;
const
	OnePly = 1;

function DepthX(StartAlpha, StartBeta: TScore; const StartRemainDepth: S1): TSubtreeStatus;
label LNextMove, LBNextMove, LEndDepth, LNoDepth, LYesDepth, LOk;
const
	AspirationWindowSize = 32; // Fritz 8 window increment: 0.28, 0.56 etc., Ruffian 0.35
var
	// Moves
	StartMove: PMove;
	// Cycles
	i, AM: SG;
	// For Back
	LastPos: TPos; // BackMove not exists
{$ifdef Debug}
	LPos: TPos;
{$endif}

	// Direction
	Status: TSubtreeStatus;
	b: TScore;
	Abort: BG;
	RemainDepth: S1;

	// Help
	HashPos: PHashPos;
	Ok: BG;
	ScoreLower, ScoreUpper: TScore;
	Forc: BG;
	Dep2: BG;
begin
	{$ifdef Debug}
	if StartAlpha >= StartBeta then
		IE('StartAB');
	{$endif}

	// Init
	Result.Score := StartAlpha;
	Result.ScoreBound := sbLower;
	Result.VariantionCut := vcNone;
	Result.MoveCount := D;
	b := StartBeta;

	Abort := False;
	Inc(D); Inc(DPlus);
	StartMove := FCMove;
	Inc(SG(FCMove), MC[D] shl ShlTMove);
	if D > AnalysisInfo.SelDepth then
	begin
		AnalysisInfo.SelDepth := D;
		DrawOb(dpSelDepth);
	end;

	if D >= 2 then
	begin
		if AEP[eoNullMovePruning].Bool then
		begin
			if (MNX[D - 1] >= 0) and (CCheck[CPos.Side xor 1] = False) and (ContPrior[D] = 0) then MNX[D] := -1 else MNX[D] := 0;
		end
		else
			MNX[D] := 0;

		if D = 2 then
		begin
			UpdateAlphaBeta(StartAlpha, StartBeta);
			AnalysisInfo.MoveCount[2] := MC[2];
			DrawOb(dpMoveCount2);
		end;
	end
	else
		MNX[D] := 0;

	CHashA[D] := CPos.Hash;
	{$ifdef Debug}LPos := CPos;{$endif}
	//if @BackMove = nil then
	CopyPos(CPos, LastPos); // D??? not all for chess

	{$ifndef Thread}
	EventsBreak;
	if Ext <> exNone then goto LEndDepth;
	{$ifdef Debug}
	if ComparePos(LPos, CPos) = False then
	begin
		IE('SwitchProbem');
		CPos := LPos;
	end;
	{$endif}
	{$endif}

	{$ifdef Log}
	Inc(Stat.Count);
	Inc(Stat.AvgMoves, MC[D]);
	{$endif}
	{$ifdef Debug}if MC[D] = 0 then
	begin
		IE('MC0');
		goto LEndDepth;
	end;
	{$endif}

	if D > 1 then
	begin
		Dec(SG(FCMove), MC[D] shl ShlTMove);
		{$ifdef Debug}
		CBestAn[D, D] := NullMoveIndex;
		for AM := 2 to MaxDepth do
			CBestAn[D, AM] := NullMoveIndex;
		{$endif}
	end;
(*-------------------------------------------------------------------------*)
	repeat // Moves
		Dep2 := False;
		RemainDepth := StartRemainDepth;
		if D = 1 then
		begin
			MX[D] := MovesOrder[MNX[D]];
		end
		else
		begin
			if MNX[D] >= 0 then
			begin
				if MNX[D] = 0 then
				begin
					Inc(SG(FCMove), MC[D] shl ShlTMove);
					PCMove := StartMove; // Set Actual Move
					FillOrderU4(MovIndex[D], MC[D]);
					for i := 0 to MC[D] - 1 do
					begin
//            MovIndex[D, i] := i;
						MovHash[D, i] := GetMoveHash(PCMove);
						// Calibrate
{           if RemainDepth < 0 then
							MovValue[i] := -PCMove.Prior
						else}
							MovValue[i] := -(PCMove.Prior + 256 * Killer[MovHash[D, i]] {D??? work very bad});

						if Game.Variant.Options[voSuicide].Bool then
							MovValue[i] := - MovValue[i];

(*            if (PCMove.Prior >= 160) {and (HD < Depth + 4)} then
							MovValue[i] := -(PCMove.Prior + 256 * 128 * 65535)
						else
							MovValue[i] := -(PCMove.Prior + 256 * Killer[MovHash[D, i]{, D}]);*)
//            MovValue[i] := -(PCMove.Prior{ + 1 * Killer[MovHash[i], D]});
						Inc(SG(PCMove), SizeTMove);
					end;
					if FAn[D, MX[1]] <> NullMoveIndex then
					begin
						{$ifdef Debug}if FAn[D, MX[1]] > MC[D] then
							IE('FAn');{$endif}
						MovValue[FAn[D, MX[1]]] := Low(MovValue[0]) div 4;
						FAn[D, MX[1]] := NullMoveIndex; /// D??? use or not (use)
					end;
					if HashBest <> NullMoveIndex then
					begin
						{$ifdef Debug}if HashBest >= MC[D] then
							IE('HashBest');{$endif}
						MovValue[HashBest] := Low(MovValue[0]) div 2;
					end;
					// 10% speed
					if MNX[D] >= 12 { Calibrate } then SortType := stQuick else SortType := stInsertion;
					SortS4(False, False, PArraySG(@MovIndex[D, 0]), PArrayS4(@MovValue[0]), MC[D]);
				end;
				MX[D] := MovIndex[D, MNX[D]];
			end
			else
				MX[D] := NullMoveIndex;
		end;
		if MNX[D] >= 0 then
		begin
			PCMove := PMove(SG(StartMove) + MX[D] shl ShlTMove); // Set Actual Move
		end
		else
			PCMove := nil;

		PLastMove[D] := PCMove;

		if D <= 2 then
		begin
			AnalysisInfo.MoveIndex[D] := MNX[D];
			if PCMove = nil then
				FillChar(AnalysisInfo.Move[D], SizeOf(AnalysisInfo.Move[D]), 0)
			else
				AnalysisInfo.Move[D] := PCMove^;
			case D of
			1:
			begin
				// Skip disabled moves
				if MoveInfos[MX[D]].Disabled then
					goto LNextMove;

				AnalysisInfo.Score := MoveInfosScore[MX[D]];
				AnalysisInfo.ScoreBound := MoveInfos[MX[D]].ScoreBound;
				DrawOb(dpMove1);
				DrawOb(dpMoveScore1);

				if ((MoveInfosScore[MX[D]] <> scoNone) and (MoveInfosScore[MX[D]] < -scWin0))
				and (SrType <> stLose) and (not (MoveInfos[MX[D]].VariantionCut in [vcAlpha, vcBeta])) then
					goto LNextMove; // Skip moves which Loses
				DrawOb(dpNextBestMoves);
			end;
			2:
			begin
				if MNX[D] >= 0 then
				begin
					if MNX[D] >= 1 then
					begin
						AnalysisInfo.Score := Result.Score;
						AnalysisInfo.ScoreBound := sbUpper;
						DrawOb(dpMoveScore1);
					end;
					DrawOb(dpMove2);
				end;
			end;
			end;
		end;

		if MNX[D] >= 0 then
		begin
			// Skip normal move if Promote required by root
			if PCMove.Prior = 0 then
				goto LNextMove;
			if PCMove.Prior < ContPrior[D] then
				goto LNextMove;

			// Go to begin of Depth
			{$ifdef Debug}CheckHash(CPos);{$endif}
			if AbortEqualMaximal then
			begin
				Ext := exFin;
				goto LEndDepth;
			end;
			Inc(AnalysisInfo.Nodes);

			// Temp
			Status.Score := scoNone;
			Status.ScoreBound := sbExact;
			Status.VariantionCut := vcNone;
			Status.MoveCount := D;
			DoMove;

			// Recapture Extension
			if AEP[eoRecaptureExtension].Bool and (MoveFormat = mfChess) and (D > 1) then
			begin
				if (PCMove.ToSq = PLastMove[D - 1].ToSq) and (PLastMove[D - 1].F2 <> sqEmpty) then
					Inc(RemainDepth, OnePly);
			end;
			// Navratovy tah D???  ;
{     if D >= 3 then
			if (MX[D] <> NullMove) and (MX[D - 2] <> NullMove) then
			begin
				if MovHash[D, MX[D]] = Swap(MovHash[D - 2, MX[D - 2]]) then
					Dec(RemainDepth, 256);
			end; }

			// Hash Draw
			if FindDHash >= 1 then
			begin
				Status.Score := GetDrawScore;
				Status.VariantionCut := vcRepetition;
				goto LNoDepth;
			end;

			// Fast Draw
			if MoveFormat <> mfGO then
			begin
				AM := 1; // 2 - D and 1; D???
				while AM < D{ - 2} do
				begin
					if (CPos.Hash.A = CHashA[AM].A)then
					begin
						Status.Score := GetDrawScore;
						Status.VariantionCut := vcRepetition;
						goto LNoDepth;
					end;
					Inc(AM, 1{2});
				end;
			end;

			// FindHash
			HashBest := NullMoveIndex;
			if NowHashPos > 0 then
			begin
				HashPos := Pointer(UG(HashTable) + SizeOf(THashPos) * (CPos.Hash.Index and NowHashAnd));
				if (HashPos.ScoreBound <> sbNone) then
				begin // Some pos found
					if (HashPos.Code = CPos.Hash.Code) then
					begin // Same pos found
						HashBest := HashPos.MoveIndex;
						// Is usable
						if S1(HashPos.Depth) >= RemainDepth then // Je prozkoumana dostatecne hluboko
						begin
							Status.Score := HashPos.Score;
							if Status.Score >= scWin0 then
								Status.Score := Status.Score - D div 2
							else if Status.Score <= -scWin0 then
								Status.Score := Status.Score + D div 2;
							Status.ScoreBound := HashPos.ScoreBound;
							if CPos.Side <> 0 then
							begin
								Status.Score := -Status.Score;
								if Status.ScoreBound = sbLower then
									Status.ScoreBound := sbUpper
								else if Status.ScoreBound = sbLower then
									Status.ScoreBound := sbUpper;
							end;

							case Status.ScoreBound of
							sbExact:
							begin
								ScoreLower := HashPos.Score;
								ScoreUpper := HashPos.Score;
							end;
							sbLower: // <---|
							begin
								ScoreLower := -scMax;
								ScoreUpper := HashPos.Score;
							end;
							else // sbUpper: // |--->
							begin
								ScoreLower := HashPos.Score;
								ScoreUpper := scMax;
							end;
							end;
							Ok := False;
							if ScoreLower >= StartBeta then
							begin
								Status.Score := ScoreUpper;
								Status.ScoreBound := sbUpper;
								Status.VariantionCut := vcHashAlpha;
								Ok := True;
							end;
							if ScoreUpper <= StartAlpha then
							begin
								Status.Score := ScoreUpper;
								Status.ScoreBound := sbLower;
								Status.VariantionCut := vcHashBeta;
								Ok := True;
							end;
							Result.Score := Max(Result.Score, ScoreLower);
							b := Min(b, ScoreUpper);
							if Ok then
							begin
								// A je to jako kdyz zavolame Depth X
								Inc(HashStat.Found);
								CBestAn[DPlus, DPlus] := HashPos.MoveIndex;
								goto LNoDepth;
							end;
						end;
						Inc(HashStat.Missed);
					end
					else
					begin
						Inc(HashStat.Corrupt);
					end;
				end
				else
				begin
					// Pos not found
	//        Inc(HashMissed); some like HashNew
				end;
			end;

			Status := GenerateMoves;
			Status.Score := -Status.Score;
			{$ifdef Log}Inc(Stat.Gener);{$endif}
			{$ifdef Log}
			if (AnalysisInfo.Depth <= 4) and (D < 8) then
				Log.Add(StringOfChar(CharTab, D - 1) + MoveToStr(PCMove, False, True) + ':' + ScoreToStr(-Status.Score, CPos.Side, sfUCI, Status.ScoreBound){ +
			', ' + ScoreToStr(Alpha) + '..' + ScoreToStr(Beta)});{$endif}

			if Status.VariantionCut <> vcNone then goto LNoDepth;
		end // if MNX[D] >= 0 then
		else
		begin
			DoMove;
			CMaxPrior := 0;
		end;

		// Long Draw, no active move in next moves
		if (CRemove = 0) and (CPromote > 2) and (CPos.LongDraw + 1 >= ConstLongDraw) then
		begin
			Status.Score := GetDrawScore;
			Status.VariantionCut := vcMovesRule;
			goto LNoDepth;
		end;

		// Specific reduce-tree algorithmus
{   case GameType of
		gtChess, gtChineseChess, gtShogi:
		begin
			if (CSa < HighMtrl) and (CSp < HighMtrl) then
			if Game.Variant.Illegal = False then
			begin
				Status.Score := GetDrawScore;
				Status.VariantionCut := vcLowMaterial;
				case InsufficientMaterial(CPos, CSa, CSp) of
				2:
				begin
					goto LNoDepth;
				end;
				end;
			end;
		end;
		gtDraughts:
		begin
			if CRemove = 0 then
			begin
				// No win move in next moves
				if MaxD <= DPlus then
				begin
					Status.VariantionCut := vcSpecific;
					goto LNoDepth;
				end;
			end;
		end;
		end;}

		// Memory Limit, LYesDepth can not be before
		if DPlus >= MaxD then
		begin
			Status.VariantionCut := vcMaxDepth;
			goto LNoDepth;
		end;

		ContPrior[DPlus] := 0;
		if (AEP[eoCheckExtension].Bool) and (CMC = 1) then
		begin
			// Continue if there is only 1 move
			ContPrior[DPlus] := 0;
			goto LYesDepth;
		end;

		// Limit - used when must capture
		if (D >= 2 * AnalysisInfo.Depth + 6) and (CMC > 1) then // 4: Honzovy sachy, 12: Chess Genius 3, Fritz, Ruffian: Inf.
		begin
			Status.VariantionCut := vcLimit;
			goto LNoDepth;
		end;

		// Nucene brani
			if Game.Variant.Options[voMustCapture].Bool then
				if CRemove <> 0 then
				begin
					ContPrior[DPlus] := 0;
					goto LYesDepth;
				end;

		// Continue or Not
		if RemainDepth <= 0 then
		begin
			if AEP[eoCaptureExtension].Bool then
				ContPrior[DPlus] := Min(255, 130 - RemainDepth) // Calibrate
			else
				goto LNoDepth;
(*      SetStatus(Status.Score, vcCalm, D);
			if (-Alpha[DPlus] > Alpha[D]) or (MNX[D] = 0) then
			begin
				Alpha[D] := -Alpha[DPlus]; // D???

//      Beta[D] := -Alpha[DPlus];
				if Alpha[D] >= Beta[D] then goto LNoDepth;
			end;*)
		end
		else
			ContPrior[DPlus] := 0;


		// po souperove tahu se to jen zhorsi, lze pouzit nejsou-li zhorsujici tahy!
		if AEP[eoFutilityPruning].Bool then
			if (RemainDepth <= OnePly) and (CCheck[CPos.Side] = False) and (Status.Score <= StartAlpha) then
			begin
				Status.VariantionCut := vcFutility;
{       if Status.Score > Result.Score then
				begin
					Result := Status;
				end;}
				goto LNoDepth;
			end;

		// Tah k promene se nezapocitava
{   if GameType = gtDraughts then
			if (PCMove <> nil) and (PCMove.DraughtsMove = tmPromote) then Inc(RemainDepth[D], 128); D???}
		// Tah zapocitan
		Dec(RemainDepth, OnePly);

		if AEP[eoCheckExtension].Bool and CCheck[CPos.Side] then
		begin
			// Check +
			// Continue if there is check, it can be checkmate
			ContPrior[DPlus] := 0;
			goto LYesDepth;
		end;

		if ContPrior[DPlus] <> 0 then // Jsme-li za hloubkou prohlubujem jen braci tahy - hledani klidu
		begin
						// Prohlubovani je libovolne, pokud je to vyhodnejsi neprohlubuje se; Zde muze koncit varianta
(*      SetStatus(Status.Score, vcCalm, D);
			if (-Alpha[DPlus] <= Alpha[D]) then // Alpha[DPlus] >= -Alpha[D]
			begin
				SetStatus(Status.Score, vcAlpha, D);
				goto LNoDepth;
				// Je dostatecne dobry
			end
			else
//        if -Alpha[DPlus] >= Alpha[D] then
//        Alpha[D] := -Alpha[DPlus];  // Neck Window D???
			if Alpha[D] >= Beta[D] then
			begin
//        goto LNoDepth;
{       Abort := True;
				goto LBNextMove;}
			end;*)
		end;
		if MNX[D] < 0 then
			Dec(RemainDepth, 2 * OnePly);

//    if GameType = gtDraughts then CPromote := 0;

		if ContPrior[DPlus] > CMaxPrior then
		begin
			// No good moves in next depth
			Status.VariantionCut := vcDepth;
			goto LNoDepth;
		end;

		LYesDepth:
		Dep2 := True;
		{$ifdef Log}Inc(Stat.Expadns);{$endif}
		MC[DPlus] := CMC;

		if D = 1 then
		begin
			if (MNX[D] + 1 > CMultiPV) then
			begin
				SrType := stNormal;
				MaxD := InitialMaxD;
				{$ifdef Debug}if MoveInfosScore[MovesOrder[CMultiPV - 1]] = scoNone then
					IE('MoveOrder');{$endif}
				StartAlpha := MoveInfosScore[MovesOrder[CMultiPV - 1]];
				StartBeta := MoveInfosScore[MovesOrder[CMultiPV - 1]] + 1;
			end
			else
			begin
				SrType := stNormal;
				MaxD := InitialMaxD;
				if (MoveInfos[MX[D]].VariantionCut in [vcAlpha, vcBeta, vcNone]) then
				begin
					StartAlpha := -scMax;
					StartBeta := scMax;
				end
				else
				begin
					if MoveInfosScore[MX[D]] <= -scWin0 then
					begin
						// Reduce max depth if lose found
						MaxD := 2 * (scWin + MoveInfosScore[MX[D]]) - 3;
						SrType := stLose;
						StartAlpha := MoveInfosScore[MX[D]] + 1;
						StartBeta := scMax;
					end
					else if MoveInfosScore[MX[D]] >= scWin0 then
					begin
						// Reduce max depth if lose found
						MaxD := 2 * (scWin - MoveInfosScore[MX[D]]) - 3;
						SrType := stWin;
						StartAlpha := MoveInfosScore[MX[D]] + 1;
						StartBeta := scMax;
					end
					else
	//        if Abs(MoveInfosScore[MX[D]]) < scWin0 then
					begin
						StartBeta := -MoveInfosScore[MX[D]] + AspirationWindowSize; // 200 div Depth
						StartAlpha := -MoveInfosScore[MX[D]] - AspirationWindowSize; // 200 div Depth
					end;
				end;
			end;
			Status := DepthX(StartAlpha, StartBeta, RemainDepth);
		end
		else
			Status := DepthX(-b, -Result.Score, RemainDepth);

(*    if MNX[D] < 0 then
		begin
			DepthX(BestStatus, Alpha, Beta);
		end
		else
			{$ifdef Debug}CheckHash(CPos);{$endif}
			if (D = 1) or (AEP[eoAspirationWindow].Bool = False) then
			begin
				Alpha[DPlus] := -Beta[D];
				Beta[DPlus] := -Alpha[D];
				DepthX;
			end
			else
			begin
				Alpha[DPlus] := -Alpha[D] - 1;
				Beta[DPlus] := -Alpha[D];
				DepthX;
				if Ext <> exNone then
				begin
{         Abort := True;
					goto LBNextMove;}
					goto LEndDepth;
				end;
				if ((-Alpha[DPlus] > Alpha[D]) and (-Alpha[DPlus] < Beta[D])) then // Check for failure.
				begin
//          BestStatus[DPlus].Score := scoNone;
					Alpha[DPlus] := -Beta[D];
					Beta[DPlus] := -Alpha[D];
					GenerateMoves;
					DepthX; // Re-search
				end;
			end;
		*)
		if Ext <> exNone then
		begin
{     Abort := True;
			goto LBNextMove;}
			goto LEndDepth;
		end;
		{$ifdef Debug}if (CBestAn[DPlus, DPlus] >= MC[DPlus]) and (Ext = exNone) and (Status.MoveCount >= DPlus) and (CBestAn[DPlus, DPlus] <> NullMoveIndex) then
			IE('CBestAn');
		{$endif}
		LNoDepth:
(*
			if RemainDepth[D] <= 0 then
				AddHash(htExact, RemainDepth[D], {NullMove} MC[D] - 1, -Alpha[DPlus]);*)
		Forc := False;
		LOk:
(*    if Forc then
		begin
			ScoreBound := sbExact; // instability prevention
		end
		else
		begin
			if -Alpha[DPlus] <= Alpha[D] then
				ScoreBound := sbUpperBound
			else if -Alpha[DPlus] >= Beta[D] then
				ScoreBound := sbLowerBound
			else
				ScoreBound := sbExact;
		end;*)
		{$ifdef Debug}CheckHash(CPos);{$endif}

		if D = 1 then // Specific, saves analysis and finish search
		begin
			{$ifdef UCI}
			if MNX[D] > 0 then
			begin
				DrawRefutation;
			end;
			{$endif}

			// Move
			for i := 2 to AnalysisInfo.Depth do // BestStatus[2].MoveCount do
				FAn[i, MX[D]] := MX[i];//CBestAn[2, i];
			for i := Max(2, AnalysisInfo.Depth{BestStatus[2].MoveCount} + 1) to MaxDepth do
				FAn[i, MX[D]] := NullMoveIndex;

			// Score
			if (MoveInfos[MX[D]].Depth <> AnalysisInfo.Depth) or (MoveInfosScore[MX[D]] <> Status.Score) or (MoveInfos[MX[D]].VariantionCut <> Status.VariantionCut) then
			begin
				MoveInfosScore[MX[D]] := Status.Score;
				MoveInfos[MX[D]].ScoreBound := Status.ScoreBound;
				MoveInfos[MX[D]].VariantionCut := Status.VariantionCut;
				MoveInfos[MX[D]].Depth := AnalysisInfo.Depth;
				DrawOb(dpNextBestMoves);
			end;

{       if (Abs(BestStatus[2].Score) < scWin0) and ((Abs(BestStatus[1].Score) < scWin0) or (BestStatus[1].Score = scoNone))
				and (Depth > 1) and (SrType <> stLose) then MN3 = 0}
			if Forc or (MNX[D] < CMultiPV) or
			(
				(Status.Score > MoveInfosScore[MovesOrder[CMultiPV - 1]]) and
				(
					(SrType = stNormal) or (Abs(Status.Score) > scWin0)
				)
			) then

(*      if ({(BestStatus[1].Score < scWin0) or} (-BestStatus[2].Score > BestStatus[1].Score))
			and ((SrType = stNormal) or (-BestStatus[2].Score < -scWin0) or (-BestStatus[2].Score > scWin0)) then*)
{       if (-BestStatus[2].Score > BestStatus[1].Score)
			and ((SrType <> stLose) or (-BestStatus[2].Score < -scWin0)) then MN3 > 0}
			begin
				// Move
				for i := 2 to Status.MoveCount do
					FAn[i, MX[D]] := CBestAn[2, i];
				for i := Max(2, Status.MoveCount + 1) to MaxDepth do
					FAn[i, MX[D]] := NullMoveIndex;

				PCMove := PLastMove[D];
				{$ifdef Log}
				if (AnalysisInfo.Depth <= 4) and (D < 8) then
					Log.Add(StringOfChar(CharTab, D - 1) + '^^^' + MoveToStr(PCMove, False, True) {+ ' ' + ScoreToStr(-Alpha)});{$endif}

				AddAnalysis(Status);

				// Sort moves
				if (Forc = False) and (MNX[D] > 0) then
				begin
					i := MNX[D];
					while i > 0 do
					begin
						if Status.Score <= MoveInfosScore[MovesOrder[i - 1]] then Break;
						Dec(i);
					end;
					Move(MovesOrder[i], MovesOrder[i + 1], SizeOf(MovesOrder[0]) * (MNX[D] - i));
					MovesOrder[i] := MX[D];
				end;

				TryAbortDepth(1);
				if AbortDepth <> adNone then
				begin
					Ext := exFin;
{         Abort := True;
					goto LBNextMove;}
					goto LEndDepth;
				end;
				if (Status.ScoreBound <> sbExact) and (Forc = False) then
				begin
					if not (Game.Levels[ActLevel].Typ in [ltShortestWin, ltWinIn]) then
					begin
						// Aspiration Window fail
						Status := GenerateMoves;
						Status.Score := -Status.Score;
						MC[2] := CMC;
(*            if Status.ScoreBound = sbLower then
						begin
							Beta := scMax;
							Alpha := -Status.Score + 1;
						end
						else // if ScoreBound = sbUpperBound then
						begin
							Beta := -Status.Score - 1;
							Alpha := -scMax;
						end;*)
//            Result := DepthX(-StartBeta, -Status.Score); // Re-search
						Status := DepthX(-scMax, scMax, RemainDepth); // Re-search
						if Ext <> exNone then goto LEndDepth;
						Forc := True;
						goto LOk;
					end;
				end;
(*        else
				begin
{         if (BestStatus[1].Score < scWin0) then}
					if (not (Game.Levels[ActLevel].Typ in [ltShortestWin, ltWinIn])) then
					begin
						if (MNX[D] + 1 >= CMultiPV) then
						begin
							Alpha := -Alpha;
							Beta := -Alpha + 1;
						end
						else
						begin
							// Full Window
							Alpha := -scMax;
							Beta := +scMax;
						end;
					end
					else
					begin
						Alpha := +scWin0;
						Beta := +scMax;
					end;
				end;  *)
				Result := Status;
			end;
		end // D = 1
		else // if D > 1 then
		begin
			if (Status.Score > Result.Score) and (Status.Score < StartBeta) and (MNX[D] > 0) and (Dep2) then
			begin
				Result := DepthX(-StartBeta, -Status.Score, RemainDepth); // Re-search
			end;

			if Status.Score > Result.Score then
			begin
				PCMove := PLastMove[D];
				{$ifdef Log}
				if (AnalysisInfo.Depth <= 4) and (D < 8) then
					Log.Add(StringOfChar(CharTab, D - 1) + '^^^' + MoveToStr(PCMove, False, True){ + ' ' + ScoreToStr(-Alpha[DPlus])});{$endif}

				{$ifdef Debug}
				if (MX[D] >= MC[D]) and (MX[D] <> NullMoveIndex) then
					IE('MXD');
				{$endif}

				// Copy best variantion
				CBestAn[D, D] := MX[D];
				if Status.MoveCount >= DPlus then
					Move(CBestAn[DPlus, DPlus], CBestAn[D, DPlus], SizeOf(CBestAn[2, 2]) * (Status.MoveCount - DPlus + 1));

				{$ifdef Debug}
				for AM := DPlus to Status.MoveCount do
				begin
					if CBestAn[DPlus, AM] = NullMoveIndex then
						IE('CBestAn1');
					CBestAn[D, AM] := CBestAn[DPlus, AM];
				end;
				{$endif}
				Result := Status;
				if D >= 2 then
				begin
					CBestAn[D, D] := MX[D];
					{$ifdef Debug}
					if (CBestAn[D, D] >= MC[D]) and (Ext = exNone) and (CBestAn[D, D] <> NullMoveIndex) then
						IE('CBestAn2');
					{$endif}
				end;
				{$ifdef Debug}
{       AM := 1 + (D and 1);
				repeat
					if Alpha[DPlus] <= Alpha[AM] then
					begin
						IE('AM');
						Abort := True;
						goto LBNextMove;
					end;
					Inc(AM, 2);
				until AM > D;}
				{$endif}
			end;
			if AEP[eoAlphaBeta].Bool then
			if Result.Score >= StartBeta then
			begin
				Result.ScoreBound := sbUpper;
				Result.VariantionCut := vcBeta;
				// Cut-off
				Abort := True;
				goto LBNextMove;
			end;
			b := Result.Score + 1; // set new null window
		end;

		LBNextMove:

		// Back all
		if MNX[D] >= 0 then
		begin
			PCMove := PLastMove[D];
			BackMove(LastPos);
		end;

		{$ifdef Debug}
		if ComparePos(LPos, CPos) = False then
		begin
			IE('Back Move');
			CopyPos(LPos, CPos);
		end;
		if Ext = exNone then
			if Status.Score = scoNone then IE('Status');
		{$endif}

		if Abort then Break;
		LNextMove:
		Inc(MNX[D]);
	until MNX[D] >= MC[D];
	if Ext = exNone then
	begin
		if D >= 2 then
		begin
			{$ifdef Debug}
{     if Result.Score <= StartAlpha then
				Assert(Result.ScoreBound = sbLower)
			else if Result.Score >= StartBeta then
				Assert(Result.ScoreBound = sbUpper)
			else
				Assert(Result.ScoreBound = sbExact);}
			{$endif}
			AddHash(Result, RemainDepth, CBestAn[D, D]);
		end;
	end;

	LEndDepth:
	if Ext = exNone then
	if D >= 2 then
	begin
			if CBestAn[D, D] <> NullMoveIndex then
			begin
				// Calibrate
	//        Inc(Killer[MovHash[D, CBestAn[D, D]], D], MaxDepth - D); // D >, tak o min
				i := MovHash[D, CBestAn[D, D]];
				Inc(Killer[i], 1{MaxMoveBonus - MoveBonus[D] D???}); // D >, tak o min {D^2, 2^D)
				if Killer[i] > High(Killer[0]) div 512 then
				begin
					{$ifdef Debug}Echo('Killer table overflow');{$endif}
					for i := 0 to Length(Killer) - 1 do
						Killer[i] := Killer[i] div 2;
				end;
			end;
			{$ifdef Debug}
			if (CBestAn[D, D] >= MC[D]) and (Status.MoveCount >= D) and (CBestAn[D, D] <> NullMoveIndex) then
				IE('CBastAn');
(*      if D = 2 then D???
			begin
				for AM := 2 to BestStatus[2].MoveCount do
				begin
					{$ifdef Debug}
	//          if CBestAn[2, AM] = NullMove then IE('AM2');
					{$endif}
					FAn[MX[1], AM] := CBestAn[2, AM];
				end;
			end;*)
			{$endif}
	{     if D = 2 then
			begin
				SMN2 := -1;
				FillChar(AnalysisInfo.Move[1], SizeOf(AnalysisInfo.Move[1]), 0);
				DrawDepth2;
			end;}
		if D = 2 then
		begin
			AnalysisInfo.MoveIndex[2] := -1;
			FillChar(AnalysisInfo.Move[2], SizeOf(AnalysisInfo.Move[2]), 0);
		end;
	end
	else // D = 1
	begin
		MX[1] := -1;
		MNX[1] := -1;
		AnalysisInfo.MoveIndex[1] := -1;
		FillChar(AnalysisInfo.Move[1], SizeOf(AnalysisInfo.Move[1]), 0);
		DrawOb(dpMove1);
		DrawOb(dpNextBestMoves);
	end;
	Dec(D); Dec(DPlus);
	FCMove := StartMove;
	Result.Score := -Result.Score;
end;


{$ifdef Thread}

{ Important: Methods and properties of objects in VCL can only be used in a
	method called Using Synchronize, for example,

		Synchronize(UpdateCaption);

	and UpdateCaption could look like,

	procedure Parallel.UpdateCaption;
	begin
		fMain.Caption := 'Updated in a thread';
	end; }

{ Parallel }
(*-------------------------------------------------------------------------*)
constructor TParallel.Create;
begin
	FreeOnTerminate := True;
	inherited Create(False);
end;

procedure RunEngine;
begin
	Parallel := TParallel.Create;
	Parallel.Priority := TThreadPriority(PriorityEngineThread);
	Parallel.OnTerminate := fMain.ParallelDone;
end;
{$endif}

{$ifdef Debug}var Recur: SG;{$endif}

{$ifndef UCI}
function FreeSquares(var Board: TBoard): UG;
var i, Index: SG;
begin
	Result := 0;
	for i := 0 to UsedSquareCount - 1 do
	begin
		Index := UsedSquares[i];
		if Board[Index] = sqEmpty then
		begin
			Inc(Result);
		end;
	end;
end;
{$endif}

procedure {$ifndef Thread}RunEngine{$else}TParallel.Execute{$endif};
label LBookFound;
var
	i, j: SG;
	BookMax: SG;
	Alpha, Beta: SG;
begin
	try
	{$ifdef Debug}
	Inc(Recur); Assert(Recur = 1);{$endif}
	Presumption := False;

	D := 0; DPlus := 1;
	repeat
		Ext := exNone;

		SetTimeGo(tgNone);

		{$ifndef Thread}
		ResetEventsBreak;
		{$ifndef UCI}
		EventsBreak; // Required on stop when depth=0
		InitMenuTM;
		{$endif}
		{$endif}

		AnalysisInfo.Time := 0;
		if AEP[eoOwnBook].Bool and (Where = whTD) and (Game.Levels[ActLevel].Typ <> ltInfinite) then
		begin // Try find book move
			BookMax := 0;
			for i := 0 to OMC - 1 do
			begin
				if MoveInfos[i].BookCount > BookMax then
					BookMax := MoveInfos[i].BookCount;
			end;
			if BookMax > 0 then
			begin
				j := 0;
				AnalysisInfo.Nodes := 0;
				for i := 0 to OMC - 1 do
				begin
					Inc(AnalysisInfo.Nodes, MoveInfos[i].BookCount);
					if (MoveInfos[i].BookCount >= 1) and (MoveInfos[i].BookCount >= {BookAccept}RoundDiv(BookMax, Max(1, AEP[eoBookAccept].Num))) then
					begin
						MovesOrder[j] := i;
						Inc(j);
					end;
				end;
				if j > 0 then
				begin
					MovesOrder[0] := MovesOrder[Random(j)];
					Ext := exBook;
					goto LBookFound;
				end;
			end;
		end;

		// Clearing
		ClearAnalysisInfo(AnalysisInfo);
		AnalysisInfo.Nodes := 1; // Actual position is evaluated early

		if AbortEqualMaximal then
		begin
			Ext := exBook;
			goto LBookFound;
		end;

		{$ifdef Log}Log.Clear; Log.Start;{$endif}
		SrType := stNormal;
		{$ifdef Debug}
		FillU2(CBestAn, SizeOf(CBestAn) div 2, NullMoveIndex);
		FillChar(MC, SizeOf(MC), -1);
{   FillChar(Alpha, SizeOf(Alpha), -1);
		FillChar(Beta, SizeOf(Beta), -1);}
		{$endif}
		if AEP[eoRandomPlay].Bool then
			LoadEvaluation;

		DepthTime := 0;
		DepthNodes := 0;
		LastDepthTime := 0;
		LastDepthNodes := 0;

		// Game To Engine
		CopyPos(Game.Pos, CPos);
		MC[1] := OMC;
		AnalysisInfo.Score := OStatus.Score;
		AnalysisInfo.MoveCount[1] := MC[1];
		AnalysisInfo.MoveCount[2] := -1;
		AbortDepth := adNone;
		if Game.Levels[ActLevel].Typ = ltWinIn then InitialMaxD := Game.Levels[ActLevel].WinIn else InitialMaxD := MaxDepth;
		{$ifndef UCI}
		if GameType = gtGoMoku then
		begin
			i := FreeSquares(CPos.Board) + 1;
			if InitialMaxD > i then InitialMaxD := i;
		end;
		{$endif}
		MaxD := InitialMaxD;

		PCMove := PMove(@OMove[0]);
		for i := 0 to MC[1] - 1 do
		begin
			if Game.Variant.Options[voSuicide].Bool then
				MoveInfosScore[i] := PCMove.Prior
			else
				MoveInfosScore[i] := -PCMove.Prior;
			MovesOrder[i] := i;
			Inc(SG(PCMove), SizeTMove);
		end;
		SortS2(True, False, PArraySG(@MovesOrder[0]), PArrayS2(@MoveInfosScore[0]), MC[1]);
		for i := 0 to MC[1] - 1 do
		begin
			MoveInfosScore[i] := scoNone;
			MoveInfos[i].Depth := 0;
			MoveInfos[i].VariantionCut := vcNone;
		end;
		if Presumption then
		begin
			CMultiPV := MaxInt;
		end
		else
		begin
			FillChar(Killer, SizeOf(Killer), 0);
			AnalysisInfo.Depth := 0;
			FillU2(FAn, SizeOf(FAn) div 2, NullMoveIndex);
//      FillChar(FAn, SizeOf(FAn), 0);
			CMultiPV := AEP[eoMultiPV].Num;
		end;
		if HashSession = High(HashSession) then HashSession := 0 else Inc(HashSession);

		// Analysis Startup
		CopyPos(CPos, AStartPos);
		CopyPos(CPos, APos);

		// Space for Actual Variantion
		SetLength(Analysis, 0);
		SetLength(Analysis, 1);
		AnalysisC := 1;
		ClearAnalysis(Analysis[0]);

		// Run Clock
		if Where = whTN then
			SetTimeGo(tgMove)
		else if Where = whTD then
			SetTimeGo(tgGame)
		{$ifdef Debug}else if Where = whNone then IE('Where'){$endif};

		CBeginTime := BeginTime;
		{$ifndef UCI}
		UpdateMovTime(Game.Pos.Side);
		{$endif}
		DrawAnalysisInfo;
		DrawOb(dpAMoves); // Must be before copy to CMove
		DrawOb(dpNextBestMoves);

		// Copy moves from O to C
		Move(OMove[0], CMove[0], MC[1] shl ShlTMove);

		repeat // Incremental Depth
			TryAbortDepth(0);
			if AbortEqualMaximal then AbortDepth := adLevel;
			if (AbortDepth <> adNone) then
			begin
				Ext := exFin;
				Break;
			end;

			Inc(AnalysisInfo.Depth);
			DrawOb(dpDepth);
			{$ifdef Log}Log.Add('Depth ' + NToS(AnalysisInfo.Depth));{$endif}
			AnalysisInfo.SelDepth := 0;
			DrawOb(dpSelDepth);

			Alpha := -scMax;
			Beta := +scMax;
			case Game.Levels[ActLevel].Typ of
			ltShortestWin:
			begin
				MaxD := AnalysisInfo.Depth + 1;
				if AnalysisInfo.Depth > 1 then
				begin
					Alpha := +scWin0;
					Beta := +scMax;
				end;
			end;
			ltWinIn:
			begin
				if AnalysisInfo.Depth > 1 then
				begin
					Alpha := +scWin0;
					Beta := +scMax;
				end;
			end;
			else
			begin
{       if MaxD = InitialMaxD then
				begin
					BestStatus[1].MoveCount := 0;
					BestStatus[1].VariantionCut := vcNone;
				end;}
			end;
			end;
			UpdateAlphaBeta(Alpha, Beta);

			ContPrior[1] := 0;
			HashBest := NullMoveIndex;
			DepthX(Alpha, Beta, (AnalysisInfo.Depth - 1) * OnePly); // First Call
			MX[1] := -1;
			{$ifdef Log}Log.Add('Pos: ' + NToS(AnalysisInfo.Nodes) + ', SelDepth: ' + NToS(AnalysisInfo.SelDepth));{$endif}
			GetGTime;
			AnalysisInfo.Time := GTime - CBeginTime;

			if Ext <> exNone then Break;

			LastDepthTime := DepthTime;
			LastDepthNodes := DepthNodes;
			DepthTime := AnalysisInfo.Time - DepthTime;
			DepthNodes := AnalysisInfo.Nodes - DepthNodes;

			{$ifdef Debug}if AnalysisC = 0then IE('No Analysis after Depth 1'){$endif};
		until False; // Depth
		{$ifndef UCI}
		if (Where in [whTN, whTD]) then UpdateMovTime(Game.Pos.Side);
		{$endif}
		{$ifdef Log}
		if Stat.Count > 0 then
			Log.Add('AvgMoves: ' + FToS(Stat.AvgMoves / Stat.Count) + ', Expadns: ' + FToS(Stat.Expadns / Stat.Count) + ', Gener: ' + FToS(Stat.Gener / Stat.Count));

		Log.Stop;
		Log.Clear;
		{$endif}

		LBookFound:
		DrawOb(dpNodes);
		{$ifdef Debug}
		if AbortDepth <> adNone then
			Echo('Reason of Abort: ' + AbortDepthStrings[AbortDepth]);{$endif}

		case Ext of
		exStop:
		begin
			SetTimeGo(tgNone);
			Break;
		end;
		{$ifndef UCI}
		exEnter:
		begin
			Where := whNone;
			DoImportMove(AMin, False);
			if not (Where in [whTN, whTD]) then Break;
		end;
		{$endif}
		exRestart: // Pres failed
		begin

		end;
		exFin, // Abort by AbortDepth
		exBook: // Book Move
		begin
			if (Where = whTD) then
			begin
				{$ifndef UCI}ProgramDoMove;
				if (Where in [whTN, whTD]) then Continue;
				{$endif}
			end
			else
				SetTimeGo(tgNone);
			Break;
		end;
		{$ifdef Debug}
		else // exNone:
			IE('exNone');
		{$endif}
		end;
	until False;

	finally
	{$ifdef Debug}Dec(Recur);{$endif}
	{$ifndef UCI}
	Where := whNone; InitMenuTM;
	{$endif}
	end;
end;
{$else}
procedure RunEngine;
begin
end;
{$endif}



end.