unit uEParams;

interface

uses
	uOptions,
	uETypes;

// Engine Configuration
type
	TEngineOption = (
		// Book
		eoOwnBook,
		eoBookAccept,
		eoBookFile,
		// Special
//    eoPonder,
		// Evaluation
		eoContemptValue,
		eoRandomPlay,
		eoRandomValue,
		eoMaterial,
		eoPieceActivity,
		eoPawnStructure,
		eoPassedPawns,
		eoKingSafety,
		// Search
		eoMultiPV,
		eoAlphaBeta,
		eoAspirationWindow,
		eoFutilityPruning,
		eoNullMovePruning,
		eoCaptureExtension,
		eoRecaptureExtension,
		eoCheckExtension,
//    eoSelectivity,
		eoHash,
		eoClearHash
		// Show
		{$ifdef UCI}
		, eoUCI_ShowCurrLine,
		eoUCI_ShowRefutations
		{$endif});
const
	EO: array[TEngineOption] of TOption = (
		// Book
		(Typ: vsCheck; Default: 1),
		(Typ: vsSpin; Default: 4; Minimum: 1; Maximum: 256),
		(Typ: vsString; DefaultStr: {$ifndef UCI}'ECO\~' + {$endif} 'ECO.dat'),
		// Special
//    (Typ: vsCheck; Default: 0),
		// Evaluation
		(Typ: vsSpin; Default: 0; Minimum: {$ifdef Debug} - scMax{$else} - scWin0 + 1{$endif}; Maximum: {$ifdef Debug}scMax{$else}scWin0 - 1{$endif}),
		(Typ: vsCheck; Default: 0),
		(Typ: vsSpin; Default: 10; Minimum: 1; Maximum: 100),
		(Typ: vsSpin; Default: 100; Minimum: 0; Maximum: 1000),
		(Typ: vsSpin; Default: 100; Minimum: 0; Maximum: 1000),
		(Typ: vsSpin; Default: 3{4 je moc}; Minimum: 0; Maximum: 1000),
		(Typ: vsSpin; Default: 220; Minimum: 0; Maximum: 1000),
		(Typ: vsSpin; Default: 50; Minimum: 0; Maximum: 1000),
		// Search
		(Typ: vsSpin; Default: 1; Minimum: 1; Maximum: MaxMoves + 1),
		(Typ: vsCheck; Default: 1),
		(Typ: vsCheck; Default: 0),
		(Typ: vsCheck; Default: 1),
		(Typ: vsCheck; Default: 0),
		(Typ: vsCheck; Default: 1),
		(Typ: vsCheck; Default: 1),
		(Typ: vsCheck; Default: 1),
//    (Typ: vsSpin; Default: 4; Minimum: 0; Maximum: MaxDepth),
		(Typ: vsSpin; Default: 20; Minimum: 0; Maximum: 2048),
		(Typ: vsButton)
		// Show
		{$ifdef UCI}
		,
		(),
		()
		{$endif});
{   (Name: 'UCI_AnalyseMode').
		(Name: 'UCI_Elo'; Typ: vsSpin),
		(Name: 'UCI_LimitStrength'
		(Name: 'UCI_Opponent'; Typ: vsString;),}
var
	EngineOptionNames: array[TEngineOption] of string;

type
	PEngineParams = ^TEngineParams;
	TEngineParams = array[TEngineOption] of TParam;
var
	AEP: TEngineParams;

implementation

end.