unit uEBoard;

interface

uses
	uTypes,
	uETypes;

var
	SqX, SqY, // 0..
	SqXC, SqYC: SG; // 0..
	SqXC2: SG; // 0..

	UsedSquares: array[0..BoardSize - 1] of U4; // Reduced index to real index
	UsedSquareCount: SG; // Reduced index count

	StP, // Min(UsedSquares)
	EnP: UG; // Max(UsedSquares)

function PieceOnSquare(Sq: TSquare): BG;
procedure FillUsedSquares(var B: TBoard; Empty: BG);
function XYToI(const X, Y: SG): UG;
procedure IToXY(I: SG; out X, Y: SG);
{$ifdef Debug}function CompareFullBoard(const B1, B2: TBoard): BG;{$endif}
function CompareBoard(const B1, B2: TBoard): BG;
procedure CopyBoard(const SB: TBoard; out DB: TBoard);
function ComparePos(const B1, B2: TPos): BG;
procedure CopyPos(const SP: TPos; out DP: TPos);

implementation

uses
	{$ifndef UCI}
	uError,
	{$endif}
	uMath,
	uEGen, uEngine;

function PieceOnSquare(Sq: TSquare): BG;
begin
	Result := (Sq <> sqEmpty) and (Abs(Sq) <= PieceTypes);
end;

var
	IToXYA: array[0..BoardSize - 1] of record
		X, Y: SG;
	end;

procedure FillUsedSquares(var B: TBoard; Empty: BG);
label LCont;
var
	x, y: SG;
	xx, yy: SG;
	Index: SG;
begin
	UsedSquareCount := 0;
	for y := 0 to SqY do
	for x := 0 to SqX do
	begin
		case GameType of
		gtDraughts: // Mirror by Point with skipped squares
		begin
			if (x and 1) <> (y and 1) then goto LCont;
			xx := SqX - x;
			yy := SqY - y;
{     xx := x;
			yy := y;}
		end;
		gtChess:
		begin // Mirror by Line
			yy := SqY - y;
			if yy >= SqYC div 2 then
				xx := SqX - x
			else
				xx := x;

			if xx and 1 = 0 then
				xx := SqX div 2 - xx div 2
			else
				xx := SqX div 2 + (xx + 1) div 2;

{     if yy >= SqYC div 2 then
				xx := SqX - x
			else
				xx := x;

			if xx and 1 = 0 then
				xx := SqX div 2  + 1 + xx div 2
			else
				xx := SqX div 2 - xx div 2;}

{     if yy >= SqYC div 2 then
				xx := SqX - xx
			else
				xx := xx;}
		end;
		gtJungle: // Mirror by Point with skipped squares
		begin
			xx := x;
			yy := y;
{     if ((x = 0) or (x = SqX) or (x = SqX div 2) or (x = (SqX + 1) div 2))
			or ((y < 3) or (y > SqY - 3)) then
			begin

			end
			else
				goto LCont;}
		end;
		else // gtShogi: Mirror by Point
		begin
			xx := x;
			yy := y;
		end;
		end;
		Index := XYToI(xx, yy);
		if Empty then
			B[Index] := sqEmpty
		else if B[Index] = sqOut then goto LCont;
		UsedSquares[UsedSquareCount] := Index;

		Index := XYToI(x, y);
		IToXYA[Index].X := x;
		IToXYA[Index].Y := y;

		Inc(UsedSquareCount);
		LCont:
	end;
end;

(*-------------------------------------------------------------------------*)
function XYToI(const X, Y: SG{; GameType: TGameType; StP: SG; SqXC2: SG}): UG;
begin
	{$ifdef Debug}
{ if (X < 0) then
		IE('XYToI0');
	if (Y < -1) then
		IE('XYToI1');
	if (X > SqX) then
		IE('XYToI2');
	if (Y > SqY + 1) then
		IE('XYToI3');}
	{$endif}
		if (X < 0) or (Y < 0) or (X > SqX) or (Y > SqY) then
		begin
			Result := 0;
			Exit;
		end;
	if GameType = gtDraughts then
	begin
		if (X + SqXC2 * Y) and 1 <> 0 then
		begin
			Result := 0;
			Exit;
		end
		else
			Result := SG(StP) + (X + SqXC2 * Y) div 2
	end
	else
		Result := SG(StP) + X + SqXC2 * Y;
	{$ifdef Debug}
	if Result < StP then
		IE('XYToI4');
	if Result > EnP then
		IE('XYToI5');
	{$endif}
end;
(*-------------------------------------------------------------------------*)
procedure IToXY(I: SG; out X, Y: SG);
begin
	if I < SG(StP) then
	begin
		if I < 0 then // Captured Pieces
		begin
			X := SqXC + 1;
			Y := -I;
		end
		else
		begin
			X := 0;
			Y := 0;
		end;
	end
	else if I > SG(EnP) then
	begin
		X := SqXC;
		Y := SqYC;
	end
	else
	begin
		X := IToXYA[I].X;
		Y := IToXYA[I].Y;
	end;
end;

{$ifdef Debug}
function CompareFullBoard(const B1, B2: TBoard): BG;
var i: SG;
begin
	Result := True;
	for i := 0 to BoardSize - 1 do
	begin
		if B1[i] <> B2[i] then
		begin
			Result := False;
			Break;
		end;
	end;
end;
{$endif}

function CompareBoard(const B1, B2: TBoard): BG;
var {i, }Index: SG;
begin
	Result := True;
{ for i := 0 to UsedSquareCount - 1 do
	begin
		Index := UsedSquares[i];
		if B1[Index] <> B2[Index] then
		begin
			Result := False;
			Break;
		end;
	end;}
	for Index := StP to EnP do
	begin
		if B1[Index] <> B2[Index] then
		begin
			Result := False;
			Break;
		end;
	end;
end;

procedure CopyBoard(const SB: TBoard; out DB: TBoard);
//var i, Index: SG;
begin
	Move(SB[StP], DB[StP], EnP - StP + 1);
{ for i := 0 to UsedSquareCount - 1 do
	begin
		Index := UsedSquares[i];
		BD[Index] := BS[Index];
	end;}
end;

function ComparePos(const B1, B2: TPos): BG;
//var i: SG;
begin
	Result := CompareBoard(B1.Board, B2.Board);
	if Result = False then Exit;
	Result := SameData(@B1.Hash, @B2.Hash, SizeOf(B1) - SizeOf(B1.Board));
{ Result :=
		(B1.LongDraw = B2.LongDraw) and
		(B1.Side = B2.Side) and
		(B1.MoveIndex = B2.MoveIndex) and
		(B1.Castles[0, caK] = B2.Castles[0, caK]) and
		(B1.Castles[0, caQ] = B2.Castles[0, caQ]) and
		(B1.Castles[1, caK] = B2.Castles[1, caK]) and
		(B1.Castles[1, caQ] = B2.Castles[1, caQ]) and
		(B1.EP = B2.EP);
	if Result = False then Exit;
	Result := Result and CompareBoard(B1.Board, B2.Board);
	if Result = False then Exit;
	for i := 1 to PieceTypes do
	begin
		Result := Result and (B1.CapturedPieces[i] = B2.CapturedPieces[i]) and (B1.CapturedPieces[-i] = B2.CapturedPieces[-i]);
	end;}
	{$ifdef Debug}
	if Result then
	begin
		if (B1.Hash.A <> B2.Hash.A) then
			IE('ComparePos');
	end;
	{$endif}
end;

procedure CopyPos(const SP: TPos; out DP: TPos);
begin
	{$ifdef Debug}CheckHash(SP);{$endif}
	CopyBoard(SP.Board, DP.Board);
	Move(SP.Hash, DP.Hash, SizeOf(DP) - SizeOf(DP.Board));
end;
(*-------------------------------------------------------------------------*)


end.