//* File:     SDG\uClock.pas
//* Created:  1997-01-01
//* Modified: 2005-11-05
//* Version:  2.1.35.309
//* Author:   Safranek David (Safrad)
//* E-Mail:   safrad at email.cz
//* Web:      http://safrad.webzdarma.cz

unit uClock;

interface

uses
	uEngine, uETypes,
	uDForm, uTypes,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	ExtCtrls, StdCtrls, uDLabel, Menus;

type
	TfClock = class(TDForm)
		PopupMenuClock: TPopupMenu;
		PopupMenuPlay: TPopupMenu;
		procedure FormCreate(Sender: TObject);
		procedure FormResize(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure FormPaint(Sender: TObject);
		procedure PopupMenuClockPopup(Sender: TObject);
		procedure PopupMenuPlayPopup(Sender: TObject);
	private
		{ Private declarations }
		PanelWhoPlay: array[0..PlayerMax] of TDLabel;
		PanelTG: array[0..PlayerMax] of TDLabel;
		PanelTM: array[0..PlayerMax] of TDLabel;
		procedure PanelWhoPlayXClick(Sender: TObject);
	public
		{ Public declarations }
		PanelTS: TDLabel;
		procedure UpdateAnalog;
	end;

var
	fClock: TfClock;

	AutoFlag, Analog, RemainTime, TimeStrategy: BG;
	STotalTime: array[0..PlayerMax] of S4;

procedure DrawWhoPlay;
procedure UpdateMovTime(Player: UG);
procedure UpdateTotTime(Player: UG; Force: BG);

procedure DrawMoveTime0;
procedure DrawMoveTime1;
procedure DrawMoveTime01(Delayed: BG = False);

procedure DrawTotalTime(Player: UG);
procedure DrawTotalTime0;
procedure DrawTotalTime1;
procedure DrawTotalTime01(Delayed: BG = False);

implementation

{$R *.dfm}
uses
	Math,
	uEGen, uESearch, uETimer,
	uGraph, uDIni, uDBitmap, uMenus, uMath, uFormat,
	uGame, uMain, uLevels, uGameInfo, uPGN;


procedure DrawWhoPlay;
var
	i: UG;
begin
	if FormDraw(fClock) then
	begin
		for i := 0 to PlayerMax do
		begin
			fClock.PanelWhoPlay[i].Caption := PlayerTypeStr[Game.PlayerTypes[i]];
		end;
	end;
end;
(*-------------------------------------------------------------------------*)

// TfClock

procedure TfClock.PanelWhoPlayXClick(Sender: TObject);
var Tg: SG;
begin
	Tg := TMenuItem(Sender).Tag;
	Game.PlayerTypes[Tg] := Game.PlayerTypes[Tg] xor 1;

	fMain.InitMenuPlayerTypes;
	InitPlayEngineTags;
	DrawWhoPlay;
	InitPGN;
end;

(*-------------------------------------------------------------------------*)
procedure TfClock.FormCreate(Sender: TObject);
var i: SG;
begin
	Background := baNone;
	MainIni.RWFormPos(Self, False);
	MenuCreate(fMain.Clock1, PopupMenuClock.Items);
	MenuSet(PopupMenuClock, fMain.OnAdvancedMenuDraw);
	MenuCreate(fMain.PlayerTypes1, PopupMenuPlay.Items);
	MenuSet(PopupMenuPlay, fMain.OnAdvancedMenuDraw);

	for i := 0 to PlayerMax do
	begin
		PanelWhoPlay[i] := TDLabel.Create(Self);
		PanelWhoPlay[i].Alignment := taCenter;
		PanelWhoPlay[i].Tag := i;
		PanelWhoPlay[i].OnClick := PanelWhoPlayXClick;
		PanelWhoPlay[i].PopupMenu := PopupMenuPlay;
		PanelWhoPlay[i].SetBounds(0, 0, 0, 0);
		InsertControl(PanelWhoPlay[i]);
		PanelTG[i] := TDLabel.Create(Self);
		PanelTG[i].BevelOuter := bvNone;
		PanelTG[i].BorderStyle := bsSingle;
		PanelTG[i].Alignment := taRightJustify;
		PanelTG[i].PopupMenu := PopupMenuClock;
		InsertControl(PanelTG[i]);
		PanelTM[i] := TDLabel.Create(Self);
		PanelTM[i].BevelOuter := bvNone;
		PanelTM[i].BorderStyle := bsSingle;
		PanelTM[i].Alignment := taRightJustify;
		PanelTM[i].PopupMenu := PopupMenuClock;
		InsertControl(PanelTM[i]);
	end;
	PanelTS := TDLabel.Create(Self);
	PanelTS.BevelOuter := bvNone;
	PanelTS.BorderStyle := bsSingle;
	PanelTS.Alignment := taRightJustify;
	PanelTS.PopupMenu := PopupMenuClock;
	InsertControl(PanelTS);

	UpdateAnalog;
	PopupMenu := PopupMenuClock;
end;

procedure TfClock.UpdateAnalog;
var i: SG;
begin
	for i := 0 to PlayerMax do
	begin
		PanelTG[i].Visible := not Analog;
		PanelTM[i].Visible := not Analog;
	end;
	PanelTS.Visible := TimeStrategy;
	if Analog then
		Background := baUser
	else
		Background := baNone;
end;

procedure TfClock.FormDestroy(Sender: TObject);
var i: SG;
begin
	for i := 0 to PlayerMax do
	begin
		RemoveControl(PanelWhoPlay[i]);
		FreeAndNil(PanelWhoPlay[i]);
		RemoveControl(PanelTM[i]);
		FreeAndNil(PanelTM[i]);
		RemoveControl(PanelTG[i]);
		FreeAndNil(PanelTG[i]);
	end;
	MenuFree(PopupMenuClock.Items);
	MenuFree(PopupMenuPlay.Items);
end;
(*-------------------------------------------------------------------------*)
const
	TSHeight = 21;

procedure TfClock.FormResize(Sender: TObject);
var
	i: SG;
	x, y, w, h, h1: SG;
begin
	if ClientWidth and 1 <> 0 then ClientWidth := ClientWidth and $fffffffe;
	x := 0; // ClientWidth div 16;
	w := 8 * ClientWidth div 16 - x;
	h := ClientHeight;
	if TimeStrategy then Dec(h, TSHeight);
	h := h div 3;
	h1 := ClientHeight - (3 - 1) * h;
	if TimeStrategy then Dec(h1, TSHeight);
	for i := 0 to PlayerMax do
	begin
		y := 0; //ClientWidth div 16;
		PanelWhoPlay[i].SetBounds(x, y, w, h1);
		PanelWhoPlay[i].Font.Height := Min(h - 1, w div 6);
		Inc(y, PanelWhoPlay[i].Height);
		if TimeStrategy then
			Inc(y, TSHeight);
		PanelTG[i].SetBounds(x, y, w, h);
		PanelTG[i].Font.Height := Min(h - 1, w div 6);
		Inc(y, PanelTG[i].Height);
		PanelTM[i].SetBounds(x, y, w, h);
		PanelTM[i].Font.Height := Min(h - 1, w div 6);
		Inc(x, w);
	end;
	PanelTS.SetBounds(PanelTS.Left, h1, ClientWidth, TSHeight);
//  PanelTS.Font.Height := Min(h - 1, w div 6);
	if Analog then Fill;
end;
(*-------------------------------------------------------------------------*)
procedure DrawMoveTime(Player: UG);
var C: TColor;
begin
	if FormDraw(fClock) then
	begin
		if Analog = False then
		begin
			fClock.PanelTM[Player].Caption := MsToStr(MoveTime[Player], diSD, Precision, True);

			if (TimeGo <> tgNone) and (Player = Game.Pos.Side) then
				C := MixColors(clBtnFace, clHighlight)
			else
				C := clBtnFace;
			fClock.PanelTM[Player].Color := C;
		end;
	end;
end;

procedure DrawMoveTime0;
begin
	DrawMoveTime(0);
end;

procedure DrawMoveTime1;
begin
	DrawMoveTime(1);
end;

procedure DrawMoveTime01(Delayed: BG = False);
begin
	if Delayed then
	begin
		DrawOb(dpMoveTime0);
		DrawOb(dpMoveTime1);
	end
	else
	begin
		DrawMoveTime(0);
		DrawMoveTime(1);
	end;
end;

const
	PrecDiv: array[0..3] of UG = (1000, 100, 10, 1);

procedure UpdateMovTime(Player: UG);
begin
	if SMoveTime[Player] div PrecDiv[Precision] <> MoveTime[Player] div PrecDiv[Precision] then
	begin
		if Player = 0 then
			DrawOb(dpMoveTime0)
		else
			DrawOb(dpMoveTime1);
	end;
end;
(*-------------------------------------------------------------------------*)
procedure DrawTotalTime(Player: UG);
var
	GameT: U8;
	GameT2: S4;
	C, FontC: TColor;
begin
	if FormDraw(fClock) then
	begin
		if (TimeGo = tgGame) and (Game.Pos.Side = Player) then GameT := NowTotTime else GameT := TotTime[Player];
		STotalTime[Player] := GameT;
		if Analog then
		begin
			fClock.Fill;
		end
		else
		begin
			if RemainTime and (Game.Levels[ActualLevel(Player)].Typ = ltTimeControls) then
			begin
				GameT2 := SG(TimeLimitClock[Player]) - SG(GameT);
			end
			else
				GameT2 := GameT;
			fClock.PanelTG[Player].Caption := MsToStr(GameT2, diMSD, Precision, True);
			if (Game.Levels[ActualLevel(Player)].Typ = ltTimeControls) and (STotalTime[Player] > SG(TimeLimitClock[Player])) then
			begin
				C := MixColors(clBtnFace, clRed);
				FontC := NegMonoColor(C);
			end
			else
			begin
				C := clBtnFace;
				FontC := clWindowText;
			end;
			if fClock.PanelTG[Player].Color <> C then
			begin
				fClock.PanelTG[Player].Color := C;
				fClock.PanelTG[Player].Font.Color := FontC;
			end;
		end;
	end;
end;

procedure DrawTotalTime0;
begin
	DrawTotalTime(0);
end;

procedure DrawTotalTime1;
begin
	DrawTotalTime(1);
end;

procedure DrawTotalTime01(Delayed: BG = False);
begin
	if Delayed then
	begin
		DrawOb(dpTotalTime0);
		DrawOb(dpTotalTime1);
	end
	else
	begin
		DrawTotalTime(0);
		DrawTotalTime(1);
	end;
end;

procedure UpdateTotTime(Player: UG; Force: BG);
var
	GameT: SG;
begin
	if (TimeGo = tgGame) and (Game.Pos.Side = Player) then GameT := NowTotTime else GameT := TotTime[Player];

	if (TimeGo = tgGame) and (Game.Levels[ActualLevel(Player)].Typ = ltTimeControls) and
//    (GameT div 1000 = SG(TimeLimit[Player] div 1000)) then
		(GameT > SG(TimeLimitClock[Player])) then
	begin
		Echo('Time is up');
		if AutoFlag then
		begin
			OStatus.VariantionCut := vcTimeUp;
			SetGameTermination(CanWin);
			if Where <> whNone then
				Ext := exStop;
		end;
	end;

	if Force = False then
		if (STotalTime[Player] div SG(PrecDiv[Precision])) = (GameT div SG(PrecDiv[Precision])) then Exit;

	if Player = 0 then
		DrawOb(dpTotalTime0)
	else
		DrawOb(dpTotalTime1);
end;
(*-------------------------------------------------------------------------*)

procedure TfClock.FormShow(Sender: TObject);
begin
	fMain.Clock2.Checked := True;
	DrawWhoPlay;
	DrawTimeStrategy;
	UpdateAnalog;
	DrawTotalTime01;
	DrawMoveTime01;
	Fill;
end;

procedure TfClock.FormHide(Sender: TObject);
begin
	fMain.Clock2.Checked := False;
end;

procedure TfClock.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	MainIni.RWFormPos(Self, True);
end;

procedure TfClock.FormPaint(Sender: TObject);
const
	HourTick = 1000;
var
	GameT2: S4;
	Player: SG;
	GH, GM, GS, GD: UG;
	Bmp: TDBitmap;
	CX, CY, X, Y: SG;
	Len: SG;
	Angle: TAngle;
	i: SG;
	C: TColor;
	OfsY: SG;
begin
	Bmp := BackBitmap;
	for Player := 0 to PlayerMax do
	begin
		if Analog then
		begin
			if Sins = nil then
			begin
				GetMem(Sins, SizeOf(TAngle) * AngleCount);
				FillSinTable(Sins, AngleCount, SinDiv);
			end;

			if RemainTime and (Game.Levels[ActualLevel(Player)].Typ = ltTimeControls) then
			begin
				GameT2 := 12 * Hour + SG(STotalTime[Player]) - SG(TimeLimitClock[Player]);
			end
			else
				GameT2 := STotalTime[Player];
			msToHMSD(GameT2, GH, GM, GS, GD);
			GH := RoundDiv(GameT2, (12 * 60 * 60)) mod HourTick;

			if (Game.Levels[ActualLevel(Player)].Typ = ltTimeControls) and (STotalTime[Player] > SG(TimeLimitClock[Player])) then
				C := MixColors(clWindow, clRed)
			else
				C := clWindow;

			OfsY := PanelWhoPlay[0].Height;
			if TimeStrategy then Inc(OfsY, TSHeight);

			Bmp.Bar(
				(Bmp.Width div 2) * Player,
				OfsY,
				(Bmp.Width div 2) * Player + Bmp.Width div 2 - 1,
				Bmp.Height - 1,
				C, ef16);

			CX := Bmp.Width div 4 + (Bmp.Width div 2) * Player;
			CY := OfsY + (Bmp.Height - OfsY) div 2;
			Len := Max(0, Min(7 * Bmp.Width div 32, 7 * (Bmp.Height - OfsY - 7) div 16));

			for i := 0 to 59 do
			begin
				Angle := RoundDiv(AngleCount * i, 60);
				x := CX + RoundDiv(Len * (i + Sins[Angle mod AngleCount]), SinDiv);
				y := CY - RoundDiv(Len * (i + Sins[(AngleCount div 4 + Angle) mod AngleCount]), SinDiv);
				if i mod 5 = 0 then
				begin
					C := clHighlight; // clAqua
					Pix(Bmp.Data, Bmp.ByteX, x - 1, y - 1, PRGBA(@C), ef16);
					Pix(Bmp.Data, Bmp.ByteX, x - 1, y, PRGBA(@C), ef16);
					Pix(Bmp.Data, Bmp.ByteX, x, y - 1, PRGBA(@C), ef16);
					C := MixColors(clWindowText, clBlue); // clTeal
					Pix(Bmp.Data, Bmp.ByteX, x, y, PRGBA(@C), ef16);
					Pix(Bmp.Data, Bmp.ByteX, x + 1, y - 1, PRGBA(@C), ef16);
					Pix(Bmp.Data, Bmp.ByteX, x - 1, y + 1, PRGBA(@C), ef16);
					C := clWindowText; // clBlack
					Pix(Bmp.Data, Bmp.ByteX, x + 1, y, PRGBA(@C), ef16);
					Pix(Bmp.Data, Bmp.ByteX, x, y + 1, PRGBA(@C), ef16);
					Pix(Bmp.Data, Bmp.ByteX, x + 1, y + 1, PRGBA(@C), ef16);
				end
				else
				begin
					C := clWindowText; // $73B0BB;
					Pix(Bmp.Data, Bmp.ByteX, x, y, PRGBA(@C), ef16);
					Pix(Bmp.Data, Bmp.ByteX, x + 1, y, PRGBA(@C), ef16);
					Pix(Bmp.Data, Bmp.ByteX, x, y + 1, PRGBA(@C), ef16);
					C := LighterColor(clWindowText);// $FDFFAB;
					Pix(Bmp.Data, Bmp.ByteX, x + 1, y + 1, PRGBA(@C), ef16);
				end;
			end;

			Bmp.DrawHand(CX + 2, CY + 2, RoundDiv(AngleCount * GH, HourTick),
				10 * Len div 16, 6, clWindowText{ $73B0BB}, ef16);
			Bmp.DrawHand(CX + 2, CY + 2, RoundDiv(AngleCount * GM, 60),
				14 * Len div 16, 4, clWindowText{ $73B0BB}, ef16);
			Bmp.DrawHand(CX + 1, CY + 1, RoundDiv(AngleCount * GS, 60),
				14 * Len div 16, 1, clWindowText{ $73B0BB}, ef16);

			C := clHighlight;
			Bmp.DrawHand(CX, CY, RoundDiv(AngleCount * GH, HourTick),
				10 * Len div 16, 6, ColorDiv(C, 32768), ef16);
			Bmp.DrawHand(CX, CY, RoundDiv(AngleCount * GM, 60),
				14 * Len div 16, 4, C, ef16);

			Bmp.DrawHand(CX, CY, RoundDiv(AngleCount * GS, 60),
				14 * Len div 16, 1, clWindowText{ $030504}, efNeg);
			if Precision <> 0 then
			begin
				Bmp.DrawHand(CX, CY, RoundDiv(AngleCount * GD, 1000),
					12 * Len div 16, 1, clGrayText, ef08);
			end;

{     if (Game.Levels[ActualLevel(Player)].Typ = ltTimeControls) and (STotalTime[Player] > SG(TimeLimit[Player])) then
			begin
				s := 'Time is up';
				Bmp.Canvas.Brush.Style := bsClear;
				Bmp.Canvas.TextOut(((Bmp.Width div 2 - Bmp.Canvas.TextHeight(s)) div 2) + (Bmp.Width div 2) * Player , Bmp.Height -
					Bmp.Canvas.TextHeight(s) - 8, s);
			end;}
		end;
	end;
end;

procedure TfClock.PopupMenuClockPopup(Sender: TObject);
begin
	MenuUpdate(fMain.Clock1, PopupMenuClock.Items);
end;

procedure TfClock.PopupMenuPlayPopup(Sender: TObject);
begin
	MenuUpdate(fMain.PlayerTypes1, PopupMenuPlay.Items);
end;

end.