//* File:     SDG\uBoard.pas
//* Created:  1997-01-01
//* Modified: 2005-11-06
//* Version:  2.1.35.309
//* Author:   Safranek David (Safrad)
//* E-Mail:   safrad at email.cz
//* Web:      http://safrad.webzdarma.cz

unit uBoard;

interface

uses
	uTypes, uDForm, uDBitmap, uDImage,
	uGame,
	uEngine, uETypes,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	ExtCtrls, Menus, ExtDlgs;

type
	PBoardSize = ^TBoardSize;
	TBoardSize = record
		Width, Height, SquareSize, BorderSize, SquareBorderSize: SG;
		MaxX, MaxY: SG;
	end;

	TfBoard = class(TDForm)
		PopupMenuBoard: TPopupMenu;
		Image: TDImage;
		procedure FormKeyDown(Sender: TObject; var Key: Word;
			Shift: TShiftState);
		procedure ImageMouseDown(Sender: TObject; Button: TMouseButton;
			Shift: TShiftState; X, Y: Integer);
		procedure ImageMouseMove(Sender: TObject; Shift: TShiftState; X,
			Y: Integer);
		procedure PopupMenuBoardPopup(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure FormResize(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure ImageFill(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure ImageMouseUp(Sender: TObject; Button: TMouseButton;
			Shift: TShiftState; X, Y: Integer);
	private
		BoardSize: TBoardSize;

		MouseCX, MouseCY: SG;
		Slide: (psNone, psMouseUp, psMouse, psTimer);
		SlideTarget: S2; // Piece on this square is not draw
		SlidePiece: TPiece;
		SlideIndex, MaxSlide: UG;
		SlideFrom, SlideTo, SlideActual, SlideDif: TPoint;
		NeedRepaint: BG;
		NextSlideTime: U4;

		procedure SquareClick;
		procedure DrawBoardMove(P: PPos; M: PMove);
		function GXYToXY(GX, GY: SG; out X, Y: SG): BG;
	public
		BIndex: SG; // 1 Board, 2 Analysis Board
		BmpBoard: TDBitmap;
		procedure Timer;
		procedure UpdateBoard;
		procedure Draw;
		{$WARNINGS OFF}
		constructor Create(AOwner: TComponent; BoardIndex: SG);
		destructor Destroy(AOwner: TComponent);
	end;
	{$WARNINGS ON}

{const
	biGame = 1;
	biAnalysis = 2;}
var
	fBoard: array[1..2] of TfBoard;

procedure DrawPiece(BoardSize: PBoardSize; BmpB: TDBitmap; GX, GY: SG; H: TSquare; BIndex, Index: SG);

procedure DrawBoard(BIndex: SG);
procedure DrawBoards;
procedure UpdateBoards;
procedure PosToBmp(BmpB: TDBitmap; var BmpBoard: TDBitmap; BoardSize: PBoardSize; BPos: PPos; SquareStatus: PSquaresStatus;
	Slide: BG; SlidePiece: TPiece; SlideTarget: SG; const SlideFrom, SlideActual: PPoint; BIndex: SG);

procedure FillBoardSize(var BoardSize: TBoardSize; BIndex: SG);

procedure DrawBoardMove(BIndex: SG; P: PPos; M: PMove);
procedure FreeBoards;

var
	// Board Menu
	Rotated: SG; // First player is bottom, left, top, right

	SideToMove: BG;
type
	TCoordinatesPosition = (cpAround, cpSquare, cpOff);
var
	Coordinates: TCoordinatesPosition;
	SquareHighlight: 0..2 = 1;
	CapturedPieces: BG;
	ActiveSquare: BG;
	MouseCursor: TCursor = crHandPoint;

	Visi: array[0..PlayerMax] of SG;
	SavedFileName: TFileName = 'Board.png';
	SavedWidth: SG = 800;
	SavedHeight: SG = 600;
	OneClickMove: BG;
	SlidePieces: BG;
const
	DefSlideTime = 400;
var
	SlideTime: U4 = DefSlideTime;

implementation

{$R *.dfm}
uses
	Math, Types,
	uEBoard, uESearch, uETimer, uEGen,
	uFiles, uGraph, uMenus, uError, uDIni, uStrings, uMath, uFormat,
	uMain, uPieces, uSetup;

procedure FreeBoards;
var i: SG;
begin
	for i := Low(fBoard) to High(fBoard) do
		if Assigned(fBoard[i]) then FreeAndNil(fBoard[i].BmpBoard);
end;

procedure DrawBoard(BIndex: SG);
begin
	if FormDraw(fBoard[BIndex]) then
		fBoard[BIndex].Image.Fill;
end;

procedure DrawBoards;
var i: SG;
begin
	for i := Low(fBoard) to High(fBoard) do
		DrawBoard(i);
end;

procedure UpdateBoards;
var i: SG;
begin
	for i := Low(fBoard) to High(fBoard) do
		if Assigned(fBoard[i]) then
			fBoard[i].UpdateBoard;
end;

procedure DrawBoardMove(BIndex: SG; P: PPos; M: PMove);
begin
	if FormDraw(fBoard[BIndex]) then
		fBoard[BIndex].DrawBoardMove(P, M);
end;

(*-------------------------------------------------------------------------*)
function TfBoard.GXYToXY(GX, GY: SG; out X, Y: SG): BG;
begin
	Result := True;
	if GX < BoardSize.BorderSize then
		X := -1
	else
		X := (GX - BoardSize.BorderSize) div Max(1, BoardSize.SquareSize);
	if GY < BoardSize.BorderSize then
		Y := -1
	else
		Y := (GY - BoardSize.BorderSize) div Max(1, BoardSize.SquareSize);

	if (X >= BoardSize.MaxX + 1) and (X <= BoardSize.MaxX + 2) and (Y >= 0) and (Y < Min(8, PieceTypes)) then
	begin
		Y := (Y + 1);
		Exit;
	end;

	Y := SG(BoardSize.MaxY - 1) - Y;
	if GameType <> gtShogi then
		Rotate(X, Y, BoardSize.MaxX - 1, BoardSize.MaxY - 1, -Rotated);

	if X < 0 then
	begin
		Result := False;
		X := 0
	end
	else if X > SG(SqX) then
	begin
		Result := False;
		X := SqX;
	end;
	if Y < 0 then
	begin
		Result := False;
		Y := 0
	end
	else if Y > SG(SqY) then
	begin
		Result := False;
		Y := SqY;
	end;
end;
(*-------------------------------------------------------------------------*)
procedure XYToGXY(BoardSize: PBoardSize; LX, LY: SG; out GX, GY: SG);
begin
	if LX > SqX then
	begin
		// Captured Pieces
		GX := BoardSize.BorderSize + BoardSize.SquareSize * LX;
		GY := BoardSize.BorderSize + BoardSize.SquareSize * (LY - 1);
	end
	else
	begin
		// Board
		if GameType <> gtShogi then
			Rotate(LX, LY, SqX, SqY, Rotated);
		LY := SG(BoardSize.MaxY - 1) - LY;
		GX := BoardSize.BorderSize + BoardSize.SquareSize * LX;
		GY := BoardSize.BorderSize + BoardSize.SquareSize * LY;
	end;
end;
(*-------------------------------------------------------------------------*)
procedure IToGXY(BoardSize: PBoardSize; LXY: SG; out GX, GY: SG);
begin
	IToXY(LXY, GX, GY);
	XYToGXY(BoardSize, GX, GY, GX, GY);
end;
(*-------------------------------------------------------------------------*)
procedure TfBoard.FormKeyDown(Sender: TObject; var Key: Word;
	Shift: TShiftState);
begin
	fMain.FormKeyDown(Sender, Key, Shift);
end;
(*-------------------------------------------------------------------------*)
procedure DrawPiece(BoardSize: PBoardSize; BmpB: TDBitmap; GX, GY: SG; H: TSquare; BIndex, Index: SG);
var
	Bmp: TDBitmap;
	y1, y2: SG;
	i, j: SG;
	C: TColor;
begin
{ if (H = sqOut) then
		if (GameType <> gtDraughts) then
			BmpB.Bar(GX, GY, GX + BoardSize.SquareSize - 1, GY + BoardSize.SquareSize - 1, clBlack, ef10);}

	case GameType of
	gtJungle:
	begin
		if Index >= 0 then
		case WaterSquares[Index] of
		sqWater:
		begin
			BmpB.Bar(GX, GY, GX + BoardSize.SquareSize - 1, GY + BoardSize.SquareSize - 1, clWater, ef12);
			BmpB.SetRect(GX, GY, GX + BoardSize.SquareSize - 1, GY + BoardSize.SquareSize - 1);
			BmpB.Rand($00007F);
			BmpB.FullRect;
		end;
		sqDen0, sqDen1:
		begin
			BmpB.Bar(GX, GY, GX + BoardSize.SquareSize - 1, GY + BoardSize.SquareSize - 1, clMoneyGreen, ef12);
		end;
		end;
	end;
	gtExplosion:
	begin
		for i := 1 to ExplosMax[Index] do
		begin
			j := ExplosMax[Index] - i + 1;
			y1 := GY + BoardSize.SquareBorderSize + (BoardSize.SquareSize - 2 * BoardSize.SquareBorderSize) * (j - 1) div ExplosMax[Index];
			y2 := GY + BoardSize.SquareBorderSize + (BoardSize.SquareSize - 2 * BoardSize.SquareBorderSize) * j div ExplosMax[Index] - 2;
			if Abs(H) >= i then
			begin
				C := PieceSet.PieceColor[SG(H < 0)];
				BmpB.Bar(GX + BoardSize.SquareBorderSize, y1, GX + BoardSize.SquareSize - 1 - BoardSize.SquareBorderSize, y2, C, ef16);
			end;
//      BmpB.Border(GX, y1, GX + BoardSize.SquareSize - 1, y2, clBlack, clWhite, 2, ef08);
		end;
		Exit;
	end;
	end;

	// Common
	case H of
	sqEmpty:
		Exit;
	sqOut:
	begin
//    if (H = sqOut) then
//      if (GameType <> gtDraughts) or ((X and 1) = (Y and 1)) then
			begin
//        BmpBoard.Bar(GX, GY, GX + BoardSize.SquareSize - 1, GY + BoardSize.SquareSize - 1, MixColors(PieceSet.LightSquare.Colors[0], PieceSet.DarkSquare.Colors[0]), ef16);
				BmpB.Border(GX, GY, GX + BoardSize.SquareSize - 1, GY + BoardSize.SquareSize - 1, clWhite, clBlack, BoardSize.SquareSize div 4, ef12);
			end;
		Exit;
	end;
	end;
	
	Bmp := PieceToBmp(BIndex, TPiece(H));

	if Bmp <> nil then
	begin
		if (BIndex in [1, 2]) and (SquareStatus[BIndex, Index] = ssMeThe) then
		begin
			Inc(GX);
			Inc(GY);
		end
		else if PieceSet.PieceShadows > 0 then
			BmpB.Bmp(GX + (BoardSize.SquareSize - Bmp.Width) div 2 + 1, GY + (BoardSize.SquareSize - Bmp.Height) div 2 + 1, Bmp, TEffect(U1(ef15) + PieceSet.PieceShadows));
// efSub, efAdd127, efSub127, efXor, efNeg
		BmpB.Bmp(GX + (BoardSize.SquareSize - Bmp.Width) div 2, GY + (BoardSize.SquareSize - Bmp.Height) div 2, Bmp, TEffect(Visi[SG(SG(H) < 0)]))

	end
	else
	begin
		BmpB.Bar(GX, GY, GX + BoardSize.SquareSize - 1, GY + BoardSize.SquareSize - 1, clWhite, efXor);
	end;
end;

const
	SlideStep = 40;

procedure TfBoard.DrawBoardMove(P: PPos; M: PMove);
begin
	if (M = nil) or (SlidePieces = False) then
	begin
		Slide := psNone;
		SlideTarget := 0;
		SlidePiece := 0;
		U8(SlideFrom) := 0;
		U8(SlideActual) := 0;
		U8(SlideTo) := 0;
		Exit;
	end;

	SlideIndex := 0;
	case MoveFormat of
	mfDraughts:
	begin
		if M.Lng <= MaxMoveL then
		begin
			IToGXY(@BoardSize, M.Sq[0], SlideFrom.X, SlideFrom.Y);
			IToGXY(@BoardSize, M.Sq[M.Lng], SlideTo.X, SlideTo.Y);
			SlideTarget := M.Sq[M.Lng];
			SlidePiece := P.Board[M.Sq[M.Lng]];
		end;
	end;
	mfChess:
	begin
		IToGXY(@BoardSize, M.FrSq, SlideFrom.X, SlideFrom.Y);
		IToGXY(@BoardSize, M.ToSq, SlideTo.X, SlideTo.Y);
		SlideTarget := M.ToSq;
		SlidePiece := M.F1;
	end;
	else // mfGO
	begin
		IToGXY(@BoardSize, M.T, SlideFrom.X, SlideFrom.Y);
		IToGXY(@BoardSize, M.T, SlideTo.X, SlideTo.Y);
		Inc(SlideFrom.X, BoardSize.SquareSize div 6);
		Inc(SlideFrom.Y, BoardSize.SquareSize div 6);
		Dec(SlideTo.X, BoardSize.SquareSize div 12);
		Dec(SlideTo.Y, BoardSize.SquareSize div 12);
		SlideTarget := M.T;
		SlidePiece := 2 * S1(P.Side) - 1;
	end;
	end;
	if Slide = psMouseUp then
	begin
		MaxSlide := 0;
		Exit;
	end;
	if Slide = psMouse then
	begin
		Slide := psTimer;
		MaxSlide := 0;
		Exit;
	end;
	Slide := psTimer;

	SlideActual := SlideFrom;
	SlideDif.X := SlideTo.X - SlideFrom.X;
	SlideDif.Y := SlideTo.Y - SlideFrom.Y;
	if BIndex = 1 then
		MaxSlide := SlideTime // ms / move
	else
		MaxSlide := 150; // ms / move

	NextSlideTime := GTime + SlideStep;
end;

procedure FillBoardSize(var BoardSize: TBoardSize; BIndex: SG);
var x, y: SG;
begin
	BoardSize.MaxX := SqXC;
	BoardSize.MaxY := SqYC;
	if GameType <> gtShogi then
		case Rotated of
		1, 3: Exchange(BoardSize.MaxX, BoardSize.MaxY);
		end;

	x := 2 * (BoardSize.MaxX + 1);
	y := BoardSize.MaxY + 1;
	if (CapturedPieces or Game.Variant.Options[voRCP].Bool) and (MoveFormat <> mfGO) then
	begin
		Inc(x, 5);
//    Dec(BoardSize.Width, 8);
		y := Max(y, 1 + Min(8, PieceTypes));
	end;
	BoardSize.SquareSize := Max(1, Min(2 * BoardSize.Width div x, BoardSize.Height div y));
	BoardSize.BorderSize := (BoardSize.SquareSize + 1) div 2;
	BoardSize.Width := BoardSize.SquareSize * (BoardSize.MaxX + 1);
	BoardSize.Height := BoardSize.SquareSize * (BoardSize.MaxY + 1);

	BoardSize.SquareBorderSize := Max(1, (BoardSize.SquareSize) div 16);
	ReqPieceSize[BIndex] := BoardSize.SquareSize - 2 * (BoardSize.SquareSize * (100 - PieceSet.PieceScale) div (2 * 100));
end;

procedure TfBoard.UpdateBoard;
begin
	BoardSize.Width := ClientWidth;
	BoardSize.Height := ClientHeight;
	if GameType <> gkNone then
	begin
		FillBoardSize(BoardSize, BIndex);
	end;
end;

procedure PosToBmp(BmpB: TDBitmap; var BmpBoard: TDBitmap; BoardSize: PBoardSize; BPos: PPos; SquareStatus: PSquaresStatus;
	Slide: BG; SlidePiece: TPiece; SlideTarget: SG; const SlideFrom, SlideActual: PPoint; BIndex: SG);
var
	BBoard: PBoard;

	GX, GY, GX1, GY1: SG;
	X, Y: SG;
	i, j, k, l, Index: SG;
	s: string;
	Size: TSize;
	Sq: TSquare;
	c: TCaptureCount;
	Nota: TNotation;
	OnlyLight, OnlyDark: BG;
	Rotated: SG;
	Po: array[0..2] of TPoint;
	Len: SG;
begin
	if Kinds.Count <= 0 then
	begin
		BmpB.Bar(clAppWorkSpace, ef16);
		Exit;
	end;

	Rotated := uBoard.Rotated;
	BBoard := @BPos.Board;

	// Board
	if not Assigned(BmpBoard) then
		BmpBoard := TDBitmap.Create;
	if (BmpBoard.Width <> BoardSize.Width) or (BoardSize.Height <> BoardSize.Height) then
	begin
		BmpBoard.SetSize(0, 0);
		BmpBoard.SetSize(BoardSize.Width, BoardSize.Height);
		BmpBoard.DrawStyle(PieceSet.Background);
		BmpBoard.Border(clWhite, clBlack, BoardSize.SquareSize div 8, ef12);

		OnlyLight := (MoveFormat = mfGO) or (GameType in [gtJungle, gtBlobWars]); // Add Game
		OnlyDark := (GameType in [gtExplosion]);
		for Y := 0 to SqY do
		for X := 0 to SqX do
		begin
			XYToGXY(BoardSize, X, Y, GX, GY);
			if (((X and 1) <> (Y and 1)) or OnlyLight) and (OnlyDark = False) then
			begin
				BmpBoard.DrawStyle(PieceSet.LightSquare, GX, GY, GX + BoardSize.SquareSize - 1, GY + BoardSize.SquareSize - 1);
			end
			else
				BmpBoard.DrawStyle(PieceSet.DarkSquare, GX, GY, GX + BoardSize.SquareSize - 1, GY + BoardSize.SquareSize - 1);
			// There can be placed fixed sqOut code
			if OnlyLight or PieceSet.GridLines then
				BmpBoard.Border(GX, GY, GX + BoardSize.SquareSize - 1, GY + BoardSize.SquareSize - 1, clWhite, clBlack, 1, ef12);
		end;

		if Coordinates <> cpOff then
		begin
			BmpBoard.Canvas.Font.Name := 'Arial';
			BmpBoard.Canvas.Font.Style := [fsBold];
			Nota := GetNotation(Notation);

			if (Coordinates = cpAround) and (Nota <> ntDraughts) then
			begin
				BmpBoard.Canvas.Font.Height := Min(-RoundDiv(BoardSize.SquareSize, 4), -1);
				for j := 0 to 1 do
				begin
					if j in [0, 2] then k := SqX else k := SqY;
					if not (j in [0, 2]) then l := SqX else l := SqY;
					for i := 0 to k do
					begin
						if Nota = ntTechnical then
							s := NToS(i)
						else
						begin
							case Nota of
							ntShogi:
							begin
								if j in [0, 2] then
									s := NToS(i + 1)
								else
									s := Char(Ord('a') + i);
							end;
							ntOthello:
							begin
								if j in [0, 2] then
									s := Char(Ord('a') + i)
								else
									s := NToS(SqXC - i);
							end;
							else
							begin
								if j in [0, 2] then
									s := Char(Ord('a') + i)
								else
									s := NToS(i + 1);
							end;
							end;
						end;

						Size := BmpBoard.Canvas.TextExtent(s);
						case (j + Rotated) and 1 of
						0:
						begin // Up, down
							case Rotated of
							0, 1:
							begin
								X := i;
							end
							else
							begin
								X := k - i;
							end;
							end;
							GX := BoardSize.BorderSize + BoardSize.SquareSize * X;
							Inc(GX, (BoardSize.SquareSize - Size.cx) div 2);
							GX1 := GX;
							GY := BoardSize.BorderSize - Size.cy - 2;
							GY1 := BoardSize.BorderSize + BoardSize.SquareSize * (l + 1);
						end
						else
						begin // Left, Right
							if (Rotated in [0, 1]) xor (j in [0, 2]) then
							begin
								Y := k - i;
							end
							else
							begin
								Y := i;
							end;
							GY := BoardSize.BorderSize + BoardSize.SquareSize * Y;
							Inc(GY, (BoardSize.SquareSize - Size.cy) div 2);
							GY1 := GY;
							GX := (BoardSize.BorderSize + BoardSize.BorderSize div 4 - Size.cx) div 2; // Left
							GX1 := BoardSize.BorderSize + BoardSize.SquareSize * (l + 1) +
								+ (BoardSize.BorderSize - BoardSize.BorderSize div 4 - Size.cx) div 2; // Right
						end
						end;

						ShadowText(BmpBoard.Canvas,
							GX,
							GY,
							s, clWhite, clNone);

						ShadowText(BmpBoard.Canvas,
							GX1,
							GY1,
							s, clWhite, clNone);
					end;
				end;
		{     for i := 0 to SqY do
				begin
					if N = ntTechnical then
						s := NToS(i)
					else
						s := NToS(i + 1);

					Rotate(GX, GY, SqX, SqY, Rotated);
					GY := SqY - GY;
					GX := GSquareX[1, GX] - 2 * BmpBoard[BIndex].Canvas.TextWidth(s);
					GY := GSquareY[1, GY] + (GSquareY[1, 0] - BmpBoard[BIndex].Canvas.TextHeight(s)) div 2;
					ShadowText(BmpBoard[BIndex].Canvas,
						GX,
						GY,
						s, clWhite, clNone);
				end;}
			end
			else
			begin
				BmpBoard.Canvas.Font.Height := Min(-RoundDiv(3 * BoardSize.SquareSize, 16), -1);
				for i := 0 to UsedSquareCount - 1 do
				begin
					Index := UsedSquares[i];
					IToXY(Index, X, Y);
					s := SquareToS(Index, True, Nota)
					{$ifdef Debug}
					 + '-' + NToS(BEval[Index])
					 {$endif};
					IToGXY(BoardSize, Index, GX, GY);
					BmpBoard.Canvas.TextOut(GX + BoardSize.SquareBorderSize, GY + BoardSize.SquareBorderSize - 1, s);
				end;
			end;
		end;
	end;

	BmpB.Bmp(0, 0, BmpBoard, ef16);
	if BmpB.Width > BoardSize.Width then
	begin
		BmpB.Bar(BoardSize.Width, 0, BmpB.Width - 1, BmpB.Height - 1, clAppWorkspace, ef16);
	end;
	if BmpB.Height > BoardSize.Height then
	begin
		BmpB.Bar(0, BoardSize.Height, BmpB.Width - 1, BmpB.Height - 1, clAppWorkspace, ef16);
	end;

	if SideToMove then
	begin
		X := 0;
		if BPos.Side = 0 then
			Y := SqYC
		else
			Y := 0;
		if GameType <> gtShogi then
			Rotate(X, Y, SqXC, SqYC, Rotated);
		GX := BoardSize.BorderSize + BoardSize.SquareSize * SqXC + BoardSize.BorderSize div 8;
		GY := BoardSize.BorderSize div 3;
		if Y <> 0 then
			GY := 2 * BoardSize.BorderSize + BoardSize.SquareSize * Y - 1 - GY - BoardSize.BorderSize div 2;

		if BoardSize.BorderSize div 2 - 1 >= 0 then
		begin
			BmpB.Bar(
				GX,
				GY,
				GX + BoardSize.BorderSize div 2 - 1,
				GY + BoardSize.BorderSize div 2 - 1,
				PieceColor[2 + BPos.Side], ef16);
			BmpB.Bar(
				GX + BoardSize.BorderSize div 16,
				GY + BoardSize.BorderSize div 16,
				GX + BoardSize.BorderSize div 2 - BoardSize.BorderSize div 16 - 1,
				GY + BoardSize.BorderSize div 2 - BoardSize.BorderSize div 16 - 1,
				PieceColor[BPos.Side], ef16);
		end;
	end;

{ PieceSet.SquareStatus[ssMeOk].BorderSize := BoardSize.SquareBorderSize;
	PieceSet.SquareStatus[ssSomeTo].BorderSize := BoardSize.SquareBorderSize;
	PieceSet.SquareStatus[ssTheTo].BorderSize := BoardSize.SquareBorderSize;}
	if (SquareHighlight > 0) and (SquareStatus <> nil) then
		for i := 0 to UsedSquareCount - 1 do
		begin
			Index := UsedSquares[i];
			IToGXY(BoardSize, Index, GX, GY);

			if SquareStatus[Index] <> ssNone then
				if ((SquareHighlight = 1) and (SquareStatus[Index] in [ssMeOk, ssTheTo]))
				or ((SquareHighlight = 2) or (MoveFormat = mfGO)) then
					BmpB.DrawStyle(PieceSet.SquareStatus[SquareStatus[Index]], GX, GY, GX + BoardSize.SquareSize - 1, GY + BoardSize.SquareSize - 1);
		end;

	if BIndex = 1 then
		if ActiveSquare then
		begin
			XYToGXY(BoardSize, Game.CursorX, Game.CursorY, GX, GY);
//        PieceSet.ActiveSquare.BorderSize := BoardSize.SquareBorderSize;

			BmpB.DrawStyle(PieceSet.ActiveSquare, GX + BoardSize.SquareBorderSize, GY + BoardSize.SquareBorderSize, GX + BoardSize.SquareSize - 1 - BoardSize.SquareBorderSize, GY + BoardSize.SquareSize - 1 - BoardSize.SquareBorderSize);
		end;

{ for i := 0 to UsedSquareCount - 1 do
	begin
		Index := UsedSquares[i];}
	for Y := 0 to SqY do
	for X := 0 to SqX do
	begin
		Index := XYToI(X, Y);
		if Slide and (Index = SlideTarget) then
		begin
			Continue;
		end;
//    IToGXY(BoardSize, Index, GX, GY);
		XYToGXY(BoardSize, X, Y, GX, GY);
		DrawPiece(BoardSize, BmpB, GX, GY, BBoard[Index], BIndex, Index);
	end;

	if (CapturedPieces or Game.Variant.Options[voRCP].Bool) and (MoveFormat <> mfGO) then
	begin
		BmpB.Canvas.Font.Color := clHighlightText;
		BmpB.Canvas.Font.Name := 'Arial';
		BmpB.Canvas.Font.Style := [fsBold];
		BmpB.Canvas.Font.Height := Min(-RoundDiv(BoardSize.SquareSize, 4), -1);
		for x := 0 to PlayerMax do
		begin
			for y := 0 to Min(8, PieceTypes) - 1 do
			begin
				XYToGXY(BoardSize, SqXC + 1 + x, y + 1, GX, GY);
{       GX := X * (BoardSize.SquareSize + 8) + 8 + BoardSize.Width;
				GY := Y * (BoardSize.SquareSize + 8);}
				Sq := TSquare((-2 * x + 1) * (y + 1));
				c := BPos.CapturedPieces[-Sq];
				if c > 0 then
				begin
					if Game.Variant.Options[voRCP].Bool = False then
						Sq := -Sq;
					if x = SG(BPos.Side) then
					begin
						if ((SquareHighlight = 1) and (SquareStatus <> nil) and (SquareStatus[-y - 1] = ssTheTo))
						or (SquareHighlight = 2) then
							if SquareStatus <> nil then
								if SquareStatus[-y - 1] <> ssNone then
									BmpB.DrawStyle(PieceSet.SquareStatus[SquareStatus[-y - 1]], GX, GY, GX + BoardSize.SquareSize - 1, GY + BoardSize.SquareSize - 1);
					end;
					DrawPiece(BoardSize, BmpB, GX, GY, Sq, BIndex, -Sq);
					if c > 1 then BmpB.Canvas.TextOut(GX + 3, GY + 3, NToS(c));
				end;
			end;
		end;
	end;

	if Kinds.Count > 0 then
	begin
		if Slide then
		begin
			DrawPiece(BoardSize, BmpB, SlideActual.X, SlideActual.Y, SlidePiece, BIndex, SlideTarget);
		end;
	end;

	if PieceSet.LastMoveArrow and (BIndex in [1, 2]) then
	begin
		if (BmpB.Width > 10) and (BmpB.Height > 10) then
		begin
			Len := Round(Sqrt(Sqr(SlideFrom.X - SlideActual.X) + Sqr(SlideFrom.Y - SlideActual.Y)));
			if Len > 0 then
			begin
				Len := Len * 8;
				Po[0].X := SlideFrom.X + BoardSize.SquareSize * (SlideFrom.Y - SlideActual.Y) div Len;
				Po[0].Y := SlideFrom.Y - BoardSize.SquareSize * (SlideFrom.X - SlideActual.X) div Len;

				Po[1].X := SlideFrom.X - BoardSize.SquareSize * (SlideFrom.Y - SlideActual.Y) div Len;
				Po[1].Y := SlideFrom.Y + BoardSize.SquareSize * (SlideFrom.X - SlideActual.X) div Len;

				Po[2] := SlideActual^;

				InflatePoint(Po[0], BoardSize.SquareSize div 2);
				InflatePoint(Po[1], BoardSize.SquareSize div 2);
				InflatePoint(Po[2], BoardSize.SquareSize div 2);
				BmpB.Canvas.Brush.Style := GToBrush[PieceSet.LastMoveColor.Style];
				BmpB.Canvas.Brush.Color := PieceSet.LastMoveColor.Colors[1];
				BmpB.Canvas.Pen.Style := psInsideFrame;
				BmpB.Canvas.Pen.Color := PieceSet.LastMoveColor.Colors[1];
				BmpB.Canvas.Polygon(Po);
			end;
{       BmpB.Line(SlideFrom.X + BoardSize.SquareSize div 2, SlideFrom.Y + BoardSize.SquareSize div 2,
				SlideActual.X + BoardSize.SquareSize div 2, SlideActual.Y + BoardSize.SquareSize div 2,
				PieceSet.LastMoveArrow.Colors[0], PieceSet.LastMoveArrow.Effect);}
		end;
	end;
end;

procedure TfBoard.Draw;
var
	BPos: PPos;
begin
	NeedRepaint := False;
	if (BoardSize.Width = 0) or (BoardSize.Height = 0) then Exit;
	// Init
	if BIndex = 2 then
		BPos := @APos
	else
		BPos := @Game.Pos;

	PosToBmp(Image.Bitmap, BmpBoard, @BoardSize, BPos, @SquareStatus[BIndex], Slide >= psMouse, SlidePiece, SlideTarget, @SlideFrom, @SlideActual, BIndex);
end;
(*-------------------------------------------------------------------------*)
procedure TfBoard.ImageMouseMove(Sender: TObject; Shift: TShiftState; X,
	Y: Integer);
var
	IX, IY: SG;
	G: TPoint;
begin
	if Kinds.Count > 0 then
	begin
		if (BIndex <> 1) then Exit;
		if Slide = psMouse then
		begin
			G.X := X - BoardSize.SquareSize div 2;
			G.Y := Y - BoardSize.SquareSize div 2;
			if (G.X <> SlideActual.X) or (G.Y <> SlideActual.Y) then
			begin
				SlideActual := G;
				NeedRepaint := True;
			end;
		end;

		if GXYToXY(X, Y, IX, IY) = False then
		begin
			Image.Cursor := crNoDrop;
		end
		else
		begin
			if (IX <> MouseCX) or (IY <> MouseCY) then
			begin
				if IX >= SqXC + 1 then
					Game.CXY := -IY // Captured pieces
				else
					Game.CXY := XYToI(IX, IY);
				Game.CursorX := IX;
				Game.CursorY := IY;
				MouseCX := IX;
				MouseCY := IY;

				if ActiveSquare then
				begin
					NeedRepaint := True;
				end;
			end;
			if SquareStatus[BIndex][Game.CXY] in [ssMeOk, ssTheTo] then
				Cursor := MouseCursor
			else
				Cursor := crDefault;
		end;
	end;
end;

procedure TfBoard.ImageMouseDown(Sender: TObject; Button: TMouseButton;
	Shift: TShiftState; X, Y: Integer);
begin
	case Button of
	mbLeft:
	begin
		if (BIndex <> 1) then Exit;
		if WhereSetup then
		begin
			SetupMouseDown;
		end
		else if SquareStatus[BIndex][Game.CXY] in [ssMeOk, ssTheTo] then
		begin
			SquareClick;
		end;
		if SquareStatus[BIndex][Game.CXY] in [ssMeThe] then
			Slide := psMouse;
	end;
	mbRight:
	begin
		if WhereSetup and (BIndex = 1) then
			SetupChangeSide
		else
			PopupMenuBoard.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);
	end;
	end;
end;

procedure TfBoard.ImageMouseUp(Sender: TObject; Button: TMouseButton;
	Shift: TShiftState; X, Y: Integer);
begin
	case Button of
	mbLeft:
	begin
		if (BIndex <> 1) then Exit;
		if WhereSetup then
		begin

		end
		else if SquareStatus[BIndex][Game.CXY] in [ssMeOk, ssTheTo] then
		begin
			if Slide = psMouse then
			begin
				Slide := psMouseUp;
				SquareClick;
				if Slide in [psMouseUp, psMouse] then
				begin
					Slide := psNone;
					Image.Fill;
				end;
			end;
		end
		else
		begin
			if Slide = psMouse then
			begin
				Slide := psNone;
				SlideActual := SlideFrom;
				Image.Fill;
			end;
		end;
	end;
	end;
end;

constructor TfBoard.Create(AOwner: TComponent; BoardIndex: SG);
begin
	inherited Create(AOwner);

	Background := baUser;
	BIndex := BoardIndex;
	case BoardIndex of
	2:
		Name := 'fABoard';
	end;
	MainIni.RWFormPos(Self, False);
	fMain.CopyGraphicsContent1.Enabled := True;
	MenuCreate(fMain.Board1, PopupMenuBoard.Items);
	MenuSet(PopupMenuBoard, fMain.OnAdvancedMenuDraw);
end;

destructor TfBoard.Destroy(AOwner: TComponent);
begin
	FreeAndNil(BmpBoard);
end;

procedure TfBoard.PopupMenuBoardPopup(Sender: TObject);
begin
	MenuUpdate(fMain.Board1, PopupMenuBoard.Items);
end;

procedure TfBoard.FormShow(Sender: TObject);
begin
	Image.Fill;
end;

procedure TfBoard.FormHide(Sender: TObject);
begin
	case BIndex of
	1: fMain.Board2.Checked := False;
	2: fMain.AnalysisBoard2.Checked := False;
	end;
end;

procedure TfBoard.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	MainIni.RWFormPos(Self, True);
end;

procedure TfBoard.FormResize(Sender: TObject);
const
	BoardCaption: array[1..2] of string = ('Board', 'Analysis Board');
begin
	UpdateBoard;

	Caption := BoardCaption[BIndex] + ' (' + NToS(BoardSize.Width) + ' ' + CharTimes + ' ' + NToS(BoardSize.Height) + ')'
	{$ifopt d+}
	+ ' - ' + NToS(ReqPieceSize[BIndex])
	+ ' - ' + NToS(BoardSize.SquareSize)
	{$endif};
	Image.Fill;
//  NeedRepaint := True;
end;

procedure TfBoard.FormDestroy(Sender: TObject);
begin
	MenuFree(PopupMenuBoard.Items);
end;

procedure TfBoard.Timer;
var
	G: TPoint;
begin
	if (Slide >= psMouse) or (NeedRepaint) then
	begin
		if GTime >= NextSlideTime then
		begin
			Inc(SlideIndex, GTime - NextSlideTime + SlideStep);
			if Slide = psTimer then
			begin
				G := SlideFrom;
				if SlideIndex > MaxSlide then
				begin
					Slide := psNone;
					SlideActual := SlideTo;
					Image.Fill;
					Exit;
				end;
				Inc(G.X, SlideDif.X * SG(SlideIndex) div Max(SG(MaxSlide), 1));
				Inc(G.Y, SlideDif.Y * SG(SlideIndex) div Max(SG(MaxSlide), 1));
				if (SlideActual.X <> G.X) or (SlideActual.Y <> G.Y) then
				begin
					SlideActual := G;
					NeedRepaint := True;
				end;
			end;
			if NeedRepaint then
				Image.Fill;
			NextSlideTime := GTime + SlideStep;
		end;
	end;
end;

procedure TfBoard.ImageFill(Sender: TObject);
begin
	Draw;
end;

procedure TfBoard.FormCreate(Sender: TObject);
begin
	Background := baNone;
	Image.SkipFillWhenResized := True;
end;

procedure TfBoard.SquareClick;
begin
	SlideTarget := Game.CXY;
	IToGXY(@BoardSize, SlideTarget, SlideFrom.X, SlideFrom.Y);
{ SlideFrom.X := Image.MouseX - BoardSize.SquareSize div 2;
	SlideFrom.Y := Image.MouseY - BoardSize.SquareSize div 2;}
	SlideActual := SlideFrom;
	if SlideTarget < 0 then
	begin
		SlidePiece := -SlideTarget;
		if Game.Pos.Side <> 0 then SlidePiece := -SlidePiece;
	end
	else if Game.Pos.Board[SlideTarget] <> sqOut {D???} then
		SlidePiece := Game.Pos.Board[SlideTarget];
	PressSquare(Game.Pos, Game.CXY, True);
end;

end.