//* File:     Lib\uLogo.pas
//* Created:  1999-10-01
//* Modified: 2005-09-14
//* Version:  X.X.35.X
//* Author:   Safranek David (Safrad)
//* E-Mail:   safrad at email.cz
//* Web:      http://safrad.webzdarma.cz

unit uLogo;

interface

uses
	uTypes,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	ExtCtrls, uDTimer, uDForm;

type
	TfLogo = class(TDForm)
		Timer1: TDTimer;
		procedure Timer1Timer(Sender: TObject);
		procedure ImageLogoMouseMove(Sender: TObject; Shift: TShiftState; X,
			Y: Integer);
		procedure FormCreate(Sender: TObject);
		procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
			Shift: TShiftState; X, Y: Integer);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
	private
		{ Private declarations }
		FirstX, FirstY: SG;
		MoveCount: SG;
	public
		{ Public declarations }
	end;

procedure ShowLogo; overload; // TfMain.FormCreate
procedure HideLogo; // TfMain.FormShow
procedure HideLogoPromptly;

implementation

{$R *.DFM}
uses
	StdCtrls,
	rpVersionInfo,
	uGraph, uDBitmap, uFiles, uMath, uSystem;
var
	fLogo: TfLogo;
	LogoTime: U4;

procedure ShowLogo(const FileName: TFileName); overload;
const
	BorderSize = 7;
var
	x: SG;
	Co: array[0..3] of TColor;
	Bmp, BmpT: TDBitmap;
	VersionInfo: TrpVersionInfo;
	s, LastFontName: string;
	i: SG;
begin
	BeginLongOperation;
	if Application.MainForm <> nil then
		fLogo := TfLogo.Create(Application.MainForm)
	else
		fLogo := TfLogo.Create(nil);

	Bmp := fLogo.BackBitmap;

	if (FileName <> '') then
	begin
		fLogo.BackBitmap.LoadFromFile(FileName);
		if (fLogo.BackBitmap.Width < 256) or (fLogo.BackBitmap.Height < 3 * 256 div 4) then
		begin
			fLogo.BackBitmap.Resize(fLogo.BackBitmap.Width * 2, fLogo.BackBitmap.Height * 2);
		end;
	end;
	if (FileName = '') then
	begin
		x := RoundDiv(2 * Screen.Width, 7);
		Bmp.SetSize(x, RoundDiv(3 * x, 4));
		Co[0] := clRed;
		Co[1] := clGreen;
		Co[2] := clBlue;
		Co[3] := clSilver;
		Bmp.GenerateRGB(gfTriaHorz, Co, clBlack, ef16, nil);
		Co[0] := clWhite;
		Co[1] := clBlack;
		Co[2] := Co[0];
		Co[3] := Co[1];
		Bmp.GenerateRGB(gfFade2x, Co, clBlack, ef10, nil);
	end;

	BmpT := TDBitmap.Create;
	BmpT.TransparentColor := clSilver;
	BmpT.SetSize(Bmp.Width, Bmp.Height);
	BmpT.Bar(clSilver, ef16);
	BmpT.Canvas.Brush.Style := bsClear;
	BmpT.Canvas.Font.Style := [fsBold];
	LastFontName := BmpT.Canvas.Font.Name;
	BmpT.Canvas.Font.Name := 'Times New Roman';
	BmpT.Canvas.Font.Height := -48;

	VersionInfo := TrpVersionInfo.Create(nil);

	s := VersionInfo.FileVersion;
	for i := Length(s) downto 2 do
	begin
		if s[i] = '.' then
		begin
			SetLength(s, i - 1);
			Break;
		end;
	end;
	GoodText(BmpT.Canvas, Rect(16, 16, Bmp.Width - 16, Bmp.Height - 16), Application.Title + ' ' +
		s,
		clBlack, clWhite, clSilver, taCenter, tlCenter);

	BmpT.Canvas.Font.Name := LastFontName;

	BmpT.Canvas.Font.Style := [];
	BmpT.Canvas.Font.Height := 14;

	GoodText(BmpT.Canvas, Rect(BorderSize + 2, Bmp.Height - BmpT.Canvas.TextHeight('W') - 4, Bmp.Width - BorderSize, Bmp.Height - BorderSize - 2), 'by ' + VersionInfo.Author,
		clNone, clNone, clWhite, taRightJustify, tlCenter);
	GoodText(BmpT.Canvas, Rect(BorderSize + 2, Bmp.Height - BmpT.Canvas.TextHeight('W') - 4, Bmp.Width - BorderSize, Bmp.Height - BorderSize - 2), VersionInfo.ReleaseDate,
		clNone, clNone, clWhite, taLeftJustify, tlCenter);
	VersionInfo.Free;

	Bmp.Bmp(0, 0, BmpT, ef12);
	Bmp.Border(clWhite, clBlack, BorderSize, ef08);

	fLogo.ClientWidth := fLogo.BackBitmap.Width;
	fLogo.ClientHeight := fLogo.BackBitmap.Height;
	fLogo.Show;
	fLogo.Paint;

	LogoTime := GetTickCount;
end;

procedure ShowLogo;
begin
	if FileExists(GraphDir + 'Logo.jpg') then
		ShowLogo(GraphDir + 'Logo.jpg')
	else if FileExists(GraphDir + 'Logo.png') then
		ShowLogo(GraphDir + 'Logo.png')
	else if FileExists(GraphDir + 'Logo.gif') then
		ShowLogo(GraphDir + 'Logo.gif')
	else
		ShowLogo('');
end;
(*
procedure ShowLogoFull;
var
	i, li: Integer;
	BackgroundCanvas: TCanvas;
	BackgroundBmp: TDBitmap;
	OutBmp: TDBitmap;
	XCount, YCount: Integer;
begin
	BeginLongOperation;
	fLogo := TfLogo.Create(Application.MainForm);
//  Application.CreateForm(TfLogo, fLogo);
	fLogo.FullScreen := True;

	XCount := Screen.Width;
	YCount := Screen.Height;

	BackgroundBmp := TDBitmap.Create;
	BackgroundBmp.SetSize(XCount, YCount);

	BackgroundCanvas := TCanvas.Create;
	BackgroundCanvas.Handle := GetDC(0);
	BackgroundBmp.Canvas.CopyRect(
		Rect(0, 0, XCount, YCount), BackgroundCanvas,
		Rect(0, 0, XCount, YCount));
	OutBmp := fLogo.BackBitmap;

	OutBmp.Bmp(0, 0, BackgroundBmp, ef16);
	fLogo.Show;
	fLogo.Paint;

	LogoTime := GetTickCount;
	i := 0;
	li := 0;
	while i <= 15 * 256 - 1 do
	begin
		OutBmp.Bmp(0, 0, BackgroundBmp, ef16);
		OutBmp.Bar(clBlack, TEffect(i div 256));
		Inc(i, GetTickCount - LogoTime);
		if i div 256 = li div 256 then
		begin
			li := 256 * (li div 256);
			Sleep(i - li);
			Inc(i, i - li);
		end;
		li := i;
		fLogo.Paint;
	end;
	OutBmp.Bar(clBlack, ef16);
	fLogo.Paint;
	FreeAndNil(BackgroundBmp);

	ReleaseDC(0, BackgroundCanvas.Handle);
	BackgroundCanvas.Free;
	BackgroundBmp.Free;

	LogoTime := GetTickCount;
	fLogo.FullScreen := False;
	fLogo.Close;
end;*)

procedure HideLogo;
const
	MinimumTime = 4000;
begin
	if Assigned(fLogo) and fLogo.Visible then
	begin
		LogoTime := GetTickCount - LogoTime;
		if LogoTime < MinimumTime then
		begin
			fLogo.Timer1.Interval := MinimumTime - LogoTime;
			fLogo.Timer1.Enabled := True;
		end;
		EndLongOperation(False);
	end;
end;

procedure HideLogoPromptly;
begin
	if Assigned(fLogo) and fLogo.Visible then
	begin
		EndLongOperation(False);
		fLogo.Close;
	end;
end;

procedure TfLogo.Timer1Timer(Sender: TObject);
begin
	Enabled := False;
	Close;
//  Hide;
end;

procedure TfLogo.ImageLogoMouseMove(Sender: TObject; Shift: TShiftState; X,
	Y: Integer);
begin
	if MoveCount = 0 then
	begin
		FirstX := X;
		FirstY := Y;
	end;
	if Sqr(FirstX - X) + Sqr(FirstY - Y) >= 256 {16 pixels} then
	begin
		Close;
//    Free; fLogo := nil;
	end;

	Inc(MoveCount);
end;

procedure TfLogo.FormCreate(Sender: TObject);
begin
	{$ifopt d+}FormStyle := fsNormal;{$endif}
	Background := baUser;
end;

procedure TfLogo.FormMouseDown(Sender: TObject; Button: TMouseButton;
	Shift: TShiftState; X, Y: Integer);
begin
	Close;
	Free; fLogo := nil;
end;

procedure TfLogo.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	if fLogo.Timer1.Enabled then
	begin
		Timer1.Enabled := False;
	end;

	EndLongOperation(False);
	BackBitmap.SetSize(0, 0);
end;

end.