// * File:     RPC\uProbe.pas
// * Created:  2001-05-28
// * Modified: 2010-01-02
// * Version:  1.0.47.34
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uProbe;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	ExtCtrls, uDImage, Menus, ImgList, uDForm, Dialogs, uDWinControl;

type
	TfProbe = class(TDForm)
		PanelP: TPanel;
		ImageP: TDImage;
		MainMenu1: TMainMenu;
		File1: TMenuItem;
		Open1: TMenuItem;
		Close1: TMenuItem;
		Bevel1: TBevel;
		Zoom1: TMenuItem;
		Fit1: TMenuItem;
		Select1: TMenuItem;
		SaveAs1: TMenuItem;
		OpenDialog1: TOpenDialog;
		SaveDialog1: TSaveDialog;
		procedure ImagePFill(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure Exit1Click(Sender: TObject);
		procedure Select1Click(Sender: TObject);
		procedure Fit1Click(Sender: TObject);
		procedure Close1Click(Sender: TObject);
		procedure Open1Click(Sender: TObject);
		procedure SaveAs1Click(Sender: TObject);
	private
		{ Private declarations }
		procedure RWOptions(const Save: Boolean);
	public
		{ Public declarations }
	end;

var
	fProbe: TfProbe;
	Changes: array[0..3] of Int64;
	DataTime: TDateTime;

implementation

{$R *.DFM}
uses
	uGraph, uGetInt, uTypes, uDBitmap, uDIniFile, uMenus, uFile, uFiles, uStrings, uInputFormat, uMath, uColor, uOutputFormat, uDrawStyle,
	uMain;
var
	Zoom: SG;
	FileName: TFileName;

function TimToStr(Tim: Int64): string;
begin
	Result := FloatToStrF((Tim - Stat[0].Tim) / PerformanceFrequency, ffGeneral, 6, 0);
end;

procedure TfProbe.RWOptions(const Save: Boolean);
begin
	MainIni.RWFormPos(Self, Save);
	Zoom := MainIni.RWSGF('Probe', 'Zoom', Zoom, 20, Save);
	if Save = False then FileName := AppDataDir + 'Log.dat';
	MainIni.RWFileName('Probe', 'FileName', FileName, Save);
end;

procedure TfProbe.ImagePFill(Sender: TObject);
const
	InName: array[0..3] of string = ('DCD', 'RI', 'DSR', 'CTS');
	DescY = 80;
	OfsX = 32;
var
	Bmp: TBitmap;
	i, j: Integer;
	x, y, ly: Integer;

	function StatToY(Stat: Boolean; Index: Integer): Integer;
	begin
		if Stat then
			Result := 2 + Index * ((Bmp.Height - DescY) div 4)
		else
			Result := (Bmp.Height - DescY) div 4 - 3 + Index * ((Bmp.Height - DescY) div 4);
	end;

begin
	Bmp := ImageP.Bitmap;
	Bmp.Width := ImageP.Width;
	Bmp.Height := ImageP.Height;

	ImageP.UserArea := Rect(0, 0, OfsX + Zoom * StatCount + 64, 0);
//  ScrollImageP.BitmapHeight := Bmp.Height;

{ Bmp.Canvas.Brush.Color := clBlack;
	Bmp.Canvas.FillRect(Rect(0, 0, Bmp.Width, Bmp.Height));}
	ImageP.Bitmap.Bar(clBtnFace, ef16);

	Bmp.Canvas.Pen.Color := clGrayText;
	for j := 0 to 3 do
	begin
		y := StatToY(False, j);
		CanvasLine(Bmp.Canvas, 0, y, Bmp.Width - 1, y);
	end;

	x := (OfsX - ImageP.OfsX) mod Zoom;
	while True do
	begin
		if (x >= Bmp.Width) then Break;
		CanvasLine(Bmp.Canvas, x, 0, x, Bmp.Height - 1);
		Inc(x, Zoom);
	end;

	Bmp.Canvas.Font.Color := clWindowText;
	Bmp.Canvas.Brush.Style := bsClear;
	x := (OfsX - ImageP.OfsX) mod Zoom - 3 * Zoom;
	i := (x + ImageP.OfsX - OfsX) div Zoom;
	while True do
	begin
		if (x >= Bmp.Width) then Break;
		if (i >= 0) and (i < StatCount) then
		begin
			y := Bmp.Height - DescY + 16 * (i mod 4);
			Bmp.Canvas.TextOut(x + 1, y, TimToStr(Stat[i].Tim));
	//    Bmp.Canvas.TextOut(x, y + 16, IntToStr(Stat[i].Reserve));
		end;
		Inc(x, Zoom);
		Inc(i);
	end;

	for j := 0 to 3 do
	begin
		Bmp.Canvas.Pen.Color := SpectrumColor(320 * j);
		Bmp.Canvas.Font.Color := Bmp.Canvas.Pen.Color;
		Bmp.Canvas.TextOut(3, StatToY(True, j) + 3, InName[j]);
		Bmp.Canvas.TextOut(3, StatToY(True, j) + 3 + 16, IntToStr(Changes[j]));
		if StatCount > 0 then
		begin
			ly := StatToY(Stat[0].Inp[j], j);
			x := (OfsX - ImageP.OfsX) mod Zoom - 3 * Zoom;
			i := (x + ImageP.OfsX - OfsX) div Zoom;
			while True do
			begin
				if (x >= Bmp.Width) then Break;
				if (i >= 0) and (i < StatCount) then
				begin
					y := StatToY(Stat[i].Inp[j], j);
					CanvasLine(Bmp.Canvas, x, ly, x + Zoom - 1, y);
					ly := y;
				end;
				Inc(x, Zoom);
				Inc(i);
			end;
		end;
	end;

end;

procedure OnZoomApply(Value: S8);
begin
	Zoom := Value;
	fProbe.ImageP.Invalidate;
end;

procedure TfProbe.FormCreate(Sender: TObject);
begin
	OpenDialog1.Filter := GetFileNameFilter('Data Files', ['dat']) + '|' + AllFiles;
	SaveDialog1.Filter := OpenDialog1.Filter;
	RWOptions(False);
end;

procedure TfProbe.FormDestroy(Sender: TObject);
begin
	RWOptions(True);
end;

procedure TfProbe.Exit1Click(Sender: TObject);
begin
	Close;
end;

procedure TfProbe.Select1Click(Sender: TObject);
begin
	GetNumber('Zoom', Zoom, 1, 20, 100, OnZoomApply);
end;

procedure TfProbe.Fit1Click(Sender: TObject);
begin
	OnZoomApply(20);
end;

procedure TfProbe.Close1Click(Sender: TObject);
var i: Integer;
begin
	SetLength(Stat, 0);
	StatCount := 0;
	ImageP.Invalidate;
	for i := 0 to 3 do
		Changes[i] := 0;
end;

procedure TfProbe.Open1Click(Sender: TObject);
var
	DFile: TFile;
	InLineIndex: Integer;
	Line, s: string;
begin
	if ExecuteDialog(OpenDialog1, FileName) then
	begin
		Close1Click(Sender);
		DFile := TFile.Create;
		try
			if DFile.Open(FileName, fmReadOnly) then
			begin
				while not DFile.Eof do
				begin
					DFile.Readln(Line);
					if Line = '[Data]' then
					begin
						DFile.BlockRead(Stat[0], SizeOf(TStat) * StatCount);
						Break;
					end
					else
					begin
						InLineIndex := 1;
						s := ReadToChar(Line, InLineIndex, '=');
						if s = 'DataCount' then
						begin
							s := ReadToChar(Line, InLineIndex, '=');
							StatCount := StrToValI(s, True, 0, 0, MaxInt, 1);
							SetLength(Stat, StatCount);
						end;
					end;
				end;
				DFile.Close;
			end;
		finally
			DFile.Free;
		end;
		ImageP.Invalidate;
	end;
end;

procedure TfProbe.SaveAs1Click(Sender: TObject);
var
	DFile: TFile;
	IsTxt: Boolean;
	i: Integer;
begin
	if ExecuteDialog(SaveDialog1, FileName) then
	begin
		DecimalSeparator := '.';
		IsTxt := LowerCase(ExtractFileExt(FileName)) = '.txt';
		DFile := TFile.Create;
		try
			if DFile.Open(FileName, fmRewrite) then
			begin
				DFile.Writeln('[Head]');
				DFile.Writeln('Date=' + DateToS(DataTime, ofIO));
				DFile.Writeln('Time=' + TimeToS(DataTime, 0, ofIO));
				DFile.Writeln('DataCount=' + IntToStr(StatCount));
				DFile.Writeln('');
				DFile.Writeln('[Data]');
				DFile.Writeln(';Time [s], DCD, RI, DSR, CTS');
				if IsTxt then
				begin
					for i := 0 to StatCount - 1 do
					begin
						DFile.Writeln(TimToStr(Stat[i].Tim) + ', ' +
							IntToStr(Integer(Stat[i].Inp[0])) + ', ' +
							IntToStr(Integer(Stat[i].Inp[1])) + ', ' +
							IntToStr(Integer(Stat[i].Inp[2])) + ', ' +
							IntToStr(Integer(Stat[i].Inp[3]))
							);

					end;
				end
				else
					DFile.BlockWrite(Stat[0], SizeOf(TStat) * StatCount);
				DFile.Truncate;
				DFile.Close;
			end;
		finally
			DFile.Free;
		end;
	end;
end;

end.
