// * File:     RPC\uMain.pas
// * Created:  2001-05-28
// * Modified: 2009-09-18
// * Version:  1.0.47.34
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	uTypes,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, uDButton, ExtCtrls, uDLabel, Menus,
	ComCtrls, uDImage, uDForm, Dialogs, uDEdit, uDWinControl, uDMemo;

type
	TfMain = class(TDForm)
		Timer1: TTimer;
		MainMenu1: TMainMenu;
		File1: TMenuItem;
		Bevel3: TBevel;
		PageControl1: TPageControl;
		Probe: TTabSheet;
		Generator: TTabSheet;
		GetR: TTabSheet;
		GetU: TTabSheet;
		ButtonView: TDButton;
		ButtonProbe: TDButton;
		LabelStatCount: TDLabel;
		DLabel5: TDLabel;
		LabelF: TDLabel;
		DLabel11: TDLabel;
		DLabel14: TDLabel;
		DLabel15: TDLabel;
		DLabel16: TDLabel;
		ComboBoxRU: TComboBox;
		ComboBoxRC: TComboBox;
		EditRR: TDEdit;
		ButtonGetR: TDButton;
		ButtonClearR: TDButton;
		Bevel2: TBevel;
		DLabel4: TDLabel;
		DLabel6: TDLabel;
		DLabel7: TDLabel;
		DLabel8: TDLabel;
		DLabel12: TDLabel;
		Bevel5: TBevel;
		DLabel17: TDLabel;
		DLabel18: TDLabel;
		DLabel19: TDLabel;
		ButtonMorse: TDButton;
		ComboBoxCrumb: TComboBox;
		ButtonRun: TDButton;
		PanelP: TPanel;
		ImageP: TDImage;
		ComboBoxF: TComboBox;
		PanelCount: TDLabel;
		PanelTime: TDLabel;
		ComboBoxType: TComboBox;
		ComboBoxGC: TComboBox;
		ComboBoxGR: TComboBox;
		ComboBoxSPP: TComboBox;
		Test: TTabSheet;
		ComboBoxSA: TComboBox;
		ComboBoxSD: TComboBox;
		ButtonSet: TDButton;
		LabelIn: TDLabel;
		LabelOut: TDLabel;
		ButtonDCD: TDButton;
		ButtonRI: TDButton;
		ButtonDSR: TDButton;
		ButtonCTS: TDButton;
		ButtonRTS: TDButton;
		ButtonDTR: TDButton;
		ButtonTxD: TDButton;
		ButtonRxD: TDButton;
		Bevel4: TBevel;
		Bevel6: TBevel;
		ButtonTimer: TDButton;
		ImageGen: TImage;
		ButtonClearU: TDButton;
		ButtonRunU: TDButton;
		DLabel21: TDLabel;
		ComboBoxUC: TComboBox;
		DLabel22: TDLabel;
		ComboBoxUR: TComboBox;
		DLabel23: TDLabel;
		EditUCTS: TDEdit;
		ImageGetR: TImage;
		ImageGetU: TImage;
		MemoU: TDMemo;
		DLabel27: TDLabel;
		EditUDSR: TDEdit;
		DLabel28: TDLabel;
		EditURI: TDEdit;
		DLabel29: TDLabel;
		EditUDCD: TDEdit;
		GetF: TTabSheet;
		ButtonRunF: TDButton;
		DLabel32: TDLabel;
		EditFDCD: TDEdit;
		DLabel33: TDLabel;
		EditF2: TDEdit;
		GetC: TTabSheet;
		In8: TTabSheet;
		Out8: TTabSheet;
		DLabel1: TDLabel;
		ComboBoxOClock: TComboBox;
		ButtonRunOut8: TDButton;
		DLabel10: TDLabel;
		ComboBoxOData: TComboBox;
		ButtonClearOut8: TDButton;
		DLabel35: TDLabel;
		ComboBox3: TComboBox;
		ButtonClearIn8: TDButton;
		ButtonRunIn8: TDButton;
		DLabel36: TDLabel;
		EditIn8f: TDEdit;
		ButtonRunC: TDButton;
		DLabel37: TDLabel;
		EditGetC: TDEdit;
		ImageGetF: TImage;
		ImageGetC: TImage;
		ComboBoxGA: TComboBox;
		ButtonGet: TDButton;
		EditGD: TDEdit;
		Com: TTabSheet;
		DLabel2: TDLabel;
		DLabel20: TDLabel;
		ComboBoxUN: TComboBox;
		ComboBoxUP: TComboBox;
		DLabel9: TDLabel;
		DLabel34: TDLabel;
		ComboBoxComAddr: TComboBox;
		ComboBoxInt: TComboBox;
		ButtonApplyToScreen: TDButton;
		Bevel1: TBevel;
		DLabel3: TDLabel;
		LabelFGen: TDLabel;
		Bevel7: TBevel;
		Bevel8: TBevel;
		Help1: TMenuItem;
		DLabel13: TDLabel;
		ComboBoxGU: TComboBox;
		MemoR: TDMemo;
		ButtonAddR: TDButton;
		ButtonAddU: TDButton;
		ButtonAddF: TDButton;
		MemoF: TDMemo;
		MemoC: TDMemo;
		ButtonAddC: TDButton;
		ButtonSaveAsF: TDButton;
		ButtonSaveAsU: TDButton;
		ButtonSaveAsR: TDButton;
		ButtonSaveAsC: TDButton;
		MemoI: TDMemo;
		ButtonSaveAsIn8: TDButton;
		ImageCom9: TImage;
		ImageCom25: TImage;
		DLabel38: TDLabel;
		EditRT: TDEdit;
		DLabel39: TDLabel;
		ComboBoxROut: TComboBox;
		DLabel40: TDLabel;
		ComboBoxUMax: TComboBox;
		TabSheetGetH: TTabSheet;
		ImageGetH: TImage;
		DLabel24: TDLabel;
		DLabel25: TDLabel;
		DLabel26: TDLabel;
		DLabel30: TDLabel;
		DLabel31: TDLabel;
		EditIB: TDEdit;
		EditIC: TDEdit;
		EditH21E: TDEdit;
		ComboBoxURC: TComboBox;
		ComboBoxURB: TComboBox;
		DLabel41: TDLabel;
		EditFRI: TDEdit;
		DLabel42: TDLabel;
		EditFDSR: TDEdit;
		DLabel43: TDLabel;
		EditFCTS: TDEdit;
		DLabel44: TDLabel;
		ComboBoxUMin: TComboBox;
		DLabel45: TDLabel;
		ComboBoxCR: TComboBox;
		ImageIn8: TImage;
		ImageOut8: TImage;
		DLabel46: TDLabel;
		EditOut8f: TDEdit;
		SaveDialog1: TSaveDialog;
		DLabel47: TDLabel;
		Options1: TMenuItem;
		procedure ComboBoxComAddrChange(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure Timer1Timer(Sender: TObject);
		procedure ButtonRTSClick(Sender: TObject);
		procedure ButtonDTRClick(Sender: TObject);
		procedure ButtonTxDClick(Sender: TObject);
		procedure ButtonSetClick(Sender: TObject);
		procedure ButtonMorseKeyPress(Sender: TObject; var Key: Char);
		procedure ButtonTimerClick(Sender: TObject);
		procedure ButtonRunClick(Sender: TObject);
		procedure ButtonProbeClick(Sender: TObject);
		procedure ComboBoxFChange(Sender: TObject);
		procedure ButtonViewClick(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure Probe1Click(Sender: TObject);
		procedure ComboBoxIntChange(Sender: TObject);
		procedure ComboBoxTypeChange(Sender: TObject);
		procedure ButtonGetRClick(Sender: TObject);
		procedure ButtonClearRClick(Sender: TObject);
		procedure ButtonClearUClick(Sender: TObject);
		procedure ButtonRunUClick(Sender: TObject);
		procedure ButtonRunFClick(Sender: TObject);
		procedure ButtonRunOut8Click(Sender: TObject);
		procedure ButtonClearOut8Click(Sender: TObject);
		procedure ButtonClearIn8Click(Sender: TObject);
		procedure ButtonRunIn8Click(Sender: TObject);
		procedure ButtonRunCClick(Sender: TObject);
		procedure ButtonGetClick(Sender: TObject);
		procedure ComboBoxCrumbChange(Sender: TObject);
		procedure ComboBoxSPPChange(Sender: TObject);
		procedure ButtonAddRClick(Sender: TObject);
		procedure ButtonAddUClick(Sender: TObject);
		procedure ButtonAddFClick(Sender: TObject);
		procedure ButtonAddCClick(Sender: TObject);
		procedure ButtonSaveAsFClick(Sender: TObject);
		procedure ButtonSaveAsUClick(Sender: TObject);
		procedure ButtonSaveAsRClick(Sender: TObject);
		procedure ButtonSaveAsCClick(Sender: TObject);
		procedure ButtonSaveAsIn8Click(Sender: TObject);
	private
		{ Private declarations }
		procedure InitCommon;
		procedure Gener(const Run: Boolean);
		procedure SetButtons;
		procedure RWOptions(const Save: Boolean);
		procedure SaveMemoToFile(Memo: TDMemo);
	public
		{ Public declarations }
	end;

type
	TStat = packed record // 12
		Tim: Int64; // 8
		Inp: array[0..3] of Boolean; // 4
//    Reserve: Integer; // 4
	end;
	TFlo = Extended;

var
	fMain: TfMain;

	Stat: array of TStat;
	StatCount: Integer;

	IntF: Extended;
	IntTime: U8;

	PortUP, PortUN: TFlo;

implementation

{$R *.DFM}
uses
	uRS232, uDIniFile, uGraph, uAbout, uMenus, uFile, uFiles, uWave, uInputFormat, uMath, uOutputFormat, uSystem,
	uDBitmap, uStrings, uSimulation,
	uProbe;

var
	ComIndex: Integer;
	GeneratorRun, ProbeRun: Boolean;
	FullF, Crumb: Extended;

procedure TfMain.ComboBoxComAddrChange(Sender: TObject);
begin
	ComIndex := ComboBoxComAddr.ItemIndex;
	SetCom(ComIndex);
end;

procedure TfMain.RWOptions(const Save: Boolean);
begin
	MainIni.RWFormPos(Self, Save);

	ComboBoxComAddr.ItemIndex := MainIni.RWSGF('Options', 'ComAddr', ComboBoxComAddr.ItemIndex, 0, Save);
	ComboBoxInt.Text := MainIni.RWStringF('Options', 'Interrupt', ComboBoxInt.Text, ComboBoxInt.Text , Save);
	ButtonApplyToScreen.Down := MainIni.RWBGF('Options', 'Screen', ButtonApplyToScreen.Down, ButtonApplyToScreen.Down, Save);

	PageControl1.ActivePageIndex := MainIni.RWSGF('Options', 'PageIndex', PageControl1.ActivePageIndex, 0, Save);

	ComboBoxGA.Text := MainIni.RWStringF('Options', 'GetAddr', ComboBoxGA.Text, ComboBoxGA.Text, Save);
	ComboBoxSA.Text := MainIni.RWStringF('Options', 'SetAddr', ComboBoxSA.Text, ComboBoxSA.Text, Save);
	ComboBoxSD.Text := MainIni.RWStringF('Options', 'SetData', ComboBoxSD.Text, ComboBoxSD.Text, Save);

	ComboBoxType.ItemIndex := MainIni.RWSGF('Options', 'Type', ComboBoxType.ItemIndex, 0 , Save);
	ComboBoxCrumb.Text := MainIni.RWStringF('Options', 'Crumb', ComboBoxCrumb.Text, ComboBoxCrumb.Text, Save);
	ComboBoxF.Text := MainIni.RWStringF('Options', 'Frequency', ComboBoxF.Text, '10', Save);
	ComboBoxGR.Text := MainIni.RWStringF('Options', 'GR', ComboBoxGR.Text, ComboBoxGR.Text, Save);
	ComboBoxGC.Text := MainIni.RWStringF('Options', 'GC', ComboBoxGC.Text, ComboBoxGC.Text, Save);

	ComboBoxRU.Text := MainIni.RWStringF('Options', 'RU', ComboBoxRU.Text, ComboBoxRU.Text, Save);
	ComboBoxRC.Text := MainIni.RWStringF('Options', 'RC', ComboBoxRC.Text, ComboBoxRC.Text, Save);

	ComboBoxUN.Text := MainIni.RWStringF('Options', 'UN', ComboBoxUN.Text, ComboBoxUN.Text, Save);
	ComboBoxUP.Text := MainIni.RWStringF('Options', 'UP', ComboBoxUP.Text, ComboBoxUP.Text, Save);
	ComboBoxROut.Text := MainIni.RWStringF('Options', 'ROut', ComboBoxROut.Text, ComboBoxROut.Text, Save);
	ComboBoxUC.Text := MainIni.RWStringF('Options', 'UC', ComboBoxUC.Text, ComboBoxUC.Text, Save);
	ComboBoxUR.Text := MainIni.RWStringF('Options', 'UR', ComboBoxUR.Text, ComboBoxUR.Text, Save);
	ComboBoxUMax.Text := MainIni.RWStringF('Options', 'UMax', ComboBoxUMax.Text, ComboBoxUMax.Text, Save);
	ComboBoxUMin.Text := MainIni.RWStringF('Options', 'UMin', ComboBoxUMin.Text, ComboBoxUMin.Text, Save);
	ComboBoxURC.Text := MainIni.RWStringF('Options', 'URC', ComboBoxURC.Text, ComboBoxURC.Text, Save);
	ComboBoxURB.Text := MainIni.RWStringF('Options', 'URB', ComboBoxURB.Text, ComboBoxURB.Text, Save);

	ComboBoxCR.Text := MainIni.RWStringF('Options', 'CR', ComboBoxCR.Text, IntToStr(1000000), Save);
end;

procedure TfMain.Gener(const Run: Boolean);
var
	TickCount, LTickCount, StartCount, NextTick: Int64;
	GR, GC, GU, U, UP, UN, MinU, MaxU: TFlo;
	Loop: Int64;
	j, Co: Integer;
	Typ: Integer;
	SPP, SPPCount: Integer;
	PerT: array[0..511] of Int64;
	PerU: array[0..511] of TFlo;

	Bmp: TBitmap;
	k: Integer;
	x1, y1, x2, y2: SG;
	t: Int64;
	Stat, LStat: SG;
	SumT, PeriodT: Int64;
	CustU: TFlo;

	function UToY(U: TFlo): SG;
	begin
		Result := Bmp.Height - 1 - Round((U - MinU) * Bmp.Height / (MaxU - MinU));
	end;

begin
	Typ := ComboBoxType.ItemIndex;
	FullF := StrToValE(ComboBoxF.Text, True, 0.01, 10, MaxInt);
	Crumb := StrToValE(ReplaceF(ComboBoxCrumb.Text, ':', '/'), True, 0.000001, 1, 1000000);

	GR := StrToValE(ComboBoxGR.Text, True, 1, 1000, 1e6);
	GC := StrToValE(ComboBoxGC.Text, True, 1e-15, 1e-6, 1);
	GU := StrToValE(ComboBoxGU.Text, True, 0, 1, 10);
	SPP := StrToValI(ComboBoxSPP.Text, True, 1, SG(3), 8, 1);
	PeriodT := Round(PerformanceFrequency / (FullF * (1 shl SPP)));
	if PeriodT = 0 then Exit;
	InitCommon;
	if Sins = nil then
	begin
		GetMem(Sins, SizeOf(TAngle) * AngleCount);
		FillSinTable(Sins, AngleCount, SinDiv);
	end;

	case Typ of
	1:
	begin
		MinU := MaxInt;
		MaxU := MinInt;
		SPPCount := 1 shl SPP;
		U := 0;
		for j := 0 to SPPCount - 1 do
		begin
			Co := Sins[(((256 * j + 128) shr SPP) + $40) and $ff];

			PerT[2 * j] := Round((PerformanceFrequency / (FullF * SPPCount)) * (Co + SinDiv) / (2 * SinDiv));
			U := U + PortUP * PerT[2 * j] / (GR * GC * PerformanceFrequency);
			if U > PortUP then U := PortUP;
			PerU[2 * j] := U;
			if U > MaxU then MaxU := U;

			PerT[2 * j + 1] := Round(PerformanceFrequency / (FullF * SPPCount)) - PerT[2 * j];
			U := U + PortUN * PerT[2 * j + 1] / (GR * GC * PerformanceFrequency);
			if U < PortUN then U := PortUN;
			if U < MinU then MinU := U;
			PerU[2 * j + 1] := U;

		end;
		SPPCount := SPPCount * 2;
	end;
	2:
	begin
		PerU[0] := 0;
		MinU := 0;
		MaxU := 0;
		U := 0;
		Stat := 1;
		SPPCount := 0;
		SumT := 0;
		for j := 0 to 1 shl SPP - 1 do
		begin
			Co := Sins[((256 * (j + 1) shr SPP)) and $ff];
			CustU := GU * Co / SinDiv;

			UP := U + PortUP * PeriodT / (GR * GC * PerformanceFrequency);
			if UP > PortUP then UP := PortUP;
			UN := U + PortUN * PeriodT / (GR * GC * PerformanceFrequency);
			if UN < PortUN then UN := PortUN;

			LStat := Stat;
			if Abs(UP - CustU) > Abs(UN - CustU) then
				Stat := -1
			else
				Stat := 1;

			PerU[j] := U;
			Inc(SumT, PeriodT);
			if Stat <> LStat then
			begin
				PerT[SPPCount] := SumT;
				Inc(SPPCount);
				SumT := 0;
			end;

			if Stat = 1 then
			begin
				U := UP;
			end
			else
			begin
				U := UN;
			end;

			if U > MaxU then MaxU := U;
			if U < MinU then MinU := U;
		end;
	end;
	else
	begin
		MinU := PortUN;
		MaxU := PortUP;
		PerT[0] := Round(PerformanceFrequency / ((1 + 1 / Crumb) * FullF));
		PerT[1] := Round(PerformanceFrequency / FullF) - PerT[0];
		SPPCount := 2;
	end;
	end;

	if Run = False then
	begin
		ImageGen.Visible := ComboBoxType.ItemIndex > 0;

		Bmp := ImageP.Bitmap;

		Bmp.Canvas.Brush.Color := clBtnFace;
		Bmp.Canvas.FillRect(Rect(0, 0, Bmp.Width, Bmp.Height));

		case ComboBoxType.ItemIndex of
		0:
		begin
			Bmp.Canvas.Pen.Color := clWindowText;
			CanvasLine(Bmp.Canvas, 0, Bmp.Height div 2, Bmp.Width - 1, Bmp.Height div 2);
			k := Round((Bmp.Width - 1) / (1 + 1 / Crumb));
			CanvasLine(Bmp.Canvas, 0, 2, k - 1, 2);
			CanvasLine(Bmp.Canvas, k, 2, k, Bmp.Height - 3);
			CanvasLine(Bmp.Canvas, k + 1, Bmp.Height - 3, Bmp.Width - 1, Bmp.Height - 3);
		end;
		1, 2:
		begin
			Bmp.Canvas.Pen.Color := clGrayText;
			y2 := UToY(0);
			CanvasLine(Bmp.Canvas, 0, y2, Bmp.Width - 1, y2);
			Bmp.Canvas.Pen.Color := clGrayText;
			t := 0;
			for j := 0 to 1 shl SPP - 1 do
			begin
				Inc(t, PeriodT);
				x2 := Round(t * Bmp.Width / Round(PerformanceFrequency / FullF));
				CanvasLine(Bmp.Canvas, x2, 0, x2, Bmp.Height - 1);
			end;
			x2 := 0;
			y2 := UToY(0);
			t := 0;
			for j := 0 to SPPCount - 1 do
			begin
				y1 := y2;
				if MaxU - MinU = 0 then
					y2 := 0
				else
					y2 := UToY(PerU[j]);
				x1 := x2;
				Inc(t, PerT[j]);
				x2 := Round(t * Bmp.Width / Round(PerformanceFrequency / FullF));
				Bmp.Canvas.Pen.Color := clWindowText;
				CanvasLine(Bmp.Canvas, x1, y1, x2, y2);
			end;
		end;
		end;
		Bmp.Canvas.TextOut(2, 2, FloatToStr(MaxU));
		Bmp.Canvas.TextOut(2, Bmp.Height - 3 - Bmp.Canvas.TextHeight('W'), FloatToStr(MinU));
	end
	else
	begin
		if GeneratorRun then
		begin
			GeneratorRun := False;
			Exit;
		end;
		GeneratorRun := True;
		Application.ProcessMessages;

		DTR := False;
		RTS := False;

		Loop := 0;
		LTickCount := PerformanceCounter;
		StartCount := LTickCount;
		NextTick := LTickCount;
		while GeneratorRun do
		begin
			DTR := not DTR;
			RTS := not RTS;
			SetOut;
	{   SetButtons;
			Application.ProcessMessages;}
			NextTick := NextTick + PerT[Loop and (SPPCount - 1)];
			repeat
				TickCount := PerformanceCounter;
			until TickCount >= NextTick;

			Inc(Loop);

			if (IntTime > 0) and (TickCount > LTickCount + IntTime) then
			begin
				if GetAsyncKeyState(VK_ESCAPE) <> 0 then ButtonRun.Click;
				if ButtonApplyToScreen.Down then
				begin
					PanelCount.Caption := IntToStr(Loop);
					PanelTime.Caption := NToS(RoundDivS8(1000000 * (TimeDifference(TickCount, StartCount)), PerformanceFrequency), 6);
					Application.ProcessMessages;
				end;
				Inc(LTickCount, IntTime);
			end;
		end;
	end;
end;

procedure TfMain.SetButtons;
begin
{	if ButtonDCD.Down <> DCD then
		PlayWave(BSoundDown);}
	ButtonDCD.Down := DCD;

{	if ButtonRI.Down <> RI then
		PlayWave(BSoundDown);}
	ButtonRI.Down := RI;

{	if ButtonDSR.Down <> DSR then
		PlayWave(BSoundDown);}
	ButtonDSR.Down := DSR;

{	if ButtonCTS.Down <> CTS then
		PlayWave(BSoundDown);}
	ButtonCTS.Down := CTS;

{	if ButtonRxD.Down <> RxD then
		PlayWave(BSoundDown);}
	ButtonRxD.Down := RxD;


{	if ButtonRTS.Down <> RTS then
		PlayWave(BSoundDown);}
	ButtonRTS.Down := RTS;

{	if ButtonDTR.Down <> DTR then
		PlayWave(BSoundDown);}
	ButtonDTR.Down := DTR;

{	if ButtonTxD.Down <> TxD then
		PlayWave(BSoundDown);}
	ButtonTxD.Down := TxD;
end;

procedure TfMain.Timer1Timer(Sender: TObject);
begin
	GetIn;
	GetOut;
	SetButtons;
end;

procedure TfMain.ButtonRTSClick(Sender: TObject);
begin
	RTS := not RTS;
	SetOut;
end;

procedure TfMain.ButtonDTRClick(Sender: TObject);
begin
	DTR := not DTR;
	SetOut;
end;

procedure TfMain.ButtonTxDClick(Sender: TObject);
begin
	TxD := not TxD;
	SetOut;
end;

procedure TfMain.ButtonSetClick(Sender: TObject);
{var
	LDCD, LRI, LDSR, LCTS, // In
	LRTS, LDTR, LTxD, LRxD: Boolean; // Out
	i: Integer;}
var
	PortAdr: Word;
	PortData: Byte;
begin
	PortAdr := StrToValI(ComboBoxSA.Text, True, 0, UG($3FB), $ffff, 1);
	PortData := StrToValI(ComboBoxSD.Text, True, 0, UG(0), $ff, 1);
	asm
	push dx
	push ax
	mov dx, PortAdr
	mov al, PortData
	out dx, al

	pop ax
	pop dx
	end;

{ for i := 0 to 999999 do
	begin
		LDCD := DCD;
		LRI := RI;
		LDSR := DSR;
		LCTS := CTS;
		LRTS := RTS;
		LDTR := DTR;
		LTxD := TxD;
		LRxD := RxD;
		GetIn;
		GetOut;
		if LDCD <> DCD then
			Beepr;
		if LRI <> RI then
			Beepr;
		if LDSR <> DSR then
			Beepr;
		if LCTS <> CTS then
			Beepr;
		if LRTS <> RTS then
			Beepr;
		if LDTR <> DTR then
			Beepr;
		if LTxD <> TxD then
			Beepr;
	end;}
end;

procedure TfMain.ButtonMorseKeyPress(Sender: TObject; var Key: Char);
const
	tmPoint = $1;
	tmStroke = $2;
	tmEnd = $0;
const
	Morse: array[0..46] of Integer = (
		$21, // A
		$1112, // B
		$212, // C
		$112, // D
		$1, // E
		$1211, // F
		$122, // G
		$1111, // H
		$11, // I
		$2221, // J
		$212, // K
		$1121, // L
		$22, // M
		$12, // N
		$222, // O
		$1221, // P
		$2122, // Q
		$121, // R
		$111, // S
		$1, // T
		$211, // U
		$2111, // V
		$221, // W
		$2112, // X
		$2212, // Y
		$1122, // Z
		$22222, // 0
		$22221, // 1
		$22211, // 2
		$22111, // 3
		$21111, // 4
		$11111, // 5
		$11112, // 6
		$11122, // 7
		$11222, // 8
		$12222, // 9

		$111111, // .
		$221122, // ,
		$112211, // ?
		$2211122, // =
		$121121, // "
		$211112, // -
		$111222, // :
		$121212, // ;
		$212212, // (
		$12112, // /
		$21122 // !
		);

var i, j, m: Integer;
begin
	case UpCase(Key) of
	'A'..'Z': i := Ord(UpCase(Key)) - Ord('A');
	'0'..'9': i := Ord(UpCase(Key)) - Ord('0') + Ord('Z') - Ord('A') + 1;
	'.': i := 36;
	',': i := 37;
	'?': i := 38;
	'=': i := 39;
	'"': i := 40;
	'-': i := 41;
	':': i := 42;
	';': i := 43;
	'(': i := 44;
	'/': i := 45;
	'!': i := 46;
	else Exit;
	end;
	m := Morse[i];
	for j := 15 downto 1 do
	begin
		case m and $f of
		tmPoint:
		begin
			DTR := True;
			SetOut;
			SetButtons;
			Application.ProcessMessages;
			Sleep(150);
			DTR := False;
			SetOut;
			SetButtons;
			Application.ProcessMessages;
			Delay(300);
		end;
		tmStroke:
		begin
			DTR := True;
			SetOut;
			SetButtons;
			Application.ProcessMessages;
			Sleep(450);
			DTR := False;
			SetOut;
			SetButtons;
			Application.ProcessMessages;
			Delay(300);
		end;
		tmEnd: Break;
		end;
		m := m shr 4;
	end;
end;

procedure TfMain.ButtonTimerClick(Sender: TObject);
begin
	Timer1.Enabled := ButtonTimer.Down;
end;


procedure TfMain.ButtonRunClick(Sender: TObject);
begin
	Gener(True);
end;

procedure TfMain.ButtonProbeClick(Sender: TObject);
var
	LDCD, LRI, LDSR, LCTS: Boolean;
	i: Int64;
	NewSize: Integer;
	Perf, LPerf, StartTime, TotTime: Int64;
begin
	if ProbeRun then
	begin
		ProbeRun := False;
		Exit;
	end;
	ProbeRun := True;
	Application.ProcessMessages;
	DataTime := Now;
	GetIn;
	LDCD := DCD;
	LRI := RI;
	LDSR := DSR;
	LCTS := CTS;
	SetLength(Stat, 65536);
	FillChar(Stat[0], 65536 * SizeOf(Stat[0]), 0);

	i := 0;
	LPerf := PerformanceCounter;
	StartTime := LPerf;
	TotTime := 1;
	while ProbeRun do
	begin
		Perf := PerformanceCounter;
		GetIn;
//    CTS := not CTS;
		if (LDCD <> DCD) or
		(LRI <> RI) or
		(LDSR <> DSR) or
		(LCTS <> CTS) then
		begin
			NewSize := StatCount + 1;
			if AllocByExp(Length(Stat), NewSize) then
				SetLength(Stat, NewSize);
			Stat[StatCount].Inp[0] := DCD;
			Stat[StatCount].Inp[1] := RI;
			Stat[StatCount].Inp[2] := DSR;
			Stat[StatCount].Inp[3] := CTS;
			Stat[StatCount].Tim := Perf;

			Inc(StatCount);

			if LDCD <> DCD then Inc(Changes[0]);
			if LRI <> RI then Inc(Changes[1]);
			if LDSR <> DSR then Inc(Changes[2]);
			if LCTS <> CTS then Inc(Changes[3]);

			LDCD := DCD;
			LRI := RI;
			LDSR := DSR;
			LCTS := CTS;
		end;
		Inc(i);
		if (IntTime > 0) and (Perf >= LPerf + IntTime) then
		begin
			if GetAsyncKeyState(VK_ESCAPE) <> 0 then
			begin
				TotTime := Perf - StartTime;
				ButtonProbe.Click;
			end;
			if ButtonApplyToScreen.Down then
			begin
				LabelStatCount.Caption := IntToStr(StatCount);
				Application.ProcessMessages;
			end;
			Inc(LPerf, IntTime);
		end;
	end;
	LabelF.Caption := IntToStr(RoundDivS8(i * PerformanceFrequency, TotTime));
end;

procedure TfMain.ComboBoxFChange(Sender: TObject);
begin
	Gener(False);
end;

procedure TfMain.ButtonViewClick(Sender: TObject);
begin
	if not Assigned(fProbe) then fProbe := TfProbe.Create(Self);
	fProbe.Show;
end;

procedure TfMain.FormDestroy(Sender: TObject);
begin
	RWOptions(True);
	if Assigned(fProbe) then
	begin
		FreeAndNil(fProbe);
	end;
end;

procedure TfMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	GeneratorRun := False;
	ProbeRun := False;
end;

procedure TfMain.Probe1Click(Sender: TObject);
begin
	ButtonViewClick(Sender);
end;

procedure TfMain.ComboBoxIntChange(Sender: TObject);
begin
	IntF := StrToValE(ComboBoxInt.Text, True, 0.01, 25, 100);
	IntTime := Round(PerformanceFrequency / IntF)
end;

procedure TfMain.ComboBoxTypeChange(Sender: TObject);
begin
	Gener(False);
end;

procedure TfMain.ButtonGetRClick(Sender: TObject);
var
	RU, RC, RT, RR: TFlo;
	STim, Tim: U8;
	LCTS: Boolean;
begin
	RU := StrToValE(ComboBoxRU.Text, True, 0, 13.5, 30);
	RC := StrToValE(ComboBoxRC.Text, True, 1e-15, 1e-6, 1);
	InitCommon;
	GetIn;
	LCTS := CTS;
	RTS := True;
	SetOut;
	STim := PerformanceCounter;
	Tim := STim;
	while True do
	begin
		GetIn;
		if CTS <> LCTS then
		begin
			EditRR.Color := clBtnFace;
			Break;
		end;
		Tim := PerformanceCounter;
		if Tim - STim > 2 * PerformanceFrequency then
		begin
			EditRR.Color := clRed;
			Break; // 2s max for lag
		end;
	end;
	RTS := False;
	SetOut;

	RT := (Tim - STim) / PerformanceFrequency;
	EditRT.Text := FloatToStr(RT);

	//RR := RT / (RC * RU);
	RT := 0.001;
	RR := RT / (RC * (-ln(1 - RU / PortUP)));
	EditRR.Text := FloatToStr(RR);
end;

procedure TfMain.ButtonClearRClick(Sender: TObject);
begin
	RTS := False;
	SetOut;
end;

procedure TfMain.ButtonClearUClick(Sender: TObject);
begin
	RTS := True;
	TxD := False;
	DTR := False;
	SetOut;
	Sleep(100);
	GetIn;
	if CTS then EditUCTS.Color := clRed else EditUCTS.Color := clBtnFace;
	if DSR then EditUDSR.Color := clRed else EditUDSR.Color := clBtnFace;
	if RI then EditURI.Color := clRed else EditURI.Color := clBtnFace;
	if DCD then EditUDCD.Color := clRed else EditUDCD.Color := clBtnFace;
end;

procedure TfMain.InitCommon;
begin
	PortUP := StrToValE(ComboBoxUP.Text, True, -1000, 11.5, 1000);
	PortUN := StrToValE(ComboBoxUN.Text, True, -1000, -11.5, 1000);
end;

procedure TfMain.ButtonRunUClick(Sender: TObject);
var
	STim, Tim, T1, T2, T3, T4: U8;
	LCTS, LDSR, LRI, LDCD: Boolean;

	Tau, UMax, UMin, U, U1, U2, U3, U4, RC, RB, IC, IB: TFlo;

begin
	DTR := False;
	RTS := True; // +Ucc
	TxD := False; // -Ucc
	SetOut;
	Sleep(250);

	T1 := 0;
	T2 := 0;
	T3 := 0;
	T4 := 0;
	GetIn;
	LCTS := CTS;
	LDSR := DSR;
	LRI := RI;
	LDCD := DCD;

	DTR := True;
	SetOut;
	STim := PerformanceCounter;
	Tim := STim;

	while True do
	begin
		GetIn;
		if (LCTS <> CTS) and (T1 = 0) then
		begin
			LCTS := CTS;
			T1 := Tim - STim;
		end;
		if (LDSR <> DSR) and (T2 = 0) then
		begin
			LDSR := DSR;
			T2 := Tim - STim;
		end;
		if (LRI <> RI) and (T3 = 0) then
		begin
			LRI := RI;
			T3 := Tim - STim;
		end;
		if (LDCD <> DCD) and (T4 = 0) then
		begin
			LDCD := DCD;
			T4 := Tim - STim;
		end;
		if (T1 <> 0) and (T2 <> 0) and (T3 <> 0) and (T4 <> 0) then Break;

		Tim := PerformanceCounter;
		if Tim - STim > 2 * PerformanceFrequency then
		begin
			Break; // 2s max for lag
		end;
	end;
	DTR := False;
	SetOut;

	Tau :=
		StrToValE(ComboBoxUC.Text, True, 1e-15, 100e-9, 1) *
		StrToValE(ComboBoxUR.Text, True, 1, 100000, 1e9) * PerformanceFrequency;
/// InitCommon;
//  U := PortUP - PortUN;
	UMax := StrToValE(ComboBoxUMax.Text, True, -30, 7.5, 30);
	UMin := StrToValE(ComboBoxUMin.Text, True, -30, -7.5, 30);
	U := UMax - UMin;

	U1 := U * Exp(-T1 / Tau) + UMin;
	U2 := U * Exp(-T2 / Tau) + UMin;
	U3 := U * Exp(-T3 / Tau) + UMin;
	U4 := U * Exp(-T4 / Tau) + UMin;

	EditUCTS.Text := FloatToStr(U1) + '; ' + FloatToStr(T1 / PerformanceFrequency);
	EditUDSR.Text := FloatToStr(U2) + '; ' + FloatToStr(T2 / PerformanceFrequency);
	EditURI.Text := FloatToStr(U3) + '; ' + FloatToStr(T3 / PerformanceFrequency);
	EditUDCD.Text := FloatToStr(U4) + '; ' + FloatToStr(T4 / PerformanceFrequency);



	RC := StrToValE(ComboBoxURC.Text, True, 1, 1000, 1e9);
	RB := StrToValE(ComboBoxURB.Text, True, 1, 10000, 1e9);
	IC := (U1 - U4) / RC;
	IB := (U2 - U3) / RB;
	EditIC.Text := FloatToStr(IC);
	EditIB.Text := FloatToStr(IB);
	if IB <> 0 then
		EditH21E.Text := FloatToStr(IC / IB)
	else
		EditH21E.Text := '';
end;

procedure TfMain.ButtonRunFClick(Sender: TObject);
var
	STim, Tim, ReadTick: U8;
	Tick: array[0..3] of U8;
	LPort: array[0..3] of Boolean;
	i: SG;
begin
	GetIn;
	for i := 0 to 3 do
		Tick[i] := 0;
	STim := PerformanceCounter;
	Tim := STim;
	ReadTick := 0;
	while True do
	begin
		for i := 0 to 3 do
			LPort[i] := RSIn[i];
		GetIn;
		Tim := PerformanceCounter;
		for i := 0 to 3 do
			if (RSIn[0] = True) and (LPort[i] = False) then
			begin
				if Tick[i] = 0 then
				begin
					STim := Tim;
					ReadTick := 0;
				end;
				Inc(Tick[i]);
			end;

		if Tim - STim > 2 * PerformanceFrequency then
		begin
			Break; // 2s max for lag
		end;
		Inc(ReadTick);
	end;

	if (Tim > STim) then
	begin
		EditFDCD.Text := FloatToStr(Tick[0] * PerformanceFrequency / (Tim - STim));
		EditFRI.Text := FloatToStr(Tick[1] * PerformanceFrequency / (Tim - STim));
		EditFDSR.Text := FloatToStr(Tick[2] * PerformanceFrequency / (Tim - STim));
		EditFCTS.Text := FloatToStr(Tick[3] * PerformanceFrequency / (Tim - STim));
		EditF2.Text := FloatToStr(ReadTick * PerformanceFrequency / (Tim - STim));
	end
	else
	begin
		EditFDCD.Text := '';
		EditFRI.Text := '';
		EditFDSR.Text := '';
		EditFCTS.Text := '';
		EditF2.Text := '';
	end;
end;

procedure TfMain.ButtonClearOut8Click(Sender: TObject);
begin
	DTR := False;
	RTS := False;
	SetOut;
end;

procedure TfMain.ButtonRunOut8Click(Sender: TObject);
var
	STim, Tim, NextTim, Period: U8;
	OutData: Word;
	Ofs: Byte;
	ReadCount: UG;
begin
	OutData := StrToValI(ComboBoxOData.Text, True, 0, UG(128 + 32 + 8 + 2), 255, 1);
	Period := Round(PerformanceFrequency / StrToValE(ComboBoxOClock.Text, True, 1, 1000, 1000000));

	RTS := True;
	SetOut;
	Sleep(100);
	Ofs := 0;
	ReadCount := 0;
	STim := PerformanceCounter;
	Tim := STim;
	while True do
	begin
		if DTR = False then
		begin
			TxD := Boolean((OutData shr Ofs) and 1);
			SetOut;
			Tim := PerformanceCounter;
			NextTim := Tim + Period;
			repeat
				Tim := PerformanceCounter;
			until Tim >= NextTim;
			Inc(Ofs); if Ofs >= 16 then Ofs := 0;
			Inc(ReadCount);
		end;
		DTR := not DTR;
		SetOut;
		Tim := PerformanceCounter;
		NextTim := Tim + Period;
		repeat
			Tim := PerformanceCounter;
		until Tim >= NextTim;

		if Tim - STim > 2 * PerformanceFrequency then
		begin
			Break; // 2s max for lag
		end;
	end;
	if Tim > STim then
		EditOut8f.Text := IntToStr(RoundDivS8(PerformanceFrequency * ReadCount, (Tim - STim)));
end;

procedure TfMain.ButtonClearIn8Click(Sender: TObject);
begin
	DTR := False;
	RTS := False;
	SetOut;
end;

procedure TfMain.ButtonRunIn8Click(Sender: TObject);
var
	STim, Tim, NextTim, Period: U8;
	InData: array[0..65535] of packed record // 9
		Tim: U8;
		Data: U1;
	end;
	InDataCount: SG;
	InDat, LInDat: SG;
	Ofs: Byte;
	i: SG;
	ReadCount: U8;
begin
	Period := Round(PerformanceFrequency / StrToValE(ComboBoxOClock.Text, True, 1, 1000, 1000000));


	InDataCount := 0;
	LInDat := -1;
	ReadCount := 0;
	STim := PerformanceCounter;
	Tim := STim;
	while True do
	begin
		InDat := 0;
		Ofs := 0;
		DTR := False;
		RTS := True;
		SetOut;

		RTS := False;
		SetOut;
		for i := 0 to 15 do
		begin
			DTR := not DTR;
			SetOut;
			if DTR then
			begin
				GetIn;
				Inc(InDat, U1(DCD) shl Ofs);
				Inc(Ofs);
			end;
			Inc(ReadCount);
			Tim := PerformanceCounter;
			NextTim := Tim + Period;
			repeat
				Tim := PerformanceCounter;
			until Tim >= NextTim;
		end;
		if InDat <> LInDat then
		begin
			LinDat := InDat;
			InData[InDataCount].Data := InDat;
			InData[InDataCount].Tim := Tim;
		end;

		if Tim - STim > 2 * PerformanceFrequency then
		begin
			Break; // 2s max for lag
		end;
	end;
	if Tim > STim then
		EditIn8f.Text := IntToStr(RoundDivS8(PerformanceFrequency * ReadCount, (Tim - STim)));
	for i := 0 to InDataCount - 1 do
	begin
		MemoI.Lines.Add(IntToStr(InData[i].Tim - STim) + ': ' + IntToStr(InData[i].Data));
	end;
end;

procedure TfMain.ButtonRunCClick(Sender: TObject);
var
	STim, Tim, Tick, i: U8;
	R2: TFlo;
	LCTS: Boolean;
begin
	R2 := StrToValE(ComboBoxCR.Text, True, 1, 1000000, 10e19);
	GetIn;
	Tick := 0;
	STim := PerformanceCounter;
	Tim := STim;
	i := 0;
	while True do
	begin
		LCTS := CTS;
		GetIn;
		Tim := PerformanceCounter;
		if (CTS = True) and (LCTS = False) then
		begin
			if Tick = 0 then
			begin
				STim := Tim;
				i := 0;
			end;
			Inc(Tick);
		end;

		if Tim - STim > 2 * PerformanceFrequency then
		begin
			Break; // 2s max for lag
		end;
		Inc(i);
	end;

	if (Tim > STim) then
		EditGetC.Text := FloatToStr(Tick * PerformanceFrequency / (1.386 * R2 * (Tim - STim)))
	else
		EditGetC.Text := '';
end;

procedure TfMain.ButtonGetClick(Sender: TObject);
var
	PortAdr: Word;
	PortData: Byte;
	s: string;
begin
	PortAdr := StrToValI(ComboBoxGA.Text, True, 0, UG($3FB), $ffff, 1);
	asm
	push dx
	push ax
	mov dx, PortAdr
	in al, dx
	mov PortData, al

	pop ax
	pop dx
	end;
	FmtStr(s, '%s%.2x', [HexDisplayPrefix, PortData]);
	EditGD.Text := s;
end;

procedure TfMain.ComboBoxCrumbChange(Sender: TObject);
begin
	Gener(False);
end;

procedure TfMain.ComboBoxSPPChange(Sender: TObject);
begin
	Gener(False);
end;

procedure TfMain.ButtonAddRClick(Sender: TObject);
begin
	MemoR.Lines.Add(EditRR.Text);
end;

procedure TfMain.ButtonAddUClick(Sender: TObject);
begin
	MemoU.Lines.Add(EditUCTS.Text);
end;

procedure TfMain.ButtonAddFClick(Sender: TObject);
begin
	MemoF.Lines.Add(EditFDCD.Text);
	MemoF.Lines.Add(EditFRI.Text);
	MemoF.Lines.Add(EditFDSR.Text);
	MemoF.Lines.Add(EditFCTS.Text);
end;

procedure TfMain.ButtonAddCClick(Sender: TObject);
begin
	MemoC.Lines.Add(EditGetC.Text);
end;

procedure TfMain.SaveMemoToFile(Memo: TDMemo);
var
	F: TFile;
	FileName: TFileName;
	i: SG;
begin
	FileName := AppDataDir + Memo.Name + '.txt';
	if ExecuteDialog(SaveDialog1, FileName) then
	begin
		F := TFile.Create;
		try
			if F.Open(FileName, fmRewrite) then
			begin
				for i := 0 to Memo.Lines.Count - 1 do
					F.Writeln(Memo.Lines[i]);
				F.Truncate;
				F.Close;
			end;
		finally
			F.Free;
		end;
	end;
end;

procedure TfMain.ButtonSaveAsFClick(Sender: TObject);
begin
	SaveMemoToFile(MemoF);
end;

procedure TfMain.ButtonSaveAsUClick(Sender: TObject);
begin
	SaveMemoToFile(MemoU);
end;

procedure TfMain.ButtonSaveAsRClick(Sender: TObject);
begin
	SaveMemoToFile(MemoR);
end;

procedure TfMain.ButtonSaveAsCClick(Sender: TObject);
begin
	SaveMemoToFile(MemoC);
end;

procedure TfMain.ButtonSaveAsIn8Click(Sender: TObject);
begin
	SaveMemoToFile(MemoI);
end;

procedure BitmapLoadFromFile(const Bitmap: TBitmap; const FileName: TFileName);
var Bmp: TDBitmap;
begin
	Bmp := TDBitmap.Create;
	try
		Bmp.LoadFromFile(FileName);
		Bmp.ToBitmap(Bitmap);
	finally
		Bmp.Free;
	end;
end;

procedure TfMain.FormCreate(Sender: TObject);
var
	i: Integer;
	s: string;
begin
	SaveDialog1.Filter := AllText;
	LabelFGen.Caption := NToS(PerformanceFrequency);
	ComboBoxComAddr.Items.BeginUpdate;
	try
		for i := 0 to 3 do
		begin
			FmtStr(s, '%s%.4x', [HexDisplayPrefix, ComAddr[i]]);
			ComboBoxComAddr.Items.Add(s + ' (Com' + IntToStr(i + 1) + ')');
		end;
	finally
		ComboBoxComAddr.Items.EndUpdate;
	end;
	ButtonDCD.Down := True;
	ButtonDCD.Down := False;
	RWOptions(False);
	ComboBoxIntChange(Sender);

	BitmapLoadFromFile(ImageCom9.Picture.Bitmap, GraphDir + 'Com' + IconExt);
	BitmapLoadFromFile(ImageCom25.Picture.Bitmap, GraphDir + 'Com25' + IconExt);
	BitmapLoadFromFile(ImageGen.Picture.Bitmap, GraphDir + 'Gen' + IconExt);
	BitmapLoadFromFile(ImageGetR.Picture.Bitmap, GraphDir + 'GetR' + IconExt);
	BitmapLoadFromFile(ImageGetU.Picture.Bitmap, GraphDir + 'GetU' + IconExt);
	BitmapLoadFromFile(ImageGetH.Picture.Bitmap, GraphDir + 'GetH' + IconExt);
	BitmapLoadFromFile(ImageGetF.Picture.Bitmap, GraphDir + 'GetF' + IconExt);
	BitmapLoadFromFile(ImageGetC.Picture.Bitmap, GraphDir + 'GetC' + IconExt);
	BitmapLoadFromFile(ImageIn8.Picture.Bitmap, GraphDir + 'In8' + IconExt);
	BitmapLoadFromFile(ImageOut8.Picture.Bitmap, GraphDir + 'Out8' + IconExt);
	Gener(False);
	SetCom(ComboBoxComAddr.ItemIndex);
end;

end.
