// * File:     ResistorDivider\uMain.pas
// * Created:  1999-10-01
// * Modified: 2010-09-01
// * Version:  1.0.47.20
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	SysUtils, Classes, Controls, Forms,
	StdCtrls, ExtCtrls, ComCtrls, uDButton, uDForm, uDEdit, Menus,
	uDImage, uDWinControl;

type
	TfMain = class(TDForm)
		ButtonCalc: TDButton;
		EditU1: TDEdit;
		EditU2: TDEdit;
		EditRI: TDEdit;
		PanelGood: TDEdit;
		Bevel1: TBevel;
		Bevel2: TBevel;
		PanelRA1: TDEdit;
		PanelRA2: TDEdit;
		PanelRB1: TDEdit;
		PanelRB2: TDEdit;
		PanelComb: TDEdit;
		PanelDelta0: TDEdit;
		PanelDelta1: TDEdit;
		PanelPA10: TDEdit;
		PanelPA20: TDEdit;
		PanelPB10: TDEdit;
		PanelPB20: TDEdit;
		EditPMax: TDEdit;
		EditDeltaMax: TDEdit;
		Label1: TLabel;
		Label2: TLabel;
		Label3: TLabel;
		Label4: TLabel;
		Label5: TLabel;
		Label6: TLabel;
		Label7: TLabel;
		Label8: TLabel;
		Label9: TLabel;
		Label10: TLabel;
		Label11: TLabel;
		Label12: TLabel;
		Label13: TLabel;
		Label14: TLabel;
		Label15: TLabel;
		Label16: TLabel;
		Label17: TLabel;
		Label18: TLabel;
		Label19: TLabel;
		Label20: TLabel;
		Label21: TLabel;
		Label22: TLabel;
		Label23: TLabel;
		Label24: TLabel;
		Label25: TLabel;
		Label26: TLabel;
		Label27: TLabel;
		Label28: TLabel;
		Label29: TLabel;
		Label30: TLabel;
		Label31: TLabel;
		Label32: TLabel;
		Label33: TLabel;
		Label34: TLabel;
		Label35: TLabel;
		Label36: TLabel;
		Bevel3: TBevel;
		Bevel4: TBevel;
		Label37: TLabel;
		Label38: TLabel;
		Label39: TLabel;
		Label40: TLabel;
		Label41: TLabel;
		Label42: TLabel;
		Label43: TLabel;
		Label44: TLabel;
		Label45: TLabel;
		Label46: TLabel;
		StatusBar1: TStatusBar;
		Label47: TLabel;
		Bevel5: TBevel;
		Label48: TLabel;
		Label49: TLabel;
		Label50: TLabel;
		Label51: TLabel;
		Label52: TLabel;
		Label53: TLabel;
		Label54: TLabel;
		Label55: TLabel;
		Label56: TLabel;
		Label57: TLabel;
		Label58: TLabel;
		Label59: TLabel;
		PanelPA11: TDEdit;
		PanelPA21: TDEdit;
		PanelPB11: TDEdit;
		PanelPB21: TDEdit;
		Label60: TLabel;
		Label61: TLabel;
		ButtonPMax1: TDButton;
		MainMenu1: TMainMenu;
		File1: TMenuItem;
		Options1: TMenuItem;
		Help1: TMenuItem;
		ImageCircuitry: TDImage;
		procedure ButtonCalcClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
	private
		{ Private declarations }
		procedure RWOptions(const Save: Boolean);
	public
		{ Public declarations }
	end;

var
	fMain: TfMain;

implementation

{$R *.DFM}
uses
	uFiles, uDIniFile, uWave, uInputFormat, uSystem, uMsg, uOutputFormat, uDictionary, uDBitmap,
	Math;

procedure TfMain.ButtonCalcClick(Sender: TObject);
label LNext;
const
	MaxRLine = 23;
	RLine: array[0..MaxRLine] of Integer = (
		100, 120, 150, 180, 220, 270, 330, 390, 470, 560, 680, 820,
		1000, 1200, 1500, 1800, 2200, 2700, 3300, 3900, 4700, 5600, 6800, 8200);
	MaxFlo = 1000000;
type
	TFlo = Extended;
	TComb = (coSS, coSP, coPS, coPP);
var
	RA, RB: TFlo;
	U1, U2, UA, U2N, RI, RBI, ID: TFlo;
	PMax: TFlo;
	DeltaMax: TFlo;

	Comb: TComb;
	RA1, RA2, RB1, RB2: Integer;
	PRA1, PRA2, PRB1, PRB2: array[0..1] of TFlo;
	Delta: array[0..1] of TFlo;

	BestComb: TComb;
	BestRA1, BestRA2, BestRB1, BestRB2: Integer;
	BestPRA1, BestPRA2, BestPRB1, BestPRB2: array[0..1] of TFlo;
	BestDelta: array[0..1] of TFlo;

	GoodCount: Integer;

	i: Integer;
	s: string;
	PMax1: Integer;
begin
	U1 := StrToValE(EditU1.Text, True, 0, 24, MaxFlo);
	U2N := StrToValE(EditU2.Text, True, 0, 18, MaxFlo);
	RI := StrToValE(EditRI.Text, True, 0, 40000, MaxFlo);
	PMax := StrToValE(EditPMax.Text, True, 0, 0.125, MaxFlo);
	DeltaMax := StrToValE(EditDeltaMax.Text, True, 0, 1, MaxFlo);
	if U2N = 0 then
	begin
		Warning('U2 can''t be 0.');
		Exit;
	end;
	BeginLongOperation;
	StatusBar1.SimpleText := Translate('Wait') + cDialogSuffix;
	StatusBar1.Update;
	try
		if ButtonPMax1.Down = False then PMax1 := 0 else PMax1 := 1;
		GoodCount := 0;
		BestComb := coSS;
		BestRA1 := 0;
		BestRA2 := 0;
		BestRB1 := 0;
		BestRB2 := 0;
		BestDelta[0] := MaxInt;
		BestDelta[1] := MaxInt;

		for Comb := coSS to coPP do
			for RA1 := 0 to MaxRLine do
				for RA2 := RA1 to MaxRLine do
					for RB1 := 0 to MaxRLine do
						for RB2 := RB1 to MaxRLine do
						begin
							if (Comb = coSS) or (Comb = coSP) then
							begin
								RA := RLine[RA1] + RLine[RA2];
							end
							else
							begin
								RA := (RLine[RA1] * RLine[RA2]) / (RLine[RA1] + RLine[RA2]);
							end;

							if (Comb = coSS) or (Comb = coPS) then
							begin
								RB := RLine[RB1] + RLine[RB2];
							end
							else
							begin
								RB := (RLine[RB1] * RLine[RB2]) / (RLine[RB1] + RLine[RB2]);
							end;

							for i := 0 to 1 do
							begin
								if i = 0 then
								begin
									ID := U1 / (RA + RB);
									U2 := U1 * (RB / (RA + RB));
									UA := U1 - U2;
								end
								else
								begin
									RBI := (RB * Ri) / (RB + RI);
									ID := U1 / (RA + RBI);
									U2 := U1 * (RBI / (RA + RBI));
									UA := U1 - U2;
								end;
								Delta[i] := 100 * (U2 - U2N) / U2N;
								if Abs(Delta[i]) > DeltaMax then
								begin
									goto LNext;
								end;

								if (Comb = coSS) or (Comb = coSP) then
								begin
									PRA1[i] := RLine[RA1] * ID * ID;
									PRA2[i] := RLine[RA2] * ID * ID;
								end
								else
								begin
									PRA1[i] := UA * UA / RLine[RA1];
									PRA2[i] := UA * UA / RLine[RA2];
								end;

								if (Comb = coSS) or (Comb = coPS) then
								begin
									PRB1[i] := RLine[RB1] * ID * ID;
									PRB2[i] := RLine[RB2] * ID * ID;
								end
								else
								begin
									PRB1[i] := U2 * U2 * RLine[RB1];
									PRB2[i] := U2 * U2 * RLine[RB2];
								end;

								if (i xor PMax1) = 0 then
								begin
									if (PRA1[i] > PMax) or (PRA2[i] > PMax)
									or (PRB1[i] > PMax) or (PRB2[i] > PMax) then
									begin
										goto LNext;
									end;
								end;
							end;

							if Max(Abs(Delta[0]), Abs(Delta[1])) <
								Max(Abs(BestDelta[0]), Abs(BestDelta[1])) then
							begin
								BestDelta[0] := Delta[0];
								BestDelta[1] := Delta[1];
								BestComb := Comb;
								BestRA1 := RA1;
								BestRA2 := RA2;
								BestRB1 := RB1;
								BestRB2 := RB2;
								BestPRA1[0] := PRA1[0];
								BestPRA2[0] := PRA2[0];
								BestPRB1[0] := PRB1[0];
								BestPRB2[0] := PRB2[0];
								BestPRA1[1] := PRA1[1];
								BestPRA2[1] := PRA2[1];
								BestPRB1[1] := PRB1[1];
								BestPRB2[1] := PRB2[1];
							end;
							Inc(GoodCount);
							LNext:
						end;

		PanelGood.Text := IntToStr(GoodCount);
		if GoodCount > 0 then
		begin
			case BestComb of
			coSS: PanelComb.Text := 'S-S';
			coSP: PanelComb.Text := 'S-P';
			coPS: PanelComb.Text := 'P-S';
			coPP: PanelComb.Text := 'P-P';
			end;

			PanelRA1.Text := NToS(RLine[BestRA1]);
			PanelRA2.Text := NToS(RLine[BestRA2]);
			PanelRB1.Text := NToS(RLine[BestRB1]);
			PanelRB2.Text := NToS(RLine[BestRB2]);
			PanelRA2.Text := NToS(RLine[BestRA2]);
			PanelRB1.Text := NToS(RLine[BestRB1]);
			PanelRB2.Text := NToS(RLine[BestRB2]);

			PanelDelta0.Text := FToS(BestDelta[0]);
			PanelPA10.Text := FToS(BestPRA1[0]);
			PanelPA20.Text := FToS(BestPRA2[0]);
			PanelPB10.Text := FToS(BestPRB1[0]);
			PanelPB20.Text := FToS(BestPRB2[0]);
			PanelDelta1.Text := FToS(BestDelta[1]);
			PanelPA11.Text := FToS(BestPRA1[1]);
			PanelPA21.Text := FToS(BestPRA2[1]);
			PanelPB11.Text := FToS(BestPRB1[1]);
			PanelPB21.Text := FToS(BestPRB2[1]);
		end
		else
		begin
			PanelComb.Text := '';

			PanelRA1.Text := '';
			PanelRA2.Text := '';
			PanelRB1.Text := '';
			PanelRB2.Text := '';
			PanelRA2.Text := '';
			PanelRB1.Text := '';
			PanelRB2.Text := '';

			PanelDelta0.Text := '';
			PanelPA10.Text := '';
			PanelPA20.Text := '';
			PanelPB10.Text := '';
			PanelPB20.Text := '';
			PanelDelta1.Text := '';
			PanelPA11.Text := '';
			PanelPA21.Text := '';
			PanelPB11.Text := '';
			PanelPB21.Text := '';
		end;
	finally
		EndLongOperation;
		StatusBar1.SimpleText := Translate('Ready');
		PlayWinSound(wsAsterisk);
	end;
end;

procedure TfMain.RWOptions(const Save: Boolean);
begin
	MainIni.RWFormPos(Self, Save);
	EditU1.Text := MainIni.RWStringF('Options', 'U1', EditU1.Text, EditU1.Text, Save);
	EditU2.Text := MainIni.RWStringF('Options', 'U2', EditU2.Text, EditU2.Text, Save);
	EditRI.Text := MainIni.RWStringF('Options', 'RI', EditRI.Text, EditRI.Text, Save);
	EditDeltaMax.Text := MainIni.RWStringF('Options', 'DeltaMax', EditDeltaMax.Text, EditDeltaMax.Text, Save);
	EditPMax.Text := MainIni.RWStringF('Options', 'PMax', EditPMax.Text, EditPMax.Text, Save);
	ButtonPMax1.Down := MainIni.RWBGF('Options', 'PMax1', ButtonPMax1.Down, ButtonPMax1.Down, Save);
//	ImageCircuitry.Serialize(MainIni, Save);
end;

procedure TfMain.FormCreate(Sender: TObject);
begin
	Background := baGradient;
	RWOptions(False);
	ImageCircuitry.EnableZoom := True;
	ImageCircuitry.UserBitmap := TDBitmap.Create;
	ImageCircuitry.UserBitmap.LoadFromFile(GraphDir + 'Circuitry.png');
	ImageCircuitry.UserArea := ImageCircuitry.UserBitmap.GetFullRect;
	ImageCircuitry.DisplayMode := dmFitImage;
//	ImageCircuitry.UserBitmapChanged;
end;

procedure TfMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	RWOptions(True);
end;

end.

