// * File:     QA\uWords.pas
// * Created:  2007-05-27
// * Modified: 2009-09-02
// * Version:  1.0.47.32
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uWords;

interface

uses uTypes;

procedure CreateWords;
procedure FreeWords;

var
	QA: array[0..1] of array of string;
	QACount: array[0..1] of SG;

implementation

uses SysUtils, uFile, uFiles, uMath, uMsg;

procedure CreateWords;
const
	Nam: array[0..1] of string = ('Question', 'Answer');
var
	F: TFile;
	i, j: SG;
	NewSize: SG;
	Line: string;
begin
	try
		for i := 0 to 1 do
		begin
			SetLength(QA[i], 0); QACount[i] := 0;
		end;

		for i := 0 to 1 do
		begin
			for j := Low(QA) to High(QA) do
			begin
				F := TFile.Create;
				try
					if F.Open(DataDir + Nam[j] + IntToStr(i) + '.txt', fmReadOnly) then
					begin
						while not F.Eof do
						begin
							NewSize := QACount[j] + 1;
							if AllocByExp(Length(QA[j]), NewSize) then
								SetLength(QA[j], NewSize);
							F.Readln(Line);
							QA[j][QACount[j]] := Line;
							Inc(QACount[j]);
						end;
						F.Close;
					end;
				finally
					F.Free;
				end;
			end;
		end;
	except
		on E: Exception do
			Fatal(E, nil);
	end;
end;

procedure FreeWords;
var i: SG;
begin
	try
		for i := Low(QA) to High(QA) do
		begin
			SetLength(QA[i], 0); QACount[i] := 0;
		end;
	except
		on E: Exception do
			Fatal(E, nil);
	end;
end;

end.
