// * File:     QA\uMain.pas
// * Created:  2003-03-02
// * Modified: 2009-12-08
// * Version:  1.0.47.32
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, uDButton, ExtCtrls, uDForm, uDEdit, Menus;

type
	TfMain = class(TDForm)
		EditQuestion: TDEdit;
		EditAnswer: TDEdit;
		ButtonGenerate: TDButton;
		MainMenu1: TMainMenu;
		File1: TMenuItem;
		Options1: TMenuItem;
		Help1: TMenuItem;
		procedure ButtonGenerateClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormResize(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	fMain: TfMain;

implementation

{$R *.DFM}

uses uTypes, uFiles, uMath, uStrings, uMsg, uOutputFormat, uWords, uDictionary;

function Fin(const s: string): BG;
begin
	Result := False;
	if Length(s) > 0 then
	begin
		Result := CharInSet(LastChar(s), ['!', '?', '.']);
	end;
end;

procedure TfMain.ButtonGenerateClick(Sender: TObject);
var
	Q, A: SG;
	s: string;
begin
	if (QACount[0] > 0) and (QACount[1] > 0) then
	begin
		Q := Random(QACount[0]);
		A := Random(QACount[1]);
		Caption := Translate('Question') + CharSpace + NToS(Q + 1) + '/' + NToS(QACount[0])
			+ ' ->' + Translate(' Answer') + CharSpace + NToS(A + 1) + '/' + NToS(QACount[1]);
		s := QA[0][Q];
		if Fin(s) = False then
			s := s + '?';
		EditQuestion.Text := s;
		s := QA[1][A];
		if Fin(s) = False then
			s := s + '.';
		EditAnswer.Text := s
	end;
end;

procedure TfMain.FormCreate(Sender: TObject);
begin
	Background := baGradient;
end;

procedure TfMain.FormResize(Sender: TObject);
begin
	EditQuestion.Width := ClientWidth - 2 * EditQuestion.Left;
	EditAnswer.Width := ClientWidth - 2 * EditAnswer.Left;
	ButtonGenerate.Left := ClientWidth - ButtonGenerate.Width - FormBorder;
end;

end.
