// * File:     PCap\uMain.pas
// * Created:  2005-04-17
// * Modified: 2009-12-08
// * Version:  1.0.47.24
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	uDForm, uTypes,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, WPCap, uDButton, ExtCtrls, uDImage, uDView, Menus, Dialogs,
	uDWinControl, uDMemo;

type
	TfMain = class(TDForm)
		OpenDialog1: TOpenDialog;
		Memo: TDMemo;
		ButtonOpen: TDButton;
		EditFrameCount: TLabeledEdit;
		DView: TDView;
		MainMenu1: TMainMenu;
		File1: TMenuItem;
		Open1: TMenuItem;
		Close1: TMenuItem;
		Help1: TMenuItem;
		LabelFTPCount: TLabeledEdit;
		LabelFTPSize: TLabeledEdit;
		Analyse1: TMenuItem;
		ButtonAnalyse: TDButton;
		ButtonUpload: TDButton;
		DViewDevices: TDView;
		ButtonAbort: TDButton;
		EditFileName: TLabeledEdit;
		EditLocalIP: TLabeledEdit;
		Label1: TLabel;
		EditRemoteIP: TLabeledEdit;
		EditLocalMAC: TLabeledEdit;
		Network1: TMenuItem;
		ReloadDevices1: TMenuItem;
		ButtonDownload: TDButton;
		Bevel1: TBevel;
		FTP1: TMenuItem;
		Download1: TMenuItem;
		Upload1: TMenuItem;
		Abort1: TMenuItem;
		Label2: TLabel;
		EditInter: TLabeledEdit;
		Options1: TMenuItem;
		procedure ButtonOpenClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormResize(Sender: TObject);
		procedure DViewGetData(Sender: TObject; var Data: String; ColIndex,
			RowIndex: Integer; Rect: TRect);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure Open1Click(Sender: TObject);
		procedure Close1Click(Sender: TObject);
		procedure Analyse1Click(Sender: TObject);
		procedure ButtonAnalyseClick(Sender: TObject);
		procedure ButtonUDClick(Sender: TObject);
		procedure ButtonAbortClick(Sender: TObject);
		procedure ReloadDevices1Click(Sender: TObject);
		procedure DViewDevicesGetData(Sender: TObject; var Data: String;
			ColIndex, RowIndex: Integer; Rect: TRect);
		procedure DViewDevicesMouseDown(Sender: TObject; Button: TMouseButton;
			Shift: TShiftState; X, Y: Integer);
	private
		{ Private declarations }
		Stop: BG;
		procedure RWOptions(const Save: BG);
		procedure AddError(const s: string);
		procedure ChangeAdapter;
	public
		{ Public declarations }
	end;

var
	fMain: TfMain;

implementation

{ Should use pcap_loop }

{$R *.DFM}
uses
	uNet,
	Winsock, {JclSysInfo,} Math,
	uFiles, uAbout, uDIniFile, uMenus, uStrings, uDParser, uInputFormat, uOutputFormat, uMath;

var
	FileNameIn: TFileName;

var
	FrameCount: SG;
	Frames: array of packed record
		Head: pcap_pkthdr;
		Data: PArrayU1;
	end;

// Devices
type
	TDevice = record
		Name: string;
		Description: string;
		Addr: TIPAdress;
		NetMask: TIPAdress;
		BroadAddr: TIPAdress;

		MAC: TMACAdress;
	end;
var
	Devices: array of TDevice;
	DeviceCount, DeviceIndex: SG;

const
	DataBlockSize = 512;

procedure TfMain.AddError(const s: string);
begin
//	Memo.Text := Memo.Text + FullSep + s;
	Memo.Lines.Add(s)
end;

procedure TfMain.ButtonOpenClick(Sender: TObject);
begin
	Open1.Click;
end;

procedure TfMain.FormResize(Sender: TObject);
begin
	Memo.Width := ClientWidth - 2 * Memo.Left;
	DView.Width := Memo.Width;
	DViewDevices.Width := Memo.Width;
	Bevel1.Width := Memo.Width;
end;

procedure TfMain.DViewGetData(Sender: TObject; var Data: String; ColIndex,
	RowIndex: Integer; Rect: TRect);
begin
	case ColIndex of
	0: Data := NToS(RowIndex + 1);
	1:
	begin
		if Frames[RowIndex].Head.caplen = Frames[RowIndex].Head.len then
			Data := NToS(Frames[RowIndex].Head.caplen)
		else
			Data := NToS(Frames[RowIndex].Head.caplen) + ' / ' + NToS(Frames[RowIndex].Head.len)
	end;
	2:
	begin
{		Data := NToS(Frames[RowIndex].Head.ts.tv_sec) + '.' +
			NToS(Frames[RowIndex].Head.ts.tv_usec);}
		Data := DateTimeToS(UnixDateDelta + Frames[RowIndex].Head.ts.tv_sec / SecsPerDay, 0, ofDisplay)
		//MsToStr(U8(Frames[RowIndex].Head.ts.tv_sec) * 1000, diHMSD, 0, False)
			+ '.' + NToS(Frames[RowIndex].Head.ts.tv_usec, '000000');
	end;
	3: Data := MACToStr(PEthernetProtocol(Frames[RowIndex].Data).Destination);
	4: Data := MACToStr(PEthernetProtocol(Frames[RowIndex].Data).Source);
	5: Data := EthernetTypeToStr(Swap(PEthernetProtocol(Frames[RowIndex].Data).Typ));
	6: Data := ByteArrayToString(Frames[RowIndex].Data, Frames[RowIndex].Head.caplen);
	7: Data := ByteArrayToHexaStr(Frames[RowIndex].Data, Frames[RowIndex].Head.caplen);
	end;
end;

procedure TfMain.RWOptions(const Save: BG);
var Section: string;
begin
	MainIni.RWFormPos(Self, Save);
	DView.Serialize(MainIni, Save);
	DViewDevices.Serialize(MainIni, Save);
	Section := 'Options';
	MainIni.RWFileName(Section, 'FileNameIn', FileNameIn, Save);
	MainIni.RWNum(Section, 'DeviceIndex', DeviceIndex, Save);
	MainIni.RWEdit(Section, TEdit(EditRemoteIP), Save);
	MainIni.RWEdit(Section, TEdit(EditFileName), Save);
end;

procedure TfMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	RWOptions(True);
end;

procedure TfMain.Open1Click(Sender: TObject);
var
	CapId: ppcap_t;
	ErrBuf: array [0 .. PCAP_ERRBUF_SIZE - 1] of Char;
	i: SG;
	pkt_header: ppcap_pkthdr;
	pkt_data: ppchar;

	NewSize: SG;
begin
	if ExecuteDialog(OpenDialog1, FileNameIn) then
	begin
		Close1.Click;
		CapId := pcap_open(PChar('file://' + FileNameIn), 65536, PCAP_OPENFLAG_PROMISCUOUS, 100, nil, ErrBuf);
		if CapId = nil then
		begin
			AddError(ErrBuf);
			Exit;
		end;
		while True do
		begin
			pkt_header := nil;
			pkt_data := nil;
			i := pcap_next_ex(CapId, ppcap_pkthdr(@pkt_header), ppchar(@pkt_data));
			if i <> 1 then break;
			if pkt_header.caplen <> pkt_header.len then
				AddError('Bad frame length')
			else
			begin
				// Add Frame
				NewSize := FrameCount + 1;
				if AllocByExp(Length(Frames), NewSize) then
					SetLength(Frames, NewSize);
				Frames[FrameCount].Head := pkt_header^;
				GetMem(Frames[FrameCount].Data, pkt_header.caplen);
				Move(PArrayU1(pkt_data)^, Frames[FrameCount].Data^, pkt_header.caplen);
				Inc(FrameCount);
			end;
		end;
		pcap_close(CapId); // CapId := nil;

		// Display
		EditFrameCount.Text := NToS(FrameCount);
//		Memo.Lines.Add(ByteArrayToHexaStr(Frames[0].Data, Frames[0].Head.caplen));
		DView.RowCount := FrameCount;
	end;
end;

procedure LoadDevices;
var
	MACs: TStrings;
	ErrBuf: array [0 .. PCAP_ERRBUF_SIZE - 1] of Char;
	gif_t: ppcap_if_t;
	i, NewSize: SG;
	alldevs: ppcap_if_t;
begin
	MACs := TStringList.Create;
	//My MACs from NetBIOS & SNMP
//	JCLSysInfo.GetMacAddresses('', MACs); TODO

	// Get Devices form PCap
	SetLength(Devices, 0);
	DeviceCount := 0;

	alldevs := nil;
	i := pcap_findalldevs(@alldevs, ErrBuf);
	if (i = 0) then
	begin
		gif_t := alldevs;
		while gif_t <> nil do
		begin
			NewSize := DeviceCount + 1;
			if AllocByExp(Length(Devices), NewSize) then
				SetLength(Devices, NewSize);
//			gif_t.address.dstaddr.sin_addr.S_un_b;
			Devices[DeviceCount].Name := gif_t.name;
			Devices[DeviceCount].Description := gif_t.description;
			if gif_t.address <> nil then
			begin
				if gif_t.address^.addr <> nil then
					Devices[DeviceCount].Addr.L := U4(gif_t.address^.addr^.sin_addr.S_addr);
				if gif_t.address^.netmask <> nil then
					Devices[DeviceCount].NetMask.L := U4(gif_t.address^.netmask^.sin_addr.S_addr);
				if gif_t.address^.broadaddr <> nil then
					Devices[DeviceCount].BroadAddr.L := U4(gif_t.address^.broadaddr^.sin_addr.S_addr);
			end;
			if DeviceCount < MACs.Count then
				Devices[DeviceCount].MAC := StrToMAC(MACs[DeviceCount]);
			Inc(DeviceCount);
			gif_t := gif_t.next;
		end;
	end
	else
	begin
//		AddError('Error reading devices: ' + ErrBuf);
	end;
	pcap_freealldevs(alldevs);
	if DeviceIndex >= DeviceCount then DeviceIndex := DeviceCount - 1;
	FreeAndNil(MACs);
end;

procedure TfMain.ChangeAdapter;
begin
	if DeviceCount > 0 then
	begin
		EditLocalMAC.Text := MACToStr(Devices[DeviceIndex].MAC);
		EditLocalIP.Text := IPToStr(Devices[DeviceIndex].Addr);
	end;
	DViewDevices.RowCount := DeviceCount;
	DViewDevices.ActualRow := DeviceIndex;
end;

procedure TfMain.FormCreate(Sender: TObject);
begin
	Background := baGradient;

	OpenDialog1.Filter := AllText;
	OpenDialog1.FilterIndex := 2;
	OpenDialog1.FileName := AppDataDir + '*.cap';
	DView.AddColumn('#');
	DView.AddColumn('Size');
	DView.AddColumn('Time');
	DView.AddColumn('Destination MAC');
	DView.AddColumn('Source MAC');
	DView.AddColumn('Type');
	DView.AddColumn('Binary Data');
	DView.AddColumn('Haxadecimal Data');

	DView.AddColumn('Name');
	DView.AddColumn('Description');
	DView.AddColumn('MAC');
	DView.AddColumn('Addr');
	DView.AddColumn('NetMask');
	DView.AddColumn('BroadAddr');

	RWOptions(False);

	LoadDevices;
	ChangeAdapter;
end;

procedure TfMain.Close1Click(Sender: TObject);
begin
	SetLength(Frames, 0);
	FrameCount := 0;
	EditFrameCount.Text := '';
	LabelFTPCount.Text := '';
	LabelFTPSize.Text := '';
	DView.RowCount := FrameCount;
end;

procedure TfMain.Analyse1Click(Sender: TObject);
var
	// Local
	i, DataIndex: SG;
	FileNameOut: TFileName;
	Output: string;

	// Stats
	SumSize, SumCount: UG;

	// Protocols
	Ethernet: PEthernetProtocol;
	IP: PIPProtocol;
	TCP: PTCPProtocol;
	FTP: string;
	StartIP: TIPAdress;

begin
	// Analysis
	StartIP.L := 0;
	if FrameCount > 0 then
	begin
		Output := '';

		SumSize := 0;
		SumCount := 0;
		for i := 0 to FrameCount - 1 do
		begin
			DataIndex := 0;
			Ethernet := PEthernetProtocol(@Frames[i].Data[DataIndex]);
			Inc(DataIndex, SizeOf(TEthernetProtocol));

			if Ethernet.Typ = Swap(U2(etIP)) then
			begin
				IP := PIPProtocol(@Frames[i].Data[DataIndex]);
				Inc(DataIndex, (IP.VersionHeaderLength and $7) shl 2);
				if IP.Protocol = 6 then
				begin
					if Frames[i].Head.caplen > DataIndex then
					begin
						TCP := PTCPProtocol(@Frames[i].Data[DataIndex]);
						Inc(DataIndex, TCP.HeaderLength shr 2);

						if Frames[i].Head.caplen > DataIndex then
						begin
							if Frames[i].Data[DataIndex] = 0 then
								Inc(DataIndex, 6)
								// Trailer
							else
							begin
								if StartIP.L = 0 then StartIP.L := IP.Source.L;
								if IP.Source.L <> StartIP.L then
								begin
									Output := Output + '<-- ';
								end
								else
								begin
									Output := Output + '--> ';
								end;
								SetLength(FTP, Frames[i].Head.caplen - DataIndex);
								//FTP := @Frames[i].Data[DataIndex];
								Move(Frames[i].Data[DataIndex], FTP[1], Frames[i].Head.caplen - DataIndex);
								Inc(DataIndex, Length(FTP));
								Output := Output + FTP + FileSep;
								Inc(SumSize, Frames[i].Head.len);
								Inc(SumCount);
							end;
						end;
					end;
				end;

			end;
			if DataIndex > Frames[i].Head.caplen then
				AddError('Packet too short');
		end;
		LabelFTPCount.Text := NToS(SumCount);
		if SumCount <= 0 then
			LabelFTPSize.Text := ''
		else
			LabelFTPSize.Text := NToS(RoundDivU8(1000 * SumSize, SumCount), 3);

		FileNameOut := DelFileExt(FileNameIn) + '.txt';
		WriteStringToFile(FileNameOut, Output, False);
	end;
end;

procedure TfMain.ButtonAnalyseClick(Sender: TObject);
begin
	Analyse1.Click;
end;

procedure TfMain.ButtonUDClick(Sender: TObject);
label LFin;
const
	MaxRetry = 10;
	Timeout = 10000; // ms
var
	CapId: ppcap_t;
	i:integer;
	Identification: SG;

	pkt_header: ppcap_pkthdr;
	pkt_data: ppchar;
	ErrBuf: array [0 .. PCAP_ERRBUF_SIZE - 1] of Char;

	NewSize: SG;
	RemoteIP: TIPAdress;
	RemoteMAC: TMACAdress;
	LocalPort, RemotePort: U2;

	ServerFileName: TFileName;
	LocalFileName: TFileName;
	LocalIndex, AckIndex: SG;
	Upload: BG;
	FileData: string;
	FileDataCount: SG;

	SendTime: U4;
	RetryCount: SG;

	// Send
	SendData: PChar;
	TotalLength: SG;

	procedure SendPacket;
//	var s: PChar;
	begin
		if CapId = nil then Exit;

		i := pcap_sendpacket(CapId, SendData, TotalLength);
		if i <> 0 then
		begin
//			s := pcap_geterr(CapId);
			AddError('Error sending packet');
		end;
		SendTime := GetTickCount;
	end;

	procedure CreateARPPacket;
	var
		// Protocols
		F: TARPFrame;
	begin
		TotalLength := 0;
		FillChar(F, SizeOf(F), 0);
		F.Destination.L0 := $ffff;
		F.Destination.L1 := $ffffffff; // Broadcast}
		F.Source := Devices[DeviceIndex].MAC;
		F.Typ := Swap(U2(etARP));
		F.hw_type := Swap($0001); //HardwareType: Ethernet
		F.prot_type := Swap($0800); //ProtocolType: IP
		F.hw_addr_size := $06; //HW Size: 6 = MAC Size
		F.prot_addr_size := $04; //Prot Size: 4 = IP Size
		F.op := Swap($0001); //OpCode: request (00 01)  Reply (00 02)
		F.Src_a_hw := Devices[DeviceIndex].MAC;
		F.Src_a_ip := Devices[DeviceIndex].Addr;
		F.Dst_a_hw.L0 := $0000;
		F.Dst_a_hw.L1 := $00000000;
		F.Dst_a_ip := RemoteIP;

		Inc(TotalLength, SizeOf(TARPFrame));

		Move(F, SendData^, TotalLength);
		AddError('Sending ARP packet');
		Inc(Identification); Identification := Identification and $ffff;
	end;

	procedure CreatePacket(OpCode: U2; BlockId: U2; FileNameOrData: string);
	var
		DataCount: SG;

		// Protocols
		F: TFTPFrame;
		P: PU2;
	begin
		TotalLength := 0;

		F.FTP.OpCode := Swap(OpCode);
		Inc(TotalLength, 2);
		{
			$01 Read Request, File, TransferType
			$02 Write Request File, TransferType
			$03 Data Packet, Block (Last)
			$04 Acknowledgement Block,
			$05 ErrorCode
					$01 File not found
					$02 Access violation
					$03 Disk full or allocation exceeded
					$04 Illegal TFTP operation
					$05 Unknown transfer ID
					$06 File already exists
					$07 No such user
					$08 Option negotiation failed
			$06 Option Acknowledgement
		}
		case OpCode of
		$01, $02:
		begin
			P := @F.FTP.FrameId;
			DataCount := Min(DataBlockSize, Length(FileNameOrData));
			Inc(TotalLength, DataCount + 1);
			if DataCount > 0 then
				Move(FileNameOrData[1], P^, DataCount + 1);
			Inc(SG(P), DataCount + 1);
			P^ := Ord('o');
			Inc(SG(P), 1);
			P^ := Ord('c');
			Inc(SG(P), 1);
			P^ := Ord('t');
			Inc(SG(P), 1);
			P^ := Ord('e');
			Inc(SG(P), 1);
			P^ := Ord('t');
			Inc(SG(P), 1);
			P^ := 0;
			Inc(TotalLength, 6);
			// Option
		end;
		$03:
		begin
			F.FTP.FrameId := Swap(BlockId);
			Inc(TotalLength, 2);
			DataCount := Min(DataBlockSize, Length(FileNameOrData));
			Inc(TotalLength, DataCount);
			if DataCount > 0 then
				Move(FileNameOrData[1], F.FTP.Data, DataCount);
		end;
		$04:
		begin
			F.FTP.FrameId := Swap(BlockId);
			Inc(TotalLength, 2);
		end;
		end;

		F.UDP.SrcPort := Swap(LocalPort);
		F.UDP.DstPort := Swap(RemotePort);
		Inc(TotalLength, SizeOf(TUDPProtocol));
		F.UDP.UDPLength := Swap(TotalLength);
		F.UDP.Checksum := 0;

		F.IP.VersionHeaderLength := $45;
		F.IP.DifferentiatedServicesField := $00;
		F.IP.Identification := Swap(Identification);
		F.IP.FlagsFragmentOffset := $40;
		F.IP.TimeToLive := $80;
		F.IP.Protocol := $11;
		F.IP.Source := Devices[DeviceIndex].Addr;
		F.IP.Destination := RemoteIP;
		Inc(TotalLength, SizeOf(TIPProtocol));
		F.IP.TotalLength := Swap(TotalLength);
		F.IP.TimeToLive := 0;
		F.IP.Protocol := $11;
		F.IP.Checksum := Swap(TotalLength - SizeOf(TIPProtocol));
		F.UDP.Checksum := Swap(PacketChecksum(PU1(@F.IP.TimeToLive), TotalLength - SizeOf(TIPProtocol) + 12));
		F.IP.TimeToLive := $80;
		F.IP.Protocol := $11;
		F.IP.Checksum := 0;
		F.IP.Checksum := Swap(PacketChecksum(PU1(@F.IP) , SizeOf(TIPProtocol)));



{		F.Ethernet.Destination.L0 := $ffff;
		F.Ethernet.Destination.L1 := $ffffffff; // Broadcast}
{		F.Ethernet.Destination.L0 := Swap($000D);
		F.Ethernet.Destination.L1 := SwapU4($EDA1BB43);}
		F.Ethernet.Destination := RemoteMAC;
//		E.Destination := Devices[DeviceIndex].MAC; // sam sobe
		F.Ethernet.Source := Devices[DeviceIndex].MAC;
		F.Ethernet.Typ := Swap(U2(etIP));
		Inc(TotalLength, SizeOf(TEthernetProtocol));

		Move(F, SendData^, TotalLength);
		AddError('Sending packet OpCode=' + NToS(Swap(F.FTP.OpCode)) + ', ' + NToS(Swap(F.FTP.FrameId)));
		Inc(Identification); Identification := Identification and $ffff;
	end;

	procedure ResendLast;
	begin
		SendPacket;
	end;


var
	PFrame: Pointer;
	DataLength: SG;
begin
	DeviceIndex := DViewDevices.ActualRow;
	if DeviceCount <= 0 then Exit;

	ButtonDownload.Enabled := False;
	ButtonUpload.Enabled := False;

	RemoteIP := StrToIP(EditRemoteIP.Text);
	ServerFileName := EditFileName.Text;
	LocalFileName := WorkDir + 'Root' + PathDelim + ExtractFileName(ServerFileName);
	Upload := TComponent(Sender).Tag = 0;
	if Upload then
	begin
		FileData := ReadStringFromFile(LocalFileName);
		FileDataCount := Length(FileData);
		AckIndex := 0;
	end
	else
	begin
		FileDataCount := 0;
		AckIndex := 1;
	end;
	LocalIndex := 0;

	RetryCount := 0;

	Stop := False;
	ButtonAbort.Enabled := True;

	try
	GetMem(SendData, {14 + 8 + 4 +} 2 * DataBlockSize); // MaxPacketSize
	CapId := pcap_open(PChar('rpcap://' + Devices[DeviceIndex].Name), 65536, PCAP_OPENFLAG_PROMISCUOUS, 100, nil, ErrBuf);

	if CapId = nil then
	begin
		AddError(ErrBuf);
		Exit;
	end;

	// Begin connection
	Identification := Random(65536);
	LocalPort := 1024 + Random(65536 - 1024);
	RemotePort := 69;
	RemoteMAC := StrToMAC(EditInter.Text); // Default solution if ARP fails

	CreateARPPacket;
	SendPacket;
	while Stop = False do
	begin
		i := 1;
		while i = 1 do // while any packet to read
		begin
			pkt_header := nil;
			pkt_data := nil;
			i := pcap_next_ex(CapId, ppcap_pkthdr(@pkt_header), ppchar(@pkt_data));
			if i <> 1 then
			begin
				// Cannot read packet
				if i <> 0 then
				begin
					AddError('Error reading packet');
				end;
				Break;
			end;

			if pkt_header.caplen <> pkt_header.len then
			begin
				AddError('Bad frame length')
			end
			else
			begin
				PFrame := pkt_data;

				if (PEthernetProtocol(PFrame).Typ = Swap(U2(etARP))) and (PEthernetProtocol(PFrame).Destination.L1 = Devices[DeviceIndex].MAC.L1)
				and (PEthernetProtocol(PFrame).Destination.L0 = Devices[DeviceIndex].MAC.L0)then
				begin
//						RemoteMAC := PEthernetProtocol(PFrame).Source;
					if (PARPFrame(PFrame).op = Swap($0002)) and (PARPFrame(PFrame).prot_type = Swap($0800)) then
					begin
						RemoteMAC := PARPFrame(PFrame).Src_a_hw;
						EditInter.Text := MACToStr(RemoteMAC);
						AddError('Received ARP reply');
						goto LFin;
						//Inc(SG(PFrame), SizeOf(TEthernetProtocol));
					end;
				end;
			end;
		end;
		if Stop then Break;
		// Nothing to do
		if GetTickCount > SendTime + Timeout then
		begin
			// Timeout
			AddError('No ARP reply - Host not found');
			Break;
		end;

		Sleep(LoopSleepTime);
		Application.ProcessMessages;
	end;
	LFin:

	CreatePacket(1 + SG(Upload), 0, ServerFileName);
	SendPacket;

	while Stop = False do
	begin
		i := 1;
		while i = 1 do // while any packet to read
		begin
			pkt_header := nil;
			pkt_data := nil;
			i := pcap_next_ex(CapId, ppcap_pkthdr(@pkt_header), ppchar(@pkt_data));
			if i <> 1 then
			begin
				// Cannot read packet
				if i <> 0 then
				begin
					AddError('Error reading packet');
				end;
				Break;
			end;

			if pkt_header.caplen <> pkt_header.len then
				AddError('Bad frame length')
			else
			begin
				PFrame := pkt_data;

				if (PEthernetProtocol(PFrame).Typ = Swap(U2(etIP))) and (PEthernetProtocol(PFrame).Destination.L1 = Devices[DeviceIndex].MAC.L1)
				and (PEthernetProtocol(PFrame).Destination.L0 = Devices[DeviceIndex].MAC.L0)then
				begin
					Inc(SG(PFrame), SizeOf(TEthernetProtocol));
					if (PIPProtocol(PFrame).Protocol = $11) and (PIPProtocol(PFrame).Destination.L = Devices[DeviceIndex].Addr.L) then
					begin
						Inc(SG(PFrame), SizeOf(TIPProtocol));
						if PUDPProtocol(PFrame).DstPort = Swap(LocalPort) then
						begin
							// Frame form server

							// Add Frame
							NewSize := FrameCount + 1;
							if AllocByExp(Length(Frames), NewSize) then
								SetLength(Frames, NewSize);
							Frames[FrameCount].Head := pkt_header^;
							GetMem(Frames[FrameCount].Data, pkt_header.caplen);
							Move(PArrayU1(pkt_data)^, Frames[FrameCount].Data^, pkt_header.caplen);
							Inc(FrameCount);

							if RemotePort = 69 then
								RemotePort := Swap(PUDPProtocol(PFrame).SrcPort); // First reply

							RetryCount := 0;
							DataLength := Max(0, Swap(PUDPProtocol(PFrame).UDPLength) - 12);

							Inc(SG(PFrame), SizeOf(TUDPProtocol));

							PFTPProtocol(PFrame).OpCode := Swap(PFTPProtocol(PFrame).OpCode);

							AddError('Received packet OpCode=' + NToS(PFTPProtocol(PFrame).OpCode) + ', ' + NToS(Swap(PFTPProtocol(PFrame).FrameId)));
							case PFTPProtocol(PFrame).OpCode of
							3:
							begin
								if Upload = False then
								begin
									PFTPProtocol(PFrame).FrameId := Swap(PFTPProtocol(PFrame).FrameId);
									if PFTPProtocol(PFrame).FrameId > AckIndex then
									begin
										AddError('Future Frame Data');
									end
									else if PFTPProtocol(PFrame).FrameId < AckIndex then
									begin
										AddError('Duplicate Frame Data');
									end
									else
									begin // PFTPProtocol(PFrame).FrameId = AckIndex
										NewSize := DataBlockSize * LocalIndex + DataLength;
										FileDataCount := NewSize;
										if NewSize > Length(FileData) then
										begin
											if AllocByExp(Length(FileData), NewSize) then
												SetLength(FileData, NewSize);
										end;
										if DataLength > 0 then
											Move(PFTPProtocol(PFrame).Data, FileData[DataBlockSize * LocalIndex + 1], DataLength);
										Inc(LocalIndex);

										// Ok,.segment is there
										CreatePacket($04, AckIndex, '');
										Inc(AckIndex);
										SendPacket;
										if DataLength < DataBlockSize then
										begin
											// Last data
											SetLength(FileData, FileDataCount);
											WriteStringToFile(LocalFileName, FileData, False);
											Stop := True; // Server dont receive Last Ack packet?
											Break;
										end;
									end;
								end
								else
									AddError('Received TFTP Data packed when Upload');
							end;
							4:
							begin
								if Upload then
								begin
									PFTPProtocol(PFrame).FrameId := Swap(PFTPProtocol(PFrame).FrameId);
									if PFTPProtocol(PFrame).FrameId > AckIndex then
									begin
										AddError('Future Frame Acknowlegement');
									end
									else if PFTPProtocol(PFrame).FrameId < AckIndex then
									begin
										AddError('Duplicate Frame Acknowlegement');
									end
									else
									begin // PFTPProtocol(PFrame).FrameId = AckIndex
										if DataBlockSize * LocalIndex <= FileDataCount then
										begin
											// Segmet is on server, send next
											Inc(AckIndex);
											DataLength := Min(FileDataCount - DataBlockSize * LocalIndex, DataBlockSize);
											CreatePacket($03, AckIndex, Copy(FileData, DataBlockSize * LocalIndex + 1, DataLength));
											Inc(LocalIndex);
											SendPacket;
										end
										else
										begin
											// Last segment is on Server
											Stop := True;
											Break;
										end;
									end;
								end
								else
									AddError('Received TFTP Acknowledgement packed when Download');
							end;
							5: // Errors
							begin
								AddError('Error Received ' + NToS(Swap(PFTPProtocol(PFrame).FrameId)) + ' ' +
									PChar(@PFTPProtocol(PFrame).Data));
								Stop := True;
								Break;
							end;
							6:
							begin
								// Ok,.segment is there
								CreatePacket($04, AckIndex, '');
								Inc(AckIndex);
								SendPacket;
							end;
							else
								AddError('Bad TFTP Opcode');
							end;

						end;
					end;
				end;
			end;
		end;

		if Stop then Break;
		// Nothing to do
		if GetTickCount > SendTime + Timeout then
		begin
			// Timeout
			if RetryCount >= MaxRetry then
			begin
				AddError('Connection lost');
				Break; // Abort
			end;
			AddError('Resending packet');
			ResendLast;
			Inc(RetryCount);
		end;
		Sleep(LoopSleepTime);
		Application.ProcessMessages;
	end;
	finally
	ButtonAbort.Enabled := False;
	ButtonDownload.Enabled := True;
	ButtonUpload.Enabled := True;
	FreeMem(SendData); SendData := nil;
	pcap_close(CapId); CapId := nil;
	end;

		// Display
		EditFrameCount.Text := NToS(FrameCount);
//		Memo.Lines.Add(ByteArrayToHexaStr(Frames[0].Data, Frames[0].Head.caplen));
		DView.RowCount := FrameCount;
end;

procedure TfMain.ButtonAbortClick(Sender: TObject);
begin
	Stop := True;
end;

procedure TfMain.ReloadDevices1Click(Sender: TObject);
begin
	LoadDevices;
end;

procedure TfMain.DViewDevicesGetData(Sender: TObject; var Data: String;
	ColIndex, RowIndex: Integer; Rect: TRect);
var i: SG;
begin
	i := RowIndex;
	case ColIndex of
	0: Data := Devices[i].Name;
	1: Data := Devices[i].Description;
	2: Data := MACToStr(Devices[i].MAC);
	3: Data := IPToStr(Devices[i].Addr);
	4: Data := IPToStr(Devices[i].NetMask);
	5: Data := IPToStr(Devices[i].BroadAddr);
	end;
end;

procedure TfMain.DViewDevicesMouseDown(Sender: TObject;
	Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	ChangeAdapter;
end;

end.
