// * File:     MultiSaver\uStarsSaver.pas
// * Created:  2001-06-01
// * Modified: 2010-12-29
// * Version:  1.1.47.72
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uStarsSaver;

interface

uses
	uTypes, uColor,
	uSaver;

const
	stMax = 4096;
	StarsCount = 4096;
type
	TStarsSaver = class(TSaver)
	protected
		stX, stY: array[0..stMax - 1] of TFlo;
		stZ: array[0..stMax - 1] of TFlo;
		procedure CreateStar(const i: SG);
	public
		constructor Create; override;
		destructor Destroy; override;
		procedure Initialize; override;
		procedure Draw; override;
		procedure SetCamera; override;
		procedure Step; override;
	end;

implementation

uses
	OpenGL12,
	uMath;

{ TStarsSaver }

procedure TStarsSaver.CreateStar(const i: SG);
begin
	stX[i] := Random2(255);
	stY[i] := Random2(255);
	stZ[i] := 255 + Random(768);
end;

constructor TStarsSaver.Create;
begin
	inherited;
	Mode2D := True;
end;

destructor TStarsSaver.Destroy;
begin

	inherited;
end;

procedure TStarsSaver.Draw;
var
	s: Integer;
//	rx, ry: Integer;
//	NX, NY: SG;
	C: TRGBA;
	i: Integer;

	Len: TFlo;
begin
	inherited;
	glClear(GL_COLOR_BUFFER_BIT);
	glDisable(GL_LIGHTING);
	glDisable(GL_COLOR_MATERIAL);
	glDisable(GL_NORMALIZE);
	glDisable(GL_POINT_SMOOTH);
	C.A := 0;
	glLoadIdentity;
	for s := 0 to StarsCount - 1 do
	begin
{		rx := (8 * LongInt(stX[s]) div stZ[s]) + (NX shr 1);
		if (rx < 0) or (rx >= NX) then goto lab;

		ry := (8 * LongInt(stY[s]) div stZ[s]) + (NY shr 1);
		if (ry < 0) or (ry >= NY) then goto lab;

		stLX[s] := rx;
		stLY[s] := ry;}
		Len := UserLen(stX[s], stY[s], stZ[s]);

{		if fMain.Lights1.Checked then
			i := Round(384 - Len)
		else}
			i := Round(255 + 64 - Len);
		if i > 255 then
			i := 255
		else if i < 0 then i := 0;
		C.R := i;
		C.G := i;
		C.B := i;
		if Len > 20 then
			glPointSize(1)
		else
			glPointSize(2);

		if i > 0 then
		begin
			glColor3ubv(@C.R);
			glBegin(GL_POINTS);
			glVertex3f(stX[s], stY[s], -stZ[s]);
			glEnd;
		end;
	end;
	glEnable(GL_NORMALIZE);
	glEnable(GL_POINT_SMOOTH);
end;

procedure TStarsSaver.Step;
var i: SG;
begin
	inherited;
	for i := 0 to StarsCount - 1 do
	begin
		if stZ[i] > -255 then
		begin
			stZ[i] := stZ[i] - 100 * ElapsedTime / PerformanceFrequency;
		end
		else
		begin
			CreateStar(i);
		end;
	end;
end;

procedure TStarsSaver.SetCamera;
begin
	inherited;
	UserX := 0;
	UserY := 0;
	UserZ := 0;
	LookTo(0, 0, -1);
end;

procedure TStarsSaver.Initialize;
var
	i: SG;
begin
	inherited;
	for i := 0 to StarsCount - 1 do
	begin
		stX[i] := Random2(255);
		stY[i] := Random2(255);
		stZ[i] := Random2(255);
	end;
end;

end.
