// * File:     MultiSaver\uFaderSaver.pas
// * Created:  2001-06-01
// * Modified: 2010-12-29
// * Version:  1.1.47.72
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uFaderSaver;

interface

uses
	uDBitmap,
	uSaver;

type
	TFaderSaver = class(TSaver)
	private
		BmpRGB: TDBitmap;
		BmpI: Integer;
		BmpX: Integer;
	public
		constructor Create; override;
		destructor Destroy; override;
		procedure Initialize; override;
		procedure Draw; override;
		procedure Step; override;
	end;

implementation

uses
	uTypes, uMath, uDrawStyle, uMain,
	SysUtils, Forms, Graphics;

{ TFaderSaver }

constructor TFaderSaver.Create;
begin
	inherited;
	Mode2D := True;
end;

destructor TFaderSaver.Destroy;
begin
	FreeAndNil(BmpRGB);
	inherited;
end;

procedure TFaderSaver.Draw;
var
	Co: array[0..3] of TColor;
	GenFunc: TGenFunc;
	i: SG;
begin
	inherited;
	if not Assigned(BmpRGB) then
	begin
		BmpRGB := TDBitmap.Create;
	end;

	if (BmpI mod 32 = 0) or (BmpRGB.Width <> TfMain(ParentForm).BmpD.Width) or (BmpRGB.Height <> TfMain(ParentForm).BmpD.Height) then
	begin
		if (BmpI mod 32 = 0) then
			Inc(BmpX);
		BmpRGB.SetSize(TfMain(ParentForm).BmpD.Width, TfMain(ParentForm).BmpD.Height);
		GenFunc := TGenFunc(BmpX mod (Integer(High(TGenFunc)) + 1));
		case GenFunc of
		gfRandom:
			Co[0] := clBtnFace;
		gfRandomLines:
			Co[0] := $00010101;
		else
		begin
			Co[0] := clRed;
			Co[1] := clLime;
			Co[2] := clBlue;
			Co[3] := clBtnFace;
		end;
		end;
		BmpRGB.GenerateRGB(GenFunc, Co, ef16, nil);
	end;
	i := LinearMax((BmpI + 1), 16);
	if Assigned(BackBmp) then
		TfMain(ParentForm).BmpD.Bmp(0, 0, BackBmp, WindowRect.Left - DesktopRect.Left, WindowRect.Top - DesktopRect.Top,
			WindowRect.Right - DesktopRect.Left, WindowRect.Bottom - DesktopRect.Top, ef16);
	TfMain(ParentForm).BmpD.Bmp(0, 0, BmpRGB, TEffect(i));
end;

procedure TFaderSaver.Initialize;
begin
	inherited;
	BmpI := -1;
	BmpX := -1;
end;

procedure TFaderSaver.Step;
begin
	inherited;
	Inc(BmpI);
end;

end.
