// * File:     MultiSaver\uElementsSaver.pas
// * Created:  2001-06-01
// * Modified: 2010-12-29
// * Version:  1.1.47.72
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uElementsSaver;

interface

uses
	Math,
	uTypes, uColor,
	uSaver;

const
	ElementCount = 48;
type
	TElementsSaver = class(TSaver)
		Elements: array[0..ElementCount - 1] of record
			m: SG;
			RX, RY, RZ,
			LX, LY, LZ,
			VX, VY, VZ: TFlo;
			FX, FY, FZ: TFlo;
		end;
	public
		constructor Create; override;
		destructor Destroy; override;
		procedure Initialize; override;
		procedure Draw; override;
		procedure SetCamera; override;
		procedure Step; override;
	end;

implementation

uses uMath, OpenGL12;

{ TElementSaver }

constructor TElementsSaver.Create;
begin
	inherited;
	Mode2D := False;
end;

destructor TElementsSaver.Destroy;
begin

	inherited;
end;

procedure TElementsSaver.Draw;
const
	LineLength = 1;
	Zoom = 10;
var
	i: SG;
	c: SG;
	AngleX, AngleZ: TFlo;
begin
	glClear(GL_COLOR_BUFFER_BIT);
	glEnable(GL_COLOR_MATERIAL);

	LightPos[0] := UserX;
	LightPos[1] := UserY;
	LightPos[2] := UserZ;

	glEnable(GL_LIGHT0);
	glLightfv(GL_LIGHT0, GL_AMBIENT, @glfLightAmbient[0]);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, @glfLightDiffuse[0]);
	glLightfv(GL_LIGHT0, GL_SPECULAR,@glfLightSpecular[0]);
	glLightfv(GL_LIGHT0, GL_POSITION,@LightPos[0]);
	glLightf(GL_LIGHT0, GL_SPOT_CUTOFF, 60);
	glfDirect[0] := Sin(UserAngleXZ);
	glfDirect[1] := UserAngleY;
	glfDirect[2] := -Cos(UserAngleXZ);
	glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION, @glfDirect[0]);

	glLineWidth(1);
	glEnable(GL_LINE_SMOOTH);
//	glScale(10, 10, 10);


	for i := 0 to ElementCount - 1 do
	begin
		glLoadIdentity;
{		d := Round(5000 * Sqrt(Leng(Elements[i].VX, Elements[i].VY, Elements[i].VZ)));
		if d > 255 then d := 255;
		if d < 96 then d := 96;
		c := Round(d);}

(*		glColor3ub(c, c, c);
		glBegin(GL_LINES);
{		dx := LineLength * cos(Dir) / 2;
		dy := LineLength * sin(Dir) / 2;}
		z := -1; // -SG(LinearMax(fMain.Timer1.TimerCount, 10));
		glVertex3f(Zoom * Elements[i].RX, Zoom * Elements[i].RY, -5 + Zoom * Elements[i].RZ);
		glVertex3f(Zoom * (Elements[i].RX + 1 * Elements[i].VX),
			Zoom * (Elements[i].RY + 1 * Elements[i].VY),
			-5 + Zoom * (Elements[i].RZ + 1 * Elements[i].VZ));
//		glVertex3f(Zoom * Elements[i].LX, Zoom * Elements[i].LY, -5 + Zoom * Elements[i].LZ);
		glEnd;*)

		glTranslatef(Zoom * Elements[i].RX, Zoom * Elements[i].RY, Zoom * Elements[i].RZ);
		glScalef(0.1, 0.1, 0.1);
{		AngleX := RadToDeg(Arg(Elements[i].VY, Elements[i].VZ));
		AngleY := RadToDeg(Arg(Elements[i].VZ, Elements[i].VX));
		AngleZ := RadToDeg(Arg(Elements[i].VX, Elements[i].VY));}
		AngleX := RadToDeg(Arg(Elements[i].VY, Elements[i].VZ));
//		AngleY := RadToDeg(Arg(Elements[i].VZ, Elements[i].VX)); // ok
		AngleZ := RadToDeg(Arg(Elements[i].VX, Elements[i].VY)); // ok

		glRotatef(AngleX, 1, 0, 0);
//		glRotatef(AngleY, 0, 1, 0);
		glRotatef(AngleZ, 0, 0, 1);

//		C := FireColor(RoundDiv(i * MaxFireColor, 2 * ElementCount));
//		C := SpectrumColor(RoundDiv(i * MaxSpectrum, 4 * ElementCount));
		C := SpectrumColor(4 * i);
		glColor3ubv(@TRGBA(C).R);
		glBegin(GL_QUADS);
			glVertex3f(1.0, 1.0, 1.0);
			glVertex3f(-1.0, 1.0, 1.0);
			glVertex3f(-1.0, -1.0, 1.0);
			glVertex3f(1.0, -1.0, 1.0);
		glEnd;

		glBegin(GL_QUADS);
			glVertex3f(1.0, 1.0, -1.0);
			glVertex3f(1.0, -1.0, -1.0);
			glVertex3f(-1.0, -1.0, -1.0);
			glVertex3f(-1.0, 1.0, -1.0);
		glEnd;

		glBegin(GL_QUADS);
			glVertex3f(-1.0, 1.0, 1.0);
			glVertex3f(-1.0, 1.0, -1.0);
			glVertex3f(-1.0, -1.0, -1.0);
			glVertex3f(-1.0, -1.0, 1.0);
		glEnd;

		glBegin(GL_QUADS);
			glVertex3f(1.0, 1.0, 1.0);
			glVertex3f(1.0, -1.0, 1.0);
			glVertex3f(1.0, -1.0, -1.0);
			glVertex3f(1.0, 1.0, -1.0);
		glEnd;

		glBegin(GL_QUADS);
			glVertex3f(-1.0, 1.0, -1.0);
			glVertex3f(-1.0, 1.0, 1.0);
			glVertex3f(1.0, 1.0, 1.0);
			glVertex3f(1.0, 1.0, -1.0);
		glEnd;

		glBegin(GL_QUADS);
			glVertex3f(-1.0, -1.0, -1.0);
			glVertex3f(1.0, -1.0, -1.0);
			glVertex3f(1.0, -1.0, 1.0);
			glVertex3f(-1.0, -1.0, 1.0);
		glEnd;
	end;
end;

procedure TElementsSaver.Initialize;
var i: SG;
begin
	inherited;
	for i := 0 to ElementCount - 1 do
	begin
		Elements[i].RX := Random2(10) / 100;
		Elements[i].RY := Random2(10) / 100;
		Elements[i].RZ := Random2(10) / 100 - 3;
		if i mod 2 = 0 then
		begin
			Elements[i].VX := Random2(10) / 100;
			Elements[i].VY := Random2(10) / 100;
			Elements[i].VZ := Random2(10) / 1000;
		end
		else
		begin
			Elements[i].VX := Elements[i - 1].VX;
			Elements[i].VY := Elements[i - 1].VY;
			Elements[i].VZ := Elements[i - 1].VZ;
		end;
	end;
end;

procedure TElementsSaver.SetCamera;
var
	i: SG;
	SumX, SumY, SumZ: TFlo;
begin
	inherited;
	SumX := 0;
	SumY := 0;
	SumZ := 0;
	for i := 0 to ElementCount - 1 do
	begin
		SumX := SumX + Elements[i].RX;
		SumY := SumY + Elements[i].RY;
		SumZ := SumZ + Elements[i].RZ;
	end;
	SumX := SumX / ElementCount;
	SumY := SumY / ElementCount;
	SumZ := SumZ / ElementCount;
	UserX := 0;
	UserY := 0;
	UserZ := 0;
	LookTo(SumX, SumY, SumZ);
end;

procedure TElementsSaver.Step;
const
	tv = 0.04;
	tr = 1;
var
	i, j: SG;
	VX, VY, VZ: TFlo;
begin

	for i := 0 to ElementCount - 1 do
	begin
		Elements[i].m := 10;
		Elements[i].FX := 0;
		Elements[i].FY := 0;
		Elements[i].FZ := 0;
{		Elements[i].FX := Elements[i].FX + Random2(5));
		Elements[i].FY := Elements[i].FY + Random2(5));
		Elements[i].FZ := Elements[i].FY + Random2(5));}
		for j := 0 to ElementCount - 1 do
		begin
			if i <> j then
			begin
				Elements[i].FX := Elements[i].FX - (Elements[i].RX - Elements[j].RX);
				Elements[i].FY := Elements[i].FY - (Elements[i].RY - Elements[j].RY);
				Elements[i].FZ := Elements[i].FZ - (Elements[i].RZ - Elements[j].RZ);
			end;
		end;
		Elements[i].FX := Elements[i].FX - Elements[i].RX / 5;
		Elements[i].FY := Elements[i].FY - Elements[i].RY / 5;
		Elements[i].FZ := Elements[i].FZ - Elements[i].RZ / 5;

		Elements[i].LX := Elements[i].RX;
		Elements[i].LY := Elements[i].RY;
		Elements[i].LZ := Elements[i].RZ;

		VX := tv * Elements[i].FX / Elements[i].m;
		VY := tv * Elements[i].FY / Elements[i].m;
		VZ := tv * Elements[i].FZ / Elements[i].m;
		Elements[i].RX := Elements[i].RX + ElapsedTime * tr * (Elements[i].VX + 0.5 * VX) / PerformanceFrequency;
		Elements[i].RY := Elements[i].RY + ElapsedTime * tr * (Elements[i].VY + 0.5 * VY) / PerformanceFrequency;
		Elements[i].RZ := Elements[i].RZ + ElapsedTime * tr * (Elements[i].VZ + 0.5 * VZ) / PerformanceFrequency;

		Elements[i].VX := Elements[i].VX + VX;
		Elements[i].VY := Elements[i].VY + VY;
		Elements[i].VZ := Elements[i].VZ + VZ;
	end;
end;

end.
