// * File:     MultiSaver\uTVSaver.pas
// * Created:  2001-06-01
// * Modified: 2010-12-29
// * Version:  1.1.47.72
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uTVSaver;

interface

uses
	uTypes, uColor,
	uSaver;

const
	NX = 512;
	NY = 256; // GeForce2 need power of 2 // 480; // PAL: 480 from 625 lines
type
	TTVSaver = class(TSaver)
	private
		Tex: array[0..NY - 1, 0..NX - 1] of TRGBA;
	public
		constructor Create; override;
		destructor Destroy; override;
		procedure Draw; override;
		procedure SetCamera; override;
		procedure Step; override;
	end;


implementation

uses
	uMain,
	uMath,
	Math, OpenGL12, uDTimer;

{ TTVSaver }

constructor TTVSaver.Create;
begin
	inherited;
	Mode2D := True;
end;

destructor TTVSaver.Destroy;
begin

	inherited;
end;

procedure TTVSaver.Draw;
begin
	inherited;
	glClear(GL_COLOR_BUFFER_BIT);
	glEnable(GL_COLOR_MATERIAL);
	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, @glfMaterialColor[0]);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, @glfSilverColor[0]);

{	glEnable(GL_COLOR_MATERIAL);
	LightPos[0] := UserX;
	LightPos[1] := UserY;
	LightPos[2] := UserZ;

	glEnable(GL_LIGHT0);
	glLightfv(GL_LIGHT0, GL_AMBIENT, @glfLightAmbient[0]);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, @glfLightDiffuse[0]);
	glLightfv(GL_LIGHT0, GL_SPECULAR, @glfLightSpecular[0]);
	glLightfv(GL_LIGHT0, GL_POSITION, @LightPos[0]);
	glLightf(GL_LIGHT0, GL_SPOT_CUTOFF, 60);
	glfDirect[0] := Sin(UserAngleXZ);
	glfDirect[1] := UserAngleY;
	glfDirect[2] := -Cos(UserAngleXZ);
	glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION, @glfDirect[0]);}

	glLoadIdentity;
	glScalef(12, 12, 12);
	glColor3ub(255, 255, 255);

	glEnable(GL_TEXTURE_2D);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, NX,
		NY, 0, GL_RGBA, GL_UNSIGNED_BYTE,
		@Tex[0, 0]);
{	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);}
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);

	glBegin(GL_QUADS);
		glNormal3f(0.0, 0.0, -1.0);
		glTexCoord2f(1, 1);
		glVertex3f(4 / 3, 1.0, -1.725);
		glTexCoord2f(0, 1);
		glVertex3f(-4 / 3, 1.0, -1.725);
		glTexCoord2f(0, 0);
		glVertex3f(-4 / 3, -1.0, -1.725);
		glTexCoord2f(1, 0);
		glVertex3f(4 / 3, -1.0, -1.725);
	glEnd;
{	glBegin(GL_QUADS);
		glNormal3f(0.0, 0.0, -1.0);
		glTexCoord2f(0, 0);
		glVertex3f(1.0, 1.0, -1.0);
		glTexCoord2f(4, 0);
		glVertex3f(-1.0, 1.0, -1.0);
		glTexCoord2f(4, 4);
		glVertex3f(-1.0, -1.0, -1.0);
		glTexCoord2f(0, 4);
		glVertex3f(1.0, -1.0, -1.0);
	glEnd;}
end;

procedure TTVSaver.SetCamera;
begin
	inherited;
	UserX := 0;
	UserY := 0;
	UserZ := 2; // Fullscreen
	LookTo(0, 0, -1);
end;

procedure TTVSaver.Step;
var
	X, Y: Integer;
	B: Byte;
	C: TRGBA;
begin
	inherited;
	C.A := $ff;
	B := Random(256);
//	B := RandomM and $ff;
	Y := Timer.TimerCount and 1;
	while Y < NY do
	begin
		for X := 0 to NX - 1 do
		begin
//			B := Random(256);
			B := B xor (Random(B or $80));
//			B := B xor (RandomM mod (B or $80));
			C.R := B;
			C.G := B;
			C.B := B;
			Tex[Y, X] := C;
{			Tex[Y, X, 1] := B;
			Tex[Y, X, 2] := B;}
	//		 Pix(Tex.PData, Tex.ByteX, X, Y, C.L, ef16);
		end;
		Inc(Y, 2);
	end;
end;

end.
