// * File:     MultiSaver\uMain.pas
// * Created:  2001-06-01
// * Modified: 2011-01-08
// * Version:  1.1.47.72
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	uDForm, uTypes, uDBitmap, uSaver,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, Registry, ExtCtrls, Menus, uDTimer, ActnList;

type
	TfMain = class(TDForm)
		DTimer: TDTimer;
		PopupMenu1: TPopupMenu;
		SaverMode1: TMenuItem;
		ShutdownMonitor1: TMenuItem;
		File1: TMenuItem;
		Help1: TMenuItem;
		Options1: TMenuItem;
		Next1: TMenuItem;
		Previous1: TMenuItem;
		N2: TMenuItem;
		DisplayOptions1: TMenuItem;
		ActionList1: TActionList;
		FullScreen1: TAction;
		Restart1: TMenuItem;
		procedure FormCreate(Sender: TObject);
		procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
			Shift: TShiftState; X, Y: Integer);
		procedure DTimerTimer(Sender: TObject);
		procedure PopupMenu1Popup(Sender: TObject);
		procedure ShutdownMonitor1Click(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure FormDestroy(Sender: TObject);
		procedure FormResize(Sender: TObject);
		procedure FormPaint(Sender: TObject);
		procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
			Y: Integer);
		procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
			Shift: TShiftState; X, Y: Integer);
		procedure FormDblClick(Sender: TObject);
		procedure FormKeyDown(Sender: TObject; var Key: Word;
			Shift: TShiftState);
		procedure PreviousNext1Click(Sender: TObject);
		procedure DisplayOptions1Click(Sender: TObject);
		procedure FullScreen1Execute(Sender: TObject);
		procedure Restart1Click(Sender: TObject);
	private
		Closing: BG;
		MouseLeft: BG;
		MouseX, MouseY: SG;

		function EnterPassword: BG;
		procedure InitWindow;
		procedure SaverModeClick(Sender: TObject);
		procedure WMSysCommand(var Msg: TWMSysCommand); message WM_SYSCOMMAND;
		procedure WMSysKeyDown(var Msg: TWMSysKeyDown); message WM_SYSKEYDOWN;
		procedure WMPowerBroadcast(var Msg: TMessage); message WM_POWERBROADCAST;
		procedure RWOptions(const Save: Boolean);
		procedure DisplayOptionChanged(const OptionIndex: SG);
		procedure SetRun(const Run: BG);
	public
		LX, LY: SG;
		Saver: TSaver;
		SaverMode: TSaverMode;
		BmpD: TDBitmap;
		procedure CreateParams(var Params: TCreateParams); override;
		procedure UpdateBackground(const SaverMode: TSaverMode);
	end;

const
	MonitorLimit = 8;
var
	fMain: array[0..MonitorLimit - 1] of TfMain;
	RunMode: (rmNone, rmInstall, rmUninstall, rmConfigure,
		rmExecute, rmPreview, rmSetPwd);
var
	ConfigParent: hWnd;
	ParamHandle : THandle;

const
	CursorVisUserTime = 3 * Second;
var
	MonOff: BG;
	MonOffTime: U4;

	CursorVis: BG;
	CursorVisTime: U4;

procedure FillPreview;
procedure ExecSetPwd;

implementation

{$R *.DFM}
uses
	OpenGL12, Math, TypInfo,
	uMsg, uGetTime, uStrings, uScreen, uInputFormat, uSysInfo, uOptions, ufOptions, uDictionary,
	uGraph, uGetInt, uAbout, uDIniFile, uFiles, uMenus, uMath, uOutputFormat , uSystem, uSimulation,
	uPicturesSaver;

procedure FillPreview;
var
	MyRect: TRect;
	MyCanvas: TCanvas;
	InMemBitmap: TBitmap;
	ScrWidth, ScrHeight: SG;
	x, y, dx, dy: SG;
begin
	while not IsWindowVisible(ParamHandle) do
		Application.ProcessMessages;
	GetWindowRect(ParamHandle, MyRect);
	ScrWidth := MyRect.Right - MyRect.Left + 1;
	ScrHeight := MyRect.Bottom - MyRect.Top + 1;
	MyRect := Rect(0, 0, ScrWidth - 1, ScrHeight - 1);
	MyCanvas := TCanvas.Create;
	MyCanvas.Handle := GetDC(ParamHandle);
	InMemBitmap := TBitmap.Create;
	try
		x := (ScrWidth div 2) - 16;
		y := (ScrHeight div 2) - 16;
		dx := 1;
		dy := 1;
		InMemBitmap.Width := ScrWidth;
		InMemBitmap.Height := ScrHeight;
		while IsWindowVisible(ParamHandle) do
		begin
			InMemBitmap.Canvas.Brush.Color := clBlack;
			InMemBitmap.Canvas.FillRect(MyRect);
			InMemBitmap.Canvas.Draw(x, y, Application.Icon);
			MyCanvas.CopyRect(MyRect, InMemBitmap.Canvas, MyRect);
			Sleep(LoopSleepTime);
			Application.ProcessMessages;
			if (x = 0) or (x = (ScrWidth - 33)) then
				dx := -dx;
			if (y = 0) or (y = (ScrHeight - 33)) then
				dy := -dy;
			x := x + dx;
			y := y + dy;
		end;
	finally
		ReleaseDC(ParamHandle, MyCanvas.Handle); MyCanvas.Handle := 0;
		MyCanvas.Free;
		InMemBitmap.Free;
	end;
end;

procedure SetMonitorOff(B: BG);
var
	i: SG;
	C: TCOmponent;
begin
	MonOff := B;
	for i := 0 to Application.ComponentCount - 1 do
	begin
		C := Application.Components[i];
		if C is TfMain then
			TfMain(C).DTimer.Enabled := not B;
	end;
	if B then
		PostMessage(Application.Handle, WM_SYSCOMMAND, SC_MONITORPOWER, 2)
	else
		PostMessage(Application.Handle, WM_SYSCOMMAND, SC_MONITORPOWER, -1);
end;

procedure TfMain.RWOptions(const Save: Boolean);
//const Section = 'Options';
begin
	MainIni.RWEnum(Self.Name, TypeInfo(TSaverMode), U1(SaverMode), Save);
	uOptions.RWOptions(POptions(@DisplayOptions), Length(DisplayOptions), PParams(@DisplayParams), MainIni, 'Display Options', Save);
	MainIni.RWFormPos(Self, Save);
end;

(*procedure SetKeyState(KeyCode: U1; const State: U1);
var
	KeyState: TKeyboardState;
begin
	FillChar(KeyState, SizeOf(TKeyboardState), 0); {Initialize}
	GetKeyboardState(KeyState);
	KeyState[KeyCode] := State;
	SetKeyboardState(KeyState);
end; *)

procedure TfMain.UpdateBackground(const SaverMode: TSaverMode);
begin
	if (SaverMode in [smFader, smCurves]) then
	begin
		if DisplayParams[doDisableOpenGLForFaderAndCurves].Bool = False then
			Background := baOpenGLBitmap
		else
			Background := baUser;
	end
	else
		Background := baOpenGL;
end;

var
	CreateCount: SG;
	
procedure TfMain.FormCreate(Sender: TObject);
var
	i: SG;
	M: TMenuItem;
begin
	Background := baNone;
	{$ifopt d-}
	Randomize;
	{$endif}
	CursorVis := True;
	for i := 0 to Length(SaverModeNames) - 1 do
	begin
		M := TMenuItem.Create(SaverMode1);
		M.Caption := SaverModeNames[TSaverMode(i)];
		M.Tag := i;
		M.RadioItem := True;
		M.GroupIndex := 1;
		M.OnClick := SaverModeClick;
		SaverMode1.Insert(i, M);
	end;
	MenuSet(PopupMenu1);

	RWOptions(False);
	if DisplayParams[doDisableOpenGLForFaderAndCurves].Bool = False then
		if Assigned(BackBmp) then
			BackBmp.SwapRB;
	GetGTime;
	MonOffTime := GTime;
	case TStartupSaver(DisplayParams[doStartupSaver].Num) of
	ssRandom: SaverMode := TSaverMode(Random(SG(High(TSaverMode)) + 1));
	ssDescending: SaverMode := TSaverMode((SG(SaverMode) + 1) mod (SG(High(TSaverMode)) + 1));
	ssAscending: SaverMode := TSaverMode((SG(SaverMode) + 1) mod (SG(High(TSaverMode)) + 1));
	ssSameWholeDay: SaverMode := TSaverMode((Trunc(Date) + CreateCount) mod (SG(High(TSaverMode)) + 1));
	end;
	Inc(CreateCount);

//	ShowTaskBar(True);
	DisplayOptionChanged(SG(doFullScreen));
	BmpD := BackBitmap;
	SetRun(True);
	ChangeSaver(SaverMode, Self);

	DisplayOptionChanged(SG(doTimerEvent));
	DisplayOptionChanged(SG(doSpeed));
	DTimer.Enabled := True;
	DTimerTimer(Sender);
end;

procedure TfMain.WMSysKeyDown(var Msg: TWMSysKeyDown);
begin
	if MonOff then
		SetMonitorOff(True);
end;

procedure TfMain.WMSysCommand;
begin
	if Msg.cmdType = SC_SCREENSAVE then
		Msg.Result := 1
	else
		inherited;
end;

procedure TfMain.CreateParams(var Params: TCreateParams);
begin
	inherited;
	{$ifopt d-}
	Params.ExStyle := Params.ExStyle or WS_EX_TOPMOST;
	{$endif}
end;

procedure SetShowCursor(Visible: Boolean);
begin
	if Visible = True then
		CursorVisTime := GTime;
	if CursorVis <> Visible then
	begin
		CursorVis := Visible;
		ShowCursor(Visible);
	end;
end;

procedure TfMain.FormMouseDown(Sender: TObject; Button: TMouseButton;
	Shift: TShiftState; X, Y: Integer);
begin
	MonOffTime := GTime;
	if MonOff then
		SetMonitorOff(False);
	SetShowCursor(True);

	case Button of
	mbLeft:
	begin
		MouseLeft := True;
		MouseX := X;
		MouseY := Y;
	end;
	mbRight:
	begin
		SetShowCursor(True);
		PopupMenu1.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);
	end;
	end;
end;

procedure TfMain.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
	Y: Integer);
begin
	if (X <> LX) or (Y <> LY) then
	begin
		SetShowCursor(True);
		LX := X;
		LY := Y;
	end;
	if MonOff and DisplayParams[doShutdownMonitorOnMouseMove].Bool then
	begin
		SetMonitorOff(True);
	end;
	if MouseLeft then
	begin
		Saver.UserAngleXZ := Saver.UserAngleXZ + 0.002 * (X - MouseX);
		Saver.UserAngleY := Saver.UserAngleY - 0.002 * (Y - MouseY);
		MouseX := X;
		MouseY := Y;
	end;
end;

procedure TfMain.DTimerTimer(Sender: TObject);
var
	DFB, DLR, DUD: SG;
begin
	if RunMode = rmExecute then
	begin
		Assert(MonOff = False);
		GetGTime;
		DFB := 0;
		DLR := 0;
		DUD := 0;
		if Active then
		begin
			if GetAsyncKeyState(Ord('S')) <> 0 then Dec(DLR);
			if GetAsyncKeyState(Ord('F')) <> 0 then Inc(DLR);
			if GetAsyncKeyState(Ord(' ')) <> 0 then Dec(DUD);
			if GetAsyncKeyState(Ord('C')) <> 0 then Inc(DUD);
			if GetAsyncKeyState(Ord('D')) <> 0 then Inc(DFB);
			if GetAsyncKeyState(Ord('E')) <> 0 then Dec(DFB);
			if GetAsyncKeyState(Ord('K')) <> 0 then Saver.UserAngleXZ := Saver.UserAngleXZ - 0.5 * DTimer.ElapsedTime / PerformanceFrequency;
			if GetAsyncKeyState(Ord('L')) <> 0 then Saver.UserAngleXZ := Saver.UserAngleXZ + 0.5 * DTimer.ElapsedTime / PerformanceFrequency;
		end;
		
		if Assigned(Saver) then
		begin
			Saver.UserX := Saver.UserX + 4 * DTimer.ElapsedTime / PerformanceFrequency * (Cos(Saver.UserAngleXZ) * DLR - Sin(Saver.UserAngleXZ) * DFB);
			Saver.UserZ := Saver.UserZ + 4 * DTimer.ElapsedTime / PerformanceFrequency * (Cos(Saver.UserAngleXZ) * DFB + Sin(Saver.UserAngleXZ) * DLR);

			Saver.UserY := Saver.UserY + 4 * DTimer.ElapsedTime / PerformanceFrequency * DUD;

			if DisplayParams[doAnimate].Bool then
			begin
				Saver.ElapsedTime := DTimer.ElapsedTime;
				Saver.Clock := DTimer.Clock;
				Saver.Step;
				if DisplayParams[doAutomaticallySetCamera].Bool then
					Saver.SetCamera;
			end;
		end;

//		if (Mouse.CursorPos.x <> LX) or (Mouse.CursorPos.y <> LY) then // System Error Code: 5. Access is denied (Object Mouse)
{		begin
			LX := Mouse.CursorPos.x;
			LY := Mouse.CursorPos.y;
			SetShowCursor(True);
		end
		else
		begin}
		if Active and CursorVis and (IntervalFrom(CursorVisTime) > CursorVisUserTime) then
		begin
			SetShowCursor(False);
		end;
//		end;

		if DisplayParams[doShutdownMonitorTime].Num <> 0 then
			if IntervalFrom(MonOffTime) > UG(DisplayParams[doShutdownMonitorTime].Num) then
			begin
				if MonOff = False then
					SetMonitorOff(True);
			end;
		Repaint;
	end;
end;

procedure ExecSetPwd;
var
	HLib : THandle;
	P: function(a: PChar; ParentHandle: THandle; b, c: Integer): Integer; stdcall;
begin
	HLib := LoadLibrary(PChar(SysDir + 'MPR.DLL'));
	if HLib <> 0 then begin
		P := GetProcAddress(HLib, 'PwdChangePasswordA');
		if Assigned(P) then
			P('SCRSAVE', ParamHandle, 0, 0);
		FreeLibrary (HLib);
	end;
end;

procedure TfMain.PopupMenu1Popup(Sender: TObject);
var
	i: SG;
begin
	ShutDownMonitor1.Caption := Translate('Shutdown') + CharSpace + NToS(Screen.MonitorCount) + CharSpace + Translate('Monitor' + Plural(Screen.MonitorCount));
	for i := 0 to Length(SaverModeNames) - 1 do
	begin
		if SaverMode1.Items[i].Tag >= 0 then
			SaverMode1.Items[i].Checked := TSaverMode(SaverMode1.Items[i].Tag) = SaverMode;
	end;
end;

procedure TfMain.SaverModeClick(Sender: TObject);
begin
	ChangeSaver(TSaverMode(TMenuItem(Sender).Tag), Self);
	DTimerTimer(Sender);
end;

procedure TfMain.ShutdownMonitor1Click(Sender: TObject);
begin
	SetMonitorOff(True);
end;

function TfMain.EnterPassword: BG;
var
	hLib: THandle;
	P: function(Parent: THandle): Boolean; stdcall;
	Registry: TRegistry;
begin
	Result := True;
	if RunMode <> rmExecute then
		Exit;
	MonOffTime := GTime;
	if MonOff then
		SetMonitorOff(False);
	SetShowCursor(True);
	if not NTSystem then
	begin
		try
			Registry := TRegistry.Create(KEY_QUERY_VALUE);
			try
				Registry.RootKey := HKEY_CURRENT_USER;
				if Registry.OpenKeyReadOnly('Control Panel\Desktop') then
				begin
					if (Registry.ValueExists('ScreenSaveUsePassword'))
					and (Registry.ReadInteger('ScreenSaveUsePassword') <> 0) then
					begin
						hLib := LoadLibrary(PChar(SysDir + 'PASSWORD.CPL')); // Library exists on Windows 95/98 only
						if hLib <> 0 then
						begin
							P := GetProcAddress(hLib, 'VerifyScreenSavePwd');
							if P(Handle) = False then
								Result := False;
							FreeLibrary(hLib);
						end;
					end;
					Registry.CloseKey;
				end;
			finally
				Registry.Free;
			end;
		except
			on E: Exception do
				Fatal(E, Self);
		end;
	end;
end;

procedure TfMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
	i: SG;
	C: TComponent;
begin
	DTimer.Enabled := False;
	if Name = 'fMain' then
		CanClose := EnterPassword
	else
		CanClose := True;

	if CanClose then
	begin
		Closing := True;
		RWOptions(True);
//		if Name = 'fMain' then
		begin
			for i := 0 to Application.ComponentCount - 1 do
			begin
				C := Application.Components[i];
				if (C <> Self) and (C is TfMain) and (TfMain(C).Closing = False) then
					TfMain(C).Close;
			end;
		end;
//		else
//			Application.Terminate;
	end
	else
		DTimer.Enabled := True;
end;

procedure TfMain.FormDestroy(Sender: TObject);
begin
	SetRun(False);
	if Assigned(Saver) then FreeAndNil(Saver);
	FreeAndNil(BackBmp);
	FreeAndNil(FileList);
end;

procedure TfMain.InitWindow;
var
	P: TPoint;
begin
	WindowRect := GetClientRect;
	P := GetClientOrigin;
	WindowRect.Left := P.X;
	WindowRect.Top := P.Y;
	Inc(WindowRect.Right, P.X);
	Inc(WindowRect.Bottom, P.Y);
end;

procedure TfMain.FormResize(Sender: TObject);
begin
	InitWindow;

	case Background of
	baOpenGLBitmap:
	begin
		if SaverMode = smCurves then
		begin
			ChangeSaver(SaverMode, Self);
		end;
	end;
	end;
end;

procedure TfMain.FormPaint(Sender: TObject);
begin
	InitWindow;

	if Assigned(Saver) then
		Saver.DrawAll;
end;

procedure TfMain.FormMouseUp(Sender: TObject; Button: TMouseButton;
	Shift: TShiftState; X, Y: Integer);
begin
	MouseLeft := False;
end;

procedure TfMain.FormDblClick(Sender: TObject);
begin
	Saver.DoubleClick;
end;

procedure TfMain.WMPowerBroadcast(var Msg: TMessage);
begin
	if Msg.WParam = 4{PBT_APMSUSPEND} then
		Close;
end;

procedure Initialize;
begin
	EnumToStr(TypeInfo(TSaverMode), SaverModeNames);
	InitOptionNames(TypeInfo(TDisplayOption), DisplayOptions);
end;

procedure TfMain.FormKeyDown(Sender: TObject; var Key: Word;
	Shift: TShiftState);
begin
	if Key = VK_ESCAPE then
	begin
		Close;
	end
	else if Key = VK_PAUSE then
	begin
		DTimer.Enabled := not DTimer.Enabled;
	end
	else if MonOff then // Retry Monitor Off
	begin
		SetMonitorOff(True);
	end;
end;

procedure TfMain.PreviousNext1Click(Sender: TObject);
begin
	ChangeSaver(TSaverMode(RangeOverFlow(SG(Low(SaverMode)), SG(SaverMode) + TMenuItem(Sender).Tag, SG(High(SaverMode)))), Self) ;
end;

procedure TfMain.DisplayOptions1Click(Sender: TObject);
begin
//	SetShowCursor(True);
	ShowOptions('Display Options', POptions(@DisplayOptions), Length(DisplayOptions), PParams(@DisplayParams), DisplayOptionChanged);
//	SetShowCursor(False);
end;

procedure TfMain.DisplayOptionChanged(const OptionIndex: SG);
var i: SG;
begin
	case TDisplayOption(OptionIndex) of
	doFullScreen:
	begin
		if DisplayParams[doOnAllMonitors].Bool then
		begin
			for i := 0 to Application.ComponentCount - 1 do
			begin
				if Copy(Application.Components[i].Name, 1, 5) = 'fMain' then
					TDForm(Application.Components[i]).FullScreen := DisplayParams[doFullScreen].Bool;
			end;
		end
		else
			FullScreen := DisplayParams[doFullScreen].Bool;
	end;
	doDisableOpenGLForFaderAndCurves:
	begin
		if Assigned(BackBmp) then
			BackBmp.SwapRB;
		UpdateBackground(SaverMode);
	end;
	doViewFPS,
	doViewDateAndTime,
	doViewRunTime:
	begin
		DTimerTimer(nil);
	end;
	doTimerEvent:
		DTimer.EventStep := TEventStep(DisplayParams[doTimerEvent].Num);
	doSpeed:
	begin
		DTimer.Interval := DisplayParams[doSpeed].Num;
	end;
{	else
		raise Exception.Create('Invalid option index.');}
	end;
end;

procedure TfMain.FullScreen1Execute(Sender: TObject);
begin
	DisplayParams[doFullScreen].Bool := not DisplayParams[doFullScreen].Bool;
	DisplayOptionChanged(SG(doFullScreen));
end;

//{$ifopt d-}
procedure TfMain.SetRun(const Run: BG);
const
	sRegPolicies = '\Software\Microsoft\Windows\CurrentVersion\Policies';
var
	Dummy: SG;
begin
	if not NTSystem then
	begin
		// Do not work on XP and newer Windows
		Dummy := 0;
		SystemParametersInfo(SPI_SCREENSAVERRUNNING, SG(Run), @Dummy, 0);
		SystemParametersInfo(SPI_SETFASTTASKSWITCH, SG(Run), @Dummy, 0);
	end
	else
	begin
		with TRegistry.Create do
		try
			RootKey := HKEY_CURRENT_USER;
			if OpenKey(sRegPolicies + '\System\', False) then
			begin
				WriteInteger('DisableTaskMgr', SG(Run));
				CloseKey;
			end;
			if OpenKey(sRegPolicies + '\Explorer\', False) then
			begin
				WriteInteger('NoChangeStartMenu', SG(Run));
				WriteInteger('NoClose', SG(Run));
				WriteInteger('NoLogOff', SG(Run));
				CloseKey;
			end;
		finally
			Free;
		end;
	end;
end;
//{$endif}

procedure TfMain.Restart1Click(Sender: TObject);
begin
	Saver.Initialize;
	Saver.SetCamera;
end;

initialization
	Initialize;
end.
