// * File:     MultiSaver\uLinesSaver.pas
// * Created:  2001-06-01
// * Modified: 2011-01-06
// * Version:  1.1.47.72
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uLinesSaver;

interface

uses
	uTypes, uSaver,
	Graphics;

const
	PointCount = 5;
	PolygonCount = 8;
type
	TCurvePoint = record
		XYZ: array[0..2] of TFlo;
		VXYZ: array[0..2] of TFlo;
	end;
	TCurve = record
		Points: array[0..PointCount - 1] of TCurvePoint;
		Color: TColor;
	end;

	TLinesSaver = class(TSaver)
	private
		SpectrumC: SG;
		Curves: array[0..PolygonCount - 1] of TCurve;
		LookAngleX, LookAngleY: TFlo;
	public
		constructor Create; override;
		destructor Destroy; override;
		procedure Initialize; override;
		procedure Draw; override;
		procedure Step; override;
	end;


implementation

uses
	uColor, uMath,
	OpenGL12;

{ TLinesSaver }

constructor TLinesSaver.Create;
begin
	inherited;
	Mode2D := True;
end;

destructor TLinesSaver.Destroy;
begin

	inherited;
end;

procedure TLinesSaver.Draw;
var
	i, j: SG;
begin
	inherited;
	glClear(GL_COLOR_BUFFER_BIT);
	glEnable(GL_COLOR_MATERIAL);
	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, @glfMaterialColor[0]);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, @glfSilverColor[0]);

	LightPos[0] := UserX;
	LightPos[1] := UserY;
	LightPos[2] := UserZ;

	glEnable(GL_LIGHT0);
	glLightfv(GL_LIGHT0, GL_AMBIENT, @glfLightAmbient[0]);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, @glfLightDiffuse[0]);
	glLightfv(GL_LIGHT0, GL_SPECULAR, @glfLightSpecular[0]);
	glLightfv(GL_LIGHT0, GL_POSITION, @LightPos[0]);
	glLightf(GL_LIGHT0, GL_SPOT_CUTOFF, 60);
	glfDirect[0] := Sin(UserAngleXZ);
	glfDirect[1] := UserAngleY;
	glfDirect[2] := -Cos(UserAngleXZ);
	glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION, @glfDirect[0]);

	glLoadIdentity;
	glScalef(2, 2, 1);
	for i := 0 to 7 do
	begin
		glColor3ubv(@TRGBA(Curves[i].Color).R);
		glBegin(GL_LINE_LOOP);
		for j := 0 to PointCount - 1 do
		begin
			glVertex3fv(@Curves[i].Points[j].XYZ[0]);
		end;
		glEnd;
	end;
end;

procedure TLinesSaver.Initialize;
begin
	inherited;
	SpectrumC := 0;
	FillChar(Curves, SizeOf(Curves), 0);
end;

procedure TLinesSaver.Step;
var
	C: TColor;
	i, j, k: SG;
	t: TFlo;
	VXYZ: array[0..2] of TFlo;
begin
	inherited;
	LookAngleX := LookAngleX + 128 * ElapsedTime / PerformanceFrequency;
	LookAngleY := LookAngleY + 128 * ElapsedTime / PerformanceFrequency;
	if SpectrumC > MaxSpectrum then SpectrumC := 0 else Inc(SpectrumC);
	for i := 6 downto 0 do
	begin
		Curves[i + 1] := Curves[i];
	end;
	for i := 0 to 0 do
	begin
		C := SpectrumColor(SpectrumC);
		Curves[i].Color := C;
		t := 16 * ElapsedTime / PerformanceFrequency;
		for j := 0 to PointCount - 1 do
		begin
			for k := 0 to 2 do
			begin
				VXYZ[k] := t * (Random2(2) / 100 {- (Curves[i].Points[j].XYZ[k]) / 100});

				Curves[i].Points[j].XYZ[k] := Curves[i].Points[j].XYZ[k] + t * (Curves[i].Points[j].VXYZ[k] + 0.5 * VXYZ[k]);

				Curves[i].Points[j].VXYZ[k] := Curves[i].Points[j].VXYZ[k] + VXYZ[k];

				if Curves[i].Points[j].XYZ[k] > 5 then
				begin
					Curves[i].Points[j].XYZ[k] := 5;
					Curves[i].Points[j].VXYZ[k] := -Curves[i].Points[j].VXYZ[k];
				end
				else if Curves[i].Points[j].XYZ[k] < -5 then
				begin
					Curves[i].Points[j].XYZ[k] := -5;
					Curves[i].Points[j].VXYZ[k] := -Curves[i].Points[j].VXYZ[k];
				end
			end;
		end;
	end;
end;

end.
