// * File:     MultiSaver\uClockSaver.pas
// * Created:  2001-06-01
// * Modified: 2010-12-28
// * Version:  1.1.47.72
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uClockSaver;

interface

uses uSaver;

type
	TClockSaver = class(TSaver)
	public
		constructor Create; override;
		destructor Destroy; override;
		procedure Draw; override;
		procedure Step; override;
	end;

implementation

uses
	uTypes, uColor, uSimulation,
	Windows, Graphics, OpenGL12;

procedure DrawArrow(const Len, Wid: TFlo; const z: TFlo);
begin
	{ glBegin(GL_QUADS);
		glNormal3f(0.0, 0.0, -1.0);
		glVertex3f(4 / 3, 1.0, -1.725);
		glTexCoord2f(0, 1);
		glVertex3f(-4 / 3, 1.0, -1.725);
		glTexCoord2f(0, 0);
		glVertex3f(-4 / 3, -1.0, -1.725);
		glTexCoord2f(1, 0);
		glVertex3f(4 / 3, -1.0, -1.725);
		glEnd; }
	glBegin(GL_POLYGON);
	// glNormal3f(0.0, 0.0, -1.0);
	{ glVertex3f(Len, Width, z);
		//		glTexCoord2f(0, 1);
		glVertex3f(Len, -Width, z);
		//		glTexCoord2f(0, 0);
		glVertex3f(-Len / 8, 0, z);
		//		glTexCoord2f(1, 0);
		glVertex3f(-Len / 8, Width / 2, z); }
	glTexCoord2f(-1, 0);
	glVertex3f(Wid / 2, -Len / 12, z);
	glTexCoord2f(0, -1);
	glVertex3f(0, 0.9 * Len, z);
	glTexCoord2f(1, 0);
	glVertex3f(-Wid / 2, -Len / 12, z);
	glTexCoord2f(0, 1);
	glVertex3f(0, -Len / 6, z);

	glEnd;
end;

procedure DrawTick(const Angle: TFlo; Wid: TFlo; C: TRGBA);
begin
	glPushMatrix;
	glRotated(Angle, 0, 0, 1);
	glTranslatef(-7, 0, 0);
	glColor3ubv(PU1(@C));
	DrawArrow(Wid, 0.5, 0);
	glPopMatrix;
end;

procedure DrawArrowWithShadow(const Angle: TFlo; const Len, Wid: TFlo; const z: TFlo; C: TRGBA);
var
	C2: TRGBA;
begin
	glPushMatrix;
	glRotated(Angle, 0, 0, 1);
	C2.L := DarkerColor(C.L);
	glColor3ubv(PU1(@C2));
	DrawArrow(Len, Wid, z);
	glPopMatrix;

	glPushMatrix;
	glColor3ubv(PU1(@C));
	glTranslatef(0.15, -0.15, -0.05);
	glRotated(Angle, 0, 0, 1);
	DrawArrow(Len, Wid, z);
	glPopMatrix;
end;

{ TClockSaver }

constructor TClockSaver.Create;
begin
	inherited;

end;

destructor TClockSaver.Destroy;
begin

	inherited;
end;

procedure TClockSaver.Draw;
var
	SystemTime: TSystemTime;
	C: TRGBA;
	i: SG;
	T: SG;
begin
	inherited;
	Mode2D := True;
	glClear(GL_COLOR_BUFFER_BIT);
	glEnable(GL_COLOR_MATERIAL);
	glEnable(GL_LIGHT0);
	{ glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, @glfMaterialColor[0]);
		glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, @glfSilverColor[0]); }

	C.L := clWhite;
	for i := 0 to 59 do
	begin
		if i mod 5 = 0 then
			DrawTick(-360 / 60 * i, 0.2, C)
		else
			DrawTick(-360 / 60 * i, 0.05, C);
	end;

	GetLocalTime(SystemTime);
	GetGTime;
	T := (GTime div 32);

	// Hour
	C.L := SpectrumColor(T mod (MaxSpectrum + 1));
	DrawArrowWithShadow(-6 / 12 * SG(60 * SystemTime.wHour + SystemTime.wMinute), 6, 1, 0.1, C);

	// Minute
	C.L := SpectrumColor((T + (MaxSpectrum + 1) div 3) mod (MaxSpectrum + 1));
	DrawArrowWithShadow(-6 * SG(SystemTime.wMinute), 8, 0.75, 0.25, C);

	// Second
	C.L := SpectrumColor((T + 2 * (MaxSpectrum + 1) div 3) mod (MaxSpectrum + 1));
	DrawArrowWithShadow(-6 * SG(SystemTime.wSecond), 9, 0.5, 0.4, C);
end;

procedure TClockSaver.Step;
begin
	inherited;

end;

end.
