// * File:     MultiSaver\uBallSaver.pas
// * Created:  2001-06-01
// * Modified: 2010-12-29
// * Version:  1.1.47.72
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uBallSaver;

interface

uses uTypes, uSaver;

const
	MaxBallDirections = 2;
type
	TBallSaver = class(TSaver)
	private
		Ball: array[0..MaxBallDirections] of TFlo;
		BallD: array[0..MaxBallDirections] of TFlo;
		BallColor: SG;
	public
		constructor Create; override;
		destructor Destroy; override;
		procedure Initialize; override;
		procedure Draw; override;
		procedure SetCamera; override;
		procedure Step; override;
	end;

implementation

uses
	OpenGL12, Graphics,
	uMath, uColor;

const
	BallSpeed = 1;
	BallRadius = 0.7;

{ TBallSaver }

constructor TBallSaver.Create;
begin
	inherited;
	Mode2D := False;
end;

destructor TBallSaver.Destroy;
begin

	inherited;
end;

procedure TBallSaver.Draw;
var
	Obj: PGLUquadricObj;
	C: TRGBA;
	Len: TFlo;
	L: SG;
begin
	inherited;
	glEnable(GL_COLOR_MATERIAL);
	C.L := MixColors(clSilver, SpectrumColor(BallColor));
	C.L := SpectrumColor(BallColor);

{	LightPos[0] := UserX;
	LightPos[1] := UserY;
	LightPos[2] := UserZ;}

	glEnable(GL_LIGHT0);
	LightPos[0] := C.R / 256;
	LightPos[1] := C.G / 256;
	LightPos[2] := C.B / 256;
	glLightfv(GL_LIGHT0, GL_AMBIENT, @LightPos[0]);
	LightPos[0] := C.R / 256;
	LightPos[1] := C.G / 256;
	LightPos[2] := C.B / 256;
	glLightfv(GL_LIGHT0, GL_DIFFUSE, @LightPos[0]);
	glLightfv(GL_LIGHT0, GL_SPECULAR, @glfBlackColor[0]);
	LightPos[0] := Ball[0];
	LightPos[1] := Ball[1];
	LightPos[2] := Ball[2];
	glLightfv(GL_LIGHT0, GL_POSITION, @LightPos[0]);
	glLightf(GL_LIGHT0, GL_SPOT_CUTOFF, 70);
	glLighti(GL_LIGHT0, GL_SPOT_EXPONENT, 4);
	glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION, 1.0);
	glLightf(GL_LIGHT0, GL_LINEAR_ATTENUATION, 0.0);
	glLightf(GL_LIGHT0, GL_QUADRATIC_ATTENUATION, 0.0);
{	glfDirect[0] := Sin(AngleXZ);
	glfDirect[1] := AngleY;
	glfDirect[2] := -Cos(AngleXZ);}
	glfDirect[0] := BallD[0];
	glfDirect[1] := BallD[1];
	glfDirect[2] := BallD[2];
	glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION, @glfDirect[0]);

	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, @glfBlackColor[0]);
	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, @glfSilverColor[0]);
	glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, @glfSilverColor[0]);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, @glfBlackColor[0]);
	glMateriali(GL_FRONT_AND_BACK, GL_SHININESS, 1);

	glLoadIdentity;
	glScalef(10, 10, 10);
	glColor3ub(128, 128, 128);
	glFrontFace(GL_CW);
	glBegin(GL_QUADS);
		glNormal3f(0.0, 0.0, -1.0);
		glVertex3f(1.0, 1.0, 1.0);
		glVertex3f(-1.0, 1.0, 1.0);
		glVertex3f(-1.0, -1.0, 1.0);
		glVertex3f(1.0, -1.0, 1.0);
	glEnd;

	glBegin(GL_QUADS);
		glNormal3f(0.0, 0.0, 1.0);
		glVertex3f(1.0, 1.0, -1.0);
		glVertex3f(1.0, -1.0, -1.0);
		glVertex3f(-1.0, -1.0, -1.0);
		glVertex3f(-1.0, 1.0, -1.0);
	glEnd;

	glBegin(GL_QUADS);
		glNormal3f(1.0, 0.0, 0.0);
		glVertex3f(-1.0, 1.0, 1.0);
		glVertex3f(-1.0, 1.0, -1.0);
		glVertex3f(-1.0, -1.0, -1.0);
		glVertex3f(-1.0, -1.0, 1.0);
	glEnd;

	glBegin(GL_QUADS);
		glNormal3f(-1.0, 0.0, 0.0);
		glVertex3f(1.0, 1.0, 1.0);
		glVertex3f(1.0, -1.0, 1.0);
		glVertex3f(1.0, -1.0, -1.0);
		glVertex3f(1.0, 1.0, -1.0);
	glEnd;

	glBegin(GL_QUADS);
		glNormal3f(0.0, -1.0, 0.0);
		glVertex3f(-1.0, 1.0, -1.0);
		glVertex3f(-1.0, 1.0, 1.0);
		glVertex3f(1.0, 1.0, 1.0);
		glVertex3f(1.0, 1.0, -1.0);
	glEnd;

	glBegin(GL_QUADS);
		glNormal3f(0.0, 1.0, 0.0);
		glVertex3f(-1.0, -1.0, -1.0);
		glVertex3f(1.0, -1.0, -1.0);
		glVertex3f(1.0, -1.0, 1.0);
		glVertex3f(-1.0, -1.0, 1.0);
	glEnd;
	glFrontFace(GL_CCW);

	glLoadIdentity;
	glTranslatef(Ball[0], Ball[1], Ball[2]);

	glColor3ubv(@TRGBA(C).R);
	Obj := gluNewQuadric;
	gluQuadricDrawStyle(Obj, GLU_FILL);
	gluQuadricTexture(Obj, GL_FALSE);
	gluQuadricNormals(Obj, GLU_SMOOTH);
	Len := UserLen(Ball[0], Ball[1], Ball[2]);
	if Abs(Len) < 0.1 then
		L := 64
	else
		L := Round(640 / Len);
	if L < 4 then L := 4;
	if L > 64 then L := 64;
	gluSphere(Obj, BallRadius, L, L);
	gluDeleteQuadric(Obj);
end;

procedure TBallSaver.Initialize;
var
	i: SG;
begin
	inherited;

	BallColor := 0;
	for i := 0 to MaxBallDirections do
		Ball[i] := 0;
	for i := 0 to MaxBallDirections do
		BallD[i] := Random2(10);
end;

procedure TBallSaver.SetCamera;
begin
	inherited;
	UserX := 0;
	UserY := 0;
	UserZ := 0;
	LookTo(Ball[0], Ball[1], Ball[2]);
end;

procedure TBallSaver.Step;
var
	i: SG;
begin
	inherited;
	for i := 0 to 2 do
	begin
		Ball[i] := Ball[i] + BallSpeed * BallD[i] * ElapsedTime / PerformanceFrequency;
		BallD[i] := BallD[i] + Random2(10) / 50;

		if Ball[i] - BallRadius < -10 then
		begin
			Ball[i] := -10 + BallRadius;
			BallD[i] := -BallD[i];
		end
		else if Ball[i] + BallRadius > 10 then
		begin
			Ball[i] := 10 - BallRadius;
			BallD[i] := -BallD[i];
		end;
	end;
	if BallColor > MaxSpectrum then BallColor := 0 else Inc(BallColor, 4);
end;

end.
